<?php
/**
 * The Classic template to display the content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage TRANSLOGIC
 * @since TRANSLOGIC 1.0
 */

$translogic_blog_style = explode('_', translogic_get_theme_option('blog_style'));
$translogic_columns = empty($translogic_blog_style[1]) ? 1 : max(1, $translogic_blog_style[1]);
$translogic_expanded = !translogic_sidebar_present() && translogic_is_on(translogic_get_theme_option('expand_content'));
$translogic_post_format = get_post_format();
$translogic_post_format = empty($translogic_post_format) ? 'standard' : str_replace('post-format-', '', $translogic_post_format);
$translogic_animation = translogic_get_theme_option('blog_animation');

?><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_chess post_layout_chess_'.esc_attr($translogic_columns).' post_format_'.esc_attr($translogic_post_format) ); ?>
	<?php echo (!translogic_is_off($translogic_animation) ? ' data-animation="'.esc_attr(translogic_get_animation_classes($translogic_animation)).'"' : ''); ?>
	>

	<?php
	// Add anchor
	if ($translogic_columns == 1 && shortcode_exists('trx_sc_anchor')) {
		echo do_shortcode('[trx_sc_anchor id="post_'.esc_attr(get_the_ID()).'" title="'.the_title_attribute( array( 'echo' => false ) ).'"]');
	}

	// Featured image
	translogic_show_post_featured( array(
											'class' => $translogic_columns == 1 ? 'trx-stretch-height' : '',
											'show_no_image' => true,
											'thumb_bg' => true,
											'thumb_size' => translogic_get_thumb_size(
																	strpos(translogic_get_theme_option('body_style'), 'full')!==false
																		? ( $translogic_columns > 1 ? 'big' : 'original' )
																		: (	$translogic_columns > 1 ? 'med' : 'big')
																	)
											) 
										);

	?><div class="post_inner"><div class="post_inner_content"><?php 

		?><div class="post_header entry-header"><?php 
			do_action('translogic_action_before_post_title'); 

			// Post title
			the_title( sprintf( '<h3 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' );
			
			do_action('translogic_action_before_post_meta'); 

			// Post meta
			$translogic_post_meta = translogic_show_post_meta(array(
									'categories' => true,
									'date' => true,
									'edit' => $translogic_columns == 1,
									'seo' => false,
									'share' => false,
									'author' => false,
									'counters' => '',
									'echo' => false
									)
								);
			translogic_show_layout($translogic_post_meta);
		?></div><!-- .entry-header -->
	
		<div class="post_content entry-content">
			<div class="post_content_inner">
				<?php
				$translogic_show_learn_more = !in_array($translogic_post_format, array('link', 'aside', 'status', 'quote'));
				if (has_excerpt()) {
					the_excerpt();
				} else if (strpos(get_the_content('!--more'), '!--more')!==false) {
					the_content( '' );
				} else if (in_array($translogic_post_format, array('link', 'aside', 'status', 'quote'))) {
					the_content();
				} else if (substr(get_the_content(), 0, 1)!='[') {
					the_excerpt();
				}
				?>
			</div>
			<?php
			// Post meta
			if (in_array($translogic_post_format, array('link', 'aside', 'status', 'quote'))) {
				translogic_show_layout($translogic_post_meta);
			}
			// More button
			if ( $translogic_show_learn_more ) {
				?><p><a class="more-link" href="<?php the_permalink(); ?>"><?php esc_html_e('Read more', 'translogic'); ?></a></p><?php
			}
			?>
		</div><!-- .entry-content -->

	</div></div><!-- .post_inner -->

</article>