<?php
/**
 * The Classic template to display the content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage TRANSLOGIC
 * @since TRANSLOGIC 1.0
 */

$translogic_blog_style = explode('_', translogic_get_theme_option('blog_style'));
$translogic_columns = empty($translogic_blog_style[1]) ? 2 : max(2, $translogic_blog_style[1]);
$translogic_expanded = !translogic_sidebar_present() && translogic_is_on(translogic_get_theme_option('expand_content'));
$translogic_post_format = get_post_format();
$translogic_post_format = empty($translogic_post_format) ? 'standard' : str_replace('post-format-', '', $translogic_post_format);
$translogic_animation = translogic_get_theme_option('blog_animation');

?><div class="column-1_<?php echo esc_attr($translogic_columns); ?>"><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_classic post_layout_classic_'.esc_attr($translogic_columns).' post_format_'.esc_attr($translogic_post_format) ); ?>
	<?php echo (!translogic_is_off($translogic_animation) ? ' data-animation="'.esc_attr(translogic_get_animation_classes($translogic_animation)).'"' : ''); ?>
	>

	<?php

	// Featured image
	translogic_show_post_featured( array( 'thumb_size' => translogic_get_thumb_size(
													strpos(translogic_get_theme_option('body_style'), 'full')!==false 
														? ( $translogic_columns > 2 ? 'big' : 'big' )
														: (	$translogic_columns > 2
															? ($translogic_expanded ? 'big' : 'big')
															: ($translogic_expanded ? 'big' : 'big')
															)
														)
										) );

	if ( !in_array($translogic_post_format, array('link', 'aside', 'status', 'quote')) ) {
		?>
		<div class="post_header entry-header">
			<?php 
			do_action('translogic_action_before_post_title'); 

			// Post title
			the_title( sprintf( '<h4 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h4>' );

			do_action('translogic_action_before_post_meta'); 

			// Post meta
			translogic_show_post_meta(array(
				'categories' => true,
				'date' => true,
				'edit' => false,
				'seo' => false,
				'share' => false,
				'counters' => '',
				)
			);
			?>
		</div><!-- .entry-header -->
		<?php
	}		
	?>

	<div class="post_content entry-content">
		<div class="post_content_inner">
			<?php
			$translogic_show_learn_more = false; 
			if (has_excerpt()) {
				the_excerpt();
			} else if (strpos(get_the_content('!--more'), '!--more')!==false) {
				the_content( '' );
			} else if (in_array($translogic_post_format, array('link', 'aside', 'status', 'quote'))) {
				the_content();
			} else if (substr(get_the_content(), 0, 1)!='[') {
				the_excerpt();
			}
			?>
		</div>
		<?php
		// Post meta
		if (in_array($translogic_post_format, array('link', 'aside', 'status', 'quote'))) {
			translogic_show_post_meta(array(
				'share' => false,
				'counters' => 'comments'
				)
			);
		}
		// More button
		if ( $translogic_show_learn_more ) {
			?><p><a class="more-link" href="<?php the_permalink(); ?>"><?php esc_html_e('Read more', 'translogic'); ?></a></p><?php
		}
		?>
	</div><!-- .entry-content -->

</article></div>