<?php
/**
 * The template for homepage posts with "Excerpt" style
 *
 * @package WordPress
 * @subpackage TRANSLOGIC
 * @since TRANSLOGIC 1.0
 */

translogic_storage_set('blog_archive', true);

get_header(); 

if (have_posts()) {

	echo get_query_var('blog_archive_start');

	?><div class="posts_container"><?php
	
	$translogic_stickies = is_home() ? get_option( 'sticky_posts' ) : false;
	$translogic_sticky_out = is_array($translogic_stickies) && count($translogic_stickies) > 0 && get_query_var( 'paged' ) < 1;
	if ($translogic_sticky_out) {
		?><div class="sticky_wrap columns_wrap"><?php	
	}
	while ( have_posts() ) { the_post(); 
		if ($translogic_sticky_out && !is_sticky()) {
			$translogic_sticky_out = false;
			?></div><?php
		}
		get_template_part( 'content', $translogic_sticky_out && is_sticky() ? 'sticky' : 'excerpt' );
	}
	if ($translogic_sticky_out) {
		$translogic_sticky_out = false;
		?></div><?php
	}
	
	?></div><?php

	translogic_show_pagination();

	echo get_query_var('blog_archive_end');

} else {

	if ( is_search() )
		get_template_part( 'content', 'none-search' );
	else
		get_template_part( 'content', 'none-archive' );

}

get_footer();
?>