<?php
/**
 * The template for homepage posts with "Portfolio" style
 *
 * @package WordPress
 * @subpackage TRANSLOGIC
 * @since TRANSLOGIC 1.0
 */

translogic_storage_set('blog_archive', true);

// Load scripts for both 'Gallery' and 'Portfolio' layouts!
wp_enqueue_script( 'classie', translogic_get_file_url('js/theme.gallery/classie.min.js'), array(), null, true );
wp_enqueue_script( 'imagesloaded', translogic_get_file_url('js/theme.gallery/imagesloaded.min.js'), array(), null, true );
wp_enqueue_script( 'masonry', translogic_get_file_url('js/theme.gallery/masonry.min.js'), array(), null, true );
wp_enqueue_script( 'translogic-gallery-script', translogic_get_file_url('js/theme.gallery/theme.gallery.js'), array(), null, true );

get_header(); 

if (have_posts()) {

	echo get_query_var('blog_archive_start');

	$translogic_stickies = is_home() ? get_option( 'sticky_posts' ) : false;
	$translogic_sticky_out = is_array($translogic_stickies) && count($translogic_stickies) > 0 && get_query_var( 'paged' ) < 1;
	
	// Show filters
	$translogic_cat = translogic_get_theme_option('parent_cat');
	$translogic_post_type = translogic_get_theme_option('post_type');
	$translogic_taxonomy = translogic_get_post_type_taxonomy($translogic_post_type);
	$translogic_show_filters = translogic_get_theme_option('show_filters');
	$translogic_tabs = array();
	if (!translogic_is_off($translogic_show_filters)) {
		$translogic_args = array(
			'type'			=> $translogic_post_type,
			'child_of'		=> $translogic_cat,
			'orderby'		=> 'name',
			'order'			=> 'ASC',
			'hide_empty'	=> 1,
			'hierarchical'	=> 0,
			'exclude'		=> '',
			'include'		=> '',
			'number'		=> '',
			'taxonomy'		=> $translogic_taxonomy,
			'pad_counts'	=> false
		);
		$translogic_portfolio_list = get_terms($translogic_args);
		if (is_array($translogic_portfolio_list) && count($translogic_portfolio_list) > 0) {
			$translogic_tabs[$translogic_cat] = esc_html__('All', 'translogic');
			foreach ($translogic_portfolio_list as $translogic_term) {
				if (isset($translogic_term->term_id)) $translogic_tabs[$translogic_term->term_id] = $translogic_term->name;
			}
		}
	}
	if (count($translogic_tabs) > 0) {
		$translogic_portfolio_filters_ajax = true;
		$translogic_portfolio_filters_active = $translogic_cat;
		$translogic_portfolio_filters_id = 'portfolio_filters';
		if (!is_customize_preview())
			wp_enqueue_script('jquery-ui-tabs', false, array('jquery', 'jquery-ui-core'), null, true);
		?>
		<div class="portfolio_filters translogic_tabs translogic_tabs_ajax">
			<ul class="portfolio_titles translogic_tabs_titles">
				<?php
				foreach ($translogic_tabs as $translogic_id=>$translogic_title) {
					?><li><a href="<?php echo esc_url(translogic_get_hash_link(sprintf('#%s_%s_content', $translogic_portfolio_filters_id, $translogic_id))); ?>" data-tab="<?php echo esc_attr($translogic_id); ?>"><?php echo esc_html($translogic_title); ?></a></li><?php
				}
				?>
			</ul>
			<?php
			$translogic_ppp = translogic_get_theme_option('posts_per_page');
			if (translogic_is_inherit($translogic_ppp)) $translogic_ppp = '';
			foreach ($translogic_tabs as $translogic_id=>$translogic_title) {
				$translogic_portfolio_need_content = $translogic_id==$translogic_portfolio_filters_active || !$translogic_portfolio_filters_ajax;
				?>
				<div id="<?php echo esc_attr(sprintf('%s_%s_content', $translogic_portfolio_filters_id, $translogic_id)); ?>"
					class="portfolio_content translogic_tabs_content"
					data-blog-template="<?php echo esc_attr(translogic_storage_get('blog_template')); ?>"
					data-blog-style="<?php echo esc_attr(translogic_get_theme_option('blog_style')); ?>"
					data-posts-per-page="<?php echo esc_attr($translogic_ppp); ?>"
					data-post-type="<?php echo esc_attr($translogic_post_type); ?>"
					data-taxonomy="<?php echo esc_attr($translogic_taxonomy); ?>"
					data-cat="<?php echo esc_attr($translogic_id); ?>"
					data-parent-cat="<?php echo esc_attr($translogic_cat); ?>"
					data-need-content="<?php echo (false===$translogic_portfolio_need_content ? 'true' : 'false'); ?>"
				>
					<?php
					if ($translogic_portfolio_need_content) 
						translogic_show_portfolio_posts(array(
							'cat' => $translogic_id,
							'parent_cat' => $translogic_cat,
							'taxonomy' => $translogic_taxonomy,
							'post_type' => $translogic_post_type,
							'page' => 1,
							'sticky' => $translogic_sticky_out
							)
						);
					?>
				</div>
				<?php
			}
			?>
		</div>
		<?php
	} else {
		translogic_show_portfolio_posts(array(
			'cat' => $translogic_cat,
			'parent_cat' => $translogic_cat,
			'taxonomy' => $translogic_taxonomy,
			'post_type' => $translogic_post_type,
			'page' => 1,
			'sticky' => $translogic_sticky_out
			)
		);
	}

	echo get_query_var('blog_archive_end');

} else {

	if ( is_search() )
		get_template_part( 'content', 'none-search' );
	else
		get_template_part( 'content', 'none-archive' );

}

get_footer();
?>