<?php
/* Mail Chimp support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if (!function_exists('translogic_mailchimp_theme_setup9')) {
	add_action( 'after_setup_theme', 'translogic_mailchimp_theme_setup9', 9 );
	function translogic_mailchimp_theme_setup9() {
		if (translogic_exists_mailchimp()) {
			add_action( 'wp_enqueue_scripts',							'translogic_mailchimp_frontend_scripts', 1100 );
			add_filter( 'translogic_filter_merge_styles',					'translogic_mailchimp_merge_styles');
			add_filter( 'translogic_filter_get_css',						'translogic_mailchimp_get_css', 10, 3);
		}
		if (is_admin()) {
			add_filter( 'translogic_filter_tgmpa_required_plugins',		'translogic_mailchimp_tgmpa_required_plugins' );
		}
	}
}

// Check if plugin installed and activated
if ( !function_exists( 'translogic_exists_mailchimp' ) ) {
	function translogic_exists_mailchimp() {
		return function_exists('__mc4wp_load_plugin') || defined('MC4WP_VERSION');
	}
}

// Filter to add in the required plugins list
if ( !function_exists( 'translogic_mailchimp_tgmpa_required_plugins' ) ) {
	
	function translogic_mailchimp_tgmpa_required_plugins($list=array()) {
		if (in_array('mailchimp-for-wp', translogic_storage_get('required_plugins')))
			$list[] = array(
				'name' 		=> esc_html__('MailChimp for WP', 'translogic'),
				'slug' 		=> 'mailchimp-for-wp',
				'required' 	=> false
			);
		return $list;
	}
}



// Custom styles and scripts
//------------------------------------------------------------------------

// Enqueue custom styles
if ( !function_exists( 'translogic_mailchimp_frontend_scripts' ) ) {
	
	function translogic_mailchimp_frontend_scripts() {
		if (translogic_exists_mailchimp()) {
			if (translogic_is_on(translogic_get_theme_option('debug_mode')) && file_exists(translogic_get_file_dir('plugins/mailchimp-for-wp/mailchimp-for-wp.css')))
				wp_enqueue_style( 'translogic-mailchimp-for-wp',  translogic_get_file_url('plugins/mailchimp-for-wp/mailchimp-for-wp.css'), array(), null );
		}
	}
}
	
// Merge custom styles
if ( !function_exists( 'translogic_mailchimp_merge_styles' ) ) {
	
	function translogic_mailchimp_merge_styles($list) {
		$list[] = 'plugins/mailchimp-for-wp/mailchimp-for-wp.css';
		return $list;
	}
}

// Add css styles into global CSS stylesheet
if (!function_exists('translogic_mailchimp_get_css')) {
	
	function translogic_mailchimp_get_css($css, $colors, $fonts) {
		
		if (isset($css['fonts']) && $fonts) {
			$css['fonts'] .= <<<CSS

CSS;
		}
		
		if (isset($css['colors']) && $colors) {
			$css['colors'] .= <<<CSS

.mc4wp-form input[type="email"] {
	background-color: {$colors['alter_dark']};
	border-color: {$colors['alter_dark']};
	color: {$colors['bg_color']};
}
.mc4wp-form input[type="submit"].sc_button_hover_slide_left  {	
	background: linear-gradient(to right, {$colors['text_link']} 50%, {$colors['text_hover']} 50%) no-repeat scroll right bottom / 210% 100% {$colors['text_hover']} !important; 
	color: {$colors['inverse_text']};
}
.mc4wp-form input[type="submit"]:hover {
	background-position: left bottom !important;
}

CSS;
		}

		return $css;
	}
}
?>