<?php
/* TRX Socials support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if (!function_exists('translogic_trx_socials_theme_setup9')) {
	add_action( 'after_setup_theme', 'translogic_trx_socials_theme_setup9', 9 );
	function translogic_trx_socials_theme_setup9() {
		
		if (is_admin()) {
			add_filter( 'translogic_filter_tgmpa_required_plugins',	'translogic_trx_socials_tgmpa_required_plugins' );
		}
	}
}

// Filter to add in the required plugins list
if ( !function_exists( 'translogic_trx_socials_tgmpa_required_plugins' ) ) {
    function translogic_trx_socials_tgmpa_required_plugins($list=array()) {
		if (in_array('trx_socials', translogic_storage_get('required_plugins'))) {
            $path = translogic_get_file_dir('plugins/trx_socials/trx_socials.zip');
            $list[] = array(
				'name' 		=> esc_html__('TRX Socials', 'translogic'),
                'slug' 		=> 'trx_socials',
                'source'	=> !empty($path) ? $path : 'upload://trx_socials.zip',
                'version'   => '1.4.5',
                'required' 	=> false
            );
        }
        return $list;
    }
}

// Check if TRX Socials installed and activated
if ( !function_exists( 'translogic_exists_trx_socials' ) ) {
	function translogic_exists_trx_socials() {
        return function_exists( 'trx_socials_load_plugin_textdomain' );
	}
}
?>