<?php
/**
 * The Sidebar containing the main widget areas.
 *
 * @package WordPress
 * @subpackage TRANSLOGIC
 * @since TRANSLOGIC 1.0
 */

$translogic_sidebar_position = translogic_get_theme_option('sidebar_position');
if (translogic_sidebar_present()) {
	ob_start();
	$translogic_sidebar_name = translogic_get_theme_option('sidebar_widgets');
	translogic_storage_set('current_sidebar', 'sidebar');
	if ( is_active_sidebar( $translogic_sidebar_name ) ) {
		dynamic_sidebar( $translogic_sidebar_name );
	}
	$translogic_out = trim(ob_get_contents());
	ob_end_clean();
	if (trim(strip_tags($translogic_out)) != '') {
		?>
		<div class="sidebar <?php echo esc_attr($translogic_sidebar_position); ?> widget_area<?php if (!translogic_is_inherit(translogic_get_theme_option('sidebar_scheme'))) echo ' scheme_'.esc_attr(translogic_get_theme_option('sidebar_scheme')); ?>" role="complementary">
			<div class="sidebar_inner">
				<?php
				do_action( 'translogic_action_before_sidebar' );
				translogic_show_layout(preg_replace("/<\/aside>[\r\n\s]*<aside/", "</aside><aside", $translogic_out));
				do_action( 'translogic_action_after_sidebar' );
				?>
			</div><!-- /.sidebar_inner -->
		</div><!-- /.sidebar -->
		<?php
	}
}
?>