<?php
/**
 * The template to display the main menu
 *
 * @package WordPress
 * @subpackage TRANSLOGIC
 * @since TRANSLOGIC 1.0
 */
?>
<div class="top_panel_navi sc_layouts_row sc_layouts_row_type_normal sc_layouts_row_fixed
			scheme_<?php echo esc_attr(translogic_is_inherit(translogic_get_theme_option('menu_scheme')) 
												? (translogic_is_inherit(translogic_get_theme_option('header_scheme')) 
													? translogic_get_theme_option('color_scheme') 
													: translogic_get_theme_option('header_scheme')) 
												: translogic_get_theme_option('menu_scheme')); ?>">
	<div class="content_wrap">
		<div class="columns_wrap">
			<div class="sc_layouts_column sc_layouts_column_align_left sc_layouts_column_icons_position_left column-1_3">
				<?php
				// Logo
				?><div class="sc_layouts_item"><?php
					get_template_part( 'templates/header-logo' );
				?></div>
			</div><?php
			
			// Attention! Don't place any spaces between columns!
			?><div class="sc_layouts_column sc_layouts_column_align_right sc_layouts_column_icons_position_left column-2_3">
				<div class="sc_layouts_item">
					<?php
					// Main menu
					$translogic_menu_main = translogic_get_nav_menu(array('location' => 'menu_main', 'class' => 'sc_layouts_hide_on_mobile'));
					if (empty($translogic_menu_main)) $translogic_menu_main = translogic_get_nav_menu(array('class' => 'sc_layouts_hide_on_mobile'));
					translogic_show_layout($translogic_menu_main);
					// Mobile menu button
					?>
					<div class="sc_layouts_iconed_text sc_layouts_menu_mobile_button">
						<a class="sc_layouts_item_link sc_layouts_iconed_text_link" href="#">
							<span class="sc_layouts_item_icon sc_layouts_iconed_text_icon trx_addons_icon-menu"></span>
						</a>
					</div>
				</div><?php
			
				// Attention! Don't place any spaces between layouts items!
				?>
				<div class="sc_layouts_item">
					<?php
					// Display search field
					do_action('translogic_action_search', 'fullscreen', 'header_search', false);
					?>
				</div>			
			</div>
		</div><!-- /.sc_layouts_row -->
	</div><!-- /.content_wrap -->
</div><!-- /.top_panel_navi -->