<?php
/**
 * The template 'Style 2' to displaying related posts
 *
 * @package WordPress
 * @subpackage TRANSLOGIC
 * @since TRANSLOGIC 1.0
 */

// Thumb image
$translogic_thumb_image = has_post_thumbnail() 
			? wp_get_attachment_image_src(get_post_thumbnail_id(), translogic_get_thumb_size('medium')) 
			: ( (float) wp_get_theme()->get('Version') > 1.0
					? translogic_get_no_image_placeholder()
					: ''
				);
if (is_array($translogic_thumb_image)) $translogic_thumb_image = $translogic_thumb_image[0];
$translogic_link = get_permalink();
$translogic_hover = translogic_get_theme_option('image_hover');
?>
<div class="related_item related_item_style_2">
	<?php if (!empty($translogic_thumb_image)) { ?>
		<div class="post_featured<?php
					if (has_post_thumbnail() || translogic_get_no_image_placeholder() == true) echo ' hover_'.esc_attr($translogic_hover); 
					echo ' ' . esc_attr(translogic_add_inline_style('background-image:url('.esc_url($translogic_thumb_image).');'));
					?>">
			<?php
			if (has_post_thumbnail() || translogic_get_no_image_placeholder() == true) {
				?><div class="mask"></div><?php
				translogic_hovers_add_icons($translogic_hover);
			}
			?>
		</div>
	<?php } ?>
	<div class="post_header entry-header">
	<div class="post_categories"><?php echo translogic_get_post_categories(); ?></div>
		<?php
		if ( in_array(get_post_type(), array( 'post', 'attachment' ) ) ) {
			?><span class="post_date"><a href="<?php echo esc_url($translogic_link); ?>"><?php echo translogic_get_date(); ?></a></span><?php
		}
		?>
		<h6 class="post_title entry-title"><a href="<?php echo esc_url($translogic_link); ?>"><?php echo the_title(); ?></a></h6>
	</div>
</div>
