<?php
/**
 * Default Theme Options and Internal Theme Settings
 *
 * @package WordPress
 * @subpackage TRANSLOGIC
 * @since TRANSLOGIC 1.0
 */

// -----------------------------------------------------------------
// -- ONLY FOR PROGRAMMERS, NOT FOR CUSTOMER
// -- Internal theme settings
// -----------------------------------------------------------------
translogic_storage_set('settings', array(
	
	'custom_sidebars'			=> 3,							// How many custom sidebars will be registered (in addition to theme preset sidebars): 0 - 10

	'ajax_views_counter'		=> true,						// Use AJAX for increment posts counter (if cache plugins used) 
																// or increment posts counter then loading page (without cache plugin)
	'disable_jquery_ui'			=> false,						// Prevent loading custom jQuery UI libraries in the third-party plugins

	'max_load_fonts'			=> 3,							// Max fonts number to load from Google fonts or from uploaded fonts

	'use_mediaelements'			=> true,						// Load script "Media Elements" to play video and audio

	'max_excerpt_length'		=> 60,							// Max words number for the excerpt in the blog style 'Excerpt'.
																// For style 'Classic' - get half from this value
	'message_maxlength'			=> 1000							// Max length of the message from contact form
	
));



// -----------------------------------------------------------------
// -- Theme fonts (Google and/or custom fonts)
// -----------------------------------------------------------------

// Fonts to load when theme start
// It can be Google fonts or uploaded fonts, placed in the folder /css/font-face/font-name inside the theme folder
// Attention! Font's folder must have name equal to the font's name, with spaces replaced on the dash '-'

translogic_storage_set('load_fonts', array(
	// Google font
	array(
		'name'	 => 'Open Sans',
		'family' => 'sans-serif',
		'styles' => '300,300italic,400,400italic,700,700italic'		// Parameter 'style' used only for the Google fonts
		),
	// Font-face packed with theme
	array(
		'name'   => 'Montserrat',
		'family' => 'sans-serif',
		'styles' => '400,700'		// Parameter 'style' used only for the Google fonts
		),
	// Font-face packed with theme
	array(
		'name'   => 'Lora',
		'family' => 'serif',
		'styles' => '400,400i,700,700i'		// Parameter 'style' used only for the Google fonts
		),
	// Font-face packed with theme
	array(
		'name'   => 'Raleway',
		'family' => 'sans-serif',
		'styles' => '100,100i,200,200i,300,300i,400,400i,500,500i,600,600i,700,700i,800,800i,900,900i'		// Parameter 'style' used only for the Google fonts
		)
));

// Characters subset for the Google fonts. Available values are: latin,latin-ext,cyrillic,cyrillic-ext,greek,greek-ext,vietnamese
translogic_storage_set('load_fonts_subset', 'latin,latin-ext');

// Settings of the main tags
translogic_storage_set('theme_fonts', array(
	'p' => array(
		'title'				=> esc_html__('Main text', 'translogic'),
		'description'		=> esc_html__('Font settings of the main text of the site', 'translogic'),
		'font-family'		=> '"Open Sans", sans-serif',
		'font-size' 		=> '1rem',
		'font-weight'		=> '400',
		'font-style'		=> 'normal',
		'line-height'		=> '1.866em',
		'text-decoration'	=> 'none',
		'text-transform'	=> 'none',
		'letter-spacing'	=> '0',
		'margin-top'		=> '0em',
		'margin-bottom'		=> '1.9em'
		),
	'h1' => array(
		'title'				=> esc_html__('Heading 1', 'translogic'),
		'font-family'		=> '"Montserrat", sans-serif',
		'font-size' 		=> '2.67rem',
		'font-weight'		=> '600',
		'font-style'		=> 'normal',
		'line-height'		=> '1.15em',
		'text-decoration'	=> 'none',
		'text-transform'	=> 'none',
		'letter-spacing'	=> '-0.02em',
		'margin-top'		=> '0em',
		'margin-bottom'		=> '0.5833em'
		),
	'h2' => array(
		'title'				=> esc_html__('Heading 2', 'translogic'),
		'font-family'		=> '"Montserrat", sans-serif',
		'font-size' 		=> '1.867rem',
		'font-weight'		=> '600',
		'font-style'		=> 'normal',
		'line-height'		=> '1.321em',
		'text-decoration'	=> 'none',
		'text-transform'	=> 'none',
		'letter-spacing'	=> '-0.02em',
		'margin-top'		=> '0em',
		'margin-bottom'		=> '1.2em'
		),
	'h3' => array(
		'title'				=> esc_html__('Heading 3', 'translogic'),
		'font-family'		=> '"Montserrat", sans-serif',
		'font-size' 		=> '1.467em',
		'font-weight'		=> '600',
		'font-style'		=> 'normal',
		'line-height'		=> '1.409em',
		'text-decoration'	=> 'none',
		'text-transform'	=> 'none',
		'letter-spacing'	=> '-0.02em',
		'margin-top'		=> '0em',
		'margin-bottom'		=> '0.85em'
		),
	'h4' => array(
		'title'				=> esc_html__('Heading 4', 'translogic'),
		'font-family'		=> '"Montserrat", sans-serif',
		'font-size' 		=> '1.2em',
		'font-weight'		=> '400',
		'font-style'		=> 'normal',
		'line-height'		=> '1.47em',
		'text-decoration'	=> 'none',
		'text-transform'	=> 'none',
		'letter-spacing'	=> '-0.02em',
		'margin-top'		=> '0em',
		'margin-bottom'		=> '1.2em'
		),
	'h5' => array(
		'title'				=> esc_html__('Heading 5', 'translogic'),
		'font-family'		=> '"Montserrat", sans-serif',
		'font-size' 		=> '1.067em',
		'font-weight'		=> '500',
		'font-style'		=> 'normal',
		'line-height'		=> '1.625em',
		'text-decoration'	=> 'none',
		'text-transform'	=> 'none',
		'letter-spacing'	=> '-0.02em',
		'margin-top'		=> '0em',
		'margin-bottom'		=> '1.25em'
		),
	'h6' => array(
		'title'				=> esc_html__('Heading 6', 'translogic'),
		'font-family'		=> '"Montserrat", sans-serif',
		'font-size' 		=> '1em',
		'font-weight'		=> '400',
		'font-style'		=> 'normal',
		'line-height'		=> '1.6em',
		'text-decoration'	=> 'none',
		'text-transform'	=> 'none',
		'letter-spacing'	=> '-0.02em',
		'margin-top'		=> '0em',
		'margin-bottom'		=> '0.85em'
		),
	'logo' => array(
		'title'				=> esc_html__('Logo text', 'translogic'),
		'description'		=> esc_html__('Font settings of the text case of the logo', 'translogic'),
		'font-family'		=> '"Montserrat", sans-serif',
		'font-size' 		=> '1.8em',
		'font-weight'		=> '400',
		'font-style'		=> 'normal',
		'line-height'		=> '1.25em',
		'text-decoration'	=> 'none',
		'text-transform'	=> 'uppercase',
		'letter-spacing'	=> '1px'
		),
	'button' => array(
		'title'				=> esc_html__('Buttons', 'translogic'),
		'font-family'		=> '"Montserrat", sans-serif',
		'font-size' 		=> '12px',
		'font-weight'		=> '400',
		'font-style'		=> 'normal',
		'line-height'		=> '1.5em',
		'text-decoration'	=> 'none',
		'text-transform'	=> 'none',
		'letter-spacing'	=> '0.02em'
		),
	'input' => array(
		'title'				=> esc_html__('Input fields', 'translogic'),
		'description'		=> esc_html__('Font settings of the input fields, dropdowns and textareas', 'translogic'),
		'font-family'		=> '"Open Sans", sans-serif',
		'font-size' 		=> '12px',
		'font-weight'		=> '400',
		'font-style'		=> 'normal',
		'line-height'		=> '1.2em',
		'text-decoration'	=> 'none',
		'text-transform'	=> 'none',
		'letter-spacing'	=> ''
		),
	'info' => array(
		'title'				=> esc_html__('Post meta', 'translogic'),
		'description'		=> esc_html__('Font settings of the post meta: date, counters, share, etc.', 'translogic'),
		'font-family'		=> '"Lora", serif',
		'font-size' 		=> '1em',
		'font-weight'		=> '400',
		'font-style'		=> 'normal',
		'line-height'		=> '1.5em',
		'text-decoration'	=> 'none',
		'text-transform'	=> 'none',
		'letter-spacing'	=> '',
		'margin-top'		=> '0.4em',
		'margin-bottom'		=> ''
		),
	'menu' => array(
		'title'				=> esc_html__('Main menu', 'translogic'),
		'description'		=> esc_html__('Font settings of the main menu items', 'translogic'),
		'font-family'		=> '"Montserrat", sans-serif',
		'font-size' 		=> '1em',
		'font-weight'		=> '300',
		'font-style'		=> 'normal',
		'line-height'		=> '1.5em',
		'text-decoration'	=> 'none',
		'text-transform'	=> 'none',
		'letter-spacing'	=> '-0.04em'
		),
	'submenu' => array(
		'title'				=> esc_html__('Dropdown menu', 'translogic'),
		'description'		=> esc_html__('Font settings of the dropdown menu items', 'translogic'),
		'font-family'		=> '"Varela", sans-serif',
		'font-size' 		=> '13px',
		'font-weight'		=> '300',
		'font-style'		=> 'normal',
		'line-height'		=> '1.5em',
		'text-decoration'	=> 'none',
		'text-transform'	=> 'none',
		'letter-spacing'	=> '0px'
		)
));


// -----------------------------------------------------------------
// -- Theme colors for customizer
// -- Attention! Inner scheme must be last in the array below
// -----------------------------------------------------------------
translogic_storage_set('schemes', array(

	// Color scheme: 'default'
	'default' => array(
		'title'	 => esc_html__('Default', 'translogic'),
		'colors' => array(
			
			// Whole block border and background
			'bg_color'				=> '#ffffff',
			'bd_color'				=> '#e5e5e5',

			// Text and links colors
			'text'					=> '#6e6e6e',
			'text_light'			=> '#afafaf',
			'text_dark'				=> '#1e2a34',
			'text_link'				=> '#df3629',
			'text_hover'			=> '#3d65b8',

			// Alternative blocks (submenu, buttons, tabs, etc.)
			'alter_bg_color'		=> '#f7f6f2',
			'alter_bg_hover'		=> '#f7f6f2',
			'alter_bd_color'		=> '#f0efeb',
			'alter_bd_hover'		=> '#f0efeb',
			'alter_text'			=> '#6e6e6e',
			'alter_light'			=> '#af9e8b', 
			'alter_dark'			=> '#1e2a34',
			'alter_link'			=> '#df3629',
			'alter_hover'			=> '#3d65b8',

			// Input fields (form's fields and textarea)
			'input_bg_color'		=> '#f7f6f2',
			'input_bg_hover'		=> '#f7f6f2',
			'input_bd_color'		=> '#f7f6f2',
			'input_bd_hover'		=> '#e6e5e1',
			'input_text'			=> '#8f8d87',
			'input_light'			=> '#af9e8b',
			'input_dark'			=> '#8f8d87',
			
			// Inverse blocks (text and links on accented bg)
			'inverse_text'			=> '#ffffff',
			'inverse_light'			=> '#ffffff',
			'inverse_dark'			=> '#ffffff',
			'inverse_link'			=> '#df3629',
			'inverse_hover'			=> '#3d65b8',

			// Additional accented colors (if used in the current theme)
			'accent2'				=> '#1f2e39'
		
		)
	),

	// Color scheme: 'dark'
	'dark' => array(
		'title'  => esc_html__('Dark', 'translogic'),
		'colors' => array(
			
			// Whole block border and background
			'bg_color'				=> '#1f2c36',
			'bd_color'				=> '#63707a',

			// Text and links colors
			'text'					=> '#8f9ca6',
			'text_light'			=> '#a2aeb6',
			'text_dark'				=> '#ffffff',
			'text_link'				=> '#df3629',
			'text_hover'			=> '#3d65b8',

			// Alternative blocks (submenu, buttons, tabs, etc.)
			'alter_bg_color'		=> '#1e2a34',
			'alter_bg_hover'		=> '#1c2933',
			'alter_bd_color'		=> '#2d3c47',
			'alter_bd_hover'		=> '#2d3c47',
			'alter_text'			=> '#c0bfcb',
			'alter_light'			=> '#dcd7d1',
			'alter_dark'			=> '#ffffff',
			'alter_link'			=> '#df3629',
			'alter_hover'			=> '#3d65b8',

			// Input fields (form's fields and textarea)
			'input_bg_color'		=> '#f7f6f2',
			'input_bg_hover'		=> '#f7f6f2',
			'input_bd_color'		=> '#f7f6f2',
			'input_bd_hover'		=> '#e6e5e1',
			'input_text'			=> '#8f8d87',
			'input_light'			=> '#8f8d87',
			'input_dark'			=> '#8f8d87',
			
			// Inverse blocks (text and links on accented bg)
			'inverse_text'			=> '#ffffff',
			'inverse_light'			=> '#ffffff',
			'inverse_dark'			=> '#ffffff',
			'inverse_link'			=> '#df3629',
			'inverse_hover'			=> '#3d65b8',
		
			// Additional accented colors (if used in the current theme)
			
			'accent2'				=> '#1f2e39'

		)
	)

));



// -----------------------------------------------------------------
// -- Theme options for customizer
// -----------------------------------------------------------------
if (!function_exists('translogic_options_create')) {

	function translogic_options_create() {

		translogic_storage_set('options', array(
		
			// Section 'Title & Tagline' - add theme options in the standard WP section
			'title_tagline' => array(
				"title" => esc_html__('Title, Tagline & Site icon', 'translogic'),
				"desc" => wp_kses_data( __('Specify site title and tagline (if need) and upload the site icon', 'translogic') ),
				"type" => "section"
				),
		
		
			// Section 'Header' - add theme options in the standard WP section
			'header_image' => array(
				"title" => esc_html__('Header', 'translogic'),
				"desc" => wp_kses_data( __('Select or upload logo images, select header type and widgets set for the header', 'translogic') ),
				"type" => "section"
				),
			'header_image_override' => array(
				"title" => esc_html__('Header image override', 'translogic'),
				"desc" => wp_kses_data( __("Allow override the header image with the page's/post's/product's/etc. featured image", 'translogic') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services',
					'section' => esc_html__('Header', 'translogic')
				),
				"std" => 0,
				"type" => "checkbox"
				),
			'header_video' => array(
				"title" => esc_html__('Header video', 'translogic'),
				"desc" => wp_kses_data( __("Select video to use it as background for the header", 'translogic') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services',
					'section' => esc_html__('Header', 'translogic')
				),
				"std" => '',
				"type" => "video"
				),
			'header_fullheight' => array(
				"title" => esc_html__('Fullheight Header', 'translogic'),
				"desc" => wp_kses_data( __("Enlarge header area to fill whole screen. Used only if header have a background image", 'translogic') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services',
					'section' => esc_html__('Header', 'translogic')
				),
				"std" => 0,
				"type" => "checkbox"
				),
			'header_style' => array(
				"title" => esc_html__('Header style', 'translogic'),
				"desc" => wp_kses_data( __('Select style to display the site header', 'translogic') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services',
					'section' => esc_html__('Header', 'translogic')
				),
				"std" => 'header-default',
				"options" => apply_filters('translogic_filter_list_header_styles', array(
					'header-default' => esc_html__('Default Header',	'translogic')
				)),
				"type" => "select"
				),
			'header_position' => array(
				"title" => esc_html__('Header position', 'translogic'),
				"desc" => wp_kses_data( __('Select position to display the site header', 'translogic') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services',
					'section' => esc_html__('Header', 'translogic')
				),
				"std" => 'default',
				"options" => array(
					'default' => esc_html__('Default','translogic'),
					'over' => esc_html__('Over',	'translogic'),
					'under' => esc_html__('Under',	'translogic')
				),
				"type" => "select"
				),
			'header_scheme' => array(
				"title" => esc_html__('Header Color Scheme', 'translogic'),
				"desc" => wp_kses_data( __('Select color scheme to decorate header area', 'translogic') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services',
					'section' => esc_html__('Header', 'translogic')
				),
				"std" => 'inherit',
				"options" => translogic_get_list_schemes(true),
				"refresh" => false,
				"type" => "select"
				),
			'menu_style' => array(
				"title" => esc_html__('Menu position', 'translogic'),
				"desc" => wp_kses_data( __('Select position of the main menu', 'translogic') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services',
					'section' => esc_html__('Header', 'translogic')
				),
				"std" => 'top',
				"options" => array(
					'top'	=> esc_html__('Top',	'translogic'),
					'left'	=> esc_html__('Left',	'translogic'),
					'right'	=> esc_html__('Right',	'translogic')
				),
				"type" => "switch"
				),
			'menu_scheme' => array(
				"title" => esc_html__('Menu Color Scheme', 'translogic'),
				"desc" => wp_kses_data( __('Select color scheme to decorate main menu area', 'translogic') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services',
					'section' => esc_html__('Header', 'translogic')
				),
				"std" => 'inherit',
				"options" => translogic_get_list_schemes(true),
				"refresh" => false,
				"type" => "select"
				),
			'menu_stretch' => array(
				"title" => esc_html__('Stretch sidemenu', 'translogic'),
				"desc" => wp_kses_data( __('Stretch sidemenu to window height (if menu items number >= 5)', 'translogic') ),
				"std" => 1,
				"type" => "checkbox"
				),
			'header_widgets' => array(
				"title" => esc_html__('Header widgets', 'translogic'),
				"desc" => wp_kses_data( __('Select set of widgets to show in the header on each page', 'translogic') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services',
					'section' => esc_html__('Header', 'translogic'),
					"desc" => wp_kses_data( __('Select set of widgets to show in the header on this page', 'translogic') ),
				),
				"std" => 'hide',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'translogic')), translogic_get_list_sidebars()),
				"type" => "select"
				),
			'header_columns' => array(
				"title" => esc_html__('Header columns', 'translogic'),
				"desc" => wp_kses_data( __('Select number columns to show widgets in the Header. If 0 - autodetect by the widgets count', 'translogic') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services',
					'section' => esc_html__('Header', 'translogic')
				),
				"dependency" => array(
					'header_widgets' => array('^hide')
				),
				"std" => 0,
				"options" => translogic_get_list_range(0,6),
				"type" => "select"
				),
			'header_wide' => array(
				"title" => esc_html__('Header fullwide', 'translogic'),
				"desc" => wp_kses_data( __('Do you want to stretch the header widgets area to the entire window width?', 'translogic') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services',
					'section' => esc_html__('Header', 'translogic')
				),
				"std" => 1,
				"type" => "checkbox"
				),
			'logo' => array(
				"title" => esc_html__('Logo', 'translogic'),
				"desc" => wp_kses_data( __('Select or upload site logo', 'translogic') ),
				"std" => '',
				"type" => "image"
				),
			'logo_retina' => array(
				"title" => esc_html__('Logo for Retina', 'translogic'),
				"desc" => wp_kses_data( __('Select or upload site logo used on Retina displays (if empty - use default logo from the field above)', 'translogic') ),
				"std" => '',
				"type" => "image"
				),
			'logo_inverse' => array(
				"title" => esc_html__('Logo inverse', 'translogic'),
				"desc" => wp_kses_data( __('Select or upload site logo to display it on the dark background', 'translogic') ),
				"std" => '',
				"type" => "image"
				),
			'logo_inverse_retina' => array(
				"title" => esc_html__('Logo inverse for Retina', 'translogic'),
				"desc" => wp_kses_data( __('Select or upload site logo used on Retina displays (if empty - use default logo from the field above)', 'translogic') ),
				"std" => '',
				"type" => "image"
				),
			
		
		
			// Section 'Content'
			'content' => array(
				"title" => esc_html__('Content', 'translogic'),
				"desc" => wp_kses_data( __('Options for the content area', 'translogic') ),
				"type" => "section",
				),
			'body_style' => array(
				"title" => esc_html__('Body style', 'translogic'),
				"desc" => wp_kses_data( __('Select width of the body content', 'translogic') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'translogic')
				),
				"refresh" => false,
				"std" => 'wide',
				"options" => array(
					'boxed'		=> esc_html__('Boxed',		'translogic'),
					'wide'		=> esc_html__('Wide',		'translogic'),
					'fullwide'	=> esc_html__('Fullwide',	'translogic'),
					'fullscreen'=> esc_html__('Fullscreen',	'translogic')
				),
				"type" => "select"
				),
			'color_scheme' => array(
				"title" => esc_html__('Site Color Scheme', 'translogic'),
				"desc" => wp_kses_data( __('Select color scheme to decorate whole site. Attention! Case "Inherit" can be used only for custom pages, not for root site content in the Appearance - Customize', 'translogic') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'translogic')
				),
				"std" => 'default',
				"options" => translogic_get_list_schemes(true),
				"refresh" => false,
				"type" => "select"
				),
			'expand_content' => array(
				"title" => esc_html__('Expand content', 'translogic'),
				"desc" => wp_kses_data( __('Expand the content width if the sidebar is hidden', 'translogic') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Content', 'translogic')
				),
				"refresh" => false,
				"std" => 1,
				"type" => "checkbox"
				),
			'remove_margins' => array(
				"title" => esc_html__('Remove margins', 'translogic'),
				"desc" => wp_kses_data( __('Remove margins above and below the content area', 'translogic') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Content', 'translogic')
				),
				"refresh" => false,
				"std" => 0,
				"type" => "checkbox"
				),
			'seo_snippets' => array(
				"title" => esc_html__('SEO snippets', 'translogic'),
				"desc" => wp_kses_data( __('Add structured data markup to the single posts and pages', 'translogic') ),
				"std" => 0,
				"type" => "checkbox"
				),
            'privacy_text' => array(
                "title" => esc_html__("Text with Privacy Policy link", 'translogic'),
                "desc"  => wp_kses_data( __("Specify text with Privacy Policy link for the checkbox 'I agree ...'", 'translogic') ),
                "std"   => wp_kses( __( 'I agree that my submitted data is being collected and stored.', 'translogic' ), 'translogic_kses_content' ),
                "type"  => "text"
            ),
			'boxed_bg_image' => array(
				"title" => esc_html__('Boxed bg image', 'translogic'),
				"desc" => wp_kses_data( __('Select or upload image, used as background in the boxed body', 'translogic') ),
				"dependency" => array(
					'body_style' => array('boxed')
				),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'translogic')
				),
				"std" => '',
				"type" => "image"
				),
			'no_image' => array(
				"title" => esc_html__('No image placeholder', 'translogic'),
				"desc" => wp_kses_data( __('Select or upload image, used as placeholder for the posts without featured image', 'translogic') ),
				"std" => '',
				"type" => "image"
				),
			'sidebar_widgets' => array(
				"title" => esc_html__('Sidebar widgets', 'translogic'),
				"desc" => wp_kses_data( __('Select default widgets to show in the sidebar', 'translogic') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Widgets', 'translogic')
				),
				"std" => 'hide',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'translogic')), translogic_get_list_sidebars()),
				"type" => "select"
				),
			'sidebar_scheme' => array(
				"title" => esc_html__('Color Scheme', 'translogic'),
				"desc" => wp_kses_data( __('Select color scheme to decorate sidebar', 'translogic') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Widgets', 'translogic')
				),
				"std" => 'side',
				"options" => translogic_get_list_schemes(true),
				"refresh" => false,
				"type" => "select"
				),
			'sidebar_position' => array(
				"title" => esc_html__('Sidebar position', 'translogic'),
				"desc" => wp_kses_data( __('Select position to show sidebar', 'translogic') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Widgets', 'translogic')
				),
				"refresh" => false,
				"std" => 'right',
				"options" => translogic_get_list_sidebars_positions(),
				"type" => "select"
				),
			'widgets_above_page' => array(
				"title" => esc_html__('Widgets above the page', 'translogic'),
				"desc" => wp_kses_data( __('Select widgets to show above page (content and sidebar)', 'translogic') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Widgets', 'translogic')
				),
				"std" => 'hide',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'translogic')), translogic_get_list_sidebars()),
				"type" => "select"
				),
			'widgets_above_content' => array(
				"title" => esc_html__('Widgets above the content', 'translogic'),
				"desc" => wp_kses_data( __('Select widgets to show at the beginning of the content area', 'translogic') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Widgets', 'translogic')
				),
				"std" => 'hide',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'translogic')), translogic_get_list_sidebars()),
				"type" => "select"
				),
			'widgets_below_content' => array(
				"title" => esc_html__('Widgets below the content', 'translogic'),
				"desc" => wp_kses_data( __('Select widgets to show at the ending of the content area', 'translogic') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Widgets', 'translogic')
				),
				"std" => 'hide',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'translogic')), translogic_get_list_sidebars()),
				"type" => "select"
				),
			'widgets_below_page' => array(
				"title" => esc_html__('Widgets below the page', 'translogic'),
				"desc" => wp_kses_data( __('Select widgets to show below the page (content and sidebar)', 'translogic') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Widgets', 'translogic')
				),
				"std" => 'hide',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'translogic')), translogic_get_list_sidebars()),
				"type" => "select"
				),
		
		
		
			// Section 'Footer'
			'footer' => array(
				"title" => esc_html__('Footer', 'translogic'),
				"desc" => wp_kses_data( __('Select set of widgets and columns number for the site footer', 'translogic') ),
				"type" => "section"
				),
			'footer_scheme' => array(
				"title" => esc_html__('Footer Color Scheme', 'translogic'),
				"desc" => wp_kses_data( __('Select color scheme to decorate footer area', 'translogic') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Footer', 'translogic')
				),
				"std" => 'dark',
				"options" => translogic_get_list_schemes(true),
				"refresh" => false,
				"type" => "select"
				),
			'footer_widgets' => array(
				"title" => esc_html__('Footer widgets', 'translogic'),
				"desc" => wp_kses_data( __('Select set of widgets to show in the footer', 'translogic') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Footer', 'translogic')
				),
				"std" => 'footer_widgets',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'translogic')), translogic_get_list_sidebars()),
				"type" => "select"
				),
			'footer_columns' => array(
				"title" => esc_html__('Footer columns', 'translogic'),
				"desc" => wp_kses_data( __('Select number columns to show widgets in the footer. If 0 - autodetect by the widgets count', 'translogic') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Footer', 'translogic')
				),
				"dependency" => array(
					'footer_widgets' => array('^hide')
				),
				"std" => 0,
				"options" => translogic_get_list_range(0,6),
				"type" => "select"
				),
			'footer_wide' => array(
				"title" => esc_html__('Footer fullwide', 'translogic'),
				"desc" => wp_kses_data( __('Do you want to stretch the footer to the entire window width?', 'translogic') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Footer', 'translogic')
				),
				"std" => 0,
				"type" => "checkbox"
				),
			'logo_in_footer' => array(
				"title" => esc_html__('Show logo', 'translogic'),
				"desc" => wp_kses_data( __('Show logo in the footer', 'translogic') ),
				'refresh' => false,
				"std" => 0,
				"type" => "checkbox"
				),
			'logo_footer' => array(
				"title" => esc_html__('Logo for footer', 'translogic'),
				"desc" => wp_kses_data( __('Select or upload site logo to display it in the footer', 'translogic') ),
				"dependency" => array(
					'logo_in_footer' => array('1')
				),
				"std" => '',
				"type" => "image"
				),
			'logo_footer_retina' => array(
				"title" => esc_html__('Logo for footer (Retina)', 'translogic'),
				"desc" => wp_kses_data( __('Select or upload logo for the footer area used on Retina displays (if empty - use default logo from the field above)', 'translogic') ),
				"dependency" => array(
					'logo_in_footer' => array('1')
				),
				"std" => '',
				"type" => "image"
				),
			'socials_in_footer' => array(
				"title" => esc_html__('Show social icons', 'translogic'),
				"desc" => wp_kses_data( __('Show social icons in the footer (under logo or footer widgets)', 'translogic') ),
				"std" => 0,
				"type" => "checkbox"
				),
			'copyright' => array(
				"title" => esc_html__('Copyright', 'translogic'),
				"desc" => wp_kses_data( __('Copyright text in the footer', 'translogic') ),
				"std" => esc_html__('ThemeREX &copy; {Y}. All rights reserved.', 'translogic'),
				"refresh" => false,
				"type" => "textarea"
				),
		
		
		
			// Section 'Homepage' - settings for home page
			'homepage' => array(
				"title" => esc_html__('Homepage', 'translogic'),
				"desc" => wp_kses_data( __('Select blog style and widgets to display on the homepage', 'translogic') ),
				"type" => "section"
				),
			'expand_content_home' => array(
				"title" => esc_html__('Expand content', 'translogic'),
				"desc" => wp_kses_data( __('Expand the content width if the sidebar is hidden on the Homepage', 'translogic') ),
				"refresh" => false,
				"std" => 1,
				"type" => "checkbox"
				),
			'blog_style_home' => array(
				"title" => esc_html__('Blog style', 'translogic'),
				"desc" => wp_kses_data( __('Select posts style for the homepage', 'translogic') ),
				"std" => 'excerpt',
				"options" => translogic_get_list_blog_styles(),
				"type" => "select"
				),
			'first_post_large_home' => array(
				"title" => esc_html__('First post large', 'translogic'),
				"desc" => wp_kses_data( __('Make first post large (with Excerpt layout) on the Classic layout of the Homepage', 'translogic') ),
				"dependency" => array(
					'blog_style_home' => array('classic')
				),
				"std" => 0,
				"type" => "checkbox"
				),
			'header_widgets_home' => array(
				"title" => esc_html__('Header widgets', 'translogic'),
				"desc" => wp_kses_data( __('Select set of widgets to show in the header on the homepage', 'translogic') ),
				"std" => 'header_widgets',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'translogic')), translogic_get_list_sidebars()),
				"type" => "select"
				),
			'sidebar_widgets_home' => array(
				"title" => esc_html__('Sidebar widgets', 'translogic'),
				"desc" => wp_kses_data( __('Select sidebar to show on the homepage', 'translogic') ),
				"std" => 'sidebar_widgets',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'translogic')), translogic_get_list_sidebars()),
				"type" => "select"
				),
			'sidebar_position_home' => array(
				"title" => esc_html__('Sidebar position', 'translogic'),
				"desc" => wp_kses_data( __('Select position to show sidebar on the homepage', 'translogic') ),
				"refresh" => false,
				"std" => 'right',
				"options" => translogic_get_list_sidebars_positions(),
				"type" => "select"
				),
			'widgets_above_page_home' => array(
				"title" => esc_html__('Widgets above the page', 'translogic'),
				"desc" => wp_kses_data( __('Select widgets to show above page (content and sidebar)', 'translogic') ),
				"std" => 'hide',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'translogic')), translogic_get_list_sidebars()),
				"type" => "select"
				),
			'widgets_above_content_home' => array(
				"title" => esc_html__('Widgets above the content', 'translogic'),
				"desc" => wp_kses_data( __('Select widgets to show at the beginning of the content area', 'translogic') ),
				"std" => 'hide',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'translogic')), translogic_get_list_sidebars()),
				"type" => "select"
				),
			'widgets_below_content_home' => array(
				"title" => esc_html__('Widgets below the content', 'translogic'),
				"desc" => wp_kses_data( __('Select widgets to show at the ending of the content area', 'translogic') ),
				"std" => 'hide',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'translogic')), translogic_get_list_sidebars()),
				"type" => "select"
				),
			'widgets_below_page_home' => array(
				"title" => esc_html__('Widgets below the page', 'translogic'),
				"desc" => wp_kses_data( __('Select widgets to show below the page (content and sidebar)', 'translogic') ),
				"std" => 'hide',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'translogic')), translogic_get_list_sidebars()),
				"type" => "select"
				),
			
		
		
			// Section 'Blog archive'
			'blog' => array(
				"title" => esc_html__('Blog archive', 'translogic'),
				"desc" => wp_kses_data( __('Options for the blog archive', 'translogic') ),
				"type" => "section",
				),
			'expand_content_blog' => array(
				"title" => esc_html__('Expand content', 'translogic'),
				"desc" => wp_kses_data( __('Expand the content width if the sidebar is hidden on the blog archive', 'translogic') ),
				"refresh" => false,
				"std" => 1,
				"type" => "checkbox"
				),
			'blog_style' => array(
				"title" => esc_html__('Blog style', 'translogic'),
				"desc" => wp_kses_data( __('Select posts style for the blog archive', 'translogic') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'translogic')
				),
				"dependency" => array(
					'#page_template' => array('blog.php'),
                    '.components-select-control:not(.post-author-selector) select' => array( 'blog.php' ),
                    '.editor-page-attributes__template select' => array( 'blog.php' ),
				),
				"std" => 'excerpt',
				"options" => translogic_get_list_blog_styles(),
				"type" => "select"
				),
			'blog_columns' => array(
				"title" => esc_html__('Blog columns', 'translogic'),
				"desc" => wp_kses_data( __('How many columns should be used in the blog archive (from 2 to 4)?', 'translogic') ),
				"std" => 2,
				"options" => translogic_get_list_range(2,4),
				"type" => "hidden"
				),
			'post_type' => array(
				"title" => esc_html__('Post type', 'translogic'),
				"desc" => wp_kses_data( __('Select post type to show in the blog archive', 'translogic') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'translogic')
				),
				"dependency" => array(
					'#page_template' => array('blog.php'),
                    '.components-select-control:not(.post-author-selector) select' => array( 'blog.php' ),
                    '.editor-page-attributes__template select' => array( 'blog.php' ),
				),
				"linked" => 'parent_cat',
				"refresh" => false,
				"hidden" => true,
				"std" => 'post',
				"options" => translogic_get_list_posts_types(),
				"type" => "select"
				),
			'parent_cat' => array(
				"title" => esc_html__('Category to show', 'translogic'),
				"desc" => wp_kses_data( __('Select category to show in the blog archive', 'translogic') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'translogic')
				),
				"dependency" => array(
					'#page_template' => array('blog.php'),
                    '.components-select-control:not(.post-author-selector) select' => array( 'blog.php' ),
                    '.editor-page-attributes__template select' => array( 'blog.php' ),
				),
				"refresh" => false,
				"hidden" => true,
				"std" => '0',
				"options" => translogic_array_merge(array(0 => esc_html__('- Select category -', 'translogic')), translogic_get_list_categories()),
				"type" => "select"
				),
			'posts_per_page' => array(
				"title" => esc_html__('Posts per page', 'translogic'),
				"desc" => wp_kses_data( __('How many posts will be displayed on this page', 'translogic') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'translogic')
				),
				"dependency" => array(
					'#page_template' => array('blog.php'),
                    '.components-select-control:not(.post-author-selector) select' => array( 'blog.php' ),
                    '.editor-page-attributes__template select' => array( 'blog.php' ),
				),
				"hidden" => true,
				"std" => '10',
				"type" => "text"
				),
			"blog_pagination" => array( 
				"title" => esc_html__('Pagination style', 'translogic'),
				"desc" => wp_kses_data( __('Show Older/Newest posts or Page numbers below the posts list', 'translogic') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'translogic')
				),
				"std" => "pages",
				"options" => array(
					'pages'	=> esc_html__("Page numbers", 'translogic'),
					'links'	=> esc_html__("Older/Newest", 'translogic'),
					'more'	=> esc_html__("Load more", 'translogic'),
					'infinite' => esc_html__("Infinite scroll", 'translogic')
				),
				"type" => "select"
				),
			'show_filters' => array(
				"title" => esc_html__('Show filters', 'translogic'),
				"desc" => wp_kses_data( __('Show categories as tabs to filter posts', 'translogic') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'translogic')
				),
				"dependency" => array(
					'#page_template' => array('blog.php'),
                    '.components-select-control:not(.post-author-selector) select' => array( 'blog.php' ),
                    '.editor-page-attributes__template select' => array( 'blog.php' ),
					'blog_style' => array('portfolio', 'gallery')
				),
				"hidden" => true,
				"std" => 0,
				"type" => "checkbox"
				),
			'first_post_large' => array(
				"title" => esc_html__('First post large', 'translogic'),
				"desc" => wp_kses_data( __('Make first post large (with Excerpt layout) on the Classic layout of blog archive', 'translogic') ),
				"dependency" => array(
					'blog_style' => array('classic')
				),
				"std" => 0,
				"type" => "checkbox"
				),
			"blog_content" => array( 
				"title" => esc_html__('Posts content', 'translogic'),
				"desc" => wp_kses_data( __("Show full post's content in the blog or only post's excerpt", 'translogic') ),
				"std" => "excerpt",
				"options" => array(
					'excerpt'	=> esc_html__('Excerpt',	'translogic'),
					'fullpost'	=> esc_html__('Full post',	'translogic')
				),
				"type" => "select"
				),
			'time_diff_before' => array(
				"title" => esc_html__('Time difference', 'translogic'),
				"desc" => wp_kses_data( __("How many days show time difference instead post's date", 'translogic') ),
				"std" => 5,
				"type" => "text"
				),
			'related_posts' => array(
				"title" => esc_html__('Related posts', 'translogic'),
				"desc" => wp_kses_data( __('How many related posts should be displayed in the single post?', 'translogic') ),
				"std" => 2,
				"options" => translogic_get_list_range(2,4),
				"type" => "select"
				),
			"blog_animation" => array( 
				"title" => esc_html__('Animation for the posts', 'translogic'),
				"desc" => wp_kses_data( __('Select animation to show posts in the blog. Attention! Do not use any animation on pages with the "wheel to the anchor" behaviour (like a "Chess 2 columns")!', 'translogic') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Content', 'translogic')
				),
				"dependency" => array(
					'#page_template' => array('blog.php'),
                    '.components-select-control:not(.post-author-selector) select' => array( 'blog.php' ),
                    '.editor-page-attributes__template select' => array( 'blog.php' ),
				),
				"std" => "none",
				"options" => translogic_get_list_animations_in(),
				"type" => "select"
				),
			'header_widgets_blog' => array(
				"title" => esc_html__('Header widgets', 'translogic'),
				"desc" => wp_kses_data( __('Select set of widgets to show in the header on the blog archive', 'translogic') ),
				"std" => 'hide',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'translogic')), translogic_get_list_sidebars()),
				"type" => "select"
				),
			'sidebar_widgets_blog' => array(
				"title" => esc_html__('Sidebar widgets', 'translogic'),
				"desc" => wp_kses_data( __('Select sidebar to show on the blog archive', 'translogic') ),
				"std" => 'sidebar_widgets',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'translogic')), translogic_get_list_sidebars()),
				"type" => "select"
				),
			'sidebar_position_blog' => array(
				"title" => esc_html__('Sidebar position', 'translogic'),
				"desc" => wp_kses_data( __('Select position to show sidebar on the blog archive', 'translogic') ),
				"refresh" => false,
				"std" => 'right',
				"options" => translogic_get_list_sidebars_positions(),
				"type" => "select"
				),
			'widgets_above_page_blog' => array(
				"title" => esc_html__('Widgets above the page', 'translogic'),
				"desc" => wp_kses_data( __('Select widgets to show above page (content and sidebar)', 'translogic') ),
				"std" => 'hide',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'translogic')), translogic_get_list_sidebars()),
				"type" => "select"
				),
			'widgets_above_content_blog' => array(
				"title" => esc_html__('Widgets above the content', 'translogic'),
				"desc" => wp_kses_data( __('Select widgets to show at the beginning of the content area', 'translogic') ),
				"std" => 'hide',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'translogic')), translogic_get_list_sidebars()),
				"type" => "select"
				),
			'widgets_below_content_blog' => array(
				"title" => esc_html__('Widgets below the content', 'translogic'),
				"desc" => wp_kses_data( __('Select widgets to show at the ending of the content area', 'translogic') ),
				"std" => 'hide',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'translogic')), translogic_get_list_sidebars()),
				"type" => "select"
				),
			'widgets_below_page_blog' => array(
				"title" => esc_html__('Widgets below the page', 'translogic'),
				"desc" => wp_kses_data( __('Select widgets to show below the page (content and sidebar)', 'translogic') ),
				"std" => 'hide',
				"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'translogic')), translogic_get_list_sidebars()),
				"type" => "select"
				),
			
		
		
		
			// Section 'Colors' - choose color scheme and customize separate colors from it
			'scheme' => array(
				"title" => esc_html__('* Color scheme editor', 'translogic'),
				"desc" => wp_kses_data( __("<b>Simple settings</b> - you can change only accented color, used for links, buttons and some accented areas.", 'translogic') )
						. '<br>'
						. wp_kses_data( __("<b>Advanced settings</b> - change all scheme's colors and get full control over the appearance of your site!", 'translogic') ),
				"priority" => 1000,
				"type" => "section"
				),
		
			'color_settings' => array(
				"title" => esc_html__('Color settings', 'translogic'),
				"desc" => '',
				"std" => 'simple',
				"options" => array(
					"simple"  => esc_html__("Simple", 'translogic'),
					"advanced" => esc_html__("Advanced", 'translogic')
				),
				"refresh" => false,
				"type" => "switch"
				),
		
			'color_scheme_editor' => array(
				"title" => esc_html__('Color Scheme', 'translogic'),
				"desc" => wp_kses_data( __('Select color scheme to edit colors', 'translogic') ),
				"std" => 'default',
				"options" => translogic_get_list_schemes(),
				"refresh" => false,
				"type" => "select"
				),
		
			'scheme_storage' => array(
				"title" => esc_html__('Colors storage', 'translogic'),
				"desc" => esc_html__('Hidden storage of the all color from the all color shemes (only for internal usage)', 'translogic'),
				"std" => '',
				"refresh" => false,
				"type" => "hidden"
				),
		
			'scheme_info_single' => array(
				"title" => esc_html__('Colors for single post/page', 'translogic'),
				"desc" => wp_kses_data( __('Specify colors for single post/page (not for alter blocks)', 'translogic') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"type" => "info"
				),
				
			'bg_color' => array(
				"title" => esc_html__('Background color', 'translogic'),
				"desc" => wp_kses_data( __('Background color of the whole page', 'translogic') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$translogic_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'bd_color' => array(
				"title" => esc_html__('Border color', 'translogic'),
				"desc" => wp_kses_data( __('Color of the bordered elements, separators, etc.', 'translogic') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$translogic_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
		
			'text' => array(
				"title" => esc_html__('Text', 'translogic'),
				"desc" => wp_kses_data( __('Plain text color on single page/post', 'translogic') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$translogic_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'text_light' => array(
				"title" => esc_html__('Light text', 'translogic'),
				"desc" => wp_kses_data( __('Color of the post meta: post date and author, comments number, etc.', 'translogic') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$translogic_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'text_dark' => array(
				"title" => esc_html__('Dark text', 'translogic'),
				"desc" => wp_kses_data( __('Color of the headers, strong text, etc.', 'translogic') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$translogic_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'text_link' => array(
				"title" => esc_html__('Links', 'translogic'),
				"desc" => wp_kses_data( __('Color of links and accented areas', 'translogic') ),
				"std" => '$translogic_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'text_hover' => array(
				"title" => esc_html__('Links hover', 'translogic'),
				"desc" => wp_kses_data( __('Hover color for links and accented areas', 'translogic') ),
				"std" => '$translogic_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
		
			'scheme_info_alter' => array(
				"title" => esc_html__('Colors for alternative blocks', 'translogic'),
				"desc" => wp_kses_data( __('Specify colors for alternative blocks - rectangular blocks with its own background color (posts in homepage, blog archive, search results, widgets on sidebar, footer, etc.)', 'translogic') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"type" => "info"
				),
		
			'alter_bg_color' => array(
				"title" => esc_html__('Alter background color', 'translogic'),
				"desc" => wp_kses_data( __('Background color of the alternative blocks', 'translogic') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$translogic_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'alter_bg_hover' => array(
				"title" => esc_html__('Alter hovered background color', 'translogic'),
				"desc" => wp_kses_data( __('Background color for the hovered state of the alternative blocks', 'translogic') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$translogic_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'alter_bd_color' => array(
				"title" => esc_html__('Alternative border color', 'translogic'),
				"desc" => wp_kses_data( __('Border color of the alternative blocks', 'translogic') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$translogic_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'alter_bd_hover' => array(
				"title" => esc_html__('Alternative hovered border color', 'translogic'),
				"desc" => wp_kses_data( __('Border color for the hovered state of the alter blocks', 'translogic') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$translogic_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'alter_text' => array(
				"title" => esc_html__('Alter text', 'translogic'),
				"desc" => wp_kses_data( __('Text color of the alternative blocks', 'translogic') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$translogic_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'alter_light' => array(
				"title" => esc_html__('Alter light', 'translogic'),
				"desc" => wp_kses_data( __('Color of the info blocks inside block with alternative background', 'translogic') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$translogic_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'alter_dark' => array(
				"title" => esc_html__('Alter dark', 'translogic'),
				"desc" => wp_kses_data( __('Color of the headers inside block with alternative background', 'translogic') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$translogic_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'alter_link' => array(
				"title" => esc_html__('Alter link', 'translogic'),
				"desc" => wp_kses_data( __('Color of the links inside block with alternative background', 'translogic') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$translogic_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'alter_hover' => array(
				"title" => esc_html__('Alter hover', 'translogic'),
				"desc" => wp_kses_data( __('Color of the hovered links inside block with alternative background', 'translogic') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$translogic_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
		
			'scheme_info_input' => array(
				"title" => esc_html__('Colors for the form fields', 'translogic'),
				"desc" => wp_kses_data( __('Specify colors for the form fields and textareas', 'translogic') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"type" => "info"
				),
		
			'input_bg_color' => array(
				"title" => esc_html__('Inactive background', 'translogic'),
				"desc" => wp_kses_data( __('Background color of the inactive form fields', 'translogic') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$translogic_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'input_bg_hover' => array(
				"title" => esc_html__('Active background', 'translogic'),
				"desc" => wp_kses_data( __('Background color of the focused form fields', 'translogic') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$translogic_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'input_bd_color' => array(
				"title" => esc_html__('Inactive border', 'translogic'),
				"desc" => wp_kses_data( __('Color of the border in the inactive form fields', 'translogic') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$translogic_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'input_bd_hover' => array(
				"title" => esc_html__('Active border', 'translogic'),
				"desc" => wp_kses_data( __('Color of the border in the focused form fields', 'translogic') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$translogic_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'input_text' => array(
				"title" => esc_html__('Inactive field', 'translogic'),
				"desc" => wp_kses_data( __('Color of the text in the inactive fields', 'translogic') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$translogic_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'input_light' => array(
				"title" => esc_html__('Disabled field', 'translogic'),
				"desc" => wp_kses_data( __('Color of the disabled field', 'translogic') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$translogic_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'input_dark' => array(
				"title" => esc_html__('Active field', 'translogic'),
				"desc" => wp_kses_data( __('Color of the active field', 'translogic') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$translogic_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
		
			'scheme_info_inverse' => array(
				"title" => esc_html__('Colors for inverse blocks', 'translogic'),
				"desc" => wp_kses_data( __('Specify colors for inverse blocks, rectangular blocks with background color equal to the links color or one of accented colors (if used in the current theme)', 'translogic') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"type" => "info"
				),
		
			'inverse_text' => array(
				"title" => esc_html__('Inverse text', 'translogic'),
				"desc" => wp_kses_data( __('Color of the text inside block with accented background', 'translogic') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$translogic_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'inverse_light' => array(
				"title" => esc_html__('Inverse light', 'translogic'),
				"desc" => wp_kses_data( __('Color of the info blocks inside block with accented background', 'translogic') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$translogic_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'inverse_dark' => array(
				"title" => esc_html__('Inverse dark', 'translogic'),
				"desc" => wp_kses_data( __('Color of the headers inside block with accented background', 'translogic') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$translogic_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'inverse_link' => array(
				"title" => esc_html__('Inverse link', 'translogic'),
				"desc" => wp_kses_data( __('Color of the links inside block with accented background', 'translogic') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$translogic_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),
			'inverse_hover' => array(
				"title" => esc_html__('Inverse hover', 'translogic'),
				"desc" => wp_kses_data( __('Color of the hovered links inside block with accented background', 'translogic') ),
				"dependency" => array(
					'color_settings' => array('^simple')
				),
				"std" => '$translogic_get_scheme_color',
				"refresh" => false,
				"type" => "color"
				),


			// Section 'Hidden'
			'media_title' => array(
				"title" => esc_html__('Media title', 'translogic'),
				"desc" => wp_kses_data( __('Used as title for the audio and video item in this post', 'translogic') ),
				"override" => array(
					'mode' => 'post',
					'section' => esc_html__('Title', 'translogic')
				),
				"hidden" => true,
				"std" => '',
				"type" => "text"
				),
			'media_author' => array(
				"title" => esc_html__('Media author', 'translogic'),
				"desc" => wp_kses_data( __('Used as author name for the audio and video item in this post', 'translogic') ),
				"override" => array(
					'mode' => 'post',
					'section' => esc_html__('Title', 'translogic')
				),
				"hidden" => true,
				"std" => '',
				"type" => "text"
				),


			// Internal options.
			// Attention! Don't change any options in the section below!
			'reset_options' => array(
				"title" => '',
				"desc" => '',
				"std" => '0',
				"type" => "hidden",
				),

		));


		// Prepare panel 'Fonts'
		$fonts = array(
		
			// Panel 'Fonts' - manage fonts loading and set parameters of the base theme elements
			'fonts' => array(
				"title" => esc_html__('* Fonts settings', 'translogic'),
				"desc" => '',
				"priority" => 1500,
				"type" => "panel"
				),

			// Section 'Load_fonts'
			'load_fonts' => array(
				"title" => esc_html__('Load fonts', 'translogic'),
				"desc" => wp_kses_data( __('Specify fonts to load when theme start. You can use them in the base theme elements: headers, text, menu, links, input fields, etc.', 'translogic') )
						. '<br>'
						. wp_kses_data( __('<b>Attention!</b> Press "Refresh" button to reload preview area after the all fonts are changed', 'translogic') ),
				"type" => "section"
				),
			'load_fonts_subset' => array(
				"title" => esc_html__('Google fonts subsets', 'translogic'),
				"desc" => wp_kses_data( __('Specify comma separated list of the subsets which will be load from Google fonts', 'translogic') )
						. '<br>'
						. wp_kses_data( __('Available subsets are: latin,latin-ext,cyrillic,cyrillic-ext,greek,greek-ext,vietnamese', 'translogic') ),
				"refresh" => false,
				"std" => '$translogic_get_load_fonts_subset',
				"type" => "text"
				)
		);

		for ($i=1; $i<=translogic_get_theme_setting('max_load_fonts'); $i++) {
			$fonts["load_fonts-{$i}-info"] = array(
				"title" => esc_html(sprintf(__('Font %s', 'translogic'), $i)),
				"desc" => '',
				"type" => "info",
				);
			$fonts["load_fonts-{$i}-name"] = array(
				"title" => esc_html__('Font name', 'translogic'),
				"desc" => '',
				"refresh" => false,
				"std" => '$translogic_get_load_fonts_option',
				"type" => "text"
				);
			$fonts["load_fonts-{$i}-family"] = array(
				"title" => esc_html__('Font family', 'translogic'),
				"desc" => $i==1 
							? wp_kses_data( __('Select font family to use it if font above is not available', 'translogic') )
							: '',
				"refresh" => false,
				"std" => '$translogic_get_load_fonts_option',
				"options" => array(
					'inherit' => esc_html__("Inherit", 'translogic'),
					'serif' => esc_html__('serif', 'translogic'),
					'sans-serif' => esc_html__('sans-serif', 'translogic'),
					'monospace' => esc_html__('monospace', 'translogic'),
					'cursive' => esc_html__('cursive', 'translogic'),
					'fantasy' => esc_html__('fantasy', 'translogic')
				),
				"type" => "select"
				);
			$fonts["load_fonts-{$i}-styles"] = array(
				"title" => esc_html__('Font styles', 'translogic'),
				"desc" => $i==1 
							? wp_kses_data( __('Font styles used only for the Google fonts. This is a comma separated list of the font weight and styles. For example: 400,400italic,700', 'translogic') )
											. '<br>'
								. wp_kses_data( __('<b>Attention!</b> Each weight and style increase download size! Specify only used weights and styles.', 'translogic') )
							: '',
				"refresh" => false,
				"std" => '$translogic_get_load_fonts_option',
				"type" => "text"
				);
		}
		$fonts['load_fonts_end'] = array(
			"type" => "section_end"
			);

		// Sections with font's attributes for each theme element
		$theme_fonts = translogic_get_theme_fonts();
		foreach ($theme_fonts as $tag=>$v) {
			$fonts["{$tag}_section"] = array(
				"title" => !empty($v['title']) 
								? $v['title'] 
								: esc_html(sprintf(__('%s settings', 'translogic'), $tag)),
				"desc" => !empty($v['description']) 
								? $v['description'] 
								: wp_kses( sprintf(__('Font settings of the "%s" tag.', 'translogic'), $tag), 'translogic_kses_content'  ),
				"type" => "section",
				);
	
			foreach ($v as $css_prop=>$css_value) {
				if (in_array($css_prop, array('title', 'description'))) continue;
				$options = '';
				$type = 'text';
				$title = ucfirst(str_replace('-', ' ', $css_prop));
				if ($css_prop == 'font-family') {
					$type = 'select';
					$options = translogic_get_list_load_fonts(true);
				} else if ($css_prop == 'font-weight') {
					$type = 'select';
					$options = array(
						'inherit' => esc_html__("Inherit", 'translogic'),
						'100' => esc_html__('100 (Light)', 'translogic'), 
						'200' => esc_html__('200 (Light)', 'translogic'), 
						'300' => esc_html__('300 (Thin)',  'translogic'),
						'400' => esc_html__('400 (Normal)', 'translogic'),
						'500' => esc_html__('500 (Semibold)', 'translogic'),
						'600' => esc_html__('600 (Semibold)', 'translogic'),
						'700' => esc_html__('700 (Bold)', 'translogic'),
						'800' => esc_html__('800 (Black)', 'translogic'),
						'900' => esc_html__('900 (Black)', 'translogic')
					);
				} else if ($css_prop == 'font-style') {
					$type = 'select';
					$options = array(
						'inherit' => esc_html__("Inherit", 'translogic'),
						'normal' => esc_html__('Normal', 'translogic'), 
						'italic' => esc_html__('Italic', 'translogic')
					);
				} else if ($css_prop == 'text-decoration') {
					$type = 'select';
					$options = array(
						'inherit' => esc_html__("Inherit", 'translogic'),
						'none' => esc_html__('None', 'translogic'), 
						'underline' => esc_html__('Underline', 'translogic'),
						'overline' => esc_html__('Overline', 'translogic'),
						'line-through' => esc_html__('Line-through', 'translogic')
					);
				} else if ($css_prop == 'text-transform') {
					$type = 'select';
					$options = array(
						'inherit' => esc_html__("Inherit", 'translogic'),
						'none' => esc_html__('None', 'translogic'), 
						'uppercase' => esc_html__('Uppercase', 'translogic'),
						'lowercase' => esc_html__('Lowercase', 'translogic'),
						'capitalize' => esc_html__('Capitalize', 'translogic')
					);
				}
				$fonts["{$tag}_{$css_prop}"] = array(
					"title" => $title,
					"desc" => '',
					"refresh" => false,
					"std" => '$translogic_get_theme_fonts_option',
					"options" => $options,
					"type" => $type
				);
			}
			
			$fonts["{$tag}_section_end"] = array(
				"type" => "section_end"
				);
		}

		$fonts['fonts_end'] = array(
			"type" => "panel_end"
			);

		// Add fonts parameters into Theme Options
		translogic_storage_merge_array('options', '', $fonts);
	}
}




// -----------------------------------------------------------------
// -- Create and manage Theme Options
// -----------------------------------------------------------------

// Theme init priorities:
// 2 - create Theme Options
if (!function_exists('translogic_options_theme_setup2')) {
	add_action( 'after_setup_theme', 'translogic_options_theme_setup2', 2 );
	function translogic_options_theme_setup2() {
		translogic_options_create();
	}
}

// Step 1: Load default settings and previously saved mods
if (!function_exists('translogic_options_theme_setup5')) {
	add_action( 'after_setup_theme', 'translogic_options_theme_setup5', 5 );
	function translogic_options_theme_setup5() {
		translogic_storage_set('options_reloaded', false);
		translogic_load_theme_options();
	}
}

// Step 2: Load current theme customization mods
if (is_customize_preview()) {
	if (!function_exists('translogic_load_custom_options')) {
		add_action( 'wp_loaded', 'translogic_load_custom_options' );
		function translogic_load_custom_options() {
			if (!translogic_storage_get('options_reloaded')) {
				translogic_storage_set('options_reloaded', true);
				translogic_load_theme_options();
			}
		}
	}
}

// Load current values for each customizable option
if ( !function_exists('translogic_load_theme_options') ) {
	function translogic_load_theme_options() {
		$options = translogic_storage_get('options');
		$reset = (int) get_theme_mod('reset_options', 0);
		foreach ($options as $k=>$v) {
			if (isset($v['std'])) {
				if (strpos($v['std'], '$translogic_')!==false) {
					$func = substr($v['std'], 1);
					if (function_exists($func)) {
						$v['std'] = $func($k);
					}
				}
				$value = $v['std'];
				if (!$reset) {
					if (isset($_GET[$k]))
						$value = sanitize_text_field($_GET[$k]);
					else {
						$tmp = get_theme_mod($k, -987654321);
						if ($tmp != -987654321) $value = $tmp;
					}
				}
				translogic_storage_set_array2('options', $k, 'val', $value);
				if ($reset) remove_theme_mod($k);
			}
		}
		if ($reset) {
			// Unset reset flag
			set_theme_mod('reset_options', 0);
			// Regenerate CSS with default colors and fonts
			translogic_customizer_save_css();
		} else {
			do_action('translogic_action_load_options');
		}
	}
}

// Override options with stored page/post meta
if ( !function_exists('translogic_override_theme_options') ) {
	add_action( 'wp', 'translogic_override_theme_options', 1 );
	function translogic_override_theme_options($query=null) {
		if (is_page_template('blog.php')) {
			translogic_storage_set('blog_archive', true);
			translogic_storage_set('blog_template', get_the_ID());
		}
		translogic_storage_set('blog_mode', translogic_detect_blog_mode());
		if (is_singular()) {
			translogic_storage_set('options_meta', get_post_meta(get_the_ID(), 'translogic_options', true));
		}
	}
}


// Return customizable option value
if (!function_exists('translogic_get_theme_option')) {
	function translogic_get_theme_option($name, $defa='', $strict_mode=false, $post_id=0) {
		$rez = $defa;
		$from_post_meta = false;
		if ($post_id > 0) {
			if (!translogic_storage_isset('post_options_meta', $post_id))
				translogic_storage_set_array('post_options_meta', $post_id, get_post_meta($post_id, 'translogic_options', true));
			if (translogic_storage_isset('post_options_meta', $post_id, $name)) {
				$tmp = translogic_storage_get_array('post_options_meta', $post_id, $name);
				if (!translogic_is_inherit($tmp)) {
					$rez = $tmp;
					$from_post_meta = true;
				}
			}
		}
		if (!$from_post_meta && translogic_storage_isset('options')) {
			if ( !translogic_storage_isset('options', $name) ) {
				$rez = $tmp = '_not_exists_';
				if (function_exists('trx_addons_get_option'))
					$rez = trx_addons_get_option($name, $tmp, false);
				if ($rez === $tmp) {
					if ($strict_mode) {
						$s = debug_backtrace();
						$s = array_shift($s);
						echo '<pre>' . sprintf(esc_html__('Undefined option "%s" called from:', 'translogic'), $name);
						if (function_exists('dco')) dco($s);
						else print_r($s);
						echo '</pre>';
                        wp_die();
					} else
						$rez = $defa;
				}
			} else {
				$blog_mode = translogic_storage_get('blog_mode');
				// Override option from GET or POST for current blog mode
				if (!empty($blog_mode) && isset($_REQUEST[$name . '_' . $blog_mode])) {
					$rez = sanitize_text_field($_REQUEST[$name . '_' . $blog_mode]);
				// Override option from GET
				} else if (isset($_REQUEST[$name])) {
					$rez = sanitize_text_field($_REQUEST[$name]);
				// Override option from current page settings (if exists)
				} else if (translogic_storage_isset('options_meta', $name) && !translogic_is_inherit(translogic_storage_get_array('options_meta', $name))) {
					$rez = translogic_storage_get_array('options_meta', $name);
				// Override option from current blog mode settings: 'home', 'search', 'page', 'post', 'blog', etc. (if exists)
				} else if (!empty($blog_mode) && translogic_storage_isset('options', $name . '_' . $blog_mode, 'val') && !translogic_is_inherit(translogic_storage_get_array('options', $name . '_' . $blog_mode, 'val'))) {
					$rez = translogic_storage_get_array('options', $name . '_' . $blog_mode, 'val');
				// Get saved option value
				} else if (translogic_storage_isset('options', $name, 'val')) {
					$rez = translogic_storage_get_array('options', $name, 'val');
				// Get ThemeREX Addons option value
				} else if (function_exists('trx_addons_get_option')) {
					$rez = trx_addons_get_option($name, $defa, false);
				}
			}
		}
		return $rez;
	}
}


// Check if customizable option exists
if (!function_exists('translogic_check_theme_option')) {
	function translogic_check_theme_option($name) {
		return translogic_storage_isset('options', $name);
	}
}

// Get dependencies list from the Theme Options
if ( !function_exists('translogic_get_theme_dependencies') ) {
	function translogic_get_theme_dependencies() {
		$options = translogic_storage_get('options');
		$depends = array();
		foreach ($options as $k=>$v) {
			if (isset($v['dependency'])) 
				$depends[$k] = $v['dependency'];
		}
		return $depends;
	}
}

// Return internal theme setting value
if (!function_exists('translogic_get_theme_setting')) {
	function translogic_get_theme_setting($name) {
		return translogic_storage_isset('settings', $name) ? translogic_storage_get_array('settings', $name) : false;
	}
}


// Set theme setting
if ( !function_exists( 'translogic_set_theme_setting' ) ) {
	function translogic_set_theme_setting($option_name, $value) {
		if (translogic_storage_isset('settings', $option_name))
			translogic_storage_set_array('settings', $option_name, $value);
	}
}
?>