(function ($) {
    "use strict";

    // Function to handle "rs-lettering-text"
    const letteringTextHandler = function () {
        if ($(".rs-lettering-text").length) {
            $(".rs-lettering-text").each(function () {
                const sentence = $(this).text().trim();
                let wrappedSentence = "";
                for (let i = 0; i < sentence.length; i++) {
                    wrappedSentence += `<span><em>${sentence[i]}</em></span>`;
                }
                $(this).html(wrappedSentence);
            });
        }
    };

    // Function for handling "draw-line" elements (Widget-specific logic)
    const headingJsHandler = function ($scope, $) {
        const drawLines = $scope.find(".draw-line");
        if (!drawLines.length) return;

        const handleIntersection = (entries) => {
            entries.forEach((entry) => {
                if (entry.isIntersecting) {
                    setTimeout(() => {
                        entry.target.classList.add("start-draw");
                    }, 300);
                } else {
                    entry.target.classList.remove("start-draw");
                }
            });
        };

        const observer = new IntersectionObserver(handleIntersection, { threshold: 0.1 });
        drawLines.each((_, drawLine) => observer.observe(drawLine));
    };

    // Function for handling "rs-highlight" elements (Global logic)
    const handleHighlight = () => {
        const sections = document.querySelectorAll(".rs-highlight");
        if (!sections.length) return;

        sections.forEach((section) => {
            const thresholdClass = [...section.classList].find(cls => cls.startsWith("threshold-"));
            const threshold = thresholdClass ? parseFloat(thresholdClass.split("-")[1]) : 0.4;

            const observerCallback = (entries) => {
                entries.forEach((entry) => {
                    if (entry.isIntersecting) {
                        entry.target.classList.add("in-view");
                    } else {
                        entry.target.classList.remove("in-view");
                    }
                });
            };
            const observer = new IntersectionObserver(observerCallback, { root: null, threshold });
            observer.observe(section);
        });
    };

    const initObservers = () => {
        letteringTextHandler();
        handleHighlight();
    };

    // Elementor hooks for frontend and editor
    $(window).on("elementor/frontend/init", () => {
        const isEditMode = elementorFrontend.isEditMode();

        elementorFrontend.hooks.addAction("frontend/element_ready/rs-heading.default", headingJsHandler);

        if (isEditMode) {
            elementorFrontend.hooks.addAction("frontend/element_ready/global", initObservers);
            
            // Custom CSS for Elementor
            elementor.hooks.addFilter('editor/style/styleText', function (css, context) {
                if (!context) {
                    return;
                }
                var model = context.model,
                customCSS = model.get('settings').get('rs_exten_custom_css');
                var selector = '.elementor-element.elementor-element-' + model.get('id');
                if ('document' === model.get('elType')) {
                    selector = elementor.config.document.settings.cssWrapperSelector;
                }
                if (customCSS) {
                    css += customCSS.replace(/selector/g, selector);
                }
                return css;
            });
        } else {
            $(document).ready(initObservers);
        }
    });
})(jQuery);
