<?php

use Elementor\Controls_Manager;
use Elementor\Controls_Stack;
use Elementor\Core\DynamicTags\Dynamic_CSS;
use Elementor\Core\Files\CSS\Post;
use Elementor\Element_Base;

defined( 'ABSPATH' ) || die();

class RS_Exten_Custom_CSS_Setting {

	public static function init() {
		add_action( 'elementor/element/after_section_end', [ __CLASS__, 'register_controls' ], 10, 2 );
		add_action( 'elementor/element/parse_css', [ __CLASS__, 'add_post_css' ], 10, 2 );
	}

	/**
	 * @param $element    Controls_Stack
	 * @param $section_id string
	 */
	public static function register_controls( Controls_Stack $element, $section_id ) {

		if ( 'section_custom_css_pro' !== $section_id ) {
			return;
		}

        $element->start_controls_section(
            'rs_exten_custom_css_section',
            [
				'label' =>  __( 'RS Custom CSS', 'rsaddon' ),
                'tab'   => Controls_Manager::TAB_ADVANCED,
            ]
        );

		$element->add_control(
			'rs_exten_custom_css',
			[
				'label' =>  __( 'Custom CSS', 'rsaddon' ),
				'type' => Controls_Manager::CODE,
				'render_type' => 'ui',
                'language' => 'css',
				'rows' => 20,
                'description' => 'Use "selector" to target this element. Example: selector .child { opacity: 0; }',
			]
		);

		$element->end_controls_section();
	}

	/**
	 * @param $post_css Post
	 * @param $element  Element_Base
	 */
	public static function add_post_css( $post_css, $element ) {
		if ( $post_css instanceof Dynamic_CSS ) {
			return;
		}

		$element_settings = $element->get_settings();

		if ( empty( $element_settings['rs_exten_custom_css'] ) ) {
			return;
		}

		$css = trim( $element_settings['rs_exten_custom_css'] );

		if ( empty( $css ) ) {
			return;
		}
		$css = str_replace( 'selector', $post_css->get_element_unique_selector( $element ), $css );

		// Add a css comment
		$css = sprintf( '/* Start custom CSS for %s, class: %s */', $element->get_name(), $element->get_unique_selector() ) . $css . '/* End custom CSS */';

		$post_css->get_stylesheet()->add_raw_css( $css );
	}
}

RS_Exten_Custom_CSS_Setting::init();
