<?php



use Elementor\Controls_Manager;
use Elementor\Element_Base;
use Elementor\Utils;
use Elementor\Group_Control_Box_Shadow;


defined('ABSPATH') || die();

class RS_Exten_GSAP_Setting
{

	public function __construct()
    {
        add_action('elementor/element/section/section_advanced/after_section_end', [$this, 'register_controls'], 10, 1);
        add_action('elementor/element/column/section_advanced/after_section_end', [$this, 'register_controls'], 10, 1);
        add_action('elementor/element/common/_section_style/after_section_end', [$this, 'register_controls'], 10, 1);

        add_action('elementor/element/container/section_layout/after_section_end', [$this, 'rs_gsap_scroll_fixed_control'], 3);
		add_action('elementor/element/section/section_advanced/after_section_end', [$this, 'rs_gsap_scroll_fixed_control'], 3);
		
		add_action('elementor/frontend/before_render', [$this, 'rs_gsap_before_section_render'], 3);
    }


    public function register_controls(Element_Base $section)
    {
        $section->start_controls_section(
            'rs_exten_gsap_intaraction_section',
            [
                'label' => 'RS GSAP Intaraction',
                'tab'   => Controls_Manager::TAB_ADVANCED,
            ]
        );
            $section->add_control(
                'rs_exten_gsap_panal_notice',
                [
                    'type'            => Controls_Manager::RAW_HTML,
                    'raw'             => __('<strong>GSAP Extension</strong> Does not work in Editor page.', 'rsaddon'),
                    'content_classes' => 'rs-panel-notice',
                ]
            );

            $section->add_control(
                'rs_exten_gsap_scroll_move_options',
                [
                    'label' => esc_html__( 'Scroll Move Options', 'rsaddon' ),
                    'type' => Controls_Manager::HEADING,
                    'classes' => 'rs-control-type-heading',
                ]
            );
            $section->add_control(
                'rs_exten_gsap_scroll_move',
                [
                    'label'        => __('Scroll Move', 'rsaddon'),
                    'type'         => Controls_Manager::SWITCHER,
                    'default'      => 'no',
                    'return_value' => 'yes',
                    'render_type'  => 'template',
                    'label_on'     => __('Enable', 'rsaddon'),
                    'label_off'    => __('Disable', 'rsaddon'),
                    'prefix_class' => 'gsap-move-',
                ]
            );
            $section->add_control(
                'rs_exten_gsap_scroll_move_dir',
                [
                    'label' => esc_html__( 'Direction', 'rsaddon' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => 'right',
                    'options' => [
                        'top' => esc_html__( 'Top', 'rsaddon' ),
                        'right' => esc_html__( 'Right', 'rsaddon' ),
                        'bottom'  => esc_html__( 'Bottom', 'rsaddon' ),
                        'left'  => esc_html__( 'Left', 'rsaddon' ),
                    ],
                    'condition' => [
                        'rs_exten_gsap_scroll_move' => 'yes'
                    ]
                ]
            );
            $section->add_control(
                'rs_exten_gsap_scroll_move_top_distance',
                [
                    'label' => esc_html__( 'Distance To Top', 'rsaddon' ),
                    'type' => Controls_Manager::NUMBER,
                    'min' => -1000,
                    'max' => 1000,
                    'step' => 2,
                    'prefix_class' => 'up-',
                    'condition' => [
                        'rs_exten_gsap_scroll_move' => 'yes',
                        'rs_exten_gsap_scroll_move_dir' => 'top'
                    ]
                ]
            );
            $section->add_control(
                'rs_exten_gsap_scroll_move_right_distance',
                [
                    'label' => esc_html__( 'Distance To Right', 'rsaddon' ),
                    'type' => Controls_Manager::NUMBER,
                    'min' => -1000,
                    'max' => 1000,
                    'step' => 2,
                    'prefix_class' => 'right-',
                    'condition' => [
                        'rs_exten_gsap_scroll_move' => 'yes',
                        'rs_exten_gsap_scroll_move_dir' => 'right'
                    ]
                ]
            );
            $section->add_control(
                'rs_exten_gsap_scroll_move_bottom_distance',
                [
                    'label' => esc_html__( 'Distance To Bottom', 'rsaddon' ),
                    'type' => Controls_Manager::NUMBER,
                    'min' => -1000,
                    'max' => 1000,
                    'step' => 2,
                    'prefix_class' => 'down-',
                    'condition' => [
                        'rs_exten_gsap_scroll_move' => 'yes',
                        'rs_exten_gsap_scroll_move_dir' => 'bottom'
                    ]
                ]
            );
            $section->add_control(
                'rs_exten_gsap_scroll_move_left_distance',
                [
                    'label' => esc_html__( 'Distance To Left', 'rsaddon' ),
                    'type' => Controls_Manager::NUMBER,
                    'min' => -1000,
                    'max' => 1000,
                    'step' => 2,
                    'prefix_class' => 'left-',
                    'condition' => [
                        'rs_exten_gsap_scroll_move' => 'yes',
                        'rs_exten_gsap_scroll_move_dir' => 'left'
                    ]
                ]
            );
            $section->add_control(
                'rs_exten_gsap_scroll_move_start_from',
                [
                    'label' => esc_html__( 'Start From (0 to 100)', 'rsaddon' ),
                    'type' => Controls_Manager::NUMBER,
                    'min' => -100,
                    'max' => 100,
                    'step' => 2,
                    'prefix_class' => 'start-',
                    'condition' => [
                        'rs_exten_gsap_scroll_move' => 'yes',
                    ]
                ]
            );

            $section->add_control(
                'rs_exten_gsap_scroll_rotate_options',
                [
                    'label' => esc_html__( 'Scroll Rotate Options', 'rsaddon' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                    'classes' => 'rs-control-type-heading',
                ]
            );
            $section->add_control(
                'rs_exten_gsap_scroll_rotation',
                [
                    'label' => esc_html__( 'Rotation', 'rsaddon' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => '',
                    'options' => [
                        '' => esc_html__( 'Not Set', 'rsaddon' ),
                        'normal' => esc_html__( 'Clockwise', 'rsaddon' ),
                        'anti' => esc_html__( 'Anti Clockwise', 'rsaddon' ),
                    ],
                    'prefix_class' => 'gsap-rotate-',
                ]
            );
            $section->add_control(
                'rs_exten_gsap_scroll_rotation_degree',
                [
                    'label' => esc_html__( 'Degree (0 to 360)', 'rsaddon' ),
                    'type' => Controls_Manager::NUMBER,
                    'min' => -1000,
                    'max' => 1000,
                    'prefix_class' => 'to-',
                    'condition' => [
                        'rs_exten_gsap_scroll_rotation' => ['normal', 'anti'],
                    ]
                ]
            );

            $section->add_control(
                'rs_exten_gsap_sticky_ripple_options',
                [
                    'label' => esc_html__( 'Sticky Ripple Options', 'rsaddon' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                    'classes' => 'rs-control-type-heading',
                ]
            );
            $section->add_control(
                'rs_exten_gsap_sticky_ripple',
                [
                    'label'        => __('Sticky Ripple', 'rsaddon'),
                    'type'         => Controls_Manager::SWITCHER,
                    'default'      => 'no',
                    'return_value' => 'yes',
                    'render_type'  => 'template',
                    'label_on'     => __('Enable', 'rsaddon'),
                    'label_off'    => __('Disable', 'rsaddon'),
                    'prefix_class' => 'rs-tween_max_btn-',
                ]
            );
            $section->add_control(
                'rs_exten_gsap_sticky_ripple_distance_max',
                [
                    'label' => esc_html__( 'Distance Max (0-10)', 'rsaddon' ),
                    'placeholder' => esc_html__( '7', 'rsaddon' ),
                    'type' => Controls_Manager::NUMBER,
                    'min' => 0,
                    'max' => 10,
                    'step' => 5,
                    'prefix_class' => 'offset-hover-max-',
                    'condition' => [
                        'rs_exten_gsap_sticky_ripple' => 'yes'
                    ]
                ]
            );
            $section->add_control(
                'rs_exten_gsap_sticky_ripple_distance_min',
                [
                    'label' => esc_html__( 'Distance Min (0-10)', 'rsaddon' ),
                    'placeholder' => esc_html__( '5', 'rsaddon' ),
                    'type' => Controls_Manager::NUMBER,
                    'min' => 0,
                    'max' => 10,
                    'step' => 5,
                    'prefix_class' => 'offset-hover-min-',
                    'condition' => [
                        'rs_exten_gsap_sticky_ripple' => 'yes'
                    ]
                ]
            );
        $section->end_controls_section();
    }

    public function rs_gsap_scroll_fixed_control(Element_Base $section)
	{
		$tabs_field = Controls_Manager::TAB_CONTENT;

		if ('section' === $section->get_name()  || 'container' === $section->get_name()) {
			$tabs_field = Controls_Manager::TAB_LAYOUT;
		}

		$section->start_controls_section(
			'_section_rs_gsap_scroll_fixed_control',
			[
				'label' => __('RS GSAP Scroll Fixed', 'rsaddon'),
				'tab'   => $tabs_field,
			]
		);
		$section->add_control(
            'gsap_scroll_fixed_panal_notice',
            [
                'type'            => Controls_Manager::RAW_HTML,
                'raw'             => __('<strong>GSAP Scroll Fixed</strong> Does not work in Editor page.', 'rsaddon'),
                'content_classes' => 'rs-panel-notice',
            ]
        );
		$section->add_control(
			'gsap_scroll_fixed',
			[
				'label'     => __('Scroll Fixed', 'rsaddon'),
				'type'      => Controls_Manager::SELECT,
				'label_block' => true,
				'options'   => [
					'' => __('Default', 'rsaddon'),
					'gsap-fixed' 	=> __('Enable For Parent Container', 'rsaddon'),
					'gsap-fixed-yes' 	=> __('Enable For Child Container', 'rsaddon')
				],
				'default'   => '',
			]
		);
		$section->add_control(
			'gsap_scroll_fixed_start_at',
			[
				'label' => esc_html__( 'Start at (e.g. 200)', 'rsaddon' ),
				'type' => Controls_Manager::NUMBER,
				'min' => -1000,
				'max' => 1000,
				'step' => 2,
                'prefix_class' => 'start-',
                'condition' => [
                    'gsap_scroll_fixed' => ['gsap-fixed', 'gsap-fixed-yes']
                ]
			]
		);
		$section->end_controls_section();
	}

    public function rs_gsap_before_section_render(Element_Base $section)
	{
		$gsap_scroll_fixed = $section->get_settings_for_display('gsap_scroll_fixed');

		if (
			($gsap_scroll_fixed && !empty($gsap_scroll_fixed))
		) {
			$section->add_render_attribute(
				'_wrapper',
				[
					'class' => [$gsap_scroll_fixed],
				]
			);
		}
	}

}

new RS_Exten_GSAP_Setting();