<?php

use Elementor\Controls_Manager;
use Elementor\Element_Base;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Background;


defined('ABSPATH') || die();

class RS_Exten_Sec_Style_Setting
{

	public function __construct()
	{
		
		add_action('elementor/element/container/section_layout/after_section_end', [$this, 'rs_sec_style_control'], 3);
		add_action('elementor/element/section/section_advanced/after_section_end', [$this, 'rs_sec_style_control'], 3);
		
	}

	public function rs_sec_style_control(Element_Base $section)
	{
		$tabs_field = Controls_Manager::TAB_CONTENT;

		if ('section' === $section->get_name()  || 'container' === $section->get_name()) {
			$tabs_field = Controls_Manager::TAB_LAYOUT;
		}

		$section->start_controls_section(
			'_section_rs_sec_style_control',
			[
				'label' => __('RS Section Style', 'rsaddon'),
				'tab'   => $tabs_field,
			]
		);

		$section->add_responsive_control(
			'rs_sec_blur',
			[
				'label' => esc_html__( 'Backdrop Blur', 'rsaddon' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 120,
					],
				],
				'selectors' => [
					'{{WRAPPER}}' => 'backdrop-filter: blur({{SIZE}}px) !important;',
				]
			]
		);

		$section->add_control(
			'rs_sec_highlight',
			[
				'label'     => __('Highlight', 'rsaddon'),
				'description'     => __('<strong>Highlight</strong> feature will add a class in this section on scroll & will do all actions based on the class.', 'rsaddon'),
				'type'      => Controls_Manager::SELECT,
				'label_block' => true,
				'prefix_class' => 'rs-',
				'options'   => [
					''			 	=> __('Disable', 'rsaddon'),
					'highlight' 	=> __('Enable', 'rsaddon')
				],
				'default'   => '',
				'render_type' => 'template'
			]
		);
		$section->add_control(
			'highlight_threshold',
			[
				'label' => esc_html__( 'Start Point', 'rsaddon' ),
				'type' => Controls_Manager::NUMBER,
				'min' => 0,
				'max' => 1,
				'step' => 0.1,
				'prefix_class' => 'threshold-',
				'condition' => [
					'rs_sec_highlight' => 'highlight'
				]
			]
		);
		$section->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'highlight_background',
				'types' => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}}.rs-highlight.in-view',
				'condition' => [
					'rs_sec_highlight' => 'highlight'
				]
			]
		);
		$section->add_responsive_control(
			'highlight_width',
			[
				'label' => esc_html__( 'Width', 'rsaddon' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}}.rs-highlight.in-view' => 'max-width: {{SIZE}}{{UNIT}} !important; width: 100% !important;',
				],
				'condition' => [
					'rs_sec_highlight' => 'highlight'
				]
			]
		);
		$section->add_responsive_control(
			'highlight_transition',
			[
				'label' => esc_html__( 'Transition', 'rsaddon' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 10,
						'step' => 0.1
					],
				],
				'selectors' => [
					'{{WRAPPER}}.rs-highlight' => 'transition: all {{SIZE}}s !important;',
				],
				'condition' => [
					'rs_sec_highlight' => 'highlight'
				]
			]
		);
		$section->add_responsive_control(
			'highlight_transition_delay',
			[
				'label' => esc_html__( 'Transition Delay', 'rsaddon' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 10,
						'step' => 0.1
					],
				],
				'selectors' => [
					'{{WRAPPER}}.rs-highlight' => 'transition-delay: {{SIZE}}s !important;',
				],
				'condition' => [
					'rs_sec_highlight' => 'highlight'
				]
			]
		);
		$section->add_control(
			'highlight_border_radius',
			[
				'label' => esc_html__( 'Border Radius', 'rsaddon' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'custom' ],
				'selectors' => [
					'{{WRAPPER}}.rs-highlight.in-view' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' => [
					'rs_sec_highlight' => 'highlight'
				]
			]
		);

		$section->end_controls_section();
	}

}

new RS_Exten_Sec_Style_Setting();
?>