<?php
/**
 * Team custom post type
 * This file is the basic custom post type for use any where in theme.
 * 
 * @author RS Theme
 * @link http://www.rstheme.com
 */
?>
<?php
class Rsaddon_Elementor_pro_career{	

	public function __construct() {
		add_action( 'init', array( $this, 'rs_career_register_post_type' ) );		
		add_action( 'init', array( $this, 'rs_create_career' ) );		
	}


	// Register Career Post Type
	function rs_career_register_post_type() {
		$labels = array(
			'name'               => esc_html__( 'Career', 'rsaddon'),
			'singular_name'      => esc_html__( 'Career', 'rsaddon'),
			'add_new'            => esc_html__( 'Add New Career', 'rsaddon'),
			'add_new_item'       => esc_html__( 'Add New Career', 'rsaddon'),
			'edit_item'          => esc_html__( 'Edit Career', 'rsaddon'),
			'new_item'           => esc_html__( 'New Career', 'rsaddon'),
			'all_items'          => esc_html__( 'All Career', 'rsaddon'),
			'view_item'          => esc_html__( 'View Career', 'rsaddon'),
			'search_items'       => esc_html__( 'Search Career', 'rsaddon'),
			'not_found'          => esc_html__( 'No Career found', 'rsaddon'),
			'not_found_in_trash' => esc_html__( 'No Career found in Trash', 'rsaddon'),
			'parent_item_colon'  => esc_html__( 'Parent Career:', 'rsaddon'),
			'menu_name'          => esc_html__( 'Career', 'rsaddon'),
		);

		$rstheme_career_slug = !empty(get_theme_mod('rstheme_career_slug')) ? get_theme_mod('rstheme_career_slug') : 'careers' ;
		$args = array(
			'labels'             => $labels,
			'public'             => true,	
			'show_in_menu'       => true,
			'show_in_admin_bar'  => true,
			'can_export'         => true,
			'has_archive'        => false,
			'hierarchical'       => false,
			'menu_position'      => 20,	
			'rewrite' => 		 array('slug' => $rstheme_career_slug,'with_front' => false),	
			'menu_icon'          =>  plugins_url( 'img/icon.png', __FILE__ ),
			'supports'           => array( 'title', 'thumbnail','editor','excerpt' ),		
		);
		register_post_type( 'careers', $args );
	}

	function rs_create_career() {
		$cat_taxonomy_label = !empty(get_theme_mod('rstheme_career_cat_taxonomy_title')) ? get_theme_mod('rstheme_career_cat_taxonomy_title') : 'Career Categories' ;
		$cat_slug = !empty(get_theme_mod('rstheme_career_cat_taxonomy_slug')) ? get_theme_mod('rstheme_career_cat_taxonomy_slug') : '' ;

		register_taxonomy(
			'career-category',
			'careers',
			array(
				'label' => esc_html__( $cat_taxonomy_label,'rsaddon'),				
				'hierarchical' => true,
				'show_admin_column' => true,
				'rewrite' =>  array('slug' => $cat_slug,'with_front' => false),
			)
		);
	}
}
new Rsaddon_Elementor_pro_career();