<?php
/**
 * Team custom post type
 * This file is the basic custom post type for use any where in theme.
 * 
 * @package rs
 * @author RS Theme
 * @link http://www.rstheme.com
 */
// Register Team Post Type
function rs_team_pro_register_post_type() {
	$labels = array(
		'name'               => esc_html__( 'Teams', 'rsaddon'),
		'singular_name'      => esc_html__( 'Team', 'rsaddon'),
		'add_new'            => esc_html_x( 'Add New Team', 'rsaddon'),
		'add_new_item'       => esc_html__( 'Add New Team', 'rsaddon'),
		'edit_item'          => esc_html__( 'Edit Team', 'rsaddon'),
		'new_item'           => esc_html__( 'New Team', 'rsaddon'),
		'all_items'          => esc_html__( 'All Team', 'rsaddon'),
		'view_item'          => esc_html__( 'View Team', 'rsaddon'),
		'search_items'       => esc_html__( 'Search Teams', 'rsaddon'),
		'not_found'          => esc_html__( 'No Teams found', 'rsaddon'),
		'not_found_in_trash' => esc_html__( 'No Teams found in Trash', 'rsaddon'),
		'parent_item_colon'  => esc_html__( 'Parent Team:', 'rsaddon'),
		'menu_name'          => esc_html__( 'Teams', 'rsaddon'),
	);	
	
	$rstheme_team_slug = !empty(get_theme_mod('rstheme_team_slug')) ? get_theme_mod('rstheme_team_slug') : 'teams' ;
	$args = array(
		'labels'             => $labels,
		'public'             => true,
		'publicly_queryable' => true,
		'show_in_menu'       => true,
		'show_in_admin_bar'  => true,
		'can_export'         => true,
		'has_archive'        => false,
		'hierarchical'       => false,
		'rewrite' => 		 array('slug' => $rstheme_team_slug,'with_front' => false),	
		'menu_position'      => 20,		
		'menu_icon'          =>  plugins_url( 'img/icon.png', __FILE__ ),
		'supports'           => array( 'title', 'thumbnail', 'editor', 'page-attributes' )
	);
	register_post_type( 'teams', $args );
}
add_action( 'init', 'rs_team_pro_register_post_type' );

function rsaddon_pro_tr_create_team() {
	$cat_taxonomy_label = !empty(get_theme_mod('rstheme_team_cat_taxonomy_title')) ? get_theme_mod('rstheme_team_cat_taxonomy_title') : 'Team Categories' ;
	$cat_slug = !empty(get_theme_mod('rstheme_team_cat_taxonomy_slug')) ? get_theme_mod('rstheme_team_cat_taxonomy_slug') : '' ;
	register_taxonomy(
		'teams-category',
		'teams',
		array(
			'label' => esc_html__( $cat_taxonomy_label,'rsaddon'),			
			'hierarchical' => true,
			'show_admin_column' => true,
			'rewrite'           => array(
				'slug' => $cat_slug,
				'with_front' => false,
			),
		)
	);
}
add_action( 'init', 'rsaddon_pro_tr_create_team' );

function rsaddon_pro_team_add_taxonomy_filters() {
	global $typenow;
 
	// an array of all the taxonomyies you want to display. Use the taxonomy name or slug
	$taxonomies = array('teams-category');
 
	// must set this to the post type you want the filter(s) displayed on
	if( $typenow == 'attorneys' ){
 			foreach ($taxonomies as $tax_slug) {
			$tax_obj = get_taxonomy($tax_slug);

			$tax_name = $tax_obj->labels->name;
			$terms = get_terms($tax_slug);		
			if(count($terms) > 0) {
				echo "<select name='$tax_slug' id='$tax_slug' class='postform'>";
				echo "<option value=''>Show All $tax_name</option>";
				foreach ($terms as $term) { 
					echo '<option value='. $term->slug.'>' . $term->name .' (' . $term->count .')</option>'; 
				}
				echo "</select>";
			}
		}
	}
}
add_action( 'restrict_manage_posts', 'rsaddon_pro_team_add_taxonomy_filters' );