<?php

/**
 * Elementor header offcanvas Widget jkjuiiugftyfytvhuj.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Image_Size;
use Elementor\Utils;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Icons_Manager;
use Elementor\Repeater;
use Elementor\Core\Kits\Documents\Tabs\Global_Typography;

defined('ABSPATH') || die();

class Rsaddon_Elementor_pro_Offcanvas_Widget extends \Elementor\Widget_Base
{


    /**
     * Get widget name.
     *
     * Retrieve rsgallery widget name.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name()
    {
        return 'rsoffcanvas';
    }

    /**
     * Get widget title.
     *
     * Retrieve rsgallery widget title.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title()
    {
        return esc_html__('RS Header Offcanvas', 'rsaddon');
    }

    /**
     * Get widget icon.
     *
     * Retrieve rsgallery widget icon.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon()
    {
        return 'rs-badge';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the rsgallery widget belongs to.
     *
     * @since 1.0.0
     * @access public
     *
     * @return array Widget categories.
     */
    public function get_categories()
    {
        return ['rsaddon_category'];
    }

    protected function register_controls(){
        $this->start_controls_section(
            'rs_offcanvas_header_offcanvas_section_tab_style',
            [
                'label' => esc_html__('Offcanvas', 'rsaddon'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
            $this->add_control(
                'canvas_icon',
                [
                    'label' => __('Icon', 'rsaddon'),
                    'type' => Controls_Manager::ICONS,
                    'default' => [
                        'value' => 'ri-menu-3-line',
                        'library' => 'reguler',
                    ],
                ]
            );
        $this->end_controls_section();

        $this->start_controls_section(
            '_section_g_style',
            [
                'label' => esc_html__('Style', 'rsaddon'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
            $this->add_responsive_control(
                'icon_size',
                [
                    'label' => esc_html__( 'Icon Size', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-offcanvas-area a.nav-expander svg' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
                        '{{WRAPPER}} .rs-offcanvas-area a.nav-expander i' => 'font-size: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'icon_wrapper_width',
                [
                    'label' => esc_html__( 'Width', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'vw', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-offcanvas-area a.nav-expander' => 'width: {{SIZE}}{{UNIT}}; text-align: center;',
                    ],
                ]
            );
            $this->add_responsive_control(
                'icon_wrapper_height',
                [
                    'label' => esc_html__( 'Height', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'vw', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-offcanvas-area a.nav-expander' => 'height: {{SIZE}}{{UNIT}}; display: flex; align-items: center; justify-content: center;',
                    ],
                ]
            );
            $this->add_responsive_control(
				'icon_wrapper_padding',
				[
					'label' => esc_html__( 'Padding', 'rsaddon' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .rs-offcanvas-area a.nav-expander' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
            $this->add_responsive_control(
				'icon_wrapper_radius',
				[
					'label' => esc_html__( 'Border Radius', 'rsaddon' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .rs-offcanvas-area a.nav-expander' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
            $this->start_controls_tabs(
                'icon_wrapper_style_tabs'
            );
                $this->start_controls_tab(
                    'icon_wrapper_style_normal_tab',
                    [
                        'label' => esc_html__( 'Normal', 'rsaddon' ),
                    ]
                );
                    $this->add_responsive_control(
                        'rs_offcanvas_offcanvas_icon_color',
                        [
                            'label' => esc_html__('Color', 'rsaddon'),
                            'type' => Controls_Manager::COLOR,
                            'default' => '',
                            'selectors' => [
                                '{{WRAPPER}} .rs-offcanvas-area .nav-expander i,
                                {{WRAPPER}} .rs-offcanvas-area .nav-expander svg path' => 'color: {{VALUE}}; fill: {{VALUE}};',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'icon_wrapper_background',
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .rs-offcanvas-area a.nav-expander',
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'icon_wrapper_border',
                            'selector' => '{{WRAPPER}} .rs-offcanvas-area a.nav-expander',
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Box_Shadow::get_type(),
                        [
                            'name' => 'icon_wrapper_box_shadow',
                            'selector' => '{{WRAPPER}} .rs-offcanvas-area a.nav-expander',
                        ]
                    );
                $this->end_controls_tab();

                $this->start_controls_tab(
                    'icon_wrapper_style_hover_tab',
                    [
                        'label' => esc_html__( 'Hover', 'rsaddon' ),
                    ]
                );
                    $this->add_responsive_control(
                        'rs_offcanvas_offcanvas_icon_color_hover',
                        [
                            'label' => esc_html__('Color (Hover)', 'rsaddon'),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .rs-offcanvas-area .nav-expander:hover i,
                                {{WRAPPER}} .rs-offcanvas-area .nav-expander:hover svg path' => 'color: {{VALUE}}; fill: {{VALUE}};',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'icon_wrapper_background_hover',
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .rs-offcanvas-area a.nav-expander:hover',
                        ]
                    );
                    $this->add_responsive_control(
                        'icon_wrapper_border_color_hover',
                        [
                            'label' => esc_html__('Border Color', 'rsaddon'),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .rs-offcanvas-area .nav-expander:hover' => 'border-color: {{VALUE}};',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Box_Shadow::get_type(),
                        [
                            'name' => 'icon_wrapper_box_shadow_hover',
                            'selector' => '{{WRAPPER}} .rs-offcanvas-area a.nav-expander:hover',
                        ]
                    );
                $this->end_controls_tab();
            $this->end_controls_tabs();
        $this->end_controls_section();
    }


    protected function render()
    {
        $this->render_raw();
    }

    protected function render_raw()
    {
        $settings = $this->get_settings();
    ?>
    <div class="rs-offcanvas-area">
        <ul>
            <li class="nav-link pr-20">
                <a class="nav-expander">
                    <?php \Elementor\Icons_Manager::render_icon($settings['canvas_icon'], ['aria-hidden' => 'true']); ?>
                </a>
            </li>
        </ul>            
    </div>

<?php
    }
}
