<?php
use Elementor\Control_Media;
?>
<div class="swiper-slide item-<?php echo esc_attr($slideItem); ?> elementor-repeater-item-<?php echo esc_attr( $item['_id'] ); ?>">
    <?php if ('rs-e-container' === $container) { ?>
        <div class="<?php echo esc_attr( $container ); ?>">
    <?php } ?>
    
    <div class="slider-inner  <?php echo esc_attr( $clip_path_enable ); ?>">
        <div class="content-part">
            <?php if (!empty($subTitle)) { ?>
                <div class="sub-title <?php echo esc_attr($subAnimInit); ?>" <?php echo esc_attr($subTitleAnimationTiming); ?>><?php echo wp_kses_post($subTitle); ?></div>
            <?php }

            if (!empty($title)) { ?>
                <<?php echo esc_html($settings['title_tag']); ?> class="title <?php echo esc_attr($titleAnimInit); ?>" <?php echo esc_attr($titleAnimationTiming); ?>><?php echo wp_kses_post($title); ?></<?php echo esc_html($settings['title_tag']); ?>>
            <?php }
            
            if (!empty($description)) { ?>
                <div class="description <?php echo esc_attr($descAnimInit); ?>" <?php echo esc_attr($descAnimationTiming); ?>><?php echo wp_kses_post($description); ?></div>
            <?php }
            
            if ((!empty($btn_txt) || !empty($btn_txt2)) && ('yes' === $settings['show_btns'])) { ?>
                <div class="btn-wrapper">
                    <?php if (!empty($btn_txt)) { ?>
                        <a class="first-btn <?php echo esc_attr($btnOneAnimInit); ?>" href="<?php echo esc_url($btn_link); ?>" <?php echo esc_attr($btnOneAnimationTiming); ?>><?php echo esc_html($btn_txt); ?> <?php \Elementor\Icons_Manager::render_icon($item['btn_icon'], ['aria-hidden' => 'true']); ?></a>
                    <?php }
                    if (!empty($btn_txt2)) { ?>
                        <a class="second-btn <?php echo esc_attr($btnTwoAnimInit); ?>" href="<?php echo esc_url($btn_link2); ?>" <?php echo esc_attr($btnOneAnimationTiming); ?>><?php echo esc_html($btn_txt2); ?> <?php \Elementor\Icons_Manager::render_icon($item['btn_icon2'], ['aria-hidden' => 'true']); ?></a>
                    <?php } ?>
                </div>
            <?php } ?>
        </div>
        <?php if (!empty($item['layer_image']['id'])) {?>
            <div class="image-part">
                <img class="<?php echo esc_attr($imgAnimInit); ?>" src="<?php echo esc_url($layer_image); ?>" alt="<?php echo esc_attr(Control_Media::get_image_alt($item['layer_image'])); ?>" <?php echo esc_attr($imgAnimationTiming); ?>>
            </div>
        <?php } ?>
    </div>

    <?php if ('rs-e-container' === $container) { ?>
        </div>
    <?php } ?>
</div>