<?php
/**
 * Image hover widget class
 *
 */
use Elementor\Group_Control_Text_Shadow;
use Elementor\Repeater;
use Elementor\Utils;
use Elementor\Control_Media;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Image_Size;


defined( 'ABSPATH' ) || die();

class Rsaddon_pro_Image_Animation_Effect_Widget extends \Elementor\Widget_Base {
    /**
     * Get widget name.
     *
     * Retrieve rsgallery widget name.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget name.
     */

    public function get_name() {
        return 'rs-image-shabe-animation-effect';
    }

    /**
     * Get widget title.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget title.
     */

    public function get_title() {
        return esc_html__( 'RS Image Animation Shape', 'rsaddon' );
    }

    /**
     * Get widget icon.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'rs-badge';
    }


    public function get_categories() {
        return [ 'rsaddon_category' ];
    }

    public function get_keywords() {
        return ['image', 'animation', 'effect'];
    }

    protected function register_controls() {

        $this->start_controls_section(
            '_section_image_content',
            [
                'label' => esc_html__( 'Image Settings', 'rsaddon' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        ); 
        $this->add_control(
            'image_style',
            [
                'label'   => esc_html__( 'Select Style', 'rsaddon' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'style1',
                'options' => [                  
                    'style1' => esc_html__( 'Style 1', 'rsaddon'),
                    'style2' => esc_html__( 'Style 2', 'rsaddon'),
                    'style3' => esc_html__( 'Style 3', 'rsaddon'),
                    'style4' => esc_html__( 'Style 4', 'rsaddon'),
                ],
            ]
        );
        $this->add_responsive_control(
            'wave_number',
            [
                'label'       => esc_html__( 'Sound Wave Number', 'rsaddon' ),
                'type'        => Controls_Manager::NUMBER,
                'default'     => 50,
                'placeholder' => esc_html__( '50', 'rsaddon' ),
                'condition' => [
                    'image_style' => 'style4'
                ]
            ]
        );
        $this->add_control(
            'wave_number_randomizer',
            [
                'label'       => esc_html__( 'Wave Randomizer', 'rsaddon' ),
                'type'        => Controls_Manager::NUMBER,
                'default'     => 5,
                'placeholder' => esc_html__( '5', 'rsaddon' ),
                'condition' => [
                    'image_style' => 'style4'
                ]
            ]
        );
        $this->add_control(
            'sound_wave_style',
            [
                'label'   => esc_html__( 'Sound Wave Style', 'rsaddon' ),
                'type'    => Controls_Manager::SELECT,
                'default' => '',
                'options' => [                  
                    '' => esc_html__( 'Default', 'rsaddon'),
                    'vartical' => esc_html__( 'Vartical', 'rsaddon'),
                ],
            ]
        );
            
        $this->add_control(
            'parent_anim',
            [
                'label'   => esc_html__( 'Wrapper Animation', 'rsaddon' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'disable',
                'separator' => 'before',
                'options' => [                  
                    'morpheneanim' => esc_html__( 'Enable', 'rsaddon'),
                    'disable' => esc_html__( 'Disable', 'rsaddon'),
                ],
                'condition' => [
                    'image_style!' => 'style4',
                ],
            ]
        );

        $this->add_responsive_control(
            'align',
            [
                'label' => esc_html__( 'Alignment', 'rsaddon' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__( 'Left', 'rsaddon' ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'rsaddon' ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', 'rsaddon' ),
                        'icon' => 'eicon-text-align-right',
                    ],
                    'justify' => [
                        'title' => esc_html__( 'Justify', 'rsaddon' ),
                        'icon' => 'eicon-text-align-justify',
                    ],
                ],
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .rs-animation-shape-image .middle-image' => 'text-align: {{VALUE}}'
                ],
                'separator' => 'before',
                'condition' => [
                    'image_style!' => 'style4',
                ],
            ]
        );


        $this->add_control(
            'morphine_wrap_image',
            [
                'label' => esc_html__( 'Morphine Image', 'rsaddon' ),
                'type' => \Elementor\Controls_Manager::MEDIA, 
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],    
                'separator' => 'before',
                'condition' => [
                    'image_style' => 'style3',
                ],
            ]
        );

        $this->add_control(
            'left_shape_image',
            [
                'label' => esc_html__( 'Shape Image One', 'rsaddon' ),
                'type' => \Elementor\Controls_Manager::MEDIA, 
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],    
                'separator' => 'before',
                'condition' => [
                    'image_style!' => ['style3','style4'],
                ],
            ]
        );

        $this->add_control(
            'middle_image',
            [
                'label' => esc_html__( 'Middle Image', 'rsaddon' ),
                'type' => \Elementor\Controls_Manager::MEDIA, 
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],    
                'separator' => 'before',

                'condition' => [
                    'image_style' => 'style1',
                ],
            ]
        );

        $this->add_control(
            'right_shape_image',
            [
                'label' => esc_html__( 'Shape Image Two', 'rsaddon' ),
                'type' => \Elementor\Controls_Manager::MEDIA, 
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],    
                'separator' => 'before',
                'condition' => [
                    'image_style!' => ['style3','style4'],
                ],
            ]
        );

        $this->end_controls_section();

        // Sound Wave Style Control
        $this->start_controls_section(
            'sound_wave_animation_style',
            [
                'label' => esc_html__( 'Sound Wave Animation Style', 'rsaddon' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'image_style' => 'style4'
                ],
            ]
        );
		$this->add_responsive_control(
            'swa_wrapper_vertical_align',
            [
                'label' => esc_html__( 'Vertical Align', 'rsaddon' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'flex-start' => [
                        'title' => esc_html__( 'Top', 'rsaddon' ),
                        'icon' => 'eicon-align-start-v',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Middle', 'rsaddon' ),
                        'icon' => 'eicon-align-center-v',
                    ],
                    'flex-end' => [
                        'title' => esc_html__( 'Bottom', 'rsaddon' ),
                        'icon' => 'eicon-align-end-v',
                    ],
                ],
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .rs-sound-waves' => 'align-items: {{VALUE}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'swa_wrapper_column_align',
            [
                'label' => esc_html__( 'Column Direction', 'rsaddon' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'row' => [
                        'title' => esc_html__( 'Row', 'rsaddon' ),
                        'icon' => 'eicon-justify-start-h',
                    ],
                    'column' => [
                        'title' => esc_html__( 'Column', 'rsaddon' ),
                        'icon' => 'eicon-justify-start-v',
                    ],
                ],
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .rs-sound-waves' => 'flex-direction: {{VALUE}};',
                ],
            ]
        );
		$this->add_responsive_control(
            'swa_wrapper_h_align',
            [
                'label' => esc_html__( 'Horizontal Align', 'rsaddon' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'flex-start' => [
                        'title' => esc_html__( 'Start', 'rsaddon' ),
                        'icon' => 'eicon-align-start-h',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'rsaddon' ),
                        'icon' => 'eicon-align-center-h',
                    ],
                    'flex-end' => [
                        'title' => esc_html__( 'End', 'rsaddon' ),
                        'icon' => 'eicon-align-end-h',
                    ],
                    'space-between' => [
                        'title' => esc_html__( 'Space Between', 'rsaddon' ),
                        'icon' => 'eicon-justify-space-between-h',
                    ],

                ],
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .rs-sound-waves' => 'justify-content: {{VALUE}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'waves_transform_x',
            [
                'label'      => esc_html__( 'Waves Line Scale X', 'rsaddon' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => [ 'px','custom' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 5,
                        'step' => 0.1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .rs-sound-waves' => 'transform: scaleX({{SIZE}});',
                ],
            ]
        );
        $this->add_responsive_control(
            'waves_transform_y',
            [
                'label'      => esc_html__( 'Waves Line Scale Y', 'rsaddon' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => [ 'px','custom' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 5,
                        'step' => 0.1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .rs-sound-waves' => 'transform: scaleY({{SIZE}});',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 's_w_a_bg',
                'label' => esc_html__( 'Background Color', 'rsaddon' ),
                'separator' => 'before',
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .rs-sound-waves .bars',
                
            ]
        );
        $this->add_responsive_control(
            'swa_wrapper_height',
            [
                'label'      => esc_html__( 'Wave Wrapper Height', 'rsaddon' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%','custom' ],
                'range' => [
                    '%' => [
                        'min' => 0,
                        'max' => 500,
                    ],
                    'px' => [
                        'min' => -100,
                        'max' => 500,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .rs-sound-waves' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'swa_wrapper_width',
            [
                'label'      => esc_html__( 'Wave Wrapper Width', 'rsaddon' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%','custom' ],
                'range' => [
                    '%' => [
                        'min' => 0,
                        'max' => 500,
                    ],
                    'px' => [
                        'min' => -100,
                        'max' => 500,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .rs-sound-waves' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'swa_bar_width',
            [
                'label'      => esc_html__( 'Wave Width', 'rsaddon' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%','custom' ],
                'range' => [
                    '%' => [
                        'min' => 0,
                        'max' => 500,
                    ],
                    'px' => [
                        'min' => -100,
                        'max' => 500,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .rs-sound-waves .bars' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'swa_bar_height',
            [
                'label'      => esc_html__( 'Wave Height', 'rsaddon' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%','custom' ],
                'range' => [
                    '%' => [
                        'min' => 0,
                        'max' => 500,
                    ],
                    'px' => [
                        'min' => -100,
                        'max' => 500,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .rs-sound-waves .bars' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'swa_bar_gap',
            [
                'label'      => esc_html__( 'Wave Gap', 'rsaddon' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%','custom' ],
                'range' => [
                    '%' => [
                        'min' => 0,
                        'max' => 500,
                    ],
                    'px' => [
                        'min' => -100,
                        'max' => 500,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .rs-sound-waves' => 'gap: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'morphine_title',
            [
                'label' => esc_html__( 'Morphine Image Effect', 'rsaddon' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'image_style' => 'style3'
                ],
            ]
        );

        $this->add_responsive_control(
            'morph_image_width',
            [
                'label'      => esc_html__( 'Image Width', 'rsaddon' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .morphine-wrap img' => 'width: {{SIZE}}{{UNIT}};',
                ],
                'separator' => 'before',
            ]
        );

        $this->add_responsive_control(
            'morph_image_height',
            [
                'label'      => esc_html__( 'Image Height', 'rsaddon' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .morphine-wrap img' => 'height: {{SIZE}}{{UNIT}};',
                ],
                'separator' => 'before',
            ]
        );

        $this->add_responsive_control(
			'morph_image_padding',
			[
				'label' => esc_html__( 'Padding', 'elementor' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors' => [
					'{{WRAPPER}} .morphine-wrap img' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'morph_image_margin',
			[
				'label' => esc_html__( 'Margin', 'elementor' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors' => [
					'{{WRAPPER}} .morphine-wrap img' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'morph_color_gradient_bg',
                'label' => esc_html__( 'Gradient Color', 'rsaddon' ),
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .morphine-wrap img',
                
            ]
        );

        // Wrapper
        $this->add_responsive_control(
			'morph_wrapper_title',
			[
				'label' => esc_html__( 'Warpper', 'elementor' ),
				'type' => Controls_Manager::HEADING,
                'separator' => 'before',
                'classes' => 'rs-control-type-heading',
			]
		);

        $this->add_responsive_control(
			'morph_wrapper_image_padding',
			[
				'label' => esc_html__( 'Padding', 'elementor' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors' => [
					'{{WRAPPER}} .morphine-wrap' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'morph_wrapper_image_margin',
			[
				'label' => esc_html__( 'Margin', 'elementor' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors' => [
					'{{WRAPPER}} .morphine-wrap' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'morph_wrapper_image_radius',
			[
				'label' => esc_html__( 'Radius', 'elementor' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .morphine-wrap' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'morph_wrapper_color_gradient_bg',
                'label' => esc_html__( 'Gradient Color', 'rsaddon' ),
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .morphine-wrap',
                
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'shape_one_title',
            [
                'label' => esc_html__( 'Shape Image One', 'rsaddon' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'image_style!' => ['style3','style4'],
                ],
            ]
        );

        $this->add_responsive_control(
            'shape_one_position',
            [
                'label'      => esc_html__( 'Image Left/Right Position', 'rsaddon' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    '%' => [
                        'min' => 0,
                        'max' => 500,
                    ],
                    'px' => [
                        'min' => -100,
                        'max' => 500,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .rs-animation-shape-image .pattern' => 'left: {{SIZE}}{{UNIT}};',
                ],
                'separator' => 'before',
            ]
        ); 

        $this->add_responsive_control(
            'shape_one_position_top',
            [
                'label'      => esc_html__( 'Image Top/Bottom Position', 'rsaddon' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    '%' => [
                        'min' => 0,
                        'max' => 500,
                    ],
                    'px' => [
                        'min' => -100,
                        'max' => 500,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .rs-animation-shape-image .pattern' => 'top: {{SIZE}}{{UNIT}};',
                ],
                'separator' => 'before',
            ]
        ); 
        $this->add_control(
            'background_hover_transition',
            [
                'label' => __( 'Transition Duration', 'elementor' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'max' => 10,
                        'step' => 0.1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .rs-animation-shape-image .scale2' => 'animation: scale2 {{SIZE}}s alternate infinite',
                ],
            ]
        );

        $this->add_responsive_control(
            'shape_position_top',
            [
                'label'      => esc_html__( 'Shape Top/Bottom Position', 'rsaddon' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    '%' => [
                        'min' => -100,
                        'max' => 100,
                    ],
                    'px' => [
                        'min' => -500,
                        'max' => 500,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .wave-wrap' => 'top: {{SIZE}}{{UNIT}};',
                ],
                'separator' => 'before',
            ]
        );

        $this->add_responsive_control(
            'shape_height',
            [
                'label' => esc_html__( 'Height', 'rsaddon' ),
                'type' => Controls_Manager::TEXT,
                'size_units' => [ 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .wave-wrap' => 'height: {{SIZE}}px;',
                ],
                'condition' => [
                    'image_style' => 'style2'
                ],
                'separator' => 'before',
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'shape_two_title',
            [
                'label' => esc_html__( 'Shape Image Two', 'rsaddon' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'image_style!' => ['style3','style4']
                ],
            ]
        );
        $this->add_responsive_control(
            'shape_two_position',
            [
                'label'      => esc_html__( 'Image Left/Right Position', 'rsaddon' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    '%' => [
                        'min' => 0,
                        'max' => 500,
                    ],
                    'px' => [
                        'min' => -100,
                        'max' => 500,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .rs-animation-shape-image .shape' => 'left: {{SIZE}}{{UNIT}};',
                ],
                'separator' => 'before',
            ]
        ); 

        $this->add_responsive_control(
            'shape_two_position_top',
            [
                'label'      => esc_html__( 'Image Top/Bottom Position', 'rsaddon' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    '%' => [
                        'min' => 0,
                        'max' => 500,
                    ],
                    'px' => [
                        'min' => -100,
                        'max' => 500,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .rs-animation-shape-image .shape' => 'top: {{SIZE}}{{UNIT}};',
                ],
                'separator' => 'before',
            ]
        ); 
        $this->add_control(
            'background_hover_transition2',
            [
                'label' => __( 'Transition Duration', 'elementor' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'max' => 10,
                        'step' => 0.1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .rs-animation-shape-image .dance' => 'animation: scale2 {{SIZE}}s alternate infinite',
                ],
            ]
        );
        $this->end_controls_section();

        
        
    }

    protected function render() {

        $settings = $this->get_settings_for_display(); 
        $unique = rand(2012, 35120); ?>

        <?php if('style3' == $settings['image_style']){ ?>
            <?php if(!empty($settings['morphine_wrap_image']['url'])) :?>
                <div class="morphine-wrap parent-<?php echo esc_attr( $settings['parent_anim'] ); ?>">
                    <img src="<?php echo esc_url( $settings['morphine_wrap_image']['url'] );?>" alt="image"/>
                </div>
            <?php endif;?>
        <?php } ?>

        <?php if('style2' == $settings['image_style'] && 'style3' !== $settings['image_style']){ ?>
            <div class="wave-wrap wave-anim rs-amimation-shape">
                <div class="wave-inner bgone">
                    <div class="wave waveone" style="background: url(<?php echo esc_url( $settings['left_shape_image']['url'] );?>);"></div>
                </div>
                <div class="wave-inner bgtwo">
                    <div class="wave wavetwo" style="background: url(<?php echo esc_url( $settings['right_shape_image']['url'] );?>);"></div>
                </div>
            </div>
        <?php } elseif('style1' == $settings['image_style']) { ?>
        <div class="rs-animation-shape-image">
            <?php if(!empty($settings['left_shape_image']['url'])) :?>
                <div class="pattern">
                    <img class="scale2" src="<?php echo esc_url( $settings['left_shape_image']['url'] );?>" alt="image"/>
                </div>
            <?php endif;?>
            <?php if(!empty($settings['middle_image']['url'])) :?>
                <div class="middle-image">
                    <img src="<?php echo esc_url( $settings['middle_image']['url'] );?>" alt="image"/>
                </div>
            <?php endif;?>
            <?php if(!empty($settings['right_shape_image']['url'])) :?>
                <div class="shape">
                    <img class="dance" src="<?php echo esc_url( $settings['right_shape_image']['url'] );?>" alt="image"/>
                </div>
            <?php endif;?>
        </div>  
        <?php }elseif('style4' == $settings['image_style']){ ?>
            
            <!--Rs dynamic waves bar  -->
            <div class='rs-sound-waves sound-waves-<?php echo esc_attr($unique); ?> <?php echo esc_attr($settings['sound_wave_style']); ?>'></div>
            
            <script type="text/javascript">
                jQuery(document).ready(function ($) {
                    var $soundWaves = $('.sound-waves-<?php echo esc_attr($unique); ?>');
                    var numberOfBars = <?php echo esc_html($settings['wave_number']); ?>;
                    var randomizer = <?php echo esc_html($settings['wave_number_randomizer']); ?>;

                    $soundWaves.find('.bars').remove();
                    for (var i = 0; i < numberOfBars; i++) {
                        var $bars = $('<i class="bars"></i>');
                        $soundWaves.append($bars);
                    }

                    var baseDuration = 0.7;
                    for (var i = 2; i <= numberOfBars; i++) {
                        $('.bars:nth-child(' + i + ')').css('animation-duration', ( baseDuration + (i % randomizer * 0.2)) + 's');
                    }
                });
            </script>

        <?php } ?>
    
    <?php
    }
}