<?php
/**
 * Latest Blog Slider Widget.
 *
 * Prelements Elementor widget that retrieve all blog post into slider style.
 *
 * @since 1.0.0
*/
use Elementor\Group_Control_Css_Filter;
use Elementor\Repeater;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Icons_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Background;
use Elementor\Utils;


defined( 'ABSPATH' ) || die();

class Rsaddon_Elementor_Pro_latest_Blog_Slider_Widget extends \Elementor\Widget_Base {

    /**
     * Get widget name.
     *
     * Retrieve Prelements Blog Slider widget name.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name() {
        return 'prelements-blog-slider';
    }       

    /**
     * Get widget title.
     *
     * Retrieve Prelements Blog Slider widget title.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title() {
        return esc_html__( 'RS Latest Blog Slider', 'rsaddon' );
    }

    /**
     * Get widget icon.
     *
     * Retrieve Prelements Blog Slider widget icon.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'rs-badge';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Prelements Blog Slider widget belongs to.
     *
     * @since 1.0.0
     * @access public
     *
     * @return array Widget categories.
     */
    public function get_categories() {
        return [ 'rsaddon_category' ];
    }

    /**
     * Register Prelements Blog Slider widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls() {       

        $category_dropdown[0] = 'Select Category';
        
        $terms  = get_terms(
            array(
                'taxonomy' => "category",
                'fields' => 'id=>name'
            )
        );       
        foreach ( $terms as $id => $name ) {
            $category_dropdown[$id] = $name;
        } 

        $post_dropdown[0] = 'Select Post';
        $prelements_query = new wp_Query(array(
            'post_type'      => 'post',
            'posts_per_page' => '-1',                                         
        )); 

        if ( $prelements_query->have_posts() ):
            while($prelements_query->have_posts()): $prelements_query->the_post();       
                $id    = get_the_ID($prelements_query->ID);
                $title = get_the_title($prelements_query->ID);
                $post_dropdown[$id] = $title;
            endwhile;
            wp_reset_query(); 
        endif;  

       
        //Default Settings Here
        $this->start_controls_section(
            '_section_settings',
            [
                'label' => esc_html__( 'Default Settings', 'rsaddon' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
            $this->add_control(
                'latest_blog_slider_style',
                [
                    'label'   => esc_html__( 'Select Style', 'rsaddon' ),
                    'type'    => Controls_Manager::SELECT,
                    'default' => 'style1',              
                    'options' => [
                        'style1' => 'Style 1',
                        'style2' => 'Style 2'
                    ],
                ]
            );

            $this->add_control(
                'widget_type_grid_slider',
                [
                    'label'   => esc_html__('Select Type (Slider/Grid)', 'rsaddon'),
                    'type'    => Controls_Manager::SELECT,
                    'default' => 'slider',
                    'options' => [
                        'slider' => 'Slider',
                        'grid' => 'Grid'
                    ],
                ]
            );
            
            $this->add_control(
                'pre_blog_posts_is_manual_selection',
                [
                    'label' => esc_html__( 'Select posts by:', 'rsaddon' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => '',
                    'options' => [
                        'recent'    => esc_html__( 'Recent Post', 'rsaddon' ),
                        'yes'       => esc_html__( 'Selected Post', 'rsaddon' ),
                        ''        => esc_html__( 'Category Post', 'rsaddon' ),
                    ],
                ]
            );
            $this->add_control(
                'category',
                [
                    'label'   => esc_html__( 'Category', 'rsaddon' ),
                    'type'    => Controls_Manager::SELECT2, 
                    'default' => 0,                 
                    'options' => $this->getCategories(),
                    'multiple' => true, 
                    'condition' => [ 'pre_blog_posts_is_manual_selection' => '' ],      
                ]
            );
            $this->add_control(
                'select_posts',
                [
                    'label'   => esc_html__( 'Select Posts', 'rsaddon' ),
                    'type'    => Controls_Manager::SELECT2, 
                    'default' => 0,         
                    'options' => [      
                            
                    ]+ $post_dropdown,
                    'multiple' => true, 
                    'condition' => [ 'pre_blog_posts_is_manual_selection' => 'yes' ],      
                ]
            );

            $this->add_control(
                'pre_blog_posts_offset',
                [
                    'label'     => esc_html__( 'Offset', 'rsaddon' ),
                    'type'      => Controls_Manager::NUMBER,
                    'min'       => 0,
                    'max'       => 20,
                ]
            );

            $this->add_control(
                'pre_posts_order_by',
                [
                    'label'   => esc_html__( 'Order by', 'rsaddon' ),
                    'type'    => Controls_Manager::SELECT,
                    'options' => [
                        'date'          => esc_html__( 'Date', 'rsaddon' ),
                        'title'         => esc_html__( 'Title', 'rsaddon' ),
                        'author'        => esc_html__( 'Author', 'rsaddon' ),
                        'modified'      => esc_html__( 'Modified', 'rsaddon' ),
                        'comment_count' => esc_html__( 'Comments', 'rsaddon' ),
                    ],
                    'default' => 'date',
                ]
            );

            $this->add_control(
                'pre_posts_sort',
                [
                    'label'   => esc_html__( 'Order', 'rsaddon' ),
                    'type'    => Controls_Manager::SELECT,
                    'options' => [
                        'ASC'  => esc_html__( 'ASC', 'rsaddon' ),
                        'DESC' => esc_html__( 'DESC', 'rsaddon' ),
                    ],
                    'default' => 'DESC',
                ]
            );

            $this->add_control(
                'per_page',
                [
                    'label' => esc_html__( 'Item Limit', 'rsaddon' ),
                    'type' => Controls_Manager::NUMBER,
                    'dynamic' => [ 'active' => true ],
                    'default' => esc_html__( '6', 'rsaddon' ),
                    'condition' => [ 'pre_blog_posts_is_manual_selection!' => 'yes' ], 
                ]
            );
            $this->add_control(
                'show_grid_pagination',
                [
                    'label' => esc_html__( 'Show Pagination', 'rsaddon' ),
                    'type' => Controls_Manager::SWITCHER,
                    'label_on' => esc_html__( 'Show', 'rsaddon' ),
                    'label_off' => esc_html__( 'Hide', 'rsaddon' ),
                    'return_value' => 'yes',
                    'default' => 'no',
                    'condition' => [
                        'widget_type_grid_slider' => 'grid'
                    ]
                ]
            );
            $this->add_control(
                'show_cursor_label',
                [
                    'label' => esc_html__( 'Show Cursor Label', 'rsaddon' ),
                    'type' => Controls_Manager::SWITCHER,
                    'label_on' => esc_html__( 'Show', 'rsaddon' ),
                    'label_off' => esc_html__( 'Hide', 'rsaddon' ),
                    'return_value' => 'yes',
                    'default' => 'no',
                    'separator' => 'before'
                ]
            );
            $this->add_control(
                'show_cursor_label_txt',
                [
                    'label' => esc_html__( 'Label Text', 'rsaddon' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => esc_html__( 'Drag', 'rsaddon' ),
                    'placeholder' => esc_html__( 'Type the label here', 'rsaddon' ),
                    'condition' => [
                        'show_cursor_label' => 'yes'
                    ]
                ]
            );
        $this->end_controls_section();


         //Thumbnail Settings Here
        $this->start_controls_section(
            '_images_settings',
            [
                'label' => esc_html__( 'Thumbnail Settings', 'rsaddon' ),
            ]
        );
            $this->add_control(
                'blog_image_show_hide',
                [
                    'label' => esc_html__( 'Show Thumbnail', 'rsaddon' ),
                    'type' => Controls_Manager::SWITCHER,
                    'default' => 'yes',
                    'options' => [
                        'label_on' => esc_html__( 'Show', 'rsaddon' ),
                        'label_off' => esc_html__( 'Hide', 'rsaddon' ),
                    ],                
                ]
            );

            $this->add_group_control(
                Group_Control_Image_Size::get_type(),
                [
                    'name' => 'thumbnail',
                    'default' => 'large',
                    'separator' => 'before',
                    'exclude' => [
                        'custom'
                    ],
                    'condition' => [
                        'blog_image_show_hide' => 'yes',
                    ],
                ]
            );

        $this->end_controls_section();


        //Title Settings Here
        $this->start_controls_section(
            '_title_settings',
            [
                'label' => esc_html__( 'Title Settings', 'rsaddon' ),
            ]
        );
            $this->add_control(
                'blog_title_show_hide',
                [
                    'label' => esc_html__( 'Title', 'rsaddon' ),
                    'type' => Controls_Manager::SWITCHER,
                    'default' => 'yes',
                    'options' => [
                        'label_on' => esc_html__( 'Show', 'rsaddon' ),
                        'label_off' => esc_html__( 'Hide', 'rsaddon' ),
                    ],                
                ]
            );
            $this->add_control(
                'title_tag',
                [
                    'label'   => esc_html__('Select Title Tag', 'rsaddon'),
                    'type'    => Controls_Manager::SELECT,
                    'default' => 'h4',
                    'options' => [
                        'h1' => esc_html__('H1', 'rsaddon'),
                        'h2' => esc_html__('H2', 'rsaddon'),
                        'h3' => esc_html__('H3', 'rsaddon'),
                        'h4' => esc_html__('H4', 'rsaddon'),
                        'h5' => esc_html__('H5', 'rsaddon'),
                        'h6' => esc_html__('H6', 'rsaddon'),
                        'div' => esc_html__('div', 'rsaddon'),
                        'p' => esc_html__('p', 'rsaddon'),
                    ],
                    'condition' => [
                        'blog_title_show_hide' => 'yes',
                    ]
                ]
            );
            $this->add_control(
                'blog_title_word_show',
                [
                    'label' => esc_html__( 'Word Limit', 'rsaddon' ),
                    'type' => Controls_Manager::TEXT,
                    'placeholder' => esc_html__( '200', 'rsaddon' ),
                    'condition' => [
                        'blog_title_show_hide' => 'yes',
                    ]
                ]
            );
        $this->end_controls_section();

        //Meta Settings Here
        $this->start_controls_section(
            '_meta_settings',
            [
                'label' => esc_html__( 'Meta Settings', 'rsaddon' ),
            ]
        );
            $this->add_control(
                'blog_meta_show_hide',
                [
                    'label' => esc_html__( 'Show Meta', 'rsaddon' ),
                    'type' => Controls_Manager::SWITCHER,
                    'default' => 'yes',
                    'options' => [
                        'label_on' => esc_html__( 'Show', 'rsaddon' ),
                        'label_off' => esc_html__( 'Hide', 'rsaddon' ),
                    ],                
                ]
            );
            $this->add_control(
                'clip_path',
                [
                    'label' => esc_html__('Clip Path ON/OFF?', 'rsaddon'),
                    'type' => \Elementor\Controls_Manager::SWITCHER,
                    'label_on' => esc_html__('Show', 'rsaddon'),
                    'label_off' => esc_html__('Hide', 'rsaddon'),
                    'return_value' => 'yes',
                    'default' => 'no',
                    'condition' => ['latest_blog_slider_style' => 'style1']
                ]
            );
            $this->add_control(
                'blog_meta_author_show_hide',
                [
                    'label' => esc_html__( 'Show Author', 'rsaddon' ),
                    'type' => Controls_Manager::SWITCHER,
                    'default' => 'yes',
                    'options' => [
                        'label_on' => esc_html__( 'Show', 'rsaddon' ),
                        'label_off' => esc_html__( 'Hide', 'rsaddon' ),
                    ],
                    'separator' => 'before',
                    'condition' => [
                        'blog_meta_show_hide' => 'yes'
                    ]
                ]
            );
            $this->add_control(
                'author_img_show',
                [
                    'label' => esc_html__( 'Show Author Avatar', 'rsaddon' ),
                    'type' => Controls_Manager::SWITCHER,
                    'default' => 'yes',
                    'options' => [
                        'label_on' => esc_html__( 'Show', 'rsaddon' ),
                        'label_off' => esc_html__( 'Hide', 'rsaddon' ),
                    ],
                    'condition' => [
                        'blog_meta_show_hide' => 'yes',
                        'blog_meta_author_show_hide' => 'yes',
                    ]
                ]
            );
            $this->add_control(
                'author_sub_text',
                [
                    'label' => esc_html__( 'Author sub-text', 'rsaddon' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => esc_html__( 'By', 'rsaddon' ),
                    'placeholder' => esc_html__( 'Sub Text (e.g. By)', 'rsaddon' ),
                    'condition' => [
                        'blog_meta_author_show_hide' => 'yes',
                        'blog_meta_show_hide' => 'yes'
                    ]
                ]
            );
            $this->add_control(
                'blog_meta_author_position',
                [
                    'label' => esc_html__( 'Position of Author', 'rsaddon' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => 'author_p_default',
                    'options' => [
                        'author_p_default' => esc_html__( 'Default', 'rsaddon' ),
                        'author_p_bottom' => esc_html__( 'Bottom', 'rsaddon' ),
                    ],
                    'condition' => [
                        'blog_meta_author_show_hide' => 'yes',
                        'blog_meta_show_hide' => 'yes'
                    ]
                ]
            );
            $this->add_control(
                'blog_meta_comment_show_hide',
                [
                    'label' => esc_html__( 'Show Comment', 'rsaddon' ),
                    'type' => Controls_Manager::SWITCHER,
                    'default' => 'no',
                    'options' => [
                        'label_on' => esc_html__( 'Show', 'rsaddon' ),
                        'label_off' => esc_html__( 'Hide', 'rsaddon' ),
                    ],
                    'separator' => 'before',
                    'condition' => [
                        'blog_meta_show_hide' => 'yes'
                    ]
                ]
            );
            $this->add_control(
                'blog_meta_date_show_hide',
                [
                    'label' => esc_html__( 'Show Date', 'rsaddon' ),
                    'type' => Controls_Manager::SWITCHER,
                    'default' => 'yes',
                    'options' => [
                        'label_on' => esc_html__( 'Show', 'rsaddon' ),
                        'label_off' => esc_html__( 'Hide', 'rsaddon' ),
                    ],
                    'separator' => 'before',
                    'condition' => [
                        'blog_meta_show_hide' => 'yes'
                    ]
                ]
            );
            $this->add_control(
                'blog_meta_date_position',
                [
                    'label' => esc_html__( 'Date Position', 'rsaddon' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => 'date_p_default',
                    'options' => [
                        'date_p_default' => esc_html__( 'Default', 'rsaddon' ),
                        'date_p_bottom' => esc_html__( 'Bottom', 'rsaddon' ),
                        'date_p_absolute' => esc_html__( 'Absolute', 'rsaddon' ),
                    ],
                    'condition' => [
                        'blog_meta_date_show_hide' => 'yes',
                        'blog_meta_show_hide' => 'yes'
                    ]
                ]
            );
            $this->add_control(
                'blog_meta_date_short',
                [
                    'label' => esc_html__( 'Date Short', 'rsaddon' ),
                    'type' => Controls_Manager::SWITCHER,
                    'default' => 'yes',
                    'options' => [
                        'label_on' => esc_html__( 'Show', 'rsaddon' ),
                        'label_off' => esc_html__( 'Hide', 'rsaddon' ),
                    ],
                    'condition' => [
                        'blog_meta_date_show_hide' => 'yes',
                        'blog_meta_show_hide' => 'yes',
                        'blog_meta_date_position' => 'date_p_absolute'
                    ]
                ]
            );
            $this->add_control(
                'blog_cate_show_hide',
                [
                    'label' => esc_html__( 'Show Category', 'rsaddon' ),
                    'type' => Controls_Manager::SWITCHER,
                    'default' => 'yes',
                    'separator' => 'before',
                    'options' => [
                        'label_on' => esc_html__( 'Show', 'rsaddon' ),
                        'label_off' => esc_html__( 'Hide', 'rsaddon' ),
                    ],   
                    'condition' => [
                        'blog_meta_show_hide' => 'yes'
                    ]
                ]
            );
            $this->add_control(
                'blog_cate_position',
                [
                    'label' => esc_html__( 'Category Position', 'rsaddon' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => '',
                    'options' => [
                        '' => esc_html__( 'Default', 'rsaddon' ),
                        'cate_p_bottom' => esc_html__( 'Meta Tray', 'rsaddon' )
                    ],
                    'condition' => [
                        'blog_cate_show_hide' => 'yes',
                        'blog_meta_show_hide' => 'yes'
                    ]
                ]
            );

        $this->end_controls_section();


        //Content Settings Here
        $this->start_controls_section(
            '_content_settings',
            [
                'label' => esc_html__( 'Description Settings', 'rsaddon' ),
            ]
        );
            $this->add_control(
                'blog_content_show_hide',
                [
                    'label' => esc_html__( 'Show Description', 'rsaddon' ),
                    'type' => Controls_Manager::SWITCHER,
                    'default' => 'yes',
                    'options' => [
                        'label_on' => esc_html__( 'Show', 'rsaddon' ),
                        'label_off' => esc_html__( 'Hide', 'rsaddon' ),
                    ],                
                ]
            );
            $this->add_control(
                'blog_word_show',
                [
                    'label' => esc_html__( 'Description Limit', 'rsaddon' ),
                    'type' => Controls_Manager::TEXT,
                    'placeholder' => esc_html__( '20', 'rsaddon' ),
                    'condition' => [
                        'blog_content_show_hide' => 'yes',
                    ]
                ]
            );
        $this->end_controls_section();

        $this->start_controls_section(
            '_button_settings',
            [
                'label' => esc_html__( 'Button Settings', 'rsaddon' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
            $this->add_control(
                'blog_btn_show_hide',
                [
                    'label' => esc_html__( 'Show Button', 'rsaddon' ),
                    'type' => Controls_Manager::SWITCHER,
                    'default' => 'yes',
                    'options' => [
                        'label_on' => esc_html__( 'Show', 'rsaddon' ),
                        'label_off' => esc_html__( 'Hide', 'rsaddon' ),
                    ],                
                ]
            );
            $this->add_control(
                'btn_gradient',
                [
                    'label' => esc_html__( 'Gradient Style', 'rsaddon' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => '',
                    'options' => [
                        '' => esc_html__( 'Disable', 'rsaddon' ),
                        'gradient' => esc_html__( 'Enable', 'rsaddon' ),
                    ],
                    'condition' => [
                        'blog_btn_show_hide' => 'yes'
                    ]
                ]
            );
            $this->add_control(
                'btn_text',
                [
                    'label' => esc_html__( 'Button Text', 'rsaddon' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => esc_html__( 'Read More', 'rsaddon' ),
                    'placeholder' => esc_html__( 'Button text here', 'rsaddon' ),
                    'condition' => [
                        'blog_btn_show_hide' => 'yes'
                    ]
                ]
            );
            $this->add_control(
				'btn_icon',
				[
					'label' => __('Button Icon', 'rsaddon'),
					'type' => Controls_Manager::ICONS,
					'default' => [
						'value' => 'fas fa-arrow-right',
						'library' => 'fa-solid',
					],
					'condition' => [
						'blog_btn_show_hide' => 'yes'
					]
				]
			);
            $this->add_responsive_control(
                'btn_icon_flex_direction',
                [
                    'label' => esc_html__( 'Icon Position', 'rsaddon' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'row' => [
                            'title' => esc_html__( 'Row', 'rsaddon' ),
                            'icon' => 'eicon-justify-start-h',
                        ],
                        'row-reverse' => [
                            'title' => esc_html__( 'Row Reverse', 'rsaddon' ),
                            'icon' => 'eicon-wrap',
                        ],
                    ],
                    'condition' => [
						'blog_btn_show_hide' => 'yes'
					],
                    'toggle' => true,
                    'selectors' => [
                        '{{WRAPPER}} .pre-blog-item .blog-btn-part a' => 'flex-direction: {{VALUE}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'btn_gap_between_icon_text',
                [
                    'label' => esc_html__( 'Gap between Icon/Text', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .pre-blog-item .blog-btn-part a' => 'gap: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
        $this->end_controls_section();

        // Global Style Start
        $this->start_controls_section(
            '_section_global_style',
            [
                'label' => esc_html__( 'Global Style', 'rsaddon' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
            $this->add_responsive_control(
                'g_horizontal_align',
                [
                    'label' => esc_html__( 'Display Style (Inline / Block)', 'rsaddon' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'flex' => [
                            'title' => esc_html__( 'Inline', 'rsaddon' ),
                            'icon' => 'eicon-post-list',
                        ],
                        'block' => [
                            'title' => esc_html__( 'Block', 'rsaddon' ),
                            'icon' => 'eicon-posts-grid',
                        ],
                    ],
                    'toggle' => true,
                    'selectors' => [
                        '{{WRAPPER}} .prelements-blog-slider .pre-blog-item .blog-inner-wrap' => 'display: {{VALUE}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'g_vertical_align',
                [
                    'label' => esc_html__( 'Vertical Align', 'rsaddon' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'flex-start' => [
                            'title' => esc_html__( 'Top', 'rsaddon' ),
                            'icon' => 'eicon-align-start-v',
                        ],
                        'center' => [
                            'title' => esc_html__( 'Middle', 'rsaddon' ),
                            'icon' => 'eicon-align-center-v',
                        ],
                        'flex-end' => [
                            'title' => esc_html__( 'Bottom', 'rsaddon' ),
                            'icon' => 'eicon-align-end-v',
                        ],
                    ],
                    'toggle' => true,
                    'condition' => [
                        'g_horizontal_align' => 'flex'
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .prelements-blog-slider .pre-blog-item .blog-inner-wrap' => 'align-items: {{VALUE}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'g_column_align',
                [
                    'label' => esc_html__( 'Column Direction', 'rsaddon' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'row' => [
                            'title' => esc_html__( 'Row', 'rsaddon' ),
                            'icon' => 'eicon-justify-start-h',
                        ],
                        'row-reverse' => [
                            'title' => esc_html__( 'Row Reverse', 'rsaddon' ),
                            'icon' => 'eicon-wrap',
                        ],
                        'column' => [
                            'title' => esc_html__( 'Column', 'rsaddon' ),
                            'icon' => 'eicon-justify-start-v',
                        ],
                        'column-reverse' => [
                            'title' => esc_html__( 'Column Reverse', 'rsaddon' ),
                            'icon' => 'eicon-wrap',
                        ],
                    ],
                    'toggle' => true,
                    'condition' => [
                        'g_horizontal_align' => 'flex'
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .prelements-blog-slider .pre-blog-item .blog-inner-wrap' => 'flex-direction: {{VALUE}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'g_column_h_align',
                [
                    'label' => esc_html__( 'Horizontal Align', 'rsaddon' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'flex-start' => [
                            'title' => esc_html__( 'Start', 'rsaddon' ),
                            'icon' => 'eicon-align-start-h',
                        ],
                        'center' => [
                            'title' => esc_html__( 'Center', 'rsaddon' ),
                            'icon' => 'eicon-align-center-h',
                        ],
                        'flex-end' => [
                            'title' => esc_html__( 'End', 'rsaddon' ),
                            'icon' => 'eicon-align-end-h',
                        ],
                        'space-between' => [
                            'title' => esc_html__( 'Space Between', 'rsaddon' ),
                            'icon' => 'eicon-justify-space-between-h',
                        ],
                    ],
                    'separator' => 'after',
                    'condition' => [
                        'g_horizontal_align' => 'flex'
                    ],
                    'toggle' => true,
                    'selectors' => [
                        '{{WRAPPER}} .prelements-blog-slider .pre-blog-item .blog-inner-wrap' => 'justify-content: {{VALUE}};',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'g_background',
                    'label' => esc_html__( 'Background', 'rsaddon' ),
                    'types' => [ 'classic', 'gradient' ],
                    'selector' => '{{WRAPPER}} .prelements-blog-slider .pre-blog-item .blog-inner-wrap'
                ]
            );
            $this->add_responsive_control(
                'g_margin',
                [
                    'label' => esc_html__( 'Blog Item Spacing', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', 'em', '%' ],
                    'selectors' => [
                        '{{WRAPPER}} .prelements-blog-slider .pre-blog-item .blog-inner-wrap' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                    'name' => 'g_box_shadow',
                    'label' => esc_html__( 'Item Shadow', 'rsaddon' ),
                    'selector' => '{{WRAPPER}} .prelements-blog-slider .pre-blog-item .blog-inner-wrap',
                ]
            );
            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'g_border',
                    'selector' => '{{WRAPPER}} .prelements-blog-slider .pre-blog-item .blog-inner-wrap',
                ]
            );
            $this->add_control(
                'g_border_radiuss',
                [
                    'label' => esc_html__( 'Border Radius', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%' ],
                    'selectors' => [
                        '{{WRAPPER}} .prelements-blog-slider .pre-blog-item .blog-inner-wrap' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
        $this->end_controls_section();
        // Global Style End

        //Feature Image Part Style Start Here
        $this->start_controls_section(
            'section_feature_img_part_style',
            [
                'label' => esc_html__( 'Feature Image Style', 'rsaddon' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
            $this->add_responsive_control(
                'feature_img_part_width',
                [
                    'label' => esc_html__( 'Area Width', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'default' => [
                        'unit' => '%'
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .prelements-blog-slider .pre-blog-item .blog-inner-wrap .pre-image-wrap' => 'width: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'feature_img_part_overflow',
                [
                    'label' => esc_html__( 'Overflow', 'rsaddon' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => '',
                    'options' => [
                        '' => esc_html__( 'Default', 'rsaddon' ),
                        'unset' => esc_html__( 'Unset', 'rsaddon' ),
                        'hidden'  => esc_html__( 'Hidden', 'rsaddon' ),
                        'visible' => esc_html__( 'Visible', 'rsaddon' ),
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .prelements-blog-slider .pre-blog-item .blog-inner-wrap .pre-image-wrap' => 'overflow: {{VALUE}};',
                    ],
                ]
            );
            $this->add_control(
                'feature_img_part_padding',
                [
                    'label' => esc_html__( 'Area Padding', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .prelements-blog-slider .pre-blog-item .blog-inner-wrap .pre-image-wrap' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_control(
                'feature_img_part_radius',
                [
                    'label' => esc_html__( 'Area Border Radius', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .prelements-blog-slider .pre-blog-item .blog-inner-wrap .pre-image-wrap' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_control(
                'feature_img_part_margin',
                [
                    'label' => esc_html__( 'Area Margin', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .prelements-blog-slider .pre-blog-item .blog-inner-wrap .pre-image-wrap' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'feature_img_part_background',
                    'types' => [ 'classic', 'gradient' ],
                    'selector' => '{{WRAPPER}} .prelements-blog-slider .pre-blog-item .blog-inner-wrap .pre-image-wrap',
                ]
            );
            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'feature_img_part_border',
                    'selector' => '{{WRAPPER}} .prelements-blog-slider .pre-blog-item .blog-inner-wrap .pre-image-wrap',
                ]
            );
            $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                    'name' => 'feature_img_part_box_shadow',
                    'selector' => '{{WRAPPER}} .prelements-blog-slider .pre-blog-item .blog-inner-wrap .pre-image-wrap',
                ]
            );
            $this->add_control(
                'feature_img_radius',
                [
                    'label' => esc_html__( 'Image Border Radius', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .prelements-blog-slider .pre-blog-item .blog-inner-wrap .pre-image-wrap img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
        $this->end_controls_section();
        //Feature Image Part Style End Here
        
        //Content Part Style Here
        $this->start_controls_section(
            'section_content_part_style',
            [
                'label' => esc_html__( 'Content Part Style', 'rsaddon' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
            $this->add_responsive_control(
                'content_part_display_style',
                [
                    'label' => esc_html__( 'Style Flex / Block', 'rsaddon' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'flex' => [
                            'title' => esc_html__( 'Inline', 'rsaddon' ),
                            'icon' => 'eicon-post-list',
                        ],
                        'block' => [
                            'title' => esc_html__( 'Block', 'rsaddon' ),
                            'icon' => 'eicon-posts-grid',
                        ],
                    ],
                    'toggle' => true,
                    'selectors' => [
                        '{{WRAPPER}} .prelements-blog-slider .pre-blog-item .pre-blog-content' => 'display: {{VALUE}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'content_part_vertical_align',
                [
                    'label' => esc_html__( 'Vertical Align', 'rsaddon' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'flex-start' => [
                            'title' => esc_html__( 'Top', 'rsaddon' ),
                            'icon' => 'eicon-align-start-v',
                        ],
                        'center' => [
                            'title' => esc_html__( 'Middle', 'rsaddon' ),
                            'icon' => 'eicon-align-center-v',
                        ],
                        'flex-end' => [
                            'title' => esc_html__( 'Bottom', 'rsaddon' ),
                            'icon' => 'eicon-align-end-v',
                        ],
                    ],
                    'condition' => [
                        'content_part_display_style' => 'flex',
                    ],
                    'toggle' => true,
                    'selectors' => [
                        '{{WRAPPER}} .prelements-blog-slider .pre-blog-item .pre-blog-content' => 'align-items: {{VALUE}};',
                    ],
                ]
            );

            $this->add_responsive_control(
                'content_part_column_align',
                [
                    'label' => esc_html__( 'Column Direction', 'rsaddon' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'row' => [
                            'title' => esc_html__( 'Row', 'rsaddon' ),
                            'icon' => 'eicon-justify-start-h',
                        ],
                        'row-reverse' => [
                            'title' => esc_html__( 'Row Reverse', 'rsaddon' ),
                            'icon' => 'eicon-wrap',
                        ],
                        'column' => [
                            'title' => esc_html__( 'Column', 'rsaddon' ),
                            'icon' => 'eicon-justify-start-v',
                        ],
                        'column-reverse' => [
                            'title' => esc_html__( 'Column Reverse', 'rsaddon' ),
                            'icon' => 'eicon-wrap',
                        ],
                    ],
                    'condition' => [
                        'content_part_display_style' => 'flex',
                    ],
                    'toggle' => true,
                    'selectors' => [
                        '{{WRAPPER}} .prelements-blog-slider .pre-blog-item .pre-blog-content' => 'flex-direction: {{VALUE}};',
                    ],
                ]
            );

            $this->add_responsive_control(
                'content_part_box_h_align',
                [
                    'label' => esc_html__( 'Horizontal Align', 'rsaddon' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'flex-start' => [
                            'title' => esc_html__( 'Start', 'rsaddon' ),
                            'icon' => 'eicon-align-start-h',
                        ],
                        'center' => [
                            'title' => esc_html__( 'Center', 'rsaddon' ),
                            'icon' => 'eicon-align-center-h',
                        ],
                        'flex-end' => [
                            'title' => esc_html__( 'End', 'rsaddon' ),
                            'icon' => 'eicon-align-end-h',
                        ],
                        'space-between' => [
                            'title' => esc_html__( 'Space Between', 'rsaddon' ),
                            'icon' => 'eicon-justify-space-between-h',
                        ],
                    ],
                    'condition' => [
                        'content_part_display_style' => 'flex',
                    ],
                    'toggle' => true,
                    'selectors' => [
                        '{{WRAPPER}} .prelements-blog-slider .pre-blog-item .pre-blog-content' => 'justify-content: {{VALUE}};',
                    ],
                ]
            );

            $this->add_responsive_control(
                'content_part_flex_gap',
                [
                    'label' => esc_html__('Flex Gap', 'rsaddon'),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => ['%', 'px'],
                    'show_label' => true,
                    'selectors' => [
                        '{{WRAPPER}} .prelements-blog-slider .pre-blog-item .pre-blog-content' => 'gap: {{SIZE}}{{UNIT}};',
                    ],
                    'condition' => [
                        'content_part_display_style' => 'flex',
                    ],
                ]
            );
            $this->add_responsive_control(
                'content_part_width',
                [
                    'label' => esc_html__( 'Area Width', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'default' => [
                        'unit' => '%'
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .prelements-blog-slider .pre-blog-item .blog-inner-wrap .pre-blog-content' => 'width: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'content_part_background',
                    'label' => esc_html__( 'Background', 'rsaddon' ),
                    'types' => [ 'classic', 'gradient' ],
                    'selector' => '{{WRAPPER}} .prelements-blog-slider .pre-blog-item .blog-inner-wrap .pre-blog-content'
                ]
            );
            $this->add_responsive_control(
                'content_part_padding',
                [
                    'label' => esc_html__( 'Padding', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', 'em', '%' ],
                    'selectors' => [
                        '{{WRAPPER}} .prelements-blog-slider .pre-blog-item .blog-inner-wrap .pre-blog-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'content_part_margin',
                [
                    'label' => esc_html__( 'Margin', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', 'em', '%' ],
                    'selectors' => [
                        '{{WRAPPER}} .prelements-blog-slider .pre-blog-item .blog-inner-wrap .pre-blog-content' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            

            $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                    'name' => 'content_part_box_shadow',
                    'label' => esc_html__( 'Box Shadow', 'rsaddon' ),
                    'selector' => '{{WRAPPER}} .prelements-blog-slider .pre-blog-item .blog-inner-wrap .pre-blog-content',
                ]
            );
            
            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'content_part_border',
                    'selector' => '{{WRAPPER}} .prelements-blog-slider .pre-blog-item .blog-inner-wrap .pre-blog-content',
                ]
            );

            $this->add_control(
                'content_part_border_radiuss',
                [
                    'label' => esc_html__( 'Border Radius', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%' ],
                    'selectors' => [
                        '{{WRAPPER}} .prelements-blog-slider .pre-blog-item .blog-inner-wrap .pre-blog-content' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            // Content Part Position Maker Start
            $this->add_control(
                'content_part_position_maker',
                [
                    'label' => esc_html__( 'Position Maker', 'rsaddon' ),
                    'type' => Controls_Manager::POPOVER_TOGGLE,
                    'label_off' => esc_html__( 'Default', 'rsaddon' ),
                    'label_on' => esc_html__( 'Custom', 'rsaddon' ),
                    'return_value' => 'yes',
                    'default' => 'no',
                    'separator' => 'before',
                ]
            );
                $this->start_popover();
                $this->add_responsive_control(
                    'content_part_position',
                    [
                        'label' => esc_html__( 'Position', 'rsaddon' ),
                        'type' => Controls_Manager::SELECT,
                        'default' => '',
                        'options' => [
                            '' => esc_html__( 'Default', 'rsaddon' ),
                            'absolute' => esc_html__( 'Absolute', 'rsaddon' ),
                            'relative'  => esc_html__( 'Relative', 'rsaddon' ),
                            'unset'  => esc_html__( 'Unset', 'rsaddon' ),
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .prelements-blog-slider .pre-blog-item .pre-blog-content' => 'position: {{VALUE}};',
                        ],
                    ]
                );
                $this->add_responsive_control(
                    'content_part_p_top',
                    [
                        'label' => esc_html__( 'Top', 'rsaddon' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%', 'custom' ],
                        'range' => [
                            'px' => [
                                'min' => -1000,
                                'max' => 1000,
                            ],
                            '%' => [
                                'min' => -100,
                                'max' => 100,
                            ],
                        ],
                        'condition' => [
                            'content_part_position' => ['absolute', 'relative']
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .prelements-blog-slider .pre-blog-item .pre-blog-content' => 'top: {{SIZE}}{{UNIT}};',
                        ],
                    ]
                );
                $this->add_responsive_control(
                    'content_part_p_right',
                    [
                        'label' => esc_html__( 'Right', 'rsaddon' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%', 'custom' ],
                        'range' => [
                            'px' => [
                                'min' => -1000,
                                'max' => 1000,
                            ],
                            '%' => [
                                'min' => -100,
                                'max' => 100,
                            ],
                        ],
                        'condition' => [
                            'content_part_position' => ['absolute', 'relative']
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .prelements-blog-slider .pre-blog-item .pre-blog-content' => 'right: {{SIZE}}{{UNIT}};',
                        ],
                    ]
                );
                $this->add_responsive_control(
                    'content_part_p_bottom',
                    [
                        'label' => esc_html__( 'Bottom', 'rsaddon' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%', 'custom' ],
                        'range' => [
                            'px' => [
                                'min' => -1000,
                                'max' => 1000,
                            ],
                            '%' => [
                                'min' => -100,
                                'max' => 100,
                            ],
                        ],
                        'condition' => [
                            'content_part_position' => ['absolute', 'relative']
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .prelements-blog-slider .pre-blog-item .pre-blog-content' => 'bottom: {{SIZE}}{{UNIT}};',
                        ],
                    ]
                );
                $this->add_responsive_control(
                    'content_part_p_left',
                    [
                        'label' => esc_html__( 'Left', 'rsaddon' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%', 'custom' ],
                        'range' => [
                            'px' => [
                                'min' => -1000,
                                'max' => 1000,
                            ],
                            '%' => [
                                'min' => -100,
                                'max' => 100,
                            ],
                        ],
                        'condition' => [
                            'content_part_position' => ['absolute', 'relative']
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .prelements-blog-slider .pre-blog-item .pre-blog-content' => 'left: {{SIZE}}{{UNIT}};',
                        ],
                    ]
                );
            $this->end_popover();
            // Content Part Position Maker End

            $this->start_controls_tabs(
                'content_part_style_tabs'
            );
                $this->start_controls_tab(
                    'content_part_style_normal_tab',
                    [
                        'label' => esc_html__( 'Normal', 'rsaddon' ),
                    ]
                );
                    $this->add_responsive_control(
                        'content_part_opacity',
                        [
                            'label' => esc_html__( 'Opacity', 'rsaddon' ),
                            'type' => Controls_Manager::SLIDER,
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 1,
                                    'step' => 0.1
                                ]
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .prelements-blog-slider .pre-blog-item .date_meta.date_p_absolute,
                                {{WRAPPER}} .prelements-blog-slider .pre-blog-item .blog-inner-wrap .pre-blog-content' => 'opacity: {{SIZE}};',
                            ],
                        ]
                    );
                $this->end_controls_tab();

                $this->start_controls_tab(
                    'content_part_style_current_tab',
                    [
                        'label' => esc_html__( 'Current', 'rsaddon' ),
                    ]
                );
                    $this->add_responsive_control(
                        'content_part_opacity_current',
                        [
                            'label' => esc_html__( 'Opacity', 'rsaddon' ),
                            'type' => Controls_Manager::SLIDER,
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 1,
                                    'step' => 0.1
                                ]
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .prelements-blog-slider .pre-blog-item.slick-current .date_meta.date_p_absolute,
                                {{WRAPPER}} .prelements-blog-slider .pre-blog-item.slick-current .blog-inner-wrap .pre-blog-content' => 'opacity: {{SIZE}};',
                            ],
                        ]
                    );
                $this->end_controls_tab();
            $this->end_controls_tabs();
        $this->end_controls_section();

        //Cursor Label Style Here
        $this->start_controls_section(
            'section_cursor_label_style',
            [
                'label' => esc_html__( 'Cursor Label Style', 'rsaddon' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'show_cursor_label' => 'yes'
                ]
            ]
        );
            $this->add_responsive_control(
                'display_show_hide',
                [
                    'label' => esc_html__( 'Display', 'rsaddon' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'none' => [
                            'title' => esc_html__( 'Hide', 'rsaddon' ),
                            'icon' => 'eicon-editor-close',
                        ],
                        'flex' => [
                            'title' => esc_html__( 'Show', 'rsaddon' ),
                            'icon' => 'eicon-preview-medium',
                        ]
                    ],
                    'toggle' => true,
                    'selectors' => [
                        '{{WRAPPER}} .gsap-cursor-attached-label .label-move' => 'display: {{VALUE}};',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'cursor_label_typography',
                    'selector' => '{{WRAPPER}} .gsap-cursor-attached-label .label-move',
                ]
            );
            $this->add_control(
                'cursor_label_text_color',
                [
                    'label' => esc_html__( 'Text Color', 'rsaddon' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .gsap-cursor-attached-label .label-move' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_responsive_control(
                'cursor_label_width',
                [
                    'label' => esc_html__( 'Width', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .gsap-cursor-attached-label .label-move' => 'width: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'cursor_label_height',
                [
                    'label' => esc_html__( 'Height', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .gsap-cursor-attached-label .label-move' => 'height: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'cursor_label_padding',
                [
                    'label' => esc_html__( 'Padding', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .gsap-cursor-attached-label .label-move' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'cursor_label_radius',
                [
                    'label' => esc_html__( 'Border Radius', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .gsap-cursor-attached-label .label-move' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'cursor_label_background',
                    'types' => [ 'classic', 'gradient' ],
                    'selector' => '{{WRAPPER}} .gsap-cursor-attached-label .label-move',
                ]
            );
            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'cursor_label_border',
                    'selector' => '{{WRAPPER}} .gsap-cursor-attached-label .label-move',
                ]
            );
            $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                    'name' => 'cursor_label_box_shadow',
                    'selector' => '{{WRAPPER}} .gsap-cursor-attached-label .label-move',
                ]
            );

        $this->end_controls_section();

        //Category Style Here
        $this->start_controls_section(
            'section_category_style',
            [
                'label' => esc_html__( 'Category Style', 'rsaddon' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'blog_cate_show_hide' => 'yes'
                ]
            ]
        );
            $this->add_responsive_control(
                'cate_text_align',
                [
                    'label' => esc_html__( 'Text Align', 'rsaddon' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'left' => [
                            'title' => esc_html__( 'Left', 'rsaddon' ),
                            'icon' => 'eicon-text-align-left',
                        ],
                        'center' => [
                            'title' => esc_html__( 'Center', 'rsaddon' ),
                            'icon' => 'eicon-text-align-center',
                        ],
                        'right' => [
                            'title' => esc_html__( 'Right', 'rsaddon' ),
                            'icon' => 'eicon-text-align-right',
                        ],
                    ],
                    'toggle' => true,
                    'selectors' => [
                        '{{WRAPPER}} .prelements-blog-slider .pre-blog-item .pre-image-wrap .rs-cate,
                        {{WRAPPER}} .prelements-blog-slider .pre-blog-item .pre-blog-content .top_meta_wrapper .rs-cate' => 'text-align: {{VALUE}};',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'cate_typography',
                    'label' => esc_html__( 'Typography', 'rsaddon' ),
                    'selector' => 
                        '{{WRAPPER}} .prelements-blog-slider .pre-blog-item .pre-image-wrap .rs-cate,
                        {{WRAPPER}} .prelements-blog-slider .pre-blog-item .pre-blog-content .top_meta_wrapper .rs-cate',
                ]
            );
            $this->add_responsive_control(
                'cats_padding',
                [
                    'label' => esc_html__( 'Padding', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', 'em', '%' ],
                    'selectors' => [
                        '{{WRAPPER}} .prelements-blog-slider .pre-blog-item .pre-image-wrap .rs-cate,
                        {{WRAPPER}} .prelements-blog-slider .pre-blog-item .pre-blog-content .top_meta_wrapper .rs-cate' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'cats_margin',
                [
                    'label' => esc_html__( 'Margin', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', 'em', '%' ],
                    'selectors' => [
                        '{{WRAPPER}} .prelements-blog-slider .pre-blog-item .pre-image-wrap .rs-cate,
                        {{WRAPPER}} .prelements-blog-slider .pre-blog-item .pre-blog-content .top_meta_wrapper .rs-cate' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'cats_border_radius',
                [
                    'label' => esc_html__( 'Border Radius', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%' ],
                    'selectors' => [
                        '{{WRAPPER}} .prelements-blog-slider .pre-blog-item .pre-image-wrap .rs-cate,
                        {{WRAPPER}} .prelements-blog-slider .pre-blog-item .pre-blog-content .top_meta_wrapper .rs-cate' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_responsive_control(
                'cats_width',
                [
                    'label' => esc_html__( 'Width', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .prelements-blog-slider .pre-blog-item .pre-image-wrap .rs-cate,
                        {{WRAPPER}} .prelements-blog-slider .pre-blog-item .pre-blog-content .top_meta_wrapper .rs-cate' => 'width: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'cate_meta_z_index',
                [
                    'label' => esc_html__( 'Z-Index', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px'],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 360
                        ],
                    ],
                    'condition' => [
                        'blog_cate_position!' => 'cate_p_bottom'
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .prelements-blog-slider .pre-blog-item .pre-image-wrap .rs-cate' => 'z-index: {{SIZE}};',
                    ],
                ]
            );

            // Category Position Maker Start
            $this->add_control(
                'category_wrapper_position_maker',
                [
                    'label' => esc_html__( 'Position Maker', 'rsaddon' ),
                    'type' => Controls_Manager::POPOVER_TOGGLE,
                    'label_off' => esc_html__( 'Default', 'rsaddon' ),
                    'label_on' => esc_html__( 'Custom', 'rsaddon' ),
                    'return_value' => 'yes',
                    'default' => 'no',
                    'separator' => 'before',
                    'condition' => [
                        'blog_cate_position!' => 'cate_p_bottom'
                    ],
                ]
            );
                $this->start_popover();
                $this->add_responsive_control(
                    'category_wrapper_position',
                    [
                        'label' => esc_html__( 'Position', 'rsaddon' ),
                        'type' => Controls_Manager::SELECT,
                        'default' => '',
                        'options' => [
                            '' => esc_html__( 'Default', 'rsaddon' ),
                            'absolute' => esc_html__( 'Absolute', 'rsaddon' ),
                            'relative'  => esc_html__( 'Relative', 'rsaddon' ),
                            'unset'  => esc_html__( 'Unset', 'rsaddon' ),
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .prelements-blog-slider .pre-blog-item .pre-image-wrap .rs-cate' => 'position: {{VALUE}};',
                        ],
                    ]
                );
                $this->add_responsive_control(
                    'category_wrapper_p_top',
                    [
                        'label' => esc_html__( 'Top', 'rsaddon' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%', 'custom' ],
                        'range' => [
                            'px' => [
                                'min' => -1000,
                                'max' => 1000,
                            ],
                            '%' => [
                                'min' => -100,
                                'max' => 100,
                            ],
                        ],
                        'condition' => [
                            'category_wrapper_position' => ['absolute', 'relative']
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .prelements-blog-slider .pre-blog-item .pre-image-wrap .rs-cate' => 'top: {{SIZE}}{{UNIT}};',
                        ],
                    ]
                );
                $this->add_responsive_control(
                    'category_wrapper_p_right',
                    [
                        'label' => esc_html__( 'Right', 'rsaddon' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%', 'custom' ],
                        'range' => [
                            'px' => [
                                'min' => -1000,
                                'max' => 1000,
                            ],
                            '%' => [
                                'min' => -100,
                                'max' => 100,
                            ],
                        ],
                        'condition' => [
                            'category_wrapper_position' => ['absolute', 'relative']
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .prelements-blog-slider .pre-blog-item .pre-image-wrap .rs-cate' => 'right: {{SIZE}}{{UNIT}};',
                        ],
                    ]
                );
                $this->add_responsive_control(
                    'category_wrapper_p_bottom',
                    [
                        'label' => esc_html__( 'Bottom', 'rsaddon' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%', 'custom' ],
                        'range' => [
                            'px' => [
                                'min' => -1000,
                                'max' => 1000,
                            ],
                            '%' => [
                                'min' => -100,
                                'max' => 100,
                            ],
                        ],
                        'condition' => [
                            'category_wrapper_position' => ['absolute', 'relative']
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .prelements-blog-slider .pre-blog-item .pre-image-wrap .rs-cate' => 'bottom: {{SIZE}}{{UNIT}};',
                        ],
                    ]
                );
                $this->add_responsive_control(
                    'category_wrapper_p_left',
                    [
                        'label' => esc_html__( 'Left', 'rsaddon' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%', 'custom' ],
                        'range' => [
                            'px' => [
                                'min' => -1000,
                                'max' => 1000,
                            ],
                            '%' => [
                                'min' => -100,
                                'max' => 100,
                            ],
                        ],
                        'condition' => [
                            'category_wrapper_position' => ['absolute', 'relative']
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .prelements-blog-slider .pre-blog-item .pre-image-wrap .rs-cate' => 'left: {{SIZE}}{{UNIT}};',
                        ],
                    ]
                );
            $this->end_popover();
            // Category Position Maker End

            $this->start_controls_tabs( '_tabs_button_cate' );
                $this->start_controls_tab(
                '_blog_cate_normal',
                [
                    'label' => esc_html__( 'Normal', 'rsaddon' ),
                ]
                );
                    $this->add_control(
                        'blog_cat_color',
                        [
                            'label' => esc_html__( 'Color', 'rsaddon' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .prelements-blog-slider .pre-blog-item .pre-image-wrap .rs-cate,
                                {{WRAPPER}} .prelements-blog-slider .pre-blog-item .pre-blog-content .top_meta_wrapper .rs-cate' => 'color: {{VALUE}};',

                            ],               
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'blog_cat_bg_gradiant_color',
                            'types' => [ 'classic', 'gradient'],
                            'selector' => '{{WRAPPER}} .prelements-blog-slider .pre-blog-item .pre-image-wrap .rs-cate,
                            {{WRAPPER}} .prelements-blog-slider .pre-blog-item .pre-blog-content .top_meta_wrapper .rs-cate',
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'blog_cat_border',
                            'selector' => '{{WRAPPER}} .prelements-blog-slider .pre-blog-item .pre-image-wrap .rs-cate,
                            {{WRAPPER}} .prelements-blog-slider .pre-blog-item .pre-blog-content .top_meta_wrapper .rs-cate',
                        ]
                    );
                $this->end_controls_tab();

                $this->start_controls_tab(
                    '_blog_btn_cate_hover',
                    [
                        'label' => esc_html__( 'Hover', 'rsaddon' ),
                    ]
                );
                    $this->add_control(
                        'blog_cat_color_hover',
                        [
                            'label' => esc_html__( 'Color', 'rsaddon' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .prelements-blog-slider .pre-blog-item .pre-image-wrap .rs-cate:hover,
                                {{WRAPPER}} .prelements-blog-slider .pre-blog-item .pre-blog-content .top_meta_wrapper .rs-cate:hover' => 'color: {{VALUE}};',

                            ],               
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'blog_cat_bg_gradiant_color_hover',
                            'types' => [ 'classic', 'gradient'],
                            'selector' => '{{WRAPPER}} .prelements-blog-slider .pre-blog-item .pre-image-wrap .rs-cate:hover,
                            {{WRAPPER}} .prelements-blog-slider .pre-blog-item .pre-blog-content .top_meta_wrapper .rs-cate:hover',
                        ]
                    );
                    $this->add_control(
                        'blog_cat_border_color_hover',
                        [
                            'label' => esc_html__( 'Border Color', 'rsaddon' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .prelements-blog-slider .pre-blog-item .pre-image-wrap .rs-cate:hover,
                                {{WRAPPER}} .prelements-blog-slider .pre-blog-item .pre-blog-content .top_meta_wrapper .rs-cate:hover' => 'border-color: {{VALUE}};',
                            ],               
                        ]
                    );
                $this->end_controls_tab();
            $this->end_controls_tabs(); 
        $this->end_controls_section();


        //Thumbnail Style Here
        $this->start_controls_section(
            'section_image_style',
            [
                'label' => esc_html__( 'Thumbnail Style', 'rsaddon' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'blog_image_show_hide' => 'yes',
                ],
            ]
        );

            $this->add_responsive_control(
                'img_border_radius',
                [
                    'label' => esc_html__( 'Border Radius', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%' ],
                    'selectors' => [
                        '{{WRAPPER}} .prelements-blog-slider .pre-blog-item .pre-image-wrap .rs--thum img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

        $this->end_controls_section();

        //Meta Style Here
        $this->start_controls_section(
            'section_meta_style',
            [
                'label' => esc_html__( 'Meta Style', 'rsaddon' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'blog_meta_show_hide' => 'yes'
                ]
            ]
        );
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'meta_wrapper_color',
                    'types' => [ 'classic', 'gradient'],
                    'selector' => '{{WRAPPER}} .prelements-blog-slider .pre-blog-item .pre-blog-content .top_meta_wrapper',
                ]
            );
            $this->add_responsive_control(
                'meta_wrapper_filter_blur',
                [
                    'label' => esc_html__( 'Filter Blur', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => ['px'],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 100,
                        ]
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .prelements-blog-slider .pre-blog-item .pre-blog-content .top_meta_wrapper' => 'backdrop-filter: blur({{SIZE}}{{UNIT}});',
                    ]
                ]
            );
            $this->add_responsive_control(
                'meta_wrapper_padding',
                [
                    'label' => esc_html__( 'Padding', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', 'em', '%' ],
                    'selectors' => [
                        '{{WRAPPER}} .prelements-blog-slider .pre-blog-item .pre-blog-content .top_meta_wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'meta_wrapper_margin',
                [
                    'label' => esc_html__( 'Margin', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', 'em', '%' ],
                    'selectors' => [
                        '{{WRAPPER}} .prelements-blog-slider .pre-blog-item .pre-blog-content .top_meta_wrapper' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            // Meta Top Wrapper
            $this->add_control(
                'meta_top_wrapper_control_options',
                [
                    'label' => esc_html__( 'Wrapper Options', 'rsaddon' ),
                    'type' => Controls_Manager::HEADING,
                    'classes' => 'rs-control-type-heading',
                ]
            );
            $this->add_responsive_control(
                'meta_top_wrapper_horizontal_align',
                [
                    'label' => esc_html__( 'Display Style (Inline / Block)', 'rsaddon' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'flex' => [
                            'title' => esc_html__( 'Inline', 'rsaddon' ),
                            'icon' => 'eicon-post-list',
                        ],
                        'block' => [
                            'title' => esc_html__( 'Block', 'rsaddon' ),
                            'icon' => 'eicon-posts-grid',
                        ],
                    ],
                    'toggle' => true,
                    'selectors' => [
                        '{{WRAPPER}} .pre-blog-item .top_meta_wrapper' => 'display: {{VALUE}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'meta_top_wrapper_vertical_align',
                [
                    'label' => esc_html__( 'Vertical Align', 'rsaddon' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'flex-start' => [
                            'title' => esc_html__( 'Top', 'rsaddon' ),
                            'icon' => 'eicon-align-start-v',
                        ],
                        'center' => [
                            'title' => esc_html__( 'Middle', 'rsaddon' ),
                            'icon' => 'eicon-align-center-v',
                        ],
                        'flex-end' => [
                            'title' => esc_html__( 'Bottom', 'rsaddon' ),
                            'icon' => 'eicon-align-end-v',
                        ],
                    ],
                    'toggle' => true,
                    'condition' => [
                        'meta_top_wrapper_horizontal_align' => 'flex'
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .pre-blog-item .top_meta_wrapper' => 'align-items: {{VALUE}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'meta_top_wrapper_column_align',
                [
                    'label' => esc_html__( 'Column Direction', 'rsaddon' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'row' => [
                            'title' => esc_html__( 'Row', 'rsaddon' ),
                            'icon' => 'eicon-justify-start-h',
                        ],
                        'row-reverse' => [
                            'title' => esc_html__( 'Row Reverse', 'rsaddon' ),
                            'icon' => 'eicon-wrap',
                        ],
                        'column' => [
                            'title' => esc_html__( 'Column', 'rsaddon' ),
                            'icon' => 'eicon-justify-start-v',
                        ],
                        'column-reverse' => [
                            'title' => esc_html__( 'Column Reverse', 'rsaddon' ),
                            'icon' => 'eicon-wrap',
                        ],
                    ],
                    'toggle' => true,
                    'condition' => [
                        'meta_top_wrapper_horizontal_align' => 'flex'
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .pre-blog-item .top_meta_wrapper' => 'flex-direction: {{VALUE}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'meta_top_wrapper_column_h_align',
                [
                    'label' => esc_html__( 'Horizontal Align', 'rsaddon' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'flex-start' => [
                            'title' => esc_html__( 'Start', 'rsaddon' ),
                            'icon' => 'eicon-align-start-h',
                        ],
                        'center' => [
                            'title' => esc_html__( 'Center', 'rsaddon' ),
                            'icon' => 'eicon-align-center-h',
                        ],
                        'flex-end' => [
                            'title' => esc_html__( 'End', 'rsaddon' ),
                            'icon' => 'eicon-align-end-h',
                        ],
                        'space-between' => [
                            'title' => esc_html__( 'Space Between', 'rsaddon' ),
                            'icon' => 'eicon-justify-space-between-h',
                        ],
                    ],
                    'condition' => [
                        'meta_top_wrapper_horizontal_align' => 'flex'
                    ],
                    'toggle' => true,
                    'selectors' => [
                        '{{WRAPPER}} .pre-blog-item .top_meta_wrapper' => 'justify-content: {{VALUE}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'meta_top_wrapper_gap',
                [
                    'label' => esc_html__( 'Gap Between', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'separator' => 'after',
                    'condition' => [
                        'meta_top_wrapper_horizontal_align' => 'flex'
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .pre-blog-item .top_meta_wrapper' => 'gap: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
            // Separator
            $this->add_control(
                'meta_separator_control_options',
                [
                    'label' => esc_html__( 'Separator Options', 'rsaddon' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                    'classes' => 'rs-control-type-heading',
                ]
            );
            $this->add_control(
                'meta_separator_show',
                [
                    'label' => esc_html__( 'Separator Show', 'rsaddon' ),
                    'type' => Controls_Manager::SWITCHER,
                    'label_on' => esc_html__( 'Show', 'rsaddon' ),
                    'label_off' => esc_html__( 'Hide', 'rsaddon' ),
                    'return_value' => 'yes',
                    'default' => 'no'
                ]
            );
            $this->add_control(
                'meta_separator_color',
                [
                    'label' => esc_html__( 'Color', 'rsaddon' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .pre-blog-item .pre-blog-content .top_meta_wrapper.separator_yes > *:after' => 'background: {{VALUE}};',
                    ],
                    'condition' => [
                        'meta_separator_show' => 'yes'
                    ]
                ]
            );
            $this->add_responsive_control(
                'meta_separator_width',
                [
                    'label' => esc_html__( 'Width', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'condition' => [
                        'meta_separator_show' => 'yes'
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .pre-blog-item .pre-blog-content .top_meta_wrapper.separator_yes > *:after' => 'width: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'meta_separator_height',
                [
                    'label' => esc_html__( 'Height', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'condition' => [
                        'meta_separator_show' => 'yes'
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .pre-blog-item .pre-blog-content .top_meta_wrapper.separator_yes > *:after' => 'height: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'meta_separator_radius',
                [
                    'label' => esc_html__( 'Border Radius', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .pre-blog-item .pre-blog-content .top_meta_wrapper.separator_yes > *:after' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'condition' => [
                        'meta_separator_show' => 'yes'
                    ]
                ]
            );

            // Author
            $this->add_control(
                'meta_author_control_options',
                [
                    'label' => esc_html__( 'Author Options', 'rsaddon' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                    'classes' => 'rs-control-type-heading',
                    'condition' => [
                        'blog_meta_author_show_hide' => 'yes'
                    ]
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'meta_author_typography',
                    'selector' => '{{WRAPPER}} .pre-blog-item .author_meta',
                    'condition' => [
                        'blog_meta_author_show_hide' => 'yes'
                    ]
                ]
            );
            $this->add_control(
                'meta_author_color',
                [
                    'label' => esc_html__( 'Color', 'rsaddon' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .pre-blog-item .author_meta' => 'color: {{VALUE}};',
                    ],
                    'condition' => [
                        'blog_meta_author_show_hide' => 'yes'
                    ]
                ]
            );
            $this->add_responsive_control(
                'author_img_size',
                [
                    'label' => esc_html__( 'Image Size', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .pre-blog-item .author_meta .author_image' => 'width: {{SIZE}}{{UNIT}}; height: auto;',
                    ],
                    'condition' => [
                        'blog_meta_author_show_hide' => 'yes'
                    ]
                ]
            );
            $this->add_responsive_control(
                'author_padding',
                [
                    'label' => esc_html__( 'Padding', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .pre-blog-item .author_meta' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                    ],
                    'condition' => [
                        'blog_meta_author_show_hide' => 'yes'
                    ]
                ]
            );
            $this->add_responsive_control(
                'author_margin',
                [
                    'label' => esc_html__( 'Margin', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .pre-blog-item .author_meta' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                    ],
                    'condition' => [
                        'blog_meta_author_show_hide' => 'yes'
                    ]
                ]
            );
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'author_background',
                    'types' => [ 'classic', 'gradient' ],
                    'selector' => '{{WRAPPER}} .pre-blog-item .author_meta',
                    'condition' => [
                        'blog_meta_author_show_hide' => 'yes'
                    ]
                ]
            );
            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'author_border',
                    'selector' => '{{WRAPPER}} .pre-blog-item .author_meta',
                    'condition' => [
                        'blog_meta_author_show_hide' => 'yes'
                    ]
                ]
            );    

            // Comment Option
            $this->add_control(
                'meta_comment_control_options',
                [
                    'label' => esc_html__( 'Comment Options', 'rsaddon' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                    'classes' => 'rs-control-type-heading',
                    'condition' => [
                        'blog_meta_comment_show_hide' => 'yes'
                    ]
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'comment_meta_typography',
                    'selector' => '{{WRAPPER}} .pre-blog-item .comment_meta',
                    'condition' => [
                        'blog_meta_comment_show_hide' => 'yes'
                    ]
                ]
            );
            $this->add_control(
                'comment_meta_color',
                [
                    'label' => esc_html__( 'Text Color', 'rsaddon' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .pre-blog-item .comment_meta' => 'color: {{VALUE}};',
                    ],
                    'condition' => [
                        'blog_meta_comment_show_hide' => 'yes'
                    ]
                ]
            );
            $this->add_control(
                'comment_meta_icon_color',
                [
                    'label' => esc_html__( 'Icon Color', 'rsaddon' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .pre-blog-item .comment_meta i' => 'color: {{VALUE}};',
                        '{{WRAPPER}} .pre-blog-item .comment_meta svg path' => 'fill: {{VALUE}};',
                    ],
                    'condition' => [
                        'blog_meta_comment_show_hide' => 'yes'
                    ]
                ]
            );
            $this->add_control(
                'comment_meta_icon_size',
                [
                    'label' => esc_html__( 'Icon Size', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'condition' => [
                        'blog_meta_comment_show_hide' => 'yes'
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .pre-blog-item .comment_meta i' => 'font-size: {{SIZE}}{{UNIT}};',
                        '{{WRAPPER}} .pre-blog-item .comment_meta svg' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'comment_meta_padding',
                [
                    'label' => esc_html__( 'Padding', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .pre-blog-item .comment_meta' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                    ],
                    'condition' => [
                        'blog_meta_comment_show_hide' => 'yes'
                    ]
                ]
            );
            $this->add_responsive_control(
                'comment_meta_margin',
                [
                    'label' => esc_html__( 'Margin', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .pre-blog-item .comment_meta' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                    ],
                    'condition' => [
                        'blog_meta_comment_show_hide' => 'yes'
                    ]
                ]
            );

            // Date Option
            $this->add_control(
                'meta_date_control_options',
                [
                    'label' => esc_html__( 'Date Options', 'rsaddon' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                    'classes' => 'rs-control-type-heading',
                    'condition' => [
                        'blog_meta_date_show_hide' => 'yes'
                    ]
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'date_meta_typography',
                    'selector' => '{{WRAPPER}} .pre-blog-item .date_meta',
                    'condition' => [
                        'blog_meta_date_show_hide' => 'yes'
                    ]
                ]
            );
            $this->add_control(
                'date_meta_color',
                [
                    'label' => esc_html__( 'Text Color', 'rsaddon' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .pre-blog-item .date_meta' => 'color: {{VALUE}};',
                    ],
                    'condition' => [
                        'blog_meta_date_show_hide' => 'yes'
                    ]
                ]
            );
            $this->add_control(
                'date_meta_color_bold',
                [
                    'label' => esc_html__( 'Text Color (Bold)', 'rsaddon' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .pre-blog-item .date_meta.date_p_absolute b' => 'color: {{VALUE}};',
                    ],
                    'condition' => [
                        'blog_meta_date_show_hide' => 'yes',
                        'blog_meta_date_short' => 'yes',
                        'blog_meta_date_position' => 'date_p_absolute'
                    ]
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'date_meta_typography_bold',
                    'selector' => '{{WRAPPER}} .pre-blog-item .date_meta.date_p_absolute b',
                    'condition' => [
                        'blog_meta_date_show_hide' => 'yes',
                        'blog_meta_date_short' => 'yes',
                        'blog_meta_date_position' => 'date_p_absolute'
                    ]
                ]
            );
            $this->add_control(
                'date_meta_icon_color',
                [
                    'label' => esc_html__( 'Icon Color', 'rsaddon' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .pre-blog-item .date_meta i' => 'color: {{VALUE}};',
                        '{{WRAPPER}} .pre-blog-item .date_meta svg path' => 'fill: {{VALUE}};',
                    ],
                    'condition' => [
                        'blog_meta_date_show_hide' => 'yes',
                        'blog_meta_date_short!' => 'yes',
                    ]
                ]
            );
            $this->add_control(
                'date_meta_icon_size',
                [
                    'label' => esc_html__( 'Icon Size', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'condition' => [
                        'blog_meta_date_show_hide' => 'yes',
                        'blog_meta_date_short!' => 'yes'
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .pre-blog-item .date_meta i' => 'font-size: {{SIZE}}{{UNIT}};',
                        '{{WRAPPER}} .pre-blog-item .date_meta svg' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'date_meta_padding',
                [
                    'label' => esc_html__( 'Padding', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .pre-blog-item .date_meta' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                    ],
                    'condition' => [
                        'blog_meta_date_show_hide' => 'yes'
                    ]
                ]
            );
            $this->add_responsive_control(
                'date_meta_radius',
                [
                    'label' => esc_html__( 'Border Radius', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .pre-blog-item .date_meta' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                    ],
                    'condition' => [
                        'blog_meta_date_show_hide' => 'yes'
                    ]
                ]
            );
            $this->add_responsive_control(
                'date_meta_margin',
                [
                    'label' => esc_html__( 'Margin', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .pre-blog-item .date_meta' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                    ],
                    'condition' => [
                        'blog_meta_date_show_hide' => 'yes'
                    ]
                ]
            );
            $this->add_responsive_control(
                'date_meta_width',
                [
                    'label' => esc_html__( 'Width', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'condition' => [
                        'blog_meta_date_show_hide' => 'yes',
                        'blog_meta_date_position' => 'date_p_absolute'
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .pre-blog-item .date_meta.date_p_absolute' => 'width: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'date_meta_height',
                [
                    'label' => esc_html__( 'Height', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'condition' => [
                        'blog_meta_date_show_hide' => 'yes',
                        'blog_meta_date_position' => 'date_p_absolute'
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .pre-blog-item .date_meta.date_p_absolute' => 'height: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'date_meta_rotate',
                [
                    'label' => esc_html__( 'Rotate', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px'],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 360
                        ],
                    ],
                    'condition' => [
                        'blog_meta_date_show_hide' => 'yes',
                        'blog_meta_date_position' => 'date_p_absolute'
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .pre-blog-item .date_meta.date_p_absolute' => 'transform: rotate({{SIZE}}deg);',
                        '{{WRAPPER}} .pre-blog-item .date_meta.date_p_absolute span' => 'transform: rotate(-{{SIZE}}deg);',
                    ],
                ]
            );
            $this->add_responsive_control(
                'date_meta_z_index',
                [
                    'label' => esc_html__( 'Z-Index', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px'],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 360
                        ],
                    ],
                    'condition' => [
                        'blog_meta_date_show_hide' => 'yes',
                        'blog_meta_date_position' => 'date_p_absolute'
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .pre-blog-item .date_meta.date_p_absolute' => 'z-index: {{SIZE}};',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'date_meta_background',
                    'types' => [ 'classic', 'gradient', 'video' ],
                    'selector' => '{{WRAPPER}} .pre-blog-item .date_meta.date_p_absolute',
                    'condition' => [
                        'blog_meta_date_show_hide' => 'yes',
                        'blog_meta_date_position' => 'date_p_absolute'
                    ],
                ]
            );
            $this->add_responsive_control(
                'filter_blur',
                [
                    'label' => esc_html__( 'Filter Blur', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => ['px'],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 100,
                        ]
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .pre-blog-item .date_meta.date_p_absolute' => 'backdrop-filter: blur({{SIZE}}{{UNIT}});',
                    ],
                    'condition' => [
                        'blog_meta_date_show_hide' => 'yes'
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'date_meta_border',
                    'selector' => '{{WRAPPER}} .pre-blog-item .date_meta.date_p_absolute',
                    'condition' => [
                        'blog_meta_date_show_hide' => 'yes',
                        'blog_meta_date_position' => 'date_p_absolute'
                    ],
                ]
            );
            // Date Position Maker Start
            $this->add_control(
                'date_meta_position_maker',
                [
                    'label' => esc_html__( 'Position Maker', 'rsaddon' ),
                    'type' => Controls_Manager::POPOVER_TOGGLE,
                    'label_off' => esc_html__( 'Default', 'rsaddon' ),
                    'label_on' => esc_html__( 'Custom', 'rsaddon' ),
                    'return_value' => 'yes',
                    'default' => 'no',
                    'separator' => 'before',
                    'condition' => [
                        'blog_meta_date_show_hide' => 'yes',
                        'blog_meta_date_position' => 'date_p_absolute'
                    ],
                ]
            );
            $this->start_popover();
                $this->add_responsive_control(
                    'date_meta_p_top',
                    [
                        'label' => esc_html__( 'Top', 'rsaddon' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%', 'custom' ],
                        'range' => [
                            'px' => [
                                'min' => -1000,
                                'max' => 1000,
                            ],
                            '%' => [
                                'min' => -100,
                                'max' => 100,
                            ],
                        ],
                        'condition' => [
                            'blog_meta_date_show_hide' => 'yes',
                            'blog_meta_date_position' => 'date_p_absolute'
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .prelements-blog-slider .pre-blog-item .date_meta.date_p_absolute' => 'top: {{SIZE}}{{UNIT}};',
                        ],
                    ]
                );
                $this->add_responsive_control(
                    'date_meta_p_right',
                    [
                        'label' => esc_html__( 'Right', 'rsaddon' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%', 'custom' ],
                        'range' => [
                            'px' => [
                                'min' => -1000,
                                'max' => 1000,
                            ],
                            '%' => [
                                'min' => -100,
                                'max' => 100,
                            ],
                        ],
                        'condition' => [
                            'blog_meta_date_show_hide' => 'yes',
                            'blog_meta_date_position' => 'date_p_absolute'
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .prelements-blog-slider .pre-blog-item .date_meta.date_p_absolute' => 'right: {{SIZE}}{{UNIT}};',
                        ],
                    ]
                );
                $this->add_responsive_control(
                    'date_meta_p_bottom',
                    [
                        'label' => esc_html__( 'Bottom', 'rsaddon' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%', 'custom' ],
                        'range' => [
                            'px' => [
                                'min' => -1000,
                                'max' => 1000,
                            ],
                            '%' => [
                                'min' => -100,
                                'max' => 100,
                            ],
                        ],
                        'condition' => [
                            'blog_meta_date_show_hide' => 'yes',
                            'blog_meta_date_position' => 'date_p_absolute'
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .prelements-blog-slider .pre-blog-item .date_meta.date_p_absolute' => 'bottom: {{SIZE}}{{UNIT}};',
                        ],
                    ]
                );
                $this->add_responsive_control(
                    'date_meta_p_left',
                    [
                        'label' => esc_html__( 'Left', 'rsaddon' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%', 'custom' ],
                        'range' => [
                            'px' => [
                                'min' => -1000,
                                'max' => 1000,
                            ],
                            '%' => [
                                'min' => -100,
                                'max' => 100,
                            ],
                        ],
                        'condition' => [
                            'blog_meta_date_show_hide' => 'yes',
                            'blog_meta_date_position' => 'date_p_absolute'
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .prelements-blog-slider .pre-blog-item .date_meta.date_p_absolute' => 'left: {{SIZE}}{{UNIT}};',
                        ],
                    ]
                );
            $this->end_popover();
            // Date Position Maker End
        $this->end_controls_section();

        //Title Style Here
        $this->start_controls_section(
            'section_title_style',
            [
                'label' => esc_html__( 'Title Style', 'rsaddon' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'blog_title_show_hide' => 'yes'
                ]
            ]
        );
            $this->add_control(
                'title_color',
                [
                    'label' => esc_html__( 'Color', 'rsaddon' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .prelements-blog-slider .pre-blog-item .pre-blog-content .pre-post-title a' => 'color: {{VALUE}};',

                    ],                
                ]
            );
            $this->add_control(
                'title_color_hover',
                [
                    'label' => esc_html__( 'Hover Color', 'rsaddon' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .prelements-blog-slider .pre-blog-item .pre-blog-content .pre-post-title a:hover' => 'color: {{VALUE}};',
                    ],                
                ]            
            );
            $this->add_control(
                'title_hover_line_color',
                [
                    'label' => esc_html__( 'Line Color', 'rsaddon' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .prelements-blog-slider .pre-blog-item .pre-blog-content .pre-post-title a' => 'background-image: linear-gradient(to bottom, {{VALUE}} 0%, {{VALUE}} 100%);',
                    ],           
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'title_typography',
                    'label' => esc_html__( 'Typography', 'rsaddon' ),
                    'selector' => 
                        '{{WRAPPER}} .prelements-blog-slider .pre-blog-item .pre-blog-content .pre-post-title',
                ]
            );
            $this->add_responsive_control(
                'titles_padding',
                [
                    'label' => esc_html__( 'Padding', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', 'em', '%' ],
                    'selectors' => [
                        '{{WRAPPER}} .prelements-blog-slider .pre-blog-item .pre-blog-content .pre-post-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'titles_margin',
                [
                    'label' => esc_html__( 'Margin', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', 'em', '%' ],
                    'selectors' => [
                        '{{WRAPPER}} .prelements-blog-slider .pre-blog-item .pre-blog-content .pre-post-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'title_part_width',
                [
                    'label' => esc_html__( 'Max Width', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .prelements-blog-slider .pre-blog-item .pre-blog-content .pre-post-title' => 'max-width: {{SIZE}}{{UNIT}}; width: 100%;',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'title_border',
                    'selector' => '{{WRAPPER}} .prelements-blog-slider .pre-blog-item .pre-blog-content .pre-post-title',
                ]
            );
        $this->end_controls_section();

        //Description Style Here
        $this->start_controls_section(
            'section_description_style',
            [
                'label' => esc_html__( 'Description Style', 'rsaddon' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'blog_content_show_hide' => 'yes'
                ]
            ]
        );
            $this->add_control(
                'desc_color',
                [
                    'label' => esc_html__( 'Color', 'rsaddon' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .pre-blog-item .pre-blog-content .pre-content' => 'color: {{VALUE}};',

                    ],                
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'desc_typography',
                    'label' => esc_html__( 'Typography', 'rsaddon' ),
                    'selector' => 
                        '{{WRAPPER}} .pre-blog-item .pre-blog-content .pre-content',
                ]
            );
            $this->add_responsive_control(
                'desc_padding',
                [
                    'label' => esc_html__( 'Padding', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', 'em', '%' ],
                    'selectors' => [
                        '{{WRAPPER}} .pre-blog-item .pre-blog-content .pre-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'desc_margin',
                [
                    'label' => esc_html__( 'Margin', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', 'em', '%' ],
                    'selectors' => [
                        '{{WRAPPER}} .pre-blog-item .pre-blog-content .pre-content' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
        $this->end_controls_section();

        //Bottom Style start Here
        $this->start_controls_section(
            'section_btn_style',
            [
                'label' => esc_html__( 'Button Style', 'rsaddon' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'blog_btn_show_hide' => 'yes'
                ]
            ]
        );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'btn_typography',
                    'selector' => '{{WRAPPER}} .pre-blog-item .blog-btn-part a',
                ]
            );
            $this->add_responsive_control(
                'btn_icon_size',
                [
                    'label' => esc_html__( 'Icon Size', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .pre-blog-item .blog-btn-part a i' => 'font-size: {{SIZE}}{{UNIT}};',
                        '{{WRAPPER}} .pre-blog-item .blog-btn-part a svg' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'btn_padding',
                [
                    'label' => esc_html__( 'Padding', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .pre-blog-item .blog-btn-part a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                    ],
                ]
            );
            $this->add_responsive_control(
                'btn_border_radius',
                [
                    'label' => esc_html__( 'Border Radius', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .pre-blog-item .blog-btn-part a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'btn_margin',
                [
                    'label' => esc_html__( 'Margin', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .pre-blog-item .blog-btn-part' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'btn_width',
                [
                    'label' => esc_html__( 'Button Width', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .pre-blog-item .blog-btn-part a' => 'width: {{SIZE}}{{UNIT}}; padding: 0;',
                    ],
                ]
            );
            $this->add_responsive_control(
                'btn_height',
                [
                    'label' => esc_html__( 'Button Height', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .pre-blog-item .blog-btn-part a' => 'height: {{SIZE}}{{UNIT}}; padding: 0;',
                    ],
                ]
            );
            
            $this->start_controls_tabs( '_tabs_button' );
                $this->start_controls_tab(
                    '_blog_btn_normal',
                    [
                        'label' => esc_html__( 'Normal', 'rsaddon' ),
                    ]
                );
                    $this->add_control(
                        'btn_color',
                        [
                            'label' => esc_html__( 'Color', 'rsaddon' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pre-blog-item .pre-blog-content .blog-btn-part a,
                                {{WRAPPER}} .pre-blog-item .pre-blog-content .blog-btn-part a i' => 'color: {{VALUE}};',
                                '{{WRAPPER}} .pre-blog-item .pre-blog-content .blog-btn-part a svg path' => 'fill: {{VALUE}};'
                            ]
                        ]
                    );
                    $this->add_group_control(
                        \Elementor\Group_Control_Background::get_type(),
                        [
                            'name' => 'btn_bg_color',
                            'types' => [ 'classic', 'gradient'],
                            'selector' => '{{WRAPPER}} .pre-blog-item .pre-blog-content .blog-btn-part a',
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'btn_border',
                            'selector' => '{{WRAPPER}} .pre-blog-item .pre-blog-content .blog-btn-part a',
                        ]
                    );
                    $this->add_control(
                        'btn_icon_color',
                        [
                            'label' => esc_html__( 'Icon Color', 'rsaddon' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pre-blog-item .pre-blog-content .blog-btn-part a i' => 'color: {{VALUE}};',
                                '{{WRAPPER}} .pre-blog-item .pre-blog-content .blog-btn-part a svg path' => 'fill: {{VALUE}};'
                            ]
                        ]
                    );
                    $this->add_control(
                        'btn_icon_stroke_color',
                        [
                            'label' => esc_html__( 'Icon Stroke Color', 'rsaddon' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pre-blog-item .pre-blog-content .blog-btn-part a svg path' => 'stroke: {{VALUE}};'
                            ]
                        ]
                    );
                $this->end_controls_tab();

                $this->start_controls_tab(
                    '_blog_btn_button_hover',
                    [
                        'label' => esc_html__( 'Hover', 'rsaddon' ),
                    ]
                );
                    $this->add_control(
                        'btn_color_hover',
                        [
                            'label' => esc_html__( 'Color', 'rsaddon' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pre-blog-item .pre-blog-content .blog-btn-part a:hover,
                                {{WRAPPER}} .pre-blog-item .pre-blog-content .blog-btn-part a:hover i' => 'color: {{VALUE}};',
                                '{{WRAPPER}} .pre-blog-item .pre-blog-content .blog-btn-part a:hover svg path' => 'fill: {{VALUE}};'
                            ]              
                        ]
                    );
                    $this->add_group_control(
                        \Elementor\Group_Control_Background::get_type(),
                        [
                            'name' => 'btn_bg_color_hover',
                            'types' => [ 'classic', 'gradient'],
                            'selector' => '{{WRAPPER}} .pre-blog-item .pre-blog-content .blog-btn-part a:hover',
                        ]
                    );
                    $this->add_control(
                        'btn_border_color_hover',
                        [
                            'label' => esc_html__( 'Border Color', 'rsaddon' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pre-blog-item .pre-blog-content .blog-btn-part a:hover' => 'border-color: {{VALUE}};',
                            ]              
                        ]
                    );
                    $this->add_control(
                        'btn_icon_color_hover',
                        [
                            'label' => esc_html__( 'Icon Color', 'rsaddon' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pre-blog-item .pre-blog-content .blog-btn-part a:hover i' => 'color: {{VALUE}};',
                                '{{WRAPPER}} .pre-blog-item .pre-blog-content .blog-btn-part a:hover svg path' => 'fill: {{VALUE}};'
                            ]
                        ]
                    );
                    $this->add_control(
                        'btn_icon_stroke_color_hover',
                        [
                            'label' => esc_html__( 'Icon Stroke Color', 'rsaddon' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pre-blog-item .pre-blog-content .blog-btn-part a:hover svg path' => 'stroke: {{VALUE}};'
                            ]
                        ]
                    );
                $this->end_controls_tab();
            $this->end_controls_tabs();
        $this->end_controls_section();
        // Button Style end

        // Grid Control Start
		$this->start_controls_section(
			'content_grid_control',
			[
				'label' => esc_html__('Grid Settings', 'rsaddon'),
				'tab' => Controls_Manager::TAB_CONTENT,
				'condition' => [
					'widget_type_grid_slider' => 'grid'
				]
			]
		);
			$this->add_control(
				'grid_col_lg',
				[
					'label'   => esc_html__('Large Device', 'rsaddon'),
					'type'    => Controls_Manager::SELECT,
					'default' => '3',
					'options' => [
						'12' => '1 Column',
						'6' => '2 Column',
						'4' => '3 Column',
						'3' => '4 Column',
						'2' => '6 Column',
					],
				]
			);
			$this->add_control(
				'grid_col_md',
				[
					'label'   => esc_html__('Medium Device', 'rsaddon'),
					'type'    => Controls_Manager::SELECT,
					'default' => '4',
					'options' => [
						'12' => '1 Column',
						'6' => '2 Column',
						'4' => '3 Column',
						'3' => '4 Column',
						'2' => '6 Column',
					],
				]
			);
			$this->add_control(
				'grid_col_sm',
				[
					'label'   => esc_html__('Small Device', 'rsaddon'),
					'type'    => Controls_Manager::SELECT,
					'default' => '6',
					'options' => [
						'12' => '1 Column',
						'6' => '2 Column',
						'4' => '3 Column',
						'3' => '4 Column',
						'2' => '6 Column',
					],
				]
			);
			$this->add_control(
				'grid_col_xs',
				[
					'label'   => esc_html__('Extra Small Device', 'rsaddon'),
					'type'    => Controls_Manager::SELECT,
					'default' => '12',
					'options' => [
						'12' => '1 Column',
						'6' => '2 Column',
						'4' => '3 Column',
						'3' => '4 Column',
						'2' => '6 Column',
					],
				]
			);
			$this->add_responsive_control(
				'grid_col_margin',
				[
					'label' => esc_html__( 'Column Margin', 'rsaddon' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'rsaddon' ],
					'selectors' => [
						'{{WRAPPER}} .rs_latest_blog_slider .row [class*=col-]' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
		$this->end_controls_section();
		// Grid Control End

        //start slider settings
        $this->start_controls_section(
            'section_slider_settings',
            [
                'label' => esc_html__( 'Slider Settings', 'rsaddon' ),
                'tab' => Controls_Manager::TAB_CONTENT,
                'condition' => [
					'widget_type_grid_slider' => 'slider'
				]
            ]
        );

            $this->add_responsive_control(
                'blog_left_right_spacing',
                [
                    'label' => esc_html__( 'Item Padding', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', 'em', '%' ],
                    'selectors' => [
                    '{{WRAPPER}} .rs_latest_blog_slider .blog-inner-wrap' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_responsive_control(
                'item_gap_custom',
                [
                    'label' => esc_html__( 'Item Margin Left', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'show_label' => true,               
                    'range' => [
                        'px' => [
                            'max' => 100,
                        ],
                    ],
                    'default' => [
                        'size' => 15,
                    ],          
                    'selectors' => [
                        '{{WRAPPER}} .prelements-blog-slider .pre-blog-item' => 'margin-left:{{SIZE}}{{UNIT}};',                   
                    ],
                    'separator' => 'before',
                ]
            ); 
            $this->add_responsive_control(
                'item_gap_right_custom',
                [
                    'label' => esc_html__( 'Item Margin Right', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'show_label' => true,               
                    'range' => [
                        'px' => [
                            'max' => 100,
                        ],
                    ],
                    'default' => [
                        'size' => 15,
                    ],          
                    'selectors' => [   
                        '{{WRAPPER}} .prelements-blog-slider .pre-blog-item' => 'margin-right:{{SIZE}}{{UNIT}};',                    
                    ],
                    'separator' => 'before',
                ]
            ); 
            $this->add_control(
                'col_lg',
                [
                    'label'   => esc_html__( 'Desktops > 1199px', 'rsaddon' ),
                    'type'    => Controls_Manager::SELECT,  
                    'default' => 3,
                    'options' => [
                        '1' => esc_html__( '1 Column', 'rsaddon' ), 
                        '2' => esc_html__( '2 Column', 'rsaddon' ),
                        '3' => esc_html__( '3 Column', 'rsaddon' ),
                        '4' => esc_html__( '4 Column', 'rsaddon' ),
                        '6' => esc_html__( '6 Column', 'rsaddon' ),                 
                    ],
                    'separator' => 'before',
                                
                ]
                
            );
            $this->add_control(
                'col_md',
                [
                    'label'   => esc_html__( 'Desktops > 991px', 'rsaddon' ),
                    'type'    => Controls_Manager::SELECT,  
                    'default' => 3,         
                    'options' => [
                        '1' => esc_html__( '1 Column', 'rsaddon' ), 
                        '2' => esc_html__( '2 Column', 'rsaddon' ),
                        '3' => esc_html__( '3 Column', 'rsaddon' ),
                        '4' => esc_html__( '4 Column', 'rsaddon' ),
                        '6' => esc_html__( '6 Column', 'rsaddon' ),                     
                    ],
                    'separator' => 'before',
                                
                ]
                
            );
            $this->add_control(
                'col_sm',
                [
                    'label'   => esc_html__( 'Tablets > 767px', 'rsaddon' ),
                    'type'    => Controls_Manager::SELECT,  
                    'default' => 2,         
                    'options' => [
                        '1' => esc_html__( '1 Column', 'rsaddon' ), 
                        '2' => esc_html__( '2 Column', 'rsaddon' ),
                        '3' => esc_html__( '3 Column', 'rsaddon' ),
                        '4' => esc_html__( '4 Column', 'rsaddon' ),
                        '6' => esc_html__( '6 Column', 'rsaddon' ),                 
                    ],
                    'separator' => 'before',
                                
                ]
                
            );
            $this->add_control(
                'col_xs',
                [
                    'label'   => esc_html__( 'Tablets < 768px', 'rsaddon' ),
                    'type'    => Controls_Manager::SELECT,  
                    'default' => 1,         
                    'options' => [
                        '1' => esc_html__( '1 Column', 'rsaddon' ), 
                        '2' => esc_html__( '2 Column', 'rsaddon' ),
                        '3' => esc_html__( '3 Column', 'rsaddon' ),
                        '4' => esc_html__( '4 Column', 'rsaddon' ),
                        '6' => esc_html__( '6 Column', 'rsaddon' ),                 
                    ],
                    'separator' => 'before',
                                
                ]
                
            );
            $this->add_control(
                'slides_ToScroll',
                [
                    'label'   => esc_html__( 'Slide To Scroll', 'rsaddon' ),
                    'type'    => Controls_Manager::SELECT,  
                    'default' => 2,         
                    'options' => [
                        '1' => esc_html__( '1 Item', 'rsaddon' ),
                        '2' => esc_html__( '2 Item', 'rsaddon' ),
                        '3' => esc_html__( '3 Item', 'rsaddon' ),
                        '4' => esc_html__( '4 Item', 'rsaddon' ),                   
                    ],
                    'separator' => 'before',
                                
                ]
                
            );
            $this->add_control(
                'slider_dots',
                [
                    'label'   => esc_html__( 'Navigation Dots', 'rsaddon' ),
                    'type'    => Controls_Manager::SELECT,  
                    'default' => 'false',
                    'options' => [
                        'true' => esc_html__( 'Enable', 'rsaddon' ),
                        'false' => esc_html__( 'Disable', 'rsaddon' ),              
                    ],
                    'separator' => 'before',             
                ]
            );
            $this->add_control(
                'slider_dots_style',
                [
                    'label'   => esc_html__('Dots Style', 'rsaddon'),
                    'type'    => Controls_Manager::SELECT,
                    'default' => 'default',
                    'options' => [
                        'default' => esc_html__('Default', 'rsaddon'),
                        '2' => esc_html__('Style 2', 'rsaddon'),
                    ],
                    'condition' => [
                        'slider_dots' => 'true',
                    ]
                ]

            );
            $this->add_control(
                'slider_nav',
                [
                    'label'   => esc_html__( 'Navigation Nav', 'rsaddon' ),
                    'type'    => Controls_Manager::SELECT,  
                    'default' => 'false',           
                    'options' => [
                        'true' => esc_html__( 'Enable', 'rsaddon' ),
                        'false' => esc_html__( 'Disable', 'rsaddon' ),              
                    ],
                    'separator' => 'before',                            
                ]            
            );

            $this->add_control(
                'slider_autoplay',
                [
                    'label'   => esc_html__( 'Autoplay', 'rsaddon' ),
                    'type'    => Controls_Manager::SELECT,  
                    'default' => 'false',           
                    'options' => [
                        'true' => esc_html__( 'Enable', 'rsaddon' ),
                        'false' => esc_html__( 'Disable', 'rsaddon' ),              
                    ],
                    'separator' => 'before',
                                
                ]
                
            );

            $this->add_control(
                'slider_autoplay_speed',
                [
                    'label'   => esc_html__( 'Autoplay Slide Speed', 'rsaddon' ),
                    'type'    => Controls_Manager::SELECT,  
                    'default' => 3000,          
                    'options' => [
                        '1000' => esc_html__( '1 Seconds', 'rsaddon' ),
                        '2000' => esc_html__( '2 Seconds', 'rsaddon' ), 
                        '3000' => esc_html__( '3 Seconds', 'rsaddon' ), 
                        '4000' => esc_html__( '4 Seconds', 'rsaddon' ), 
                        '5000' => esc_html__( '5 Seconds', 'rsaddon' ), 
                    ],
                    'separator' => 'before',
                                
                ]
                
            );

            $this->add_control(
                'slider_stop_on_hover',
                [
                    'label'   => esc_html__( 'Stop on Hover', 'rsaddon' ),
                    'type'    => Controls_Manager::SELECT,
                    'default' => 'false',               
                    'options' => [
                        'true' => esc_html__( 'Enable', 'rsaddon' ),
                        'false' => esc_html__( 'Disable', 'rsaddon' ),              
                    ],
                    'separator' => 'before',
                                
                ]
                
            );

            $this->add_control(
                'slider_interval',
                [
                    'label'   => esc_html__( 'Autoplay Interval', 'rsaddon' ),
                    'type'    => Controls_Manager::SELECT,  
                    'default' => 3000,          
                    'options' => [
                        '5000' => esc_html__( '5 Seconds', 'rsaddon' ), 
                        '4000' => esc_html__( '4 Seconds', 'rsaddon' ), 
                        '3000' => esc_html__( '3 Seconds', 'rsaddon' ), 
                        '2000' => esc_html__( '2 Seconds', 'rsaddon' ), 
                        '1000' => esc_html__( '1 Seconds', 'rsaddon' ),     
                    ],
                    'separator' => 'before',
                                
                ]
                
            );

            $this->add_control(
                'slider_centerMode',
                [
                    'label'   => esc_html__( 'Center Mode', 'rsaddon' ),
                    'type'    => Controls_Manager::SELECT,
                    'default' => 'false',
                    'options' => [
                        'true' => esc_html__( 'Enable', 'rsaddon' ),
                        'false' => esc_html__( 'Disable', 'rsaddon' ),
                    ],
                    'separator' => 'before',
                                
                ]
                
            );
            $this->add_control(
                'variable_width',
                [
                    'label'   => esc_html__( 'Variable Width', 'rsaddon' ),
                    'type'    => Controls_Manager::SELECT,
                    'default' => 'false',
                    'options' => [
                        'true' => esc_html__( 'Enable', 'rsaddon' ),
                        'false' => esc_html__( 'Disable', 'rsaddon' ),
                    ],
                    'separator' => 'before',
                                
                ]
            );
            $this->add_responsive_control(
                'slide_item_variable_width',
                [
                    'label' => esc_html__( 'Item Width', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .prelements-blog-slider .pre-blog-item' => 'width: {{SIZE}}{{UNIT}} !important;',
                    ],
                    'condition' => [
                        'variable_width' => 'true'
                    ]
                ]
            );

        $this->end_controls_section(); 

        //end slider settings

        // Arrow Section Start
		$this->start_controls_section(
			'section_slider_style_arrow_ontrol',
			[
				'label' => esc_html__('Arrow Control', 'rsaddon'),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' => [
					'slider_nav' => 'true',
                    'widget_type_grid_slider' => 'slider'
				]
			]
		);
            // positioning start
            $this->add_control(
                'arrow_position_maker',
                [
                    'label' => esc_html__('Arrow Position Style', 'rsaddon'),
                    'type' => Controls_Manager::SELECT,
                    'default' => '',
                    'options' => [
                        '' => esc_html__('Default', 'rsaddon'),
                        'custom' => esc_html__('Custom', 'rsaddon'),
                    ],
                ]
            );
            $this->add_responsive_control(
                'arrow_prev_x_select',
                [
                    'label' => esc_html__('Prev Position X', 'rsaddon'),
                    'type' => Controls_Manager::SELECT,
                    'default' => '',
                    'options' => [
                        '' => esc_html__('Default', 'rsaddon'),
                        'left' => esc_html__('Left', 'rsaddon'),
                        'right' => esc_html__('Right', 'rsaddon'),
                    ],
                    'condition' => [
                        'arrow_position_maker' => 'custom'
                    ]
                ]
            );
            $this->add_responsive_control(
                'arrow_prev_left_position',
                [
                    'label' => esc_html__('Prev Left Position', 'rsaddon'),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => ['px', '%', 'custom'],
                    'range' => [
                        'px' => [
                            'min' => -1000,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs_latest_blog_slider .slick-prev' => 'left: {{SIZE}}{{UNIT}}; right: unset;',
                    ],
                    'condition' => [
                        'arrow_prev_x_select' => 'left',
                        'arrow_position_maker' => 'custom'
                    ]
                ]
            );
            $this->add_responsive_control(
                'arrow_prev_right_position',
                [
                    'label' => esc_html__('Prev Right Position', 'rsaddon'),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => ['px', '%', 'custom'],
                    'range' => [
                        'px' => [
                            'min' => -1000,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs_latest_blog_slider .slick-prev' => 'right: {{SIZE}}{{UNIT}}; left: unset;',
                    ],
                    'condition' => [
                        'arrow_prev_x_select' => 'right',
                        'arrow_position_maker' => 'custom'
                    ]
                ]
            );

            $this->add_responsive_control(
                'arrow_prev_y_select',
                [
                    'label' => esc_html__('Prev Position Y', 'rsaddon'),
                    'type' => Controls_Manager::SELECT,
                    'default' => '',
                    'options' => [
                        '' => esc_html__('Default', 'rsaddon'),
                        'top' => esc_html__('Top', 'rsaddon'),
                        'bottom' => esc_html__('Bottom', 'rsaddon'),
                    ],
                    'condition' => [
                        'arrow_position_maker' => 'custom'
                    ]
                ]
            );
            $this->add_responsive_control(
                'arrow_prev_top_position',
                [
                    'label' => esc_html__('Prev Top Position', 'rsaddon'),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => ['px', '%', 'custom'],
                    'range' => [
                        'px' => [
                            'min' => -1000,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs_latest_blog_slider .slick-prev' => 'top: {{SIZE}}{{UNIT}}; bottom: unset;',
                    ],
                    'condition' => [
                        'arrow_prev_y_select' => 'top',
                        'arrow_position_maker' => 'custom'
                    ]
                ]
            );
            $this->add_responsive_control(
                'arrow_prev_bottom_position',
                [
                    'label' => esc_html__('Prev Bottom Position', 'rsaddon'),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => ['px', '%', 'custom'],
                    'range' => [
                        'px' => [
                            'min' => -1000,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs_latest_blog_slider .slick-prev' => 'bottom: {{SIZE}}{{UNIT}}; top: unset;',
                    ],
                    'condition' => [
                        'arrow_prev_y_select' => 'bottom',
                        'arrow_position_maker' => 'custom'
                    ]
                ]
            );

            $this->add_responsive_control(
                'arrow_next_x_select',
                [
                    'label' => esc_html__('Next Position X', 'rsaddon'),
                    'type' => Controls_Manager::SELECT,
                    'default' => '',
                    'options' => [
                        '' => esc_html__('Default', 'rsaddon'),
                        'left' => esc_html__('Left', 'rsaddon'),
                        'right' => esc_html__('Right', 'rsaddon'),
                    ],
                    'condition' => [
                        'arrow_position_maker' => 'custom'
                    ]
                ]
            );
            $this->add_responsive_control(
                'arrow_next_left_position',
                [
                    'label' => esc_html__('Next Left Position', 'rsaddon'),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => ['px', '%', 'custom'],
                    'range' => [
                        'px' => [
                            'min' => -1000,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs_latest_blog_slider .slick-next' => 'left: {{SIZE}}{{UNIT}}; right: unset;',
                    ],
                    'condition' => [
                        'arrow_next_x_select' => 'left',
                        'arrow_position_maker' => 'custom'
                    ]
                ]
            );
            $this->add_responsive_control(
                'arrow_next_right_position',
                [
                    'label' => esc_html__('Next Right Position', 'rsaddon'),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => ['px', '%', 'custom'],
                    'range' => [
                        'px' => [
                            'min' => -1000,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs_latest_blog_slider .slick-next' => 'right: {{SIZE}}{{UNIT}}; left: unset;',
                    ],
                    'condition' => [
                        'arrow_next_x_select' => 'right',
                        'arrow_position_maker' => 'custom'
                    ]
                ]
            );

            $this->add_responsive_control(
                'arrow_next_y_select',
                [
                    'label' => esc_html__('Next Position Y', 'rsaddon'),
                    'type' => Controls_Manager::SELECT,
                    'default' => '',
                    'options' => [
                        '' => esc_html__('Default', 'rsaddon'),
                        'top' => esc_html__('Top', 'rsaddon'),
                        'bottom' => esc_html__('Bottom', 'rsaddon'),
                    ],
                    'condition' => [
                        'arrow_position_maker' => 'custom'
                    ]
                ]
            );
            $this->add_responsive_control(
                'arrow_next_top_position',
                [
                    'label' => esc_html__('Next Top Position', 'rsaddon'),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => ['px', '%', 'custom'],
                    'range' => [
                        'px' => [
                            'min' => -1000,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs_latest_blog_slider .slick-next' => 'top: {{SIZE}}{{UNIT}}; bottom: unset;',
                    ],
                    'condition' => [
                        'arrow_next_y_select' => 'top',
                        'arrow_position_maker' => 'custom'
                    ]
                ]
            );
            $this->add_responsive_control(
                'arrow_next_bottom_position',
                [
                    'label' => esc_html__('Next Bottom Position', 'rsaddon'),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => ['px', '%', 'custom'],
                    'range' => [
                        'px' => [
                            'min' => -1000,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs_latest_blog_slider .slick-next' => 'bottom: {{SIZE}}{{UNIT}}; top: unset;',
                    ],
                    'condition' => [
                        'arrow_next_y_select' => 'bottom',
                        'arrow_position_maker' => 'custom'
                    ]
                ]
            );
            // positioning end

            $this->add_control(
                'arrow_after_hr',
                [
                    'type' => \Elementor\Controls_Manager::DIVIDER,
                ]
            );

            $this->add_responsive_control(
                'navigation_arrow_width',
                [
                    'label' => esc_html__('Arrow Width', 'rsaddon'),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => ['px'],
                    'selectors' => [
                        '{{WRAPPER}} .rs_latest_blog_slider .slick-prev,
                        {{WRAPPER}} .rs_latest_blog_slider .slick-next' => 'width: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'navigation_arrow_height',
                [
                    'label' => esc_html__('Arrow Height', 'rsaddon'),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => ['px'],
                    'selectors' => [
                        '{{WRAPPER}} .rs_latest_blog_slider .slick-prev,
                        {{WRAPPER}} .rs_latest_blog_slider .slick-next' => 'height: {{SIZE}}{{UNIT}}; line-height: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'navigation_arrow_line_height',
                [
                    'label' => esc_html__('Arrow Line Height', 'rsaddon'),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => ['px'],
                    'selectors' => [
                        '{{WRAPPER}} .rs_latest_blog_slider .slick-prev,
                        {{WRAPPER}} .rs_latest_blog_slider .slick-next' => 'line-height: {{SIZE}}{{UNIT}} !important;',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'nav_icon_typography',
                    'label' => esc_html__('Icon Typography', 'rsaddon'),
                    'selector' => '
                        {{WRAPPER}} .rs_latest_blog_slider .slick-prev::before,
                        {{WRAPPER}} .rs_latest_blog_slider .slick-next::before
                    ',
                ]
            );

            $this->add_control(
                'arrow_border_radius_',
                [
                    'label' => esc_html__('Border Radius', 'rsaddon'),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', '%'],
                    'selectors' => [
                        '{{WRAPPER}} .rs_latest_blog_slider .slick-prev,
                        {{WRAPPER}} .rs_latest_blog_slider .slick-next' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_control(
                'arrow_border_padding_',
                [
                    'label' => esc_html__('Padding', 'rsaddon'),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', '%'],
                    'selectors' => [
                        '{{WRAPPER}} .rs_latest_blog_slider .slick-prev,
                        {{WRAPPER}} .rs_latest_blog_slider .slick-next' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            // Arrow Hover Normal Tab Start
            $this->start_controls_tabs('_tabs_slider_arrow');
                // Normal Arrow Start
                $this->start_controls_tab(
                    'slider_arrow_normal_tab',
                    [
                        'label' => esc_html__('Normal', 'rsaddon'),
                    ]
                );
                    $this->add_control(
                        'navigation_arrow_color',
                        [
                            'label' => esc_html__('Icon Color', 'rsaddon'),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .rs_latest_blog_slider .slick-prev::before,
                                {{WRAPPER}} .rs_latest_blog_slider .slick-next::before' => 'color: {{VALUE}};',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'navigation_arrow_background',
                            'types' => ['classic', 'gradient'],
                            'selector' => '
                                {{WRAPPER}} .rs_latest_blog_slider .slick-prev,
                                {{WRAPPER}} .rs_latest_blog_slider .slick-next
                            ',
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'nav_arrow_border',
                            'selector' => '
                                {{WRAPPER}} .rs_latest_blog_slider .slick-prev,
                                {{WRAPPER}} .rs_latest_blog_slider .slick-next
                            ',
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Box_Shadow::get_type(),
                        [
                            'name' => 'arrow_shadow_custom',
                            'selector' => '
                                {{WRAPPER}} .rs_latest_blog_slider .slick-prev,
                                {{WRAPPER}} .rs_latest_blog_slider .slick-next
                            ',
                        ]
                    );
                    $this->add_responsive_control(
                        'arrow_opacity',
                        [
                            'label' => esc_html__('Opacity', 'rsaddon'),
                            'type' => Controls_Manager::SLIDER,
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 1,
                                    'step' => 0.1,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .prelements-blog-slider .rs_latest_blog_slider .slick-arrow' => 'opacity: {{SIZE}}',
                            ]
                        ]
                    );
                $this->end_controls_tab();

                // Hover Arrow Start
                $this->start_controls_tab(
                    'slider_arrow_hover_tab',
                    [
                        'label' => esc_html__('Hover', 'rsaddon'),
                    ]
                );
                    $this->add_control(
                        'navigation_arrow_color_hover',
                        [
                            'label' => esc_html__('Icon Color', 'rsaddon'),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .rs_latest_blog_slider .slick-prev:hover::before,
                                {{WRAPPER}} .rs_latest_blog_slider .slick-next:hover::before' => 'color: {{VALUE}};',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'navigation_arrow_background_hover',
                            'types' => ['classic', 'gradient'],
                            'selector' => '
                                {{WRAPPER}} .rs_latest_blog_slider .slick-prev:hover,
                                {{WRAPPER}} .rs_latest_blog_slider .slick-next:hover
                            ',
                        ]
                    );
                    $this->add_control(
                        'nav_arrow_border_hover',
                        [
                            'label' => esc_html__('Border Color', 'rsaddon'),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .rs_latest_blog_slider .slick-prev:hover,
                                {{WRAPPER}} .rs_latest_blog_slider .slick-next:hover' => 'border-color: {{VALUE}};',
                            ],
                        ]
                    );
                    $this->add_responsive_control(
                        'arrow_opacity_hover',
                        [
                            'label' => esc_html__('Opacity', 'rsaddon'),
                            'type' => Controls_Manager::SLIDER,
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 1,
                                    'step' => 0.1,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .prelements-blog-slider .rs_latest_blog_slider:hover .slick-arrow' => 'opacity: {{SIZE}}',
                            ]
                        ]
                    );
                $this->end_controls_tab();
            $this->end_controls_tabs();
            // Arrow Hover Normal Tab End
		$this->end_controls_section();
		// Arrow Style End

        // Bullet Style Start
		$this->start_controls_section(
			'section_slider_style_dots_ontrol',
			[
				'label' => esc_html__('Dots Control', 'rsaddon'),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' => [
					'slider_dots' => 'true',
                    'widget_type_grid_slider' => 'slider'
				]
			]
		);
            $this->add_responsive_control(
                'dots_alignments',
                [
                    'label' => esc_html__('Alignment', 'rsaddon'),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'left' => [
                            'title' => esc_html__('Left', 'rsaddon'),
                            'icon' => 'eicon-text-align-left',
                        ],
                        'center' => [
                            'title' => esc_html__('Center', 'rsaddon'),
                            'icon' => 'eicon-text-align-center',
                        ],
                        'right' => [
                            'title' => esc_html__('Right', 'rsaddon'),
                            'icon' => 'eicon-text-align-right',
                        ],
                        'justify' => [
                            'title' => esc_html__('Justify', 'rsaddon'),
                            'icon' => 'eicon-text-align-justify',
                        ],
                    ],
                    'toggle' => true,
                    'selectors' => [
                        '{{WRAPPER}} .slick-dots' => 'text-align: {{VALUE}}'
                    ],
                ]
            );
            $this->add_control(
                'bullet_wrapper_box_style',
                [
                    'label' => esc_html__('Dots Wrapper Box', 'rsaddon'),
                    'type' => Controls_Manager::HEADING,
                    'classes' => 'rs-control-type-heading',
                ]
            );
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'bullet_wrapper_box_bg',
                    'types' => ['classic', 'gradient'],
                    'selector' => '{{WRAPPER}} .rs_latest_blog_slider .slick-dots',
                ]
            );
            $this->add_responsive_control(
                'bullet_wrapper_box_padding',
                [
                    'label' => esc_html__('Padding', 'rsaddon'),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', 'em', '%'],
                    'selectors' => [
                        '{{WRAPPER}} .rs_latest_blog_slider .slick-dots' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'bullet_wrapper_box_margin',
                [
                    'label' => esc_html__('Margin', 'rsaddon'),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', 'em', '%'],
                    'selectors' => [
                        '{{WRAPPER}} .rs_latest_blog_slider .slick-dots li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'bullet_wrapper_box_radius',
                [
                    'label' => esc_html__('Border Radius', 'rsaddon'),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', 'em', '%'],
                    'selectors' => [
                        '{{WRAPPER}} .rs_latest_blog_slider .slick-dots' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_control(
                '_hr',
                [
                    'type' => Controls_Manager::DIVIDER,
                    'style' => 'thick',
                ]
            );
            $this->add_control(
                'bullet_item_options',
                [
                    'label' => esc_html__('Bullet Item Style', 'rsaddon'),
                    'type' => Controls_Manager::HEADING,
                    'classes' => 'rs-control-type-heading',
                ]
            );
            $this->start_controls_tabs('_tabs_slider_dots');
                // Normal Bullet Start
                $this->start_controls_tab(
                    'slider_dots_normal_tab',
                    [
                        'label' => esc_html__('Normal', 'rsaddon'),
                    ]
                );

                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name'     => 'navigation_dot_inner_color',
                            'selector' => '{{WRAPPER}} .rs_latest_blog_slider .slick-dots li button:after',
                        ]
                    );
                    $this->add_responsive_control(
                        'bullet_inner_dot_height_custom',
                        [
                            'label' => esc_html__('Inner Dot Height', 'rsaddon'),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => ['px'],
                            'selectors' => [
                                '{{WRAPPER}} .rs_latest_blog_slider .slick-dots li button:after' => 'height: {{SIZE}}{{UNIT}};',
                            ],
                        ]
                    );
                    $this->add_responsive_control(
                        'bullet_inner_dot_normal_width_custom',
                        [
                            'label' => esc_html__('Inner Dot Width', 'rsaddon'),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => ['px'],
                            'selectors' => [
                                '{{WRAPPER}} .rs_latest_blog_slider .slick-dots li button:after' => 'width: {{SIZE}}{{UNIT}};',
                            ],
                        ]
                    );
                    $this->add_responsive_control(
                        'bullet_inner_dot_border_radius',
                        [
                            'label' => esc_html__('Inner Dot Radius', 'rsaddon'),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => ['px'],
                            'selectors' => [
                                '{{WRAPPER}} .rs_latest_blog_slider .slick-dots li button:after' => 'border-radius: {{SIZE}}{{UNIT}};',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name'     => 'navigation_dot_icon_background',
                            'selector' => '{{WRAPPER}} .rs_latest_blog_slider .slick-dots li button',
                        ]
                    );
                    $this->add_responsive_control(
                        'bullet_height_custom',
                        [
                            'label' => esc_html__('Bullet Height', 'rsaddon'),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => ['px'],
                            'selectors' => [
                                '{{WRAPPER}} .rs_latest_blog_slider .slick-dots li button' => 'height: {{SIZE}}{{UNIT}};',
                            ],
                        ]
                    );
                    $this->add_responsive_control(
                        'bullet_normal_width_custom',
                        [
                            'label' => esc_html__('Bullet Width', 'rsaddon'),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => ['px'],
                            'selectors' => [
                                '{{WRAPPER}} .rs_latest_blog_slider .slick-dots li button' => 'width: {{SIZE}}{{UNIT}};',
                            ],
                        ]
                    );
                    $this->add_control(
                        'bullet_border_radius_custom',
                        [
                            'label' => esc_html__('Border Radius', 'rsaddon'),
                            'type' => Controls_Manager::DIMENSIONS,
                            'size_units' => ['px', '%'],
                            'selectors' => [
                                '{{WRAPPER}} .rs_latest_blog_slider .slick-dots li button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'bullet_border_custom',
                            'selector' => '{{WRAPPER}} .rs_latest_blog_slider .slick-dots li button',
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Box_Shadow::get_type(),
                        [
                            'name' => 'bullet_shadow_custom',
                            'selector' => '{{WRAPPER}} .rs_latest_blog_slider .slick-dots li button'
                        ]
                    );
                $this->end_controls_tab();
                // Normal Bullet End

                // Active Bullet Start
                $this->start_controls_tab(
                    'slider_dots_active_tab',
                    [
                        'label' => esc_html__('Active', 'rsaddon'),
                    ]
                );

                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name'     => 'navigation_dot_inner_color_active',
                            'selector' => '{{WRAPPER}} .rs_latest_blog_slider .slick-dots li button:hover:after, 
                                            {{WRAPPER}} .rs_latest_blog_slider .slick-dots li.slick-active button:after',
                        ]
                    );
                    $this->add_responsive_control(
                        'bullet_inner_dot_height_custom_active',
                        [
                            'label' => esc_html__('Inner Dot Height', 'rsaddon'),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => ['px'],
                            'selectors' => [
                                '{{WRAPPER}} .rs_latest_blog_slider .slick-dots li button:hover:after,
                                {{WRAPPER}} .rs_latest_blog_slider .slick-dots li.slick-active button:after' => 'height: {{SIZE}}{{UNIT}};',
                            ],
                        ]
                    );
                    $this->add_responsive_control(
                        'bullet_inner_dot_active_width_custom',
                        [
                            'label' => esc_html__('Inner Dot Width', 'rsaddon'),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => ['px'],
                            'selectors' => [
                                '{{WRAPPER}} .rs_latest_blog_slider .slick-dots li button:hover:after,
                                {{WRAPPER}} .rs_latest_blog_slider .slick-dots li.slick-active button:after' => 'width: {{SIZE}}{{UNIT}};',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name'     => 'navigation_dot_icon_background_active',
                            'selector' => '{{WRAPPER}} .rs_latest_blog_slider .slick-dots li button:hover, {{WRAPPER}} .rs_latest_blog_slider .slick-dots li.slick-active button',
                        ]
                    );
                    $this->add_responsive_control(
                        'bullet_active_width_custom',
                        [
                            'label' => esc_html__('Bullet Width', 'rsaddon'),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => ['px'],
                            'selectors' => [
                                '{{WRAPPER}} .rs_latest_blog_slider .slick-dots li.slick-active button' => 'width: {{SIZE}}{{UNIT}};',
                            ],
                        ]
                    );
                    $this->add_responsive_control(
                        'bullet_active_height_custom',
                        [
                            'label' => esc_html__('Bullet Height', 'rsaddon'),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => ['px'],
                            'selectors' => [
                                '{{WRAPPER}} .rs_latest_blog_slider .slick-dots li.slick-active button' => 'height: {{SIZE}}{{UNIT}};',
                            ],
                        ]
                    );
                    $this->add_responsive_control(
                        'bullet_active_scale_custom',
                        [
                            'label' => esc_html__('Bullet Scale', 'rsaddon'),
                            'type' => Controls_Manager::SLIDER,
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 1000,
                                    'step' => 0.1,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .rs_latest_blog_slider .slick-dots li.slick-active button' => 'transform: scale({{SIZE}})',
                            ],
                        ]
                    );
                    $this->add_control(
                        'navigation_dot_active_border_color',
                        [
                            'label' => esc_html__('Border Color', 'rsaddon'),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .rs_latest_blog_slider .slick-dots li button:hover' => 'border-color: {{VALUE}};',
                                '{{WRAPPER}} .rs_latest_blog_slider .slick-dots li.slick-active button' => 'border-color: {{VALUE}};',

                            ],
                        ]
                    );
                $this->end_controls_tab();
            $this->end_controls_tabs();
            // Active Bullet End
            $this->add_responsive_control(
                'bullet_spacing_custom',
                [
                    'label' => esc_html__('Top Gap', 'rsaddon'),
                    'type' => Controls_Manager::SLIDER,
                    'show_label' => true,
                    'range' => [
                        'px' => [
                            'max' => 100,
                        ],
                    ],
                    'default' => [
                        'size' => 25,
                    ],
                    'separator' => 'before',
                    'selectors' => [
                        '{{WRAPPER}} .rs_latest_blog_slider .slick-dots' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'bullet_spacing_custom_position',
                [
                    'label' => esc_html__('Top Position', 'rsaddon'),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                    'show_label' => true,
                    'range' => [
                        'px' => [
                            'min' => -1000,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => -1000,
                            'max' => 1000,
                        ],
                    ],
                    'separator' => 'before',
                    'selectors' => [
                        '{{WRAPPER}} .rs_latest_blog_slider .slick-dots' => 'top: {{SIZE}}{{UNIT}}; bottom:unset;',
                    ],
                ]
            );
            $this->add_responsive_control(
                'bullet_spacing_custom_position_bottom',
                [
                    'label' => esc_html__('Bottom Position', 'rsaddon'),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                    'show_label' => true,
                    'range' => [
                        'px' => [
                            'min' => -1000,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => -1000,
                            'max' => 1000,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs_latest_blog_slider .slick-dots' => 'bottom: {{SIZE}}{{UNIT}}; top: unset;',
                    ],
                ]
            );
		$this->end_controls_section();
		// Bullet Style End

        // Grid Pagination Style Start
		$this->start_controls_section(
			'section_grid_pagination_control',
			[
				'label' => esc_html__('Pagination Control', 'rsaddon'),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' => [
					'show_grid_pagination' => 'yes',
                    'widget_type_grid_slider' => 'grid'
				]
			]
		);
            $this->add_control(
                'grid_pagination_wrapper_options',
                [
                    'label' => esc_html__( 'Wrapper Options', 'rsaddon' ),
                    'type' => Controls_Manager::HEADING,
                    'classes' => 'rs-control-type-heading',
                ]
            );
            $this->add_responsive_control(
                'grid_pagination_text_align',
                [
                    'label' => esc_html__( 'Alignment', 'rsaddon' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'left' => [
                            'title' => esc_html__( 'Left', 'rsaddon' ),
                            'icon' => 'eicon-text-align-left',
                        ],
                        'center' => [
                            'title' => esc_html__( 'Center', 'rsaddon' ),
                            'icon' => 'eicon-text-align-center',
                        ],
                        'right' => [
                            'title' => esc_html__( 'Right', 'rsaddon' ),
                            'icon' => 'eicon-text-align-right',
                        ],
                    ],
                    'default' => 'center',
                    'toggle' => true,
                    'selectors' => [
                        '{{WRAPPER}} .pagination-area .nav-links' => 'justify-content: {{VALUE}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'grid_pagination_margin',
                [
                    'label' => esc_html__( 'Margin', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .pagination-area' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            // Item
            $this->add_control(
                'grid_pagination_item_options',
                [
                    'label' => esc_html__( 'Item Options', 'rsaddon' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                    'classes' => 'rs-control-type-heading',
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'grid_pagination_item_typo',
                    'selector' => '{{WRAPPER}} .pagination-area .nav-links > *, {{WRAPPER}} .pagination-area .nav-links > *:before',
                ]
            );
            $this->add_responsive_control(
                'grid_pagination_item_gap_between',
                [
                    'label' => esc_html__( 'Gap Between', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .pagination-area .nav-links' => 'gap: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'grid_pagination_item_width',
                [
                    'label' => esc_html__( 'Width', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .pagination-area .nav-links > *' => 'width: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'grid_pagination_item_height',
                [
                    'label' => esc_html__( 'Height', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .pagination-area .nav-links > *' => 'height: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'grid_pagination_item_radius',
                [
                    'label' => esc_html__( 'Border Radius', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .pagination-area .nav-links > *' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->start_controls_tabs(
                'grid_pagination_item_style_tabs'
            );
                $this->start_controls_tab(
                    'grid_pagination_item_normal_tab',
                    [
                        'label' => esc_html__( 'Normal', 'rsaddon' ),
                    ]
                );
                    $this->add_control(
                        'grid_pagination_item_color',
                        [
                            'label' => esc_html__( 'Color', 'rsaddon' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pagination-area .nav-links > *' => 'color: {{VALUE}}',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'grid_pagination_item_background',
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .pagination-area .nav-links > *',
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'grid_pagination_item_border',
                            'selector' => '{{WRAPPER}} .pagination-area .nav-links > *',
                        ]
                    );
                $this->end_controls_tab();
                $this->start_controls_tab(
                    'grid_pagination_item_active_tab',
                    [
                        'label' => esc_html__( 'Active', 'rsaddon' ),
                    ]
                );
                    $this->add_control(
                        'grid_pagination_item_color_active',
                        [
                            'label' => esc_html__( 'Color', 'rsaddon' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .pagination-area .nav-links .current' => 'color: {{VALUE}}',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'grid_pagination_item_background_active',
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .pagination-area .nav-links .current',
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'grid_pagination_item_border_active',
                            'selector' => '{{WRAPPER}} .pagination-area .nav-links .current',
                        ]
                    );
                $this->end_controls_tab();
            $this->end_controls_tabs();
        $this->end_controls_section();
		// Grid Pagination Style End
    }

    /**
     * Render Prelements Blog Slider widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render() {

        $settings = $this->get_settings_for_display(); 
        $unique = rand(100,31120);
        $rtl = is_rtl() ? 'true' : 'false';
		$clip_path 			   = ('yes' === $settings['clip_path']) ? 'clip-path-enable' : '';

        if ('slider' == $settings['widget_type_grid_slider']){
            $slidesToShow    = !empty($settings['col_lg']) ? $settings['col_lg'] : 3;
            $autoplaySpeed   = $settings['slider_autoplay_speed'];
            $interval        = $settings['slider_interval'];
            $slidesToScroll  = $settings['slides_ToScroll'];
            $slider_autoplay = $settings['slider_autoplay'] === 'true' ? 'true' : 'false';
            $pauseOnHover    = $settings['slider_stop_on_hover'] === 'true' ? 'true' : 'false';
            $sliderDots      = $settings['slider_dots'] == 'true' ? 'true' : 'false';
            $sliderNav       = $settings['slider_nav'] == 'true' ? 'true' : 'false';        
            $centerMode      = $settings['slider_centerMode'] === 'true' ? 'true' : 'false';
            $variableWidth   = $settings['variable_width'] === 'true' ? 'true' : 'false';
            $col_lg          = $settings['col_lg'];
            $col_md          = $settings['col_md'];
            $col_sm          = $settings['col_sm'];
            $col_xs          = $settings['col_xs'];

            $grabClass = 'yes' == $settings['show_cursor_label'] ? 'gsap-cursor-attached-label' : '';

            $slider_conf = compact('slidesToShow', 'variableWidth', 'autoplaySpeed', 'interval', 'slidesToScroll', 'slider_autoplay','pauseOnHover', 'sliderDots', 'sliderNav', 'centerMode', 'col_lg', 'col_md', 'col_sm', 'col_xs');

            $columns_grid = '';
            $sliderClasses = 'prelements-unique-slider';
        } else {
			$sliderClasses = '';
			$grid_col_lg = 'col-lg-' . $settings['grid_col_lg'];
			$grid_col_md = 'col-md-' . $settings['grid_col_md'];
			$grid_col_sm = 'col-sm-' . $settings['grid_col_sm'];
			$grid_col_xs = 'col-' . $settings['grid_col_xs'];
			$columns_grid = $grid_col_lg . ' ' . $grid_col_md . ' ' . $grid_col_sm . ' ' . $grid_col_xs;
		}
        ?>

        <div class="<?php echo esc_attr( $sliderClasses ); ?> prelements-blog-slider <?php echo esc_attr($grabClass); ?>">
                <?php if ('yes' == $settings['show_cursor_label']) { ?>
                    <div class="label-move"><?php echo esc_html($settings['show_cursor_label_txt']); ?></div>
                <?php } ?>
                <!-- Default Old Style -->
                <?php if ('slider' == $settings['widget_type_grid_slider']){ ?>
                    <div id="prelements-slick-slider-<?php echo esc_attr($unique); ?>" class="prelements-addon-slider rs_latest_blog_slider blog_style_<?php echo esc_html($settings['latest_blog_slider_style']);?> slick-dots-<?php echo esc_attr($settings['slider_dots_style']); ?> <?php echo esc_attr($clip_path); ?>">
                <?php } else { ?>
                    <div class="rs_latest_blog_slider blog_style_<?php echo esc_html($settings['latest_blog_slider_style']);?>">
                        <div class="row">
                    <?php } ?>
                        <?php include plugin_dir_path(__FILE__)."/style1.php"; ?>                 
                    </div> <!-- end of grid .row & slider .rs_latest_blog_slider -->
            <?php if ('slider' == $settings['widget_type_grid_slider']){ ?>
                    <div class="prelements-slider-conf d-none" data-conf="<?php echo htmlspecialchars(json_encode($slider_conf)); ?>"></div>
                </div> <!-- end of .prelements-blog-slide -->
                <script type="text/javascript"> 
                    jQuery(document).ready(function(){
                        jQuery( '.prelements-addon-slider' ).each(function( index ) {        
                            var slider_id       = jQuery(this).attr('id'); 
                            var slider_conf     = jQuery.parseJSON( jQuery(this).closest('.prelements-blog-slider').find('.prelements-slider-conf').attr('data-conf'));               
                            if( typeof(slider_id) != 'undefined' && slider_id != '' ) {
                            jQuery('#'+slider_id).not('.slick-initialized').slick({
                            slidesToShow    : parseInt(slider_conf.col_lg),
                            centerMode      : (slider_conf.centerMode)  == "true" ? true : false,
                            dots            : (slider_conf.sliderDots)  == "true" ? true : false,
                            arrows          : (slider_conf.sliderNav) == "true" ? true : false,
                            autoplay        : (slider_conf.slider_autoplay) == "true" ? true : false,
                            variableWidth   : (slider_conf.variableWidth) == "true" ? true : false,
                            slidesToScroll  : parseInt(slider_conf.slidesToScroll),
                            centerPadding   : '15px',
                            rtl: <?php echo esc_attr($rtl); ?>,
                            autoplaySpeed   : parseInt(slider_conf.autoplaySpeed),
                            pauseOnHover    : (slider_conf.pauseOnHover) == "true" ? true : false,
                            gap: 30,
                            loop : false,
                            responsive: [{
                                breakpoint: 1025,
                                settings: {
                                    slidesToShow: parseInt(slider_conf.col_md),
                                }
                            }, 
                            {
                                breakpoint: 881,
                                settings: {
                                    slidesToShow: parseInt(slider_conf.col_sm),
                                }
                            }, 
                            {
                                breakpoint: 768,
                                settings: {
                                    arrows: false,
                                    slidesToShow: parseInt(slider_conf.col_xs),
                                }
                            }, ]
                            });
                        }        
                        });
                    });
                </script>
            <?php } else { ?>
                    </div><!-- end of grid .rs_latest_blog_slider -->
                </div><!-- end of .prelements-blog-slide -->
            <?php } ?>
        <?php
    }
    public function getCategories(){
        $cat_list = [];
            if ( post_type_exists( 'post' ) ) { 
            $terms = get_terms( array(
                'taxonomy'    => 'category',
                'hide_empty'  => true            
            ) );           
         
    
            foreach($terms as $post) {
                $cat_list[$post->slug]  = [$post->name];
            }
        }  
        return $cat_list;
    }
}