<?php
/**
 * Feature List
 *
 */

use Elementor\Repeater;
use Elementor\Utils;
use Elementor\Control_Media;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;
use Elementor\Icons_Manager;


defined( 'ABSPATH' ) || die();

class Rsaddon_Pro_Modal_Widget extends \Elementor\Widget_Base {

    /**
     * Get widget name.
     *
     * Retrieve rsgallery widget name.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget name.
     */

    public function get_name() {
        return 'rs_modal_box';
    }   


    /**
     * Get widget title.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title() {
        return esc_html__( 'RS Modal Box ', 'rsaddon' );
    }
    /**
     * Get widget icon.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'rs-badge';
    }


    public function get_categories() {
        return [ 'rsaddon_category' ];
    }

    public function get_keywords() {
        return [ 'modal', 'popup', 'maker', 'on load' ];
    }

	protected function register_controls() {
        $category_dropdown[0] = 'Select Template';
        $best_wp = new wp_Query(array(
            'post_type'      => 'elementor_library',
            'posts_per_page' => -1

        ));

        while ($best_wp->have_posts()) : $best_wp->the_post();
            $title = get_the_title();
            $id = get_the_ID();
            $category_dropdown[$id] = $title;

        endwhile;
        wp_reset_query();

        // Content Modal Trigger Start
		$this->start_controls_section(
			'_section_modal_trigger',
			[
				'label' => esc_html__( 'Modal Trigger', 'rsaddon' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
            $this->add_control(
                'trigger_type',
                [
                    'label' => esc_html__( 'Trigger Type', 'rsaddon' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => 'button',
                    'options' => [
                        'button'  => esc_html__( 'Button', 'rsaddon' ),
                        'image' => esc_html__( 'Image', 'rsaddon' ),
                        'onload' => esc_html__( 'On Load', 'rsaddon' )
                    ]
                ]
            );
            $this->add_control(
				'trigger_img',
				[
					'label' => esc_html__( 'Choose Image', 'rsaddon' ),
					'type' => Controls_Manager::MEDIA,
					'default' => [
						'url' => Utils::get_placeholder_image_src(),
					],
					'condition' => [
						'trigger_type' => 'image',
					]
				]
			);
            $this->add_control(
                'trigger_btn_txt',
                [
                    'label' => esc_html__( 'Button Text', 'rsaddon' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => esc_html__( 'Launch modal', 'rsaddon' ),
                    'placeholder' => esc_html__( 'Type your trigger button text here', 'rsaddon' ),
                    'condition' => [
                        'trigger_type' => 'button'
                    ]
                ]
            );
            $this->add_control(
				'trigger_icon',
				[
					'label' => __('Icon', 'rsaddon'),
					'type' => Controls_Manager::ICONS,
					'condition' => [
						'trigger_type' => 'button',
					]
				]
			);
            $this->add_control(
                'onload_delay',
                [
                    'label' => esc_html__( 'On Load Delay', 'rsaddon' ),
                    'placeholder' => esc_html__( '2000', 'rsaddon' ),
                    'type' => Controls_Manager::NUMBER,
                    'min' => 100,
                    'max' => 10000,
                    'step' => 100,
                    'condition' => [
                        'trigger_type' => 'onload'
                    ]
                ]
            );
            $this->add_control(
                'once_in_session',
                [
                    'label' => esc_html__( 'Once In a Session', 'rsaddon' ),
                    'type' => Controls_Manager::SWITCHER,
                    'label_on' => esc_html__( 'Yes', 'rsaddon' ),
                    'label_off' => esc_html__( 'No', 'rsaddon' ),
                    'return_value' => 'yes',
                    'default' => 'no',
                    'condition' => [
                        'trigger_type' => 'onload'
                    ]
                ]
            );
            $this->add_control(
                'prevent_for_logedin',
                [
                    'label' => esc_html__( 'Prevent For Logged In Users', 'rsaddon' ),
                    'type' => Controls_Manager::SWITCHER,
                    'label_on' => esc_html__( 'Yes', 'rsaddon' ),
                    'label_off' => esc_html__( 'No', 'rsaddon' ),
                    'return_value' => 'yes',
                    'default' => 'yes',
                    'condition' => [
                        'trigger_type' => 'onload'
                    ]
                ]
            );
        $this->end_controls_section();
        // Content Modal Trigger End

        // Content Modal Body Start
        $this->start_controls_section(
			'_section_modal_body',
			[
				'label' => esc_html__( 'Modal Body', 'rsaddon' ),
				'tab' => Controls_Manager::TAB_CONTENT
			]
		);
            // Header
            $this->add_control(
                'modal_body_header_content_control',
                [
                    'label' => esc_html__( 'Header Options', 'rsaddon' ),
                    'type' => Controls_Manager::HEADING,
                    'classes' => 'rs-control-type-heading',
                ]
            );
            $this->add_control(
                'show_modal_body_header',
                [
                    'label' => esc_html__( 'Show Header', 'rsaddon' ),
                    'type' => Controls_Manager::SWITCHER,
                    'label_on' => esc_html__( 'Show', 'rsaddon' ),
                    'label_off' => esc_html__( 'Hide', 'rsaddon' ),
                    'return_value' => 'yes',
                    'default' => 'yes'
                ]
            );
            $this->add_control(
                'modal_title',
                [
                    'label' => esc_html__( 'Title', 'rsaddon' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => esc_html__( 'Modal Header', 'rsaddon' ),
                    'placeholder' => esc_html__( 'Type your popup box title here', 'rsaddon' ),
                    'condition' => [
                        'show_modal_body_header' => 'yes'
                    ]
                ]
            );

            $this->add_control(
                'hr',
                [
                    'type' => Controls_Manager::DIVIDER,
                ]
            );

            // Body
            $this->add_control(
                'modal_body_content_control',
                [
                    'label' => esc_html__( 'Content Options', 'rsaddon' ),
                    'type' => Controls_Manager::HEADING,
                    'classes' => 'rs-control-type-heading',
                ]
            );
            $this->add_control(
                'modal_content_type',
                [
                    'label' => esc_html__( 'Content Type', 'rsaddon' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => 'default',
                    'options' => [
                        'default' => esc_html__( 'Default', 'rsaddon' ),
                        'templates' => esc_html__( 'Template', 'rsaddon' ),
                    ],
                ]
            );
            $this->add_control(
                'template',
                [
                    'label'       => esc_html__( 'Template', 'rsaddon' ),
                    'type'        => Controls_Manager::SELECT, 
                    'label_block' => true,
                    'default'     => 0,         
                    'options' => [] + $category_dropdown,
                    'condition' => [
                        'modal_content_type' => 'templates',
                    ],
                ]
            );
            $this->add_control(
                'modal_description',
                [
                    'label' => esc_html__( 'Description', 'rsaddon' ),
                    'type' => Controls_Manager::WYSIWYG,
                    'default' => esc_html__( 'Default description', 'rsaddon' ),
                    'placeholder' => esc_html__( 'Type your description here', 'rsaddon' ),
                    'condition' => [
                        'modal_content_type' => 'default',
                    ],
                ]
            );
            $this->add_control(
                'hr2',
                [
                    'type' => Controls_Manager::DIVIDER,
                ]
            );
            // Footer
            $this->add_control(
                'modal_body_footer_content_control',
                [
                    'label' => esc_html__( 'Footer Options', 'rsaddon' ),
                    'type' => Controls_Manager::HEADING,
                    'classes' => 'rs-control-type-heading',
                ]
            );
            $this->add_control(
                'show_modal_body_footer',
                [
                    'label' => esc_html__( 'Show Footer', 'rsaddon' ),
                    'type' => Controls_Manager::SWITCHER,
                    'label_on' => esc_html__( 'Show', 'rsaddon' ),
                    'label_off' => esc_html__( 'Hide', 'rsaddon' ),
                    'return_value' => 'yes',
                    'default' => 'yes'
                ]
            );
        $this->end_controls_section();
        // Content Modal Body End
        
        // Modal Close Button Start
        $this->start_controls_section(
			'_section_modal_close',
			[
				'label' => esc_html__( 'Close Button', 'rsaddon' ),
				'tab' => Controls_Manager::TAB_CONTENT
			]
		);
            // Header Button
            $this->add_control(
                'modal_body_header_button_control',
                [
                    'label' => esc_html__( 'Header Options', 'rsaddon' ),
                    'type' => Controls_Manager::HEADING,
                    'classes' => 'rs-control-type-heading',
                ]
            );
            $this->add_control(
                'body_header_close_icon',
                [
                    'label' => __('Icon', 'rsaddon'),
                    'type' => Controls_Manager::ICONS,
                    'default' => [
                        'value' => 'fas fa-times',
                        'library' => 'fa-solid',
                    ],
                ]
            );
            $this->add_control(
                'body_header_close_text',
                [
                    'label' => esc_html__( 'Close Button Text', 'rsaddon' ),
                    'type' => Controls_Manager::TEXT,
                    'placeholder' => esc_html__( 'e.g. Close', 'rsaddon' )
                ]
            );
            $this->add_control(
                'hr3',
                [
                    'type' => Controls_Manager::DIVIDER,
                ]
            );
            // Footer Button
            $this->add_control(
                'modal_body_footer_button_control',
                [
                    'label' => esc_html__( 'Footer Options', 'rsaddon' ),
                    'type' => Controls_Manager::HEADING,
                    'classes' => 'rs-control-type-heading',
                ]
            );
            $this->add_control(
                'body_footer_close_icon',
                [
                    'label' => __('Icon', 'rsaddon'),
                    'type' => Controls_Manager::ICONS
                ]
            );
            $this->add_control(
                'body_footer_close_text',
                [
                    'label' => esc_html__( 'Close Button Text', 'rsaddon' ),
                    'type' => Controls_Manager::TEXT,
                    'default' => esc_html__( 'Close', 'rsaddon' ),
                    'placeholder' => esc_html__( 'e.g. Close', 'rsaddon' )
                ]
            );
        $this->end_controls_section();
        // Modal Close Button End

        // Trigger Style Start
        $this->start_controls_section(
			'_section_modal_trigger_style',
			[
				'label' => esc_html__( 'Trigger Style', 'rsaddon' ),
				'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'trigger_type' => 'button'
                ]
			]
		);
            $this->add_control(
                'modal_trigger_btn_f_direction',
                [
                    'label' => esc_html__( 'Icon Position', 'rsaddon' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'row' => [
                            'title' => esc_html__( 'Default', 'rsaddon' ),
                            'icon' => 'eicon-nowrap',
                        ],
                        'row-reverse' => [
                            'title' => esc_html__( 'Reverse', 'rsaddon' ),
                            'icon' => 'eicon-wrap',
                        ]
                    ],
                    'toggle' => true,
                    'selectors' => [
                        '{{WRAPPER}} .rs-modal-maker a.modal-trigger.type-button' => 'flex-direction: {{VALUE}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'modal_trigger_btn_gap_between',
                [
                    'label' => esc_html__( 'Space Between', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-modal-maker a.modal-trigger.type-button' => 'gap: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'modal_trigger_btn_typography',
                    'selector' => '{{WRAPPER}} .rs-modal-maker a.modal-trigger.type-button',
                ]
            );
            $this->add_responsive_control(
                'modal_trigger_btn_icon_size',
                [
                    'label' => esc_html__( 'Icon Size', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-modal-maker a.modal-trigger.type-button svg' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
                        '{{WRAPPER}} .rs-modal-maker a.modal-trigger.type-button i' => 'font-size: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'modal_trigger_btn_padding',
                [
                    'label' => esc_html__( 'Padding', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-modal-maker a.modal-trigger.type-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ]
                ]
            );
            $this->add_responsive_control(
                'modal_trigger_btn_margin',
                [
                    'label' => esc_html__( 'Margin', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-modal-maker a.modal-trigger.type-button' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ]
                ]
            );
            $this->add_responsive_control(
                'modal_trigger_btn_border_radius',
                [
                    'label' => esc_html__( 'Border Radius', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-modal-maker a.modal-trigger.type-button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ]
                ]
            );
            $this->start_controls_tabs(
                'modal_trigger_btn_style_tabs'
            );
                $this->start_controls_tab(
                    'modal_trigger_btn_style_normal_tab',
                    [
                        'label' => esc_html__( 'Normal', 'rsaddon' ),
                    ]
                );
                    $this->add_control(
                        'modal_trigger_btn_text_color',
                        [
                            'label' => esc_html__( 'Text Color', 'rsaddon' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .rs-modal-maker a.modal-trigger.type-button' => 'color: {{VALUE}}',
                            ],
                        ]
                    );
                    $this->add_control(
                        'modal_trigger_btn_icon_color',
                        [
                            'label' => esc_html__( 'Icon Color', 'rsaddon' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .rs-modal-maker a.modal-trigger.type-button i' => 'color: {{VALUE}}',
                                '{{WRAPPER}} .rs-modal-maker a.modal-trigger.type-button svg path' => 'fill: {{VALUE}}',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'modal_trigger_btn_background',
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .rs-modal-maker a.modal-trigger.type-button'
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'modal_trigger_btn_border',
                            'selector' => '{{WRAPPER}} .rs-modal-maker a.modal-trigger.type-button'
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Box_Shadow::get_type(),
                        [
                            'name' => 'modal_trigger_btn_box_shadow',
                            'selector' => '{{WRAPPER}} .rs-modal-maker a.modal-trigger.type-button'
                        ]
                    );
                $this->end_controls_tab();
                $this->start_controls_tab(
                    'modal_trigger_btn_style_hover_tab',
                    [
                        'label' => esc_html__( 'Hover', 'rsaddon' ),
                    ]
                );
                    $this->add_control(
                        'modal_trigger_btn_text_color_hover',
                        [
                            'label' => esc_html__( 'Text Color', 'rsaddon' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .rs-modal-maker a.modal-trigger.type-button:hover' => 'color: {{VALUE}}',
                            ],
                        ]
                    );
                    $this->add_control(
                        'modal_trigger_btn_icon_color_hover',
                        [
                            'label' => esc_html__( 'Icon Color', 'rsaddon' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .rs-modal-maker a.modal-trigger.type-button:hover i' => 'color: {{VALUE}}',
                                '{{WRAPPER}} .rs-modal-maker a.modal-trigger.type-button:hover svg path' => 'fill: {{VALUE}}',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'modal_trigger_btn_background_hover',
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .rs-modal-maker a.modal-trigger.type-button:hover'
                        ]
                    );
                    $this->add_control(
                        'modal_trigger_btn_border_color_hover',
                        [
                            'label' => esc_html__( 'Border Color', 'rsaddon' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .rs-modal-maker a.modal-trigger.type-button:hover' => 'border-color: {{VALUE}}',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Box_Shadow::get_type(),
                        [
                            'name' => 'modal_trigger_btn_box_shadow_hover',
                            'selector' => '{{WRAPPER}} .rs-modal-maker a.modal-trigger.type-button:hover'
                        ]
                    );
                $this->end_controls_tab();
            $this->end_controls_tabs();
        $this->end_controls_section();
        // Trigger Style End

        // Modal Body Wrapper Style Start
		$this->start_controls_section(
			'_section_modal_body_wrapper_style',
			[
				'label' => esc_html__( 'Modal Body Wrapper', 'rsaddon' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
            $this->add_control(
                'overlay_area_options',
                [
                    'label' => esc_html__( 'Overlay Area', 'rsaddon' ),
                    'type' => Controls_Manager::HEADING,
                    'classes' => 'rs-control-type-heading',
                ]
            );
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'overlay_background',
                    'types' => [ 'classic', 'gradient' ],
                    'selector' => 'body .modal-backdrop',
                ]
            );
            $this->add_control(
                'content_wrapper_area_options',
                [
                    'label' => esc_html__( 'Content Wrapper Area', 'rsaddon' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                    'classes' => 'rs-control-type-heading',
                ]
            );
            $this->add_responsive_control(
                'content_wrapper_max_width',
                [
                    'label' => esc_html__( 'Max Width', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 10000
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-modal-maker .modal .modal-dialog' => 'max-width: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'content_wrapper_height',
                [
                    'label' => esc_html__( 'Height', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 10000
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-modal-maker .modal .modal-dialog .modal-content' => 'height: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'content_wrapper_background',
                    'types' => [ 'classic', 'gradient' ],
                    'selector' => '{{WRAPPER}} .rs-modal-maker .modal .modal-dialog .modal-content',
                ]
            );
            $this->add_responsive_control(
                'content_wrapper_padding',
                [
                    'label' => esc_html__( 'Padding', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-modal-maker .modal .modal-dialog .modal-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'content_wrapper_border_radius',
                [
                    'label' => esc_html__( 'Border Radius', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-modal-maker .modal .modal-dialog .modal-content' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'content_wrapper_border',
                    'selector' => '{{WRAPPER}} .rs-modal-maker .modal .modal-dialog .modal-content',
                ]
            );
            $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                    'name' => 'content_wrapper_box_shadow',
                    'selector' => '{{WRAPPER}} .rs-modal-maker .modal .modal-dialog .modal-content',
                ]
            );
        $this->end_controls_section();
        // Modal Body Wrapper Style End

        // Modal Content Style Start
		$this->start_controls_section(
			'_section_modal_content_style',
			[
				'label' => esc_html__( 'Modal Content', 'rsaddon' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
            // Header Style
            $this->add_control(
                'modal_content_header_style_options',
                [
                    'label' => esc_html__( 'Header Style', 'rsaddon' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                    'condition' => [
                        'show_modal_body_header' => 'yes'
                    ],
                    'classes' => 'rs-control-type-heading',
                ]
            );
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'modal_content_header_background',
                    'types' => [ 'classic', 'gradient' ],
                    'selector' => '{{WRAPPER}} .rs-modal-maker .modal .modal-dialog .modal-content .modal-header',
                    'condition' => [
                        'show_modal_body_header' => 'yes'
                    ]
                ]
            );
            $this->add_responsive_control(
                'modal_content_header_padding',
                [
                    'label' => esc_html__( 'Padding', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-modal-maker .modal .modal-dialog .modal-content .modal-header' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'condition' => [
                        'show_modal_body_header' => 'yes'
                    ]
                ]
            );
            $this->add_responsive_control(
                'modal_content_header_margin',
                [
                    'label' => esc_html__( 'Margin', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-modal-maker .modal .modal-dialog .modal-content .modal-header' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'condition' => [
                        'show_modal_body_header' => 'yes'
                    ]
                ]
            );
            $this->add_responsive_control(
                'modal_content_header_border_radius',
                [
                    'label' => esc_html__( 'Border Radius', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-modal-maker .modal .modal-dialog .modal-content .modal-header' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'condition' => [
                        'show_modal_body_header' => 'yes'
                    ]
                ]
            );
            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'modal_content_header_border',
                    'selector' => '{{WRAPPER}} .rs-modal-maker .modal .modal-dialog .modal-content .modal-header',
                    'condition' => [
                        'show_modal_body_header' => 'yes'
                    ]
                ]
            );
            $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                    'name' => 'modal_content_header_box_shadow',
                    'selector' => '{{WRAPPER}} .rs-modal-maker .modal .modal-dialog .modal-content .modal-header',
                    'condition' => [
                        'show_modal_body_header' => 'yes'
                    ]
                ]
            );
            // Header Title Style
            $this->add_control(
                'modal_content_header_title_style_options',
                [
                    'label' => esc_html__( 'Header Title Style', 'rsaddon' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                    'classes' => 'rs-control-type-heading',
                    'condition' => [
                        'show_modal_body_header' => 'yes'
                    ]
                ]
            );
            $this->add_control(
                'modal_content_header_title_color',
                [
                    'label' => esc_html__( 'Text Color', 'rsaddon' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .rs-modal-maker .modal .modal-dialog .modal-content .modal-header .modal-title' => 'color: {{VALUE}}',
                    ],
                    'condition' => [
                        'show_modal_body_header' => 'yes'
                    ]
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'modal_content_header_title_typography',
                    'selector' => '{{WRAPPER}} .rs-modal-maker .modal .modal-dialog .modal-content .modal-header .modal-title',
                    'condition' => [
                        'show_modal_body_header' => 'yes'
                    ]
                ]
            );
            $this->add_responsive_control(
                'modal_content_header_title_margin',
                [
                    'label' => esc_html__( 'Margin', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-modal-maker .modal .modal-dialog .modal-content .modal-header .modal-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'condition' => [
                        'show_modal_body_header' => 'yes'
                    ]
                ]
            );
            // Body Style
            $this->add_control(
                'modal_content_body_style_options',
                [
                    'label' => esc_html__( 'Body Style', 'rsaddon' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                    'classes' => 'rs-control-type-heading',
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'modal_content_body_typography',
                    'selector' => '{{WRAPPER}} .rs-modal-maker .modal .modal-dialog .modal-content .modal-body, {{WRAPPER}} .rs-modal-maker .modal .modal-dialog .modal-content .modal-body p',
                ]
            );
            $this->add_control(
                'modal_content_body_text_color',
                [
                    'label' => esc_html__( 'Text Color', 'rsaddon' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .rs-modal-maker .modal .modal-dialog .modal-content .modal-body,
                        {{WRAPPER}} .rs-modal-maker .modal .modal-dialog .modal-content .modal-body p' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'modal_content_body_background',
                    'types' => [ 'classic', 'gradient' ],
                    'selector' => '{{WRAPPER}} .rs-modal-maker .modal .modal-dialog .modal-content .modal-body'
                ]
            );
            $this->add_responsive_control(
                'modal_content_body_padding',
                [
                    'label' => esc_html__( 'Padding', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-modal-maker .modal .modal-dialog .modal-content .modal-body' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ]
                ]
            );
            $this->add_responsive_control(
                'modal_content_body_margin',
                [
                    'label' => esc_html__( 'Margin', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-modal-maker .modal .modal-dialog .modal-content .modal-body' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ]
                ]
            );
            $this->add_responsive_control(
                'modal_content_body_border_radius',
                [
                    'label' => esc_html__( 'Border Radius', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-modal-maker .modal .modal-dialog .modal-content .modal-body' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ]
                ]
            );
            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'modal_content_body_border',
                    'selector' => '{{WRAPPER}} .rs-modal-maker .modal .modal-dialog .modal-content .modal-body'
                ]
            );
            $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                    'name' => 'modal_content_body_box_shadow',
                    'selector' => '{{WRAPPER}} .rs-modal-maker .modal .modal-dialog .modal-content .modal-body'
                ]
            );
            // Footer Style
            $this->add_control(
                'modal_content_footer_style_options',
                [
                    'label' => esc_html__( 'Footer Style', 'rsaddon' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                    'classes' => 'rs-control-type-heading',
                    'condition' => [
                        'show_modal_body_footer' => 'yes'
                    ]
                ]
            );
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'modal_content_footer_background',
                    'types' => [ 'classic', 'gradient' ],
                    'selector' => '{{WRAPPER}} .rs-modal-maker .modal .modal-dialog .modal-content .modal-footer',
                    'condition' => [
                        'show_modal_body_footer' => 'yes'
                    ]
                ]
            );
            $this->add_responsive_control(
                'modal_content_footer_padding',
                [
                    'label' => esc_html__( 'Padding', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-modal-maker .modal .modal-dialog .modal-content .modal-footer' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'condition' => [
                        'show_modal_body_footer' => 'yes'
                    ]
                ]
            );
            $this->add_responsive_control(
                'modal_content_footer_margin',
                [
                    'label' => esc_html__( 'Margin', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-modal-maker .modal .modal-dialog .modal-content .modal-footer' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'condition' => [
                        'show_modal_body_footer' => 'yes'
                    ]
                ]
            );
            $this->add_responsive_control(
                'modal_content_footer_border_radius',
                [
                    'label' => esc_html__( 'Border Radius', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-modal-maker .modal .modal-dialog .modal-content .modal-footer' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'condition' => [
                        'show_modal_body_footer' => 'yes'
                    ]
                ]
            );
            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'modal_content_footer_border',
                    'selector' => '{{WRAPPER}} .rs-modal-maker .modal .modal-dialog .modal-content .modal-footer',
                    'condition' => [
                        'show_modal_body_footer' => 'yes'
                    ]
                ]
            );
            $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                    'name' => 'modal_content_footer_box_shadow',
                    'selector' => '{{WRAPPER}} .rs-modal-maker .modal .modal-dialog .modal-content .modal-footer',
                    'condition' => [
                        'show_modal_body_footer' => 'yes'
                    ]
                ]
            );
        $this->end_controls_section();
        // Modal Content Style End

        // Close Button Style Start
        $this->start_controls_section(
			'_section_modal_close_btn_style',
			[
				'label' => esc_html__( 'Close Button', 'rsaddon' ),
				'tab' => Controls_Manager::TAB_STYLE
			]
		);
            // Common Button Style
            $this->add_control(
                'modal_close_btn_common_style_opt',
                [
                    'label' => esc_html__( 'Common Button Options', 'rsaddon' ),
                    'type' => Controls_Manager::HEADING,
                    'classes' => 'rs-control-type-heading',
                ]
            );
            $this->add_control(
                'modal_close_btn_f_direction',
                [
                    'label' => esc_html__( 'Icon Position', 'rsaddon' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'row' => [
                            'title' => esc_html__( 'Default', 'rsaddon' ),
                            'icon' => 'eicon-nowrap',
                        ],
                        'row-reverse' => [
                            'title' => esc_html__( 'Reverse', 'rsaddon' ),
                            'icon' => 'eicon-wrap',
                        ]
                    ],
                    'toggle' => true,
                    'selectors' => [
                        '{{WRAPPER}} .rs-modal-maker .modal .modal-dialog .modal-content >* .modal_close_btn' => 'flex-direction: {{VALUE}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'modal_close_btn_gap_between',
                [
                    'label' => esc_html__( 'Space Between', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-modal-maker .modal .modal-dialog .modal-content >* .modal_close_btn' => 'gap: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'modal_close_btn_width',
                [
                    'label' => esc_html__( 'Width', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-modal-maker .modal .modal-dialog .modal-content >* .modal_close_btn' => 'width: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'modal_close_btn_height',
                [
                    'label' => esc_html__( 'Height', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-modal-maker .modal .modal-dialog .modal-content >* .modal_close_btn' => 'height: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'modal_close_btn_typography',
                    'selector' => '{{WRAPPER}} .rs-modal-maker .modal .modal-dialog .modal-content >* .modal_close_btn',
                ]
            );
            $this->add_responsive_control(
                'modal_close_btn_icon_size',
                [
                    'label' => esc_html__( 'Icon Size', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-modal-maker .modal .modal-dialog .modal-content >* .modal_close_btn svg' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
                        '{{WRAPPER}} .rs-modal-maker .modal .modal-dialog .modal-content >* .modal_close_btn i' => 'font-size: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'modal_close_btn_padding',
                [
                    'label' => esc_html__( 'Padding', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-modal-maker .modal .modal-dialog .modal-content >* .modal_close_btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ]
                ]
            );
            $this->add_responsive_control(
                'modal_close_btn_margin',
                [
                    'label' => esc_html__( 'Margin', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-modal-maker .modal .modal-dialog .modal-content >* .modal_close_btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ]
                ]
            );
            $this->add_responsive_control(
                'modal_close_btn_border_radius',
                [
                    'label' => esc_html__( 'Border Radius', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-modal-maker .modal .modal-dialog .modal-content >* .modal_close_btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ]
                ]
            );
            $this->start_controls_tabs(
                'modal_close_btn_style_tabs'
            );
                $this->start_controls_tab(
                    'modal_close_btn_style_normal_tab',
                    [
                        'label' => esc_html__( 'Normal', 'rsaddon' ),
                    ]
                );
                    $this->add_control(
                        'modal_close_btn_text_color',
                        [
                            'label' => esc_html__( 'Text Color', 'rsaddon' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .rs-modal-maker .modal .modal-dialog .modal-content >* .modal_close_btn' => 'color: {{VALUE}}',
                            ],
                        ]
                    );
                    $this->add_control(
                        'modal_close_btn_icon_color',
                        [
                            'label' => esc_html__( 'Icon Color', 'rsaddon' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .rs-modal-maker .modal .modal-dialog .modal-content >* .modal_close_btn i' => 'color: {{VALUE}}',
                                '{{WRAPPER}} .rs-modal-maker .modal .modal-dialog .modal-content >* .modal_close_btn svg path' => 'fill: {{VALUE}}',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'modal_close_btn_background',
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .rs-modal-maker .modal .modal-dialog .modal-content >* .modal_close_btn'
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'modal_close_btn_border',
                            'selector' => '{{WRAPPER}} .rs-modal-maker .modal .modal-dialog .modal-content >* .modal_close_btn'
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Box_Shadow::get_type(),
                        [
                            'name' => 'modal_close_btn_box_shadow',
                            'selector' => '{{WRAPPER}} .rs-modal-maker .modal .modal-dialog .modal-content >* .modal_close_btn'
                        ]
                    );
                $this->end_controls_tab();
                $this->start_controls_tab(
                    'modal_close_btn_style_hover_tab',
                    [
                        'label' => esc_html__( 'Hover', 'rsaddon' ),
                    ]
                );
                    $this->add_control(
                        'modal_close_btn_text_color_hover',
                        [
                            'label' => esc_html__( 'Text Color', 'rsaddon' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .rs-modal-maker .modal .modal-dialog .modal-content >* .modal_close_btn:hover' => 'color: {{VALUE}}',
                            ],
                        ]
                    );
                    $this->add_control(
                        'modal_close_btn_icon_color_hover',
                        [
                            'label' => esc_html__( 'Icon Color', 'rsaddon' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .rs-modal-maker .modal .modal-dialog .modal-content >* .modal_close_btn:hover i' => 'color: {{VALUE}}',
                                '{{WRAPPER}} .rs-modal-maker .modal .modal-dialog .modal-content >* .modal_close_btn:hover svg path' => 'fill: {{VALUE}}',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'modal_close_btn_background_hover',
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .rs-modal-maker .modal .modal-dialog .modal-content >* .modal_close_btn:hover'
                        ]
                    );
                    $this->add_control(
                        'modal_close_btn_border_color_hover',
                        [
                            'label' => esc_html__( 'Border Color', 'rsaddon' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .rs-modal-maker .modal .modal-dialog .modal-content >* .modal_close_btn:hover' => 'border-color: {{VALUE}}',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Box_Shadow::get_type(),
                        [
                            'name' => 'modal_close_btn_box_shadow_hover',
                            'selector' => '{{WRAPPER}} .rs-modal-maker .modal .modal-dialog .modal-content >* .modal_close_btn:hover'
                        ]
                    );
                $this->end_controls_tab();
            $this->end_controls_tabs();

            // Footer Close Button
            $this->add_control(
                'modal_close_btn_footer_style_opt',
                [
                    'label' => esc_html__( 'Footer Button Options', 'rsaddon' ),
                    'type' => Controls_Manager::HEADING,
                    'separator' => 'before',
                    'classes' => 'rs-control-type-heading',
                    'condition' => [
                        'show_modal_body_footer' => 'yes'
                    ]
                ]
            );
            $this->add_control(
                'modal_footer_close_btn_f_direction',
                [
                    'label' => esc_html__( 'Icon Position', 'rsaddon' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'row' => [
                            'title' => esc_html__( 'Default', 'rsaddon' ),
                            'icon' => 'eicon-nowrap',
                        ],
                        'row-reverse' => [
                            'title' => esc_html__( 'Reverse', 'rsaddon' ),
                            'icon' => 'eicon-wrap',
                        ]
                    ],
                    'toggle' => true,
                    'selectors' => [
                        '{{WRAPPER}} .rs-modal-maker .modal .modal-dialog .modal-content .modal-footer .modal_close_btn' => 'flex-direction: {{VALUE}};',
                    ],
                    'condition' => [
                        'show_modal_body_footer' => 'yes'
                    ]
                ]
            );
            $this->add_responsive_control(
                'modal_footer_close_btn_gap_between',
                [
                    'label' => esc_html__( 'Space Between', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-modal-maker .modal .modal-dialog .modal-content .modal-footer .modal_close_btn' => 'gap: {{SIZE}}{{UNIT}};',
                    ],
                    'condition' => [
                        'show_modal_body_footer' => 'yes'
                    ]
                ]
            );
            $this->add_responsive_control(
                'modal_footer_close_btn_width',
                [
                    'label' => esc_html__( 'Width', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-modal-maker .modal .modal-dialog .modal-content .modal-footer .modal_close_btn' => 'width: {{SIZE}}{{UNIT}};',
                    ],
                    'condition' => [
                        'show_modal_body_footer' => 'yes'
                    ]
                ]
            );
            $this->add_responsive_control(
                'modal_footer_close_btn_height',
                [
                    'label' => esc_html__( 'Height', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-modal-maker .modal .modal-dialog .modal-content .modal-footer .modal_close_btn' => 'height: {{SIZE}}{{UNIT}};',
                    ],
                    'condition' => [
                        'show_modal_body_footer' => 'yes'
                    ]
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'modal_footer_close_btn_typography',
                    'selector' => '{{WRAPPER}} .rs-modal-maker .modal .modal-dialog .modal-content .modal-footer .modal_close_btn',
                    'condition' => [
                        'show_modal_body_footer' => 'yes'
                    ]
                ]
            );
            $this->add_responsive_control(
                'modal_footer_close_btn_icon_size',
                [
                    'label' => esc_html__( 'Icon Size', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-modal-maker .modal .modal-dialog .modal-content .modal-footer .modal_close_btn svg' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
                        '{{WRAPPER}} .rs-modal-maker .modal .modal-dialog .modal-content .modal-footer .modal_close_btn i' => 'font-size: {{SIZE}}{{UNIT}};',
                    ],
                    'condition' => [
                        'show_modal_body_footer' => 'yes'
                    ]
                ]
            );
            $this->add_responsive_control(
                'modal_footer_close_btn_padding',
                [
                    'label' => esc_html__( 'Padding', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-modal-maker .modal .modal-dialog .modal-content .modal-footer .modal_close_btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'condition' => [
                        'show_modal_body_footer' => 'yes'
                    ]
                ]
            );
            $this->add_responsive_control(
                'modal_footer_close_btn_margin',
                [
                    'label' => esc_html__( 'Margin', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-modal-maker .modal .modal-dialog .modal-content .modal-footer .modal_close_btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'condition' => [
                        'show_modal_body_footer' => 'yes'
                    ]
                ]
            );
            $this->add_responsive_control(
                'modal_footer_close_btn_border_radius',
                [
                    'label' => esc_html__( 'Border Radius', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-modal-maker .modal .modal-dialog .modal-content .modal-footer .modal_close_btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'condition' => [
                        'show_modal_body_footer' => 'yes'
                    ]
                ]
            );
            $this->start_controls_tabs(
                'modal_footer_close_btn_style_tabs',
                [
                    'condition' => [
                        'show_modal_body_footer' => 'yes'
                    ]
                ]
            );
                $this->start_controls_tab(
                    'modal_footer_close_btn_style_normal_tab',
                    [
                        'label' => esc_html__( 'Normal', 'rsaddon' ),
                    ]
                );
                    $this->add_control(
                        'modal_footer_close_btn_text_color',
                        [
                            'label' => esc_html__( 'Text Color', 'rsaddon' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .rs-modal-maker .modal .modal-dialog .modal-content .modal-footer .modal_close_btn' => 'color: {{VALUE}}',
                            ],
                        ]
                    );
                    $this->add_control(
                        'modal_footer_close_btn_icon_color',
                        [
                            'label' => esc_html__( 'Icon Color', 'rsaddon' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .rs-modal-maker .modal .modal-dialog .modal-content .modal-footer .modal_close_btn i' => 'color: {{VALUE}}',
                                '{{WRAPPER}} .rs-modal-maker .modal .modal-dialog .modal-content .modal-footer .modal_close_btn svg path' => 'fill: {{VALUE}}',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'modal_footer_close_btn_background',
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .rs-modal-maker .modal .modal-dialog .modal-content .modal-footer .modal_close_btn'
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'modal_footer_close_btn_border',
                            'selector' => '{{WRAPPER}} .rs-modal-maker .modal .modal-dialog .modal-content .modal-footer .modal_close_btn'
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Box_Shadow::get_type(),
                        [
                            'name' => 'modal_footer_close_btn_box_shadow',
                            'selector' => '{{WRAPPER}} .rs-modal-maker .modal .modal-dialog .modal-content .modal-footer .modal_close_btn'
                        ]
                    );
                $this->end_controls_tab();
                $this->start_controls_tab(
                    'modal_footer_close_btn_style_hover_tab',
                    [
                        'label' => esc_html__( 'Hover', 'rsaddon' ),
                    ]
                );
                    $this->add_control(
                        'modal_footer_close_btn_text_color_hover',
                        [
                            'label' => esc_html__( 'Text Color', 'rsaddon' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .rs-modal-maker .modal .modal-dialog .modal-content .modal-footer .modal_close_btn:hover' => 'color: {{VALUE}}',
                            ],
                        ]
                    );
                    $this->add_control(
                        'modal_footer_close_btn_icon_color_hover',
                        [
                            'label' => esc_html__( 'Icon Color', 'rsaddon' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .rs-modal-maker .modal .modal-dialog .modal-content .modal-footer .modal_close_btn:hover i' => 'color: {{VALUE}}',
                                '{{WRAPPER}} .rs-modal-maker .modal .modal-dialog .modal-content .modal-footer .modal_close_btn:hover svg path' => 'fill: {{VALUE}}',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'modal_footer_close_btn_background_hover',
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .rs-modal-maker .modal .modal-dialog .modal-content .modal-footer .modal_close_btn:hover'
                        ]
                    );
                    $this->add_control(
                        'modal_footer_close_btn_border_color_hover',
                        [
                            'label' => esc_html__( 'Border Color', 'rsaddon' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .rs-modal-maker .modal .modal-dialog .modal-content .modal-footer .modal_close_btn:hover' => 'border-color: {{VALUE}}',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Box_Shadow::get_type(),
                        [
                            'name' => 'modal_footer_close_btn_box_shadow_hover',
                            'selector' => '{{WRAPPER}} .rs-modal-maker .modal .modal-dialog .modal-content .modal-footer .modal_close_btn:hover'
                        ]
                    );
                $this->end_controls_tab();
            $this->end_controls_tabs();
        $this->end_controls_section();
        // Close Button Style End
    }

  

	protected function render() {
        $settings = $this->get_settings_for_display();
        $unique = 'rs_modal_' . $this->get_id();
        $onload_pop_delay = !empty($settings['onload_delay']) ? $settings['onload_delay'] : '1000';
    ?> 

        <div class="rs-modal-maker">
            <?php if ('onload' !== $settings['trigger_type']) { ?> 
                <a class="modal-trigger type-<?php echo esc_attr($settings['trigger_type']); ?>" data-bs-toggle="modal" data-bs-target="#<?php echo esc_attr( $unique ); ?>">
                    <?php
                        if ('image' == $settings['trigger_type']) {
                            if (!empty($settings['trigger_img']['url'])) { ?>
                                <img src="<?php echo esc_url( $settings['trigger_img']['url'] ); ?>" alt="<?php echo esc_attr(Control_Media::get_image_alt($settings['trigger_img'])); ?>">
                            <?php }
                        } else {
                            if (!empty($settings['trigger_btn_txt'])) {
                                echo esc_html($settings['trigger_btn_txt']);
                            }
                            if (!empty($settings['trigger_icon']['value'])) {
                                Icons_Manager::render_icon($settings['trigger_icon'], ['aria-hidden' => 'true']);
                            }
                        }
                    ?>
                </a>
            <?php } ?>

            <!-- Modal Body -->
            <div class="modal fade" id="<?php echo esc_attr( $unique ); ?>" tabindex="-1" aria-hidden="true">
                <div class="modal-dialog">
                    <div class="modal-content" data-lenis-prevent>
                        <?php if ('yes' == $settings['show_modal_body_header']) { ?>
                            <div class="modal-header">
                                <h4 class="modal-title"><?php echo esc_html( $settings['modal_title'] ); ?></h4>
                                <div class="modal_close_btn" data-bs-dismiss="modal">
                                    <?php
                                        if (!empty($settings['body_header_close_text'])) {
                                            echo esc_html( $settings['body_header_close_text'] );
                                        }
                                        if (!empty($settings['body_header_close_icon']['value'])) {
                                            Icons_Manager::render_icon($settings['body_header_close_icon'], ['aria-hidden' => 'true']);
                                        }
                                    ?>
                                </div>
                            </div>
                        <?php } ?>
                        <div class="modal-body">
                            <?php if ('templates' == $settings['modal_content_type']) {
                                $id = $settings['template'];                     
                                $template_id = $id;
                                if ( class_exists( '\Elementor\Plugin' ) ) {
                                    if ( \Elementor\Plugin::$instance->db->is_built_with_elementor( $template_id ) ) {
                                        echo \Elementor\Plugin::$instance->frontend->get_builder_content( $template_id );
                                    } else {
                                        echo 'Elementor is not enabled for this template ID.';
                                    }
                                }
                            } else {
                                echo wp_kses_post($settings['modal_description']);
                            } ?>
                        </div>
                        <?php if ('yes' == $settings['show_modal_body_footer']) { ?>
                            <div class="modal-footer">
                                <div class="modal_close_btn" data-bs-dismiss="modal">
                                    <?php
                                        if (!empty($settings['body_footer_close_text'])) {
                                            echo esc_html( $settings['body_footer_close_text'] );
                                        }
                                        if (!empty($settings['body_footer_close_icon']['value'])) {
                                            Icons_Manager::render_icon($settings['body_footer_close_icon'], ['aria-hidden' => 'true']);
                                        }
                                    ?>
                                </div>
                            </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>

        <?php if ('onload' == $settings['trigger_type'] && !\Elementor\Plugin::instance()->editor->is_edit_mode()) {
            $showModal = true;
            
            if ('yes' === $settings['prevent_for_logedin'] && is_user_logged_in()) {
                $showModal = false;
            }
            if ($showModal) { ?>
                <script>
                    (function($) {
                        "use strict";
                        $(window).on('load', function() {
                            var showOnceInSession = <?php echo json_encode('yes' == $settings['once_in_session']); ?>;
                            var modalShown = sessionStorage.getItem('modalShown');
                            
                            if (!showOnceInSession || (showOnceInSession && !modalShown)) {
                                setTimeout(function() {
                                    $('#<?php echo esc_attr($unique); ?>').modal('show');
                                    if (showOnceInSession) {
                                        sessionStorage.setItem('modalShown', 'true');
                                    }
                                }, <?php echo esc_html($onload_pop_delay); ?>);
                            }
                        });
                    })(jQuery);
                </script>
            <?php }
        } ?>

    <?php }
}
