<?php 
	use Elementor\Icons_Manager;
    $cat = $settings['portfolio_category'];
	$select_portfolio = $settings['select_portfolio_item'];
    $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;

	if(empty($cat)){
    	$best_wp = new wp_Query(array(
			'post_type'      => 'portfolios',
			'posts_per_page' => $settings['per_page'],	
			'orderby' => 'menu_order',
			'post__in' => $select_portfolio,
			'order' 			=> $settings['pre_posts_sort'],							
		));	  
    }   
    else{
    	$best_wp = new wp_Query(array(
				'post_type'      => 'portfolios',
				'posts_per_page' => $settings['per_page'],	
				'orderby' => 'menu_order',
				'order' 			=> $settings['pre_posts_sort'],		
				'post__in' => $select_portfolio,	
				'tax_query'      => array(
			        array(
						'taxonomy' => 'portfolios-category',
						'field'    => 'slug', //can be set to ID
						'terms'    => $cat //if field is ID you can reference by cat/term number
			        ),
			    )
		));	  
    }

    $x=1;

	while($best_wp->have_posts()): $best_wp->the_post();	
		$content       = get_the_content();
		$cats_show = get_the_term_list( $best_wp->ID, 'portfolios-category', ' ', '<span class="separator">,</span> ');

		$unique = $this->get_id() . '_' . rand(4545, 5485);
	?>

		<div class="col-lg-<?php echo esc_html($settings['portfolio_columns']);?> col-md-<?php echo esc_html($settings['portfolio_md_columns']);?> col-xs-1 grid-item col-sm-<?php echo esc_html($settings['portfolio_sm_columns']);?>">
			<div class="portfolio-item content-overlay unique-<?php echo $unique ?>">
				<?php if(has_post_thumbnail()):
					$thumbnail_id = get_post_thumbnail_id();
					$thumbnail_alt = get_post_meta( $thumbnail_id, '_wp_attachment_image_alt', true );
					if ( empty( $thumbnail_alt ) ) {
						$thumbnail_alt = get_the_title( $thumbnail_id );
					}?>
					<div class="portfolio-img">
					<?php echo wp_get_attachment_image( $thumbnail_id, $settings['thumbnail_size'], false, ['alt' => $thumbnail_alt] );?>
					<?php if ('yes' == $settings['plus_icon_show_hide']) {?>
					<div class="portfolio-link">
						<a href="<?php the_permalink(); ?>">
							<svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
								<path d="M10 1L10 19M19 10.75L1 10.75" stroke="white" stroke-width="2" stroke-linecap="round"/>
							</svg>
						</a>
					</div>
					<?php } ?>
					<div class="img-overlay"></div>
                </div>
                <?php endif;?>

                <div class="portfolio-details">
                	<p class="p-category"><?php echo wp_kses_post( $cats_show ); ?></p>
            		<?php if(get_the_title()):?>
            	        <h4 class="p-title">
            	            <a href="<?php the_permalink() ?>">
            	                <?php the_title();?>
            	                <?php if ('yes' == $settings['title_icon_show_hide']) {?>
            	                    <span class="title-icons">
            	                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 14 14"><path d="M6 6V0H8V6H14V8H8V14H6V8H0V6H6Z" fill="#071230"></path></svg>
            	                    </span>
            	                <?php } ?>
            	            </a>
            	        </h4>
            	    <?php endif;?>
                </div>
				<?php if ('yes' == $settings['show_button']) { ?>
				<div class="p-icon">
					<a href="<?php the_permalink(); ?>" class="prs_btn">
						<span>
							<?php
							if (!empty($settings['read_more_text'])) {
								echo esc_html($settings['read_more_text']);
							}
							?>
							<?php if (!empty($settings['read_more_icon']['value'])) : ?>
								<em class="btn_icon_1"><?php \Elementor\Icons_Manager::render_icon($settings['read_more_icon'], ['aria-hidden' => 'true']); ?></em>
								<em class="btn_icon_2"><?php \Elementor\Icons_Manager::render_icon($settings['read_more_icon'], ['aria-hidden' => 'true']); ?> </em>
							<?php endif; ?>
						</span>
					</a>
				</div>

			<?php } ?>
			<?php if ('yes' === $settings['glass_effect']) { ?>
				<svg xmlns="http://www.w3.org/2000/svg" version="1.1">
					<filter id="turbulence<?php echo $unique ?>" filterUnits="objectBoundingBox" x="0" y="0" width="100%" height="100%">
						<feTurbulence id="feTurbulence<?php echo $unique ?>" type="fractalNoise" baseFrequency="0.05 0"></feTurbulence>
						<feDisplacementMap xChannelSelector="G" yChannelSelector="B" scale="0" in="SourceGraphic"></feDisplacementMap>
					</filter>
				</svg>
				<style>
					.portfolio-item.unique-<?php echo $unique ?> .portfolio-img img {
						filter: url('#turbulence<?php echo $unique ?>');
					}
				</style>
			<?php } ?>
            </div>
		</div>
		
	<?php
	$x++;	
	endwhile;
	wp_reset_query();  