<?php
use Elementor\Icons_Manager;

$cat = $settings['portfolio_category'];
$select_portfolio = $settings['select_portfolio_item'];
$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;

$icon_image = $settings['icon_image_show_hide'];

if (empty($cat)) {
	$best_wp = new wp_Query(array(
		'post_type'      => 'portfolios',
		'posts_per_page' => $settings['per_page'],
		'post__in' => $select_portfolio,
		'orderby' => 'menu_order',
		'order' 			=> $settings['pre_posts_sort'],
	));
} else {
	$best_wp = new wp_Query(array(
		'post_type'      => 'portfolios',
		'posts_per_page' => $settings['per_page'],
		'orderby' => 'menu_order',
		'post__in' => $select_portfolio,
		'order' 			=> $settings['pre_posts_sort'],
		'tax_query'      => array(
			array(
				'taxonomy' => 'portfolios-category',
				'field'    => 'slug', //can be set to ID
				'terms'    => $cat //if field is ID you can reference by cat/term number
			),
		)
	));
}

$x = 1;

while ($best_wp->have_posts()) : $best_wp->the_post();

	$content       = get_the_content();
	$column_cl = get_post_meta( get_the_ID(), 'portfolios_column', true);
	$cats_show = get_the_term_list($best_wp->ID, 'portfolios-category', ' ', '<span class="separator">,</span> ');

	if(isset($column_cl) && !empty($column_cl)) {
		$col_class = $column_cl;
	} else {
		$col_class = $settings['portfolio_columns'];
	}

	$unique = $this->get_id() . '_' . rand(4545, 5485);

?>
	<div class="col-lg-<?php echo esc_html($col_class); ?> col-md-<?php echo esc_html($settings['portfolio_md_columns']); ?> col-xs-1 grid-item col-sm-<?php echo esc_html($settings['portfolio_sm_columns']); ?>">
		<div class="portfolio-item content-overlay rsportfolio-grid-style2 unique-<?php echo $unique ?>">
			<?php if (has_post_thumbnail()) :
				$thumbnail_id = get_post_thumbnail_id();
				$thumbnail_alt = get_post_meta( $thumbnail_id, '_wp_attachment_image_alt', true );
				if ( empty( $thumbnail_alt ) ) {
					$thumbnail_alt = get_the_title( $thumbnail_id );
				}?>
				<a href="<?php the_permalink(); ?>">
					<div class="portfolio-img">
						<?php if(isset($column_cl) && !empty($column_cl)) {
							echo wp_get_attachment_image( $thumbnail_id, '898x450', false, ['alt' => $thumbnail_alt] );
						} else {
							echo wp_get_attachment_image( $thumbnail_id, $settings['thumbnail_size'], false, ['alt' => $thumbnail_alt] ); 
						} ?>
					</div>
				</a>
			<?php endif; ?>

			<div class="portfolio-details">
				<div class="portfolio-title-cat">
					<?php if (get_the_title()) : ?>
						
						<h4 class="p-title">
							<a href="<?php the_permalink() ?>">
								<?php the_title(); ?>
							</a>
						</h4>
						
					<?php endif; ?>
					<p class="p-category"><?php echo wp_kses_post($cats_show); ?></p>
				</div>
			</div>
			<?php if ('yes' == $settings['show_button']) { ?>
				<div class="p-icon">
					<a href="<?php the_permalink(); ?>" class="prs_btn">
						<span>
							<?php
							if (!empty($settings['read_more_text'])) {
								echo esc_html($settings['read_more_text']);
							}
							?>
							<?php if (!empty($settings['read_more_icon']['value'])) : ?>
								<?php \Elementor\Icons_Manager::render_icon($settings['read_more_icon'], ['aria-hidden' => 'true']); ?>
							<?php endif; ?>
						</span>
					</a>
				</div>
			<?php } ?>
			<?php if ('yes' === $settings['glass_effect']) { ?>
				<svg xmlns="http://www.w3.org/2000/svg" version="1.1">
					<filter id="turbulence<?php echo $unique ?>" filterUnits="objectBoundingBox" x="0" y="0" width="100%" height="100%">
						<feTurbulence id="feTurbulence<?php echo $unique ?>" type="fractalNoise" baseFrequency="0.05 0"></feTurbulence>
						<feDisplacementMap xChannelSelector="G" yChannelSelector="B" scale="0" in="SourceGraphic"></feDisplacementMap>
					</filter>
				</svg>
				<style>
					.portfolio-item.unique-<?php echo $unique ?> .portfolio-img img {
						filter: url('#turbulence<?php echo $unique ?>');
					}
				</style>
			<?php } ?>
		</div>
	</div>
<?php
	$x++;
endwhile;
wp_reset_query();