<?php 
	use Elementor\Icons_Manager;
    $cat = $settings['portfolio_category'];
	$select_portfolio = $settings['select_portfolio_item'];
    $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
	$unique = rand(515155,879797);

	if(empty($cat)){
    	$best_wp = new wp_Query(array(
			'post_type'      => 'portfolios',
			'posts_per_page' => $settings['per_page'],	
			'orderby' => 'menu_order',
			'post__in' => $select_portfolio,
			'order' 			=> $settings['pre_posts_sort'],							
		));	  
    }   
    else{
    	$best_wp = new wp_Query(array(
				'post_type'      => 'portfolios',
				'posts_per_page' => $settings['per_page'],	
				'orderby' => 'menu_order',
				'order' 			=> $settings['pre_posts_sort'],		
				'post__in' => $select_portfolio,	
				'tax_query'      => array(
			        array(
						'taxonomy' => 'portfolios-category',
						'field'    => 'slug', //can be set to ID
						'terms'    => $cat //if field is ID you can reference by cat/term number
			        ),
			    )
		));	  
    }

	$counter = 0;
	$thumb_counter = 0;?>
	<div class="project-both-wrap">
		<div class="portfolio_acc_feature_image portfolio-<?php echo esc_attr($unique); ?>">
			<?php 
			while($best_wp->have_posts()): $best_wp->the_post();
			$thumb_counter++;
			$first_item_active = ($thumb_counter == 1) ? 'active' : '';
			$thumbnail_id = get_post_thumbnail_id();
			$thumbnail_alt = get_post_meta( $thumbnail_id, '_wp_attachment_image_alt', true );
			if ( empty( $thumbnail_alt ) ) {
				$thumbnail_alt = get_the_title( $thumbnail_id );
			}
			?>
				<img class="<?php echo esc_attr($thumb_counter); ?> <?php echo esc_attr($first_item_active); ?>" src="<?php echo get_the_post_thumbnail_url();?>" alt="<?php echo esc_attr( $thumbnail_alt );?>">
			<?php endwhile; ?>
		</div>
		<div class="portfolio-accordion accordion portfolio-<?php echo esc_attr($unique); ?>" id="portfolio_accordion_inner_<?php echo esc_attr($unique); ?>">
			<?php
			while($best_wp->have_posts()): $best_wp->the_post();
				$cats_show = get_the_term_list( $best_wp->ID, 'portfolios-category', ' ', '<span class="separator">,</span> ');
				$description = get_post_meta( get_the_ID(), 'custom_description', true );

				$i = rand(20212,351820);
				$counter++;
				$first_item_collapsed = ($counter !== 1) ? 'collapsed' : '';
				$first_item_show = ($counter == 1) ? 'show' : '';
			?>
				<div class="accordion-item item-<?php echo esc_attr($counter); ?>">
					<div class="accordion-header" id="heading<?php echo esc_attr($i);?>">
						<div class="portfolio-acc-btn <?php echo esc_attr($first_item_collapsed); ?>" data-bs-toggle="collapse" data-bs-target="#collapse_<?php echo esc_attr($i);?>" aria-controls="collapse_<?php echo esc_attr($i);?>">
							<h4 class="tab-title"><?php echo the_title();?></h4>
						</div>
					</div>
					<div id="collapse_<?php echo esc_attr($i);?>" class="accordion-collapse collapse <?php echo esc_attr($first_item_show); ?>" aria-labelledby="heading<?php echo esc_attr($i);?>" data-bs-parent="#portfolio_accordion_inner_<?php echo esc_attr($unique); ?>">
						<div class="accordion-body">
							<?php if (!empty($description)) {?>
								<p class="desc"><?php echo esc_html($description); ?></p>
							<?php } else {
								echo esc_html("Description not found.");
							}
							if (!empty($settings['read_more_text'])) {
								if ('yes' == $settings['show_button']) { ?>
									<div class="p-icon">
										<a href="<?php the_permalink(); ?>" class="prs_btn"><?php echo esc_html($settings['read_more_text']); ?></a>
									</div>
								<?php }
							} ?>
						</div>
					</div>
				</div>
			<?php endwhile; ?>
		</div>
	</div>

		<script>
			jQuery(document).ready(function($){
				$('.portfolio-<?php echo esc_attr($unique); ?> .accordion-item').click(function(){
					$('.portfolio-<?php echo esc_attr($unique); ?>.portfolio_acc_feature_image img').removeClass('active');
					var number = $(this).attr('class').split(' ').pop().split('-').pop();
					$('.portfolio-<?php echo esc_attr($unique); ?>.portfolio_acc_feature_image img.' + number).addClass('active');
				});
			});
		</script>
	<?php
	wp_reset_query();  