<?php
/**
 * Elementor rsgallery Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */
use Elementor\Group_Control_Css_Filter;
use Elementor\Repeater;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Background;
use Elementor\Utils;


defined('ABSPATH') || die();

class Rsaddon_Portfolio_Slider_Pro_Widget extends \Elementor\Widget_Base
{

	/**
	 * Get widget name.
	 *
	 * Retrieve rsgallery widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name()
	{
		return 'portfolio-slider';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve rsgallery widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title()
	{
		return __('RS Portfolio Slider', 'rsaddon');
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve rsgallery widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon()
	{
		return 'rs-badge';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the rsgallery widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories()
	{
		return ['rsaddon_category'];
	}

	/**
	 * Register rsgallery widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls()
	{


		$post_dropdown[0] = 'Select Portfolio';
		$wp_portfolio_query = new wp_Query(array(
			'post_type'      => 'portfolios',
			'posts_per_page' => '-1',
		));

		if ($wp_portfolio_query->have_posts()) :
			while ($wp_portfolio_query->have_posts()) : $wp_portfolio_query->the_post();
				$id    = get_the_ID($wp_portfolio_query->ID);
				$title = get_the_title($wp_portfolio_query->ID);
				$post_dropdown[$id] = $title;
			endwhile;
			wp_reset_query();
		endif;

		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__('Content', 'rsaddon'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);


		$this->add_control(
			'portfolio_slider_style',
			[
				'label'   => esc_html__('Select Style', 'rsaddon'),
				'type'    => Controls_Manager::SELECT,
				'default' => '1',
				'options' => [
					'1' => 'Style 1',
					'2' => 'Style 2',
					'3' => 'Style 3',
					'4' => 'Style 4',
					'5' => 'Style 5',
					'6' => 'Style 6',
					'7' => 'Style 7'
				],
			]
		);
		$this->add_control(
			'portfolio_is_manual_selection',
			[
				'label' => esc_html__('Select Portfolio by:', 'prelements'),
				'type' => Controls_Manager::SELECT,
				'default' => '',
				'options' => [
					'yes'       => esc_html__('Selected Portfolio', 'prelements'),
					''        => esc_html__('Category Portfolio', 'prelements'),
				],
			]
		);
		$this->add_control(
			'portfolio_category',
			[
				'label'   => esc_html__('Category', 'rsaddon'),
				'type'    => Controls_Manager::SELECT2,
				'default' => 0,
				'options' => $this->getCategories(),
				'multiple' => true,
				'condition' => ['portfolio_is_manual_selection' => ''],
				'separator' => 'before',
			]
		);
		$this->add_control(
			'select_portfolio_item',
			[
				'label'   => esc_html__('Select Portfolio', 'prelements'),
				'type'    => Controls_Manager::SELECT2,
				'default' => 0,
				'options' => [] + $post_dropdown,
				'multiple' => true,
				'condition' => ['portfolio_is_manual_selection' => 'yes'],
			]
		);
		$this->add_control(
			'per_page',
			[
				'label' => esc_html__('Portfolio Show Per Page', 'rsaddon'),
				'type' => Controls_Manager::TEXT,
				'placeholder' => esc_html__('example 3', 'rsaddon'),
				'separator' => 'before'
			]
		);

		$this->add_group_control(
			Group_Control_Image_Size::get_type(),
			[
				'name' => 'thumbnail',
				'default' => 'large',
				'separator' => 'before',
				'separator' => 'before',
			]
		);
		$this->add_control(
			'cat_show_hide',
			[
				'label' => esc_html__('Show Category', 'rsaddon'),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__('Show', 'rsaddon'),
				'label_off' => esc_html__('Hide', 'rsaddon'),
				'return_value' => 'yes',
				'default' => 'yes',
				'separator' => 'before',
				'condition' => [
					'portfolio_slider_style!' => '6'
				]
			]
		);
		$this->add_control(
			'desc_show_hide',
			[
				'label' => esc_html__('Show Description', 'rsaddon'),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__('Show', 'rsaddon'),
				'label_off' => esc_html__('Hide', 'rsaddon'),
				'return_value' => 'yes',
				'default' => 'no',
				'separator' => 'before',
				'condition' => [
					'portfolio_slider_style' => '4'
				]
			]
		);
		$this->add_control(
			'btn__show_hide',
			[
				'label' => esc_html__('Button Show', 'rsaddon'),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__('Show', 'rsaddon'),
				'label_off' => esc_html__('Hide', 'rsaddon'),
				'return_value' => 'yes',
				'separator' => 'before',
				'condition' => [
					'portfolio_slider_style!' => '6'
				]
			]
		);
		$this->add_control(
			'btn__title',
			[
				'label' => esc_html__('Button Title', 'rsaddon'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__('View Project', 'rsaddon'),
				'placeholder' => esc_html__('Button Title', 'rsaddon'),
				'condition' => [
					'btn__show_hide' => 'yes'
				],
			]
		);
		$this->add_control(
			'btn__icon',
			[
				'label' => esc_html__('Icon', 'rsaddon'),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fas fa-star',
					'library' => 'fa-solid',
				],
				'condition' => [
					'btn__show_hide' => 'yes'
				],
			]
		);

		$this->add_control(
			'number_show_hide',
			[
				'label' => esc_html__('Number Enable?', 'rsaddon'),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__('Show', 'rsaddon'),
				'label_off' => esc_html__('Hide', 'rsaddon'),
				'return_value' => 'yes',
				'default' => 'yes',
				'separator' => 'before',
				'condition' => ['portfolio_slider_style' => '2']
			]
		);

		$this->add_control(
			'clip_path',
			[
				'label' => esc_html__('Clip Path ON/OFF?', 'rsaddon'),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__('Show', 'rsaddon'),
				'label_off' => esc_html__('Hide', 'rsaddon'),
				'return_value' => 'yes',
				'default' => 'no',
				'condition' => ['portfolio_slider_style' => '4']
			]
		);
		$this->add_control(
			'plus_icon_show_hide',
			[
				'label' => esc_html__('Show Plus Icon', 'rsaddon'),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__('Show', 'rsaddon'),
				'label_off' => esc_html__('Hide', 'rsaddon'),
				'return_value' => 'yes',
				'default' => 'yes',
				'separator' => 'before',
			]
		);

		$this->end_controls_section();


		$this->start_controls_section(
			'content_slider',
			[
				'label' => esc_html__('Slider Settings', 'rsaddon'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'col_lg',
			[
				'label'   => esc_html__('Desktops > 1199px', 'rsaddon'),
				'type'    => Controls_Manager::SELECT,
				'default' => 3,
				'options' => [
					'1' => esc_html__('1 Column', 'rsaddon'),
					'2' => esc_html__('2 Column', 'rsaddon'),
					'3' => esc_html__('3 Column', 'rsaddon'),
					'4' => esc_html__('4 Column', 'rsaddon'),
					'5' => esc_html__('5 Column', 'rsaddon'),
					'6' => esc_html__('6 Column', 'rsaddon'),
				],
				'separator' => 'before',

			]
		);
		$this->add_control(
			'col_lg_2',
			[
				'label'   => esc_html__('Desktops < 1199px', 'rsaddon'),
				'type'    => Controls_Manager::SELECT,
				'default' => 3,
				'options' => [
					'1' => esc_html__('1 Column', 'rsaddon'),
					'2' => esc_html__('2 Column', 'rsaddon'),
					'3' => esc_html__('3 Column', 'rsaddon'),
					'4' => esc_html__('4 Column', 'rsaddon'),
					'5' => esc_html__('5 Column', 'rsaddon'),
					'6' => esc_html__('6 Column', 'rsaddon'),
				],
				'separator' => 'before',

			]
		);
		$this->add_control(
			'col_md',
			[
				'label'   => esc_html__('Desktops > 991px', 'rsaddon'),
				'type'    => Controls_Manager::SELECT,
				'default' => 3,
				'options' => [
					'1' => esc_html__('1 Column', 'rsaddon'),
					'2' => esc_html__('2 Column', 'rsaddon'),
					'3' => esc_html__('3 Column', 'rsaddon'),
					'4' => esc_html__('4 Column', 'rsaddon'),
					'6' => esc_html__('6 Column', 'rsaddon'),
				],
				'separator' => 'before',
			]
		);
		$this->add_control(
			'col_sm',
			[
				'label'   => esc_html__('Tablets > 767px', 'rsaddon'),
				'type'    => Controls_Manager::SELECT,
				'default' => 2,
				'options' => [
					'1' => esc_html__('1 Column', 'rsaddon'),
					'2' => esc_html__('2 Column', 'rsaddon'),
					'3' => esc_html__('3 Column', 'rsaddon'),
					'4' => esc_html__('4 Column', 'rsaddon'),
					'6' => esc_html__('6 Column', 'rsaddon'),
				],
				'separator' => 'before',

			]
		);

		$this->add_control(
			'col_xs',
			[
				'label'   => esc_html__('Tablets < 768px', 'rsaddon'),
				'type'    => Controls_Manager::SELECT,
				'default' => 1,
				'options' => [
					'1' => esc_html__('1 Column', 'rsaddon'),
					'2' => esc_html__('2 Column', 'rsaddon'),
					'3' => esc_html__('3 Column', 'rsaddon'),
					'4' => esc_html__('4 Column', 'rsaddon'),
					'6' => esc_html__('6 Column', 'rsaddon'),
				],
				'separator' => 'before',

			]

		);
		$this->add_control(
			'slides_ToScroll',
			[
				'label'   => esc_html__('Slide To Scroll', 'rsaddon'),
				'type'    => Controls_Manager::SELECT,
				'default' => 2,
				'options' => [
					'1' => esc_html__('1 Item', 'rsaddon'),
					'2' => esc_html__('2 Item', 'rsaddon'),
					'3' => esc_html__('3 Item', 'rsaddon'),
					'4' => esc_html__('4 Item', 'rsaddon'),
				],
				'separator' => 'before',

			]

		);
		$this->add_control(
			'slider_dots',
			[
				'label'   => esc_html__('Navigation Dots', 'rsaddon'),
				'type'    => Controls_Manager::SELECT,
				'default' => 'false',
				'options' => [
					'true' => esc_html__('Enable', 'rsaddon'),
					'false' => esc_html__('Disable', 'rsaddon'),
				],
				'separator' => 'before',

			]

		);
		$this->add_control(
			'slider_dots_style',
			[
				'label'   => esc_html__('Dots Style', 'rsaddon'),
				'type'    => Controls_Manager::SELECT,
				'default' => 'default',
				'options' => [
					'default' => esc_html__('Default', 'rsaddon'),
					'2' => esc_html__('Style 2', 'rsaddon'),
				],
				'condition' => [
					'slider_dots' => 'true',
				]
			]

		);
		$this->add_control(
			'slider_nav',
			[
				'label'   => esc_html__('Navigation Nav', 'rsaddon'),
				'type'    => Controls_Manager::SELECT,
				'default' => 'false',
				'options' => [
					'true' => esc_html__('Enable', 'rsaddon'),
					'false' => esc_html__('Disable', 'rsaddon'),
				],
				'separator' => 'before',

			]
		);
		$this->add_control(
			'slider_nav_icon_style',
			[
				'label'   => esc_html__('Icon style', 'rsaddon'),
				'type'    => Controls_Manager::SELECT,
				'default' => '1',
				'options' => [
					'1' => esc_html__('One', 'rsaddon'),
					'2' => esc_html__('Two', 'rsaddon'),
				],
				'condition' => [
					'slider_nav' => 'true'
				]
			]
		);
		$this->add_control(
			'slider_autoplay',
			[
				'label'   => esc_html__('Autoplay', 'rsaddon'),
				'type'    => Controls_Manager::SELECT,
				'default' => 'false',
				'options' => [
					'true' => esc_html__('Enable', 'rsaddon'),
					'false' => esc_html__('Disable', 'rsaddon'),
				],
				'separator' => 'before',

			]

		);
		$this->add_control(
			'slider_autoplay_speed',
			[
				'label'   => esc_html__('Autoplay Slide Speed', 'rsaddon'),
				'type'    => Controls_Manager::SELECT,
				'default' => 3000,
				'options' => [
					'1000' => esc_html__('1 Seconds', 'rsaddon'),
					'2000' => esc_html__('2 Seconds', 'rsaddon'),
					'3000' => esc_html__('3 Seconds', 'rsaddon'),
					'4000' => esc_html__('4 Seconds', 'rsaddon'),
					'5000' => esc_html__('5 Seconds', 'rsaddon'),
				],
				'separator' => 'before',

			]

		);
		$this->add_control(
			'slider_stop_on_hover',
			[
				'label'   => esc_html__('Stop on Hover', 'rsaddon'),
				'type'    => Controls_Manager::SELECT,
				'default' => 'false',
				'options' => [
					'true' => esc_html__('Enable', 'rsaddon'),
					'false' => esc_html__('Disable', 'rsaddon'),
				],
				'separator' => 'before',

			]

		);
		$this->add_control(
			'slider_interval',
			[
				'label'   => esc_html__('Autoplay Interval', 'rsaddon'),
				'type'    => Controls_Manager::SELECT,
				'default' => 3000,
				'options' => [
					'5000' => esc_html__('5 Seconds', 'rsaddon'),
					'4000' => esc_html__('4 Seconds', 'rsaddon'),
					'3000' => esc_html__('3 Seconds', 'rsaddon'),
					'2000' => esc_html__('2 Seconds', 'rsaddon'),
					'1000' => esc_html__('1 Seconds', 'rsaddon'),
				],
				'separator' => 'before',

			]

		);
		$this->add_control(
			'slider_loop',
			[
				'label'   => esc_html__('Loop', 'rsaddon'),
				'type'    => Controls_Manager::SELECT,
				'default' => 'false',
				'options' => [
					'true' => esc_html__('Enable', 'rsaddon'),
					'false' => esc_html__('Disable', 'rsaddon'),
				],
				'separator' => 'before',

			]

		);
		$this->add_control(
			'slider_centerMode',
			[
				'label'   => esc_html__('Center Mode', 'rsaddon'),
				'type'    => Controls_Manager::SELECT,
				'default' => 'false',
				'options' => [
					'true' => esc_html__('Enable', 'rsaddon'),
					'false' => esc_html__('Disable', 'rsaddon'),
				],
				'separator' => 'before',
			]
		);
		$this->add_control(
			'fade_effect',
			[
				'label'   => esc_html__('Fade Effect', 'rsaddon'),
				'type'    => Controls_Manager::SELECT,
				'default' => 'false',
				'options' => [
					'true' => esc_html__('Enable', 'rsaddon'),
					'false' => esc_html__('Disable', 'rsaddon'),
				],
				'separator' => 'before',
			]
		);
		$this->add_control(
			'slider_centers_pad_xl',
			[
				'label'   => esc_html__('Center Mode Padding (XL)', 'rsaddon'),
				'type' => Controls_Manager::TEXT,
				'default' => '',
				'separator' => 'before',
				'condition' => [
					'slider_centerMode' => 'true',
				]
			]
		);
		$this->add_control(
			'slider_centers_pad_lg',
			[
				'label'   => esc_html__('Center Mode Padding (LG)', 'rsaddon'),
				'type' => Controls_Manager::TEXT,
				'default' => '',
				'separator' => 'before',
				'condition' => [
					'slider_centerMode' => 'true',
				]
			]
		);
		$this->add_control(
			'slider_centers_pad_md',
			[
				'label'   => esc_html__('Center Mode Padding (MD)', 'rsaddon'),
				'type' => Controls_Manager::TEXT,
				'default' => '',
				'separator' => 'before',
				'condition' => [
					'slider_centerMode' => 'true',
				]
			]
		);
		$this->add_responsive_control(
			'item_gap_custom',
			[
				'label' => esc_html__('Item Gap', 'rsaddon'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['%', 'px', 'custom'],
				'show_label' => true,
				'range' => [
					'px' => [
						'max' => 100,
					],
				],
				'default' => [
					'size' => 15,
				],

				'selectors' => [
					'{{WRAPPER}} .rs-addon-sliders .grid-item' => 'padding:0 {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'item_gap_custom_margin',
			[
				'label' => esc_html__('Item Margin', 'rsaddon'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'custom'],
				'selectors' => [
					'{{WRAPPER}} .rs-addon-sliders .grid-item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_slider_style',
			[
				'label' => esc_html__('General Section', 'rsaddon'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
			// Btn Wrapper
			$this->add_control(
				'box_wrapper_ctrl_heading_style7',
				[
					'label' => esc_html__( 'Box Wrapper Options', 'rsaddon' ),
					'type' => Controls_Manager::HEADING,
					'classes' => 'rs-control-type-heading',
					'condition' => [
						'portfolio_slider_style' => '7'
					],
				]
			);
			$this->add_responsive_control(
				'box_wrapper_v_align_style7',
				[
					'label' => esc_html__( 'Vertical Align', 'rsaddon' ),
					'type' => Controls_Manager::CHOOSE,
					'options' => [
						'flex-start' => [
							'title' => esc_html__( 'Top', 'rsaddon' ),
							'icon' => 'eicon-align-start-v',
						],
						'center' => [
							'title' => esc_html__( 'Middle', 'rsaddon' ),
							'icon' => 'eicon-align-center-v',
						],
						'flex-end' => [
							'title' => esc_html__( 'Bottom', 'rsaddon' ),
							'icon' => 'eicon-align-end-v',
						],
					],
					'toggle' => true,
					'selectors' => [
						'{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style7 .rs-addon-sliders .portfolio-item' => 'align-items: {{VALUE}};',
					],
					'condition' => [
						'portfolio_slider_style' => '7'
					],
				]
			);
			$this->add_responsive_control(
				'box_wrapper_column_align_style7',
				[
					'label' => esc_html__( 'Column Direction', 'rsaddon' ),
					'type' => Controls_Manager::CHOOSE,
					'options' => [
						'row' => [
							'title' => esc_html__( 'Row', 'rsaddon' ),
							'icon' => 'eicon-justify-start-h',
						],
						'row-reverse' => [
							'title' => esc_html__( 'Row Reverse', 'rsaddon' ),
							'icon' => 'eicon-wrap',
						],
						'column' => [
							'title' => esc_html__( 'Column', 'rsaddon' ),
							'icon' => 'eicon-justify-start-v',
						],
						'column-reverse' => [
							'title' => esc_html__( 'Column Reverse', 'rsaddon' ),
							'icon' => 'eicon-wrap',
						],
					],
					'toggle' => true,
					'selectors' => [
						'{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style7 .rs-addon-sliders .portfolio-item' => 'flex-direction: {{VALUE}};',
					],
					'condition' => [
						'portfolio_slider_style' => '7'
					],
				]
			);
			$this->add_responsive_control(
				'box_wrapper_h_align_style7',
				[
					'label' => esc_html__( 'Horizontal Align', 'rsaddon' ),
					'type' => Controls_Manager::CHOOSE,
					'options' => [
						'flex-start' => [
							'title' => esc_html__( 'Start', 'rsaddon' ),
							'icon' => 'eicon-align-start-h',
						],
						'center' => [
							'title' => esc_html__( 'Center', 'rsaddon' ),
							'icon' => 'eicon-align-center-h',
						],
						'flex-end' => [
							'title' => esc_html__( 'End', 'rsaddon' ),
							'icon' => 'eicon-align-end-h',
						],
						'space-between' => [
							'title' => esc_html__( 'Space Between', 'rsaddon' ),
							'icon' => 'eicon-justify-space-between-h',
						],

					],
					'toggle' => true,
					'selectors' => [
						'{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style7 .rs-addon-sliders .portfolio-item' => 'justify-content: {{VALUE}};',
					],
					'condition' => [
						'portfolio_slider_style' => '7'
					],
				]
			);
			$this->add_responsive_control(
				'box_wrapper_flex_wrap_style7',
				[
					'label' => esc_html__( 'Flex Wrap', 'rsaddon' ),
					'type' => Controls_Manager::CHOOSE,
					'options' => [
						'nowrap' => [
							'title' => esc_html__( 'No Wrap', 'rsaddon' ),
							'icon' => 'eicon-nowrap',
						],
						'wrap' => [
							'title' => esc_html__( 'Wrap', 'rsaddon' ),
							'icon' => 'eicon-wrap',
						],
					],
					'toggle' => true,
					'selectors' => [
						'{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style7 .rs-addon-sliders .portfolio-item' => 'flex-wrap: {{VALUE}};',
					],
					'condition' => [
						'portfolio_slider_style' => '7'
					],
				]
			);
		$this->add_responsive_control(
			'align',
			[
				'label' => esc_html__('Alignment', 'rsaddon'),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__('Left', 'rsaddon'),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__('Center', 'rsaddon'),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__('Right', 'rsaddon'),
						'icon' => 'eicon-text-align-right',
					],
				],
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .rs-portfolio .portfolio-item' => 'text-align: {{VALUE}};'
				],
			]
		);
		$this->add_responsive_control(
			'item_margin',
			[
				'label' => esc_html__('Item Margin', 'rsaddon'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors' => [
					'{{WRAPPER}} .rs-portfolio .portfolio-item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'item_padding',
			[
				'label' => esc_html__('Item Padding', 'rsaddon'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors' => [
					'{{WRAPPER}} .rs-portfolio .portfolio-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'item_border_radius',
			[
				'label' => esc_html__('Border Radius', 'rsaddon'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors' => [
					'{{WRAPPER}} .rs-portfolio .portfolio-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'item_border',
				'selector' => '
						{{WRAPPER}} .rs-portfolio .portfolio-item',
			]
		);
		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'item_box_shadow',
				'exclude' => [
					'box_shadow_position',
				],
				'selector' => '{{WRAPPER}} .rs-portfolio .portfolio-item',
			]
		);
		$this->add_responsive_control(
			'item_height',
			[
				'label' => esc_html__( 'Height', 'rsaddon' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'condition' => [
					'portfolio_slider_style' => '7'
				],
				'selectors' => [
					'{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style7 .rs-addon-sliders .portfolio-item' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();

		// Thumb part style start
		$this->start_controls_section(
			'section_slider_style_thumb_part',
			[
				'label' => esc_html__('Thumb Part Style', 'rsaddon'),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' => [
					'portfolio_slider_style' => ['6', '7']
				]
			]
		);
			$this->add_responsive_control(
				'wrapper_thumb_part_width',
				[
					'label' => esc_html__( 'Wrapper Width', 'rsaddon' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'custom' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 1000
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'default' => [
						'unit' => '%'
					],
					'selectors' => [
						'{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style6 .rs-addon-sliders,
						{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style7 .rs-thumb-sl-nav' => 'width: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'thumb_item_height_uni',
				[
					'label' => esc_html__( 'Height', 'rsaddon' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'custom' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 1000
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'condition' => [
						'portfolio_slider_style' => '7'
					],
					'selectors' => [
						'{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style7 .rs-thumb-sl-nav .thumb-img' => 'height: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'thumb_item_padding_uni',
				[
					'label' => esc_html__( 'Padding', 'rsaddon' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style7 .rs-thumb-sl-nav' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
					'condition' => [
						'portfolio_slider_style' => '7'
					],
				]
			);
			$this->add_responsive_control(
				'thumb_item_border_radius_uni',
				[
					'label' => esc_html__( 'Border Radius', 'rsaddon' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style7 .rs-thumb-sl-nav' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}; overflow: hidden;',
					],
					'condition' => [
						'portfolio_slider_style' => '7'
					],
				]
			);
			$this->add_responsive_control(
				'thumb_item_filter_uni',
				[
					'label' => esc_html__( 'Filter Blur', 'rsaddon' ),
					'type' => Controls_Manager::SLIDER,
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style7 .rs-thumb-sl-nav' => 'backdrop-filter: blur({{SIZE}}px);',
					],
					'condition' => [
						'portfolio_slider_style' => '7'
					],
				]
			);
			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name' => 'thumb_item_bg_uni',
					'types' => [ 'classic', 'gradient' ],
					'selector' => '{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style7 .rs-thumb-sl-nav',
					'condition' => [
						'portfolio_slider_style' => '7'
					],
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name' => 'thumb_item_border_uni',
					'selector' => '{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style7 .rs-thumb-sl-nav',
					'condition' => [
						'portfolio_slider_style' => '7'
					],
				]
			);

			$this->add_control(
				'thumb_img_control_options',
				[
					'label' => esc_html__( 'Thumb Image Options', 'rsaddon' ),
					'type' => Controls_Manager::HEADING,
					'classes' => 'rs-control-type-heading',
					'separator' => 'before',
				]
			);
			$this->add_responsive_control(
				'thumb_image_fit',
				[
					'label' => esc_html__( 'Image Fit', 'rsaddon' ),
					'type' => Controls_Manager::SELECT,
					'default' => 'cover',
					'options' => [
						'' => esc_html__( 'Default', 'rsaddon' ),
						'auto' => esc_html__( 'Auto', 'rsaddon' ),
						'cover' => esc_html__( 'Cover', 'rsaddon' ),
						'contain' => esc_html__( 'Contain', 'rsaddon' ),
						'unset' => esc_html__( 'Unset', 'rsaddon' ),
						'initial' => esc_html__( 'Custom', 'rsaddon' ),
					],
					'selectors' => [
						'{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style6 .rs-thumb-sl-nav .thumb-img,
						{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style7 .rs-thumb-sl-nav .thumb-img,
						{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style7 .portfolio-item' => 'background-size: {{VALUE}} !important;',
					]
				]
			);
			$this->add_responsive_control(
				'thumb_image_size_x',
				[
					'label' => esc_html__( 'Size X', 'rsaddon' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'vh', 'custom' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 1000,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
						'vh' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style6 .rs-thumb-sl-nav .thumb-img,
						{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style7 .rs-thumb-sl-nav .thumb-img,
						{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style7 .portfolio-item' => 'background-size: {{SIZE}}{{UNIT}} {{thumb_image_size_y.SIZE}}{{thumb_image_size_y.UNIT}} !important;',
					],
					'condition' => [
						'thumb_image_fit' => 'initial'
					],
				]
			);
			$this->add_responsive_control(
				'thumb_image_size_y',
				[
					'label' => esc_html__( 'Size Y', 'rsaddon' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'vh', 'custom' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 1000,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
						'vh' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style6 .rs-thumb-sl-nav .thumb-img,
						{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style7 .rs-thumb-sl-nav .thumb-img,
						{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style7 .portfolio-item' => 'background-size: {{thumb_image_size_x.SIZE}}{{thumb_image_size_x.UNIT}} {{SIZE}}{{UNIT}} !important;',
					],
					'condition' => [
						'thumb_image_fit' => 'initial'
					],
				]
			);
			$this->add_responsive_control(
				'thumb_image_position',
				[
					'label' => esc_html__( 'Image Position', 'rsaddon' ),
					'type' => Controls_Manager::SELECT,
					'default' => '',
					'options' => [
						'' => esc_html__( 'Default', 'rsaddon' ),
						'center center' => esc_html__( 'Center Center', 'rsaddon' ),
						'center left' => esc_html__( 'Center Left', 'rsaddon' ),
						'center right' => esc_html__( 'Center Right', 'rsaddon' ),
						'top center' => esc_html__( 'Top Center', 'rsaddon' ),
						'top left' => esc_html__( 'Top Left', 'rsaddon' ),
						'top right' => esc_html__( 'Top Right', 'rsaddon' ),
						'bottom center' => esc_html__( 'Bottom Center', 'rsaddon' ),
						'bottom left' => esc_html__( 'Bottom Left', 'rsaddon' ),
						'bottom right' => esc_html__( 'Bottom Right', 'rsaddon' ),
						'initial' => esc_html__( 'Custom', 'rsaddon' ),
					],
					'selectors' => [
						'{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style6 .rs-thumb-sl-nav .thumb-img,
						{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style7 .rs-thumb-sl-nav .thumb-img,
						{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style7 .portfolio-item' => 'background-position: {{VALUE}} !important;',
					],
					'condition' => [
						'thumb_image_fit!' => ['unset', '']
					],
				]
			);
			$this->add_responsive_control(
				'thumb_image_position_x',
				[
					'label' => esc_html__( 'Position X', 'rsaddon' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'vh', 'custom' ],
					'range' => [
						'px' => [
							'min' => -1000,
							'max' => 1000,
						],
						'%' => [
							'min' => -100,
							'max' => 100,
						],
						'vh' => [
							'min' => -100,
							'max' => 100,
						],
					],
					'default' => [
						'size' => 0,
					],
					'selectors' => [
						'{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style6 .rs-thumb-sl-nav .thumb-img,
						{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style7 .rs-thumb-sl-nav .thumb-img,
						{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style7 .portfolio-item' => 'background-position-x: {{SIZE}}{{UNIT}} !important;',
					],
					'condition' => [
						'thumb_image_fit!' => ['unset', ''],
						'thumb_image_position' => 'initial'
					],
				]
			);
			$this->add_responsive_control(
				'thumb_image_position_y',
				[
					'label' => esc_html__( 'Position Y', 'rsaddon' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'vh', 'custom' ],
					'range' => [
						'px' => [
							'min' => -1000,
							'max' => 1000,
						],
						'%' => [
							'min' => -100,
							'max' => 100,
						],
						'vh' => [
							'min' => -100,
							'max' => 100,
						],
					],
					'default' => [
						'size' => 0,
					],
					'selectors' => [
						'{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style6 .rs-thumb-sl-nav .thumb-img,
						{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style7 .rs-thumb-sl-nav .thumb-img,
						{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style7 .portfolio-item' => 'background-position-y: {{SIZE}}{{UNIT}} !important;',
					],
					'condition' => [
						'thumb_image_fit!' => ['unset', ''],
						'thumb_image_position' => 'initial'
					],
				]
			);
			$this->add_responsive_control(
				'thumb_image_repeat',
				[
					'label' => esc_html__( 'Image Repeat', 'rsaddon' ),
					'type' => Controls_Manager::SELECT,
					'default' => '',
					'options' => [
						'' => esc_html__( 'Default', 'elementor' ),
						'no-repeat' => esc_html__( 'No-repeat', 'elementor' ),
						'repeat' => esc_html__( 'Repeat', 'elementor' ),
						'repeat-x' => esc_html__( 'Repeat-x', 'elementor' ),
						'repeat-y' => esc_html__( 'Repeat-y', 'elementor' ),
					],
					'selectors' => [
						'{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style7 .rs-thumb-sl-nav .thumb-img,
						{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style7 .portfolio-item' => 'background-repeat: {{VALUE}} !important;',
					],
					'condition' => [
						'portfolio_slider_style' => '7'
					]
				]
			);

			// Thumbnail Part Position Maker Start
            $this->add_control(
                'thumb_position_maker',
                [
                    'label' => esc_html__( 'Position Maker', 'rsaddon' ),
                    'type' => Controls_Manager::POPOVER_TOGGLE,
                    'label_off' => esc_html__( 'Default', 'rsaddon' ),
                    'label_on' => esc_html__( 'Custom', 'rsaddon' ),
                    'return_value' => 'yes',
                    'default' => 'no',
                    'separator' => 'before',
					'condition' => [
						'portfolio_slider_style' => '7'
					],
                ]
            );
            
            $this->start_popover();
                $this->add_responsive_control(
                    'thumb_position',
                    [
                        'label' => esc_html__( 'Position', 'rsaddon' ),
                        'type' => Controls_Manager::SELECT,
                        'default' => '',
                        'options' => [
                            '' => esc_html__( 'Default', 'rsaddon' ),
                            'absolute' => esc_html__( 'Absolute', 'rsaddon' ),
                            'relative'  => esc_html__( 'Relative', 'rsaddon' ),
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style7 .rs-thumb-sl-nav' => 'position: {{VALUE}};',
                        ],
						'condition' => [
							'portfolio_slider_style' => '7'
						],
                    ]
                );
                $this->add_responsive_control(
                    'thumb_p_top',
                    [
                        'label' => esc_html__( 'Top', 'rsaddon' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%', 'custom' ],
                        'range' => [
                            'px' => [
                                'min' => -1000,
                                'max' => 1000,
                            ],
                            '%' => [
                                'min' => -100,
                                'max' => 100,
                            ],
                        ],
                        'condition' => [
                            'thumb_position' => ['absolute', 'relative'],
							'portfolio_slider_style' => '7'
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style7 .rs-thumb-sl-nav' => 'top: {{SIZE}}{{UNIT}};',
                        ],
                    ]
                );
                $this->add_responsive_control(
                    'thumb_p_right',
                    [
                        'label' => esc_html__( 'Right', 'rsaddon' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%', 'custom' ],
                        'range' => [
                            'px' => [
                                'min' => -1000,
                                'max' => 1000,
                            ],
                            '%' => [
                                'min' => -100,
                                'max' => 100,
                            ],
                        ],
                        'condition' => [
                            'thumb_position' => ['absolute', 'relative'],
							'portfolio_slider_style' => '7'
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style7 .rs-thumb-sl-nav' => 'right: {{SIZE}}{{UNIT}};',
                        ],
                    ]
                );
                $this->add_responsive_control(
                    'thumb_p_bottom',
                    [
                        'label' => esc_html__( 'Bottom', 'rsaddon' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%', 'custom' ],
                        'range' => [
                            'px' => [
                                'min' => -1000,
                                'max' => 1000,
                            ],
                            '%' => [
                                'min' => -100,
                                'max' => 100,
                            ],
                        ],
                        'condition' => [
                            'thumb_position' => ['absolute', 'relative'],
							'portfolio_slider_style' => '7'
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style7 .rs-thumb-sl-nav' => 'bottom: {{SIZE}}{{UNIT}};',
                        ],
                    ]
                );
                $this->add_responsive_control(
                    'thumb_p_left',
                    [
                        'label' => esc_html__( 'Left', 'rsaddon' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%', 'custom' ],
                        'range' => [
                            'px' => [
                                'min' => -1000,
                                'max' => 1000,
                            ],
                            '%' => [
                                'min' => -100,
                                'max' => 100,
                            ],
                        ],
                        'condition' => [
                            'thumb_position' => ['absolute', 'relative'],
							'portfolio_slider_style' => '7'
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style7 .rs-thumb-sl-nav' => 'left: {{SIZE}}{{UNIT}};',
                        ],
                    ]
                );
            $this->end_popover();
            // Thumbnail Part Position Maker End


			$this->start_controls_tabs(
				'wrapper_thumb_style_tabs',
				[
					'condition' => [
						'portfolio_slider_style!' => '7'
					],
				]
			);
				$this->start_controls_tab(
					'wrapper_thumb_style_normal_tab',
					[
						'label' => esc_html__( 'Normal', 'rsaddon' ),
					]
				);
					$this->add_responsive_control(
						'thumb_height',
						[
							'label' => esc_html__( 'Height', 'rsaddon' ),
							'type' => Controls_Manager::SLIDER,
							'size_units' => [ 'px', '%', 'custom' ],
							'range' => [
								'px' => [
									'min' => 0,
									'max' => 1000
								],
								'%' => [
									'min' => 0,
									'max' => 100,
								],
							],
							'selectors' => [
								'{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style6 .rs-thumb-sl-nav .thumb-img.slick-active:not(.slick-current)' => 'height: {{SIZE}}{{UNIT}};',
							],
						]
					);
					$this->add_responsive_control(
						'thumb_scale',
						[
							'label' => esc_html__( 'Scale', 'rsaddon' ),
							'type' => Controls_Manager::SLIDER,
							'range' => [
								'px' => [
									'min' => 0,
									'max' => 3,
									'step' => 0.1,
								]
							],
							'selectors' => [
								'{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style6 .rs-thumb-sl-nav .thumb-img' => 'transform: scale({{SIZE}});',
							],
						]
					);
					$this->add_responsive_control(
						'thumb_opacity',
						[
							'label' => esc_html__( 'Opacity', 'rsaddon' ),
							'type' => Controls_Manager::SLIDER,
							'range' => [
								'px' => [
									'min' => 0,
									'max' => 1,
									'step' => 0.1,
								]
							],
							'selectors' => [
								'{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style6 .rs-thumb-sl-nav .thumb-img.slick-active:not(.slick-current)' => 'opacity: {{SIZE}};',
							],
						]
					);
					$this->add_group_control(
						Group_Control_Border::get_type(),
						[
							'name' => 'thumb_border',
							'selector' => '{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style6 .rs-thumb-sl-nav .thumb-img'
						]
					);
				$this->end_controls_tab();

				$this->start_controls_tab(
					'wrapper_thumb_style_active_tab',
					[
						'label' => esc_html__( 'Active', 'rsaddon' ),
					]
				);
					$this->add_responsive_control(
						'thumb_height_active',
						[
							'label' => esc_html__( 'Height', 'rsaddon' ),
							'type' => Controls_Manager::SLIDER,
							'size_units' => [ 'px', '%', 'custom' ],
							'range' => [
								'px' => [
									'min' => 0,
									'max' => 1000
								],
								'%' => [
									'min' => 0,
									'max' => 100,
								],
							],
							'selectors' => [
								'{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style6 .rs-thumb-sl-nav .thumb-img' => 'height: {{SIZE}}{{UNIT}};',
							],
						]
					);
					$this->add_responsive_control(
						'thumb_scale_active',
						[
							'label' => esc_html__( 'Scale', 'rsaddon' ),
							'type' => Controls_Manager::SLIDER,
							'range' => [
								'px' => [
									'min' => 0,
									'max' => 1,
									'step' => 0.1,
								]
							],
							'selectors' => [
								'{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style6 .rs-thumb-sl-nav .thumb-img.slick-active:not(.slick-current)' => 'transform: scale({{SIZE}});',
							],
						]
					);
					$this->add_responsive_control(
						'thumb_opacity_active',
						[
							'label' => esc_html__( 'Opacity', 'rsaddon' ),
							'type' => Controls_Manager::SLIDER,
							'range' => [
								'px' => [
									'min' => 0,
									'max' => 1,
									'step' => 0.1,
								]
							],
							'selectors' => [
								'{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style6 .rs-thumb-sl-nav .thumb-img' => 'opacity: {{SIZE}};',
							],
						]
					);
					$this->add_control(
						'thumb_border_color_active',
						[
							'label' => esc_html__( 'Border Color', 'rsaddon' ),
							'type' => Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style6 .rs-thumb-sl-nav .thumb-img.slick-current' => 'border-color: {{VALUE}}',
							],
						]
					);
				$this->end_controls_tab();
			$this->end_controls_tabs();
		$this->end_controls_section();
		// Thumb part style end

		// image section start
		$this->start_controls_section(
			'section_slider_style_image',
			[
				'label' => esc_html__('Image Style', 'rsaddon'),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' => [
					'portfolio_slider_style!' => '6'
				]
			]
		);
		$this->add_responsive_control(
			'image_wrapper_width',
			[
				'label'      => esc_html__('Image Wrapper Width', 'rsaddon'),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => ['px', '%', 'custom'],
				'range' => [
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rs-portfolio .portfolio-img' => 'width: {{SIZE}}{{UNIT}}; flex: 0 0 {{SIZE}}{{UNIT}}; min-width: auto !important;',
				],
			]
		);
		$this->add_responsive_control(
			'image__width',
			[
				'label'      => esc_html__('Image Width', 'rsaddon'),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => ['px', '%', 'custom'],
				'range' => [
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rs-portfolio .portfolio-img img' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'image_wrapper_margin',
			[
				'label' => esc_html__('Margin', 'rsaddon'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors' => [
					'{{WRAPPER}} .rs-portfolio .portfolio-img' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'image_wrapper_padding',
			[
				'label' => esc_html__('Padding', 'rsaddon'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors' => [
					'{{WRAPPER}} .rs-portfolio .portfolio-img' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'image_wrapper_border_radius',
			[
				'label' => esc_html__('Border Radius', 'rsaddon'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors' => [
					'{{WRAPPER}} .rs-portfolio .portfolio-img, {{WRAPPER}} .rs-portfolio-style5 .portfolio-item:hover .portfolio-img::before' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}; overflow: hidden;',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'image_wrapper_border',
				'selector' => '
						{{WRAPPER}} .rs-portfolio .portfolio-img',
			]
		);
		$this->add_control(
			'image_hover_overlay_color_heading',
			[
				'label' => esc_html__('Image Hover Overlay Background', 'rsaddon'),
				'type' => \Elementor\Controls_Manager::HEADING,
				'classes' => 'rs-control-type-heading',
				'separator' => 'before',
			]
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'image_hover_overlay_color',
				'types' => ['classic', 'gradient'],
				'selector' => '
						{{WRAPPER}} .rs-portfolio .portfolio-item .portfolio-img .img-overlay',
			]
		);
		$this->add_responsive_control(
			'image_opacity',
			[
				'label' => esc_html__( 'Overlay Opacity', 'rsaddon' ),
				'type' => Controls_Manager::SLIDER,
				'show_label' => true,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1,
						'step' => 0.1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rs-portfolio .portfolio-item .portfolio-img .img-overlay' => 'opacity: {{SIZE}};',                   
				],
				'condition' => ['portfolio_slider_style' => '4']
			]
		);

		$this->add_responsive_control(
			'image_hover_opacity',
			[
				'label' => esc_html__( 'Overlay Opacity Hover', 'rsaddon' ),
				'type' => Controls_Manager::SLIDER,
				'show_label' => true,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1,
						'step' => 0.1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rs-portfolio .portfolio-item:hover .portfolio-img .img-overlay' => 'opacity: {{SIZE}};',
				],
				'condition' => ['portfolio_slider_style' => '4']
			]
		);
		
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'image_wrapper_border4',
				'selector' => '{{WRAPPER}} .rs-portfolio .portfolio-img',
				'condition' => ['portfolio_slider_style' => '4']
			]
		);



		$this->end_controls_section();
		// image section end

		$this->start_controls_section(
			'image_icon_style',
			[
				'label' => esc_html__('Image Icon Style', 'rsaddon'),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' => [
					'plus_icon_show_hide' => 'yes',
					'portfolio_slider_style' => ['4', '6']
				]
			]
		);

		$this->add_responsive_control(
			'image_icon_box_width',
			[
				'label' => esc_html__( 'Width', 'rsaddon' ),
				'type' => Controls_Manager::SLIDER,
				'show_label' => true,
				'size_units' => [ 'px', '%', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000
					],
					'%' => [
						'min' => 0,
						'max' => 100
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rs-portfolio-slider .portfolio-item .portfolio-img .portfolio-link a, {{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style6 .rs-thumb-sl-nav .thumb-img .portfolio-link a' => 'width: {{SIZE}}{{UNIT}};',                   
				],
			]
		);
		$this->add_responsive_control(
			'image_icon_box_height',
			[
				'label' => esc_html__( 'Height', 'rsaddon' ),
				'type' => Controls_Manager::SLIDER,
				'show_label' => true,
				'size_units' => [ 'px', '%', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000
					],
					'%' => [
						'min' => 0,
						'max' => 100
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rs-portfolio-slider .portfolio-item .portfolio-img .portfolio-link a, {{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style6 .rs-thumb-sl-nav .thumb-img .portfolio-link a' => 'height: {{SIZE}}{{UNIT}};',                   
				],
			]
		);

		$this->add_responsive_control(
			'image_icon_svg_size',
			[
				'label' => esc_html__( 'Icon Size', 'rsaddon' ),
				'type' => Controls_Manager::SLIDER,
				'show_label' => true,
				'size_units' => [ 'px', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rs-portfolio-slider .portfolio-item .portfolio-img .portfolio-link a svg, {{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style6 .rs-thumb-sl-nav .thumb-img .portfolio-link a svg' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',                   
				],
			]
		);
		$this->add_control(
			'image_icon_svg_color',
			[
				'label' => esc_html__( 'Icon Color', 'prelements' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rs-portfolio-slider .portfolio-item .portfolio-img .portfolio-link a svg path, {{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style6 .rs-thumb-sl-nav .thumb-img .portfolio-link a svg path' => 'fill: {{VALUE}} !important;',
				],
			]
		);
		$this->add_control(
			'image_icon_effect_color',
			[
				'label' => esc_html__( 'Effect Color', 'prelements' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style6 .rs-thumb-sl-nav .thumb-img .portfolio-link a:after,
					{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style6 .rs-thumb-sl-nav .thumb-img .portfolio-link a:before ' => 'background: {{VALUE}} !important;',
				],
				'condition' => [
					'portfolio_slider_style' => '6'
				]
			]
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'image_icon_bg',
				'types' => ['classic', 'gradient'],
				'selector' => ' {{WRAPPER}} .rs-portfolio-slider .portfolio-item .portfolio-img .portfolio-link a, {{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style6 .rs-thumb-sl-nav .thumb-img .portfolio-link a',
			]
		);
		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'image_icon_shadow',
				'exclude' => [
					'box_shadow_position',
				],
				'selector' => ' {{WRAPPER}} .rs-portfolio-slider .portfolio-item .portfolio-img .portfolio-link a, {{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style6 .rs-thumb-sl-nav .thumb-img .portfolio-link a',
			]
		);
		$this->add_responsive_control(
			'image_icon_border_radius',
			[
				'label' => esc_html__('Border Radius', 'rsaddon'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors' => [
					'{{WRAPPER}} .rs-portfolio-slider .portfolio-item .portfolio-img .portfolio-link a,
					{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style6 .rs-thumb-sl-nav .thumb-img .portfolio-link a,
					{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style6 .rs-thumb-sl-nav .thumb-img .portfolio-link a:after,
					{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style6 .rs-thumb-sl-nav .thumb-img .portfolio-link a:before' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();
		// image Icon end

		$this->start_controls_section(
			'section_slider_style_title',
			[
				'label' => esc_html__('Title Style', 'rsaddon'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		
			$this->add_control(
				'title_hover_line_color',
				[
					'label' => esc_html__( 'Line Color', 'prelements' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .rs-portfolio-style4 .portfolio-item .portfolio-content .p-title a' => 'background-image: linear-gradient(to bottom, {{VALUE}} 0%, {{VALUE}} 100%);',
					], 
					'condition' => ['portfolio_slider_style' => '4'] 
							
				]
			);
			
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' => 'title_typography',
					'label' => esc_html__('Title Typography', 'rsaddon'),
					'selector' => '{{WRAPPER}} .rs-portfolio-slider .portfolio-item .portfolio-content .p-title a,{{WRAPPER}} .rs-portfolio-slider .portfolio-item .portfolio-content .p-title',
				]
			);
			$this->add_responsive_control(
				'title_margin',
				[
					'label' => esc_html__('Title Margin', 'rsaddon'),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => ['px', 'em', '%'],
					'selectors' => [
						'{{WRAPPER}} .rs-portfolio .portfolio-item .p-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'title_padding',
				[
					'label' => esc_html__('Title Padding', 'rsaddon'),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => ['px', 'em', '%'],
					'selectors' => [
						'{{WRAPPER}} .rs-portfolio .portfolio-item .p-title a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'title_border_radius',
				[
					'label' => esc_html__('Border Radius', 'rsaddon'),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => ['px', 'em', '%'],
					'selectors' => [
						'{{WRAPPER}} .rs-portfolio .portfolio-item .p-title a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						'{{WRAPPER}} .rs-portfolio .portfolio-item .p-title' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_control(
				'title_hover_color_based_on',
				[
					'label' => esc_html__( 'Hover Based On', 'rsaddon' ),
					'type' => Controls_Manager::SELECT,
					'default' => 'normal',
					'options' => [
						'normal' => esc_html__( 'Normal', 'rsaddon' ),
						'box' => esc_html__( 'Box', 'rsaddon' ),
					]
				]
			);
			$this->start_controls_tabs( 'title_hover_normal_style_tabs' );
				$this->start_controls_tab(
					'title_style_normal_tab',
					[
						'label' => esc_html__( 'Normal', 'rsaddon' ),
					]
				);
					$this->add_control(
						'title_color',
						[
							'label' => esc_html__('Title Color', 'rsaddon'),
							'type' => Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .rs-portfolio .portfolio-item .p-title a' => 'color: {{VALUE}};',
								'{{WRAPPER}} .rs-portfolio .portfolio-item .p-title' => 'color: {{VALUE}};',
								'{{WRAPPER}} .rs-portfolio-slider .portfolio-item .portfolio-content .p-title a' => 'color: {{VALUE}};',
							],
						]
					);
					$this->add_control(
						'title_bg_color',
						[
							'label' => esc_html__('Background Color', 'rsaddon'),
							'type' => Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .rs-portfolio .portfolio-item .p-title a' => 'background-color: {{VALUE}};',
							],
						]
					);
				$this->end_controls_tab();
				$this->start_controls_tab(
					'title_style_hover_tab',
					[
						'label' => esc_html__( 'Hover', 'rsaddon' ),
					]
				);
					$this->add_control(
						'title_color_hover',
						[
							'label' => esc_html__('Title Hover Color', 'rsaddon'),
							'type' => Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .rs-portfolio .portfolio-item .p-title a:hover' => 'color: {{VALUE}};',
								'{{WRAPPER}} .rs-portfolio .portfolio-item .p-title:hover' => 'color: {{VALUE}};',
								'{{WRAPPER}} .rs-portfolio-style4 .portfolio-item .portfolio-content:hover .p-title a' => 'color: {{VALUE}};',
							],
							'condition' => [
								'title_hover_color_based_on!' => 'box'
							]
						]
					);
					$this->add_control(
						'box_hover_title_color',
						[
							'label' => esc_html__('Box Hover Title Color', 'rsaddon'),
							'type' => Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .rs-portfolio .portfolio-item:hover .p-title a' => 'color: {{VALUE}};',
								'{{WRAPPER}} .rs-portfolio .portfolio-item:hover .p-title' => 'color: {{VALUE}};',
								'{{WRAPPER}} .rs-portfolio-style4 .portfolio-item:hover .portfolio-content .p-title a' => 'color: {{VALUE}};',
							],
							'condition' => [
								'title_hover_color_based_on' => 'box'
							]
						]
					);
					$this->add_control(
						'title_bg_color_hover',
						[
							'label' => esc_html__('Background Color Hover', 'rsaddon'),
							'type' => Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .rs-portfolio .portfolio-item .p-title a:hover' => 'background-color: {{VALUE}};',
							],
							'condition' => [
								'title_hover_color_based_on!' => 'box'
							]
						]
					);
					$this->add_control(
						'box_hover_title_bg_color',
						[
							'label' => esc_html__('Box Hover Title Bg Color', 'rsaddon'),
							'type' => Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .rs-portfolio .portfolio-item:hover .p-title a' => 'background-color: {{VALUE}};',
							],
							'condition' => [
								'title_hover_color_based_on' => 'box'
							]
						]
					);
				$this->end_controls_tab();
			$this->end_controls_tabs();
		$this->end_controls_section();

		// Description Style Start
		$this->start_controls_section(
			'section_description_style',
			[
				'label' => esc_html__('Description Style', 'rsaddon'),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' => [
					'desc_show_hide' => 'yes'
				]
			]
		);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' => 'desc_typography',
					'selector' => '{{WRAPPER}} .rs-portfolio-slider .portfolio-item .content-details .desc',
				]
			);
			$this->add_control(
				'desc_text_color',
				[
					'label' => esc_html__( 'Color', 'rsaddon' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .rs-portfolio-slider .portfolio-item .content-details .desc' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'desc_text_color_hover',
				[
					'label' => esc_html__( 'Color (Hover)', 'rsaddon' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .rs-portfolio-slider .portfolio-item:hover .content-details .desc' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_responsive_control(
				'desc_text_margin',
				[
					'label' => esc_html__( 'Margin', 'rsaddon' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .rs-portfolio-slider .portfolio-item .content-details .desc' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
		$this->end_controls_section();
		// Description Style End

		$this->start_controls_section(
			'section_slider_style_category',
			[
				'label' => esc_html__('Category Style', 'rsaddon'),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' => [
					'portfolio_slider_style!' => '6'
				]
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'cat_typography',
				'label' => esc_html__('Typography', 'rsaddon'),
				'selector' => '{{WRAPPER}} .rs-portfolio .portfolio-item .portfolio-content .p-category a',
				'condition' => [
					'cat_show_hide' => 'yes'
				]
			]
		);
		
		$this->add_responsive_control(
			'category_border_radius',
			[
				'label' => esc_html__('Border Radius', 'rsaddon'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors' => [
					'{{WRAPPER}} .rs-portfolio .portfolio-item .portfolio-content .p-category a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'category_margin',
			[
				'label' => esc_html__('Margin', 'rsaddon'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors' => [
					'{{WRAPPER}} .rs-portfolio .portfolio-item .portfolio-content .p-category' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .rs-portfolio .portfolio-item .portfolio-content .p-category a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'category_padding',
			[
				'label' => esc_html__('Padding', 'rsaddon'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors' => [
					'{{WRAPPER}} .rs-portfolio .portfolio-item .portfolio-content .p-category a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'category_hover_color_based_on',
			[
				'label' => esc_html__( 'Hover Based On', 'rsaddon' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'normal',
				'options' => [
					'normal' => esc_html__( 'Normal', 'rsaddon' ),
					'box' => esc_html__( 'Box', 'rsaddon' ),
				],
				'condition' => [
					'cat_show_hide' => 'yes'
				]
			]
		);
		$this->start_controls_tabs( 'category_hover_normal_style_tabs' );
		
			$this->start_controls_tab(
				'category_style_normal_tab',
				[
					'label' => esc_html__( 'Normal', 'rsaddon' ),
				]
			);
				$this->add_control(
					'category_color',
					[
						'label' => esc_html__('Color', 'rsaddon'),
						'type' => Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .rs-portfolio .portfolio-item .portfolio-content .p-category a' => 'color: {{VALUE}};',
						],
						'condition' => [
							'cat_show_hide' => 'yes'
						]
					]
				);
				$this->add_control(
					'category_bg_color',
					[
						'label' => esc_html__('Background Color', 'rsaddon'),
						'type' => Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .rs-portfolio .portfolio-item .portfolio-content .p-category a' => 'background-color: {{VALUE}};',
						],
						'condition' => [
							'cat_show_hide' => 'yes'
						]
					]
				);
		
			$this->end_controls_tab();
			$this->start_controls_tab(
				'category_style_hover_tab',
				[
					'label' => esc_html__( 'Hover', 'rsaddon' ),
				]
			);

				$this->add_control(
					'category_color_hover',
					[
						'label' => esc_html__('Color (Hover)', 'rsaddon'),
						'type' => Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .rs-portfolio .portfolio-item .portfolio-content .p-category a:hover' => 'color: {{VALUE}};',
							'{{WRAPPER}} .rs-portfolio-style4 .portfolio-item .portfolio-content:hover .p-category a' => 'color: {{VALUE}};',
						],
						'condition' => [
							'cat_show_hide' => 'yes',
							'category_hover_color_based_on!' => 'box'
						]
					]
				);
				$this->add_control(
					'box_hover_category_color',
					[
						'label' => esc_html__('Box Hover Category Color', 'rsaddon'),
						'type' => Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .rs-portfolio .portfolio-item:hover .portfolio-content .p-category a' => 'color: {{VALUE}};',
							'{{WRAPPER}} .rs-portfolio-style4 .portfolio-item:hover .portfolio-content .p-category a' => 'color: {{VALUE}};',
						],
						'condition' => [
							'cat_show_hide' => 'yes',
							'category_hover_color_based_on' => 'box'
						]
					]
				);
				$this->add_control(
					'category_bg_color_hover',
					[
						'label' => esc_html__('Background Color (Hover)', 'rsaddon'),
						'type' => Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .rs-portfolio .portfolio-item .portfolio-content .p-category a:hover' => 'background-color: {{VALUE}};',
						],
						'condition' => [
							'cat_show_hide' => 'yes',
							'category_hover_color_based_on!' => 'box'
						]
					]
				);
				$this->add_control(
					'box_hover_category_bg_color',
					[
						'label' => esc_html__('Box Hover Category Bg Color', 'rsaddon'),
						'type' => Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .rs-portfolio .portfolio-item:hover .portfolio-content .p-category a' => 'background-color: {{VALUE}};',
						],
						'condition' => [
							'cat_show_hide' => 'yes',
							'category_hover_color_based_on' => 'box'
						]
					]
				);
		
			$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_controls_section();

		$this->start_controls_section(
			'section_slider_style_content',
			[
				'label' => esc_html__('Content Style', 'rsaddon'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
            'box_horizontal_align',
            [
                'label' => esc_html__( 'Box Style (Inline / Block)', 'rsaddon' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'flex' => [
                        'title' => esc_html__( 'Inline', 'rsaddon' ),
                        'icon' => 'eicon-post-list',
                    ],
                    'block' => [
                        'title' => esc_html__( 'Block', 'rsaddon' ),
                        'icon' => 'eicon-posts-grid',
                    ],
                ],
				'default' => 'block',
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .rs-portfolio-slider .portfolio-item .portfolio-content' => 'display: {{VALUE}};',
                ],
				'separator' => 'before',
				'condition' => [
					'portfolio_slider_style' => '4'
				]
            ]
        );
		$this->add_responsive_control(
            'box_vertical_align',
            [
                'label' => esc_html__( 'Vertical Align', 'rsaddon' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'flex-start' => [
                        'title' => esc_html__( 'Top', 'rsaddon' ),
                        'icon' => 'eicon-align-start-v',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Middle', 'rsaddon' ),
                        'icon' => 'eicon-align-center-v',
                    ],
                    'flex-end' => [
                        'title' => esc_html__( 'Bottom', 'rsaddon' ),
                        'icon' => 'eicon-align-end-v',
                    ],
                ],
				'default' => 'flex-start',
				'condition' => [
					'box_horizontal_align' => 'flex',
				],
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .rs-portfolio-slider .portfolio-item .portfolio-content' => 'align-items: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'box_column_align',
            [
                'label' => esc_html__( 'Column Direction', 'rsaddon' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'row' => [
                        'title' => esc_html__( 'Row', 'rsaddon' ),
                        'icon' => 'eicon-justify-start-h',
                    ],
                    'row-reverse' => [
                        'title' => esc_html__( 'Row Reverse', 'rsaddon' ),
                        'icon' => 'eicon-wrap',
                    ],
                    'column' => [
                        'title' => esc_html__( 'Column', 'rsaddon' ),
                        'icon' => 'eicon-justify-start-v',
                    ],
                    'column-reverse' => [
                        'title' => esc_html__( 'Column Reverse', 'rsaddon' ),
                        'icon' => 'eicon-wrap',
                    ],
                ],
				'default' => 'row',
				'condition' => [
					'box_horizontal_align' => 'flex',
				],
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .rs-portfolio-slider .portfolio-item .portfolio-content' => 'flex-direction: {{VALUE}};',
                ],
            ]
        );

		$this->add_responsive_control(
            'flex_box_h_align',
            [
                'label' => esc_html__( 'Horizontal Align', 'rsaddon' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'flex-start' => [
                        'title' => esc_html__( 'Start', 'rsaddon' ),
                        'icon' => 'eicon-align-start-h',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'rsaddon' ),
                        'icon' => 'eicon-align-center-h',
                    ],
                    'flex-end' => [
                        'title' => esc_html__( 'End', 'rsaddon' ),
                        'icon' => 'eicon-align-end-h',
                    ],
                    'space-between' => [
                        'title' => esc_html__( 'Space Between', 'rsaddon' ),
                        'icon' => 'eicon-justify-space-between-h',
                    ],
                ],
				'default' => 'flex-start',
				'condition' => [
					'box_horizontal_align' => 'flex',
				],
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .rs-portfolio-slider .portfolio-item .portfolio-content' => 'justify-content: {{VALUE}};',
                ],
            ]
        );

		$this->add_responsive_control(
			'services_flex_gap',
			[
				'label' => esc_html__('Flex Gap', 'rsaddon'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['%', 'px'],
				'show_label' => true,
				'selectors' => [
					'{{WRAPPER}} .rs-portfolio-slider .portfolio-item .portfolio-content' => 'gap: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'box_horizontal_align' => 'flex',
				]
			]
		);

		$this->add_responsive_control(
			'content_opacity',
			[
				'label' => esc_html__( 'Content Opacity', 'rsaddon' ),
				'type' => Controls_Manager::SLIDER,
				'show_label' => true,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1,
						'step' => 0.1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rs-portfolio-slider .portfolio-item .portfolio-content' => 'opacity: {{SIZE}};',                   
				],
				'condition' => ['portfolio_slider_style' => '4']
			]
		);

		$this->add_responsive_control(
			'content_hover_opacity',
			[
				'label' => esc_html__( 'Content Opacity (Hover / Active)', 'rsaddon' ),
				'type' => Controls_Manager::SLIDER,
				'show_label' => true,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1,
						'step' => 0.1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rs-portfolio-slider .portfolio-item:hover .portfolio-content, {{WRAPPER}} .rs-portfolio-slider .slick-active.slick-center .portfolio-item .portfolio-content' => 'opacity: {{SIZE}};',
				],
				'condition' => ['portfolio_slider_style' => '4']
			]
		);
		$this->add_responsive_control(
			'content_filter_blur_style4',
			[
				'label' => esc_html__( 'Filter Blur', 'rsaddon' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rs-portfolio-slider .portfolio-item .portfolio-content' => 'backdrop-filter: blur({{SIZE}}px);',
				],
				'condition' => ['portfolio_slider_style' => '4']
			]
		);

		$this->add_responsive_control(
			'content_align',
			[
				'label' => esc_html__('Alignment', 'rsaddon'),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__('Left', 'rsaddon'),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__('Center', 'rsaddon'),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__('Right', 'rsaddon'),
						'icon' => 'eicon-text-align-right',
					],
				],
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .rs-portfolio-slider .portfolio-item .portfolio-content, {{WRAPPER}} .rs-portfolio.swiper .content-details' => 'text-align: {{VALUE}};'
				],
			]
		);
		$this->add_responsive_control(
			'content_wrapper_width',
			[
				'label'      => esc_html__('Width', 'rsaddon'),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => ['px', '%', 'custom'],
				'range' => [
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rs-portfolio-slider .portfolio-item .portfolio-content,
					{{WRAPPER}} .rs-portfolio.swiper .content-details' => 'width: {{SIZE}}{{UNIT}}; flex: 0 0 {{SIZE}}{{UNIT}}; min-width: auto !important;',
				],
			]
		);
		$this->add_responsive_control(
			'content_wrapper_margin',
			[
				'label' => esc_html__('Margin', 'rsaddon'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors' => [
					'{{WRAPPER}} .rs-portfolio-slider .portfolio-item .portfolio-content,
					{{WRAPPER}} .rs-portfolio.swiper .content-details' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'content_wrapper_padding',
			[
				'label' => esc_html__('Padding', 'rsaddon'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors' => [
					'{{WRAPPER}} .rs-portfolio-slider .portfolio-item .portfolio-content,
					{{WRAPPER}} .rs-portfolio.swiper .content-details' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'content_wrapper_border_radius',
			[
				'label' => esc_html__('Border Radius', 'rsaddon'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors' => [
					'{{WRAPPER}} .rs-portfolio-slider .portfolio-item .portfolio-content,
					{{WRAPPER}} .rs-portfolio.swiper .content-details' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		
		$this->add_control(
			'content_position_options_heading',
			[
				'label' => esc_html__('Content Wrapper Position', 'rsaddon'),
				'type' => Controls_Manager::HEADING,
				'classes' => 'rs-control-type-heading',
			]
		);
		$this->add_responsive_control(
			'content_position_options',
			[
				'label'   => esc_html__('Position', 'rsaddon'),
				'type'    => Controls_Manager::SELECT,
				'default' => '',
				'options' => [
					'' => esc_html__('Defalut', 'rsaddon'),
					'absolute' => esc_html__('Absolute', 'rsaddon'),
					'relative' => esc_html__('Relative', 'rsaddon'),
				],
				'selectors' => [
					'{{WRAPPER}} .rs-portfolio-slider .portfolio-item .portfolio-content' => 'position: {{VALUE}};',
					'{{WRAPPER}} .rs-portfolio.swiper .content-details' => 'position: {{VALUE}};',
					'{{WRAPPER}} .rs-portfolio-style1 .portfolio-item .portfolio-content' => 'position: {{VALUE}};'
				],
			]
		);
		$this->add_responsive_control(
			'content_wrapper_position_left',
			[
				'label'      => esc_html__('Left', 'rsaddon'),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => ['px', '%', 'custom'],
				'range' => [
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'condition' => [
					'content_position_options' => ['absolute', 'relative']
				],
				'selectors' => [
					'{{WRAPPER}} .rs-portfolio-slider .portfolio-item .portfolio-content,
					{{WRAPPER}} .rs-portfolio.swiper .content-details,
					{{WRAPPER}} .rs-portfolio-style1 .portfolio-item .portfolio-content' => 'left: {{SIZE}}{{UNIT}} !important;',
				],
			]
		);
		$this->add_responsive_control(
			'content_wrapper_position_left_hover',
			[
				'label'      => esc_html__('Left (Hover)', 'rsaddon'),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => ['px', '%', 'custom'],
				'range' => [
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'condition' => [
					'content_position_options' => ['absolute', 'relative'],
					'portfolio_slider_style' => '4'
				],
				'selectors' => [
					'{{WRAPPER}} .rs-portfolio-slider .portfolio-item:hover .portfolio-content' => 'left: {{SIZE}}{{UNIT}} !important;',
				],
			]
		);
		$this->add_responsive_control(
			'content_wrapper_position_right',
			[
				'label'      => esc_html__('Right', 'rsaddon'),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => ['px', '%', 'custom'],
				'range' => [
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'condition' => [
					'content_position_options' => ['absolute', 'relative']
				],
				'selectors' => [
					'{{WRAPPER}} .rs-portfolio-slider .portfolio-item .portfolio-content,
					{{WRAPPER}} .rs-portfolio.swiper .content-details,
					{{WRAPPER}} .rs-portfolio-style1 .portfolio-item .portfolio-content' => 'right: {{SIZE}}{{UNIT}} !important;',
				],
			]
		);
		$this->add_responsive_control(
			'content_wrapper_position_right_hover',
			[
				'label'      => esc_html__('Right (Hover)', 'rsaddon'),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => ['px', '%', 'custom'],
				'range' => [
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'condition' => [
					'content_position_options' => ['absolute', 'relative'],
					'portfolio_slider_style' => '4'
				],
				'selectors' => [
					'{{WRAPPER}} .rs-portfolio-slider .portfolio-item:hover .portfolio-content' => 'right: {{SIZE}}{{UNIT}} !important;',
				],
			]
		);
		$this->add_responsive_control(
			'content_wrapper_position_top',
			[
				'label'      => esc_html__('Top', 'rsaddon'),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => ['px', '%', 'custom'],
				'range' => [
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'condition' => [
					'content_position_options' => ['absolute', 'relative']
				],
				'selectors' => [
					'{{WRAPPER}} .rs-portfolio-slider .portfolio-item .portfolio-content,
					{{WRAPPER}} .rs-portfolio.swiper .content-details,
					{{WRAPPER}} .rs-portfolio-style1 .portfolio-item .portfolio-content' => 'top: {{SIZE}}{{UNIT}} !important;',
				],
			]
		);
		$this->add_responsive_control(
			'content_wrapper_position_top_hover',
			[
				'label'      => esc_html__('Top (hover)', 'rsaddon'),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => ['px', '%', 'custom'],
				'range' => [
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'condition' => [
					'content_position_options' => ['absolute', 'relative'],
					'portfolio_slider_style' => '4'
				],
				'selectors' => [
					'{{WRAPPER}} .rs-portfolio-slider .portfolio-item:hover .portfolio-content' => 'top: {{SIZE}}{{UNIT}} !important;',
				],
			]
		);
		$this->add_responsive_control(
			'content_wrapper_position_bottom',
			[
				'label'      => esc_html__('Bottom', 'rsaddon'),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => ['px', '%', 'custom'],
				'range' => [
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'condition' => [
					'content_position_options' => ['absolute', 'relative']
				],
				'selectors' => [
					'{{WRAPPER}} .rs-portfolio-slider .portfolio-item .portfolio-content,
					{{WRAPPER}} .rs-portfolio.swiper .content-details,
					{{WRAPPER}} .rs-portfolio-style1 .portfolio-item .portfolio-content' => 'bottom: {{SIZE}}{{UNIT}} !important;',
				],
			]
		);
		$this->add_responsive_control(
			'content_wrapper_position_bottom_hover',
			[
				'label'      => esc_html__('Bottom (Hover)', 'rsaddon'),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => ['px', '%', 'custom'],
				'range' => [
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'condition' => [
					'content_position_options' => ['absolute', 'relative'],
					'portfolio_slider_style' => '4'
				],
				'selectors' => [
					'{{WRAPPER}} .rs-portfolio-slider .portfolio-item:hover .portfolio-content' => 'bottom: {{SIZE}}{{UNIT}} !important;',
				],
			]
		);
		$this->add_responsive_control(
			'content_wrapper_position_bottom_center_active',
			[
				'label'      => esc_html__('Bottom (Center Active)', 'rsaddon'),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => ['px', '%', 'custom'],
				'range' => [
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'condition' => [
					'content_position_options' => ['absolute', 'relative'],
					'portfolio_slider_style' => '4',
					'slider_centerMode' => 'true'
				],
				'selectors' => [
					'{{WRAPPER}} .rs-portfolio-slider .slick-active.slick-center .portfolio-item .portfolio-content' => 'bottom: {{SIZE}}{{UNIT}} !important;',
				],
			]
		);

		$this->start_controls_tabs( 'content_wrapper_style_tabs' );
			$this->start_controls_tab(
				'content_wrapper_style_normal_tab',
				[
					'label' => esc_html__( 'Normal', 'rsaddon' ),
				]
			);
				$this->add_group_control(
					Group_Control_Background::get_type(),
					[
						'name' => 'content_wrapper_bg',
						'types' => ['classic', 'gradient'],
						'selector' => '
							{{WRAPPER}} .rs-portfolio-slider .portfolio-item .portfolio-content
						',
						'condition' => [
							'portfolio_slider_style!' => '6',
						]
					]
				);
				$this->add_control(
					'content_wrapper_bg_style_6',
					[
						'label' => esc_html__( 'Background', 'rsaddon' ),
						'type' => Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style6 .rs-addon-sliders:after' => 'background: {{VALUE}};'
						],
						'condition' => [
							'portfolio_slider_style' => '6',
						]
					]
				);
				$this->add_control(
					'content_wrapper_bg_style_6_overlay',
					[
						'label' => esc_html__( 'Overlay Color', 'rsaddon' ),
						'type' => Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style6 .rs-addon-sliders .slick-list' => 'background: {{VALUE}};'
						],
						'condition' => [
							'portfolio_slider_style' => '6',
						]
					]
				);
				$this->add_responsive_control(
					'content_wrapper_bg_style_6_grayscale',
					[
						'label' => esc_html__( 'Grayscale', 'rsaddon' ),
						'type' => Controls_Manager::SLIDER,
						'range' => [
							'px' => [
								'min' => 0,
								'max' => 1,
								'step' => 0.01,
							]
						],
						'selectors' => [
							'{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style6 .rs-addon-sliders .slick-list' => 'backdrop-filter: grayscale({{SIZE}});',
						],
					]
				);
				$this->add_group_control(
					Group_Control_Border::get_type(),
					[
						'name' => 'content_wrapper_border',
						'selector' => '
							{{WRAPPER}} .rs-portfolio-slider .portfolio-item .portfolio-content',
					]
				);
				$this->add_group_control(
					Group_Control_Box_Shadow::get_type(),
					[
						'name' => 'content_wrapper_box_shadow',
						'exclude' => [
							'box_shadow_position',
						],
						'selector' => '
							{{WRAPPER}} .rs-portfolio-slider .portfolio-item .portfolio-content',
					]
				);
			$this->end_controls_tab();
			$this->start_controls_tab(
				'content_wrapper_style_hover_tab',
				[
					'label' => esc_html__( 'Hover', 'rsaddon' ),
				]
			);
				$this->add_group_control(
					Group_Control_Background::get_type(),
					[
						'name' => 'content_wrapper_bg_hover',
						'types' => ['classic', 'gradient'],
						'selector' => '
							{{WRAPPER}} .rs-portfolio-slider .portfolio-item:hover .portfolio-content',
					]
				);
				$this->add_control(
					'content_wrapper_border_color_hover',
					[
						'label' => esc_html__('Border Color', 'rsaddon'),
						'type' => Controls_Manager::COLOR,
						'selectors' => [
							'{{WRAPPER}} .rs-portfolio-slider .portfolio-item:hover .portfolio-content' => 'border-color: {{VALUE}};',
						],
					]
				);
				$this->add_group_control(
					Group_Control_Box_Shadow::get_type(),
					[
						'name' => 'content_wrapper_box_shadow_hover',
						'exclude' => [
							'box_shadow_position',
						],
						'selector' => '
							{{WRAPPER}} .rs-portfolio-slider .portfolio-item:hover .portfolio-content',
					]
				);
			$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_controls_section();

		// Arrow Section Start
		$this->start_controls_section(
			'section_slider_style_arrow_ontrol',
			[
				'label' => esc_html__('Arrow Control', 'rsaddon'),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' => [
					'slider_nav' => 'true'
				]
			]
		);

		// positioning start
		$this->add_control(
			'arrow_position_maker',
			[
				'label' => esc_html__('Arrow Position Style', 'rsaddon'),
				'type' => Controls_Manager::SELECT,
				'default' => '',
				'options' => [
					'' => esc_html__('Default', 'rsaddon'),
					'custom' => esc_html__('Custom', 'rsaddon'),
				],
			]
		);
		$this->add_responsive_control(
			'arrow_prev_x_select',
			[
				'label' => esc_html__('Prev Position X', 'rsaddon'),
				'type' => Controls_Manager::SELECT,
				'default' => '',
				'options' => [
					'' => esc_html__('Default', 'rsaddon'),
					'left' => esc_html__('Left', 'rsaddon'),
					'right' => esc_html__('Right', 'rsaddon'),
				],
				'condition' => [
					'arrow_position_maker' => 'custom'
				]
			]
		);
		$this->add_responsive_control(
			'arrow_prev_left_position',
			[
				'label' => esc_html__('Prev Left Position', 'rsaddon'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px', '%', 'custom'],
				'range' => [
					'px' => [
						'min' => -1000,
						'max' => 1000,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rs-addon-sliders .slick-prev, {{WRAPPER}} .swiper .swiper-button-prev' => 'left: {{SIZE}}{{UNIT}}; right: unset;',
				],
				'condition' => [
					'arrow_prev_x_select' => 'left',
					'arrow_position_maker' => 'custom'
				]
			]
		);
		$this->add_responsive_control(
			'arrow_prev_right_position',
			[
				'label' => esc_html__('Prev Right Position', 'rsaddon'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px', '%', 'custom'],
				'range' => [
					'px' => [
						'min' => -1000,
						'max' => 1000,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rs-addon-sliders .slick-prev, {{WRAPPER}} .swiper .swiper-button-prev' => 'right: {{SIZE}}{{UNIT}}; left: unset;',
				],
				'condition' => [
					'arrow_prev_x_select' => 'right',
					'arrow_position_maker' => 'custom'
				]
			]
		);

		$this->add_responsive_control(
			'arrow_prev_y_select',
			[
				'label' => esc_html__('Prev Position Y', 'rsaddon'),
				'type' => Controls_Manager::SELECT,
				'default' => '',
				'options' => [
					'' => esc_html__('Default', 'rsaddon'),
					'top' => esc_html__('Top', 'rsaddon'),
					'bottom' => esc_html__('Bottom', 'rsaddon'),
				],
				'condition' => [
					'arrow_position_maker' => 'custom'
				]
			]
		);
		$this->add_responsive_control(
			'arrow_prev_top_position',
			[
				'label' => esc_html__('Prev Top Position', 'rsaddon'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px', '%', 'custom'],
				'range' => [
					'px' => [
						'min' => -1000,
						'max' => 1000,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rs-addon-sliders .slick-prev, {{WRAPPER}} .swiper .swiper-button-prev' => 'top: {{SIZE}}{{UNIT}}; bottom: unset;',
				],
				'condition' => [
					'arrow_prev_y_select' => 'top',
					'arrow_position_maker' => 'custom'
				]
			]
		);
		$this->add_responsive_control(
			'arrow_prev_bottom_position',
			[
				'label' => esc_html__('Prev Bottom Position', 'rsaddon'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px', '%', 'custom'],
				'range' => [
					'px' => [
						'min' => -1000,
						'max' => 1000,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rs-addon-sliders .slick-prev, {{WRAPPER}} .swiper .swiper-button-prev' => 'bottom: {{SIZE}}{{UNIT}}; top: unset;',
				],
				'condition' => [
					'arrow_prev_y_select' => 'bottom',
					'arrow_position_maker' => 'custom'
				]
			]
		);

		$this->add_responsive_control(
			'arrow_next_x_select',
			[
				'label' => esc_html__('Next Position X', 'rsaddon'),
				'type' => Controls_Manager::SELECT,
				'default' => '',
				'options' => [
					'' => esc_html__('Default', 'rsaddon'),
					'left' => esc_html__('Left', 'rsaddon'),
					'right' => esc_html__('Right', 'rsaddon'),
				],
				'condition' => [
					'arrow_position_maker' => 'custom'
				]
			]
		);
		$this->add_responsive_control(
			'arrow_next_left_position',
			[
				'label' => esc_html__('Next Left Position', 'rsaddon'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px', '%', 'custom'],
				'range' => [
					'px' => [
						'min' => -1000,
						'max' => 1000,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rs-addon-sliders .slick-next, {{WRAPPER}} .swiper .swiper-button-next' => 'left: {{SIZE}}{{UNIT}}; right: unset;',
				],
				'condition' => [
					'arrow_next_x_select' => 'left',
					'arrow_position_maker' => 'custom'
				]
			]
		);
		$this->add_responsive_control(
			'arrow_next_right_position',
			[
				'label' => esc_html__('Next Right Position', 'rsaddon'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px', '%', 'custom'],
				'range' => [
					'px' => [
						'min' => -1000,
						'max' => 1000,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rs-addon-sliders .slick-next, {{WRAPPER}} .swiper .swiper-button-next' => 'right: {{SIZE}}{{UNIT}}; left: unset;',
				],
				'condition' => [
					'arrow_next_x_select' => 'right',
					'arrow_position_maker' => 'custom'
				]
			]
		);

		$this->add_responsive_control(
			'arrow_next_y_select',
			[
				'label' => esc_html__('Next Position Y', 'rsaddon'),
				'type' => Controls_Manager::SELECT,
				'default' => '',
				'options' => [
					'' => esc_html__('Default', 'rsaddon'),
					'top' => esc_html__('Top', 'rsaddon'),
					'bottom' => esc_html__('Bottom', 'rsaddon'),
				],
				'condition' => [
					'arrow_position_maker' => 'custom'
				]
			]
		);
		$this->add_responsive_control(
			'arrow_next_top_position',
			[
				'label' => esc_html__('Next Top Position', 'rsaddon'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px', '%', 'custom'],
				'range' => [
					'px' => [
						'min' => -1000,
						'max' => 1000,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rs-addon-sliders .slick-next, {{WRAPPER}} .swiper .swiper-button-next' => 'top: {{SIZE}}{{UNIT}}; bottom: unset;',
				],
				'condition' => [
					'arrow_next_y_select' => 'top',
					'arrow_position_maker' => 'custom'
				]
			]
		);
		$this->add_responsive_control(
			'arrow_next_bottom_position',
			[
				'label' => esc_html__('Next Bottom Position', 'rsaddon'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px', '%', 'custom'],
				'range' => [
					'px' => [
						'min' => -1000,
						'max' => 1000,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rs-addon-sliders .slick-next, {{WRAPPER}} .swiper .swiper-button-next' => 'bottom: {{SIZE}}{{UNIT}}; top: unset;',
				],
				'condition' => [
					'arrow_next_y_select' => 'bottom',
					'arrow_position_maker' => 'custom'
				]
			]
		);
		// positioning end

		$this->add_control(
			'arrow_after_hr',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);

		$this->add_responsive_control(
			'navigation_arrow_width',
			[
				'label' => esc_html__('Arrow Width', 'rsaddon'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'selectors' => [
					'{{WRAPPER}} .swiper .swiper-button-next,
					{{WRAPPER}} .swiper .swiper-button-prev,
					{{WRAPPER}} .rs-addon-sliders .slick-prev,
					{{WRAPPER}} .rs-addon-sliders .slick-next' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'navigation_arrow_height',
			[
				'label' => esc_html__('Arrow Height', 'rsaddon'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'selectors' => [
					'{{WRAPPER}} .swiper .swiper-button-next,
					{{WRAPPER}} .swiper .swiper-button-prev,
					{{WRAPPER}} .rs-addon-sliders .slick-prev,
					{{WRAPPER}} .rs-addon-sliders .slick-next' => 'height: {{SIZE}}{{UNIT}}; line-height: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'navigation_arrow_line_height',
			[
				'label' => esc_html__('Arrow Line Height', 'rsaddon'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'selectors' => [
					'{{WRAPPER}} .swiper .swiper-button-next,
					{{WRAPPER}} .swiper .swiper-button-prev,
					{{WRAPPER}} .rs-addon-sliders .slick-prev,
					{{WRAPPER}} .rs-addon-sliders .slick-next' => 'line-height: {{SIZE}}{{UNIT}} !important;',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'nav_icon_typography',
				'label' => esc_html__('Icon Typography', 'rsaddon'),
				'selector' => '
					{{WRAPPER}} .swiper .swiper-button-next,
					{{WRAPPER}} .swiper .swiper-button-prev,
					{{WRAPPER}} .rs-addon-sliders .slick-prev::before,
					{{WRAPPER}} .rs-addon-sliders .slick-next::before
				',
			]
		);

		$this->add_control(
			'arrow_border_radius_',
			[
				'label' => esc_html__('Border Radius', 'rsaddon'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors' => [
					'{{WRAPPER}} .swiper .swiper-button-next,
					{{WRAPPER}} .swiper .swiper-button-prev,
					{{WRAPPER}} .rs-addon-sliders .slick-prev,
					{{WRAPPER}} .rs-addon-sliders .slick-next' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
			'arrow_border_padding_',
			[
				'label' => esc_html__('Padding', 'rsaddon'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors' => [
					'{{WRAPPER}} .swiper .swiper-button-next,
					{{WRAPPER}} .swiper .swiper-button-prev,
					{{WRAPPER}} .rs-addon-sliders .slick-prev,
					{{WRAPPER}} .rs-addon-sliders .slick-next' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		// Arrow Hover Normal Tab Start
		$this->start_controls_tabs('_tabs_slider_arrow');
		// Normal Bullet Start
		$this->start_controls_tab(
			'slider_arrow_normal_tab',
			[
				'label' => esc_html__('Normal', 'rsaddon'),
			]
		);
		$this->add_control(
			'navigation_arrow_color',
			[
				'label' => esc_html__('Icon Color', 'rsaddon'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swiper .swiper-button-next,
							{{WRAPPER}} .swiper .swiper-button-prev,
							{{WRAPPER}} .rs-addon-sliders .slick-prev::before,
							{{WRAPPER}} .rs-addon-sliders .slick-next::before' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'navigation_arrow_background',
				'types' => ['classic', 'gradient'],
				'selector' => '
							{{WRAPPER}} .swiper .swiper-button-next,
							{{WRAPPER}} .swiper .swiper-button-prev,
							{{WRAPPER}} .rs-addon-sliders .slick-prev,
							{{WRAPPER}} .rs-addon-sliders .slick-next
						',
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'nav_arrow_border',
				'selector' => '
							{{WRAPPER}} .swiper .swiper-button-next,
							{{WRAPPER}} .swiper .swiper-button-prev,
							{{WRAPPER}} .rs-addon-sliders .slick-prev,
							{{WRAPPER}} .rs-addon-sliders .slick-next
						',
			]
		);
		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'arrow_shadow_custom',
				'selector' => '
							{{WRAPPER}} .swiper .swiper-button-next,
							{{WRAPPER}} .swiper .swiper-button-prev,
							{{WRAPPER}} .rs-addon-sliders .slick-prev,
							{{WRAPPER}} .rs-addon-sliders .slick-next
						',
			]
		);
		$this->add_responsive_control(
			'arrow_filter_blur',
			[
				'label' => esc_html__( 'Filter Blur', 'rsaddon' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					]
				],
				'selectors' => [
					'{{WRAPPER}} .rs-addon-sliders .slick-prev, {{WRAPPER}} .rs-addon-sliders .slick-next' => 'backdrop-filter: blur({{SIZE}}{{UNIT}});',
				]
			]
		);
		$this->end_controls_tab();

		// Hover Bullet Start
		$this->start_controls_tab(
			'slider_arrow_hover_tab',
			[
				'label' => esc_html__('Hover', 'rsaddon'),
			]
		);
		$this->add_control(
			'navigation_arrow_color_hover',
			[
				'label' => esc_html__('Icon Color', 'rsaddon'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swiper .swiper-button-next:hover,
							{{WRAPPER}} .swiper .swiper-button-prev:hover,
							{{WRAPPER}} .rs-addon-sliders .slick-prev:hover::before,
							{{WRAPPER}} .rs-addon-sliders .slick-next:hover::before' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'navigation_arrow_background_hover',
				'types' => ['classic', 'gradient'],
				'selector' => '
							{{WRAPPER}} .swiper .swiper-button-next:hover,
							{{WRAPPER}} .swiper .swiper-button-prev:hover,
							{{WRAPPER}} .rs-addon-sliders .slick-prev:hover,
							{{WRAPPER}} .rs-addon-sliders .slick-next:hover
						',
			]
		);
		$this->add_control(
			'nav_arrow_border_hover',
			[
				'label' => esc_html__('Border Color', 'rsaddon'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swiper .swiper-button-next:hover,
							{{WRAPPER}} .swiper .swiper-button-prev:hover,
							{{WRAPPER}} .rs-addon-sliders .slick-prev:hover,
							{{WRAPPER}} .rs-addon-sliders .slick-next:hover' => 'border-color: {{VALUE}};',
				],
			]
		);
		$this->end_controls_tab();
		$this->end_controls_tabs();
		// Arrow Hover Normal Tab End
		$this->end_controls_section();
		// Arrow Style End

		// Bullet Style Start
		$this->start_controls_section(
			'section_slider_style_dots_ontrol',
			[
				'label' => esc_html__('Dots Control', 'rsaddon'),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' => [
					'slider_dots' => 'true'
				]
			]
		);
		$this->add_responsive_control(
			'bullet_alignment_dots',
			[
				'label' => esc_html__('Alignment', 'rsaddon'),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__('Left', 'rsaddon'),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__('Center', 'rsaddon'),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__('Right', 'rsaddon'),
						'icon' => 'eicon-text-align-right',
					],
					'justify' => [
						'title' => esc_html__('Justify', 'rsaddon'),
						'icon' => 'eicon-text-align-justify',
					],
				],
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .rs-portfolio-slider ul.slick-dots' => 'text-align: {{VALUE}}'
				],
			]
		);

		$this->add_control(
			'_hr',
			[
				'type' => Controls_Manager::DIVIDER,
				'style' => 'thick',
			]
		);

		$this->add_control(
			'bullet_item_options',
			[
				'label' => esc_html__('Bullet Item Style', 'rsaddon'),
				'type' => Controls_Manager::HEADING,
				'classes' => 'rs-control-type-heading',
			]
		);
		$this->add_control(
			'dots__margin',
			[
				'label' => esc_html__('Margin', 'rsaddon'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors' => [
					'{{WRAPPER}} .rs-addon-slider .slick-dots li' => 'Margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->start_controls_tabs('_tabs_slider_dots');

		// Normal Bullet Start
		$this->start_controls_tab(
			'slider_dots_normal_tab',
			[
				'label' => esc_html__('Normal', 'rsaddon'),
			]
		);
		$this->add_control(
			'navigation_dot_inner_color',
			[
				'label' => esc_html__('Inner Dot Color', 'rsaddon'),
				'type' => Controls_Manager::COLOR,
				'condition' => [
					'slider_dots_style' => '2',
				],
				'selectors' => [
					'{{WRAPPER}} .rs-addon-slider .slick-dots li button:after' => 'background: {{VALUE}}',
				],
			]
		);
		$this->add_responsive_control(
			'bullet_inner_dot_height_custom',
			[
				'label' => esc_html__('Inner Dot Height', 'rsaddon'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'selectors' => [
					'{{WRAPPER}} .rs-addon-slider .slick-dots li button:after' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'bullet_inner_dot_normal_width_custom',
			[
				'label' => esc_html__('Inner Dot Width', 'rsaddon'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'selectors' => [
					'{{WRAPPER}} .rs-addon-slider .slick-dots li button:after' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'bullet_inner_dot_border_radius',
			[
				'label' => esc_html__('Inner Dot Radius', 'rsaddon'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'selectors' => [
					'{{WRAPPER}} .rs-addon-slider .slick-dots li button:after' => 'border-radius: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name'     => 'navigation_dot_icon_background',
				'selector' => '{{WRAPPER}} .rs-addon-slider .slick-dots li button',
			]
		);

		$this->add_responsive_control(
			'bullet_height_custom',
			[
				'label' => esc_html__('Bullet Height', 'rsaddon'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'selectors' => [
					'{{WRAPPER}} .rs-addon-slider .slick-dots li button' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'bullet_normal_width_custom',
			[
				'label' => esc_html__('Bullet Width', 'rsaddon'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'selectors' => [
					'{{WRAPPER}} .rs-addon-slider .slick-dots li button' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'bullet_border_radius_custom',
			[
				'label' => esc_html__('Border Radius', 'rsaddon'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors' => [
					'{{WRAPPER}} .rs-addon-slider .slick-dots li button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'bullet_border_custom',
				'selector' => '{{WRAPPER}} .rs-addon-slider .slick-dots li button',
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'bullet_shadow_custom',
				'selector' => '{{WRAPPER}} .rs-addon-slider .slick-dots li button'
			]
		);

		$this->end_controls_tab();
		// Normal Bullet End

		// Active Bullet Start
		$this->start_controls_tab(
			'slider_dots_active_tab',
			[
				'label' => esc_html__('Active', 'rsaddon'),
			]
		);
		$this->add_control(
			'navigation_dot_inner_color_active',
			[
				'label' => esc_html__('Inner Dot Color', 'rsaddon'),
				'type' => Controls_Manager::COLOR,
				'condition' => [
					'slider_dots_style' => '2',
				],
				'selectors' => [
					'{{WRAPPER}} .rs-addon-slider .slick-dots li button:hover:after,
					{{WRAPPER}} .rs-addon-slider .slick-dots li.slick-active button:after' => 'background: {{VALUE}}',
				],
			]
		);
		$this->add_responsive_control(
			'bullet_inner_dot_height_custom_active',
			[
				'label' => esc_html__('Inner Dot Height', 'rsaddon'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'selectors' => [
					'{{WRAPPER}} .rs-addon-slider .slick-dots li button:hover:after,
					{{WRAPPER}} .rs-addon-slider .slick-dots li.slick-active button:after' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'bullet_inner_dot_active_width_custom',
			[
				'label' => esc_html__('Inner Dot Width', 'rsaddon'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'selectors' => [
					'{{WRAPPER}} .rs-addon-slider .slick-dots li button:hover:after,
					{{WRAPPER}} .rs-addon-slider .slick-dots li.slick-active button:after' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name'     => 'navigation_dot_icon_background_active',
				'selector' => '{{WRAPPER}} .rs-addon-slider .slick-dots li button:hover, {{WRAPPER}} .rs-addon-slider .slick-dots li.slick-active button',
			]
		);

		$this->add_responsive_control(
			'bullet_active_width_custom',
			[
				'label' => esc_html__('Bullet Width', 'rsaddon'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'selectors' => [
					'{{WRAPPER}} .rs-addon-slider .slick-dots li.slick-active button' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'bullet_active_height_custom',
			[
				'label' => esc_html__('Bullet Height', 'rsaddon'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'selectors' => [
					'{{WRAPPER}} .rs-addon-slider .slick-dots li.slick-active button' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'bullet_active_scale_custom',
			[
				'label' => esc_html__('Bullet Scale', 'rsaddon'),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 0.1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rs-addon-slider .slick-dots li.slick-active button' => 'transform: scale({{SIZE}})',
				],
			]
		);

		$this->add_control(
			'navigation_dot_active_border_color',
			[
				'label' => esc_html__('Border Color', 'rsaddon'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rs-addon-slider .slick-dots li button:hover' => 'border-color: {{VALUE}};',
					'{{WRAPPER}} .rs-addon-slider .slick-dots li.slick-active button' => 'border-color: {{VALUE}};',

				],
			]
		);

		$this->end_controls_tab();
		$this->end_controls_tabs();
		// Active Bullet End

		$this->add_responsive_control(
			'bullet_spacing_custom',
			[
				'label' => esc_html__('Top Gap', 'rsaddon'),
				'type' => Controls_Manager::SLIDER,
				'show_label' => true,
				'range' => [
					'px' => [
						'max' => 100,
					],
				],
				'default' => [
					'size' => 25,
				],
				'separator' => 'before',
				'selectors' => [
					'{{WRAPPER}} .rs-addon-slider .slick-dots' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'bullet_spacing_custom_position',
			[
				'label' => esc_html__('Top Position', 'rsaddon'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px', '%', 'em', 'rem', 'custom'],
				'show_label' => true,
				'range' => [
					'px' => [
						'min' => -1000,
						'max' => 1000,
					],
					'%' => [
						'min' => -1000,
						'max' => 1000,
					],
				],
				'separator' => 'before',
				'selectors' => [
					'{{WRAPPER}} .rs-addon-slider .slick-dots' => 'top: {{SIZE}}{{UNIT}}; bottom:unset;',
				],
			]
		);
		$this->add_responsive_control(
			'bullet_spacing_custom_position_bottom',
			[
				'label' => esc_html__('Bottom Position', 'rsaddon'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px', '%', 'em', 'rem', 'custom'],
				'show_label' => true,
				'range' => [
					'px' => [
						'min' => -1000,
						'max' => 1000,
					],
					'%' => [
						'min' => -1000,
						'max' => 1000,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rs-addon-slider .slick-dots' => 'bottom: {{SIZE}}{{UNIT}}; top: unset;',
				],
			]
		);
		$this->end_controls_section();
		// Bullet Style End


		// Button Style Start
		$this->start_controls_section(
			'btn_style',
			[
				'label' => esc_html__('Button Style', 'rsaddon'),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' => [
					'btn__show_hide' => 'yes',
					'portfolio_slider_style!' => '7'
				],
			]
		);
			$this->add_control(
				'btn_top_line_color',
				[
					'label' => esc_html__('Button Border Top Color', 'rsaddon'),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .rs-portfolio-slider .portfolio-item .p-icon' => 'border-top: 1px solid {{VALUE}};',
					],
					'condition' => ['portfolio_slider_style!' => '5']
				]
			);
			$this->add_responsive_control(
				'button_width',
				[
					'label'      => esc_html__('Button Width', 'rsaddon'),
					'type'       => Controls_Manager::SLIDER,
					'size_units' => ['px', '%', 'custom'],
					'range' => [
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .rs-portfolio-slider .portfolio-item .p-icon .prs_btn' => 'width: {{SIZE}}{{UNIT}};display:flex;align-items:center;justify-content:center;',
					],
					'condition' => ['portfolio_slider_style!' => '5']
				]
			);
			$this->add_responsive_control(
				'button_height',
				[
					'label'      => esc_html__('Button Height', 'rsaddon'),
					'type'       => Controls_Manager::SLIDER,
					'size_units' => ['px', '%', 'custom'],
					'range' => [
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .rs-portfolio-slider .portfolio-item .p-icon .prs_btn' => 'height: {{SIZE}}{{UNIT}};',
					],
					'condition' => ['portfolio_slider_style!' => '5']
				]
			);
			$this->add_responsive_control(
				'button_svgwidth',
				[
					'label'      => esc_html__('Button SVg Width', 'rsaddon'),
					'type'       => Controls_Manager::SLIDER,
					'size_units' => ['px', '%', 'custom'],
					'range' => [
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .rs-portfolio-slider .portfolio-item .p-icon a.prs_btn .btn_icon_2 svg' => 'width: {{SIZE}}{{UNIT}};',
						'{{WRAPPER}} .rs-portfolio-slider .portfolio-item .p-icon a.prs_btn .btn_icon_1 svg' => 'width: {{SIZE}}{{UNIT}};',
						'{{WRAPPER}} .rs-portfolio-style5.rs-portfolio-slider .portfolio-item .p-icon2 svg' => 'width: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'button_svgheight',
				[
					'label'      => esc_html__('Button SVg Height', 'rsaddon'),
					'type'       => Controls_Manager::SLIDER,
					'size_units' => ['px', '%', 'custom'],
					'range' => [
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .rs-portfolio-slider .portfolio-item .p-icon a.prs_btn .btn_icon_2 svg' => 'height: {{SIZE}}{{UNIT}};',
						'{{WRAPPER}} .rs-portfolio-slider .portfolio-item .p-icon a.prs_btn .btn_icon_1 svg' => 'height: {{SIZE}}{{UNIT}};',
						'{{WRAPPER}} .rs-portfolio-style5.rs-portfolio-slider .portfolio-item .p-icon2 svg' => 'height: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'button_position_options',
				[
					'label'   => esc_html__('Position', 'rsaddon'),
					'type'    => Controls_Manager::SELECT,
					'default' => '',
					'options' => [
						'' => esc_html__('Defalut', 'rsaddon'),
						'absolute' => esc_html__('Absolute', 'rsaddon'),
						'relative' => esc_html__('Relative', 'rsaddon'),
					],
					'selectors' => [
						'{{WRAPPER}} .rs-portfolio-slider .portfolio-item .portfolio-content .p-icon' => 'position: {{VALUE}};',
					],
				]
			);
			$this->add_responsive_control(
				'button_top_normal_position',
				[
					'label'      => esc_html__('Button Top Position', 'rsaddon'),
					'type'       => Controls_Manager::SLIDER,
					'size_units' => ['px', '%', 'custom'],
					'range' => [
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .rs-portfolio-slider .portfolio-item .p-icon' => 'top: {{SIZE}}{{UNIT}};bottom:unset;',
						'{{WRAPPER}} .rs-portfolio-style5.rs-portfolio-slider .portfolio-item .p-icon2 a.prs_btn' => 'right: {{SIZE}}{{UNIT}};left:unset;',
					],
				]
			);
			$this->add_responsive_control(
				'button_bottom_normal_position',
				[
					'label'      => esc_html__('Button Bottom Position', 'rsaddon'),
					'type'       => Controls_Manager::SLIDER,
					'size_units' => ['px', '%', 'custom'],
					'range' => [
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .rs-portfolio-slider .portfolio-item .p-icon' => 'bottom: {{SIZE}}{{UNIT}};',
						'{{WRAPPER}} .rs-portfolio-style5.rs-portfolio-slider .portfolio-item .p-icon2 a.prs_btn' => 'bottom: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'button_bottom_position',
				[
					'label'      => esc_html__('Button Hover Bottom Position', 'rsaddon'),
					'type'       => Controls_Manager::SLIDER,
					'size_units' => ['px', '%', 'custom'],
					'range' => [
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .rs-portfolio-slider .portfolio-item:hover .p-icon' => 'bottom: {{SIZE}}{{UNIT}};',
					],
					'condition' => ['portfolio_slider_style!' => '5']
				]
			);
			$this->add_responsive_control(
				'button_right_normal_position',
				[
					'label'      => esc_html__('Button Right Position', 'rsaddon'),
					'type'       => Controls_Manager::SLIDER,
					'size_units' => ['px', '%', 'custom'],
					'range' => [
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .rs-portfolio-slider .portfolio-item .p-icon' => 'right: {{SIZE}}{{UNIT}};left:unset;',
						'{{WRAPPER}} .rs-portfolio-style5.rs-portfolio-slider .portfolio-item .p-icon2 a.prs_btn' => 'right: {{SIZE}}{{UNIT}};left:unset;',
					],
				]
			);
			$this->add_responsive_control(
				'button_left_normal_position',
				[
					'label'      => esc_html__('Button Left Position', 'rsaddon'),
					'type'       => Controls_Manager::SLIDER,
					'size_units' => ['px', '%', 'custom'],
					'range' => [
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .rs-portfolio-slider .portfolio-item .p-icon' => 'left: {{SIZE}}{{UNIT}};right:unset;',
						'{{WRAPPER}} .rs-portfolio-style5.rs-portfolio-slider .portfolio-item .p-icon2 a.prs_btn' => 'left: {{SIZE}}{{UNIT}};right:unset;',
					],
				]
			);
			$this->add_responsive_control(
				'button_opacity',
				[
					'label' => esc_html__( 'Button Opacity', 'rsaddon' ),
					'type' => Controls_Manager::SLIDER,
					'show_label' => true,
					'size_units' => [ 'px' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 1,
							'step' => 0.1,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .rs-portfolio-slider .portfolio-item .p-icon' => 'opacity: {{SIZE}};',                   
					],
					'condition' => ['portfolio_slider_style' => '4']
				]
			);
			$this->start_controls_tabs(
				'btn__style_tabs'
			);
				$this->start_controls_tab(
					'btn__style_normal_tab',
					[
						'label' => esc_html__('Normal', 'rsaddon'),
					]
				);
					$this->add_group_control(
						Group_Control_Typography::get_type(),
						[
							'name' => 'btn_typography',
							'selector' => '{{WRAPPER}} .rs-portfolio-slider .portfolio-item .p-icon a.prs_btn,{{WRAPPER}} .rs-portfolio-style2 .portfolio-item .p-icon a.prs_btn .btn_text,{{WRAPPER}} .rs-portfolio-style5.rs-portfolio-slider .portfolio-item .p-icon2 a.prs_btn .pbtn_text',
						]
					);
					$this->add_control(
						'btn_text_color',
						[
							'label' => esc_html__('Text Color', 'rsaddon'),
							'type' => Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .rs-portfolio-slider .portfolio-item .p-icon a.prs_btn' => 'color: {{VALUE}};',
								'{{WRAPPER}} .rs-portfolio-style5.rs-portfolio-slider .portfolio-item .p-icon2 a.prs_btn .pbtn_text' => 'color: {{VALUE}};',
								'{{WRAPPER}} .rs-portfolio-style2 .portfolio-item .p-icon a.prs_btn .btn_text' => 'color: {{VALUE}};',
								'{{WRAPPER}} .rs-portfolio-style1 .portfolio-item .p-icon a.prs_btn svg' => 'fill: {{VALUE}};',
								'{{WRAPPER}} .rs-portfolio-style1 .portfolio-item .p-icon a.prs_btn svg path' => 'fill: {{VALUE}};',
								'{{WRAPPER}} .rs-portfolio-style5.rs-portfolio-slider .portfolio-item .p-icon2 svg' => 'fill: {{VALUE}};',
								'{{WRAPPER}} .rs-portfolio-style5.rs-portfolio-slider .portfolio-item .p-icon2 svg path' => 'fill: {{VALUE}};',
							],
						]
					);
					$this->add_group_control(
						Group_Control_Background::get_type(),
						[
							'name' => 'btn_bg',
							'label' => esc_html__('Background', 'rsaddon'),
							'types' => ['classic', 'gradient'],
							'selector' => '{{WRAPPER}} .rs-portfolio-slider .portfolio-item .p-icon a.prs_btn,{{WRAPPER}} .rs-portfolio-style2 .portfolio-item .p-icon a.prs_btn .btn_text,{{WRAPPER}} .rs-portfolio-style5.rs-portfolio-slider .portfolio-item .p-icon2 a.prs_btn span.pbtn_icon,{{WRAPPER}} .rs-portfolio-style5.rs-portfolio-slider .portfolio-item .p-icon2 a.prs_btn .pbtn_text',
						]
					);
					$this->add_control(
						'btn_icon_color_style4',
						[
							'label' => esc_html__('Icon Color', 'rsaddon'),
							'type' => Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style4 .portfolio-item .p-icon a.prs_btn svg path' => 'fill: {{VALUE}};',
								'{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style4 .portfolio-item .p-icon a.prs_btn i' => 'color: {{VALUE}};',
							],
							'condition' => [
								'portfolio_slider_style' => '4'
							]
						]
					);
					$this->add_responsive_control(
						'btn_icon_size_style4',
						[
							'label'      => esc_html__('Icon Size', 'rsaddon'),
							'type'       => Controls_Manager::SLIDER,
							'size_units' => ['px', '%', 'custom'],
							'range' => [
								'px' => [
									'min' => 0,
									'max' => 150
								],
								'%' => [
									'min' => 0,
									'max' => 100,
								],
							],
							'selectors' => [
								'{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style4 .portfolio-item .p-icon a.prs_btn svg' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
								'{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style4 .portfolio-item .p-icon a.prs_btn i' => 'font-size: {{SIZE}}{{UNIT}};',
							],
							'condition' => [
								'portfolio_slider_style' => '4'
							]
						]
					);
					$this->add_control(
						'btn_bg_icon_bg_style3',
						[
							'label' => esc_html__('Icon Bg Color', 'rsaddon'),
							'type' => Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .rs-portfolio-style3 .portfolio-item .p-icon a.prs_btn em' => 'background: {{VALUE}};'
							],
							'condition' => [
								'portfolio_slider_style' => '3'
							]
						]
					);
					$this->add_control(
						'button_brder_radius',
						[
							'label' => esc_html__('Border Radius', 'rsaddon'),
							'type' => Controls_Manager::DIMENSIONS,
							'size_units' => ['px', '%'],
							'selectors' => [
								'{{WRAPPER}} .rs-portfolio-style1 .portfolio-item .p-icon a.prs_btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
								'{{WRAPPER}} .rs-portfolio-slider .portfolio-item .p-icon a.prs_btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
								'{{WRAPPER}} .rs-portfolio-style2 .portfolio-item .p-icon a.prs_btn .btn_text' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
							],
							'condition' => ['portfolio_slider_style!' => '5']
						]
					);
					$this->add_control(
						'button__margin',
						[
							'label' => esc_html__('Margin', 'rsaddon'),
							'type' => Controls_Manager::DIMENSIONS,
							'size_units' => ['px', '%'],
							'selectors' => [
								'{{WRAPPER}} .rs-portfolio-slider .portfolio-item .p-icon a.prs_btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
								'{{WRAPPER}} .rs-portfolio-style5.rs-portfolio-slider .portfolio-item .p-icon2 a.prs_btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
								'{{WRAPPER}} .rs-portfolio-style4.rs-portfolio-slider .portfolio-item .p-icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
							],
						]
					);
					$this->add_responsive_control(
						'button__padding',
						[
							'label' => esc_html__('Padding', 'rsaddon'),
							'type' => Controls_Manager::DIMENSIONS,
							'size_units' => ['px', 'em', '%', 'custom'],
							'selectors' => [
								'{{WRAPPER}} .rs-portfolio-style1 .portfolio-item .p-icon a.prs_btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
								'{{WRAPPER}} .rs-portfolio-style3 .portfolio-item .p-icon a.prs_btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
								'{{WRAPPER}} .rs-portfolio-style2 .portfolio-item .p-icon a.prs_btn .btn_text' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
								'{{WRAPPER}} .rs-portfolio-style5.rs-portfolio-slider .portfolio-item .p-icon2 a.prs_btn span.pbtn_icon' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
								'{{WRAPPER}} .rs-portfolio-style4.rs-portfolio-slider .portfolio-item .p-icon' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
							],
						]
					);
					$this->add_responsive_control(
						'button__padding_anchor_style4',
						[
							'label' => esc_html__('Anchor Padding', 'rsaddon'),
							'type' => Controls_Manager::DIMENSIONS,
							'size_units' => ['px', 'em', '%', 'custom'],
							'selectors' => [
								'{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style4 .portfolio-item .p-icon a.prs_btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
							],
							'condition' => ['portfolio_slider_style' => '4']
						]
					);
					$this->add_responsive_control(
						'button__padding_wrapper_style3',
						[
							'label' => esc_html__('Wrapper Padding', 'rsaddon'),
							'type' => Controls_Manager::DIMENSIONS,
							'size_units' => ['px', 'em', '%'],
							'selectors' => [
								'{{WRAPPER}} .rs-portfolio-style3 .portfolio-item .p-icon' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
							],
							'condition' => [
								'portfolio_slider_style' => '3'
							]
						]
					);
					$this->add_group_control(
						\Elementor\Group_Control_Border::get_type(),
						[
							'name' => 'portfolio__border',
							'selector' => '{{WRAPPER}} .rs-portfolio-style1 .portfolio-item .p-icon a.prs_btn,{{WRAPPER}} .rs-portfolio-style2 .portfolio-item .p-icon a.prs_btn .btn_text,{{WRAPPER}} .rs-portfolio-slider .portfolio-item .p-icon a.prs_btn,{{WRAPPER}} .rs-portfolio-style4.rs-portfolio-slider .portfolio-item .p-icon',
							'condition' => ['portfolio_slider_style!' => '5']
						]
					);
					$this->add_control(
						'btn__icon_bg_color',
						[
							'label' => esc_html__('Icon BG Color', 'rsaddon'),
							'type' => Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .rs-portfolio-style2 .portfolio-item .p-icon .btn_icon_1' => 'background-color: {{VALUE}};',
							],
							'condition' => ['portfolio_slider_style' => '2']
						]
					);
					$this->add_control(
						'btn__icon_color',
						[
							'label' => esc_html__('Svg Icon Color', 'rsaddon'),
							'type' => Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .rs-portfolio-style2 .portfolio-item .p-icon .btn_icon_1 svg' => 'fill: {{VALUE}};',
								'{{WRAPPER}} .rs-portfolio-style2 .portfolio-item .p-icon .btn_icon_1 svg path' => 'fill: {{VALUE}};',
							],
							'condition' => ['portfolio_slider_style' => '2']
						]
					);
				$this->end_controls_tab();

				$this->start_controls_tab(
					'btn__style_hover_tab',
					[
						'label' => esc_html__('Hover', 'rsaddon'),
					]
				);
					$this->add_group_control(
						Group_Control_Background::get_type(),
						[
							'name' => 'btn__hover_bg',
							'label' => esc_html__('Background', 'rsaddon'),
							'types' => ['classic', 'gradient'],
							'selector' => '{{WRAPPER}} .rs-portfolio-slider .portfolio-item .p-icon a.prs_btn:hover,{{WRAPPER}} .rs-portfolio-style2 .portfolio-item .p-icon a.prs_btn .btn_text:hover,{{WRAPPER}} .rs-portfolio-style5.rs-portfolio-slider .portfolio-item .p-icon2 a.prs_btn:hover span.pbtn_icon,{{WRAPPER}} .rs-portfolio-style5.rs-portfolio-slider .portfolio-item .p-icon2 a.prs_btn:hover .pbtn_text',
						]
					);
					$this->add_control(
						'btn__hover_text_color',
						[
							'label' => esc_html__('Text Color', 'rsaddon'),
							'type' => Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .rs-portfolio-slider .portfolio-item .p-icon a.prs_btn:hover' => 'color: {{VALUE}};',
								'{{WRAPPER}} .rs-portfolio-style2 .portfolio-item .p-icon a.prs_btn .btn_text:hover' => 'color: {{VALUE}};',
								'{{WRAPPER}} .rs-portfolio-style1 .portfolio-item .p-icon a.prs_btn:hover svg' => 'fill: {{VALUE}};',
								'{{WRAPPER}} .rs-portfolio-style1 .portfolio-item .p-icon a.prs_btn:hover svg path' => 'fill: {{VALUE}};',
								'{{WRAPPER}} .rs-portfolio-style5.rs-portfolio-slider .portfolio-item .p-icon2 a.prs_btn:hover .pbtn_text' => 'color: {{VALUE}};',
								'{{WRAPPER}} .rs-portfolio-style5.rs-portfolio-slider .portfolio-item .p-icon2 a.prs_btn:hover .pbtn_icon svg' => 'color: {{VALUE}};',
								'{{WRAPPER}} .rs-portfolio-style5.rs-portfolio-slider .portfolio-item .p-icon2 a.prs_btn:hover .pbtn_icon svg path' => 'color: {{VALUE}};',
							],
						]
					);
					$this->add_control(
						'btn_icon_color_hover_style4',
						[
							'label' => esc_html__('Icon Color', 'rsaddon'),
							'type' => Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style4 .portfolio-item .p-icon a.prs_btn:hover svg path' => 'fill: {{VALUE}};',
								'{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style4 .portfolio-item .p-icon a.prs_btn:hover i' => 'color: {{VALUE}};',
							],
							'condition' => [
								'portfolio_slider_style' => '4'
							]
						]
					);
					$this->add_group_control(
						\Elementor\Group_Control_Border::get_type(),
						[
							'name' => 'portfolio_hover_border',
							'selector' => '{{WRAPPER}} .rs-portfolio-slider .portfolio-item .p-icon a.prs_btn:hover,{{WRAPPER}} .rs-portfolio-style2 .portfolio-item .p-icon a.prs_btn .btn_text',
							'condition' => ['portfolio_slider_style!' => '5']
						]
					);
					$this->add_control(
						'btn__icon_hover_bg_color',
						[
							'label' => esc_html__('Icon HOver BG Color', 'rsaddon'),
							'type' => Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .rs-portfolio-style2 .portfolio-item .p-icon .btn_icon_1:hover' => 'background-color: {{VALUE}};',
							],
							'condition' => ['portfolio_slider_style' => '2']
						]
					);
					$this->add_control(
						'btn__icon_hover_color',
						[
							'label' => esc_html__('Hover Icon Color', 'rsaddon'),
							'type' => Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .rs-portfolio-style2 .portfolio-item .p-icon .btn_icon_1:hover svg' => 'fill: {{VALUE}};',
								'{{WRAPPER}} .rs-portfolio-style2 .portfolio-item .p-icon .btn_icon_1:hover svg path' => 'fill: {{VALUE}};',
							],
							'condition' => ['portfolio_slider_style' => '2']
						]
					);
				$this->end_controls_tab();
			$this->end_controls_tabs();
		$this->end_controls_section();
		// Button Style End

		// Button Style 7 Start
		$this->start_controls_section(
			'btn_style7',
			[
				'label' => esc_html__('Button Style', 'rsaddon'),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' => [
					'btn__show_hide' => 'yes',
					'portfolio_slider_style' => '7'
				],
			]
		);
			// Btn Wrapper
			$this->add_control(
				'btn_wrapper_ctrl_heading_style7',
				[
					'label' => esc_html__( 'Wrapper Options', 'rsaddon' ),
					'type' => Controls_Manager::HEADING,
					'classes' => 'rs-control-type-heading',
				]
			);
			$this->add_responsive_control(
                'btn_wrapper_v_align_style7',
                [
                    'label' => esc_html__( 'Vertical Align', 'rsaddon' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'flex-start' => [
                            'title' => esc_html__( 'Top', 'rsaddon' ),
                            'icon' => 'eicon-align-start-v',
                        ],
                        'center' => [
                            'title' => esc_html__( 'Middle', 'rsaddon' ),
                            'icon' => 'eicon-align-center-v',
                        ],
                        'flex-end' => [
                            'title' => esc_html__( 'Bottom', 'rsaddon' ),
                            'icon' => 'eicon-align-end-v',
                        ],
                    ],
                    'toggle' => true,
                    'selectors' => [
                        '{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style7 .rs-addon-sliders .portfolio-item .btn-wrapper' => 'align-items: {{VALUE}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'btn_wrapper_column_align_style7',
                [
                    'label' => esc_html__( 'Column Direction', 'rsaddon' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'row' => [
                            'title' => esc_html__( 'Row', 'rsaddon' ),
                            'icon' => 'eicon-justify-start-h',
                        ],
                        'row-reverse' => [
                            'title' => esc_html__( 'Row Reverse', 'rsaddon' ),
                            'icon' => 'eicon-wrap',
                        ],
                        'column' => [
                            'title' => esc_html__( 'Column', 'rsaddon' ),
                            'icon' => 'eicon-justify-start-v',
                        ],
                        'column-reverse' => [
                            'title' => esc_html__( 'Column Reverse', 'rsaddon' ),
                            'icon' => 'eicon-wrap',
                        ],
                    ],
                    'toggle' => true,
                    'selectors' => [
                        '{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style7 .rs-addon-sliders .portfolio-item .btn-wrapper' => 'flex-direction: {{VALUE}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'btn_wrapper_h_align_style7',
                [
                    'label' => esc_html__( 'Horizontal Align', 'rsaddon' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'flex-start' => [
                            'title' => esc_html__( 'Start', 'rsaddon' ),
                            'icon' => 'eicon-align-start-h',
                        ],
                        'center' => [
                            'title' => esc_html__( 'Center', 'rsaddon' ),
                            'icon' => 'eicon-align-center-h',
                        ],
                        'flex-end' => [
                            'title' => esc_html__( 'End', 'rsaddon' ),
                            'icon' => 'eicon-align-end-h',
                        ],
                        'space-between' => [
                            'title' => esc_html__( 'Space Between', 'rsaddon' ),
                            'icon' => 'eicon-justify-space-between-h',
                        ],

                    ],
                    'toggle' => true,
                    'selectors' => [
                        '{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style7 .rs-addon-sliders .portfolio-item .btn-wrapper' => 'justify-content: {{VALUE}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'btn_wrapper_flex_wrap_style7',
                [
                    'label' => esc_html__( 'Flex Wrap', 'rsaddon' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'nowrap' => [
                            'title' => esc_html__( 'No Wrap', 'rsaddon' ),
                            'icon' => 'eicon-nowrap',
                        ],
                        'wrap' => [
                            'title' => esc_html__( 'Wrap', 'rsaddon' ),
                            'icon' => 'eicon-wrap',
                        ],
                    ],
                    'toggle' => true,
                    'selectors' => [
                        '{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style7 .rs-addon-sliders .portfolio-item .btn-wrapper' => 'flex-wrap: {{VALUE}};',
                    ],
                ]
            );
			$this->add_responsive_control(
				'btn_wrapper_width_style7',
				[
					'label' => esc_html__( 'Width', 'rsaddon' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'custom' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 1000
						],
						'%' => [
							'min' => 0,
							'max' => 100
						],
					],
					'selectors' => [
						'{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style7 .rs-addon-sliders .portfolio-item .btn-wrapper' => 'width: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'btn_wrapper_height_style7',
				[
					'label' => esc_html__( 'Height', 'rsaddon' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'custom' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 1000
						],
						'%' => [
							'min' => 0,
							'max' => 100
						],
					],
					'selectors' => [
						'{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style7 .rs-addon-sliders .portfolio-item .btn-wrapper' => 'height: {{SIZE}}{{UNIT}};',
					],
				]
			);

			// Btn Image
			$this->add_control(
				'btn_img_ctrl_heading_style7',
				[
					'label' => esc_html__( 'Image Options', 'rsaddon' ),
					'type' => Controls_Manager::HEADING,
					'classes' => 'rs-control-type-heading',
					'separator' => 'before',
				]
			);
			$this->add_responsive_control(
				'btn_img_object_fit_style7',
				[
					'label' => esc_html__( 'Image/Object Fit', 'rsaddon' ),
					'type' => Controls_Manager::SELECT,
					'default' => 'cover',
					'options' => [
						'' => esc_html__( 'Default', 'rsaddon' ),
						'cover' => esc_html__( 'Cover', 'rsaddon' ),
						'contain' => esc_html__( 'Contain', 'rsaddon' ),
						'fill' => esc_html__( 'Fill', 'rsaddon' ),
						'scale-down' => esc_html__( 'Scale-Down', 'rsaddon' ),
						'unset' => esc_html__( 'Unset', 'rsaddon' ),
					],
					'selectors' => [
						'{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style7 .rs-addon-sliders .portfolio-item .btn-wrapper .btn-img img' => 'object-fit: {{VALUE}};',
					]
				]
			);
			$this->add_responsive_control(
				'btn_img_object_position_style7',
				[
					'label' => esc_html__( 'Image/Object Position', 'rsaddon' ),
					'type' => Controls_Manager::SELECT,
					'default' => '',
					'options' => [
						'' => esc_html__( 'Default', 'rsaddon' ),
						'center center' => esc_html__( 'Center Center', 'rsaddon' ),
						'center left' => esc_html__( 'Center Left', 'rsaddon' ),
						'center right' => esc_html__( 'Center Right', 'rsaddon' ),
						'top center' => esc_html__( 'Top Center', 'rsaddon' ),
						'top left' => esc_html__( 'Top Left', 'rsaddon' ),
						'top right' => esc_html__( 'Top Right', 'rsaddon' ),
						'bottom center' => esc_html__( 'Bottom Center', 'rsaddon' ),
						'bottom left' => esc_html__( 'Bottom Left', 'rsaddon' ),
						'bottom right' => esc_html__( 'Bottom Right', 'rsaddon' ),
						'initial' => esc_html__( 'Custom', 'rsaddon' ),
					],
					'selectors' => [
						'{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style7 .rs-addon-sliders .portfolio-item .btn-wrapper .btn-img img' => 'object-position: {{VALUE}};',
					],
					'condition' => [
						'btn_img_object_fit_style7!' => ['unset', '']
					],
				]
			);
			$this->add_responsive_control(
				'btn_img_object_position_x_style7',
				[
					'label' => esc_html__( 'Position X', 'rsaddon' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'vh', 'custom' ],
					'range' => [
						'px' => [
							'min' => -1000,
							'max' => 1000,
						],
						'%' => [
							'min' => -100,
							'max' => 100,
						],
						'vh' => [
							'min' => -100,
							'max' => 100,
						],
					],
					'default' => [
						'size' => 0,
					],
					'selectors' => [
						'{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style7 .rs-addon-sliders .portfolio-item .btn-wrapper .btn-img img' => 'object-position: {{SIZE}}{{UNIT}} {{btn_img_object_position_y_style7.SIZE}}{{btn_img_object_position_y_style7.UNIT}};',
					],
					'condition' => [
						'btn_img_object_fit_style7!' => ['unset', ''],
						'btn_img_object_position_style7' => 'initial'
					],
				]
			);
			$this->add_responsive_control(
				'btn_img_object_position_y_style7',
				[
					'label' => esc_html__( 'Position Y', 'rsaddon' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'vh', 'custom' ],
					'range' => [
						'px' => [
							'min' => -1000,
							'max' => 1000,
						],
						'%' => [
							'min' => -100,
							'max' => 100,
						],
						'vh' => [
							'min' => -100,
							'max' => 100,
						],
					],
					'default' => [
						'size' => 0,
					],
					'selectors' => [
						'{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style7 .rs-addon-sliders .portfolio-item .btn-wrapper .btn-img img' => 'object-position: {{btn_img_object_position_x_style7.SIZE}}{{btn_img_object_position_x_style7.UNIT}} {{SIZE}}{{UNIT}};',
					],
					'condition' => [
						'btn_img_object_fit_style7!' => ['unset', ''],
						'btn_img_object_position_style7' => 'initial'
					],
				]
			);
			$this->add_responsive_control(
				'btn_img_margin_style7',
				[
					'label' => esc_html__( 'Margin', 'rsaddon' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style7 .rs-addon-sliders .portfolio-item .btn-wrapper .btn-img' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'btn_img_radius_style7',
				[
					'label' => esc_html__( 'Border Radius', 'rsaddon' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style7 .rs-addon-sliders .portfolio-item .btn-wrapper .btn-img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name' => 'btn_img_border_style7',
					'selector' => '{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style7 .rs-addon-sliders .portfolio-item .btn-wrapper .btn-img',
				]
			);
			$this->add_responsive_control(
				'btn_img_width_style7',
				[
					'label' => esc_html__( 'Width', 'rsaddon' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'custom' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 1000
						],
						'%' => [
							'min' => 0,
							'max' => 100
						],
					],
					'selectors' => [
						'{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style7 .rs-addon-sliders .portfolio-item .btn-wrapper .btn-img' => 'width: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'btn_img_height_style7',
				[
					'label' => esc_html__( 'Height', 'rsaddon' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'custom' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 1000
						],
						'%' => [
							'min' => 0,
							'max' => 100
						],
					],
					'selectors' => [
						'{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style7 .rs-addon-sliders .portfolio-item .btn-wrapper .btn-img' => 'height: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'btn_img_grayscale_style7',
				[
					'label' => esc_html__( 'Grayscale', 'rsaddon' ),
					'type' => Controls_Manager::SLIDER,
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 1,
							'step' => 0.01,
						]
					],
					'selectors' => [
						'{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style7 .rs-addon-sliders .portfolio-item .btn-wrapper .btn-img img' => 'filter: grayscale({{SIZE}});',
					],
				]
			);

			// Btn Control
			$this->add_control(
				'btn_ctrl_heading_style7',
				[
					'label' => esc_html__( 'Button Options', 'rsaddon' ),
					'type' => Controls_Manager::HEADING,
					'classes' => 'rs-control-type-heading',
					'separator' => 'before',
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' => 'btn_typography_style7',
					'selector' => '{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style7 .rs-addon-sliders .portfolio-item .btn-wrapper a',
				]
			);
			$this->add_control(
				'btn_text_color_style7',
				[
					'label' => esc_html__( 'Text Color', 'rsaddon' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style7 .rs-addon-sliders .portfolio-item .btn-wrapper a' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name' => 'btn_background_style7',
					'types' => [ 'classic', 'gradient' ],
					'selector' => '{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style7 .rs-addon-sliders .portfolio-item .btn-wrapper a',
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name' => 'btn_border_style7',
					'selector' => '{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style7 .rs-addon-sliders .portfolio-item .btn-wrapper a',
				]
			);
			$this->add_responsive_control(
				'btn_width_style7',
				[
					'label' => esc_html__( 'Width', 'rsaddon' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'custom' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 1000
						],
						'%' => [
							'min' => 0,
							'max' => 100
						],
					],
					'selectors' => [
						'{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style7 .rs-addon-sliders .portfolio-item .btn-wrapper a' => 'width: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'btn_height_style7',
				[
					'label' => esc_html__( 'Height', 'rsaddon' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'custom' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 1000
						],
						'%' => [
							'min' => 0,
							'max' => 100
						],
					],
					'selectors' => [
						'{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style7 .rs-addon-sliders .portfolio-item .btn-wrapper a' => 'height: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'btn_filter_style7',
				[
					'label' => esc_html__( 'Filter Blur', 'rsaddon' ),
					'type' => Controls_Manager::SLIDER,
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style7 .rs-addon-sliders .portfolio-item .btn-wrapper a' => 'backdrop-filter: blur({{SIZE}}px);',
					]
				]
			);
			$this->add_responsive_control(
				'btn_text_rotate_style7',
				[
					'label' => esc_html__( 'Text Rotation', 'rsaddon' ),
					'type' => Controls_Manager::SLIDER,
					'range' => [
						'px' => [
							'min' => -1000,
							'max' => 1000,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style7 .rs-addon-sliders .portfolio-item .btn-wrapper a > span' => 'transform: rotate({{SIZE}}deg);',
					]
				]
			);
			$this->add_responsive_control(
				'btn_text_rotate_hover_style7',
				[
					'label' => esc_html__( 'Text Rotation (Hover)', 'rsaddon' ),
					'type' => Controls_Manager::SLIDER,
					'range' => [
						'px' => [
							'min' => -1000,
							'max' => 1000,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style7 .rs-addon-sliders .portfolio-item .btn-wrapper a:hover > span' => 'transform: rotate({{SIZE}}deg);',
					]
				]
			);

			// Btn Icon
			$this->add_control(
				'btn_icon_heading_style7',
				[
					'label' => esc_html__( 'Icon Options', 'rsaddon' ),
					'type' => Controls_Manager::HEADING,
					'classes' => 'rs-control-type-heading',
					'separator' => 'before',
				]
			);
			$this->add_control(
				'btn_icon_color_style7',
				[
					'label' => esc_html__( 'Icon Color', 'rsaddon' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style7 .rs-addon-sliders .portfolio-item .btn-wrapper a svg path' => 'fill: {{VALUE}}',
						'{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style7 .rs-addon-sliders .portfolio-item .btn-wrapper a i' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_responsive_control(
				'btn_icon_size_style7',
				[
					'label' => esc_html__( 'Icon Size', 'rsaddon' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'custom' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 1000
						],
						'%' => [
							'min' => 0,
							'max' => 100
						],
					],
					'selectors' => [
						'{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style7 .rs-addon-sliders .portfolio-item .btn-wrapper a svg' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
						'{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style7 .rs-addon-sliders .portfolio-item .btn-wrapper a i' => 'font-size: {{SIZE}}{{UNIT}};',
					],
				]
			);
			
			// Btn Icon Position Maker Start
            $this->add_control(
                'btn_icon_position_maker_style7',
                [
                    'label' => esc_html__( 'Icon Position', 'rsaddon' ),
                    'type' => Controls_Manager::POPOVER_TOGGLE,
                    'label_off' => esc_html__( 'Default', 'rsaddon' ),
                    'label_on' => esc_html__( 'Custom', 'rsaddon' ),
                    'return_value' => 'yes',
                    'default' => 'no',
                    'separator' => 'before',
                ]
            );
            $this->start_popover();
                $this->add_responsive_control(
                    'btn_icon_position_style7',
                    [
                        'label' => esc_html__( 'Position', 'rsaddon' ),
                        'type' => Controls_Manager::SELECT,
                        'default' => '',
                        'options' => [
                            '' => esc_html__( 'Default', 'rsaddon' ),
                            'absolute' => esc_html__( 'Absolute', 'rsaddon' ),
                            'relative'  => esc_html__( 'Relative', 'rsaddon' ),
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style7 .rs-addon-sliders .portfolio-item .btn-wrapper a svg,
							{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style7 .rs-addon-sliders .portfolio-item .btn-wrapper a i' => 'position: {{VALUE}};',
                        ],
                    ]
                );
                $this->add_responsive_control(
                    'btn_icon_p_top_style7',
                    [
                        'label' => esc_html__( 'Top', 'rsaddon' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%', 'custom' ],
                        'range' => [
                            'px' => [
                                'min' => -1000,
                                'max' => 1000,
                            ],
                            '%' => [
                                'min' => -100,
                                'max' => 100,
                            ],
                        ],
                        'condition' => [
                            'btn_icon_position_style7' => ['absolute', 'relative']
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style7 .rs-addon-sliders .portfolio-item .btn-wrapper a svg,
							{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style7 .rs-addon-sliders .portfolio-item .btn-wrapper a i' => 'top: {{SIZE}}{{UNIT}};',
                        ],
                    ]
                );
                $this->add_responsive_control(
                    'btn_icon_p_right_style7',
                    [
                        'label' => esc_html__( 'Right', 'rsaddon' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%', 'custom' ],
                        'range' => [
                            'px' => [
                                'min' => -1000,
                                'max' => 1000,
                            ],
                            '%' => [
                                'min' => -100,
                                'max' => 100,
                            ],
                        ],
                        'condition' => [
                            'btn_icon_position_style7' => ['absolute', 'relative']
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style7 .rs-addon-sliders .portfolio-item .btn-wrapper a svg,
							{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style7 .rs-addon-sliders .portfolio-item .btn-wrapper a i' => 'right: {{SIZE}}{{UNIT}};',
                        ],
                    ]
                );
                $this->add_responsive_control(
                    'btn_icon_p_bottom_style7',
                    [
                        'label' => esc_html__( 'Bottom', 'rsaddon' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%', 'custom' ],
                        'range' => [
                            'px' => [
                                'min' => -1000,
                                'max' => 1000,
                            ],
                            '%' => [
                                'min' => -100,
                                'max' => 100,
                            ],
                        ],
                        'condition' => [
                            'btn_icon_position_style7' => ['absolute', 'relative']
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style7 .rs-addon-sliders .portfolio-item .btn-wrapper a svg,
							{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style7 .rs-addon-sliders .portfolio-item .btn-wrapper a i' => 'bottom: {{SIZE}}{{UNIT}};',
                        ],
                    ]
                );
                $this->add_responsive_control(
                    'btn_icon_p_left_style7',
                    [
                        'label' => esc_html__( 'Left', 'rsaddon' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%', 'custom' ],
                        'range' => [
                            'px' => [
                                'min' => -1000,
                                'max' => 1000,
                            ],
                            '%' => [
                                'min' => -100,
                                'max' => 100,
                            ],
                        ],
                        'condition' => [
                            'btn_icon_position_style7' => ['absolute', 'relative']
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style7 .rs-addon-sliders .portfolio-item .btn-wrapper a svg,
							{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style7 .rs-addon-sliders .portfolio-item .btn-wrapper a i' => 'left: {{SIZE}}{{UNIT}};',
                        ],
                    ]
                );
            $this->end_popover();
            // Btn Icon Position Maker End
		$this->end_controls_section();
		// Button Style 7 End

		// number Style 
		$this->start_controls_section(
			'section_number_style',
			[
				'label' => esc_html__('Number Style', 'prelements'),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' => [
					'number_show_hide' => 'yes',
					'portfolio_slider_style' => '2'
				]
			]
		);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' => 'number_typography',
					'label' => esc_html__('Number Typography', 'prelements'),
					'selector' => '{{WRAPPER}} .rs-portfolio-slider .portfolio-item .portfolio-content .numbering span',
				]
			);
			$this->add_control(
				'number_color',
				[
					'label' => esc_html__('Number Color', 'prelements'),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .rs-portfolio-slider .portfolio-item .portfolio-content .numbering span' => 'color: {{VALUE}};',
					],
				]
			);
			$this->add_control(
				'number_fill_stroke_color',
				[
					'label' => esc_html__('Number Stroke Fill Color', 'prelements'),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .rs-portfolio-slider .portfolio-item .portfolio-content .numbering span' => '-webkit-text-fill-color: {{VALUE}};',
					],
				]
			);
			$this->add_group_control(
				\Elementor\Group_Control_Text_Stroke::get_type(),
				[
					'name' => 'number_text_stroke',
					'selector' => '{{WRAPPER}} .rs-portfolio-slider .portfolio-item .portfolio-content .numbering span',
				]
			);
			$this->add_responsive_control(
				'number_margin',
				[
					'label' => esc_html__('Number Margin', 'prelements'),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => ['px', 'em', '%'],
					'selectors' => [
						'{{WRAPPER}} .rs-portfolio-slider .portfolio-item .portfolio-content .numbering span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
					],
				]
			);
			// Controls For Style 4
		$this->end_controls_section();

		// number Style 
		$this->start_controls_section(
			'section_thumb_arrow_style',
			[
				'label' => esc_html__('Thumb Arrow & Dot Style', 'prelements'),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' => [
					'portfolio_slider_style' => '7'
				]
			]
		);

		$this->add_control(
			'arrow_style_options',
			[
				'label' => esc_html__( 'Arrow Style', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'classes' => 'rs-control-type-heading',
			]
		);

		$this->add_control(
			'thumb_arrow_color',
			[
				'label' => esc_html__('Arrow Color', 'prelements'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style7 .rs-thumb-sl-nav .slick-arrow::before' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'thumb_arrow_font_size',
			[
				'label' => esc_html__( 'Arrow Font Size', 'rsaddon' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					]
				],
				'selectors' => [
					'{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style7 .rs-thumb-sl-nav .slick-arrow::before' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'dot_style_options',
			[
				'label' => esc_html__( 'Dot Style', 'textdomain' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
				'classes' => 'rs-control-type-heading',
			]
		);

		$this->add_control(
			'thumb_dot_color',
			[
				'label' => esc_html__('Dot Color', 'prelements'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style7 .rs-thumb-sl-nav .slick-dots li button' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'thumb_dot_font_size',
			[
				'label' => esc_html__( 'Dot Font Size', 'rsaddon' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'custom' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					]
				],
				'selectors' => [
					'{{WRAPPER}} .rs-portfolio-slider.rs-portfolio-style7 .rs-thumb-sl-nav .slick-dots li button' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);



		// Controls For Style 4
		$this->end_controls_section();
	}

	/**
	 * Render rsgallery widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render()
	{

		$settings              = $this->get_settings_for_display();
		$id					   = $this->get_id();
		$unique 			   = rand(2012, 35120);
		$slidesToShow          = !empty($settings['col_lg']) ? $settings['col_lg'] : 3;
		$autoplaySpeed         = $settings['slider_autoplay_speed'];
		$number_show_hide      = $settings['number_show_hide'];
		$interval              = $settings['slider_interval'];
		$slidesToScroll        = $settings['slides_ToScroll'];
		$slider_autoplay       = $settings['slider_autoplay'] === 'true' ? 'true' : 'false';
		$pauseOnHover          = $settings['slider_stop_on_hover'] === 'true' ? 'true' : 'false';
		$sliderDots            = $settings['slider_dots'] === 'true' ? 'true' : 'false';
		$sliderNav             = $settings['slider_nav'] === 'true' ? 'true' : 'false';
		$infinite              = $settings['slider_loop'] === 'true' ? 'true' : 'false';
		$centerMode            = $settings['slider_centerMode'] === 'true' ? 'true' : 'false';
		$fadeEffect	           = $settings['fade_effect'] === 'true' ? 'true' : 'false';
		$col_lg                = $settings['col_lg'];
		$col_md                = $settings['col_md'];
		$col_sm                = $settings['col_sm'];
		$col_xs                = $settings['col_xs'];
		$col_lg_2              = $settings['col_lg_2'];
		$slider_centers_pad_xl = !empty($settings['slider_centers_pad_xl']) ? $settings['slider_centers_pad_xl'] : '400px';
		$slider_centers_pad_lg = !empty($settings['slider_centers_pad_lg']) ? $settings['slider_centers_pad_lg'] : '250px';
		$slider_centers_pad_md = !empty($settings['slider_centers_pad_md']) ? $settings['slider_centers_pad_md'] : '100px';

		$overlay_show_hide 	   = $settings['overlay_show_hide'] ?? '';
		$clip_path 			   = ('yes' === $settings['clip_path']) ? 'clip-path-enable' : '';

		$slFor             	   = (in_array($settings['portfolio_slider_style'], ['6', '7'])) ? 'slider-for-' . $id : '';
        $slNav                 = (in_array($settings['portfolio_slider_style'], ['6', '7'])) ? 'slider-nav-' . $id : '';

		if ( is_rtl() ) {
            $rtl= 'true';
            $rtlAti = 'false';
			$dirAnti = '';
        } else {
            $rtl= 'false';
			$rtlAti = 'true';
			$dirAnti = 'rtl';
        }

		$slider_conf = compact('slidesToShow', 'autoplaySpeed', 'fadeEffect', 'interval', 'slidesToScroll', 'slider_autoplay', 'pauseOnHover', 'sliderDots', 'sliderNav', 'infinite', 'centerMode', 'col_lg', 'col_md', 'col_sm', 'col_xs', 'slider_centers_pad_xl', 'slider_centers_pad_lg', 'slider_centers_pad_md', 'col_lg_2');
?>

		<div class="rsaddon-unique-slider uni-<?php echo esc_attr($id); ?> rs-addon-slider rs-portfolio-slider rs-portfolio rs-portfolio-style<?php echo esc_attr($settings['portfolio_slider_style']); ?> slider-style-<?php echo esc_attr($settings['portfolio_slider_style']); ?>  overlay-<?php echo esc_attr($overlay_show_hide); ?> <?php echo esc_attr($clip_path); ?>">

			<div id="rsaddon-slick-slider-<?php echo esc_attr($unique); ?>" class="<?php echo esc_attr($slFor); ?> rs-addon-sliders uni-<?php echo esc_attr($unique); ?> slick-dots-<?php echo esc_attr($settings['slider_dots_style']); ?> nav-icon-<?php echo esc_attr($settings['slider_nav_icon_style']); ?>">
				<?php 
				if ('1' === $settings['portfolio_slider_style']) {
					include plugin_dir_path(__FILE__) . "/style1.php";
				} elseif ('2' === $settings['portfolio_slider_style']) {
					include plugin_dir_path(__FILE__) . "/style2.php";
				} elseif ('3' === $settings['portfolio_slider_style']) {
					include plugin_dir_path(__FILE__) . "/style3.php";
				} elseif ('4' === $settings['portfolio_slider_style']) {
					include plugin_dir_path(__FILE__) . "/style4.php";
				} elseif ('5' === $settings['portfolio_slider_style']) {
					include plugin_dir_path(__FILE__) . "/style5.php";
				} elseif ('6' === $settings['portfolio_slider_style']) {
					include plugin_dir_path(__FILE__) . "/style6.php";
				} else {
					include plugin_dir_path(__FILE__) . "/style7.php";
				}
				?>
			</div>
			<?php if (in_array($settings['portfolio_slider_style'], ['6', '7'])) { ?>
				<div class="<?php echo esc_attr($slNav); ?> rs-thumb-sl-nav nav-icon-2 slick-dots-number" dir="<?php echo esc_attr($dirAnti); ?>">
					<?php 
						$cat = $settings['portfolio_category']; 
						$select_portfolio = $settings['select_portfolio_item'];
						$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
					
						if (empty($cat)){
							$best_wp = new wp_Query(array(
								'post_type'      => 'portfolios',
								'posts_per_page' => $settings['per_page'],	
								'post__in' => $select_portfolio,						
							));	  
						} else{
							$best_wp = new wp_Query(array(
									'post_type'      => 'portfolios',
									'posts_per_page' => $settings['per_page'],
									'post__in' => $select_portfolio,				
									'tax_query'      => array(
										array(
											'taxonomy' => 'portfolios-category',
											'field'    => 'slug', //can be set to ID
											'terms'    => $cat //if field is ID you can reference by cat/term number
										),
									)
							));	  
						}
						while($best_wp->have_posts()) : $best_wp->the_post();
							$thumbnail = get_the_post_thumbnail_url();?>
							<div class="thumb-img" style="
								background: url(<?php echo esc_url($thumbnail); ?>);
							">
								<?php if (('yes' === $settings['plus_icon_show_hide']) && ('7' !== $settings['portfolio_slider_style'])) {?>
									<div class="portfolio-link">
										<a href="<?php echo esc_url($thumbnail); ?>" data-elementor-open-lightbox="yes">
											<svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
												<path d="M10 1L10 19M19 10.75L1 10.75" stroke="white" stroke-width="2" stroke-linecap="round"/>
											</svg>
										</a>
									</div>
								<?php } ?>
							</div>
						<?php endwhile;
						wp_reset_query();
					?>
				</div>
				<style>
					<?php                
						$rotate_degree = ($settings['rotate_degree']) ? $settings['rotate_degree'] : '7' ;
						for ($i = 0; $i <= 50; $i++) {
							echo ".rs-addon-sliders.uni-$unique .portfolio-item .btn-wrapper a span span:nth-child({$i}) {
								transform: rotate(" . ($i * (int)$rotate_degree) . "deg);
							}\n";
						}
					?>
				</style>
			<?php } ?>
			<div class="rsaddon-slider-conf d-none" data-conf="<?php echo htmlspecialchars(json_encode($slider_conf)); ?>"></div>
		</div>
		<script>
			jQuery(document).ready(function($) {
				jQuery('#rsaddon-slick-slider-<?php echo esc_attr($unique); ?>').each(function(index) {
					var slider_id = jQuery(this).attr('id');
					var slider_conf = jQuery.parseJSON(jQuery(this).closest('.rsaddon-unique-slider.uni-<?php echo esc_attr($id); ?>').find('.rsaddon-slider-conf').attr('data-conf'));

					if (typeof(slider_id) != 'undefined' && slider_id != '') {
						jQuery('#' + slider_id ).not('.slick-initialized').slick({
							slidesToShow: parseInt(slider_conf.col_lg),
							centerMode: (slider_conf.centerMode) == "true" ? true : false,
							dots: (slider_conf.sliderDots) == "true" ? true : false,
							arrows: (slider_conf.sliderNav) == "true" ? true : false,
							autoplay: (slider_conf.slider_autoplay) == "true" ? true : false,
							slidesToScroll: parseInt(slider_conf.slidesToScroll),
							centerPadding: slider_conf.slider_centers_pad_xl,
							autoplaySpeed: parseInt(slider_conf.autoplaySpeed),
							pauseOnHover: (slider_conf.pauseOnHover) == "true" ? true : false,
							fade: (slider_conf.fadeEffect) == "true" ? true : false,
							infinite: true,
							loop: (slider_conf.slider_loop) == "true" ? true : false,
							rtl: <?php echo esc_attr($rtl); ?>,
							<?php if (in_array($settings['portfolio_slider_style'], ['6', '7'])) { ?>
                                asNavFor: '.<?php echo esc_attr($slNav); ?>',
                            <?php } ?>
							responsive: [{
									breakpoint: 1200,
									settings: {
										slidesToShow: parseInt(slider_conf.col_md),
										slidesToScroll: 1,
									}
								},
								{
									breakpoint: 1199,
									settings: {
										slidesToShow: parseInt(slider_conf.col_lg_2),
										centerPadding: slider_conf.slider_centers_pad_xl,
									}
								},
								{
									breakpoint: 992,
									settings: {
										slidesToShow: parseInt(slider_conf.col_sm),
										slidesToScroll: 1,
										centerPadding: slider_conf.slider_centers_pad_lg,
									}
								},
								{
									breakpoint: 768,
									settings: {
										arrows: false,
										slidesToShow: parseInt(slider_conf.col_xs),
										slidesToScroll: 1,
										centerPadding: slider_conf.slider_centers_pad_md,
									}
								},
								{
									breakpoint: 600,
									settings: {
										slidesToShow: 1,
										arrows: false,
										slidesToScroll: 1,
										centerPadding: '0px',
									}
								}
							]
						});
					}
				});
				<?php 
				if ('7' === $settings['portfolio_slider_style']) { ?>
					$('.<?php echo esc_attr($slNav); ?>').on('init', function(event, slick) {
						let totalSlides = slick.slideCount;
						let $dotContainer = $('.slick-dots');
						if ($dotContainer.length) {
							$dotContainer.append(`<li class="total-slide-count"><button>/<span>${totalSlides}</span></button></li>`);
						}
					});
				<?php }
				if (in_array($settings['portfolio_slider_style'], ['6', '7'])) { ?>
					$('.<?php echo esc_attr($slNav); ?>').slick({
						slidesToScroll: 1,
						<?php if ('7' === $settings['portfolio_slider_style']) { ?>
							slidesToShow: 1,
							arrows: true,
							dots: true,
						<?php } else { ?>
							slidesToShow: 2,
							arrows: false,
							dots: false,
						<?php } ?>
						asNavFor: '.<?php echo esc_attr($slFor); ?>',
						vertical: false,
						verticalSwiping: false,
						infinite: true,
						centerMode: false,
						focusOnSelect: true,
						rtl: <?php echo esc_js( $rtlAti ); ?>,
					});
				<?php } ?>
			});
		</script>

		<?php if ('5' === $settings['portfolio_slider_style']) { ?>
			<script>
				document.addEventListener("DOMContentLoaded", function() {
					var tooltipTriggers = document.querySelectorAll(".rs-portfolio-style5 .portfolio-item");
					tooltipTriggers.forEach(function(element) {
						element.addEventListener("mousemove", myFunction);
					});
					function myFunction(e) {
						var x = e.clientX;
						var y = e.clientY;
						var tooltipTrigger = e.currentTarget;
						var tooltip = tooltipTrigger.querySelector(".rs-portfolio-style5 .portfolio-content");
						var triggerRect = tooltipTrigger.getBoundingClientRect();
						var offsetX = x - triggerRect.left;
						var offsetY = y - triggerRect.top;
						var tooltipRect = tooltip.getBoundingClientRect();
						var triggerWidth = triggerRect.width;
						var triggerHeight = triggerRect.height;
						var tooltipWidth = tooltipRect.width;
						var tooltipHeight = tooltipRect.height;
						var buffer = 200;
						var maxX = triggerWidth - tooltipWidth + buffer;
						var maxY = triggerHeight - tooltipHeight + buffer;
						var left = Math.min(Math.max(x - triggerRect.left - tooltipWidth / 2, -buffer), maxX);
						var top = Math.min(Math.max(y - triggerRect.top - tooltipHeight / 2, -buffer), maxY);
						tooltip.style.left = left + "px";
						tooltip.style.top = top + "px";
					}
				});
			</script>
		<?php } ?>
<?php
	}
	public function getCategories()
	{
		$cat_list = [];
		if (post_type_exists('portfolios')) {
			$terms = get_terms(array(
				'taxonomy'    => 'portfolios-category',
				'hide_empty'  => true
			));

			foreach ($terms as $post) {
				$cat_list[$post->slug]  = [$post->name];
			}
		}
		return $cat_list;
	}
}
