<?php 
    $cat = $settings['portfolio_category']; 
    $select_portfolio = $settings['select_portfolio_item'];
    $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;

	if(empty($cat)){
    	$best_wp = new wp_Query(array(
			'post_type'      => 'portfolios',
			'posts_per_page' => $settings['per_page'],	
			'post__in' => $select_portfolio,						
		));	  
    }   
    else{
    	$best_wp = new wp_Query(array(
				'post_type'      => 'portfolios',
				'posts_per_page' => $settings['per_page'],
				'post__in' => $select_portfolio,				
				'tax_query'      => array(
			        array(
						'taxonomy' => 'portfolios-category',
						'field'    => 'slug', //can be set to ID
						'terms'    => $cat //if field is ID you can reference by cat/term number
			        ),
			    )
		));	  
    }

	while($best_wp->have_posts()): $best_wp->the_post();			
		$cats_show = get_the_term_list( $best_wp->ID, 'portfolios-category', ' ', '<span class="separator">,</span> ');
		$desc = !empty(get_post_meta( get_the_ID(), 'custom_description', true )) ? get_post_meta( get_the_ID(), 'custom_description', true ) : '';							
	?>	

	<div class="grid-item">
		<div class="portfolio-item">
			<?php if(has_post_thumbnail()):
				$thumbnail_id = get_post_thumbnail_id();
				$thumbnail_alt = get_post_meta( $thumbnail_id, '_wp_attachment_image_alt', true );
				if ( empty( $thumbnail_alt ) ) {
					$thumbnail_alt = get_the_title( $thumbnail_id );
				}?>
                <div class="portfolio-img">
					<?php echo wp_get_attachment_image( $thumbnail_id, $settings['thumbnail_size'], false, ['alt' => $thumbnail_alt] );?>
					<?php if ('yes' == $settings['plus_icon_show_hide']) {?>
					<div class="portfolio-link">
						<a href="<?php the_permalink(); ?>">
							<svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
								<path d="M10 1L10 19M19 10.75L1 10.75" stroke="white" stroke-width="2" stroke-linecap="round"/>
							</svg>
						</a>
					</div>
					<?php } ?>
					<div class="img-overlay"></div>
                </div>
            <?php endif;?>
            <div class="portfolio-content">
            	<div class="content-details">
					<?php if('yes' == $settings['cat_show_hide']){ ?>
	            		<p class="p-category"><?php echo wp_kses_post($cats_show); ?></p>
					<?php } ?>
	            	<?php if(get_the_title()):?>
	            		<h4 class="p-title"><a href="<?php the_permalink();?>"><?php the_title();?></a></h4>
	            	<?php endif;?>
					<?php if (!empty($desc) && 'yes' == $settings['desc_show_hide']) {?>
						<div class="desc"><?php echo esc_html($desc); ?></div>
					<?php } ?>
					
	            </div>
				<?php if('yes' == $settings['btn__show_hide']){ ?>
				<div class="p-icon">
					<a href="<?php the_permalink(); ?>" class="prs_btn">
						<span>
						<?php 
							if(!empty($settings['btn__title'])) {
								echo esc_html($settings['btn__title']);
							} 
						?>
						<?php if(!empty($settings['btn__icon']['value'])) : ?>
							<em class="btn_icon_1"><?php \Elementor\Icons_Manager::render_icon( $settings['btn__icon'], [ 'aria-hidden' => 'true' ] ); ?></em>
							<em class="btn_icon_2"><?php \Elementor\Icons_Manager::render_icon( $settings['btn__icon'], [ 'aria-hidden' => 'true' ] ); ?> </em>	
						<?php endif; ?>
						</span>
					</a>                        
				</div>
			<?php } ?>
            </div>
			
        </div>
	</div>
	<?php	
	endwhile;
	wp_reset_query();  
