<?php
/**
 *
 * @since 1.0.0
 */

use Elementor\Repeater;
use Elementor\Utils;
use Elementor\Group_Control_Css_Filter;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Text_Stroke;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Image_Size;
use Elementor\Icons_Manager;

defined('ABSPATH') || die();

class Rsaddon_Elementor_pro_RS_Search_result_Widget extends \Elementor\Widget_Base
{

	/**
	 * Get widget name.
	 *
	 * Retrieve counter widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name()
	{
		return 'rs-search-result';
	}

	public function get_keywords() {
        return ['rs', 'search', 'result'];
    }

	/**
	 * Get widget title.
	 *
	 * Retrieve counter widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title()
	{
		return esc_html__('RS Search Result', 'rsaddon');
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve counter widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon()
	{
		return 'rs-badge';
	}

	/**
	 * Retrieve the list of scripts the counter widget depended on.
	 *
	 * Used to set scripts dependencies required to run the widget.
	 *
	 * @since 1.3.0
	 * @access public
	 *
	 * @return array Widget scripts dependencies.
	 */
	public function get_categories()
	{
		return ['rsaddon_category'];
	}
	/**
	 * Register widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls()
	{
		// Global Content Start
		$this->start_controls_section(
			'section_search_result',
			[
				'label' => esc_html__('Global Content', 'rsaddon'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
			$this->add_control(
				'source',
				[
					'label'   => esc_html__('Source', 'rsaddon'),
					'type'    => Controls_Manager::SELECT,
					'default' => 'repeater',
					'options' => [
						'repeater' => esc_html__( 'Repeater', 'rsaddon' ),
						'post' => esc_html__( 'Post Type', 'rsaddon' ),
					]
				]
			);
			$this->add_control(
				'post_type',
				[
					'label'   => esc_html__('Select Post Type', 'rsaddon'),
					'type'    => Controls_Manager::SELECT,
					'default' => 'post',
					'options' => RS_get_post_types(),
					'condition' => [
						'source' => 'post'
					]
				]
			);
			$this->add_control(
				'categories',
				[
					'label'   => esc_html__('Select Categories', 'rsaddon'),
					'type'    => Controls_Manager::SELECT,
					'default' => '',
					'options' => ['' => 'Select Category'] + RS_get_categories(),
					'condition' => [
						'source' => 'post'
					]
				]
			);
			$this->add_control(
				'categories_panal_notice',
				[
					'type'            => Controls_Manager::RAW_HTML,
					'raw'             => __('Select <b>category</b> accordingly with chosen <b>post type</b>.<br>e.g. (post type name) - category.', 'rsaddon'),
					'content_classes' => 'rs-panel-notice',
					'condition' => [
						'source' => 'post'
					]
				]
			);
			$this->add_control(
				'order',
				[
					'label' => esc_html__( 'Order', 'rsaddon' ),
					'type' => Controls_Manager::SELECT,
					'default' => 'DESC',
					'separator' => 'before',
					'options' => [
						'DESC'  => esc_html__( 'Descending', 'rsaddon' ),
						'ASC'  => esc_html__( 'Ascending', 'rsaddon' )
					],
					'condition' => [
						'source' => 'post'
					]
				]
			);
			$this->add_control(
				'input_placeholder_text',
				[
					'label' => esc_html__( 'Placeholder Text', 'rsaddon' ),
					'type' => Controls_Manager::TEXT,
					'label_block' => true,
					'separator' => 'before',
					'default' => esc_html__( 'Search for names..', 'rsaddon' ),
					'placeholder' => esc_html__( 'Type placeholder text here', 'rsaddon' ),
				]
			);
			$this->add_control(
				'show_btn_icon',
				[
					'label' => esc_html__( 'Show Button Icon', 'rsaddon' ),
					'type' => Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'rsaddon' ),
					'label_off' => esc_html__( 'Hide', 'rsaddon' ),
					'return_value' => 'yes',
					'default' => 'yes',
					'separator' => 'before',
				]
			);
			$this->add_control(
				'show_btn_txt',
				[
					'label' => esc_html__( 'Show Button Text', 'rsaddon' ),
					'type' => Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Show', 'rsaddon' ),
					'label_off' => esc_html__( 'Hide', 'rsaddon' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);
			$this->add_control(
				'search_btn_text',
				[
					'label' => esc_html__( 'Search Button Text', 'rsaddon' ),
					'type' => Controls_Manager::TEXT,
					'label_block' => true,
					'default' => esc_html__( 'Search Now', 'rsaddon' ),
					'placeholder' => esc_html__( 'Type search button text here', 'rsaddon' ),
					'condition' => [
						'show_btn_txt' => 'yes'
					]
				]
			);
			$this->add_control(
				'close_btn_text',
				[
					'label' => esc_html__( 'Close Button Text', 'rsaddon' ),
					'type' => Controls_Manager::TEXT,
					'label_block' => true,
					'default' => esc_html__( 'Close', 'rsaddon' ),
					'placeholder' => esc_html__( 'Type close button text here', 'rsaddon' ),
					'condition' => [
						'show_btn_txt' => 'yes'
					]
				]
			);

			$repeater = new Repeater();
				$repeater->add_control(
					'title',
					[
						'label'       => esc_html__('Search Title', 'rsaddon'),
						'type'        => Controls_Manager::TEXT,
						'label_block' => true,
						'default'     => 'Search Title',
						'placeholder' => esc_html__('Search Title', 'rsaddon'),
						'separator'   => 'before',
					]
				);
				$repeater->add_control(
					'link',
					[
						'label'       => esc_html__('Link', 'rsaddon'),
						'type'        => Controls_Manager::URL,
						'label_block' => true,
						'default' => [
							'url' => '#',
						]
					]
				);
			$this->add_control(
                'search_result',
                [
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $repeater->get_controls(),
                    'show_label' => false,
					'condition' => [
						'source' => 'repeater'
					],
                    'default' => [
                        [ 'title' => esc_html__( 'Alabama', 'rsaddon' ) ],
                        [ 'title' => esc_html__( 'California', 'rsaddon' ) ],
                        [ 'title' => esc_html__( 'Colorado', 'rsaddon' ) ],
                        [ 'title' => esc_html__( 'Florida', 'rsaddon' ) ],
                        [ 'title' => esc_html__( 'Georgia', 'rsaddon' ) ],
                        [ 'title' => esc_html__( 'Hawaii', 'rsaddon' ) ],
                        [ 'title' => esc_html__( 'Kansas', 'rsaddon' ) ],
                        [ 'title' => esc_html__( 'Nevada', 'rsaddon' ) ],
                        [ 'title' => esc_html__( 'Maryland', 'rsaddon' ) ],
                        [ 'title' => esc_html__( 'New York', 'rsaddon' ) ]
                    ],
                    'title_field' => '{{{ title }}}',
                ]
            );
		$this->end_controls_section();
		// Global Content End

		// Input Style Start
		$this->start_controls_section(
			'result_input_area_style_section',
			[
				'label' => esc_html__('Input Style', 'rsaddon'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
			$this->add_control(
				'input_text_color',
				[
					'label' => esc_html__( 'Text Color', 'rsaddon' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .rs-search-result .input-wrapper input' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'input_placeholder_color',
				[
					'label' => esc_html__( 'Placeholder Color', 'rsaddon' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .rs-search-result .input-wrapper input::placeholder' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name' => 'input_background',
					'types' => [ 'classic', 'gradient'],
					'selector' => '{{WRAPPER}} .rs-search-result .input-wrapper input',
				]
			);
			$this->add_responsive_control(
				'input_padding',
				[
					'label' => esc_html__( 'Padding', 'rsaddon' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .rs-search-result .input-wrapper input' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					]
				]
			);
			$this->add_responsive_control(
				'input_radius',
				[
					'label' => esc_html__( 'Border Radius', 'rsaddon' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .rs-search-result .input-wrapper input' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					]
				]
			);
			$this->add_responsive_control(
				'input_height',
				[
					'label' => esc_html__( 'Height', 'rsaddon' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'custom' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 1000,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .rs-search-result .input-wrapper input' => 'height: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name' => 'input_border',
					'selector' => '{{WRAPPER}} .rs-search-result .input-wrapper input',
				]
			);
			$this->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name' => 'input_box_shadow',
					'selector' => '{{WRAPPER}} .rs-search-result .input-wrapper input',
				]
			);
		$this->end_controls_section();
		// Input Style End

		// Button Style Start
		$this->start_controls_section(
			'result_input_button_style_section',
			[
				'label' => esc_html__('Button Style', 'rsaddon'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' => 'button_typography',
					'selector' => '{{WRAPPER}} .rs-search-result .input-wrapper button > *',
					'condition' => [
						'show_btn_txt' => 'yes'
					]
				]
			);
			$this->add_responsive_control(
				'button_padding',
				[
					'label' => esc_html__( 'Padding', 'rsaddon' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .rs-search-result .input-wrapper button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					]
				]
			);
			$this->add_responsive_control(
				'button_radius',
				[
					'label' => esc_html__( 'Border Radius', 'rsaddon' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .rs-search-result .input-wrapper button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					]
				]
			);
			$this->add_responsive_control(
				'button_icon_size',
				[
					'label' => esc_html__( 'Icon Size', 'rsaddon' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'custom' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 1000,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .rs-search-result .input-wrapper button > * i' => 'font-size: {{SIZE}}{{UNIT}};',
					],
					'condition' => [
						'show_btn_icon' => 'yes'
					]
				]
			);
			$this->add_responsive_control(
				'button_min_width',
				[
					'label' => esc_html__( 'Min Width', 'rsaddon' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'custom' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 1000,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .rs-search-result .input-wrapper button' => 'min-width: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'button_height',
				[
					'label' => esc_html__( 'Height', 'rsaddon' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'custom' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 1000,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .rs-search-result .input-wrapper button' => 'height: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name' => 'button_box_shadow',
					'selector' => '{{WRAPPER}} .rs-search-result .input-wrapper button',
				]
			);

			$this->start_controls_tabs(
				'button_style_tabs'
			);
				$this->start_controls_tab(
					'button_style_normal_tab',
					[
						'label' => esc_html__( 'Normal', 'rsaddon' ),
					]
				);
					$this->add_control(
						'button_color',
						[
							'label' => esc_html__( 'Color', 'rsaddon' ),
							'type' => Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .rs-search-result .input-wrapper button > *,
								{{WRAPPER}} .rs-search-result .input-wrapper button > * i' => 'color: {{VALUE}}',
							],
						]
					);
					$this->add_group_control(
						Group_Control_Background::get_type(),
						[
							'name' => 'button_background',
							'types' => [ 'classic', 'gradient'],
							'selector' => '{{WRAPPER}} .rs-search-result .input-wrapper button',
						]
					);
					$this->add_group_control(
						Group_Control_Border::get_type(),
						[
							'name' => 'button_border',
							'selector' => '{{WRAPPER}} .rs-search-result .input-wrapper button',
						]
					);
				$this->end_controls_tab();
				$this->start_controls_tab(
					'button_style_hover_tab',
					[
						'label' => esc_html__( 'Hover', 'rsaddon' ),
					]
				);
					$this->add_control(
						'button_color_hover',
						[
							'label' => esc_html__( 'Color', 'rsaddon' ),
							'type' => Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .rs-search-result .input-wrapper button:hover > *,
								{{WRAPPER}} .rs-search-result .input-wrapper button:hover > * i' => 'color: {{VALUE}}',
							],
						]
					);
					$this->add_group_control(
						Group_Control_Background::get_type(),
						[
							'name' => 'button_background_hover',
							'types' => [ 'classic', 'gradient'],
							'selector' => '{{WRAPPER}} .rs-search-result .input-wrapper button:hover',
						]
					);
					$this->add_control(
						'button_border_color_hover',
						[
							'label' => esc_html__( 'Border Color', 'rsaddon' ),
							'type' => Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .rs-search-result .input-wrapper button:hover' => 'border-color: {{VALUE}}',
							],
						]
					);
				$this->end_controls_tab();
			$this->end_controls_tabs();

			// Button Position Maker Start
            $this->add_control(
                'button_position_maker',
                [
                    'label' => esc_html__( 'Position Maker', 'rsaddon' ),
                    'type' => Controls_Manager::POPOVER_TOGGLE,
                    'label_off' => esc_html__( 'Default', 'rsaddon' ),
                    'label_on' => esc_html__( 'Custom', 'rsaddon' ),
                    'return_value' => 'yes',
                    'default' => 'no',
                    'separator' => 'before',
                ]
            );
            
            $this->start_popover();
                $this->add_responsive_control(
                    'button_position',
                    [
                        'label' => esc_html__( 'Position', 'rsaddon' ),
                        'type' => Controls_Manager::SELECT,
                        'default' => '',
                        'options' => [
                            '' => esc_html__( 'Default', 'rsaddon' ),
                            'absolute' => esc_html__( 'Absolute', 'rsaddon' ),
                            'relative'  => esc_html__( 'Relative', 'rsaddon' ),
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .rs-search-result .input-wrapper button' => 'position: {{VALUE}};',
                        ],
                    ]
                );
                $this->add_responsive_control(
                    'button_p_top',
                    [
                        'label' => esc_html__( 'Top', 'rsaddon' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%', 'custom' ],
                        'range' => [
                            'px' => [
                                'min' => -1000,
                                'max' => 1000,
                            ],
                            '%' => [
                                'min' => -100,
                                'max' => 100,
                            ],
                        ],
                        'condition' => [
                            'button_position' => ['absolute', 'relative']
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .rs-search-result .input-wrapper button' => 'top: {{SIZE}}{{UNIT}};',
                        ],
                    ]
                );
                $this->add_responsive_control(
                    'button_p_right',
                    [
                        'label' => esc_html__( 'Right', 'rsaddon' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%', 'custom' ],
                        'range' => [
                            'px' => [
                                'min' => -1000,
                                'max' => 1000,
                            ],
                            '%' => [
                                'min' => -100,
                                'max' => 100,
                            ],
                        ],
                        'condition' => [
                            'button_position' => ['absolute', 'relative']
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .rs-search-result .input-wrapper button' => 'right: {{SIZE}}{{UNIT}};',
                        ],
                    ]
                );
                $this->add_responsive_control(
                    'button_p_bottom',
                    [
                        'label' => esc_html__( 'Bottom', 'rsaddon' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%', 'custom' ],
                        'range' => [
                            'px' => [
                                'min' => -1000,
                                'max' => 1000,
                            ],
                            '%' => [
                                'min' => -100,
                                'max' => 100,
                            ],
                        ],
                        'condition' => [
                            'button_position' => ['absolute', 'relative']
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .rs-search-result .input-wrapper button' => 'bottom: {{SIZE}}{{UNIT}};',
                        ],
                    ]
                );
                $this->add_responsive_control(
                    'button_p_left',
                    [
                        'label' => esc_html__( 'Left', 'rsaddon' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%', 'custom' ],
                        'range' => [
                            'px' => [
                                'min' => -1000,
                                'max' => 1000,
                            ],
                            '%' => [
                                'min' => -100,
                                'max' => 100,
                            ],
                        ],
                        'condition' => [
                            'button_position' => ['absolute', 'relative']
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .rs-search-result .input-wrapper button' => 'left: {{SIZE}}{{UNIT}};',
                        ],
                    ]
                );
            $this->end_popover();
            // Button Position Maker End
		$this->end_controls_section();
		// Button Style End

		// Result Area Style Start
		$this->start_controls_section(
			'result_area_style_section',
			[
				'label' => esc_html__('Result Area Style', 'rsaddon'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
			$this->add_responsive_control(
				'result_area_padding',
				[
					'label' => esc_html__( 'Padding', 'rsaddon' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .rs-search-result .search-result-wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					]
				]
			);
			$this->add_responsive_control(
				'result_area_radius',
				[
					'label' => esc_html__( 'Border Radius', 'rsaddon' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .rs-search-result .search-result-wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					]
				]
			);
			$this->add_responsive_control(
				'result_area_min_height',
				[
					'label' => esc_html__( 'Min Height', 'rsaddon' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'custom' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 1000,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .rs-search-result .search-result-wrapper ul.search-result-ul' => 'min-height: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name' => 'result_area_background',
					'types' => [ 'classic', 'gradient' ],
					'selector' => '{{WRAPPER}} .rs-search-result .search-result-wrapper',
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name' => 'result_area_border',
					'selector' => '{{WRAPPER}} .rs-search-result .search-result-wrapper',
				]
			);
			$this->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name' => 'result_area_box_shadow',
					'selector' => '{{WRAPPER}} .rs-search-result .search-result-wrapper',
				]
			);

			// Items Control
			$this->add_control(
				'result_item_options_heading',
				[
					'label' => esc_html__( 'Items Options', 'rsaddon' ),
					'type' => Controls_Manager::HEADING,
					'classes' => 'rs-control-type-heading',
					'separator' => 'before',
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' => 'result_item_typography',
					'selector' => '{{WRAPPER}} .rs-search-result .search-result-wrapper ul.search-result-ul li a',
				]
			);
			$this->add_responsive_control(
				'result_item_margin',
				[
					'label' => esc_html__( 'Margin', 'rsaddon' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .rs-search-result .search-result-wrapper ul.search-result-ul li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					]
				]
			);
			$this->add_responsive_control(
				'result_item_padding',
				[
					'label' => esc_html__( 'Padding', 'rsaddon' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .rs-search-result .search-result-wrapper ul.search-result-ul li a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					]
				]
			);
			$this->add_responsive_control(
				'result_item_radius',
				[
					'label' => esc_html__( 'Border Radius', 'rsaddon' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .rs-search-result .search-result-wrapper ul.search-result-ul li a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					]
				]
			);
			$this->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name' => 'result_item_box_shadow',
					'selector' => '{{WRAPPER}} .rs-search-result .search-result-wrapper ul.search-result-ul li a',
				]
			);
			$this->start_controls_tabs(
				'result_item_style_tabs'
			);
				$this->start_controls_tab(
					'result_item_style_normal_tab',
					[
						'label' => esc_html__( 'Normal', 'rsaddon' ),
					]
				);
					$this->add_control(
						'result_item_color',
						[
							'label' => esc_html__( 'Color', 'rsaddon' ),
							'type' => Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .rs-search-result .search-result-wrapper ul.search-result-ul li a,
								{{WRAPPER}} .rs-search-result .search-result-wrapper ul.search-result-ul li a:after' => 'color: {{VALUE}}',
							],
						]
					);
					$this->add_group_control(
						Group_Control_Background::get_type(),
						[
							'name' => 'result_item_background',
							'types' => [ 'classic', 'gradient' ],
							'selector' => '{{WRAPPER}} .rs-search-result .search-result-wrapper ul.search-result-ul li a',
						]
					);
					$this->add_group_control(
						Group_Control_Border::get_type(),
						[
							'name' => 'result_item_border',
							'selector' => '{{WRAPPER}} .rs-search-result .search-result-wrapper ul.search-result-ul li a',
						]
					);
				$this->end_controls_tab();

				$this->start_controls_tab(
					'result_item_style_hover_tab',
					[
						'label' => esc_html__( 'Hover', 'rsaddon' ),
					]
				);
					$this->add_control(
						'result_item_color_hover',
						[
							'label' => esc_html__( 'Color', 'rsaddon' ),
							'type' => Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .rs-search-result .search-result-wrapper ul.search-result-ul li a:hover,
								{{WRAPPER}} .rs-search-result .search-result-wrapper ul.search-result-ul li a:hover:after' => 'color: {{VALUE}}',
							],
						]
					);
					$this->add_group_control(
						Group_Control_Background::get_type(),
						[
							'name' => 'result_item_background_hover',
							'types' => [ 'classic', 'gradient' ],
							'selector' => '{{WRAPPER}} .rs-search-result .search-result-wrapper ul.search-result-ul li a:hover',
						]
					);
					$this->add_control(
						'result_item_border_color_hover',
						[
							'label' => esc_html__( 'Border Color', 'rsaddon' ),
							'type' => Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .rs-search-result .search-result-wrapper ul.search-result-ul li a:hover' => 'border-color: {{VALUE}}',
							],
						]
					);
				$this->end_controls_tab();
			$this->end_controls_tabs();
		$this->end_controls_section();
		// Result Area Style End

		// Scrollbar Style Start
		$this->start_controls_section(
			'scrollbar_style_section',
			[
				'label' => esc_html__('Scrollbar Style', 'rsaddon'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
			$this->add_responsive_control(
				'scrollbar_gap_right',
				[
					'label' => esc_html__( 'Right Gap', 'rsaddon' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'custom' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 1000,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .rs-search-result .search-result-wrapper ul.search-result-ul' => 'padding-right: {{SIZE}}{{UNIT}};',
					],
				]
			);
			// Track
			$this->add_control(
				'scrollable_scrollbar_track',
				[
					'label' => esc_html__( 'Scrollbar Track', 'rsaddon' ),
					'type' => Controls_Manager::HEADING,
					'classes' => 'rs-control-type-heading',
					'separator' => 'before',
				]
			);
			$this->add_control(
				'scrollable_scrollbar_track_color',
				[
					'label' => esc_html__( 'Track Bg', 'rsaddon' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .rs-search-result .search-result-wrapper ul.search-result-ul::-webkit-scrollbar-track' => 'background-color: {{VALUE}}',
					],
				]
			);
			$this->add_responsive_control(
				'scrollable_scrollbar_track_width',
				[
					'label' => esc_html__( 'Track Width', 'rsaddon' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'custom' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 1000,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .rs-search-result .search-result-wrapper ul.search-result-ul::-webkit-scrollbar' => 'width: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control (
				'scrollable_scrollbar_radius',
				[
					'label' => esc_html__( 'Border Radius', 'rsaddon' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .rs-search-result .search-result-wrapper ul.search-result-ul::-webkit-scrollbar,
						{{WRAPPER}} .rs-search-result .search-result-wrapper ul.search-result-ul::-webkit-scrollbar-track,
						{{WRAPPER}} .rs-search-result .search-result-wrapper ul.search-result-ul::-webkit-scrollbar-thumb' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			// Thumb
			$this->add_control(
				'scrollable_scrollthumb',
				[
					'label' => esc_html__( 'Scroll Thumb', 'rsaddon' ),
					'type' => Controls_Manager::HEADING,
					'classes' => 'rs-control-type-heading',
					'separator' => 'before',
				]
			);
			$this->add_control(
				'scrollable_scrollthumb_color',
				[
					'label' => esc_html__( 'Thumb Color', 'rsaddon' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .rs-search-result .search-result-wrapper ul.search-result-ul::-webkit-scrollbar-thumb' => 'background-color: {{VALUE}}',
					],
				]
			);
		$this->end_controls_section();
		// Scrollbar Style Emd
	}

	/**
	 * Render counter widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	/**
	 * Render counter widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */

	protected function render()
	{
		$settings = $this->get_settings_for_display();
		$unique = rand(2012, 3554120);
		$order = $settings['order'];
		$postype = $settings['post_type'];

		if (in_array($postype, ['portfolios', 'teams', 'services', 'events', 'careers'])) {
			$taxonomyName = $postype . '-category';
		} elseif ('post' == $postype) {
			$taxonomyName = 'category';
		} else {
			$taxonomyName = $postype;
		}

		$categories = $settings['categories'];

		if (!empty($categories)) {
			$terms = array(
				array(
					'taxonomy' => $taxonomyName,
					'field'    => 'slug', 
					'terms'    => $categories
				)
			);
		} else {
			$terms = '';
		}

		$custom_query = new WP_Query( 
			array(
				'post_type'   => $postype,
				'post_status' => 'publish',
				'order'       => $order,
				'tax_query'   => $terms,
			)
		);
	?>
		<div class="rs-search-result">
			<div class="input-wrapper">
				<input type="text" id="search-result-input-<?php echo esc_attr( $unique ); ?>" placeholder="<?php echo esc_html($settings['input_placeholder_text']); ?>">
				<button id="close-<?php echo esc_attr( $unique ); ?>" type="button">
					<span>
						<?php if ('yes' === $settings['show_btn_txt']){
							echo esc_html( $settings['search_btn_text'] );
						}
						if ('yes' === $settings['show_btn_icon']){ ?>
							<i class="ri-search-line"></i>
						<?php } ?>
					</span>
					<span>
						<?php if ('yes' === $settings['show_btn_txt']){
							echo esc_html( $settings['close_btn_text'] );
						}
						if ('yes' === $settings['show_btn_icon']){ ?>
							<i class="ri-close-line"></i>
						<?php } ?>
					</span>
				</button>
			</div>
			<div id="swrapper-<?php echo esc_attr( $unique ); ?>" class="search-result-wrapper">
				<ul id="search-result-ul-<?php echo esc_attr( $unique ); ?>" class="search-result-ul" data-lenis-prevent>
					<?php if ('post' == $settings['source']) { ?>
						<?php while($custom_query->have_posts()) : $custom_query->the_post(); ?>
							<li class="result-item">
								<?php if (get_the_title()) { ?>
									<a href="<?php echo the_permalink( ); ?>"><?php echo get_the_title(); ?></a>
								<?php } ?>
							<li>
						<?php endwhile;
						wp_reset_postdata(); ?>
					<?php } else { ?> 
						<?php foreach ($settings['search_result'] as $index => $item) :
							$link = !empty($item['link']['url']) ? $item['link']['url'] : '#';
							$target = $item['link']['is_external'] ? 'target=_blank' : '';
						?>
							<li class="result-item">
								<?php echo $num; ?>
								<a href="<?php echo esc_url($item['link']['url']); ?>" <?php echo esc_attr($target); ?>><?php echo wp_kses_post($item['title']); ?></a>
							</li>
						<?php endforeach;
					} ?>
				</ul>
			</div>
		</div>

		<script>
			jQuery(document).ready(function($) {
				if ($('.rs-search-result').length) {
					var searchInput = $('#search-result-input-<?php echo esc_attr( $unique ); ?>');
					var searchResults = $('#search-result-ul-<?php echo esc_attr( $unique ); ?>');
					var closeButton = $('#close-<?php echo esc_attr( $unique ); ?>');
					var swrapper = $('#swrapper-<?php echo esc_attr( $unique ); ?>');
					if (searchInput.length && searchResults.length && closeButton.length && swrapper.length) {
						searchInput.on('keyup', function() {
							var filter = this.value.toUpperCase();
							searchResults.find('li').each(function() {
								var link = $(this).find('a').first();
								var txtValue = link.text() || link.html() || '';
								$(this).toggle(txtValue.toUpperCase().indexOf(filter) > -1);
							});
						});
						searchInput.on('click', function() {
							swrapper.toggleClass('active');
							closeButton.toggleClass('active');
						});
						closeButton.on('click', function() {
							$(this).toggleClass('active');
							swrapper.toggleClass('active');
						});
					}
				}
			});
		</script>
<?php
	}
}
