<?php
/**
 * Elementor rsgallery Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */

use Elementor\Repeater;
use Elementor\Utils;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Text_Stroke;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;
use Elementor\Icons_Manager;


defined('ABSPATH') || die();

class Rsaddon_Service_Expand_Effect_Widget extends \Elementor\Widget_Base
{

	/**
	 * Get widget name.
	 *
	 * Retrieve rsgallery widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name()
	{
		return 'rs-service-expand-effect';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve rsgallery widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title()
	{
		return __('RS Services Expand', 'rsaddon');
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve rsgallery widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon()
	{
		return 'rs-badge';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the rsgallery widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories()
	{
		return ['rsaddon_category'];
	}

	/**
	 * Register rsgallery widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls()
	{

		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__('Content', 'rsaddon'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
			$this->add_control(
				'service_style',
				[
					'label' => esc_html__( 'Style', 'rsaddon' ),
					'type' => Controls_Manager::SELECT,
					'default' => 'style1',
					'options' => [
						'style1' => esc_html__( 'Style 1', 'rsaddon' ),
						'style2' => esc_html__( 'Style 2', 'rsaddon' )
					]
				]
			);
			$this->add_responsive_control(
				'item_height',
				[
					'label' => esc_html__('Item Height', 'rsaddon'),
					'type' => Controls_Manager::SLIDER,
					'size_units' => ['px', '%', 'custom'],
					'range' => [
						'px' => [
							'min' => 10,
							'max' => 1000,
						],
						'%' => [
							'min' => 10,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex.style1 .grid-item .service-inner,
						{{WRAPPER}} .rs-service-flex.style2 .thumbnail-part-wrapper' => 'min-height: {{SIZE}}{{UNIT}};',
					],
				]
			);

			$this->add_control(
				'show_icon',
				[
					'label'        => esc_html__('Show Icon', 'rsaddon'),
					'type'         => Controls_Manager::SWITCHER,
					'label_on'     => esc_html__('Show', 'rsaddon'),
					'label_off'    => esc_html__('Hide', 'rsaddon'),
					'return_value' => 'yes',
					'default'      => 'yes',
				]
			);

			$this->add_control(
				'show_count_number',
				[
					'label'        => esc_html__('Show Count Number', 'rsaddon'),
					'type'         => Controls_Manager::SWITCHER,
					'label_on'     => esc_html__('Show', 'rsaddon'),
					'label_off'    => esc_html__('Hide', 'rsaddon'),
					'return_value' => 'yes',
					'default'      => 'yes',
				]
			);
			$this->add_control(
				'button_show_hide',
				[
					'label' => esc_html__('Button Show/Hide', 'rsaddon'),
					'type' => Controls_Manager::SWITCHER,
					'label_on' => esc_html__('Show', 'rsaddon'),
					'label_off' => esc_html__('Hide', 'rsaddon'),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);
			$this->add_control(
				'btn__selected_icon',
				[
					'label' => __('Icon', 'rsaddon'),
					'type' => Controls_Manager::ICONS,
					'default' => [
						'value' => 'fas fa-chevron-right',
						'library' => 'fa-solid',
					]
				]
			);
			$this->add_control(
				'btn_text',
				[
					'label' => esc_html__( 'Button Text', 'rsaddon' ),
					'type' => Controls_Manager::TEXT,
					'default' => esc_html__( 'Learn More', 'rsaddon' ),
					'placeholder' => esc_html__( 'Button text here', 'rsaddon' ),
					'condition' => ['button_show_hide' => 'yes']
				]
			);
			$repeater = new Repeater();
				$repeater->add_control(
					'link',
					[
						'label'       => esc_html__('Link', 'rsaddon'),
						'type'        => Controls_Manager::URL,
						'label_block' => true,
						'default' => [
							'url' => '#',
						]
					]
				);
				$repeater->add_control(
					'feature_img',
					[
						'label' => esc_html__('Feature Image Bg', 'rsaddon'),
						'type' => Controls_Manager::MEDIA,
						'default' => [
							'url' => Utils::get_placeholder_image_src(),
						],
					]
				);

				$repeater->add_control(
					'service_expand_icon',
					[
						'label' => __('Icon', 'rsaddon'),
						'type' => Controls_Manager::ICONS,
						'default' => [
							'value' => 'fas fa-laptop-house',
							'library' => 'fa-ragular',
						]
					]
				);
				$repeater->add_control(
					'title',
					[
						'label'       => esc_html__('Title', 'rsaddon'),
						'type'        => Controls_Manager::TEXT,
						'label_block' => true,
						'default'     => 'Services Title',
						'placeholder' => esc_html__('Services Title', 'rsaddon'),
						'separator'   => 'before',
					]
				);
				$repeater->add_control(
					'description',
					[
						'label' => esc_html__('Description', 'rsaddon'),
						'type' => Controls_Manager::TEXTAREA,
						'label_block' => true,
						'default' => esc_html__('Quisque placerat vitae lacus ut scelerisque. Fusce luctus odio ac nibh luctus, in porttitor theo lacus egestas. Dummy text generator.', 'rsaddon'),
						'separator' => 'before',
					]
				);
				$repeater->add_control(
					'number',
					[
						'label'       => esc_html__('Number', 'rsaddon'),
						'type'        => Controls_Manager::TEXT,
						'label_block' => true,
						'default'     => '01',
						'placeholder' => esc_html__('01', 'rsaddon'),
						'separator'   => 'before',
					]
				);
				$repeater->add_control(
					'active_item',
					[
						'label'        => esc_html__('Active this item', 'rsaddon'),
						'type'         => Controls_Manager::SWITCHER,
						'label_on'     => esc_html__('Yes', 'rsaddon'),
						'label_off'    => esc_html__('No', 'rsaddon'),
						'return_value' => 'yes',
						'default'      => 'no',
					]
				);
			$this->add_control(
				'services_list',
				[
					'type' => Controls_Manager::REPEATER,
					'fields' => $repeater->get_controls(),
					'show_label' => false,
					'default' => [
						[
							'title' => esc_html__( 'Service One', 'rsaddon' ),
							'active_item' => 'no'
						],
						[
							'title' => esc_html__( 'Service Two', 'rsaddon' ),
							'active_item' => 'no'
						],
						[
							'title' => esc_html__( 'Service Three', 'rsaddon' ),
							'active_item' => 'yes'
						],
						[
							'title' => esc_html__( 'Service Three', 'rsaddon' ),
							'active_item' => 'no'
						]
					],
					'title_field' => '{{{ title }}}',
				]
			);
		$this->end_controls_section();

		// Grid Control Start
		$this->start_controls_section(
			'content_grid_control_section',
			[
				'label' => esc_html__('Grid Control', 'rsaddon'),
				'tab' => Controls_Manager::TAB_CONTENT,
				'condition' => [
					'service_style!' => 'style2'
				]
			]
		);
			$this->add_control(
				'column_lg',
				[
					'label'   => esc_html__('Column LG Device', 'rsaddon'),
					'type'    => Controls_Manager::SELECT,
					'default' => '3',
					'options' => [
						'12' => esc_html__('Column 1', 'rsaddon'),
						'6' => esc_html__('Column 2', 'rsaddon'),
						'4' => esc_html__('Column 3', 'rsaddon'),
						'3' => esc_html__('Column 4', 'rsaddon'),
					]
				]
			);
			$this->add_control(
				'column_md',
				[
					'label'   => esc_html__('Column MD Device', 'rsaddon'),
					'type'    => Controls_Manager::SELECT,
					'default' => '6',
					'options' => [
						'12' => esc_html__('Column 1', 'rsaddon'),
						'6' => esc_html__('Column 2', 'rsaddon'),
						'4' => esc_html__('Column 3', 'rsaddon'),
						'3' => esc_html__('Column 4', 'rsaddon'),
					]
				]
			);
			$this->add_control(
				'column_sm',
				[
					'label'   => esc_html__('Column SM Device', 'rsaddon'),
					'type'    => Controls_Manager::SELECT,
					'default' => '6',
					'options' => [
						'12' => esc_html__('Column 1', 'rsaddon'),
						'6' => esc_html__('Column 2', 'rsaddon'),
						'4' => esc_html__('Column 3', 'rsaddon'),
						'3' => esc_html__('Column 4', 'rsaddon'),
					]
				]
			);

			$this->add_responsive_control(
				'column_padding',
				[
					'label' => esc_html__( 'Column Padding', 'rsaddon' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex .grid-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'column_margin',
				[
					'label' => esc_html__( 'Column Margin', 'rsaddon' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex .grid-item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
		$this->end_controls_section();
		// Grid Control End

		// Global Style Start
		$this->start_controls_section(
			'g_style_service',
			[
				'label' => esc_html__('Global Style', 'rsaddon'),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' => [
					'service_style!' => 'style2'
				]
			]
		);
			$this->add_responsive_control(
				'g_padding',
				[
					'label' => esc_html__( 'Padding', 'rsaddon' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex .grid-item .service-inner' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'g_margin',
				[
					'label' => esc_html__( 'Margin', 'rsaddon' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex .grid-item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'g_border_radius',
				[
					'label' => esc_html__( 'Border Radius', 'rsaddon' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex .grid-item .service-inner' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->start_controls_tabs(
				'g_style_tabs'
			);
				$this->start_controls_tab(
					'g_style_normal_tab',
					[
						'label' => esc_html__( 'Normal', 'rsaddon' ),
					]
				);
					$this->add_group_control(
						Group_Control_Background::get_type(),
						[
							'name' => 'g_background',
							'types' => ['classic', 'gradient'],
							'selector' => '{{WRAPPER}} .rs-service-flex .grid-item .service-inner',
						]
					);
					$this->add_responsive_control(
						'filter_blur',
						[
							'label' => esc_html__( 'Filter Blur', 'rsaddon' ),
							'type' => Controls_Manager::SLIDER,
							'size_units' => ['px'],
							'range' => [
								'px' => [
									'min' => 0,
									'max' => 100,
								]
							],
							'selectors' => [
								'{{WRAPPER}} .rs-service-flex .grid-item .service-inner' => 'backdrop-filter: blur({{SIZE}}{{UNIT}});',
							]
						]
					);
					$this->add_group_control(
						Group_Control_Border::get_type(),
						[
							'name' => 'g_border',
							'selector' => '{{WRAPPER}} .rs-service-flex .grid-item .service-inner',
						]
					);
					$this->add_group_control(
						Group_Control_Box_Shadow::get_type(),
						[
							'name' => 'g_box_shadow',
							'selector' => '{{WRAPPER}} .rs-service-flex .grid-item .service-inner',
						]
					);

					$this->add_control(
						'last_child_options',
						[
							'label' => esc_html__( 'Last Child Options', 'rsaddon' ),
							'type' => Controls_Manager::HEADING,
							'classes' => 'rs-control-type-heading',
							'separator' => 'before',
						]
					);
					$this->add_group_control(
						Group_Control_Border::get_type(),
						[
							'name' => 'g_border_lastchild',
							'selector' => '{{WRAPPER}} .rs-service-flex .grid-item:last-child .service-inner',
						]
					);
				$this->end_controls_tab();
				$this->start_controls_tab(
					'g_style_active_tab',
					[
						'label' => esc_html__( 'Active', 'rsaddon' ),
					]
				);
					$this->add_group_control(
						Group_Control_Background::get_type(),
						[
							'name' => 'g_background_active',
							'types' => ['classic', 'gradient'],
							'selector' => '{{WRAPPER}} .rs-service-flex .grid-item.active .service-inner',
						]
					);
					$this->add_responsive_control(
						'filter_blur_active',
						[
							'label' => esc_html__( 'Filter Blur Active', 'rsaddon' ),
							'type' => Controls_Manager::SLIDER,
							'size_units' => ['px'],
							'range' => [
								'px' => [
									'min' => 0,
									'max' => 100,
								]
							],
							'selectors' => [
								'{{WRAPPER}} .rs-service-flex .grid-item.active .service-inner' => 'backdrop-filter: blur({{SIZE}}{{UNIT}});',
							]
						]
					);
					$this->add_control(
						'g_border_color_active',
						[
							'label' => esc_html__( 'Border Color', 'rsaddon' ),
							'type' => Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .rs-service-flex .grid-item.active .service-inner' => 'border-color: {{VALUE}}',
							],
						]
					);
					$this->add_group_control(
						Group_Control_Box_Shadow::get_type(),
						[
							'name' => 'g_box_shadow_active',
							'selector' => '{{WRAPPER}} .rs-service-flex .grid-item.active .service-inner',
						]
					);
				$this->end_controls_tab();
			$this->end_controls_tabs();
		$this->end_controls_section();
		// Global Style End

		// Style 2 Column Wrapper Style Start
		$this->start_controls_section(
			'style2_col_wrapper',
			[
				'label' => esc_html__('Column Wrapper', 'rsaddon'),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' => [
					'service_style' => 'style2'
				]
			]
		);
			$this->add_responsive_control(
				'style2_col_v_align',
				[
					'label' => esc_html__( 'Vertical Align', 'rsaddon' ),
					'type' => Controls_Manager::CHOOSE,
					'options' => [
						'flex-start' => [
							'title' => esc_html__( 'Top', 'rsaddon' ),
							'icon' => 'eicon-align-start-v',
						],
						'center' => [
							'title' => esc_html__( 'Middle', 'rsaddon' ),
							'icon' => 'eicon-align-center-v',
						],
						'flex-end' => [
							'title' => esc_html__( 'Bottom', 'rsaddon' ),
							'icon' => 'eicon-align-end-v',
						],
					],
					'toggle' => true,
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex.style2 .wrapper-part' => 'align-items: {{VALUE}};',
					],
				]
			);
			$this->add_responsive_control(
				'style2_col_dir',
				[
					'label' => esc_html__( 'Column Direction', 'rsaddon' ),
					'type' => Controls_Manager::CHOOSE,
					'options' => [
						'row' => [
							'title' => esc_html__( 'Row', 'rsaddon' ),
							'icon' => 'eicon-justify-start-h',
						],
						'row-reverse' => [
							'title' => esc_html__( 'Row Reverse', 'rsaddon' ),
							'icon' => 'eicon-wrap',
						],
						'column' => [
							'title' => esc_html__( 'Column', 'rsaddon' ),
							'icon' => 'eicon-justify-start-v',
						],
						'column-reverse' => [
							'title' => esc_html__( 'Column Reverse', 'rsaddon' ),
							'icon' => 'eicon-wrap',
						],
					],
					'toggle' => true,
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex.style2 .wrapper-part' => 'flex-direction: {{VALUE}};',
					],
				]
			);
			$this->add_responsive_control(
				'style2_col_h_align',
				[
					'label' => esc_html__( 'Horizontal Align', 'rsaddon' ),
					'type' => Controls_Manager::CHOOSE,
					'options' => [
						'flex-start' => [
							'title' => esc_html__( 'Start', 'rsaddon' ),
							'icon' => 'eicon-align-start-h',
						],
						'center' => [
							'title' => esc_html__( 'Center', 'rsaddon' ),
							'icon' => 'eicon-align-center-h',
						],
						'flex-end' => [
							'title' => esc_html__( 'End', 'rsaddon' ),
							'icon' => 'eicon-align-end-h',
						],
						'space-between' => [
							'title' => esc_html__( 'Space Between', 'rsaddon' ),
							'icon' => 'eicon-justify-space-between-h',
						],

					],
					'toggle' => true,
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex.style2 .wrapper-part' => 'justify-content: {{VALUE}};',
					],
				]
			);
			$this->add_responsive_control(
				'style2_col_flex_wrap',
				[
					'label' => esc_html__( 'Flex Wrap', 'rsaddon' ),
					'type' => Controls_Manager::CHOOSE,
					'options' => [
						'nowrap' => [
							'title' => esc_html__( 'No Wrap', 'rsaddon' ),
							'icon' => 'eicon-nowrap',
						],
						'wrap' => [
							'title' => esc_html__( 'Wrap', 'rsaddon' ),
							'icon' => 'eicon-wrap',
						],
					],
					'toggle' => true,
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex.style2 .wrapper-part' => 'flex-wrap: {{VALUE}};',
					],
				]
			);
			$this->add_responsive_control(
				'style2_col_flex_gap',
				[
					'label' => esc_html__( 'Gap Between', 'rsaddon' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'custom' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 1000,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex.style2 .wrapper-part' => 'gap: {{SIZE}}{{UNIT}};',
					],
				]
			);
		$this->end_controls_section();
		// Style 2 Column Wrapper Style End

		// Style 2 Left Column Style Start
		$this->start_controls_section(
			'style2_left_col_style',
			[
				'label' => esc_html__('Left Column Style', 'rsaddon'),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' => [
					'service_style' => 'style2'
				]
			]
		);
			$this->add_responsive_control(
				'style2_left_col_width',
				[
					'label' => esc_html__( 'Width', 'rsaddon' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'custom' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 2000
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'default' => [
						'unit' => '%'
					],
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex.style2 .wrapper-part .left-part' => 'width: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'style2_left_col_padding',
				[
					'label' => esc_html__( 'Padding', 'rsaddon' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex.style2 .wrapper-part .left-part' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_control(
				'style2_left_title_options',
				[
					'label' => esc_html__( 'Title Options', 'rsaddon' ),
					'type' => Controls_Manager::HEADING,
					'classes' => 'rs-control-type-heading',
					'separator' => 'before',
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' => 'style2_left_title_typography',
					'selector' => '{{WRAPPER}} .rs-service-flex.style2 .grid-item .service-inner .title',
				]
			);
			$this->add_responsive_control(
				'style2_left_icon_size',
				[
					'label' => esc_html__( 'Icon Size', 'rsaddon' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'custom' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 1000
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex.style2 .grid-item .service-inner .title svg' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
						'{{WRAPPER}} .rs-service-flex.style2 .grid-item .service-inner .title i' => 'font-size: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'style2_left_title_radius',
				[
					'label' => esc_html__( 'Border Radius', 'rsaddon' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex.style2 .grid-item .service-inner .title' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'style2_left_item_margin',
				[
					'label' => esc_html__( 'Margin', 'rsaddon' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex.style2 .grid-item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'style2_left_item_margin_last_child',
				[
					'label' => esc_html__( 'Margin (Last Child)', 'rsaddon' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex.style2 .grid-item:last-child' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->start_controls_tabs(
				'style2_left_style_tabs'
			);
				$this->start_controls_tab(
					'style2_left_style_normal_tab',
					[
						'label' => esc_html__( 'Normal', 'rsaddon' ),
					]
				);
					$this->add_control(
						'style2_left_title_text_color',
						[
							'label' => esc_html__( 'Text Color', 'rsaddon' ),
							'type' => Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .rs-service-flex.style2 .grid-item .service-inner .title,
								{{WRAPPER}} .rs-service-flex.style2 .grid-item .service-inner .title i' => 'color: {{VALUE}}',
								'{{WRAPPER}} .rs-service-flex.style2 .grid-item .service-inner .title svg path' => 'color: {{VALUE}}',
							],
						]
					);
					$this->add_control(
						'style2_left_icon_color',
						[
							'label' => esc_html__( 'Icon Color', 'rsaddon' ),
							'type' => Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .rs-service-flex.style2 .grid-item .service-inner .title i' => 'color: {{VALUE}}',
								'{{WRAPPER}} .rs-service-flex.style2 .grid-item .service-inner .title svg path' => 'fill: {{VALUE}}',
							],
						]
					);
					$this->add_group_control(
						Group_Control_Background::get_type(),
						[
							'name' => 'style2_left_title_background',
							'types' => [ 'classic', 'gradient' ],
							'selector' => '{{WRAPPER}} .rs-service-flex.style2 .grid-item .service-inner .title',
						]
					);
					$this->add_responsive_control(
						'style2_left_title_padding',
						[
							'label' => esc_html__( 'Padding', 'rsaddon' ),
							'type' => Controls_Manager::DIMENSIONS,
							'size_units' => [ 'px', '%', 'custom' ],
							'selectors' => [
								'{{WRAPPER}} .rs-service-flex.style2 .grid-item .service-inner .title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
							],
						]
					);
					$this->add_group_control(
						Group_Control_Border::get_type(),
						[
							'name' => 'style2_left_title_border',
							'selector' => '{{WRAPPER}} .rs-service-flex.style2 .grid-item .service-inner .title',
						]
					);
					$this->add_responsive_control(
						'style2_left_title_border_last_child_width',
						[
							'label' => esc_html__( 'Border Bottom Width (Last Child)', 'rsaddon' ),
							'type' => Controls_Manager::SLIDER,
							'size_units' => [ 'px', '%', 'custom' ],
							'range' => [
								'px' => [
									'min' => 0,
									'max' => 1000
								],
								'%' => [
									'min' => 0,
									'max' => 100,
								],
							],
							'selectors' => [
								'{{WRAPPER}} .rs-service-flex.style2 .grid-item:last-child .title' => 'border-bottom-width: {{SIZE}}{{UNIT}};',
							],
						]
					);
				$this->end_controls_tab();
				$this->start_controls_tab(
					'style2_left_style_active_tab',
					[
						'label' => esc_html__( 'Active', 'rsaddon' ),
					]
				);
					$this->add_control(
						'style2_left_title_text_color_active',
						[
							'label' => esc_html__( 'Text Color', 'rsaddon' ),
							'type' => Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .rs-service-flex.style2 .grid-item.active .service-inner .title,
								{{WRAPPER}} .rs-service-flex.style2 .grid-item.active .service-inner .title i' => 'color: {{VALUE}}',
								'{{WRAPPER}} .rs-service-flex.style2 .grid-item.active .service-inner .title svg path' => 'color: {{VALUE}}',
							],
						]
					);
					$this->add_control(
						'style2_left_icon_color_active',
						[
							'label' => esc_html__( 'Icon Color', 'rsaddon' ),
							'type' => Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .rs-service-flex.style2 .grid-item.active .service-inner .title i' => 'color: {{VALUE}}',
								'{{WRAPPER}} .rs-service-flex.style2 .grid-item.active .service-inner .title svg path' => 'fill: {{VALUE}}',
							],
						]
					);
					$this->add_group_control(
						Group_Control_Background::get_type(),
						[
							'name' => 'style2_left_title_background_active',
							'types' => [ 'classic', 'gradient' ],
							'selector' => '{{WRAPPER}} .rs-service-flex.style2 .grid-item.active .service-inner .title',
						]
					);
					$this->add_responsive_control(
						'style2_left_title_padding_active',
						[
							'label' => esc_html__( 'Padding', 'rsaddon' ),
							'type' => Controls_Manager::DIMENSIONS,
							'size_units' => [ 'px', '%', 'custom' ],
							'selectors' => [
								'{{WRAPPER}} .rs-service-flex.style2 .grid-item.active .service-inner .title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
							],
						]
					);
					$this->add_control(
						'style2_left_title_border_color_active',
						[
							'label' => esc_html__( 'Border Color', 'rsaddon' ),
							'type' => Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .rs-service-flex.style2 .grid-item.active .service-inner .title' => 'border-color: {{VALUE}};',
							],
						]
					);
				$this->end_controls_tab();
			$this->end_controls_tabs();
		$this->end_controls_section();
		// Style 2 Left Column Style End

		// Style 2 Right Column Style Start
		$this->start_controls_section(
			'style2_right_col_style',
			[
				'label' => esc_html__('Right Column Style', 'rsaddon'),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' => [
					'service_style' => 'style2'
				]
			]
		);
			$this->add_responsive_control(
				'style2_right_col_width',
				[
					'label' => esc_html__( 'Width', 'rsaddon' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'custom' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 2000
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'default' => [
						'unit' => '%'
					],
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex.style2 .wrapper-part .thumbnail-part-wrapper' => 'width: {{SIZE}}{{UNIT}};',
					],
				]
			);

			$this->add_control(
				'style2_right_col_bg_options',
				[
					'label' => esc_html__( 'Background Options', 'rsaddon' ),
					'type' => Controls_Manager::HEADING,
					'classes' => 'rs-control-type-heading',
					'separator' => 'before',
				]
			);

			$this->add_responsive_control(
				'style2_right_col_bg_position',
				[
					'label' => esc_html__( 'Position', 'rsaddon' ),
					'type' => Controls_Manager::SELECT,
					'default' => '',
					'options' => [
						'' => esc_html__( 'Default', 'rsaddon' ),
						'center center' => esc_html__( 'Center Center', 'rsaddon' ),
						'center left' => esc_html__( 'Center Left', 'rsaddon' ),
						'center right' => esc_html__( 'Center Right', 'rsaddon' ),
						'top center' => esc_html__( 'Top Center', 'rsaddon' ),
						'top left' => esc_html__( 'Top Left', 'rsaddon' ),
						'top right' => esc_html__( 'Top Right', 'rsaddon' ),
						'bottom center' => esc_html__( 'Bottom Center', 'rsaddon' ),
						'bottom left' => esc_html__( 'Bottom Left', 'rsaddon' ),
						'bottom right' => esc_html__( 'Bottom Right', 'rsaddon' ),
						'initial' => esc_html__( 'Custom', 'rsaddon' ),

					],
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex.style2 .thumbnail-part-wrapper .thumbnail-part' => 'background-position: {{VALUE}} !important;',
					],
				]
			);
			$this->add_responsive_control(
				'style2_right_col_bg_x_position',
				[
					'label' => esc_html__( 'X Position', 'rsaddon' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'custom' ],
					'range' => [
						'px' => [
							'min' => -1200,
							'max' => 1200,
						],
						'%' => [
							'min' => -100,
							'max' => 100,
						]
					],
					'default' => [
						'size' => 0,
					],
					'condition' => [
						'style2_right_col_bg_position' => [ 'initial' ],
					],
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex.style2 .thumbnail-part-wrapper .thumbnail-part' => 'background-position: {{SIZE}}{{UNIT}} {{style2_right_col_bg_y_position.SIZE}}{{style2_right_col_bg_y_position.UNIT}} !important;',
					],
				]
			);
			$this->add_responsive_control(
				'style2_right_col_bg_y_position',
				[
					'label' => esc_html__( 'Y Position', 'rsaddon' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'custom' ],
					'range' => [
						'px' => [
							'min' => -1200,
							'max' => 1200,
						],
						'%' => [
							'min' => -100,
							'max' => 100,
						]
					],
					'default' => [
						'size' => 0,
					],
					'condition' => [
						'style2_right_col_bg_position' => [ 'initial' ],
					],
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex.style2 .thumbnail-part-wrapper .thumbnail-part' => 'background-position: {{style2_right_col_bg_x_position.SIZE}}{{style2_right_col_bg_x_position.UNIT}} {{SIZE}}{{UNIT}} !important;',
					],
				]
			);
			$this->add_responsive_control(
				'style2_right_col_bg_repeat',
				[
					'label' => esc_html__( 'Repeat', 'rsaddon' ),
					'type' => Controls_Manager::SELECT,
					'default' => '',
					'options' => [
						'' => esc_html__( 'Default', 'elementor' ),
						'no-repeat' => esc_html__( 'No-repeat', 'elementor' ),
						'repeat' => esc_html__( 'Repeat', 'elementor' ),
						'repeat-x' => esc_html__( 'Repeat-x', 'elementor' ),
						'repeat-y' => esc_html__( 'Repeat-y', 'elementor' ),
					],
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex.style2 .thumbnail-part-wrapper .thumbnail-part' => 'background-repeat: {{VALUE}} !important;',
					],
				]
			);
			$this->add_responsive_control(
				'style2_right_col_bg_size',
				[
					'label' => esc_html__( 'Display Size', 'rsaddon' ),
					'type' => Controls_Manager::SELECT,
					'default' => '',
					'options' => [
						'' => esc_html__( 'Default', 'elementor' ),
						'auto' => esc_html__( 'Auto', 'elementor' ),
						'cover' => esc_html__( 'Cover', 'elementor' ),
						'contain' => esc_html__( 'Contain', 'elementor' ),
						'initial' => esc_html__( 'Custom', 'elementor' ),
					],
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex.style2 .thumbnail-part-wrapper .thumbnail-part' => 'background-size: {{VALUE}} !important;',
					],
				]
			);
			$this->add_responsive_control(
				'style2_right_col_bg_size_custom',
				[
					'label' => esc_html__( 'Width', 'rsaddon' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'custom' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 3000,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						]
					],
					'default' => [
						'size' => 100,
						'unit' => '%',
					],
					'condition' => [
						'style2_right_col_bg_size' => [ 'initial' ],
					],
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex.style2 .thumbnail-part-wrapper .thumbnail-part' => 'background-size: {{SIZE}}{{UNIT}} auto !important;',
					]
				]
			);

			$this->add_control(
				'style2_right_col_content_options',
				[
					'label' => esc_html__( 'Content Wrapper', 'rsaddon' ),
					'type' => Controls_Manager::HEADING,
					'classes' => 'rs-control-type-heading',
					'separator' => 'before',
				]
			);
			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name' => 'style2_right_col_content_background',
					'types' => [ 'classic', 'gradient' ],
					'selector' => '{{WRAPPER}} .rs-service-flex.style2 .thumbnail-part-wrapper .thumbnail-part .content-wrapper',
				]
			);
			$this->add_responsive_control(
				'style2_right_col_content_padding',
				[
					'label' => esc_html__( 'Padding', 'rsaddon' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex.style2 .thumbnail-part-wrapper .thumbnail-part .content-wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'style2_right_col_content_radius',
				[
					'label' => esc_html__( 'Border Radius', 'rsaddon' ),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'custom' ],
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex.style2 .thumbnail-part-wrapper .thumbnail-part .content-wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'style2_right_col_content_max_width',
				[
					'label' => esc_html__( 'Max Width', 'rsaddon' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'custom' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 1000
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex.style2 .thumbnail-part-wrapper .thumbnail-part .content-wrapper' => 'max-width: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'style2_right_col_content_blur',
				[
					'label' => esc_html__( 'Filter Blur', 'rsaddon' ),
					'type' => Controls_Manager::SLIDER,
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex.style2 .thumbnail-part-wrapper .thumbnail-part .content-wrapper' => 'backdrop-filter: blur({{SIZE}}px);',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name' => 'style2_right_col_content_border',
					'selector' => '{{WRAPPER}} .rs-service-flex.style2 .thumbnail-part-wrapper .thumbnail-part .content-wrapper',
				]
			);
			$this->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name' => 'style2_right_col_content_shadow',
					'selector' => '{{WRAPPER}} .rs-service-flex.style2 .thumbnail-part-wrapper .thumbnail-part .content-wrapper',
				]
			);
			$this->add_control(
				'style2_right_col_content_shape_color',
				[
					'label' => esc_html__( 'Shape Color', 'rsaddon' ),
					'type' => Controls_Manager::COLOR,
					'separator' => 'before',
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex.style2 .thumbnail-part-wrapper .thumbnail-part .content-wrapper:after' => 'border-left-color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'style2_right_col_content_overlay_color',
				[
					'label' => esc_html__( 'Overlay Color', 'rsaddon' ),
					'type' => Controls_Manager::COLOR,
					'separator' => 'before',
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex.style2 .thumbnail-part-wrapper .thumbnail-part:after' => 'border-left-color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'style2_right_col_content_overlay_options',
				[
					'label' => esc_html__( 'Overlay Options', 'rsaddon' ),
					'type' => Controls_Manager::HEADING,
					'separator' => 'before',
					'classes' => 'rs-control-type-heading',
				]
			);
			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name' => 'style2_right_col_content_overlay_color',
					'types' => [ 'classic', 'gradient' ],
					'selector' => '{{WRAPPER}} .rs-service-flex.style2 .thumbnail-part-wrapper .thumbnail-part:after',
				]
			);
			// Content Position Maker Start
            $this->add_control(
                'style2_right_col_content_position_maker',
                [
                    'label' => esc_html__( 'Position Maker', 'rsaddon' ),
                    'type' => Controls_Manager::POPOVER_TOGGLE,
                    'label_off' => esc_html__( 'Default', 'rsaddon' ),
                    'label_on' => esc_html__( 'Custom', 'rsaddon' ),
                    'return_value' => 'yes',
                    'default' => 'no',
                    'separator' => 'before',
                ]
            );
            
            $this->start_popover();
                $this->add_responsive_control(
                    'style2_right_col_content_p_top',
                    [
                        'label' => esc_html__( 'Top', 'rsaddon' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%', 'custom' ],
                        'range' => [
                            'px' => [
                                'min' => -1000,
                                'max' => 1000,
                            ],
                            '%' => [
                                'min' => -100,
                                'max' => 100,
                            ],
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .rs-service-flex.style2 .thumbnail-part-wrapper .thumbnail-part .content-wrapper' => 'top: {{SIZE}}{{UNIT}};',
                        ],
                    ]
                );
                $this->add_responsive_control(
                    'style2_right_col_content_p_right',
                    [
                        'label' => esc_html__( 'Right', 'rsaddon' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%', 'custom' ],
                        'range' => [
                            'px' => [
                                'min' => -1000,
                                'max' => 1000,
                            ],
                            '%' => [
                                'min' => -100,
                                'max' => 100,
                            ],
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .rs-service-flex.style2 .thumbnail-part-wrapper .thumbnail-part .content-wrapper' => 'right: {{SIZE}}{{UNIT}};',
                        ],
                    ]
                );
                $this->add_responsive_control(
                    'style2_right_col_content_bottom',
                    [
                        'label' => esc_html__( 'Bottom', 'rsaddon' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%', 'custom' ],
                        'range' => [
                            'px' => [
                                'min' => -1000,
                                'max' => 1000,
                            ],
                            '%' => [
                                'min' => -100,
                                'max' => 100,
                            ],
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .rs-service-flex.style2 .thumbnail-part-wrapper .thumbnail-part .content-wrapper' => 'bottom: {{SIZE}}{{UNIT}};',
                        ],
                    ]
                );
                $this->add_responsive_control(
                    'style2_right_col_content_left',
                    [
                        'label' => esc_html__( 'Left', 'rsaddon' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%', 'custom' ],
                        'range' => [
                            'px' => [
                                'min' => -1000,
                                'max' => 1000,
                            ],
                            '%' => [
                                'min' => -100,
                                'max' => 100,
                            ],
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .rs-service-flex.style2 .thumbnail-part-wrapper .thumbnail-part .content-wrapper' => 'left: {{SIZE}}{{UNIT}};',
                        ],
                    ]
                );
            $this->end_popover();
            // Content Position Maker End
		$this->end_controls_section();
		// Style 2 Right Column Style End

		// Icon Style Start
		$this->start_controls_section(
			'_icon_style',
			[
				'label' => esc_html__('Icon Style', 'rsaddon'),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' => [
					'show_icon' => 'yes',
				]
			]
		);

			$this->add_responsive_control(
				'service_icon_font_size',
				[
					'label' => esc_html__( 'Font Size', 'rsaddon' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'custom' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 200,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex .grid-item .service-inner .icon-wrap svg,
						{{WRAPPER}} .rs-service-flex.style2 .thumbnail-part-wrapper .thumbnail-part .content-wrapper .icon-wrap svg' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
						'{{WRAPPER}} .rs-service-flex .grid-item .service-inner .icon-wrap i,
						{{WRAPPER}} .rs-service-flex.style2 .thumbnail-part-wrapper .thumbnail-part .content-wrapper .icon-wrap i' => 'font-size: {{SIZE}}{{UNIT}};',
					]
				]
			);


			$this->add_responsive_control(
				'icon_wrapper_width',
				[
					'label' => esc_html__( 'Icon Wrapper Width', 'rsaddon' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'custom' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 1000,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex .grid-item .service-inner .icon-wrap,
						{{WRAPPER}} .rs-service-flex.style2 .thumbnail-part-wrapper .thumbnail-part .content-wrapper .icon-wrap' => 'width: {{SIZE}}{{UNIT}};',
					]
				]
			);
			$this->add_responsive_control(
				'icon_wrapper_height',
				[
					'label' => esc_html__( 'Icon Wrapper Height', 'rsaddon' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'custom' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 1000,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex .grid-item .service-inner .icon-wrap,
						{{WRAPPER}} .rs-service-flex.style2 .thumbnail-part-wrapper .thumbnail-part .content-wrapper .icon-wrap' => 'height: {{SIZE}}{{UNIT}};',
					]
				]
			);
			$this->add_responsive_control(
                'icon_padding',
                [
                    'label' => esc_html__( 'Padding', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-service-flex .grid-item .service-inner .icon-wrap,
						{{WRAPPER}} .rs-service-flex.style2 .thumbnail-part-wrapper .thumbnail-part .content-wrapper .icon-wrap' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}; overflow: hidden;',
                    ]
                ]
            );
			$this->add_responsive_control(
				'icon_position_y',
				[
					'label' => esc_html__('Position Y (Top)', 'rsaddon'),
					'type' => Controls_Manager::SLIDER,
					'size_units' => ['%', 'px'],
					'range' => [
						'px' => [
							'min' => -1000,
							'max' => 1000
						],
						'px' => [
							'min' => -100,
							'max' => 100
						]
					],
					'show_label' => true,
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex .grid-item .service-inner .icon-wrap,
						{{WRAPPER}} .rs-service-flex.style2 .thumbnail-part-wrapper .thumbnail-part .content-wrapper .icon-wrap' => 'top: {{SIZE}}{{UNIT}}; bottom: unset; position: absolute;'
					],
				]
			);
			$this->add_responsive_control(
				'icon_position_y_bottom',
				[
					'label' => esc_html__('Position Y (Bottom)', 'rsaddon'),
					'type' => Controls_Manager::SLIDER,
					'size_units' => ['%', 'px'],
					'range' => [
						'px' => [
							'min' => -1000,
							'max' => 1000
						],
						'px' => [
							'min' => -100,
							'max' => 100
						]
					],
					'show_label' => true,
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex .grid-item .service-inner .icon-wrap,
						{{WRAPPER}} .rs-service-flex.style2 .thumbnail-part-wrapper .thumbnail-part .content-wrapper .icon-wrap' => 'bottom: {{SIZE}}{{UNIT}}; top: unset; position: absolute;'
					],
				]
			);
			$this->add_responsive_control(
				'icon_position_x',
				[
					'label' => esc_html__('Position X (Left)', 'rsaddon'),
					'type' => Controls_Manager::SLIDER,
					'size_units' => ['%', 'px'],
					'range' => [
						'px' => [
							'min' => -1000,
							'max' => 1000
						],
						'px' => [
							'min' => -100,
							'max' => 100
						]
					],
					'show_label' => true,
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex .grid-item .service-inner .icon-wrap,
						{{WRAPPER}} .rs-service-flex.style2 .thumbnail-part-wrapper .thumbnail-part .content-wrapper .icon-wrap' => 'left: {{SIZE}}{{UNIT}}; right: unset;  position: absolute;'
					],
				]
			);
			$this->add_responsive_control(
				'icon_position_x_right',
				[
					'label' => esc_html__('Position X (Right)', 'rsaddon'),
					'type' => Controls_Manager::SLIDER,
					'size_units' => ['%', 'px'],
					'range' => [
						'px' => [
							'min' => -1000,
							'max' => 1000
						],
						'px' => [
							'min' => -100,
							'max' => 100
						]
					],
					'show_label' => true,
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex .grid-item .service-inner .icon-wrap,
						{{WRAPPER}} .rs-service-flex.style2 .thumbnail-part-wrapper .thumbnail-part .content-wrapper .icon-wrap' => 'right: {{SIZE}}{{UNIT}}; left: unset;  position: absolute;',
					],
				]
			);
			$this->add_responsive_control(
                'icon_radius',
                [
                    'label' => esc_html__( 'Border Radius', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-service-flex .grid-item .service-inner .icon-wrap,
						{{WRAPPER}} .rs-service-flex.style2 .thumbnail-part-wrapper .thumbnail-part .content-wrapper .icon-wrap' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}; overflow: hidden;',
                    ]
                ]
            );
			$this->add_group_control(
				Group_Control_Box_Shadow::get_type(),
				[
					'name' => 'icon_box_shadow',
					'selector' => '{{WRAPPER}} .rs-service-flex .grid-item .service-inner .icon-wrap, {{WRAPPER}} .rs-service-flex.style2 .thumbnail-part-wrapper .thumbnail-part .content-wrapper .icon-wrap'
				]
			);
			$this->start_controls_tabs(
				'icon_style_tabs'
			);
				$this->start_controls_tab(
					'icon_style_normal_tab',
					[
						'label' => esc_html__( 'Normal', 'rsaddon' ),
					]
				);

					$this->add_control(
						'icon_color',
						[
							'label' => esc_html__('Color', 'rsaddon'),
							'type' => Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .rs-service-flex .grid-item .service-inner .icon-wrap i,
								{{WRAPPER}} .rs-service-flex.style2 .thumbnail-part-wrapper .thumbnail-part .content-wrapper .icon-wrap i' => 'color: {{VALUE}};',
								'{{WRAPPER}} .rs-service-flex .grid-item .service-inner .icon-wrap svg path,
								{{WRAPPER}} .rs-service-flex.style2 .thumbnail-part-wrapper .thumbnail-part .content-wrapper .icon-wrap svg path' => 'fill: {{VALUE}};',
							],
						]
					);
					$this->add_group_control(
						Group_Control_Background::get_type(),
						[
							'name' => 'icon_background',
							'types' => ['classic', 'gradient'],
							'selector' => '
								{{WRAPPER}} .rs-service-flex .grid-item .service-inner .icon-wrap,
								{{WRAPPER}} .rs-service-flex.style2 .thumbnail-part-wrapper .thumbnail-part .content-wrapper .icon-wrap
							',
						]
					);

				$this->end_controls_tab();

				$this->start_controls_tab(
					'icon_style_active_tab',
					[
						'label' => esc_html__( 'Active', 'rsaddon' ),
						'condition' => [
							'service_style!' => 'style2'
						]
					]
				);

					$this->add_control(
						'icon_color_active',
						[
							'label' => esc_html__('Color (Active)', 'rsaddon'),
							'type' => Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .rs-service-flex .grid-item.active .service-inner .icon-wrap i' => 'color: {{VALUE}};',
								'{{WRAPPER}} .rs-service-flex .grid-item.active .service-inner .icon-wrap svg path' => 'fill: {{VALUE}};',
							]
						]
		
					);
					$this->add_group_control(
						Group_Control_Background::get_type(),
						[
							'name' => 'icon_background_active',
							'types' => ['classic', 'gradient'],
							'selector' => '{{WRAPPER}} .rs-service-flex .grid-item.active .service-inner .icon-wrap',
						]
					);
					
				$this->end_controls_tab();

			$this->end_controls_tabs();

		$this->end_controls_section();
		// Icon Style End

		// Title Style Start
		$this->start_controls_section(
			'_title_style',
			[
				'label' => esc_html__('Title Style', 'rsaddon'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' => 'title_typography',
					'label' => esc_html__('Typography', 'rsaddon'),
					'selector' => '{{WRAPPER}} .rs-service-flex .grid-item .service-inner .title, {{WRAPPER}} .rs-service-flex.style2 .thumbnail-part-wrapper .thumbnail-part .content-wrapper .title',
				]
			);
			$this->add_control(
				'title_color',
				[
					'label' => esc_html__('Color', 'rsaddon'),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex .grid-item .service-inner .title a, {{WRAPPER}} .rs-service-flex.style2 .thumbnail-part-wrapper .thumbnail-part .content-wrapper .title a' => 'color: {{VALUE}};',
					],
				]
			);
			$this->add_control(
				'title_color_active',
				[
					'label' => esc_html__('Color (Active)', 'rsaddon'),
					'type' => Controls_Manager::COLOR,
					'condition' => [
						'service_style!' => 'style2'
					],
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex .grid-item.active .service-inner .title a' => 'color: {{VALUE}};',
					]
				]

			);
			$this->add_control(
				'title_color_hover',
				[
					'label' => esc_html__('Color (Hover)', 'rsaddon'),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex .grid-item .service-inner .title a:hover,
						{{WRAPPER}} .rs-service-flex.style2 .thumbnail-part-wrapper .thumbnail-part .content-wrapper .title a:hover' => 'color: {{VALUE}};',
					]
				]

			);
			$this->add_control(
				'title_color_hover',
				[
					'label' => esc_html__('Color (Hover)', 'rsaddon'),
					'type' => Controls_Manager::COLOR,
					'condition' => [
						'service_style' => 'style2'
					],
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex.style2 .thumbnail-part-wrapper .thumbnail-part .content-wrapper .title a:hover' => 'color: {{VALUE}};',
					]
				]

			);
			$this->add_responsive_control(
				'title_margin',
				[
					'label' => esc_html__('Margin', 'rsaddon'),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => ['px', 'em', '%'],
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex .grid-item .service-inner .title, {{WRAPPER}} .rs-service-flex.style2 .thumbnail-part-wrapper .thumbnail-part .content-wrapper .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'title_margin_active',
				[
					'label' => esc_html__('Active Margin', 'rsaddon'),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => ['px', 'em', '%'],
					'condition' => [
						'service_style!' => 'style2'
					],
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex .grid-item.active .service-inner .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
		$this->end_controls_section();
		// Title Style End

		// Description Style Start
		$this->start_controls_section(
			'_description_style',
			[
				'label' => esc_html__('Description Style', 'rsaddon'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' => 'desc_typography',
					'label' => esc_html__('Typography', 'rsaddon'),
					'selector' => '{{WRAPPER}} .rs-service-flex .grid-item .service-inner .desc, {{WRAPPER}} .rs-service-flex.style2 .thumbnail-part-wrapper .thumbnail-part .content-wrapper .desc',
				]
			);
			$this->add_control(
				'desc_color',
				[
					'label' => esc_html__('Color', 'rsaddon'),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex .grid-item .service-inner .desc, {{WRAPPER}} .rs-service-flex.style2 .thumbnail-part-wrapper .thumbnail-part .content-wrapper .desc' => 'color: {{VALUE}};',
					],
				]
			);
			$this->add_control(
				'desc_color_active',
				[
					'label' => esc_html__('Color (Active)', 'rsaddon'),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex .grid-item.active .service-inner .desc' => 'color: {{VALUE}};',
					],
					'condition' => [
						'service_style!' => 'style2'
					]
				]

			);
			$this->add_responsive_control(
				'desc_margin',
				[
					'label' => esc_html__('Margin', 'rsaddon'),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => ['px', 'em', '%'],
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex .grid-item .service-inner .desc, {{WRAPPER}} .rs-service-flex.style2 .thumbnail-part-wrapper .thumbnail-part .content-wrapper .desc' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'desc_height_normal',
				[
					'label' => esc_html__( 'Height (Normal)', 'rsaddon' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'custom' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 1000,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex .grid-item .service-inner .desc' => 'height: {{SIZE}}{{UNIT}};',
					],
					'condition' => [
						'service_style!' => 'style2'
					]
				]
			);
			$this->add_responsive_control(
				'desc_height_active',
				[
					'label' => esc_html__( 'Height (Active)', 'rsaddon' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'custom' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 1000,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex .grid-item.active .service-inner .desc' => 'height: {{SIZE}}{{UNIT}};',
					],
					'condition' => [
						'service_style!' => 'style2'
					]
				]
			);
		$this->end_controls_section();
		// Description Style End

		// Number Style Start
		$this->start_controls_section(
			'_number_style',
			[
				'label' => esc_html__('Number Style', 'rsaddon'),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' => [
					'show_count_number' => 'yes',
				]
			]
		);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' => 'number_typography',
					'label' => esc_html__('Typography', 'rsaddon'),
					'selector' => '
						{{WRAPPER}} .rs-service-flex .grid-item .service-inner .number span,
						{{WRAPPER}} .rs-service-flex.style2 .thumbnail-part-wrapper .thumbnail-part .content-wrapper .number span
					',
				]
			);
			$this->add_control(
				'number_color',
				[
					'label' => esc_html__('Color', 'rsaddon'),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex .grid-item .service-inner .number span,
						{{WRAPPER}} .rs-service-flex.style2 .thumbnail-part-wrapper .thumbnail-part .content-wrapper .number span' => 'color: {{VALUE}};',
					],
				]
			);
			$this->add_control(
				'number_color_active',
				[
					'label' => esc_html__('Color (Active)', 'rsaddon'),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex .grid-item.active .service-inner .number span' => 'color: {{VALUE}};',
					],
					'condition' => [
						'service_style!' => 'style2'
					]
				]

			);
			// Numbering Stroke
			$this->add_control(
				'number_expand_stroke',
				[
					'label' => esc_html__( 'Numbering Stroke', 'rsaddon' ),
					'type' => Controls_Manager::HEADING,
					'classes' => 'rs-control-type-heading',
					'separator' => 'before',
				]
			);

			$this->add_control(
				'number_fill_stroke_color',
				[
					'label' => esc_html__( 'Number Stroke Fill Color', 'prelements' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex .grid-item .service-inner .number span,
						{{WRAPPER}} .rs-service-flex.style2 .thumbnail-part-wrapper .thumbnail-part .content-wrapper .number span ' => '-webkit-text-fill-color: {{VALUE}};'
					],                
				]
			);
		
			$this->add_group_control(
				Group_Control_Text_Stroke::get_type(),
				[
					'name' => 'number_text_stroke',
					'selector' => '
						{{WRAPPER}} .rs-service-flex .grid-item .service-inner .number span,
						{{WRAPPER}} .rs-service-flex.style2 .thumbnail-part-wrapper .thumbnail-part .content-wrapper .number span
					',
				]
			);

			$this->add_group_control(
				Group_Control_Background::get_type(),
				[
					'name' => 'number_background',
					'types' => ['classic', 'gradient'],
					'selector' => '
						{{WRAPPER}} .rs-service-flex .grid-item .service-inner .number,
						{{WRAPPER}} .rs-service-flex.style2 .thumbnail-part-wrapper .thumbnail-part .content-wrapper .number
					',
				]
			);
			$this->add_responsive_control(
				'number_margin',
				[
					'label' => esc_html__('Margin', 'rsaddon'),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => ['px', 'em', '%'],
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex .grid-item .service-inner .number span,
						{{WRAPPER}} .rs-service-flex.style2 .thumbnail-part-wrapper .thumbnail-part .content-wrapper .number span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'number_padding',
				[
					'label' => esc_html__('Padding', 'rsaddon'),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => ['px', 'em', '%'],
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex .grid-item .service-inner .number span,
						{{WRAPPER}} .rs-service-flex.style2 .thumbnail-part-wrapper .thumbnail-part .content-wrapper .number span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'number_wrapper_width',
				[
					'label' => esc_html__('Number Wrapper Width', 'rsaddon'),
					'type' => Controls_Manager::SLIDER,
					'show_label' => true,
					'size_units' => ['px','%'],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 1,
							'step' => 0.1,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex .grid-item .service-inner .number,
						{{WRAPPER}} .rs-service-flex.style2 .thumbnail-part-wrapper .thumbnail-part .content-wrapper .number' => 'width: {{SIZE}}{{UNIT}};display:flex;align-items:center;justify-content:center;'
					],
				]
			);

			$this->add_responsive_control(
				'number_wrapper_height',
				[
					'label' => esc_html__('Number Wrapper Height', 'rsaddon'),
					'type' => Controls_Manager::SLIDER,
					'show_label' => true,
					'size_units' => ['px','%'],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 1,
							'step' => 0.1,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex .grid-item .service-inner .number,
						{{WRAPPER}} .rs-service-flex.style2 .thumbnail-part-wrapper .thumbnail-part .content-wrapper .number' => 'height: {{SIZE}}{{UNIT}};'
					],
				]
			);

			$this->add_responsive_control(
				'number_position_y',
				[
					'label' => esc_html__('Position Y (Top)', 'rsaddon'),
					'type' => Controls_Manager::SLIDER,
					'size_units' => ['%', 'px'],
					'range' => [
						'px' => [
							'min' => -1000,
							'max' => 1000
						],
						'px' => [
							'min' => -100,
							'max' => 100
						]
					],
					'show_label' => true,
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex .grid-item .service-inner .number,
						{{WRAPPER}} .rs-service-flex.style2 .thumbnail-part-wrapper .thumbnail-part .content-wrapper .number' => 'top: {{SIZE}}{{UNIT}}; bottom: unset; position: absolute;'
					],
				]
			);
			$this->add_responsive_control(
				'number_position_y_bottom',
				[
					'label' => esc_html__('Position Y (Bottom)', 'rsaddon'),
					'type' => Controls_Manager::SLIDER,
					'size_units' => ['%', 'px'],
					'range' => [
						'px' => [
							'min' => -1000,
							'max' => 1000
						],
						'px' => [
							'min' => -100,
							'max' => 100
						]
					],
					'show_label' => true,
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex .grid-item .service-inner .number,
						{{WRAPPER}} .rs-service-flex.style2 .thumbnail-part-wrapper .thumbnail-part .content-wrapper .number' => 'bottom: {{SIZE}}{{UNIT}}; top: unset; position: absolute;'
					],
				]
			);
			$this->add_responsive_control(
				'number_position_x',
				[
					'label' => esc_html__('Position X (Left)', 'rsaddon'),
					'type' => Controls_Manager::SLIDER,
					'size_units' => ['%', 'px'],
					'range' => [
						'px' => [
							'min' => -1000,
							'max' => 1000
						],
						'px' => [
							'min' => -100,
							'max' => 100
						]
					],
					'show_label' => true,
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex .grid-item .service-inner .number,
						{{WRAPPER}} .rs-service-flex.style2 .thumbnail-part-wrapper .thumbnail-part .content-wrapper .number' => 'left: {{SIZE}}{{UNIT}}; right: unset;  position: absolute;'
					],
				]
			);
			$this->add_responsive_control(
				'number_position_x_right',
				[
					'label' => esc_html__('Position X (Right)', 'rsaddon'),
					'type' => Controls_Manager::SLIDER,
					'size_units' => ['%', 'px'],
					'range' => [
						'px' => [
							'min' => -1000,
							'max' => 1000
						],
						'px' => [
							'min' => -100,
							'max' => 100
						]
					],
					'show_label' => true,
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex .grid-item .service-inner .number,
						{{WRAPPER}} .rs-service-flex.style2 .thumbnail-part-wrapper .thumbnail-part .content-wrapper .number' => 'right: {{SIZE}}{{UNIT}}; left: unset;  position: absolute;',
					],
				]
			);


		$this->end_controls_section();
		// Number Style End

		// Button Style Start
		$this->start_controls_section(
			'_button_style',
			[
				'label' => esc_html__('Button Style', 'rsaddon'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
			$this->add_responsive_control(
				'icon_reverse',
				[
					'label' => esc_html__( 'Icon Position', 'rsaddon' ),
					'type' => Controls_Manager::CHOOSE,
					'options' => [
						'row' => [
							'title' => esc_html__( 'Right', 'rsaddon' ),
							'icon' => 'eicon-nowrap',
						],
						'row-reverse' => [
							'title' => esc_html__( 'Left', 'rsaddon' ),
							'icon' => 'eicon-wrap',
						]
					],
					'toggle' => true,
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex .grid-item .service-inner .btn-part a.service-btn,
						{{WRAPPER}} .rs-service-flex.style2 .thumbnail-part-wrapper .thumbnail-part .content-wrapper .btn-part a' => 'flex-direction: {{VALUE}};',
					]
				]
			);
			$this->add_responsive_control(
				'btn_icon_text_gap_between',
				[
					'label' => esc_html__( 'Gap Between', 'rsaddon' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'custom' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 1000,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex .grid-item .service-inner .btn-part a.service-btn,
						{{WRAPPER}} .rs-service-flex.style2 .thumbnail-part-wrapper .thumbnail-part .content-wrapper .btn-part a' => 'gap: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'btn_h_align',
				[
					'label' => esc_html__( 'Horizontal Align', 'rsaddon' ),
					'type' => Controls_Manager::CHOOSE,
					'options' => [
						'flex-start' => [
							'title' => esc_html__( 'Start', 'rsaddon' ),
							'icon' => 'eicon-align-start-h',
						],
						'center' => [
							'title' => esc_html__( 'Center', 'rsaddon' ),
							'icon' => 'eicon-align-center-h',
						],
						'flex-end' => [
							'title' => esc_html__( 'End', 'rsaddon' ),
							'icon' => 'eicon-align-end-h',
						],
						'space-between' => [
							'title' => esc_html__( 'Space Between', 'rsaddon' ),
							'icon' => 'eicon-justify-space-between-h',
						],

					],
					'condition' => [
						'service_style!' => 'style2'
					],
					'toggle' => true,
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex .grid-item .service-inner .btn-part a.service-btn' => 'justify-content: {{VALUE}};',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name' => 'btn_typography',
					'label' => esc_html__('Typography', 'rsaddon'),
					'selector' => '
						{{WRAPPER}} .rs-service-flex .grid-item .service-inner .btn-part a.service-btn,
						{{WRAPPER}} .rs-service-flex.style2 .thumbnail-part-wrapper .thumbnail-part .content-wrapper .btn-part a
					',
				]
			);
			$this->add_responsive_control(
				'btn_icon_size',
				[
					'label' => esc_html__( 'Icon Size', 'rsaddon' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'custom' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 1000,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex .grid-item .service-inner .btn-part a.service-btn i,
						{{WRAPPER}} .rs-service-flex.style2 .thumbnail-part-wrapper .thumbnail-part .content-wrapper .btn-part a i' => 'font-size: {{SIZE}}{{UNIT}};',
						'{{WRAPPER}} .rs-service-flex .grid-item .service-inner .btn-part a.service-btn svg,
						{{WRAPPER}} .rs-service-flex.style2 .thumbnail-part-wrapper .thumbnail-part .content-wrapper .btn-part a svg' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'btn_padding',
				[
					'label' => esc_html__('Padding', 'rsaddon'),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => ['px', 'em', '%'],
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex .grid-item .service-inner .btn-part a.service-btn,
						{{WRAPPER}} .rs-service-flex.style2 .thumbnail-part-wrapper .thumbnail-part .content-wrapper .btn-part a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'btn_border_radius',
				[
					'label' => esc_html__('Border Radius', 'rsaddon'),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => ['px', 'em', '%'],
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex .grid-item .service-inner .btn-part a.service-btn,
						{{WRAPPER}} .rs-service-flex.style2 .thumbnail-part-wrapper .thumbnail-part .content-wrapper .btn-part a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'btn_margin',
				[
					'label' => esc_html__('Margin', 'rsaddon'),
					'type' => Controls_Manager::DIMENSIONS,
					'size_units' => ['px', 'em', '%'],
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex .grid-item .service-inner .btn-part,
						{{WRAPPER}} .rs-service-flex.style2 .thumbnail-part-wrapper .thumbnail-part .content-wrapper .btn-part' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);
			$this->add_responsive_control(
				'btn_width',
				[
					'label' => esc_html__( 'Button Width', 'rsaddon' ),
					'type' => Controls_Manager::SLIDER,
					'size_units' => [ 'px', '%', 'custom' ],
					'range' => [
						'px' => [
							'min' => 0,
							'max' => 1000,
						],
						'%' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'default' => [
						'unit' => '%'
					],
					'selectors' => [
						'{{WRAPPER}} .rs-service-flex .grid-item .service-inner .btn-part a.service-btn,
						{{WRAPPER}} .rs-service-flex.style2 .thumbnail-part-wrapper .thumbnail-part .content-wrapper .btn-part a' => 'width: {{SIZE}}{{UNIT}};',
					],
				]
			);
			$this->start_controls_tabs(
				'button_style_tabs'
			);
				$this->start_controls_tab(
					'button_style_normal_tab',
					[
						'label' => esc_html__( 'Normal', 'rsaddon' ),
					]
				);
					$this->add_control(
						'btn_color',
						[
							'label' => esc_html__('Text Color', 'rsaddon'),
							'type' => Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .rs-service-flex .grid-item .service-inner .btn-part a.service-btn,
								{{WRAPPER}} .rs-service-flex.style2 .thumbnail-part-wrapper .thumbnail-part .content-wrapper .btn-part a' => 'color: {{VALUE}};',
							],
						]
					);
					$this->add_control(
						'btn_icon_color',
						[
							'label' => esc_html__('Icon Color', 'rsaddon'),
							'type' => Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .rs-service-flex .grid-item .service-inner .btn-part a.service-btn i,
								{{WRAPPER}} .rs-service-flex.style2 .thumbnail-part-wrapper .thumbnail-part .content-wrapper .btn-part a i' => 'color: {{VALUE}};',
								'{{WRAPPER}} .rs-service-flex .grid-item .service-inner .btn-part a.service-btn svg path,
								{{WRAPPER}} .rs-service-flex.style2 .thumbnail-part-wrapper .thumbnail-part .content-wrapper .btn-part a svg path' => 'fill: {{VALUE}};',
							]
						]
					);
					$this->add_control(
						'btn_icon_stroke_color',
						[
							'label' => esc_html__('Icon Stroke Color', 'rsaddon'),
							'type' => Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .rs-service-flex .grid-item .service-inner .btn-part a.service-btn svg path,
								{{WRAPPER}} .rs-service-flex.style2 .thumbnail-part-wrapper .thumbnail-part .content-wrapper .btn-part a svg path' => 'stroke: {{VALUE}};',
							]
						]
		
					);
					$this->add_group_control(
						Group_Control_Background::get_type(),
						[
							'name' => 'btn_background',
							'types' => ['classic', 'gradient'],
							'selector' => '
								{{WRAPPER}} .rs-service-flex .grid-item .service-inner .btn-part a.service-btn,
								{{WRAPPER}} .rs-service-flex.style2 .thumbnail-part-wrapper .thumbnail-part .content-wrapper .btn-part a
							',
						]
					);
					$this->add_group_control(
						Group_Control_Border::get_type(),
						[
							'name' => 'btn_border',
							'selector' => '
								{{WRAPPER}} .rs-service-flex .grid-item .service-inner .btn-part a.service-btn,
								{{WRAPPER}} .rs-service-flex.style2 .thumbnail-part-wrapper .thumbnail-part .content-wrapper .btn-part a
							',
						]
					);
				$this->end_controls_tab();
				$this->start_controls_tab(
					'button_style_active_tab',
					[
						'label' => esc_html__( 'Active', 'rsaddon' ),
						'condition' => [
							'service_style!' => 'style2'
						]
					]
				);
					$this->add_control(
						'btn_color_active',
						[
							'label' => esc_html__('Text Color', 'rsaddon'),
							'type' => Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .rs-service-flex .grid-item.active .service-inner .btn-part a.service-btn' => 'color: {{VALUE}};',
							]
						]
		
					);
					$this->add_control(
						'btn_icon_color_active',
						[
							'label' => esc_html__('Icon Color', 'rsaddon'),
							'type' => Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .rs-service-flex .grid-item.active .service-inner .btn-part a.service-btn i' => 'color: {{VALUE}};',
								'{{WRAPPER}} .rs-service-flex .grid-item.active .service-inner .btn-part a.service-btn svg path' => 'fill: {{VALUE}};',
							]
						]
					);
					$this->add_control(
						'btn_icon_stroke_color_active',
						[
							'label' => esc_html__('Icon Stroke Color', 'rsaddon'),
							'type' => Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .rs-service-flex .grid-item .service-inner:hover .btn-part a.service-btn svg path,
								{{WRAPPER}} .rs-service-flex.style2 .thumbnail-part-wrapper .thumbnail-part .content-wrapper .btn-part a:hover svg path' => 'stroke: {{VALUE}};',
							]
						]
		
					);
					$this->add_group_control(
						Group_Control_Background::get_type(),
						[
							'name' => 'btn_background_active',
							'types' => ['classic', 'gradient'],
							'selector' => '{{WRAPPER}} .rs-service-flex .grid-item.active .service-inner .btn-part a.service-btn',
						]
					);
					$this->add_control(
						'btn_border_color_active',
						[
							'label' => esc_html__('Border Color', 'rsaddon'),
							'type' => Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .rs-service-flex .grid-item.active .service-inner .btn-part a.service-btn' => 'border-color: {{VALUE}};',
							]
						]
		
					);
				$this->end_controls_tab();
				$this->start_controls_tab(
					'button_style_hover_tab',
					[
						'label' => esc_html__( 'Hover', 'rsaddon' ),
						'condition' => [
							'service_style' => 'style2'
						]
					]
				);
					$this->add_control(
						'btn_color_hover',
						[
							'label' => esc_html__('Text Color', 'rsaddon'),
							'type' => Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .rs-service-flex.style2 .thumbnail-part-wrapper .thumbnail-part .content-wrapper .btn-part a:hover' => 'color: {{VALUE}};',
							]
						]
		
					);
					$this->add_control(
						'btn_icon_color_hover',
						[
							'label' => esc_html__('Icon Color', 'rsaddon'),
							'type' => Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .rs-service-flex.style2 .thumbnail-part-wrapper .thumbnail-part .content-wrapper .btn-part a:hover i' => 'color: {{VALUE}};',
								'{{WRAPPER}} .rs-service-flex.style2 .thumbnail-part-wrapper .thumbnail-part .content-wrapper .btn-part a:hover svg path' => 'fill: {{VALUE}};',
							]
						]
		
					);
					$this->add_group_control(
						Group_Control_Background::get_type(),
						[
							'name' => 'btn_background_hover',
							'types' => ['classic', 'gradient'],
							'selector' => '{{WRAPPER}} .rs-service-flex.style2 .thumbnail-part-wrapper .thumbnail-part .content-wrapper .btn-part a:hover',
						]
					);
					$this->add_control(
						'btn_border_color_hover',
						[
							'label' => esc_html__('Border Color', 'rsaddon'),
							'type' => Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .rs-service-flex.style2 .thumbnail-part-wrapper .thumbnail-part .content-wrapper .btn-part a:hover' => 'border-color: {{VALUE}};',
							]
						]
		
					);
				$this->end_controls_tab();
			$this->end_controls_tabs();
		$this->end_controls_section();
		// Button Style End
	}

	/**
	 * Render rsgallery widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render()
	{

		$settings = $this->get_settings_for_display();
		$unique = rand(54543455, 987484);
		$counter = 0;
		$thumb_counter = 0;
		$active_item = '';
	?>
		<div class="rs-service-flex <?php echo esc_attr($settings['service_style']); ?> service-parent-<?php echo esc_attr($unique); ?>">
			<?php if ('style2' === $settings['service_style']) { ?>
				<div class="wrapper-part">
					<!-- Content Part Start -->
					<div class="left-part service-<?php echo esc_attr($unique); ?>">
						<?php foreach ($settings['services_list'] as $index => $item) :
							$link = !empty($item['link']['url']) ? $item['link']['url'] : '#';
							$target = $item['link']['is_external'] ? 'target=_blank' : '';
							$counter++;
							$active_item = $item['active_item'];
						?>
							<div class="grid-item item-<?php echo $counter ?> <?php echo ($active_item == 'yes') ? 'active' : ''; ?>">
								<div class="service-inner">
									<?php if(!empty($item['title'])) {?>
										<h4 class="title">
											<?php
												echo esc_html($item['title']);
												if (!empty($settings['btn__selected_icon']['value'])) {
													Icons_Manager::render_icon($settings['btn__selected_icon'], ['aria-hidden' => 'true']);
												}
											?>
										</h4>
									<?php } ?>
								</div>
							</div>
						<?php endforeach; ?>
					</div>
					<!-- Content Part End -->
					<div class="thumbnail-part-wrapper">
						<?php foreach ($settings['services_list'] as $index => $item) :
							$image = wp_get_attachment_image_url( $item['feature_img']['id'], 'full');
							$thumbnail_id = $item['feature_img']['id'];
							$thumbnail_alt = get_post_meta( $thumbnail_id, '_wp_attachment_image_alt', true );
							if ( empty( $thumbnail_alt ) ) {
								$thumbnail_alt = get_the_title( $thumbnail_id );
							}

							if ( ! $image ) {
								$image = Utils::get_placeholder_image_src();
							}
							$thumb_counter++;
							$active_item = $item['active_item'];
						?>
							<div class="thumbnail-part <?php echo esc_attr($thumb_counter); ?> <?php echo esc_attr($active_item == 'yes' ? 'active' : ''); ?>" style="background-image: url(<?php echo esc_url($image);?>);">
								<div class="content-wrapper">
									<?php if (('yes' == $settings['show_count_number']) && !empty($item['number'])) {?>
										<div class="number">
											<span><?php echo esc_html($item['number']); ?></span>
										</div>
									<?php } ?>
									<?php if (('yes' == $settings['show_icon']) && !empty($item['service_expand_icon']['value'])) { ?>
										<div class="icon-wrap">
											<?php Icons_Manager::render_icon($item['service_expand_icon'], ['aria-hidden' => 'true']) ?>
										</div>
									<?php } ?>
									<?php if(!empty($item['title'])) {?>
										<h4 class="title"><a href="<?php echo esc_url($item['link']['url']); ?>" <?php echo esc_attr($target); ?>><?php echo esc_html($item['title']); ?></a></h4>
									<?php } ?>
									<?php if(!empty($item['description'])) {?>
										<div class="desc">
											<?php echo esc_html($item['description']); ?>
										</div>
									<?php } ?>
									<?php if ('yes' == $settings['button_show_hide']) { ?>
										<div class="btn-part">
											<a class="service-btn" href="<?php echo esc_url($item['link']['url']); ?>" <?php echo esc_attr($target); ?>>
												<?php if(!empty($settings['btn_text'])) {?>
													<span><?php echo esc_html($settings['btn_text']); ?></span>
												<?php }
													Icons_Manager::render_icon($settings['btn__selected_icon'], ['aria-hidden' => 'true']);
												?>
											</a>
										</div>
									<?php } ?>
								</div>
							</div>
						<?php endforeach; ?>
					</div>
				</div>
			<?php } else { ?>
				<!-- Background Part Start -->
				<?php foreach ($settings['services_list'] as $index => $item) :
					$image = wp_get_attachment_image_url( $item['feature_img']['id'], 'full');
					$thumbnail_id = $item['feature_img']['id'];
					$thumbnail_alt = get_post_meta( $thumbnail_id, '_wp_attachment_image_alt', true );
					if ( empty( $thumbnail_alt ) ) {
						$thumbnail_alt = get_the_title( $thumbnail_id );
					}

					if ( ! $image ) {
						$image = Utils::get_placeholder_image_src();
					}
					$thumb_counter++;
					$active_item = $item['active_item'];
				?>
					<img class="the-img <?php echo esc_attr($thumb_counter); ?> <?php echo esc_attr($active_item == 'yes' ? 'active' : ''); ?>" src="<?php echo esc_url( $image ); ?>" alt="<?php echo esc_attr($thumbnail_alt); ?>">
				<?php endforeach; ?>
				<!-- Background Part End -->
	
				<!-- Content Part Start -->
				<div class="service-<?php echo esc_attr($unique); ?> row">
					<?php foreach ($settings['services_list'] as $index => $item) :
						$link = !empty($item['link']['url']) ? $item['link']['url'] : '#';
						$target = $item['link']['is_external'] ? 'target=_blank' : '';
						$counter++;
						$active_item = $item['active_item'];
					?>
						<div class="grid-item item-<?php echo $counter ?> <?php echo ($active_item == 'yes') ? 'active' : ''; ?> col-lg-<?php echo esc_html($settings['column_lg']); ?> col-md-<?php echo esc_html($settings['column_md']); ?> col-sm-<?php echo esc_html($settings['column_sm']); ?>">
							<div class="service-inner">
								<?php if (('yes' == $settings['show_icon']) && !empty($item['service_expand_icon']['value'])) { ?>
									<div class="icon-wrap">
										<?php Icons_Manager::render_icon($item['service_expand_icon'], ['aria-hidden' => 'true']) ?>
									</div>
								<?php } ?>
								<?php if (('yes' == $settings['show_count_number']) && !empty($item['number'])) {?>
									<div class="number">
										<span><?php echo esc_html($item['number']); ?></span>
									</div>
								<?php } ?>
								<?php if(!empty($item['title'])) {?>
									<h3 class="title"><a href="<?php echo esc_url($item['link']['url']); ?>" <?php echo esc_attr($target); ?>><?php echo esc_html($item['title']); ?></a></h3>
								<?php } ?>
								<?php if(!empty($item['description'])) {?>
									<div class="desc">
										<?php echo esc_html($item['description']); ?>
									</div>
								<?php } ?>
								<?php if ('yes' == $settings['button_show_hide']) { ?>
									<div class="btn-part">
										<a class="service-btn" href="<?php echo esc_url($item['link']['url']); ?>" <?php echo esc_attr($target); ?>>
											<?php if(!empty($settings['btn_text'])) {?>
												<span><?php echo esc_html($settings['btn_text']); ?></span>
											<?php }
												Icons_Manager::render_icon($settings['btn__selected_icon'], ['aria-hidden' => 'true']);
											?>
										</a>
									</div>
								<?php } ?>
							</div>
						</div>
					<?php endforeach; ?>
				</div>
				<!-- Content Part End -->
			<?php } ?>
		</div>
		<script>
			jQuery(document).ready(function($) {
				$('.service-<?php echo $unique; ?> .grid-item').mouseenter(function(){
					var $backgrounds = $('.service-parent-<?php echo $unique; ?> img.the-img, .service-parent-<?php echo $unique; ?>  .thumbnail-part');
					var $items = $('.service-<?php echo $unique; ?> .grid-item');

					$backgrounds.removeClass('active');
					$items.removeClass('active');

					var classes = $(this).attr('class');
					var number = classes.split(' ').filter(function(className) {
						return className.startsWith('item-');
					})[0].split('-').pop();

					$backgrounds.eq(number - 1).addClass('active');
					$(this).addClass('active');
				});
				<?php if ('style2' === $settings['service_style']) { ?>
					$('.rs-service-flex.style2 .content-wrapper').each(function() {
						var tiltAmount = 15;
						$(this).on('mouseenter', function() {
							$(this).mousemove(function(e) {
								var xPos = e.pageX - $(this).offset().left;
								var yPos = e.pageY - $(this).offset().top;
								var xAngle = (yPos / $(this).height() - 0.5) * tiltAmount;
								var yAngle = (0.5 - xPos / $(this).width()) * tiltAmount;

								$(this).css({
									'-webkit-transform': 'perspective(500px) rotateX(' + xAngle + 'deg) rotateY(' + yAngle + 'deg)',
									'-moz-transform': 'perspective(500px) rotateX(' + xAngle + 'deg) rotateY(' + yAngle + 'deg)',
									'transform': 'perspective(500px) rotateX(' + xAngle + 'deg) rotateY(' + yAngle + 'deg)'
								});
							});
						}).on('mouseleave', function() {
							$(this).css({
								'-webkit-transform': 'perspective(500px) rotateX(0) rotateY(0)',
								'-moz-transform': 'perspective(500px) rotateX(0) rotateY(0)',
								'transform': 'perspective(500px) rotateX(0) rotateY(0)'
							});
							$(this).off('mousemove');
						});
					});
				<?php } ?>
			});
		</script>
<?php
	}
} ?>