
<?php if ('yes' === $settings['enable_grid_']) { ?>
    <div class="grid-item col-lg-<?php echo esc_attr($settings['service__column_desktop']); ?> col-md-<?php echo esc_attr($settings['service__column_md']); ?>">
<?php } else { ?>
    <div class="grid-item">
<?php } ?>
    <div class="rs-service-slider <?php echo esc_attr($current); ?>"
        <?php if (('post' == $settings['source']) && has_post_thumbnail()) { ?>
            style="
                background: url(<?php echo get_the_post_thumbnail_url( get_the_ID(), 'full' ); ?>) no-repeat center center;
                background-size: cover;
            "
        <?php } else { ?>
            style="
                background: url(<?php echo esc_url( $image ); ?>) no-repeat center center;
                background-size: cover;
            "
        <?php } ?>>
        
        <?php if('icon' !== $item['select_icon_type']) {
            if (!empty($icon_image_id)) { ?>
                <div class="service-img image-type <?php echo esc_attr($img_clippath); ?>">
                    <?php 
                        echo wp_get_attachment_image( $icon_image_id, $settings['thumbnail_size'], false, ['alt' => $icon_image_alt] );
                    ?>
                </div>
            <?php } ?>
        <?php } else {
            if (!empty($item['selected_icon_font']['value'])) { ?>
                <div class="service-img icon-type <?php echo esc_attr($img_clippath); ?>">
                    <?php \Elementor\Icons_Manager::render_icon( $item['selected_icon_font'], [ 'aria-hidden' => 'true' ] ); ?>
                </div>
            <?php }
        } ?>

        <div class="service-title-holder btn_<?php echo $read_more_hover_based; ?>">
            <div class="service-content-area">
            <?php if (!empty($title)) { ?>
                <?php if ('yes' === $settings['show_title']) { ?>
                    <div class="service-title <?php echo $title_hover_underline;?>">
                        <<?php echo esc_attr($title_tag); ?> class="title">
                            <a href="<?php echo esc_url($link); ?>" <?php echo wp_kses_post($target); ?>>
                                <?php echo esc_html($title); ?>
                            </a>
                        </<?php echo esc_attr($title_tag); ?>>
                    </div>
                <?php } ?>
            <?php } ?>

            <?php if (!empty($description)) { ?>
                <?php if ('yes' === $settings['show_desc']) { ?>
                    <div class="service-desc">
                        <?php if (!empty($desc_limit)) {
                                echo wp_trim_words( wp_kses_post($description), $desc_limit, '...' );
                            } else {
                                echo wp_kses_post($description);
                        } ?>
                    </div>
                <?php } ?>
            <?php } ?>
            <?php if (!empty($number) && $number_enable_disable == 'yes') { ?>
                <div class="numbering <?php echo $number_line_css;?>">
                    <span><?php echo esc_html($number);?></span>
                </div>
            <?php } ?>
            <!-- Button Style -->
            <?php if ($settings['show_read'] == 'yes') { ?>
                <div class="read__more">
                    <a href="<?php echo esc_url($link); ?>" <?php echo wp_kses_post($target); ?> class="btn-area">
                        <span class="btn-text"><?php echo esc_html($settings['button_text']); ?></span>
                        <span class="btn-icon"><?php if (!empty($settings['show_read_icon']) && !empty($settings['button_text'])) { ?>
                            <?php \Elementor\Icons_Manager::render_icon($settings['btn_icon'], ['aria-hidden' => 'true']); ?>
                        <?php } ?>
                        </span>
                    </a>
                </div>
            <?php } ?>
            <!-- Button Style End -->
            </div>
        </div>
    </div>
</div>