<?php //******************//
$cat = $settings['team_category'];

$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;

if(empty($cat)){
	$best_wp = new wp_Query(array(
			'post_type'      => 'teams',
			'posts_per_page' => $settings['per_page'],
			'paged'          => $paged					
	));	  
}   
else{
	$best_wp = new wp_Query(array(
			'post_type'      => 'teams',
			'posts_per_page' => $settings['per_page'],
			'paged'          => $paged,
			'tax_query'      => array(
		        array(
					'taxonomy' => 'teams-category',
					'field'    => 'slug', //can be set to ID
					'terms'    => $cat //if field is ID you can reference by cat/term number
		        ),
		    )
	));	  
}

while($best_wp->have_posts()): $best_wp->the_post();

    $designation  = !empty(get_post_meta( get_the_ID(), 'designation', true )) ? get_post_meta( get_the_ID(), 'designation', true ):'';			
    $content = get_the_content();									   
	//retrive social icon values			
	$facebook    = get_post_meta( get_the_ID(), 'facebook', true );
	$twitter     = get_post_meta( get_the_ID(), 'twitter', true );
	$instagram = get_post_meta( get_the_ID(), 'instagram', true );
	$linkedin    = get_post_meta( get_the_ID(), 'linkedin', true );
	$show_phone  = get_post_meta( get_the_ID(), 'phone', true );
	$show_email  = get_post_meta( get_the_ID(), 'email', true );
	
	$fb   ='';
	$tw   ='';
	$ins   ='';
	$ldin ='';

	if($facebook!=''){
		$fb='<a href="'.$facebook.'" class="social-icon"><i class="ri-facebook-fill"></i></a> ';
	}
	if($twitter!=''){
		$tw='<a href="'.$twitter.'" class="social-icon"><i class="ri-twitter-fill"></i></a>';
	}
	if($instagram!=''){
		$ins='<a href="'.$instagram.'" class="social-icon"><i class="ri-instagram-line"></i></a> ';
	}
	if($linkedin!=''){
		$ldin='<a href="'.$linkedin.'" class="social-icon"><i class="ri-linkedin-fill"></i></a>';
	}

?>
	
<div class="team-item">
	<div class="team-inner-wrap">
		<div class="image-wrap">
			<?php if ('yes' == $settings['social_box']) { ?>
				<div class="social-trigger-btn <?php echo esc_attr( $this->get_id() ); ?>">
					<?php if (!empty($settings['trigger_btn_icon']['value'])) {
						\Elementor\Icons_Manager::render_icon( $settings['trigger_btn_icon'], [ 'aria-hidden' => 'true' ] );
					} else { ?>
						<svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18" fill="none"><path d="M17.2501 8.25003H9.75003V0.74999C9.75003 0.335778 9.41425 0 9.00004 0C8.58582 0 8.25004 0.335778 8.25004 0.74999V8.24999H0.749991C0.335779 8.25003 0 8.58581 0 9.00002C0 9.41423 0.335779 9.75001 0.749991 9.75001H8.25001V17.25C8.25001 17.6642 8.58579 18 9 18C9.41421 18 9.74999 17.6642 9.74999 17.25V9.75001H17.25C17.6642 9.75001 18 9.41423 18 9.00002C18.0001 8.58581 17.6643 8.25003 17.2501 8.25003Z"></path></svg>
					<?php } ?>
				</div>
			<?php }
			if(has_post_thumbnail()) {
				$thumbnail_id = get_post_thumbnail_id();
				$thumbnail_alt = get_post_meta( $thumbnail_id, '_wp_attachment_image_alt', true );
				if ( empty( $thumbnail_alt ) ) {
					$thumbnail_alt = get_the_title( $thumbnail_id );
				}?>
				<a <?php echo $settings['team_grid_popup_style'] == 'popup' ? 'class="pointer-events" href="#rs_popupBox4_' . esc_attr($unique) . '" data-effect="mfp-zoom-in"' : 'href="' . get_permalink() . '"'; ?>>
					<?php echo wp_get_attachment_image( $thumbnail_id, $settings['thumbnail_size'], false, ['alt' => $thumbnail_alt] );?>
				</a>
			<?php } ?>
			<?php if ('yes' == $settings['social_box']) {
				 if( $fb || $ins || $tw || $ldin ){ ?>
					<div class="social-icons">
						<?php echo wp_kses_post($fb);
							echo wp_kses_post($ins);
							echo wp_kses_post($tw);
							echo wp_kses_post($ldin);
						?>
		        	</div>
			    <?php }
		    } ?>	
		</div>
		<div class="team-content">
			<?php if(get_the_title()) { ?>
	       		<h4 class="team-name">
				   <a <?php echo $settings['team_grid_popup_style'] == 'popup' ? 'class="pointer-events" href="#rs_popupBox4_' . esc_attr($unique) . '" data-effect="mfp-zoom-in"' : 'href="' . get_permalink() . '"'; ?>>
						<?php the_title(); ?>
					</a>
				</h4>
			<?php } ?>

	        <?php if($designation): ?>
				<span class="team-title"><?php echo esc_html($designation);?></span>
			<?php endif ;
			if( $short_bio ) : ?>
				<p class="team-desc"><?php echo esc_html( $short_bio );?></p>
			<?php endif; ?>
		</div>
	</div>
</div>

<?php
endwhile;
wp_reset_query();  
?>  
