<div class="rs-team-grid rs-team team-grid-<?php echo esc_html($settings['team_grid_style']); ?>  rsaddon_pro_box <?php echo $clip_path_css; ?>">
	<div class="row">
		<?php //******************//
		$x = 1;
		$cat = $settings['team_category'];

		$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;

		if (empty($cat)) {
			$best_wp = new wp_Query(array(
				'post_type'      => 'teams',
				'posts_per_page' => $settings['per_page'],
				'paged'          => $paged,
				'order' 			=> $settings['team_ordering'],
			));
		} else {
			$best_wp = new wp_Query(array(
				'post_type'      => 'teams',
				'posts_per_page' => $settings['per_page'],
				'paged'          => $paged,
				'order' 			=> $settings['team_ordering'],
				'tax_query'      => array(
					array(
						'taxonomy' => 'teams-category',
						'field'    => 'slug', //can be set to ID
						'terms'    => $cat //if field is ID you can reference by cat/term number
					),
				)
			));
		}

		while ($best_wp->have_posts()) : $best_wp->the_post();
			$content = get_the_content();
			$designation  = !empty(get_post_meta(get_the_ID(), 'designation', true)) ? get_post_meta(get_the_ID(), 'designation', true) : '';
			$unique = rand(2012, 3554120);
			//retrive social icon values			
			$facebook    = get_post_meta(get_the_ID(), 'facebook', true);
			$twitter     = get_post_meta(get_the_ID(), 'twitter', true);
			$instagram = get_post_meta(get_the_ID(), 'instagram', true);
			$linkedin    = get_post_meta(get_the_ID(), 'linkedin', true);
			$show_phone  = get_post_meta(get_the_ID(), 'phone', true);
			$show_email  = get_post_meta(get_the_ID(), 'email', true);
			$short_bio   = get_post_meta(get_the_ID(), 'shortbio', true);

			$fb   =	'';
			$tw   =	'';
			$ins   =	'';
			$ldin =	'';

			if ($facebook != '') {
				$fb = '<a href="' . $facebook . '" class="social-icon"><i class="ri-facebook-fill"></i></a> ';
			}
			if ($twitter != '') {
				$tw = '<a href="' . $twitter . '" class="social-icon"><i class="ri-twitter-x-line"></i></a>';
			}
			if ($instagram != '') {
				$ins = '<a href="' . $instagram . '" class="social-icon"><i class="ri-instagram-line"></i></a> ';
			}
			if ($linkedin != '') {
				$ldin = '<a href="' . $linkedin . '" class="social-icon"><i class="ri-linkedin-fill"></i></a>';
			}
		?>
			<div class="col-lg-<?php echo esc_html($settings['team_columns']); ?> col-md-<?php echo esc_attr($settings['team_columns_md']); ?> col-xs-1 team-style-column">
				<div class="team-item">
					<div class="team-inner-wrap">
						<div class="image-wrap">
							<?php if (has_post_thumbnail()) :
								$thumbnail_id = get_post_thumbnail_id();
								$thumbnail_alt = get_post_meta( $thumbnail_id, '_wp_attachment_image_alt', true );
								if ( empty( $thumbnail_alt ) ) {
									$thumbnail_alt = get_the_title( $thumbnail_id );
								}?>
								<a class="pointer-events" href="#rs_popupBox4_<?php echo esc_attr($unique); ?>" data-effect="mfp-zoom-in">
									<?php echo wp_get_attachment_image( $thumbnail_id, $settings['thumbnail_size'], false, ['alt' => $thumbnail_alt] );?>
								</a>
							<?php endif; ?>
							<?php if ('yes' == $settings['social_box']) {
								if( $fb || $ins || $tw || $ldin ){ ?>
									<div class="social-icons">
										<?php echo wp_kses_post($fb);
											echo wp_kses_post($ins);
											echo wp_kses_post($tw);
											echo wp_kses_post($ldin);
										?>
									</div>
								<?php }
							} ?>
						</div>
						<div class="team-content">
							<?php if (get_the_title()) : ?>
								<h4 class="team-name"><?php if ($settings['team_grid_popup_style'] == 'popup') : ?>
										<a class="pointer-events" href="#rs_popupBox4_<?php echo esc_attr($unique); ?>" data-effect="mfp-zoom-in">
										<?php else : ?>
											<a href="<?php the_permalink(); ?>">
											<?php endif; ?>

											<?php the_title(); ?></a>
								</h4>
							<?php endif;

							if ($designation) : ?>
								<span class="team-title"><?php echo esc_html($designation); ?></span>
							<?php endif;
							if ($short_bio) : ?>
								<p class="team-desc"><?php echo esc_html($short_bio); ?></p>
							<?php endif; ?>
							
						</div>
					</div>
				</div>
			</div>

			<!-- Hidden PupupBox Text -->
			<?php

			if ($facebook != '') {
				$fb_popup = '<a href="' . $facebook . '" class="social-icon"><i class="ri-facebook-fill"></i></a> ';
			}
			if ($twitter != '') {
				$tw_popup = '<a href="' . $twitter . '" class="social-icon"><i class="ri-twitter-x-line"></i></a>';
			}
			if ($instagram != '') {
				$ins_popup = '<a href="' . $instagram . '" class="social-icon"><i class="ri-instagram-line"></i></a> ';
			}
			if ($linkedin != '') {
				$ldin_popup = '<a href="' . $linkedin . '" class="social-icon"><i class="ri-linkedin-fill"></i></a>';
			}


			?>

			<div id="rs_popupBox4_<?php echo esc_attr($unique); ?>" class="rspopup_style1  mfp-with-anim mfp-hide" <?php echo wp_kses_post($popup_background); ?>>
				<div class="row">
					<div class="col-md-5">
						<div class="rsteam_img">
							<?php the_post_thumbnail($settings['thumbnail_size']); ?>
						</div>
					</div>
					<div class="col-md-7">
						<div class="rsteam_content">
							<div class="team-content">
								<div class="team-heading">

									<h3 class="team-name" <?php echo wp_kses_post($popup_title_color); ?>><?php the_title(); ?></h3>
									<span class="team-title" <?php echo wp_kses_post($popup_designation_color); ?>><?php echo esc_html($designation); ?></span>
								</div>
								<?php if ($content) : ?>
									<div class="team-des" <?php echo wp_kses_post($popup_content_color); ?>>
										<?php echo esc_html($content); ?>
									</div>
								<?php endif; ?>


								<?php if ($show_phone || $show_email) : ?>
									<div class="contact-info">
										<ul>
											<?php if ($show_phone) : ?>
												<li <?php echo wp_kses_post($popup_phn_email_color); ?>><span><?php echo esc_html('Phone:', 'rsaddon'); ?> </span><?php echo esc_html($show_phone); ?></li>
											<?php endif; ?>

											<?php if ($show_email) : ?>
												<li <?php echo wp_kses_post($popup_phn_email_color); ?>><span><?php echo esc_html('Email:', 'rsaddon'); ?> </span><a href="<?php echo esc_html($show_email); ?>" <?php echo wp_kses_post($popup_phn_email_color); ?>><?php echo esc_html($show_email); ?></a></li>
											<?php endif; ?>
										</ul>
									</div>
								<?php endif; ?>

								<?php if ('yes' == $settings['social_box']) {
									if ($fb || $ins || $tw || $ldin) { ?>
										<div class="rs-social-icons">
											<div class="social-icons1">
												<?php echo wp_kses_post($fb_popup);
												echo wp_kses_post($ins_popup);
												echo wp_kses_post($tw_popup);
												echo wp_kses_post($ldin_popup);
												?>
											</div>
										</div>
									<?php }
								} ?>
							</div>
						</div>
					</div>
				</div>
				<style>
					<?php
					if (isset($social_popup_icon_bg_color) && !empty($social_popup_icon_bg_color)) { ?>.rspopup_style1 .social-icons1 a {
						background-color: <?php echo $social_popup_icon_bg_color; ?>;
					}

					<?php } ?><?php if (isset($popup_social_icon_color) && !empty($popup_social_icon_color)) { ?>.rspopup_style1 .social-icons1 a {
						color: <?php echo $popup_social_icon_color; ?>;
					}

					<?php } ?><?php if (isset($popup_border_color) && !empty($popup_border_color)) { ?>.rspopup_style1 .team-heading {
						border-bottom: 1px solid <?php echo $popup_border_color; ?>;
					}

					<?php } ?><?php if (isset($popup_icon_color) && !empty($popup_icon_color)) { ?>.body .rspopup_style1 .mfp-close {
						color: <?php echo $popup_icon_color; ?>;
					}

					<?php } ?><?php if (isset($popup_icon_bg_color) && !empty($popup_icon_bg_color)) { ?>.body .rspopup_style1 .mfp-close {
						background-color: <?php echo $popup_icon_bg_color; ?>;
					}

					<?php } ?>
				</style>
			</div>


		<?php
			$x++;
		endwhile;
		wp_reset_query();
		?>
	</div>
</div>