<div class="rs-team-grid rs-team team-grid-<?php echo esc_html($settings['team_grid_style']); ?> <?php echo esc_attr($clip_path_css);?>">
    <div class="team-both-wrap">
        <?php 
        $x = 1;
        $cat = $settings['team_category'];              
        $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;

        if (empty($cat)) {
            $best_wp = new WP_Query(array(
                'post_type'      => 'teams',
                'posts_per_page' => $settings['per_page'],
                'order' 			=> $settings['team_ordering'],
                'paged'          => $paged
            ));  
        } else {
            $best_wp = new WP_Query(array(
                'post_type'      => 'teams',
                'posts_per_page' => $settings['per_page'],
                'order' 			=> $settings['team_ordering'],
                'paged'          => $paged,
                'tax_query'      => array(
                    array(
                        'taxonomy' => 'teams-category',
                        'field'    => 'slug',
                        'terms'    => $cat
                    ),
                )
            ));  
        }
        $counter = 0;
        $thumb_counter = 0;
        $unique = $this->get_id() . '-' . rand(155, 989);
        ?>

        <div class="team_acc_feature_image team-<?php echo esc_attr($unique); ?>">
            <?php 
            while ($best_wp->have_posts()): $best_wp->the_post();
                $thumb_counter++;
                $first_item_active = ($thumb_counter == 1) ? 'active' : '';

				$thumbnail_id = get_post_thumbnail_id();
				$thumbnail_alt = get_post_meta( $thumbnail_id, '_wp_attachment_image_alt', true );
				if ( empty( $thumbnail_alt ) ) {
					$thumbnail_alt = get_the_title( $thumbnail_id );
				}
            ?>
				<?php echo wp_get_attachment_image( 
					$thumbnail_id, 
					$settings['thumbnail_size'], 
					false, 
					[
						'alt' => $thumbnail_alt, 
						'class' => esc_attr($thumb_counter) . ' ' . esc_attr($first_item_active)
					] 
				); ?>
            <?php endwhile; ?>
        </div>

        <div class="team-accordion accordion team-<?php echo esc_attr($unique); ?>" id="team_accordion_inner_<?php echo esc_attr($unique); ?>">
            <?php
            while ($best_wp->have_posts()): $best_wp->the_post();                    
                $content = get_the_content();    
                $designation = !empty(get_post_meta(get_the_ID(), 'designation', true)) ? get_post_meta(get_the_ID(), 'designation', true) : '';
                $description = !empty(get_post_meta(get_the_ID(), 'description', true)) ? get_post_meta(get_the_ID(), 'description', true) : '';
                
                $i = rand(20212, 351820);
                $counter++;
                $first_item_collapsed = ($counter !== 1) ? 'collapsed' : '';
                $first_item_show = ($counter == 1) ? 'show' : '';
            ?>          
            <div class="accordion-item item-<?php echo esc_attr($counter); ?>">
                <div class="accordion-header" id="heading<?php echo $i; ?>">
                    <h4 class="team-acc-btn <?php echo $first_item_collapsed; ?>" data-bs-toggle="collapse" data-bs-target="#collapse_<?php echo $i; ?>" aria-controls="collapse_<?php echo $i; ?>">
                        <?php the_title(); ?>
                    </h4>
                </div>
                <div id="collapse_<?php echo esc_attr($i); ?>" class="accordion-collapse collapse <?php echo esc_attr($first_item_show); ?>" aria-labelledby="heading<?php echo esc_attr($i); ?>" data-bs-parent="#team_accordion_inner_<?php echo esc_attr($unique); ?>">
                    <div class="accordion-body">
                        <?php if (!empty($designation) && ('yes' == $settings['show_designation'])) { ?>
                            <div class="desig"><?php echo esc_html($designation); ?></div>
                        <?php }

						if (!empty($description) && ('yes' == $settings['show_desc'])) { ?>
                            <div class="desc"><?php echo wp_kses_post($description); ?></div>
                        <?php }

                        if (!empty($settings['read_more_text'])) {
                            if ('yes' == $settings['show_button']) { ?>
                                <div class="rs_btn">
                                    <a href="<?php the_permalink(); ?>">
                                        <?php
                                            echo esc_html($settings['read_more_text']);
                                            \Elementor\Icons_Manager::render_icon( $settings['btn_icon'], [ 'aria-hidden' => 'true' ] );
                                        ?>
                                    </a>
                                </div>
                            <?php }
                        } ?>
                    </div>
                </div>
            </div>
            <?php
				endwhile;
				wp_reset_query();
			?>
        </div>

        <script>
            jQuery(document).ready(function($) {
                $('.team-<?php echo esc_attr($unique); ?> .accordion-item').click(function() {
                    $('.team-<?php echo esc_attr($unique); ?>.team_acc_feature_image img').removeClass('active');
                    var number = $(this).attr('class').split(' ').pop().split('-').pop();
                    $('.team-<?php echo esc_attr($unique); ?>.team_acc_feature_image img.' + number).addClass('active');
                });
            });
        </script>
    </div>
</div>
