<?php

/**
 * Logo widget class
 *
 */

use Elementor\Repeater;
use Elementor\Utils;
use Elementor\Control_Media;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Image_Size;
use Elementor\POPOVER_TOGGLE;
use Elementor\Icons_Manager;

defined('ABSPATH') || die();

class Rsaddon_Elementor_pro_RS_Testimonial_Slider_Widget extends \Elementor\Widget_Base
{
    /**
     * Get widget name.
     *
     * Retrieve rsgallery widget name.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget name.
     */

    public function get_name()
    {
        return 'rs-testimonial-slider';
    }

    /**
     * Get widget title.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget title.
     */

    public function get_title()
    {
        return esc_html__('RS Testimonial Slider', 'rsaddon');
    }

    /**
     * Get widget icon.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon()
    {
        return 'rs-badge';
    }


    public function get_categories()
    {
        return ['rsaddon_category'];
    }

    public function get_keywords()
    {
        return ['testimonial_slider'];
    }


    protected function register_controls()
    {

        $this->start_controls_section(
            '_section_logo',
            [
                'label' => esc_html__('Testimonial Item', 'rsaddon'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
            $this->add_control(
                'testimonial_style',
                [
                    'label'   => esc_html__( 'Testimonial Style', 'rsaddon' ),
                    'type'    => Controls_Manager::SELECT,
                    'default' => '1',
                    'options' => [					
                        '1' => esc_html__( 'Style 1', 'rsaddon'),
                        '2' => esc_html__( 'Style 2', 'rsaddon'),
                        '3' => esc_html__( 'Style 3', 'rsaddon')
                    ],
                ]
            );
            $this->add_control(
                'testimonial_type_sl_grid',
                [
                    'label'   => esc_html__( 'Type', 'rsaddon' ),
                    'type'    => Controls_Manager::SELECT,
                    'default' => 'slider',
                    'options' => [					
                        'slider' => esc_html__( 'Slider', 'rsaddon'),
                        'grid' => esc_html__( 'Grid', 'rsaddon')
                    ],
                ]
            );
            $this->add_control(
                'testimonial_quote_icon',
                [
                    'label' => __( 'Icon', 'rsaddon' ),
                    'type' => Controls_Manager::ICONS,
                    'default' => [
                        'value' => 'fas fa-quote-right',
                        'library' => 'fa-solid',
                    ],
                ]
            );
            $this->add_control(
                'ratings_show',
                [
                    'label' => esc_html__( 'Ratings Show', 'rsaddon' ),
                    'type' => Controls_Manager::SWITCHER,
                    'label_on' => esc_html__( 'Show', 'rsaddon' ),
                    'label_off' => esc_html__( 'Hide', 'rsaddon' ),
                    'return_value' => 'yes',
                    'default' => 'yes',
                    'separator' => 'before',
                ]
            );
            $this->add_control(
                'title_show',
                [
                    'label' => esc_html__( 'Title Show', 'rsaddon' ),
                    'type' => Controls_Manager::SWITCHER,
                    'label_on' => esc_html__( 'Show', 'rsaddon' ),
                    'label_off' => esc_html__( 'Hide', 'rsaddon' ),
                    'return_value' => 'yes',
                    'default' => 'no',
                ]
            );
            $this->add_control(
                'company_logo_show',
                [
                    'label' => esc_html__( 'Company Logo Show', 'rsaddon' ),
                    'type' => Controls_Manager::SWITCHER,
                    'label_on' => esc_html__( 'Show', 'rsaddon' ),
                    'label_off' => esc_html__( 'Hide', 'rsaddon' ),
                    'return_value' => 'yes',
                    'default' => 'no',
                ]
            );
            $this->add_control(
                'thumbnail_slider',
                [
                    'label' => esc_html__( 'Thumbnail Slider', 'rsaddon' ),
                    'type' => Controls_Manager::SWITCHER,
                    'label_on' => esc_html__( 'Yes', 'rsaddon' ),
                    'label_off' => esc_html__( 'No', 'rsaddon' ),
                    'return_value' => 'yes',
                    'default' => 'no',
                    'condition' => [
                        'testimonial_style' => '1',
                        'testimonial_type_sl_grid' => 'slider'
                    ]
                ]
            );
            $this->add_control(
                'separator_content',
                [
                    'label' => esc_html__('Separator', 'rsaddon'),
                    'type' => Controls_Manager::TEXT,
                    'default' => esc_html__('/', 'rsaddon'),
                    'label_block' => true,
                    'placeholder' => esc_html__('Separator ( / )', 'rsaddon'),
                    'separator'   => 'before',
                    'condition' => [
                        'testimonial_style' => '3'
                    ]
                ]
            );
            $repeater = new Repeater();
            $repeater->add_control(
                'vendor_image',
                [
                    'label' => esc_html__('Vendor Image', 'rsaddon'),
                    'type' => Controls_Manager::MEDIA,
                    'default' => [
                        'url' => Utils::get_placeholder_image_src(),
                    ],
                ]
            );
            $repeater->add_control(
                'name',
                [
                    'label' => esc_html__('Name', 'rsaddon'),
                    'type' => Controls_Manager::TEXT,
                    'default' => esc_html__('', 'rsaddon'),
                    'label_block' => true,
                    'placeholder' => esc_html__('Name', 'rsaddon'),
                    'separator'   => 'before',
                ]
            );
            $repeater->add_control(
                'description',
                [
                    'label' => esc_html__('Description', 'rsaddon'),
                    'type' => Controls_Manager::TEXTAREA,
                    'default' => esc_html__('', 'rsaddon'),
                    'label_block' => true,
                    'placeholder' => esc_html__('Description', 'rsaddon'),
                    'separator'   => 'before',
                ]
            );
            $repeater->add_control(
                'designation',
                [
                    'label' => esc_html__('Designation', 'rsaddon'),
                    'type' => Controls_Manager::TEXT,
                    'default' => esc_html__('', 'rsaddon'),
                    'label_block' => true,
                    'placeholder' => esc_html__('Designation', 'rsaddon'),
                    'separator'   => 'before',
                ]
            );
            $repeater->add_control(
                'title',
                [
                    'label' => esc_html__('Title', 'rsaddon'),
                    'type' => Controls_Manager::TEXT,
                    'default' => esc_html__('', 'rsaddon'),
                    'label_block' => true,
                    'placeholder' => esc_html__('Title Here', 'rsaddon'),
                    'separator'   => 'before',
                ]
            );
            $repeater->add_control(
                'ratings',
                [
                    'label' => esc_html__( 'Rating', 'rsaddon' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => '4.5',
                    'options' => [
                        '1' => esc_html__( '1', 'rsaddon' ),
                        '1.5'  => esc_html__( '1.5', 'rsaddon' ),
                        '2' => esc_html__( '2', 'rsaddon' ),
                        '2.5' => esc_html__( '2.5', 'rsaddon' ),
                        '3' => esc_html__( '3', 'rsaddon' ),
                        '3.5' => esc_html__( '3.5', 'rsaddon' ),
                        '4' => esc_html__( '4', 'rsaddon' ),
                        '4.5' => esc_html__( '4.5', 'rsaddon' ),
                        '5' => esc_html__( '5', 'rsaddon' ),
                    ],
                ]
            );
            $repeater->add_control(
                'company_logo',
                [
                    'label' => esc_html__('Company Logo', 'rsaddon'),
                    'type' => Controls_Manager::MEDIA,
                    'default' => [
                        'url' => Utils::get_placeholder_image_src(),
                    ],
                ]
            );
            $this->add_control(
                'testi_list',
                [
                    'show_label' => false,
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $repeater->get_controls(),
                    'title_field' => '{{{ name }}}',
                    'default' => [
                        [
                            'name' => esc_html__( 'Abdur Rashid', 'rsaddon' ),
                            'description' => esc_html__( "Holly is one of the best content writers I've ever worked with. Her ability to write clearly and help the reader achieve their goals is remarkable.", 'rsaddon' ),
                            'designation' => esc_html__( "Founder & CEO", 'rsaddon' ),
                        ],
                        [
                            'name' => esc_html__( 'Brish Jhonson', 'rsaddon' ),
                            'description' => esc_html__( "Holly is one of the best content writers I've ever worked with. Her ability to write clearly and help the reader achieve their goals is remarkable.", 'rsaddon' ),
                            'designation' => esc_html__( "Web Developer", 'rsaddon' ),
                        ],
                        [
                            'name' => esc_html__( 'Marry Jaen', 'rsaddon' ),
                            'description' => esc_html__( "Holly is one of the best content writers I've ever worked with. Her ability to write clearly and help the reader achieve their goals is remarkable.", 'rsaddon' ),
                            'designation' => esc_html__( "Web Designer", 'rsaddon' ),
                        ],
                        [
                            'name' => esc_html__( 'Alen Walker', 'rsaddon' ),
                            'description' => esc_html__( "Holly is one of the best content writers I've ever worked with. Her ability to write clearly and help the reader achieve their goals is remarkable.", 'rsaddon' ),
                            'designation' => esc_html__( "Manager", 'rsaddon' ),
                        ],
                    ]
                ]
            );
            $this->add_control(
                'right_clip_path_enable',
                [
                    'label' => esc_html__( 'Clip Path Enable?', 'rsaddon' ),
                    'type' => Controls_Manager::SWITCHER,
                    'label_on' => esc_html__( 'Show', 'rsaddon' ),
                    'label_off' => esc_html__( 'Hide', 'rsaddon' ),
                    'return_value' => 'yes',
                    'default' => 'no',
                    'condition' => [
                        'testimonial_style' => '1'
                    ],
                ]
            );
        $this->end_controls_section();

        // Slider Setting Start
        $this->start_controls_section(
			'content_slider',
			[
				'label' => esc_html__('Slider Settings', 'rsaddon'),
				'tab' => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'testimonial_type_sl_grid' => 'slider'
                ]
			]
		);
            $this->add_control(
                'col_desktop',
                [
                    'label'   => esc_html__('Desktops Above 1200px', 'rsaddon'),
                    'type'    => Controls_Manager::SELECT,
                    'label_block' => true,
                    'default' => 3,
                    'options' => [
                        '1' => esc_html__('1 Column', 'rsaddon'),
                        '2' => esc_html__('2 Column', 'rsaddon'),
                        '3' => esc_html__('3 Column', 'rsaddon'),
                        '4' => esc_html__('4 Column', 'rsaddon'),
                        '5' => esc_html__('5 Column', 'rsaddon'),
                        '6' => esc_html__('6 Column', 'rsaddon'),
                        'auto' => esc_html__('Auto', 'rsaddon'),
                    ],
                    'separator' => 'before',
                ]
            );
            $this->add_control(
                'slide_space_between',
                [
                    'label' => esc_html__( 'Desktop Space Between', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'default' => [
                        'size' => 30,
                    ],
                ]
            );
            $this->add_control(
                'col_lg',
                [
                    'label'   => esc_html__('Large 1199px to 992px', 'rsaddon'),
                    'type'    => Controls_Manager::SELECT,
                    'label_block' => true,
                    'default' => 3,
                    'options' => [
                        '1' => esc_html__('1 Column', 'rsaddon'),
                        '2' => esc_html__('2 Column', 'rsaddon'),
                        '3' => esc_html__('3 Column', 'rsaddon'),
                        '4' => esc_html__('4 Column', 'rsaddon'),
                        '5' => esc_html__('5 Column', 'rsaddon'),
                        '6' => esc_html__('6 Column', 'rsaddon'),
                        'auto' => esc_html__('Auto', 'rsaddon'),
                    ],
                    'separator' => 'before',
                ]
            );
            $this->add_control(
                'slide_space_between_lg',
                [
                    'label' => esc_html__( 'Large Space Between', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'default' => [
                        'size' => 30,
                    ],
                ]
            );
            $this->add_control(
                'col_md',
                [
                    'label'   => esc_html__('Medium 991px to 768px', 'rsaddon'),
                    'type'    => Controls_Manager::SELECT,
                    'label_block' => true,
                    'default' => 3,
                    'options' => [
                        '1' => esc_html__('1 Column', 'rsaddon'),
                        '2' => esc_html__('2 Column', 'rsaddon'),
                        '3' => esc_html__('3 Column', 'rsaddon'),
                        '4' => esc_html__('4 Column', 'rsaddon'),
                        '6' => esc_html__('6 Column', 'rsaddon'),
                        'auto' => esc_html__('Auto', 'rsaddon'),
                    ],
                    'separator' => 'before',
                ]
            );
            $this->add_control(
                'slide_space_between_md',
                [
                    'label' => esc_html__( 'Medium Space Between', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'default' => [
                        'size' => 30,
                    ],
                ]
            );
            $this->add_control(
                'col_sm',
                [
                    'label'   => esc_html__('Small 767px to 576px', 'rsaddon'),
                    'type'    => Controls_Manager::SELECT,
                    'label_block' => true,
                    'default' => 2,
                    'options' => [
                        '1' => esc_html__('1 Column', 'rsaddon'),
                        '2' => esc_html__('2 Column', 'rsaddon'),
                        '3' => esc_html__('3 Column', 'rsaddon'),
                        '4' => esc_html__('4 Column', 'rsaddon'),
                        '6' => esc_html__('6 Column', 'rsaddon'),
                        'auto' => esc_html__('Auto', 'rsaddon'),
                    ],
                    'separator' => 'before',
                ]
            );
            $this->add_control(
                'slide_space_between_sm',
                [
                    'label' => esc_html__( 'Small Space Between', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'default' => [
                        'size' => 30,
                    ],
                ]
            );
            $this->add_control(
                'col_xs',
                [
                    'label'   => esc_html__('Mobile Below 575px', 'rsaddon'),
                    'type'    => Controls_Manager::SELECT,
                    'label_block' => true,
                    'default' => 1,
                    'options' => [
                        '1' => esc_html__('1 Column', 'rsaddon'),
                        '2' => esc_html__('2 Column', 'rsaddon'),
                        '3' => esc_html__('3 Column', 'rsaddon'),
                        '4' => esc_html__('4 Column', 'rsaddon'),
                        '6' => esc_html__('6 Column', 'rsaddon'),
                        'auto' => esc_html__('Auto', 'rsaddon'),
                    ],
                    'separator' => 'before',
                ]
            );
            $this->add_control(
                'slide_space_between_xs',
                [
                    'label' => esc_html__( 'Mobile Space Between', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'default' => [
                        'size' => 10,
                    ],
                ]
            );
            $this->add_control(
                'slides_ToScroll',
                [
                    'label'   => esc_html__('Slide To Scroll', 'rsaddon'),
                    'type'    => Controls_Manager::SELECT,
                    'default' => 2,
                    'options' => [
                        '1' => esc_html__('1 Item', 'rsaddon'),
                        '2' => esc_html__('2 Item', 'rsaddon'),
                        '3' => esc_html__('3 Item', 'rsaddon'),
                        '4' => esc_html__('4 Item', 'rsaddon'),
                    ],
                    'separator' => 'before',
                ]
            );

            $this->add_control(
                'slider_speed',
                [
                    'label'   => esc_html__('Slide Transition', 'rsaddon'),
                    'type'    => Controls_Manager::SELECT,
                    'default' => 500,
                    'options' => [
                        '300' => esc_html__('300 ms', 'rsaddon'),
                        '500' => esc_html__('500 ms', 'rsaddon'),
                        '700' => esc_html__('700 ms', 'rsaddon'),
                        '1000' => esc_html__('1000 ms', 'rsaddon'),
                        '1500' => esc_html__('1500 ms', 'rsaddon'),
                        '2000' => esc_html__('2000 ms', 'rsaddon'),
                        '2500' => esc_html__('2500 ms', 'rsaddon'),
                        '3000' => esc_html__('3000 ms', 'rsaddon'),
                        '3500' => esc_html__('3500 ms', 'rsaddon'),
                        '4000' => esc_html__('4000 ms', 'rsaddon'),
                        '4500' => esc_html__('4500 ms', 'rsaddon'),
                        '5000' => esc_html__('5000 ms', 'rsaddon'),
                    ],
                    'separator' => 'before',
                ]
            );

            $this->add_control(
                'slider_direction',
                [
                    'label'   => esc_html__('Direction', 'rsaddon'),
                    'type'    => Controls_Manager::SELECT,
                    'default' => '',
                    'options' => [
                        '' => esc_html__('Left', 'rsaddon'),
                        'right' => esc_html__('Right', 'rsaddon'),
                    ],
                    'separator' => 'before',
                ]
            );

            $this->add_control(
                'slider_effect',
                [
                    'label'   => esc_html__('Slide Effect', 'rsaddon'),
                    'type'    => Controls_Manager::SELECT,
                    'default' => '',
                    'options' => [
                        '' => esc_html__('Default', 'rsaddon'),
                        'fade' => esc_html__('Fade', 'rsaddon'),
                        'cube' => esc_html__('Cube', 'rsaddon'),
                        'coverflow' => esc_html__('Coverflow', 'rsaddon'),
                        'flip' => esc_html__('Flip', 'rsaddon'),
                        'cards' => esc_html__('Cards', 'rsaddon'),
                        'creative' => esc_html__('Creative', 'rsaddon'),
                    ],
                    'separator' => 'before',
                ]
            );
            $this->add_control(
                'slider_creative_style',
                [
                    'label'   => esc_html__('Creative Style', 'rsaddon'),
                    'type'    => Controls_Manager::SELECT,
                    'default' => '',
                    'options' => [
                        '' => esc_html__('One', 'rsaddon'),
                        'two' => esc_html__('Two', 'rsaddon'),
                        'three' => esc_html__('Three', 'rsaddon'),
                        'four' => esc_html__('Four', 'rsaddon')
                    ],
                    'condition' => [
                        'slider_effect' => 'creative'
                    ],
                ]
            );
            $this->add_control(
                'slider_effect_warning',
                [
                    'type'            => Controls_Manager::RAW_HTML,
                    'raw'             => __('The <strong>cube effect</strong> may not function correctly when displaying more than <strong>one item</strong> simultaneously.', 'rsaddon'),
                    'content_classes' => 'rs-panel-notice',
                    'condition' => [
                        'col_desktop!' => '1',
                        'slider_effect' => 'cube'
                    ]
                ]
            );
            $this->add_control(
                'slider_dots',
                [
                    'label'   => esc_html__('Navigation Bullets', 'rsaddon'),
                    'type'    => Controls_Manager::SELECT,
                    'default' => 'false',
                    'options' => [
                        'true' => esc_html__('Enable', 'rsaddon'),
                        'false' => esc_html__('Disable', 'rsaddon'),
                    ],
                    'separator' => 'before',
                ]

            );
            $this->add_control(
                'slider_bullet_type',
                [
                    'label'   => esc_html__('Bullets Type', 'rsaddon'),
                    'type'    => Controls_Manager::SELECT,
                    'default' => '',
                    'options' => [
                        '' => esc_html__('Dots', 'rsaddon'),
                        'progressbar' => esc_html__('Progressbar', 'rsaddon'),
                        'fraction' => esc_html__('Fraction Number', 'rsaddon'),
                    ],
                    'condition' => [
                        'slider_dots' => 'true',
                    ]
                ]

            );
            $this->add_control(
                'slider_dynamic_bullets',
                [
                    'label'   => esc_html__('Dynamic Bullets', 'rsaddon'),
                    'type'    => Controls_Manager::SELECT,
                    'default' => 'false',
                    'options' => [
                        'true' => esc_html__('Enable', 'rsaddon'),
                        'false' => esc_html__('Disable', 'rsaddon'),
                    ],
                    'condition' => [
                        'slider_dots' => 'true',
                        'slider_bullet_type!' => ['progressbar', 'fraction']
                    ]
                ]
            );
            $this->add_control(
                'slider_dots_style',
                [
                    'label'   => esc_html__('Bullets Style', 'rsaddon'),
                    'type'    => Controls_Manager::SELECT,
                    'default' => 'default',
                    'options' => [
                        'default' => esc_html__('Default', 'rsaddon'),
                        '2' => esc_html__('Style 2', 'rsaddon')
                    ],
                    'condition' => [
                        'slider_dots' => 'true',
                        'slider_bullet_type!' => ['progressbar', 'fraction']
                    ]
                ]
            );
            $this->add_control(
                'slider_nav',
                [
                    'label'   => esc_html__('Navigation Nav', 'rsaddon'),
                    'type'    => Controls_Manager::SELECT,
                    'default' => 'false',
                    'options' => [
                        'true' => esc_html__('Enable', 'rsaddon'),
                        'false' => esc_html__('Disable', 'rsaddon'),
                    ],
                    'separator' => 'before',
                ]

            );
            $this->add_control(
                'slider_nav_icon_style',
                [
                    'label'   => esc_html__('Nav Icon Style', 'rsaddon'),
                    'type'    => Controls_Manager::SELECT,
                    'default' => '',
                    'options' => [
                        '' => esc_html__('Style 1', 'rsaddon'),
                        '2' => esc_html__('Style 2', 'rsaddon'),
                    ],
                    'condition' => [
                        'slider_nav' => 'true'
                    ]
                ]

            );
            $this->add_control(
                'slider_scrollbar',
                [
                    'label'   => esc_html__('Scrollbar', 'rsaddon'),
                    'type'    => Controls_Manager::SELECT,
                    'default' => 'false',
                    'options' => [
                        'true' => esc_html__('Enable', 'rsaddon'),
                        'false' => esc_html__('Disable', 'rsaddon'),
                    ],
                    'separator' => 'before',
                ]
            );
            $this->add_control(
                'slider_scrollbar_warning',
                [
                    'type'            => Controls_Manager::RAW_HTML,
                    'raw'             => __('The <strong>Scrollbar</strong> functionality may not operate as expected when the <strong>loop</strong>  feature is enabled.', 'rsaddon'),
                    'content_classes' => 'rs-panel-notice',
                    'condition' => [
                        'slider_loop' => 'true',
                        'slider_scrollbar' => 'true'
                    ]
                ]
            );
            $this->add_control(
                'slider_autoplay',
                [
                    'label'   => esc_html__('Autoplay', 'rsaddon'),
                    'type'    => Controls_Manager::SELECT,
                    'default' => 'false',
                    'options' => [
                        'true' => esc_html__('Enable', 'rsaddon'),
                        'false' => esc_html__('Disable', 'rsaddon'),
                    ],
                    'separator' => 'before',

                ]
            );
            $this->add_control(
                'slide_item_circle_progress',
                [
                    'label'   => esc_html__('Auto Play Progress', 'rsaddon'),
                    'type'    => Controls_Manager::SELECT,
                    'default' => 'false',
                    'options' => [
                        'true' => esc_html__('Enable', 'rsaddon'),
                        'false' => esc_html__('Disable', 'rsaddon'),
                    ],
                    'condition' => [
                        'slider_autoplay' => 'true'
                    ]
                ]
            );
            $this->add_control(
                'slider_stop_on_hover',
                [
                    'label'   => esc_html__('Stop on Hover', 'rsaddon'),
                    'type'    => Controls_Manager::SELECT,
                    'default' => 'false',
                    'options' => [
                        'true' => esc_html__('Enable', 'rsaddon'),
                        'false' => esc_html__('Disable', 'rsaddon'),
                    ],
                    'condition' => [
                        'slider_autoplay' => 'true'
                    ]
                ]
            );
            $this->add_control(
                'slider_interval',
                [
                    'label'   => esc_html__('Autoplay Interval', 'rsaddon'),
                    'type'    => Controls_Manager::SELECT,
                    'default' => 3000,
                    'options' => [
                        '500' => esc_html__('500 ms', 'rsaddon'),
                        '700' => esc_html__('700 ms', 'rsaddon'),
                        '1000' => esc_html__('1000 ms', 'rsaddon'),
                        '1500' => esc_html__('1500 ms', 'rsaddon'),
                        '2000' => esc_html__('2000 ms', 'rsaddon'),
                        '2500' => esc_html__('2500 ms', 'rsaddon'),
                        '3000' => esc_html__('3000 ms', 'rsaddon'),
                        '3500' => esc_html__('3500 ms', 'rsaddon'),
                        '4000' => esc_html__('4000 ms', 'rsaddon'),
                        '4500' => esc_html__('4500 ms', 'rsaddon'),
                        '5000' => esc_html__('5000 ms', 'rsaddon'),
                        '5500' => esc_html__('5500 ms', 'rsaddon'),
                        '6000' => esc_html__('6000 ms', 'rsaddon'),
                        '6500' => esc_html__('6500 ms', 'rsaddon'),
                        '7000' => esc_html__('7000 ms', 'rsaddon'),
                        '7500' => esc_html__('7500 ms', 'rsaddon'),
                        '8000' => esc_html__('8000 ms', 'rsaddon'),
                        '8500' => esc_html__('8500 ms', 'rsaddon'),
                        '9000' => esc_html__('9000 ms', 'rsaddon'),
                        '9500' => esc_html__('9500 ms', 'rsaddon'),
                        '10000' => esc_html__('10000 ms', 'rsaddon'),
                    ],
                    'condition' => [
                        'slider_autoplay' => 'true'
                    ]
                ]
            );
            $this->add_control(
                'slider_loop',
                [
                    'label'   => esc_html__('Loop', 'rsaddon'),
                    'type'    => Controls_Manager::SELECT,
                    'default' => 'true',
                    'options' => [
                        'true' => esc_html__('Enable', 'rsaddon'),
                        'false' => esc_html__('Disable', 'rsaddon'),
                    ],
                    'separator' => 'before',
                ]
            );
            $this->add_control(
                'slider_auto_height',
                [
                    'label'   => esc_html__('Auto Height', 'rsaddon'),
                    'type'    => Controls_Manager::SELECT,
                    'default' => 'false',
                    'options' => [
                        'true' => esc_html__('Enable', 'rsaddon'),
                        'false' => esc_html__('Disable', 'rsaddon'),
                    ],
                    'separator' => 'before',
                ]
            );
            $this->add_control(
                'slider_free_mode',
                [
                    'label'   => esc_html__('Free Mode', 'rsaddon'),
                    'type'    => Controls_Manager::SELECT,
                    'default' => 'false',
                    'options' => [
                        'true' => esc_html__('Enable', 'rsaddon'),
                        'false' => esc_html__('Disable', 'rsaddon'),
                    ],
                    'separator' => 'before',
                ]
            );
            $this->add_control(
                'slider_grab_cursor',
                [
                    'label'   => esc_html__('Grab Cursor', 'rsaddon'),
                    'type'    => Controls_Manager::SELECT,
                    'default' => 'false',
                    'options' => [
                        'true' => esc_html__('Enable', 'rsaddon'),
                        'false' => esc_html__('Disable', 'rsaddon'),
                    ],
                    'separator' => 'before',
                ]
            );
            $this->add_control(
                'slider_mousewheel',
                [
                    'label'   => esc_html__('Mousewheel', 'rsaddon'),
                    'type'    => Controls_Manager::SELECT,
                    'default' => 'false',
                    'options' => [
                        'true' => esc_html__('Enable', 'rsaddon'),
                        'false' => esc_html__('Disable', 'rsaddon'),
                    ],
                    'separator' => 'before',
                ]
            );
            $this->add_control(
                'slider_keyboard_control',
                [
                    'label'   => esc_html__('Keyboard Control', 'rsaddon'),
                    'type'    => Controls_Manager::SELECT,
                    'default' => 'false',
                    'options' => [
                        'true' => esc_html__('Enable', 'rsaddon'),
                        'false' => esc_html__('Disable', 'rsaddon'),
                    ],
                    'separator' => 'before',
                ]
            );
            $this->add_control(
                'slider_centerMode',
                [
                    'label'   => esc_html__('Center Mode', 'rsaddon'),
                    'type'    => Controls_Manager::SELECT,
                    'default' => 'false',
                    'options' => [
                        'true' => esc_html__('Enable', 'rsaddon'),
                        'false' => esc_html__('Disable', 'rsaddon'),
                    ],
                    'separator' => 'before',
                ]
            );
            $this->add_control(
                'slider_slider_center_mode_warning',
                [
                    'type'            => Controls_Manager::RAW_HTML,
                    'raw'             => __("If <strong>center mode</strong> doesn't work as expected, enable the <strong>loop</strong> feature and ensure there are <strong>enough items</strong> to center one properly.", 'rsaddon'),
                    'content_classes' => 'rs-panel-notice',
                    'condition' => [
                        'slider_centerMode' => 'true'
                    ]
                ]
            );
            $this->add_control(
                'swiper_item_wrapper_padding',
                [
                    'label' => esc_html__( 'Swiper Wrapper Padding', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-addon-slider .swiper-wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                    'separator' => 'before',
                ]
            );
		$this->end_controls_section();
        // Slider Setting End

        // Grid Setting Start
        $this->start_controls_section(
			'grid_setting',
			[
				'label' => esc_html__('Grid Settings', 'rsaddon'),
				'tab' => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'testimonial_type_sl_grid' => 'grid'
                ]
			]
		);
            $this->add_control(
                'grid_col_xl',
                [
                    'label'   => esc_html__('Desktops > 1200px', 'rsaddon'),
                    'type'    => Controls_Manager::SELECT,
                    'default' => 3,
                    'options' => [
                        '12' => esc_html__('1 Column', 'rsaddon'),
                        '6' => esc_html__('2 Column', 'rsaddon'),
                        '4' => esc_html__('3 Column', 'rsaddon'),
                        '3' => esc_html__('4 Column', 'rsaddon'),
                        '2' => esc_html__('6 Column', 'rsaddon'),
                    ],
                ]
            );
            $this->add_control(
                'grid_col_lg',
                [
                    'label'   => esc_html__('Desktops < 1199px', 'rsaddon'),
                    'type'    => Controls_Manager::SELECT,
                    'default' => 3,
                    'options' => [
                        '12' => esc_html__('1 Column', 'rsaddon'),
                        '6' => esc_html__('2 Column', 'rsaddon'),
                        '4' => esc_html__('3 Column', 'rsaddon'),
                        '3' => esc_html__('4 Column', 'rsaddon'),
                        '2' => esc_html__('6 Column', 'rsaddon'),
                    ],
                ]
            );
            $this->add_control(
                'grid_col_md',
                [
                    'label'   => esc_html__('Desktops < 991px', 'rsaddon'),
                    'type'    => Controls_Manager::SELECT,
                    'default' => 4,
                    'options' => [
                        '12' => esc_html__('1 Column', 'rsaddon'),
                        '6' => esc_html__('2 Column', 'rsaddon'),
                        '4' => esc_html__('3 Column', 'rsaddon'),
                        '3' => esc_html__('4 Column', 'rsaddon'),
                        '2' => esc_html__('6 Column', 'rsaddon'),
                    ],
                ]
            );
            $this->add_control(
                'grid_col_sm',
                [
                    'label'   => esc_html__('Tablets < 767px', 'rsaddon'),
                    'type'    => Controls_Manager::SELECT,
                    'default' => 2,
                    'options' => [
                        '12' => esc_html__('1 Column', 'rsaddon'),
                        '6' => esc_html__('2 Column', 'rsaddon'),
                        '4' => esc_html__('3 Column', 'rsaddon'),
                        '3' => esc_html__('4 Column', 'rsaddon'),
                        '2' => esc_html__('6 Column', 'rsaddon'),
                    ],
                ]
            );
            $this->add_control(
                'grid_col_xs',
                [
                    'label'   => esc_html__('Tablets < 575px', 'rsaddon'),
                    'type'    => Controls_Manager::SELECT,
                    'default' => 1,
                    'options' => [
                        '12' => esc_html__('1 Column', 'rsaddon'),
                        '6' => esc_html__('2 Column', 'rsaddon'),
                        '4' => esc_html__('3 Column', 'rsaddon'),
                        '3' => esc_html__('4 Column', 'rsaddon'),
                        '2' => esc_html__('6 Column', 'rsaddon'),
                    ],
                ]
            );
            $this->add_responsive_control(
                'grid_item_margin',
                [
                    'label' => esc_html__( 'Margin', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-testimonial-slider .row [class*="col-"]' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
        $this->end_controls_section();
        // Grid Setting End

        // Thumb Slider Setting Start
        $this->start_controls_section(
			'thumb_slider_setting',
			[
				'label' => esc_html__('Thumb Slider Settings', 'rsaddon'),
				'tab' => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'thumbnail_slider' => 'yes',
                    'testimonial_type_sl_grid' => 'slider'
                ]
			]
		);
            $this->add_control(
                'thumb_slide_items_options',
                [
                    'label' => esc_html__( 'Items View Options', 'rsaddon' ),
                    'type' => Controls_Manager::HEADING,
                    'classes' => 'rs-control-type-heading',
                ]
            );
            $this->add_control(
                'thumb_col_desktop',
                [
                    'label'   => esc_html__('Desktops Above 1200px', 'rsaddon'),
                    'type'    => Controls_Manager::SELECT,
                    'default' => 3,
                    'options' => [
                        '1' => esc_html__('1 Column', 'rsaddon'),
                        '2' => esc_html__('2 Column', 'rsaddon'),
                        '3' => esc_html__('3 Column', 'rsaddon'),
                        '4' => esc_html__('4 Column', 'rsaddon'),
                        '5' => esc_html__('5 Column', 'rsaddon'),
                        '6' => esc_html__('6 Column', 'rsaddon'),
                    ],
                    'render_type' => 'template'
                ]
            );
            $this->add_control(
                'thumb_col_lg',
                [
                    'label'   => esc_html__('Large 1199px to 992px', 'rsaddon'),
                    'type'    => Controls_Manager::SELECT,
                    'default' => 3,
                    'options' => [
                        '1' => esc_html__('1 Column', 'rsaddon'),
                        '2' => esc_html__('2 Column', 'rsaddon'),
                        '3' => esc_html__('3 Column', 'rsaddon'),
                        '4' => esc_html__('4 Column', 'rsaddon'),
                        '5' => esc_html__('5 Column', 'rsaddon'),
                        '6' => esc_html__('6 Column', 'rsaddon'),
                    ],
                    'render_type' => 'template'
                ]
            );
            $this->add_control(
                'thumb_col_md',
                [
                    'label'   => esc_html__('Medium 991px to 768px', 'rsaddon'),
                    'type'    => Controls_Manager::SELECT,
                    'default' => 3,
                    'options' => [
                        '1' => esc_html__('1 Column', 'rsaddon'),
                        '2' => esc_html__('2 Column', 'rsaddon'),
                        '3' => esc_html__('3 Column', 'rsaddon'),
                        '4' => esc_html__('4 Column', 'rsaddon'),
                        '6' => esc_html__('6 Column', 'rsaddon'),
                    ],
                    'render_type' => 'template'
                ]
            );
            $this->add_control(
                'thumb_col_sm',
                [
                    'label'   => esc_html__('Small 767px to 576px', 'rsaddon'),
                    'type'    => Controls_Manager::SELECT,
                    'default' => 3,
                    'options' => [
                        '1' => esc_html__('1 Column', 'rsaddon'),
                        '2' => esc_html__('2 Column', 'rsaddon'),
                        '3' => esc_html__('3 Column', 'rsaddon'),
                        '4' => esc_html__('4 Column', 'rsaddon'),
                        '6' => esc_html__('6 Column', 'rsaddon'),
                    ],
                    'render_type' => 'template'
                ]
            );
            $this->add_control(
                'thumb_col_xs',
                [
                    'label'   => esc_html__('Mobile Below 575px', 'rsaddon'),
                    'type'    => Controls_Manager::SELECT,
                    'default' => 3,
                    'options' => [
                        '1' => esc_html__('1 Column', 'rsaddon'),
                        '2' => esc_html__('2 Column', 'rsaddon'),
                        '3' => esc_html__('3 Column', 'rsaddon'),
                        '4' => esc_html__('4 Column', 'rsaddon'),
                        '6' => esc_html__('6 Column', 'rsaddon'),
                    ],
                    'render_type' => 'template'
                ]
            );

            $this->add_control(
                'thumb_col_gap_options',
                [
                    'label' => esc_html__( 'Gap Between Options', 'rsaddon' ),
                    'type' => Controls_Manager::HEADING,
                    'classes' => 'rs-control-type-heading',
                    'separator' => 'before',
                ]
            );
            $this->add_responsive_control(
                'thumb_col_gap_desktop',
                [
                    'label' => esc_html__( 'Desktops Above 1200px', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'default' => [
                        'size' => 30,
                    ],
                    'render_type' => 'template'
                ]
            );
            $this->add_responsive_control(
                'thumb_col_gap_lg',
                [
                    'label' => esc_html__( 'Large 1199px to 992px', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'default' => [
                        'size' => 30,
                    ],
                    'render_type' => 'template'
                ]
            );
            $this->add_responsive_control(
                'thumb_col_gap_md',
                [
                    'label' => esc_html__( 'Medium 991px to 768px', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'default' => [
                        'size' => 30,
                    ],
                    'render_type' => 'template'
                ]
            );
            $this->add_responsive_control(
                'thumb_col_gap_sm',
                [
                    'label' => esc_html__( 'Small 767px to 576px', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'default' => [
                        'size' => 20,
                    ],
                    'render_type' => 'template'
                ]
            );
            $this->add_responsive_control(
                'thumb_col_gap_xs',
                [
                    'label' => esc_html__( 'Mobile Below 575px', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'default' => [
                        'size' => 10,
                    ],
                    'render_type' => 'template'
                ]
            );

            $this->add_control(
                'thumb_vertical_options',
                [
                    'label' => esc_html__( 'Vertical Mood Options', 'rsaddon' ),
                    'type' => Controls_Manager::HEADING,
                    'classes' => 'rs-control-type-heading',
                    'separator' => 'before',
                ]
            );
            $this->add_control(
                'thumb_col_desktop_vertical',
                [
                    'label' => esc_html__( 'Desktops Above 1200px', 'rsaddon' ),
                    'type' => Controls_Manager::SWITCHER,
                    'label_on' => esc_html__( 'True', 'rsaddon' ),
                    'label_off' => esc_html__( 'False', 'rsaddon' ),
                    'return_value' => 'vertical',
                    'default' => 'vertical',
                    'render_type' => 'template'
                ]
            );
            $this->add_control(
                'thumb_col_lg_vertical',
                [
                    'label' => esc_html__( 'Large 1199px to 992px', 'rsaddon' ),
                    'type' => Controls_Manager::SWITCHER,
                    'label_on' => esc_html__( 'True', 'rsaddon' ),
                    'label_off' => esc_html__( 'False', 'rsaddon' ),
                    'return_value' => 'vertical',
                    'default' => 'vertical',
                    'render_type' => 'template'
                ]
            );
            $this->add_control(
                'thumb_col_md_vertical',
                [
                    'label' => esc_html__( 'Medium 991px to 768px', 'rsaddon' ),
                    'type' => Controls_Manager::SWITCHER,
                    'label_on' => esc_html__( 'True', 'rsaddon' ),
                    'label_off' => esc_html__( 'False', 'rsaddon' ),
                    'return_value' => 'vertical',
                    'default' => 'vertical',
                    'render_type' => 'template'
                ]
            );
            $this->add_control(
                'thumb_col_sm_vertical',
                [
                    'label' => esc_html__( 'Small 767px to 576px', 'rsaddon' ),
                    'type' => Controls_Manager::SWITCHER,
                    'label_on' => esc_html__( 'True', 'rsaddon' ),
                    'label_off' => esc_html__( 'False', 'rsaddon' ),
                    'return_value' => 'vertical',
                    'default' => 'vertical',
                    'render_type' => 'template'
                ]
            );
            $this->add_control(
                'thumb_col_xs_vertical',
                [
                    'label' => esc_html__( 'Mobile Below 575px', 'rsaddon' ),
                    'type' => Controls_Manager::SWITCHER,
                    'label_on' => esc_html__( 'True', 'rsaddon' ),
                    'label_off' => esc_html__( 'False', 'rsaddon' ),
                    'return_value' => 'vertical',
                    'default' => 'vertical',
                    'render_type' => 'template'
                ]
            );
        $this->end_controls_section();
        // Thumb Slider Setting End

        // Thumbnail Style Start
        $this->start_controls_section(
			'_section_thumbnail_style',
			[
				'label' => esc_html__('Thumbnail & Content Wrapper', 'rsaddon'),
				'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'testimonial_style' => '1',
                    'thumbnail_slider' => 'yes',
                    'testimonial_type_sl_grid' => 'slider'
                ]
			]
		);
            $this->add_control(
                'g_thumb_sl_wrapper_options',
                [
                    'label' => esc_html__( 'Wrapper Options', 'rsaddon' ),
                    'type' => Controls_Manager::HEADING,
                    'classes' => 'rs-control-type-heading',
                ]
            );
            $this->add_responsive_control(
                'g_thumb_sl_vertical_align',
                [
                    'label' => esc_html__( 'Vertical Align', 'rsaddon' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'flex-start' => [
                            'title' => esc_html__( 'Top', 'rsaddon' ),
                            'icon' => 'eicon-align-start-v',
                        ],
                        'center' => [
                            'title' => esc_html__( 'Middle', 'rsaddon' ),
                            'icon' => 'eicon-align-center-v',
                        ],
                        'flex-end' => [
                            'title' => esc_html__( 'Bottom', 'rsaddon' ),
                            'icon' => 'eicon-align-end-v',
                        ],
                    ],
                    'toggle' => true,
                    'selectors' => [
                        '{{WRAPPER}} .rs-testi-thumb-slider' => 'align-items: {{VALUE}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'g_thumb_sl_column_align',
                [
                    'label' => esc_html__( 'Column Direction', 'rsaddon' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'row' => [
                            'title' => esc_html__( 'Row', 'rsaddon' ),
                            'icon' => 'eicon-justify-start-h',
                        ],
                        'row-reverse' => [
                            'title' => esc_html__( 'Row Reverse', 'rsaddon' ),
                            'icon' => 'eicon-wrap',
                        ],
                        'column' => [
                            'title' => esc_html__( 'Column', 'rsaddon' ),
                            'icon' => 'eicon-justify-start-v',
                        ],
                        'column-reverse' => [
                            'title' => esc_html__( 'Column Reverse', 'rsaddon' ),
                            'icon' => 'eicon-wrap',
                        ],
                    ],
                    'toggle' => true,
                    'selectors' => [
                        '{{WRAPPER}} .rs-testi-thumb-slider' => 'flex-direction: {{VALUE}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'g_thumb_sl_h_align',
                [
                    'label' => esc_html__( 'Horizontal Align', 'rsaddon' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'flex-start' => [
                            'title' => esc_html__( 'Start', 'rsaddon' ),
                            'icon' => 'eicon-align-start-h',
                        ],
                        'center' => [
                            'title' => esc_html__( 'Center', 'rsaddon' ),
                            'icon' => 'eicon-align-center-h',
                        ],
                        'flex-end' => [
                            'title' => esc_html__( 'End', 'rsaddon' ),
                            'icon' => 'eicon-align-end-h',
                        ],
                        'space-between' => [
                            'title' => esc_html__( 'Space Between', 'rsaddon' ),
                            'icon' => 'eicon-justify-space-between-h',
                        ],

                    ],
                    'toggle' => true,
                    'selectors' => [
                        '{{WRAPPER}} .rs-testi-thumb-slider' => 'justify-content: {{VALUE}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'g_thumb_sl_flex_wrap',
                [
                    'label' => esc_html__( 'Flex Wrap', 'rsaddon' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'nowrap' => [
                            'title' => esc_html__( 'No Wrap', 'rsaddon' ),
                            'icon' => 'eicon-nowrap',
                        ],
                        'wrap' => [
                            'title' => esc_html__( 'Wrap', 'rsaddon' ),
                            'icon' => 'eicon-wrap',
                        ],
                    ],
                    'toggle' => true,
                    'selectors' => [
                        '{{WRAPPER}} .rs-testi-thumb-slider' => 'flex-wrap: {{VALUE}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'thumb_wrapper_width',
                [
                    'label' => esc_html__( 'Thumb Wrapper Width', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-testi-thumb-slider .thumb-sl-nav' => 'max-width: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'thumb_wrapper_height',
                [
                    'label' => esc_html__( 'Thumb Wrapper Height', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-testi-thumb-slider .thumb-sl-nav' => 'height: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'content_wrapper_width',
                [
                    'label' => esc_html__( 'Content Wrapper Width', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-testimonial-slider' => 'max-width: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
        $this->end_controls_section();
        // Thumbnail Style End

        // Global Style Start
        $this->start_controls_section(
			'_section_global_style',
			[
				'label' => esc_html__('General Style', 'rsaddon'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
            $this->add_responsive_control(
                'g_text_align',
                [
                    'label' => esc_html__( 'Alignment', 'rsaddon' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'left' => [
                            'title' => esc_html__( 'Left', 'rsaddon' ),
                            'icon' => 'eicon-text-align-left',
                        ],
                        'center' => [
                            'title' => esc_html__( 'Center', 'rsaddon' ),
                            'icon' => 'eicon-text-align-center',
                        ],
                        'right' => [
                            'title' => esc_html__( 'Right', 'rsaddon' ),
                            'icon' => 'eicon-text-align-right',
                        ],
                    ],
                    'toggle' => true,
                    'selectors' => [
                        '{{WRAPPER}} .rs-testimonial-slider .swiper-wrapper' => 'text-align: {{VALUE}};',
                    ],
                    'separator' => 'before'
                ]
            );
            $this->add_responsive_control(
                'g_display_style',
                [
                    'label' => esc_html__( 'Display Style (Inline / Block)', 'rsaddon' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'flex' => [
                            'title' => esc_html__( 'Inline', 'rsaddon' ),
                            'icon' => 'eicon-post-list',
                        ],
                        'block' => [
                            'title' => esc_html__( 'Block', 'rsaddon' ),
                            'icon' => 'eicon-posts-grid',
                        ],
                    ],
                    'toggle' => true,
                    'selectors' => [
                        '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner' => 'display: {{VALUE}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'g_vertical_align',
                [
                    'label' => esc_html__( 'Vertical Align', 'rsaddon' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'flex-start' => [
                            'title' => esc_html__( 'Top', 'rsaddon' ),
                            'icon' => 'eicon-align-start-v',
                        ],
                        'center' => [
                            'title' => esc_html__( 'Middle', 'rsaddon' ),
                            'icon' => 'eicon-align-center-v',
                        ],
                        'flex-end' => [
                            'title' => esc_html__( 'Bottom', 'rsaddon' ),
                            'icon' => 'eicon-align-end-v',
                        ],
                    ],
                    'condition' => [
                        'g_display_style' => 'flex',
                    ],
                    'toggle' => true,
                    'selectors' => [
                        '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner' => 'align-items: {{VALUE}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'g_column_align',
                [
                    'label' => esc_html__( 'Column Direction', 'rsaddon' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'row' => [
                            'title' => esc_html__( 'Row', 'rsaddon' ),
                            'icon' => 'eicon-justify-start-h',
                        ],
                        'row-reverse' => [
                            'title' => esc_html__( 'Row Reverse', 'rsaddon' ),
                            'icon' => 'eicon-wrap',
                        ],
                        'column' => [
                            'title' => esc_html__( 'Column', 'rsaddon' ),
                            'icon' => 'eicon-justify-start-v',
                        ],
                        'column-reverse' => [
                            'title' => esc_html__( 'Column Reverse', 'rsaddon' ),
                            'icon' => 'eicon-wrap',
                        ],
                    ],
                    'condition' => [
                        'g_display_style' => 'flex',
                    ],
                    'toggle' => true,
                    'selectors' => [
                        '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner' => 'flex-direction: {{VALUE}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'g_h_align',
                [
                    'label' => esc_html__( 'Horizontal Align', 'rsaddon' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'flex-start' => [
                            'title' => esc_html__( 'Start', 'rsaddon' ),
                            'icon' => 'eicon-align-start-h',
                        ],
                        'center' => [
                            'title' => esc_html__( 'Center', 'rsaddon' ),
                            'icon' => 'eicon-align-center-h',
                        ],
                        'flex-end' => [
                            'title' => esc_html__( 'End', 'rsaddon' ),
                            'icon' => 'eicon-align-end-h',
                        ],
                        'space-between' => [
                            'title' => esc_html__( 'Space Between', 'rsaddon' ),
                            'icon' => 'eicon-justify-space-between-h',
                        ],

                    ],
                    'condition' => [
                        'g_display_style' => 'flex',
                    ],
                    'toggle' => true,
                    'selectors' => [
                        '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner' => 'justify-content: {{VALUE}};',
                    ],
                ]
            );
        
            $this->add_responsive_control(
                'g_padding',
                [
                    'label' => esc_html__( 'Padding', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'g_margin',
                [
                    'label' => esc_html__( 'Margin', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'g_border_radius',
                [
                    'label' => esc_html__( 'Border Radius', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_responsive_control(
                'g_min_height',
                [
                    'label' => esc_html__( 'Min Height', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1500,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner' => 'min-height: {{SIZE}}{{UNIT}};'
                    ],
                ]
            );
            
            $this->start_controls_tabs(
                'g_hover_normal_tabs'
            );
                $this->start_controls_tab(
                    'g_normal_tab',
                    [
                        'label' => esc_html__( 'Normal', 'rsaddon' ),
                    ]
                );
                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'g_background',
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner',
                        ]
                    );
                    $this->add_responsive_control(
                        'box_filter_blur',
                        [
                            'label' => esc_html__( 'Filter Blur', 'rsaddon' ),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => ['px'],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 100,
                                ]
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner' => 'backdrop-filter: blur({{SIZE}}{{UNIT}});',
                            ]
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'g_border',
                            'selector' => '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner',
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Box_Shadow::get_type(),
                        [
                            'name' => 'g_box_shadow',
                            'selector' => '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner',
                        ]
                    );
                $this->end_controls_tab();
        
                $this->start_controls_tab(
                    'g_hover_tab',
                    [
                        'label' => esc_html__( 'Hover', 'rsaddon' ),
                    ]
                );
                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'g_background_hover',
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner:hover',
                        ]
                    );

                    $this->add_responsive_control(
                        'box_hover_filter_blur',
                        [
                            'label' => esc_html__( 'Filter Blur', 'rsaddon' ),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => ['px'],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 100,
                                ]
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner:hover' => 'backdrop-filter: blur({{SIZE}}{{UNIT}});',
                            ]
                        ]
                    );
                    $this->add_control(
                        'g_border_color_hover',
                        [
                            'label' => esc_html__( 'Border Color', 'rsaddon' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner:hover' => 'border-color: {{VALUE}}',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Box_Shadow::get_type(),
                        [
                            'name' => 'g_box_shadow_hover',
                            'selector' => '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner:hover',
                        ]
                    );
                $this->end_controls_tab();
                $this->start_controls_tab(
                    'g_active_tab',
                    [
                        'label' => esc_html__( 'Active', 'rsaddon' ),
                        'condition' => [
                            'slider_centerMode' => 'true'
                        ]
                    ]
                );
                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'g_background_active',
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .rs-testimonial-slider .slick-center .testimonial-inner',
                        ]
                    );
                    $this->add_control(
                        'g_border_color_active',
                        [
                            'label' => esc_html__( 'Border Color', 'rsaddon' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .rs-testimonial-slider .slick-center .testimonial-inner' => 'border-color: {{VALUE}}',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Box_Shadow::get_type(),
                        [
                            'name' => 'g_box_shadow_active',
                            'selector' => '{{WRAPPER}} .rs-testimonial-slider .slick-center .testimonial-inner',
                        ]
                    );
                $this->end_controls_tab();
            $this->end_controls_tabs();
        $this->end_controls_section();
        // Global Style End

        // Quote Icon Style Start
        $this->start_controls_section(
			'_section_quote_icon_style',
			[
				'label' => esc_html__('Quote Icon Style', 'rsaddon'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
            $this->add_responsive_control(
                'quote_font_size',
                [
                    'label' => esc_html__( 'Font Size', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                        ],
                    ],
                    'default' => [
                        'unit' => 'px',
                        'size' => 18,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .quote_icon svg' => 'width: {{SIZE}}{{UNIT}}; height: auto;',
                        '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .quote_icon i' => 'font-size: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_control(
                'quote_text_align',
                [
                    'label' => esc_html__( 'Inner Alignment', 'rsaddon' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'left' => [
                            'title' => esc_html__( 'Left', 'rsaddon' ),
                            'icon' => 'eicon-text-align-left',
                        ],
                        'center' => [
                            'title' => esc_html__( 'Center', 'rsaddon' ),
                            'icon' => 'eicon-text-align-center',
                        ],
                        'right' => [
                            'title' => esc_html__( 'Right', 'rsaddon' ),
                            'icon' => 'eicon-text-align-right',
                        ],
                    ],
                    'toggle' => true,
                    'selectors' => [
                        '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .quote_icon' => 'text-align: {{VALUE}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'quote_width',
                [
                    'label' => esc_html__( 'Width', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .quote_icon' => 'width: {{SIZE}}{{UNIT}};'
                    ],
                ]
            );
            $this->add_responsive_control(
                'quote_height',
                [
                    'label' => esc_html__( 'Height', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .quote_icon' => 'height: {{SIZE}}{{UNIT}}; line-height: {{SIZE}}{{UNIT}};'
                    ],
                ]
            );
            $this->add_responsive_control(
                'quote_padding',
                [
                    'label' => esc_html__( 'Padding', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .quote_icon' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'quote_margin',
                [
                    'label' => esc_html__( 'Margin', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .quote_icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'quote_border_radius',
                [
                    'label' => esc_html__( 'Border Radius', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .quote_icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            // Quote Icon Position Maker Start
            $this->add_control(
                'quote_icon_position_maker',
                [
                    'label' => esc_html__( 'Position Maker', 'rsaddon' ),
                    'type' => Controls_Manager::POPOVER_TOGGLE,
                    'label_off' => esc_html__( 'Default', 'rsaddon' ),
                    'label_on' => esc_html__( 'Custom', 'rsaddon' ),
                    'return_value' => 'yes',
                    'default' => 'no',
                    'separator' => 'before',
                ]
            );
            
            $this->start_popover();
                $this->add_responsive_control(
                    'quote_icon_position',
                    [
                        'label' => esc_html__( 'Position', 'rsaddon' ),
                        'type' => Controls_Manager::SELECT,
                        'default' => '',
                        'options' => [
                            '' => esc_html__( 'Default', 'rsaddon' ),
                            'absolute' => esc_html__( 'Absolute', 'rsaddon' ),
                            'relative'  => esc_html__( 'Relative', 'rsaddon' ),
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .quote_icon' => 'position: {{VALUE}};',
                        ],
                    ]
                );
                $this->add_responsive_control(
                    'quote_icon_p_top',
                    [
                        'label' => esc_html__( 'Top', 'rsaddon' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%', 'custom' ],
                        'range' => [
                            'px' => [
                                'min' => -1000,
                                'max' => 1000,
                            ],
                            '%' => [
                                'min' => -100,
                                'max' => 100,
                            ],
                        ],
                        'condition' => [
                            'quote_icon_position' => ['absolute', 'relative']
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .quote_icon' => 'top: {{SIZE}}{{UNIT}};',
                        ],
                    ]
                );
                $this->add_responsive_control(
                    'quote_icon_p_right',
                    [
                        'label' => esc_html__( 'Right', 'rsaddon' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%', 'custom' ],
                        'range' => [
                            'px' => [
                                'min' => -1000,
                                'max' => 1000,
                            ],
                            '%' => [
                                'min' => -100,
                                'max' => 100,
                            ],
                        ],
                        'condition' => [
                            'quote_icon_position' => ['absolute', 'relative']
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .quote_icon' => 'right: {{SIZE}}{{UNIT}};',
                        ],
                    ]
                );
                $this->add_responsive_control(
                    'quote_icon_p_bottom',
                    [
                        'label' => esc_html__( 'Bottom', 'rsaddon' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%', 'custom' ],
                        'range' => [
                            'px' => [
                                'min' => -1000,
                                'max' => 1000,
                            ],
                            '%' => [
                                'min' => -100,
                                'max' => 100,
                            ],
                        ],
                        'condition' => [
                            'quote_icon_position' => ['absolute', 'relative']
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .quote_icon' => 'bottom: {{SIZE}}{{UNIT}};',
                        ],
                    ]
                );
                $this->add_responsive_control(
                    'quote_icon_p_left',
                    [
                        'label' => esc_html__( 'Left', 'rsaddon' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%', 'custom' ],
                        'range' => [
                            'px' => [
                                'min' => -1000,
                                'max' => 1000,
                            ],
                            '%' => [
                                'min' => -100,
                                'max' => 100,
                            ],
                        ],
                        'condition' => [
                            'quote_icon_position' => ['absolute', 'relative']
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .quote_icon' => 'left: {{SIZE}}{{UNIT}};',
                        ],
                    ]
                );
            $this->end_popover();
            // Quote Icon Position Maker End

            $this->start_controls_tabs( 'quote_icon_style_tabs' );
                $this->start_controls_tab(
                    'quote_icon_normal_tab',
                    [
                        'label' => esc_html__( 'Normal', 'rsaddon' ),
                    ]
                );
                    $this->add_control(
                        'quote_color',
                        [
                            'label' => esc_html__( 'Icon Color', 'rsaddon' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .quote_icon i' => 'color: {{VALUE}}',
                                '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .quote_icon svg path' => 'fill: {{VALUE}}',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'quote_background',
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .quote_icon',
                        ]
                    );
                    $this->add_responsive_control(
                        'quote_icon_opacity',
                        [
                            'label' => esc_html__( 'Opacity', 'rsaddon' ),
                            'type' => Controls_Manager::SLIDER,
                            'show_label' => true,
                            'size_units' => [ 'px' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 1,
                                    'step' => 0.1,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .quote_icon' => 'opacity: {{SIZE}};',                   
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'quote_border',
                            'selector' => '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .quote_icon',
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Box_Shadow::get_type(),
                        [
                            'name' => 'quote_box_shadow',
                            'selector' => '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .quote_icon',
                        ]
                    );
                $this->end_controls_tab();
                $this->start_controls_tab(
                    'quote_icon_hover_tab',
                    [
                        'label' => esc_html__( 'Hover', 'rsaddon' ),
                    ]
                );
                    $this->add_control(
                        'quote_color_hover',
                        [
                            'label' => esc_html__( 'Icon Color', 'rsaddon' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner:hover .quote_icon i' => 'color: {{VALUE}}',
                                '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner:hover .quote_icon svg path' => 'fill: {{VALUE}}',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'quote_background_hover',
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner:hover .quote_icon',
                        ]
                    );
                    $this->add_responsive_control(
                        'quote_icon_opacity_hover',
                        [
                            'label' => esc_html__( 'Opacity', 'rsaddon' ),
                            'type' => Controls_Manager::SLIDER,
                            'show_label' => true,
                            'size_units' => [ 'px' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 1,
                                    'step' => 0.1,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner:hover .quote_icon' => 'opacity: {{SIZE}};',                   
                            ],
                        ]
                    );
                    $this->add_control(
                        'quote_border_color_hover',
                        [
                            'label' => esc_html__( 'Border Color', 'rsaddon' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner:hover .quote_icon' => 'border-color: {{VALUE}}',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Box_Shadow::get_type(),
                        [
                            'name' => 'quote_box_shadow_hover',
                            'selector' => '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner:hover .quote_icon',
                        ]
                    );
                $this->end_controls_tab();
                $this->start_controls_tab(
                    'quote_icon_active_tab',
                    [
                        'label' => esc_html__( 'Active', 'rsaddon' ),
                        'condition' => [
                            'slider_centerMode' => 'true'
                        ]
                    ]
                );
                    $this->add_control(
                        'quote_color_active',
                        [
                            'label' => esc_html__( 'Icon Color', 'rsaddon' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .rs-testimonial-slider .slick-center .testimonial-inner .quote_icon i' => 'color: {{VALUE}}',
                                '{{WRAPPER}} .rs-testimonial-slider .slick-center .testimonial-inner .quote_icon svg path' => 'fill: {{VALUE}}',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'quote_background_active',
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .rs-testimonial-slider .slick-center .testimonial-inner .quote_icon',
                        ]
                    );
                    $this->add_responsive_control(
                        'quote_icon_opacity_active',
                        [
                            'label' => esc_html__( 'Opacity', 'rsaddon' ),
                            'type' => Controls_Manager::SLIDER,
                            'show_label' => true,
                            'size_units' => [ 'px' ],
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 1,
                                    'step' => 0.1,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .rs-testimonial-slider .slick-center .testimonial-inner .quote_icon' => 'opacity: {{SIZE}};',                   
                            ],
                        ]
                    );
                    $this->add_control(
                        'quote_border_color_active',
                        [
                            'label' => esc_html__( 'Border Color', 'rsaddon' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .rs-testimonial-slider .slick-center .testimonial-inner .quote_icon' => 'border-color: {{VALUE}}',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Box_Shadow::get_type(),
                        [
                            'name' => 'quote_box_shadow_active',
                            'selector' => '{{WRAPPER}} .rs-testimonial-slider .slick-center .testimonial-inner .quote_icon',
                        ]
                    );
                $this->end_controls_tab();
            $this->end_controls_tabs();
            
        $this->end_controls_section();
        // Quote Icon Style End

        // Ratings Icon Style Start
        $this->start_controls_section(
			'_section_rating_style',
			[
				'label' => esc_html__('Rating Style', 'rsaddon'),
				'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'ratings_show' => 'yes'
                ]
			]
		);

            $this->add_control(
                'rating_text_align',
                [
                    'label' => esc_html__( 'Alignment', 'rsaddon' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'left' => [
                            'title' => esc_html__( 'Left', 'rsaddon' ),
                            'icon' => 'eicon-text-align-left',
                        ],
                        'center' => [
                            'title' => esc_html__( 'Center', 'rsaddon' ),
                            'icon' => 'eicon-text-align-center',
                        ],
                        'right' => [
                            'title' => esc_html__( 'Right', 'rsaddon' ),
                            'icon' => 'eicon-text-align-right',
                        ],
                    ],
                    'toggle' => true,
                    'selectors' => [
                        '{{WRAPPER}} .rs-testimonial-slider .ratings' => 'text-align: {{VALUE}};',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'rating_icon_font_size',
                    'selector' => '{{WRAPPER}} .rs-testimonial-slider .ratings i',
                ]
            );
            $this->add_control(
                'rating_icon_color',
                [
                    'label' => esc_html__( 'Color', 'rsaddon' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .rs-testimonial-slider .ratings i' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_responsive_control(
                'rating_icon_display',
                [
                    'label' => esc_html__( 'Display Style', 'rsaddon' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'flex' => [
                            'title' => esc_html__( 'Block', 'rsaddon' ),
                            'icon' => 'eicon-post-list',
                        ],
                        'inline-flex' => [
                            'title' => esc_html__( 'Inline Flex', 'rsaddon' ),
                            'icon' => 'eicon-post-list',
                        ],
                    ],
                    'default' => 'flex',
                    'toggle' => true,
                    'selectors' => [
                        '{{WRAPPER}} .rs-testimonial-slider .ratings' => 'display: {{VALUE}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'rating_icon_h_align',
                [
                    'label' => esc_html__( 'Horizontal Align', 'rsaddon' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'flex-start' => [
                            'title' => esc_html__( 'Start', 'rsaddon' ),
                            'icon' => 'eicon-align-start-h',
                        ],
                        'center' => [
                            'title' => esc_html__( 'Center', 'rsaddon' ),
                            'icon' => 'eicon-align-center-h',
                        ],
                        'flex-end' => [
                            'title' => esc_html__( 'End', 'rsaddon' ),
                            'icon' => 'eicon-align-end-h',
                        ],
                        'space-between' => [
                            'title' => esc_html__( 'Space Between', 'rsaddon' ),
                            'icon' => 'eicon-justify-space-between-h',
                        ],
    
                    ],
                    'condition' => [
                        'rating_icon_display' => ['flex', 'inline-flex'],
                    ],
                    'toggle' => true,
                    'selectors' => [
                        '{{WRAPPER}} .rs-testimonial-slider .ratings' => 'justify-content: {{VALUE}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'rating_icon_column_align',
                [
                    'label' => esc_html__( 'Direction', 'rsaddon' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'row' => [
                            'title' => esc_html__( 'Row', 'rsaddon' ),
                            'icon' => 'eicon-justify-start-h',
                        ],
                        'row-reverse' => [
                            'title' => esc_html__( 'Row Reverse', 'rsaddon' ),
                            'icon' => 'eicon-wrap',
                        ],
                        'column' => [
                            'title' => esc_html__( 'Column', 'rsaddon' ),
                            'icon' => 'eicon-justify-start-v',
                        ],
                        'column-reverse' => [
                            'title' => esc_html__( 'Column Reverse', 'rsaddon' ),
                            'icon' => 'eicon-wrap',
                        ],
                    ],
                    'condition' => [
                        'rating_icon_display' => ['flex', 'inline-flex'],
                    ],
                    'toggle' => true,
                    'selectors' => [
                        '{{WRAPPER}} .rs-testimonial-slider .ratings' => 'flex-direction: {{VALUE}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'rating_icon_vertical_align',
                [
                    'label' => esc_html__( 'Vertical Align', 'rsaddon' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'flex-start' => [
                            'title' => esc_html__( 'Top', 'rsaddon' ),
                            'icon' => 'eicon-align-start-v',
                        ],
                        'center' => [
                            'title' => esc_html__( 'Middle', 'rsaddon' ),
                            'icon' => 'eicon-align-center-v',
                        ],
                        'flex-end' => [
                            'title' => esc_html__( 'Bottom', 'rsaddon' ),
                            'icon' => 'eicon-align-end-v',
                        ],
                    ],
                    'condition' => [
                        'rating_icon_display' => ['flex', 'inline-flex'],
                    ],
                    'toggle' => true,
                    'selectors' => [
                        '{{WRAPPER}} .rs-testimonial-slider .ratings' => 'align-items: {{VALUE}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'rating_icon_gap_between_icon',
                [
                    'label' => esc_html__( 'Icon Space Between', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'condition' => [
                        'rating_icon_display' => ['flex', 'inline-flex'],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-testimonial-slider .ratings' => 'gap: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );

            $this->add_control(
                'rating_wrapper_control',
                [
                    'label' => esc_html__( 'Wrapper Control', 'rsaddon' ),
                    'type' => Controls_Manager::HEADING,
                    'classes' => 'rs-control-type-heading',
                    'separator' => 'before',
                ]
            );
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'rating_wrapper_background',
                    'types' => [ 'classic', 'gradient'],
                    'selector' => '{{WRAPPER}} .rs-testimonial-slider .ratings',
                ]
            );
            $this->add_responsive_control(
                'rating_wrapper_width',
                [
                    'label' => esc_html__( 'Width', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-testimonial-slider .ratings' => 'width: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'rating_wrapper_height',
                [
                    'label' => esc_html__( 'Height', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-testimonial-slider .ratings' => 'height: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'rating_wrapper_padding',
                [
                    'label' => esc_html__( 'Padding', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-testimonial-slider .ratings' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'rating_wrapper_margin',
                [
                    'label' => esc_html__( 'Margin', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-testimonial-slider .ratings' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'rating_wrapper_border_radius',
                [
                    'label' => esc_html__( 'Border Radius', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-testimonial-slider .ratings' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'rating_wrapper__border',
                    'selector' => '{{WRAPPER}} .rs-testimonial-slider .ratings',
                ]
            );
            $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                    'name' => 'rating_wrapper_box_shadow',
                    'selector' => '{{WRAPPER}} .rs-testimonial-slider .ratings',
                ]
            );

            // Rating Icon Position Maker Start
            $this->add_control(
                'rating_wrapper_position_maker',
                [
                    'label' => esc_html__( 'Position Maker', 'rsaddon' ),
                    'type' => Controls_Manager::POPOVER_TOGGLE,
                    'label_off' => esc_html__( 'Default', 'rsaddon' ),
                    'label_on' => esc_html__( 'Custom', 'rsaddon' ),
                    'return_value' => 'yes',
                    'default' => 'no',
                    'separator' => 'before',
                ]
            );
            
            $this->start_popover();
                $this->add_responsive_control(
                    'rating_wrapper_position',
                    [
                        'label' => esc_html__( 'Position', 'rsaddon' ),
                        'type' => Controls_Manager::SELECT,
                        'default' => '',
                        'options' => [
                            '' => esc_html__( 'Default', 'rsaddon' ),
                            'absolute' => esc_html__( 'Absolute', 'rsaddon' ),
                            'relative'  => esc_html__( 'Relative', 'rsaddon' ),
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .rs-testimonial-slider .ratings' => 'position: {{VALUE}};',
                        ],
                    ]
                );
                $this->add_responsive_control(
                    'rating_wrapper_p_top',
                    [
                        'label' => esc_html__( 'Top', 'rsaddon' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%', 'custom' ],
                        'range' => [
                            'px' => [
                                'min' => -1000,
                                'max' => 1000,
                            ],
                            '%' => [
                                'min' => -100,
                                'max' => 100,
                            ],
                        ],
                        'condition' => [
                            'rating_wrapper_position' => ['absolute', 'relative']
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .rs-testimonial-slider .ratings' => 'top: {{SIZE}}{{UNIT}};',
                        ],
                    ]
                );
                $this->add_responsive_control(
                    'rating_wrapper_p_right',
                    [
                        'label' => esc_html__( 'Right', 'rsaddon' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%', 'custom' ],
                        'range' => [
                            'px' => [
                                'min' => -1000,
                                'max' => 1000,
                            ],
                            '%' => [
                                'min' => -100,
                                'max' => 100,
                            ],
                        ],
                        'condition' => [
                            'rating_wrapper_position' => ['absolute', 'relative']
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .rs-testimonial-slider .ratings' => 'right: {{SIZE}}{{UNIT}};',
                        ],
                    ]
                );
                $this->add_responsive_control(
                    'rating_wrapper_p_bottom',
                    [
                        'label' => esc_html__( 'Bottom', 'rsaddon' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%', 'custom' ],
                        'range' => [
                            'px' => [
                                'min' => -1000,
                                'max' => 1000,
                            ],
                            '%' => [
                                'min' => -100,
                                'max' => 100,
                            ],
                        ],
                        'condition' => [
                            'rating_wrapper_position' => ['absolute', 'relative']
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .rs-testimonial-slider .ratings' => 'bottom: {{SIZE}}{{UNIT}};',
                        ],
                    ]
                );
                $this->add_responsive_control(
                    'rating_wrapper_p_left',
                    [
                        'label' => esc_html__( 'Left', 'rsaddon' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%', 'custom' ],
                        'range' => [
                            'px' => [
                                'min' => -1000,
                                'max' => 1000,
                            ],
                            '%' => [
                                'min' => -100,
                                'max' => 100,
                            ],
                        ],
                        'condition' => [
                            'rating_wrapper_position' => ['absolute', 'relative']
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .rs-testimonial-slider .ratings' => 'left: {{SIZE}}{{UNIT}};',
                        ],
                    ]
                );
            $this->end_popover();
            // Rating Icon Position Maker End

        $this->end_controls_section();
        // Ratings Icon Style End

        // Vendor Image Style Start
        $this->start_controls_section(
			'_section_vendor_image_style',
			[
				'label' => esc_html__('Author Image Style', 'rsaddon'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
            $this->add_responsive_control(
                'vendor_img_width',
                [
                    'label' => esc_html__( 'Width', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .vendor-img img' => 'width: {{SIZE}}{{UNIT}}; height: auto;'
                    ],
                    'condition' => [
                        'thumbnail_slider!' => 'yes'
                    ]
                ]
            );
            $this->add_responsive_control(
                'vendor_img_height',
                [
                    'label' => esc_html__( 'Height', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .vendor-img img' => 'height: {{SIZE}}{{UNIT}}; line-height: {{SIZE}}{{UNIT}};'
                    ],
                    'condition' => [
                        'thumbnail_slider!' => 'yes'
                    ]
                ]
            );
            $this->add_responsive_control(
                'vendor_img_radius',
                [
                    'label' => esc_html__( 'Border Radius', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .vendor-img img,
                        {{WRAPPER}} .rs-testi-thumb-slider .thumb-sl-nav .vendor-img img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ]
                ]
            );
            
            $this->add_control(
                'vendor_img_wrapper_ctrl_heading',
                [
                    'label' => esc_html__( 'Wrapper Control', 'rsaddon' ),
                    'type' => Controls_Manager::HEADING,
                    'classes' => 'rs-control-type-heading',
                    'separator' => 'before'
                ]
            );
            $this->add_control(
                'vendor_img_wrapper_overflow',
                [
                    'label' => esc_html__( 'Wrapper Overflow', 'rsaddon' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => '',
                    'options' => [
                        '' => esc_html__( 'Default', 'rsaddon' ),
                        'visible' => esc_html__( 'Visible', 'rsaddon' ),
                        'hidden' => esc_html__( 'Hidden', 'rsaddon' ),
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .vendor-img,
                        {{WRAPPER}} .rs-testi-thumb-slider .thumb-sl-nav .vendor-img' => 'overflow: {{VALUE}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'vendor_img_wrapper_width',
                [
                    'label' => esc_html__( 'Width', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .vendor-img' => 'width: {{SIZE}}{{UNIT}};'
                    ],
                    'condition' => [
                        'thumbnail_slider!' => 'yes'
                    ]
                ]
            );
            $this->add_responsive_control(
                'vendor_img_wrapper_height',
                [
                    'label' => esc_html__( 'Height', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .vendor-img' => 'height: {{SIZE}}{{UNIT}};'
                    ],
                    'condition' => [
                        'thumbnail_slider!' => 'yes'
                    ]
                ]
            );
            $this->add_responsive_control(
                'vendor_img_wrapper_padding',
                [
                    'label' => esc_html__( 'Padding', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .vendor-img,
                        {{WRAPPER}} .rs-testi-thumb-slider .thumb-sl-nav .vendor-img' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ]
                ]
            );
            $this->add_responsive_control(
                'vendor_img_wrapper_margin',
                [
                    'label' => esc_html__('Margin', 'rsaddon'),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', '%', 'custom'],
                    'selectors' => [
                        '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .vendor-img,
                        {{WRAPPER}} .rs-testi-thumb-slider .thumb-sl-nav .vendor-img' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                    ]
                ]
            );
            $this->add_responsive_control(
                'vendor_img_wrapper_border_radius',
                [
                    'label' => esc_html__( 'Border Radius', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .vendor-img,
                        {{WRAPPER}} .rs-testi-thumb-slider .thumb-sl-nav .vendor-img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->start_controls_tabs( 'vendor_img_wrapper_style_tabs' );
                $this->start_controls_tab(
                    'vendor_img_wrapper_normal_tab',
                    [
                        'label' => esc_html__( 'Normal', 'rsaddon' ),
                    ]
                );
                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'vendor_img_wrapper_background',
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '
                                {{WRAPPER}} .rs-testimonial-slider .testimonial-inner .vendor-img,
                                {{WRAPPER}} .rs-testi-thumb-slider .thumb-sl-nav .vendor-img
                            ',
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'vendor_img_wrapper_border',
                            'selector' => '
                                {{WRAPPER}} .rs-testimonial-slider .testimonial-inner .vendor-img,
                                {{WRAPPER}} .rs-testi-thumb-slider .thumb-sl-nav .vendor-img
                            ',
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Box_Shadow::get_type(),
                        [
                            'name' => 'vendor_img_wrapper_box_shadow',
                            'selector' => '
                                {{WRAPPER}} .rs-testimonial-slider .testimonial-inner .vendor-img,
                                {{WRAPPER}} .rs-testi-thumb-slider .thumb-sl-nav .vendor-img
                            ',
                        ]
                    );
                    $this->add_responsive_control(
                        'vendor_img_scale',
                        [
                            'label' => esc_html__( 'Transform Scale', 'rsaddon' ),
                            'type' => Controls_Manager::SLIDER,
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 2,
                                    'step' => 0.1,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .rs-testi-thumb-slider .thumb-sl-nav .slick-list .vendor-img' => 'transform: scale({{SIZE}});',
                            ],
                            'condition' => [
                                'thumbnail_slider' => 'yes'
                            ]
                        ]
                    );
                $this->end_controls_tab();
                $this->start_controls_tab(
                    'vendor_img_wrapper_hover_tab',
                    [
                        'label' => esc_html__( 'Hover', 'rsaddon' ),
                    ]
                );
                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'vendor_img_wrapper_background_hover',
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '
                                {{WRAPPER}} .rs-testimonial-slider .testimonial-inner:hover .vendor-img,
                                {{WRAPPER}} .rs-testi-thumb-slider .thumb-sl-nav .vendor-img:hover
                            ',
                        ]
                    );
                    $this->add_control(
                        'vendor_img_wrapper_border_color_hover',
                        [
                            'label' => esc_html__( 'Border Color', 'rsaddon' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner:hover .vendor-img,
                                {{WRAPPER}} .rs-testi-thumb-slider .thumb-sl-nav .vendor-img:hover' => 'border-color: {{VALUE}}',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Box_Shadow::get_type(),
                        [
                            'name' => 'vendor_img_wrapper_box_shadow_hover',
                            'selector' => '
                                {{WRAPPER}} .rs-testimonial-slider .testimonial-inner:hover .vendor-img,
                                {{WRAPPER}} .rs-testi-thumb-slider .thumb-sl-nav .vendor-img:hover
                            ',
                        ]
                    );
                    $this->add_responsive_control(
                        'vendor_img_scale_hover',
                        [
                            'label' => esc_html__( 'Transform Scale', 'rsaddon' ),
                            'type' => Controls_Manager::SLIDER,
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 2,
                                    'step' => 0.1,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .rs-testi-thumb-slider .thumb-sl-nav .slick-list .vendor-img:not(.slick-center):hover' => 'transform: scale({{SIZE}});',
                            ],
                            'condition' => [
                                'thumbnail_slider' => 'yes'
                            ]
                        ]
                    );
                $this->end_controls_tab();
                $this->start_controls_tab(
                    'vendor_img_wrapper_active_tab',
                    [
                        'label' => esc_html__( 'Active', 'rsaddon' ),
                        'condition' => [
                            'slider_centerMode' => 'true',
                            'thumbnail_slider!' => 'yes'
                        ]
                    ]
                );
                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'vendor_img_wrapper_background_active',
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .rs-testimonial-slider .slick-center .testimonial-inner .vendor-img',
                        ]
                    );
                    $this->add_control(
                        'vendor_img_wrapper_border_color_active',
                        [
                            'label' => esc_html__( 'Border Color', 'rsaddon' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .rs-testimonial-slider .slick-center .testimonial-inner .vendor-img' => 'border-color: {{VALUE}}',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Box_Shadow::get_type(),
                        [
                            'name' => 'vendor_img_wrapper_box_shadow_active',
                            'selector' => '{{WRAPPER}} .rs-testimonial-slider .slick-center .testimonial-inner .vendor-img',
                        ]
                    );
                $this->end_controls_tab();
                // Thumbs Active Start
                $this->start_controls_tab(
                    'vendor_img_thumb_mood_wrapper_active_tab',
                    [
                        'label' => esc_html__( 'Active', 'rsaddon' ),
                        'condition' => [
                            'thumbnail_slider' => 'yes'
                        ]
                    ]
                );
                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'vendor_img_thumb_mood_wrapper_background_active',
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .rs-testi-thumb-slider .thumb-sl-nav .vendor-img.slick-center',
                        ]
                    );
                    $this->add_control(
                        'vendor_img_thumb_mood_wrapper_border_color_active',
                        [
                            'label' => esc_html__( 'Border Color', 'rsaddon' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .rs-testi-thumb-slider .thumb-sl-nav .vendor-img.slick-center' => 'border-color: {{VALUE}}',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Box_Shadow::get_type(),
                        [
                            'name' => 'vendor_img_thumb_mood_wrapper_box_shadow_active',
                            'selector' => '{{WRAPPER}} .rs-testi-thumb-slider .thumb-sl-nav .vendor-img.slick-center',
                        ]
                    );
                    $this->add_responsive_control(
                        'vendor_img_scale_scale',
                        [
                            'label' => esc_html__( 'Transform Scale', 'rsaddon' ),
                            'type' => Controls_Manager::SLIDER,
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 2,
                                    'step' => 0.1,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .rs-testi-thumb-slider .thumb-sl-nav .slick-list .vendor-img.slick-center' => 'transform: scale({{SIZE}});',
                            ],
                            'condition' => [
                                'thumbnail_slider' => 'yes'
                            ]
                        ]
                    );
                $this->end_controls_tab();
            $this->end_controls_tabs();
        $this->end_controls_section();
        // Vendor Image Style End

        // Company Logo Style Start
        $this->start_controls_section(
			'_section_company_logo_style',
			[
				'label' => esc_html__('Company Logo Style', 'rsaddon'),
				'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'company_logo_show' => 'yes'
                ]
			]
		);
            $this->add_responsive_control(
                'logo_img_width',
                [
                    'label' => esc_html__( 'Width', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .logo-img img' => 'width: {{SIZE}}{{UNIT}}; height: auto;'
                    ],
                ]
            );
            $this->add_responsive_control(
                'logo_img_height',
                [
                    'label' => esc_html__( 'Height', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .logo-img img' => 'height: {{SIZE}}{{UNIT}}; line-height: {{SIZE}}{{UNIT}};'
                    ],
                ]
            );
            $this->add_responsive_control(
                'logo_img_radius',
                [
                    'label' => esc_html__( 'Border Radius', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .logo-img img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'logo_img_wrapper_padding',
                [
                    'label' => esc_html__( 'Padding', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .logo-img' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'logo_img_wrapper_margins',
                [
                    'label' => esc_html__('Margin', 'rsaddon'),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', '%', 'custom'],
                    'selectors' => [
                        '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .logo-img' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

                    ],
                ]
            );
            $this->add_control(
                'logo_img_wrapper_ctrl_heading',
                [
                    'label' => esc_html__( 'Wrapper Control', 'rsaddon' ),
                    'type' => Controls_Manager::HEADING,
                    'classes' => 'rs-control-type-heading',
                    'separator' => 'before',
                ]
            );
            $this->add_control(
                'logo_img_wrapper_overflow',
                [
                    'label' => esc_html__( 'Wrapper Overflow', 'rsaddon' ),
                    'type' => Controls_Manager::SELECT,
                    'default' => '',
                    'options' => [
                        '' => esc_html__( 'Default', 'rsaddon' ),
                        'visible' => esc_html__( 'Visible', 'rsaddon' ),
                        'hidden' => esc_html__( 'Hidden', 'rsaddon' ),
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .logo-img' => 'overflow: {{VALUE}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'logo_img_wrapper_width',
                [
                    'label' => esc_html__( 'Width', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .logo-img' => 'width: {{SIZE}}{{UNIT}};'
                    ],
                ]
            );
            $this->add_responsive_control(
                'logo_img_wrapper_height',
                [
                    'label' => esc_html__( 'Height', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .logo-img' => 'height: {{SIZE}}{{UNIT}};'
                    ],
                ]
            );
            $this->add_responsive_control(
                'logo_img_wrapper_padding__',
                [
                    'label' => esc_html__( 'Padding', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .logo-img' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'logo_img_wrapper_margin',
                [
                    'label' => esc_html__( 'Margin', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .logo-img' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'logo_img_wrapper_border_radius',
                [
                    'label' => esc_html__( 'Border Radius', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .logo-img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

             // Quote Icon Position Maker Start
             $this->add_control(
                'clogo_icon_position_maker',
                [
                    'label' => esc_html__( 'Position Maker', 'rsaddon' ),
                    'type' => Controls_Manager::POPOVER_TOGGLE,
                    'label_off' => esc_html__( 'Default', 'rsaddon' ),
                    'label_on' => esc_html__( 'Custom', 'rsaddon' ),
                    'return_value' => 'yes',
                    'default' => 'no',
                    'separator' => 'before',
                ]
            );
            
            $this->start_popover();
                $this->add_responsive_control(
                    'clogo_position',
                    [
                        'label' => esc_html__( 'Position', 'rsaddon' ),
                        'type' => Controls_Manager::SELECT,
                        'default' => '',
                        'options' => [
                            '' => esc_html__( 'Default', 'rsaddon' ),
                            'absolute' => esc_html__( 'Absolute', 'rsaddon' ),
                            'relative'  => esc_html__( 'Relative', 'rsaddon' ),
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .logo-img' => 'position: {{VALUE}};',
                        ],
                    ]
                );
                $this->add_responsive_control(
                    'clogo_p_top',
                    [
                        'label' => esc_html__( 'Top', 'rsaddon' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%', 'custom' ],
                        'range' => [
                            'px' => [
                                'min' => -1000,
                                'max' => 1000,
                            ],
                            '%' => [
                                'min' => -100,
                                'max' => 100,
                            ],
                        ],
                        'condition' => [
                            'clogo_position' => ['absolute', 'relative']
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .logo-img' => 'top: {{SIZE}}{{UNIT}};',
                        ],
                    ]
                );
                $this->add_responsive_control(
                    'clogo_p_right',
                    [
                        'label' => esc_html__( 'Right', 'rsaddon' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%', 'custom' ],
                        'range' => [
                            'px' => [
                                'min' => -1000,
                                'max' => 1000,
                            ],
                            '%' => [
                                'min' => -100,
                                'max' => 100,
                            ],
                        ],
                        'condition' => [
                            'clogo_position' => ['absolute', 'relative']
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .logo-img' => 'right: {{SIZE}}{{UNIT}};',
                        ],
                    ]
                );
                $this->add_responsive_control(
                    'clogo_icon_p_bottom',
                    [
                        'label' => esc_html__( 'Bottom', 'rsaddon' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%', 'custom' ],
                        'range' => [
                            'px' => [
                                'min' => -1000,
                                'max' => 1000,
                            ],
                            '%' => [
                                'min' => -100,
                                'max' => 100,
                            ],
                        ],
                        'condition' => [
                            'clogo_position' => ['absolute', 'relative']
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .logo-img' => 'bottom: {{SIZE}}{{UNIT}};',
                        ],
                    ]
                );
                $this->add_responsive_control(
                    'clogo_icon_p_left',
                    [
                        'label' => esc_html__( 'Left', 'rsaddon' ),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => [ 'px', '%', 'custom' ],
                        'range' => [
                            'px' => [
                                'min' => -1000,
                                'max' => 1000,
                            ],
                            '%' => [
                                'min' => -100,
                                'max' => 100,
                            ],
                        ],
                        'condition' => [
                            'clogo_position' => ['absolute', 'relative']
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .logo-img' => 'left: {{SIZE}}{{UNIT}};',
                        ],
                    ]
                );
            $this->end_popover();
            // Quote Icon Position Maker End

            $this->start_controls_tabs( 'clogo_icon_style_tabs' );
                $this->start_controls_tab(
                    'clogo_icon_normal_tab',
                    [
                        'label' => esc_html__( 'Normal', 'rsaddon' ),
                    ]
                );
                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'logo_img_wrapper_background',
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .logo-img',
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'logo_img_wrapper_border',
                            'selector' => '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .logo-img',
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Box_Shadow::get_type(),
                        [
                            'name' => 'logo_img_wrapper_box_shadow',
                            'selector' => '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .logo-img',
                        ]
                    );
                $this->end_controls_tab();
                $this->start_controls_tab(
                    'clogo_icon_hover_tab',
                    [
                        'label' => esc_html__( 'Hover', 'rsaddon' ),
                    ]
                );
                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'logo_img_wrapper_background_hover',
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner:hover .logo-img',
                        ]
                    );
                    $this->add_control(
                        'logo_img_wrapper_border_color_hover',
                        [
                            'label' => esc_html__( 'Border Color', 'rsaddon' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner:hover .logo-img' => 'border-color: {{VALUE}}',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Box_Shadow::get_type(),
                        [
                            'name' => 'logo_img_wrapper_box_shadow_hover',
                            'selector' => '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner:hover .logo-img',
                        ]
                    );
                $this->end_controls_tab();
                $this->start_controls_tab(
                    'clogo_icon_active_tab',
                    [
                        'label' => esc_html__( 'Active', 'rsaddon' ),
                        'condition' => [
                            'slider_centerMode' => 'true'
                        ]
                    ]
                );
                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'logo_img_wrapper_background_active',
                            'types' => [ 'classic', 'gradient' ],
                            'selector' => '{{WRAPPER}} .rs-testimonial-slider .slick-center .testimonial-inner .logo-img',
                        ]
                    );
                    $this->add_control(
                        'logo_img_wrapper_border_color_active',
                        [
                            'label' => esc_html__( 'Border Color', 'rsaddon' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .rs-testimonial-slider .slick-center .testimonial-inner .logo-img' => 'border-color: {{VALUE}}',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Box_Shadow::get_type(),
                        [
                            'name' => 'logo_img_wrapper_box_shadow_active',
                            'selector' => '{{WRAPPER}} .rs-testimonial-slider .slick-center .testimonial-inner .logo-img',
                        ]
                    );
                $this->end_controls_tab();
            $this->end_controls_tabs();
        $this->end_controls_section();
        // Company Logo Style End

        // Content Style Start
        $this->start_controls_section(
			'_section_content_inner_style',
			[
				'label' => esc_html__('Content & Wrapper Style', 'rsaddon'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
            $this->add_control(
                'content_wrapper_text_align',
                [
                    'label' => esc_html__( 'Alignment', 'rsaddon' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'left' => [
                            'title' => esc_html__( 'Left', 'rsaddon' ),
                            'icon' => 'eicon-text-align-left',
                        ],
                        'center' => [
                            'title' => esc_html__( 'Center', 'rsaddon' ),
                            'icon' => 'eicon-text-align-center',
                        ],
                        'right' => [
                            'title' => esc_html__( 'Right', 'rsaddon' ),
                            'icon' => 'eicon-text-align-right',
                        ],
                    ],
                    'toggle' => true,
                    'selectors' => [
                        '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .testi-card-bottom' => 'text-align: {{VALUE}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'content_wrapper_display_style',
                [
                    'label' => esc_html__( 'Box Style (Inline / Block)', 'rsaddon' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'flex' => [
                            'title' => esc_html__( 'Inline', 'rsaddon' ),
                            'icon' => 'eicon-post-list',
                        ],
                        'block' => [
                            'title' => esc_html__( 'Block', 'rsaddon' ),
                            'icon' => 'eicon-posts-grid',
                        ],
                    ],
                    'default' => 'block',
                    'toggle' => true,
                    'selectors' => [
                        '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .testi-card-bottom' => 'display: {{VALUE}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'content_wrapper_vertical_align',
                [
                    'label' => esc_html__( 'Vertical Align', 'rsaddon' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'flex-start' => [
                            'title' => esc_html__( 'Top', 'rsaddon' ),
                            'icon' => 'eicon-align-start-v',
                        ],
                        'center' => [
                            'title' => esc_html__( 'Middle', 'rsaddon' ),
                            'icon' => 'eicon-align-center-v',
                        ],
                        'flex-end' => [
                            'title' => esc_html__( 'Bottom', 'rsaddon' ),
                            'icon' => 'eicon-align-end-v',
                        ],
                    ],
                    'default' => 'flex-start',
                    'condition' => [
                        'content_wrapper_display_style' => 'flex',
                    ],
                    'toggle' => true,
                    'selectors' => [
                        '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .testi-card-bottom' => 'align-items: {{VALUE}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'content_wrapper_column_align',
                [
                    'label' => esc_html__( 'Column Direction', 'rsaddon' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'row' => [
                            'title' => esc_html__( 'Row', 'rsaddon' ),
                            'icon' => 'eicon-justify-start-h',
                        ],
                        'row-reverse' => [
                            'title' => esc_html__( 'Row Reverse', 'rsaddon' ),
                            'icon' => 'eicon-wrap',
                        ],
                        'column' => [
                            'title' => esc_html__( 'Column', 'rsaddon' ),
                            'icon' => 'eicon-justify-start-v',
                        ],
                        'column-reverse' => [
                            'title' => esc_html__( 'Column Reverse', 'rsaddon' ),
                            'icon' => 'eicon-wrap',
                        ],
                    ],
                    'default' => 'row',
                    'condition' => [
                        'content_wrapper_display_style' => 'flex',
                    ],
                    'toggle' => true,
                    'selectors' => [
                        '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .testi-card-bottom' => 'flex-direction: {{VALUE}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'content_wrapper_box_h_align',
                [
                    'label' => esc_html__( 'Horizontal Align', 'rsaddon' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'flex-start' => [
                            'title' => esc_html__( 'Start', 'rsaddon' ),
                            'icon' => 'eicon-align-start-h',
                        ],
                        'center' => [
                            'title' => esc_html__( 'Center', 'rsaddon' ),
                            'icon' => 'eicon-align-center-h',
                        ],
                        'flex-end' => [
                            'title' => esc_html__( 'End', 'rsaddon' ),
                            'icon' => 'eicon-align-end-h',
                        ],
                        'space-between' => [
                            'title' => esc_html__( 'Space Between', 'rsaddon' ),
                            'icon' => 'eicon-justify-space-between-h',
                        ],
    
                    ],
                    'default' => 'flex-start',
                    'condition' => [
                        'content_wrapper_display_style' => 'flex',
                    ],
                    'toggle' => true,
                    'selectors' => [
                        '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .testi-card-bottom' => 'justify-content: {{VALUE}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'content_wrapper_padding',
                [
                    'label' => esc_html__( 'Padding', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .testi-card-bottom' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'content_wrapper_margin',
                [
                    'label' => esc_html__( 'Margin', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .testi-card-bottom' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'content_wrapper_gap',
                [
                    'label' => esc_html__( 'Gap Between', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .testi-card-bottom' => 'gap: {{SIZE}}{{UNIT}};'
                    ],
                ]
            );
            $this->add_responsive_control(
                'content_wrapper_area_width',
                [
                    'label' => esc_html__( 'Area Width', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .testi-card-bottom' => 'width: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_control(
                'show_border_effect',
                [
                    'label' => esc_html__( 'Show Border Effect', 'rsaddon' ),
                    'type' => Controls_Manager::SWITCHER,
                    'label_on' => esc_html__( 'Show', 'rsaddon' ),
                    'label_off' => esc_html__( 'Hide', 'rsaddon' ),
                    'return_value' => 'yes',
                    'default' => 'no',
                    'condition' => [
                        'testimonial_style' => '1',
                        'slider_centerMode' => 'true'
                    ]
                ]
            );
            $this->add_control(
                'border_effect_color',
                [
                    'label' => esc_html__( 'Effect Color', 'rsaddon' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .testi-card-bottom.border-effect:before,
                        {{WRAPPER}} .rs-testimonial-slider .testimonial-inner .testi-card-bottom.border-effect:after' => 'background: linear-gradient(90deg, rgba(0, 0, 0, 0) 0%, {{VALUE}} 50%, rgba(0, 0, 0, 0) 100%);',
                    ],
                    'condition' => [
                        'testimonial_style' => '1',
                        'show_border_effect' => 'yes',
                        'slider_centerMode' => 'true'
                    ]
                ]
            );
            $this->add_control(
                'border_effect_color_active',
                [
                    'label' => esc_html__( 'Effect Color (Active)', 'rsaddon' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .rs-testimonial-slider .grid-item.slick-center .testimonial-inner .testi-card-bottom.border-effect:before,
                        {{WRAPPER}} .rs-testimonial-slider .grid-item.slick-center .testimonial-inner .testi-card-bottom.border-effect:after' => 'background: linear-gradient(90deg, rgba(0, 0, 0, 0) 0%, {{VALUE}} 50%, rgba(0, 0, 0, 0) 100%);',
                    ],
                    'condition' => [
                        'testimonial_style' => '1',
                        'show_border_effect' => 'yes',
                        'slider_centerMode' => 'true'
                    ]
                ]
            );
            $this->add_responsive_control(
                'border_effect_height',
                [
                    'label' => esc_html__( 'Effect Height', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .testi-card-bottom.border-effect:before,
                        {{WRAPPER}} .rs-testimonial-slider .testimonial-inner .testi-card-bottom.border-effect:after' => 'height: {{SIZE}}{{UNIT}};',
                    ],
                    'condition' => [
                        'testimonial_style' => '1',
                        'show_border_effect' => 'yes',
                        'slider_centerMode' => 'true'
                    ]
                ]
            );

            // Name & Designation Control
            $this->add_control(
                'name_&_designation_ctrl_heading',
                [
                    'label' => esc_html__( 'Name & Designation Control', 'rsaddon' ),
                    'type' => Controls_Manager::HEADING,
                    'classes' => 'rs-control-type-heading',
                    'separator' => 'before',
                    'condition' => [
                        'testimonial_style' => '1'
                    ]
                ]
            );
            $this->add_responsive_control(
                'name_&_designation_display_style',
                [
                    'label' => esc_html__( 'Inline / Block', 'rsaddon' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'flex' => [
                            'title' => esc_html__( 'Inline', 'rsaddon' ),
                            'icon' => 'eicon-post-list',
                        ],
                        'block' => [
                            'title' => esc_html__( 'Block', 'rsaddon' ),
                            'icon' => 'eicon-posts-grid',
                        ],
                    ],
                    'toggle' => true,
                    'selectors' => [
                        '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .testi-card-bottom .content-part' => 'display: {{VALUE}};',
                    ],
                    'condition' => [
                        'testimonial_style' => '1'
                    ]
                ]
            );
            $this->add_responsive_control(
                'name_&_designation__vertical_align',
                [
                    'label' => esc_html__( 'Vertical Align', 'rsaddon' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'flex-start' => [
                            'title' => esc_html__( 'Top', 'rsaddon' ),
                            'icon' => 'eicon-align-start-v',
                        ],
                        'center' => [
                            'title' => esc_html__( 'Middle', 'rsaddon' ),
                            'icon' => 'eicon-align-center-v',
                        ],
                        'flex-end' => [
                            'title' => esc_html__( 'Bottom', 'rsaddon' ),
                            'icon' => 'eicon-align-end-v',
                        ],
                    ],
                    'toggle' => true,
                    'selectors' => [
                        '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .testi-card-bottom .content-part' => 'align-items: {{VALUE}};',
                    ],
                    'condition' => [
                        'testimonial_style' => '1'
                    ]
                ]
            );
            $this->add_responsive_control(
                'name_&_designation_column_align',
                [
                    'label' => esc_html__( 'Column Direction', 'rsaddon' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'row' => [
                            'title' => esc_html__( 'Row', 'rsaddon' ),
                            'icon' => 'eicon-justify-start-h',
                        ],
                        'row-reverse' => [
                            'title' => esc_html__( 'Row Reverse', 'rsaddon' ),
                            'icon' => 'eicon-wrap',
                        ],
                        'column' => [
                            'title' => esc_html__( 'Column', 'rsaddon' ),
                            'icon' => 'eicon-justify-start-v',
                        ],
                        'column-reverse' => [
                            'title' => esc_html__( 'Column Reverse', 'rsaddon' ),
                            'icon' => 'eicon-wrap',
                        ],
                    ],
                    'toggle' => true,
                    'selectors' => [
                        '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .testi-card-bottom .content-part' => 'flex-direction: {{VALUE}};',
                    ],
                    'condition' => [
                        'testimonial_style' => '1'
                    ]
                ]
            );
            $this->add_responsive_control(
                'name_&_designation_h_align',
                [
                    'label' => esc_html__( 'Horizontal Align', 'rsaddon' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'flex-start' => [
                            'title' => esc_html__( 'Start', 'rsaddon' ),
                            'icon' => 'eicon-align-start-h',
                        ],
                        'center' => [
                            'title' => esc_html__( 'Center', 'rsaddon' ),
                            'icon' => 'eicon-align-center-h',
                        ],
                        'flex-end' => [
                            'title' => esc_html__( 'End', 'rsaddon' ),
                            'icon' => 'eicon-align-end-h',
                        ],
                        'space-between' => [
                            'title' => esc_html__( 'Space Between', 'rsaddon' ),
                            'icon' => 'eicon-justify-space-between-h',
                        ],
    
                    ],
                    'toggle' => true,
                    'selectors' => [
                        '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .testi-card-bottom .content-part' => 'justify-content: {{VALUE}};',
                    ],
                    'condition' => [
                        'testimonial_style' => '1'
                    ]
                ]
            );
            $this->add_responsive_control(
                'name_&_designation_gap_between',
                [
                    'label' => esc_html__( 'Gap Between', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .testi-card-bottom .content-part' => 'gap: {{SIZE}}{{UNIT}};',
                    ],
                    'condition' => [
                        'testimonial_style' => '1'
                    ]
                ]
            );

            // Name
            $this->add_control(
                'name_ctrl_heading',
                [
                    'label' => esc_html__( 'Name Control', 'rsaddon' ),
                    'type' => Controls_Manager::HEADING,
                    'classes' => 'rs-control-type-heading',
                    'separator' => 'before',
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'name_typography',
                    'selector' => '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .content-part .name,
                        {{WRAPPER}} .rs-testimonial-slider .testimonial-inner .content-part-modify .name',
                ]
            );
            $this->add_responsive_control(
                'name_padding',
                [
                    'label' => esc_html__( 'Padding', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .content-part .name,
                        {{WRAPPER}} .rs-testimonial-slider .testimonial-inner .content-part-modify .name' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'name_margin',
                [
                    'label' => esc_html__( 'Margin', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .content-part .name,
                        {{WRAPPER}} .rs-testimonial-slider .testimonial-inner .content-part-modify .name' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->start_controls_tabs( 'name_text_style_tabs' );
                $this->start_controls_tab(
                    'name_text_normal_tab',
                    [
                        'label' => esc_html__( 'Normal', 'rsaddon' ),
                    ]
                );
                    $this->add_control(
                        'name_text_color',
                        [
                            'label' => esc_html__( 'Color', 'rsaddon' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .content-part .name,
                                {{WRAPPER}} .rs-testimonial-slider .testimonial-inner .content-part-modify .name' => 'color: {{VALUE}}',
                            ],
                        ]
                    );
                $this->end_controls_tab();
                $this->start_controls_tab(
                    'name_text_hover_tab',
                    [
                        'label' => esc_html__( 'Hover', 'rsaddon' ),
                    ]
                );
                    $this->add_control(
                        'name_text_color_hover',
                        [
                            'label' => esc_html__( 'Color', 'rsaddon' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner:hover .content-part .name,
                                {{WRAPPER}} .rs-testimonial-slider .testimonial-inner:hover .content-part-modify .name' => 'color: {{VALUE}}',
                            ],
                        ]
                    );
                $this->end_controls_tab();
                $this->start_controls_tab(
                    'name_text_active_tab',
                    [
                        'label' => esc_html__( 'Active', 'rsaddon' ),
                        'condition' => [
                            'slider_centerMode' => 'true'
                        ]
                    ]
                );
                    $this->add_control(
                        'name_text_color_active',
                        [
                            'label' => esc_html__( 'Color', 'rsaddon' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .rs-testimonial-slider .slick-center .testimonial-inner .content-part .name,
                                {{WRAPPER}} .rs-testimonial-slider .slick-center .testimonial-inner .content-part-modify .name' => 'color: {{VALUE}}',
                            ],
                        ]
                    );
                $this->end_controls_tab();
            $this->end_controls_tabs();

            // Description
            $this->add_control(
                'description_ctrl_heading',
                [
                    'label' => esc_html__( 'Description Control', 'rsaddon' ),
                    'type' => Controls_Manager::HEADING,
                    'classes' => 'rs-control-type-heading',
                    'separator' => 'before',
                ]
            );
            $this->add_control(
                'description_text_align',
                [
                    'label' => esc_html__( 'Description Alignment', 'rsaddon' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'left' => [
                            'title' => esc_html__( 'Left', 'rsaddon' ),
                            'icon' => 'eicon-text-align-left',
                        ],
                        'center' => [
                            'title' => esc_html__( 'Center', 'rsaddon' ),
                            'icon' => 'eicon-text-align-center',
                        ],
                        'right' => [
                            'title' => esc_html__( 'Right', 'rsaddon' ),
                            'icon' => 'eicon-text-align-right',
                        ],
                    ],
                    'toggle' => true,
                    'selectors' => [
                        '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .description' => 'text-align: {{VALUE}};',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'description_typography',
                    'selector' => '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .description',
                ]
            );
            $this->add_responsive_control(
                'description_padding',
                [
                    'label' => esc_html__( 'Padding', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .description' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'description_margin',
                [
                    'label' => esc_html__( 'Margin', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .description' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'description_border',
                    'selector' => '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .description',
                ]
            );
            $this->start_controls_tabs( 'description_style_tabs' );
                $this->start_controls_tab(
                    'description_normal_tab',
                    [
                        'label' => esc_html__( 'Normal', 'rsaddon' ),
                    ]
                );
                    $this->add_control(
                        'description_text_color',
                        [
                            'label' => esc_html__( 'Color', 'rsaddon' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .description' => 'color: {{VALUE}}',
                            ],
                        ]
                    );
                $this->end_controls_tab();
                $this->start_controls_tab(
                    'description_hover_tab',
                    [
                        'label' => esc_html__( 'Hover', 'rsaddon' ),
                    ]
                );
                    $this->add_control(
                        'description_text_color_hover',
                        [
                            'label' => esc_html__( 'Color', 'rsaddon' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner:hover .description' => 'color: {{VALUE}}',
                            ],
                        ]
                    );
                $this->end_controls_tab();
                $this->start_controls_tab(
                    'description_active_tab',
                    [
                        'label' => esc_html__( 'Active', 'rsaddon' ),
                        'condition' => [
                            'slider_centerMode' => 'true'
                        ]
                    ]
                );
                    $this->add_control(
                        'description_text_color_active',
                        [
                            'label' => esc_html__( 'Color', 'rsaddon' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .rs-testimonial-slider .slick-center .testimonial-inner .description' => 'color: {{VALUE}}',
                            ],
                        ]
                    );
                $this->end_controls_tab();
            $this->end_controls_tabs();

            // Designation
            $this->add_control(
                'designation_ctrl_heading',
                [
                    'label' => esc_html__( 'Designation Control', 'rsaddon' ),
                    'type' => Controls_Manager::HEADING,
                    'classes' => 'rs-control-type-heading',
                    'separator' => 'before',
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'designation_typography',
                    'selector' => '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .content-part .testi-designation,
                        {{WRAPPER}} .rs-testimonial-slider .testimonial-inner .content-part-modify .testi-designation',
                ]
            );
            $this->add_responsive_control(
                'designation_padding',
                [
                    'label' => esc_html__( 'Padding', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .content-part .testi-designation,
                        {{WRAPPER}} .rs-testimonial-slider .testimonial-inner .content-part-modify .testi-designation' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'designation_margin',
                [
                    'label' => esc_html__( 'Margin', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .content-part .testi-designation,
                        {{WRAPPER}} .rs-testimonial-slider .testimonial-inner .content-part-modify .testi-designation' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->start_controls_tabs( 'designation_style_tabs' );
                $this->start_controls_tab(
                    'designation_normal_tab',
                    [
                        'label' => esc_html__( 'Normal', 'rsaddon' ),
                    ]
                );
                    $this->add_control(
                        'designation_text_color',
                        [
                            'label' => esc_html__( 'Color', 'rsaddon' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .content-part .testi-designation,
                                {{WRAPPER}} .rs-testimonial-slider .testimonial-inner .content-part-modify .testi-designation' => 'color: {{VALUE}}',
                            ],
                        ]
                    );
                $this->end_controls_tab();
                $this->start_controls_tab(
                    'designation_hover_tab',
                    [
                        'label' => esc_html__( 'Hover', 'rsaddon' ),
                    ]
                );
                    $this->add_control(
                        'designation_text_color_hover',
                        [
                            'label' => esc_html__( 'Color', 'rsaddon' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner:hover .content-part .testi-designation,
                                {{WRAPPER}} .rs-testimonial-slider .testimonial-inner:hover .content-part-modify .testi-designation' => 'color: {{VALUE}}',
                            ],
                        ]
                    );
                $this->end_controls_tab();
                $this->start_controls_tab(
                    'designation_active_tab',
                    [
                        'label' => esc_html__( 'Active', 'rsaddon' ),
                        'condition' => [
                            'slider_centerMode' => 'true'
                        ]
                    ]
                );
                    $this->add_control(
                        'designation_text_color_active',
                        [
                            'label' => esc_html__( 'Color', 'rsaddon' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .rs-testimonial-slider .slick-center .testimonial-inner .content-part .testi-designation,
                                {{WRAPPER}} .rs-testimonial-slider .slick-center .testimonial-inner .content-part-modify .testi-designation' => 'color: {{VALUE}}',
                            ],
                        ]
                    );
                $this->end_controls_tab();
            $this->end_controls_tabs();

            // Title & Designation Flex Style 3
            $this->add_control(
                'title_designation_style',
                [
                    'label' => esc_html__( 'Title & Designation Style', 'rsaddon' ),
                    'type' => Controls_Manager::HEADING,
                    'classes' => 'rs-control-type-heading',
                    'separator' => 'before',
                    'condition' => [
                        'testimonial_style' => '3'
                    ]
                ]
            );
            $this->add_control(
                'separator_content_show',
                [
                    'label' => esc_html__( 'Separator Show/Hide', 'rsaddon' ),
                    'type' => Controls_Manager::SWITCHER,
                    'label_on' => esc_html__( 'Show', 'rsaddon' ),
                    'label_off' => esc_html__( 'Hide', 'rsaddon' ),
                    'return_value' => 'yes',
                    'default' => 'yes',
                    'condition' => [
                        'testimonial_style' => '3'
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'separator_content_typography',
                    'selector' => '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .testi-separator',
                    'condition' => [
                        'separator_content_show' => 'yes',
                        'testimonial_style' => '3'
                    ]
                ]
            );
            $this->start_controls_tabs( 
                'separator_content_style_tabs',
                [
                    'condition' => [
                        'separator_content_show' => 'yes',
                        'testimonial_style' => '3'
                    ]
                ]
            );
                $this->start_controls_tab(
                    'separator_content_normal_tab',
                    [
                        'label' => esc_html__( 'Normal', 'rsaddon' ),
                    ]
                );
                    $this->add_control(
                        'separator_content_color',
                        [
                            'label' => esc_html__( 'Separator Color', 'rsaddon' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .testi-separator' => 'color: {{VALUE}}',
                            ],
                        ]
                    );
                $this->end_controls_tab();
                $this->start_controls_tab(
                    'separator_content_hover_tab',
                    [
                        'label' => esc_html__( 'Hover', 'rsaddon' ),
                    ]
                );
                    $this->add_control(
                        'separator_content_hover_color',
                        [
                            'label' => esc_html__( 'Separator Color', 'rsaddon' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner:hover .testi-separator' => 'color: {{VALUE}}',
                            ],
                        ]
                    );
                $this->end_controls_tab();
                $this->start_controls_tab(
                    'separator_content_active_tab',
                    [
                        'label' => esc_html__( 'Active', 'rsaddon' ),
                        'condition' => [
                            'slider_centerMode' => 'true'
                        ]
                    ]
                );
                    $this->add_control(
                        'separator_content_active_color',
                        [
                            'label' => esc_html__( 'Separator Color', 'rsaddon' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .rs-testimonial-slider .slick-center .testimonial-inner .testi-separator' => 'color: {{VALUE}}',
                            ],
                        ]
                    );
                $this->end_controls_tab();
            $this->end_controls_tabs();

            $this->add_responsive_control(
                'title_designation_display_style',
                [
                    'label' => esc_html__( 'Display Style (Inline / Block)', 'rsaddon' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'flex' => [
                            'title' => esc_html__( 'Inline', 'rsaddon' ),
                            'icon' => 'eicon-post-list',
                        ],
                        'block' => [
                            'title' => esc_html__( 'Block', 'rsaddon' ),
                            'icon' => 'eicon-posts-grid',
                        ],
                    ],
                    'default' => 'flex',
                    'toggle' => true,
                    'separator' => 'before',
                    'selectors' => [
                        '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .content-part-modify' => 'display: {{VALUE}};',
                    ],
                    'condition' => [
                        'testimonial_style' => '3'
                    ]
                ]
            );
            $this->add_responsive_control(
                'title_designation_vertical_align',
                [
                    'label' => esc_html__( 'Vertical Align', 'rsaddon' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'flex-start' => [
                            'title' => esc_html__( 'Top', 'rsaddon' ),
                            'icon' => 'eicon-align-start-v',
                        ],
                        'center' => [
                            'title' => esc_html__( 'Middle', 'rsaddon' ),
                            'icon' => 'eicon-align-center-v',
                        ],
                        'flex-end' => [
                            'title' => esc_html__( 'Bottom', 'rsaddon' ),
                            'icon' => 'eicon-align-end-v',
                        ],
                    ],
                    'default' => 'flex-start',
                    'condition' => [
                        'title_designation_display_style' => 'flex',
                        'testimonial_style' => '3'
                    ],
                    'toggle' => true,
                    'selectors' => [
                        '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .content-part-modify' => 'align-items: {{VALUE}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'title_designation_column_align',
                [
                    'label' => esc_html__( 'Column Direction', 'rsaddon' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'row' => [
                            'title' => esc_html__( 'Row', 'rsaddon' ),
                            'icon' => 'eicon-justify-start-h',
                        ],
                        'row-reverse' => [
                            'title' => esc_html__( 'Row Reverse', 'rsaddon' ),
                            'icon' => 'eicon-wrap',
                        ],
                        'column' => [
                            'title' => esc_html__( 'Column', 'rsaddon' ),
                            'icon' => 'eicon-justify-start-v',
                        ],
                        'column-reverse' => [
                            'title' => esc_html__( 'Column Reverse', 'rsaddon' ),
                            'icon' => 'eicon-wrap',
                        ],
                    ],
                    'default' => 'row',
                    'condition' => [
                        'title_designation_display_style' => 'flex',
                        'testimonial_style' => '3'
                    ],
                    'toggle' => true,
                    'selectors' => [
                        '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .content-part-modify' => 'flex-direction: {{VALUE}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'title_designation_box_h_align',
                [
                    'label' => esc_html__( 'Horizontal Align', 'rsaddon' ),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'flex-start' => [
                            'title' => esc_html__( 'Start', 'rsaddon' ),
                            'icon' => 'eicon-align-start-h',
                        ],
                        'center' => [
                            'title' => esc_html__( 'Center', 'rsaddon' ),
                            'icon' => 'eicon-align-center-h',
                        ],
                        'flex-end' => [
                            'title' => esc_html__( 'End', 'rsaddon' ),
                            'icon' => 'eicon-align-end-h',
                        ],
                        'space-between' => [
                            'title' => esc_html__( 'Space Between', 'rsaddon' ),
                            'icon' => 'eicon-justify-space-between-h',
                        ],
            
                    ],
                    'default' => 'flex-start',
                    'condition' => [
                        'title_designation_display_style' => 'flex',
                        'testimonial_style' => '3'
                    ],
                    'toggle' => true,
                    'selectors' => [
                        '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .content-part-modify' => 'justify-content: {{VALUE}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'title_designation_gap',
                [
                    'label' => esc_html__( 'Gap Between', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                        ],
                    ],
                    'default' => [
                        'unit' => 'px',
                        'size' => 15,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .content-part-modify' => 'gap: {{SIZE}}{{UNIT}};'
                    ],
                    'condition' => [
                        'title_designation_display_style' => 'flex',
                        'testimonial_style' => '3'
                    ]
                ]
            );
        $this->end_controls_section();
        // Content Style End

        // Title Style Start
        $this->start_controls_section(
			'_section_testi_title_style',
			[
				'label' => esc_html__('Title Style', 'rsaddon'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'title_typography',
                    'selector' => '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .title',
                ]
            );
            $this->add_responsive_control(
                'title_padding',
                [
                    'label' => esc_html__( 'Padding', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'title_margin',
                [
                    'label' => esc_html__( 'Margin', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->start_controls_tabs( 'title_style_tabs' );
                $this->start_controls_tab(
                    'title_normal_tab',
                    [
                        'label' => esc_html__( 'Normal', 'rsaddon' ),
                    ]
                );
                    $this->add_control(
                        'title_text_color',
                        [
                            'label' => esc_html__( 'Color', 'rsaddon' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner .title' => 'color: {{VALUE}}',
                            ],
                        ]
                    );
                $this->end_controls_tab();
                $this->start_controls_tab(
                    'title_hover_tab',
                    [
                        'label' => esc_html__( 'Hover', 'rsaddon' ),
                    ]
                );
                    $this->add_control(
                        'title_text_hover_color',
                        [
                            'label' => esc_html__( 'Color', 'rsaddon' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .rs-testimonial-slider .testimonial-inner:hover .title' => 'color: {{VALUE}}',
                            ],
                        ]
                    );
                $this->end_controls_tab();
                $this->start_controls_tab(
                    'title_active_tab',
                    [
                        'label' => esc_html__( 'Active', 'rsaddon' ),
                        'condition' => [
                            'slider_centerMode' => 'true'
                        ]
                    ]
                );
                    $this->add_control(
                        'title_text_active_color',
                        [
                            'label' => esc_html__( 'Color', 'rsaddon' ),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .rs-testimonial-slider .slick-center .testimonial-inner .title' => 'color: {{VALUE}}',
                            ],
                        ]
                    );
                $this->end_controls_tab();
            $this->end_controls_tabs();
        $this->end_controls_section();
        // Title Style End

        // Arrow Section Start
		$this->start_controls_section(
			'section_slider_style_arrow_ontrol',
			[
				'label' => esc_html__('Arrow Control', 'rsaddon'),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' => [
					'slider_nav' => 'true',
                    'testimonial_type_sl_grid' => 'slider'
				]
			]
		);
            // positioning start
            $this->add_control(
                'arrow_position_maker',
                [
                    'label' => esc_html__('Arrow Position Style', 'rsaddon'),
                    'type' => Controls_Manager::SELECT,
                    'default' => '',
                    'options' => [
                        '' => esc_html__('Default', 'rsaddon'),
                        'custom' => esc_html__('Custom', 'rsaddon'),
                    ],
                ]
            );
            $this->add_responsive_control(
                'arrow_prev_x_select',
                [
                    'label' => esc_html__('Prev Position X', 'rsaddon'),
                    'type' => Controls_Manager::SELECT,
                    'default' => '',
                    'options' => [
                        '' => esc_html__('Default', 'rsaddon'),
                        'left' => esc_html__('Left', 'rsaddon'),
                        'right' => esc_html__('Right', 'rsaddon'),
                    ],
                    'condition' => [
                        'arrow_position_maker' => 'custom'
                    ]
                ]
            );
            $this->add_responsive_control(
                'arrow_prev_left_position',
                [
                    'label' => esc_html__('Prev Left Position', 'rsaddon'),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => ['px', '%', 'custom'],
                    'range' => [
                        'px' => [
                            'min' => -1000,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-addon-slider .swiper-button-prev' => 'left: {{SIZE}}{{UNIT}}; right: unset;',
                    ],
                    'condition' => [
                        'arrow_prev_x_select' => 'left',
                        'arrow_position_maker' => 'custom'
                    ]
                ]
            );
            $this->add_responsive_control(
                'arrow_prev_right_position',
                [
                    'label' => esc_html__('Prev Right Position', 'rsaddon'),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => ['px', '%', 'custom'],
                    'range' => [
                        'px' => [
                            'min' => -1000,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-addon-slider .swiper-button-prev' => 'right: {{SIZE}}{{UNIT}}; left: unset;',
                    ],
                    'condition' => [
                        'arrow_prev_x_select' => 'right',
                        'arrow_position_maker' => 'custom'
                    ]
                ]
            );

            $this->add_responsive_control(
                'arrow_prev_y_select',
                [
                    'label' => esc_html__('Prev Position Y', 'rsaddon'),
                    'type' => Controls_Manager::SELECT,
                    'default' => '',
                    'options' => [
                        '' => esc_html__('Default', 'rsaddon'),
                        'top' => esc_html__('Top', 'rsaddon'),
                        'bottom' => esc_html__('Bottom', 'rsaddon'),
                    ],
                    'condition' => [
                        'arrow_position_maker' => 'custom'
                    ]
                ]
            );
            $this->add_responsive_control(
                'arrow_prev_top_position',
                [
                    'label' => esc_html__('Prev Top Position', 'rsaddon'),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => ['px', '%', 'custom'],
                    'range' => [
                        'px' => [
                            'min' => -1000,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-addon-slider .swiper-button-prev' => 'top: {{SIZE}}{{UNIT}}; bottom: unset;',
                    ],
                    'condition' => [
                        'arrow_prev_y_select' => 'top',
                        'arrow_position_maker' => 'custom'
                    ]
                ]
            );
            $this->add_responsive_control(
                'arrow_prev_bottom_position',
                [
                    'label' => esc_html__('Prev Bottom Position', 'rsaddon'),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => ['px', '%', 'custom'],
                    'range' => [
                        'px' => [
                            'min' => -1000,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-addon-slider .swiper-button-prev' => 'bottom: {{SIZE}}{{UNIT}}; top: unset;',
                    ],
                    'condition' => [
                        'arrow_prev_y_select' => 'bottom',
                        'arrow_position_maker' => 'custom'
                    ]
                ]
            );

            $this->add_responsive_control(
                'arrow_next_x_select',
                [
                    'label' => esc_html__('Next Position X', 'rsaddon'),
                    'type' => Controls_Manager::SELECT,
                    'default' => '',
                    'options' => [
                        '' => esc_html__('Default', 'rsaddon'),
                        'left' => esc_html__('Left', 'rsaddon'),
                        'right' => esc_html__('Right', 'rsaddon'),
                    ],
                    'condition' => [
                        'arrow_position_maker' => 'custom'
                    ]
                ]
            );
            $this->add_responsive_control(
                'arrow_next_left_position',
                [
                    'label' => esc_html__('Next Left Position', 'rsaddon'),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => ['px', '%', 'custom'],
                    'range' => [
                        'px' => [
                            'min' => -1000,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-addon-slider .swiper-button-next' => 'left: {{SIZE}}{{UNIT}}; right: unset;',
                    ],
                    'condition' => [
                        'arrow_next_x_select' => 'left',
                        'arrow_position_maker' => 'custom'
                    ]
                ]
            );
            $this->add_responsive_control(
                'arrow_next_right_position',
                [
                    'label' => esc_html__('Next Right Position', 'rsaddon'),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => ['px', '%', 'custom'],
                    'range' => [
                        'px' => [
                            'min' => -1000,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-addon-slider .swiper-button-next' => 'right: {{SIZE}}{{UNIT}}; left: unset;',
                    ],
                    'condition' => [
                        'arrow_next_x_select' => 'right',
                        'arrow_position_maker' => 'custom'
                    ]
                ]
            );

            $this->add_responsive_control(
                'arrow_next_y_select',
                [
                    'label' => esc_html__('Next Position Y', 'rsaddon'),
                    'type' => Controls_Manager::SELECT,
                    'default' => '',
                    'options' => [
                        '' => esc_html__('Default', 'rsaddon'),
                        'top' => esc_html__('Top', 'rsaddon'),
                        'bottom' => esc_html__('Bottom', 'rsaddon'),
                    ],
                    'condition' => [
                        'arrow_position_maker' => 'custom'
                    ]
                ]
            );
            $this->add_responsive_control(
                'arrow_next_top_position',
                [
                    'label' => esc_html__('Next Top Position', 'rsaddon'),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => ['px', '%', 'custom'],
                    'range' => [
                        'px' => [
                            'min' => -1000,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-addon-slider .swiper-button-next' => 'top: {{SIZE}}{{UNIT}}; bottom: unset;',
                    ],
                    'condition' => [
                        'arrow_next_y_select' => 'top',
                        'arrow_position_maker' => 'custom'
                    ]
                ]
            );
            $this->add_responsive_control(
                'arrow_next_bottom_position',
                [
                    'label' => esc_html__('Next Bottom Position', 'rsaddon'),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => ['px', '%', 'custom'],
                    'range' => [
                        'px' => [
                            'min' => -1000,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-addon-slider .swiper-button-next' => 'bottom: {{SIZE}}{{UNIT}}; top: unset;',
                    ],
                    'condition' => [
                        'arrow_next_y_select' => 'bottom',
                        'arrow_position_maker' => 'custom'
                    ]
                ]
            );
            // positioning end

            $this->add_control(
                'arrow_after_hr',
                [
                    'type' => \Elementor\Controls_Manager::DIVIDER,
                ]
            );

            $this->add_responsive_control(
                'navigation_arrow_width',
                [
                    'label' => esc_html__('Arrow Width', 'rsaddon'),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => ['px', '%', 'custom'],
                    'selectors' => [
                        '{{WRAPPER}} .rs-addon-slider .swiper-button-prev,
                        {{WRAPPER}} .rs-addon-slider .swiper-button-next' => 'width: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'navigation_arrow_height',
                [
                    'label' => esc_html__('Arrow Height', 'rsaddon'),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => ['px', '%', 'custom'],
                    'selectors' => [
                        '{{WRAPPER}} .rs-addon-slider .swiper-button-prev,
                        {{WRAPPER}} .rs-addon-slider .swiper-button-next' => 'height: {{SIZE}}{{UNIT}}; line-height: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'navigation_arrow_line_height',
                [
                    'label' => esc_html__('Arrow Line Height', 'rsaddon'),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => ['px', '%', 'custom'],
                    'selectors' => [
                        '{{WRAPPER}} .rs-addon-slider .swiper-button-prev,
                        {{WRAPPER}} .rs-addon-slider .swiper-button-next' => 'line-height: {{SIZE}}{{UNIT}} !important;',
                    ],
                ]
            );

            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'nav_icon_typography',
                    'label' => esc_html__('Icon Typography', 'rsaddon'),
                    'selector' => '
                        {{WRAPPER}} .rs-addon-slider .swiper-button-prev::after,
                        {{WRAPPER}} .rs-addon-slider .swiper-button-next::after
                    ',
                ]
            );

            $this->add_control(
                'arrow_border_radius_',
                [
                    'label' => esc_html__('Border Radius', 'rsaddon'),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', '%', 'custom'],
                    'selectors' => [
                        '{{WRAPPER}} .rs-addon-slider .swiper-button-prev,
                        {{WRAPPER}} .rs-addon-slider .swiper-button-next' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_control(
                'arrow_border_padding_',
                [
                    'label' => esc_html__('Padding', 'rsaddon'),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', '%', 'custom'],
                    'selectors' => [
                        '{{WRAPPER}} .rs-addon-slider .swiper-button-prev,
                        {{WRAPPER}} .rs-addon-slider .swiper-button-next' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            // Arrow Hover Normal Tab Start
            $this->start_controls_tabs('_tabs_slider_arrow');
                // Normal Bullet Start
                $this->start_controls_tab(
                    'slider_arrow_normal_tab',
                    [
                        'label' => esc_html__('Normal', 'rsaddon'),
                    ]
                );
                    $this->add_control(
                        'navigation_arrow_color',
                        [
                            'label' => esc_html__('Icon Color', 'rsaddon'),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .rs-addon-slider .swiper-button-prev::after,
                                {{WRAPPER}} .rs-addon-slider .swiper-button-next::after' => 'color: {{VALUE}};',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'navigation_arrow_background',
                            'types' => ['classic', 'gradient'],
                            'selector' => '
                                {{WRAPPER}} .rs-addon-slider .swiper-button-prev,
                                {{WRAPPER}} .rs-addon-slider .swiper-button-next
                            ',
                        ]
                    );

                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'nav_arrow_border',
                            'selector' => '
                                {{WRAPPER}} .rs-addon-slider .swiper-button-prev,
                                {{WRAPPER}} .rs-addon-slider .swiper-button-next
                            ',
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Box_Shadow::get_type(),
                        [
                            'name' => 'arrow_shadow_custom',
                            'selector' => '
                                {{WRAPPER}} .rs-addon-slider .swiper-button-prev,
                                {{WRAPPER}} .rs-addon-slider .swiper-button-next
                            ',
                        ]
                    );
                    $this->add_responsive_control(
                        'arrow_opacity',
                        [
                            'label' => esc_html__('Opacity', 'rsaddon'),
                            'type' => Controls_Manager::SLIDER,
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 1,
                                    'step' => 0.1,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .rs-addon-slider .swiper-button-prev,
                                {{WRAPPER}} .rs-addon-slider .swiper-button-next' => 'opacity: {{SIZE}}',
                            ]
                        ]
                    );
                $this->end_controls_tab();

                // Hover Bullet Start
                $this->start_controls_tab(
                    'slider_arrow_hover_tab',
                    [
                        'label' => esc_html__('Hover', 'rsaddon'),
                    ]
                );
                    $this->add_control(
                        'navigation_arrow_color_hover',
                        [
                            'label' => esc_html__('Icon Color', 'rsaddon'),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .rs-addon-slider .swiper-button-prev:hover::after,
                                {{WRAPPER}} .rs-addon-slider .swiper-button-next:hover::after' => 'color: {{VALUE}};',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name' => 'navigation_arrow_background_hover',
                            'types' => ['classic', 'gradient'],
                            'selector' => '
                                {{WRAPPER}} .rs-addon-slider .swiper-button-prev:hover,
                                {{WRAPPER}} .rs-addon-slider .swiper-button-next:hover
                            ',
                        ]
                    );
                    $this->add_control(
                        'nav_arrow_border_hover',
                        [
                            'label' => esc_html__('Border Color', 'rsaddon'),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .rs-addon-slider .swiper-button-prev:hover,
                                {{WRAPPER}} .rs-addon-slider .swiper-button-next:hover' => 'border-color: {{VALUE}};',
                            ],
                        ]
                    );
                    $this->add_responsive_control(
                        'arrow_opacity_hover',
                        [
                            'label' => esc_html__('Opacity', 'rsaddon'),
                            'type' => Controls_Manager::SLIDER,
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 1,
                                    'step' => 0.1,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .rsaddon-unique-slider .rs-addon-slider:hover .swiper-button-prev,
                                {{WRAPPER}} .rsaddon-unique-slider .rs-addon-slider:hover .swiper-button-next' => 'opacity: {{SIZE}}',
                            ]
                        ]
                    );
                $this->end_controls_tab();
            $this->end_controls_tabs();
            // Arrow Hover Normal Tab End
		$this->end_controls_section();
		// Arrow Style End

		// Bullet Style Start
		$this->start_controls_section(
			'section_slider_style_dots_ontrol',
			[
				'label' => esc_html__('Bullets Control', 'rsaddon'),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' => [
					'slider_dots' => 'true',
                    'testimonial_type_sl_grid' => 'slider',
                    'slider_bullet_type!' => ['progressbar', 'fraction']
				]
			]
		);
            $this->add_responsive_control(
                'dots_alignments',
                [
                    'label' => esc_html__('Alignment', 'rsaddon'),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'left' => [
                            'title' => esc_html__('Left', 'rsaddon'),
                            'icon' => 'eicon-text-align-left',
                        ],
                        'center' => [
                            'title' => esc_html__('Center', 'rsaddon'),
                            'icon' => 'eicon-text-align-center',
                        ],
                        'right' => [
                            'title' => esc_html__('Right', 'rsaddon'),
                            'icon' => 'eicon-text-align-right',
                        ],
                        'justify' => [
                            'title' => esc_html__('Justify', 'rsaddon'),
                            'icon' => 'eicon-text-align-justify',
                        ],
                    ],
                    'toggle' => true,
                    'selectors' => [
                        '{{WRAPPER}} .rs-addon-slider .swiper-pagination' => 'text-align: {{VALUE}}'
                    ],
                ]
            );
            $this->add_control(
                'bullet_wrapper_box_style',
                [
                    'label' => esc_html__('Dots Wrapper Box', 'rsaddon'),
                    'type' => Controls_Manager::HEADING,
                    'classes' => 'rs-control-type-heading',
                ]
            );
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'bullet_wrapper_box_bg',
                    'types' => ['classic', 'gradient'],
                    'selector' => '{{WRAPPER}} .rs-addon-slider .swiper-pagination',
                ]
            );
            $this->add_responsive_control(
                'bullet_wrapper_box_padding',
                [
                    'label' => esc_html__('Padding', 'rsaddon'),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', '%', 'custom'],
                    'selectors' => [
                        '{{WRAPPER}} .rs-addon-slider .swiper-pagination' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'bullet_wrapper_box_margin',
                [
                    'label' => esc_html__('Margin', 'rsaddon'),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', '%', 'custom'],
                    'selectors' => [
                        '{{WRAPPER}} .rs-addon-slider .swiper-pagination .swiper-pagination-bullet' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'bullet_wrapper_box_radius',
                [
                    'label' => esc_html__('Border Radius', 'rsaddon'),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', '%', 'custom'],
                    'selectors' => [
                        '{{WRAPPER}} .rs-addon-slider .swiper-pagination .swiper-pagination-bullet' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'bullet_wrapper_width',
                [
                    'label' => esc_html__( 'Wrapper Width', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-addon-slider .swiper-pagination' => 'width: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_control(
                '_hr',
                [
                    'type' => Controls_Manager::DIVIDER,
                    'style' => 'thick',
                ]
            );
            $this->add_control(
                'bullet_item_options',
                [
                    'label' => esc_html__('Bullet Item Style', 'rsaddon'),
                    'type' => Controls_Manager::HEADING,
                    'classes' => 'rs-control-type-heading',
                ]
            );
            $this->start_controls_tabs('_tabs_slider_dots');
                // Normal Bullet Start
                $this->start_controls_tab(
                    'slider_dots_normal_tab',
                    [
                        'label' => esc_html__('Normal', 'rsaddon'),
                    ]
                );
                    $this->add_control(
                        'navigation_dot_inner_color',
                        [
                            'label' => esc_html__('Inner Dot Color', 'rsaddon'),
                            'type' => Controls_Manager::COLOR,
                            'condition' => [
                                'slider_dots_style' => '2',
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .rs-addon-slider .swiper-pagination .swiper-pagination-bullet:after' => 'background: {{VALUE}}',
                            ],
                        ]
                    );
                    $this->add_responsive_control(
                        'bullet_inner_dot_height_custom',
                        [
                            'label' => esc_html__('Inner Dot Height', 'rsaddon'),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => ['px', '%', 'custom'],
                            'selectors' => [
                                '{{WRAPPER}} .rs-addon-slider .swiper-pagination .swiper-pagination-bullet:after' => 'height: {{SIZE}}{{UNIT}};',
                            ],
                            'condition' => [
                                'slider_dots_style' => '2',
                            ],
                        ]
                    );
                    $this->add_responsive_control(
                        'bullet_inner_dot_normal_width_custom',
                        [
                            'label' => esc_html__('Inner Dot Width', 'rsaddon'),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => ['px', '%', 'custom'],
                            'selectors' => [
                                '{{WRAPPER}} .rs-addon-slider .swiper-pagination .swiper-pagination-bullet:after' => 'width: {{SIZE}}{{UNIT}};',
                            ],
                            'condition' => [
                                'slider_dots_style' => '2',
                            ],
                        ]
                    );
                    $this->add_responsive_control(
                        'bullet_inner_dot_border_radius',
                        [
                            'label' => esc_html__('Inner Dot Radius', 'rsaddon'),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => ['px', '%', 'custom'],
                            'selectors' => [
                                '{{WRAPPER}} .rs-addon-slider .swiper-pagination .swiper-pagination-bullet:after' => 'border-radius: {{SIZE}}{{UNIT}};',
                            ],
                            'condition' => [
                                'slider_dots_style' => '2',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name'     => 'navigation_dot_icon_background',
                            'selector' => '{{WRAPPER}} .rs-addon-slider .swiper-pagination .swiper-pagination-bullet',
                        ]
                    );
                    $this->add_responsive_control(
                        'bullet_height_custom',
                        [
                            'label' => esc_html__('Bullet Height', 'rsaddon'),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => ['px', '%', 'custom'],
                            'selectors' => [
                                '{{WRAPPER}} .rs-addon-slider .swiper-pagination .swiper-pagination-bullet' => 'height: {{SIZE}}{{UNIT}};',
                            ],
                        ]
                    );
                    $this->add_responsive_control(
                        'bullet_normal_width_custom',
                        [
                            'label' => esc_html__('Bullet Width', 'rsaddon'),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => ['px', '%', 'custom'],
                            'selectors' => [
                                '{{WRAPPER}} .rs-addon-slider .swiper-pagination .swiper-pagination-bullet' => 'width: {{SIZE}}{{UNIT}};',
                            ],
                        ]
                    );
                    $this->add_control(
                        'bullet_border_radius_custom',
                        [
                            'label' => esc_html__('Border Radius', 'rsaddon'),
                            'type' => Controls_Manager::DIMENSIONS,
                            'size_units' => ['px', '%', 'custom'],
                            'selectors' => [
                                '{{WRAPPER}} .rs-addon-slider .swiper-pagination .swiper-pagination-bullet' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Border::get_type(),
                        [
                            'name' => 'bullet_border_custom',
                            'selector' => '{{WRAPPER}} .rs-addon-slider .swiper-pagination .swiper-pagination-bullet',
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Box_Shadow::get_type(),
                        [
                            'name' => 'bullet_shadow_custom',
                            'selector' => '{{WRAPPER}} .rs-addon-slider .swiper-pagination .swiper-pagination-bullet'
                        ]
                    );
                $this->end_controls_tab();
                // Normal Bullet End

                // Active Bullet Start
                $this->start_controls_tab(
                    'slider_dots_active_tab',
                    [
                        'label' => esc_html__('Active', 'rsaddon'),
                    ]
                );
                    $this->add_control(
                        'navigation_dot_inner_color_active',
                        [
                            'label' => esc_html__('Inner Dot Color', 'rsaddon'),
                            'type' => Controls_Manager::COLOR,
                            'condition' => [
                                'slider_dots_style' => '2',
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .rs-addon-slider .swiper-pagination .swiper-pagination-bullet:hover:after,
                                {{WRAPPER}} .rs-addon-slider .swiper-pagination .swiper-pagination-bullet.swiper-pagination-bullet-active:after' => 'background: {{VALUE}}',
                            ],
                        ]
                    );
                    $this->add_responsive_control(
                        'bullet_inner_dot_height_custom_active',
                        [
                            'label' => esc_html__('Inner Dot Height', 'rsaddon'),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => ['px', '%', 'custom'],
                            'selectors' => [
                                '{{WRAPPER}} .rs-addon-slider .swiper-pagination .swiper-pagination-bullet:hover:after,
                                {{WRAPPER}} .rs-addon-slider .swiper-pagination .swiper-pagination-bullet:after' => 'height: {{SIZE}}{{UNIT}};',
                            ],
                            'condition' => [
                                'slider_dots_style' => '2',
                            ],
                        ]
                    );
                    $this->add_responsive_control(
                        'bullet_inner_dot_active_width_custom',
                        [
                            'label' => esc_html__('Inner Dot Width', 'rsaddon'),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => ['px', '%', 'custom'],
                            'selectors' => [
                                '{{WRAPPER}} .rs-addon-slider .swiper-pagination .swiper-pagination-bullet:hover:after,
                                {{WRAPPER}} .rs-addon-slider .swiper-pagination .swiper-pagination-bullet:after' => 'width: {{SIZE}}{{UNIT}};',
                            ],
                            'condition' => [
                                'slider_dots_style' => '2',
                            ],
                        ]
                    );
                    $this->add_group_control(
                        Group_Control_Background::get_type(),
                        [
                            'name'     => 'navigation_dot_icon_background_active',
                            'selector' => '{{WRAPPER}} .rs-addon-slider .swiper-pagination .swiper-pagination-bullet:hover, {{WRAPPER}} .rs-addon-slider .swiper-pagination .swiper-pagination-bullet.swiper-pagination-bullet-active',
                        ]
                    );
                    $this->add_responsive_control(
                        'bullet_active_width_custom',
                        [
                            'label' => esc_html__('Bullet Width', 'rsaddon'),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => ['px', '%', 'custom'],
                            'selectors' => [
                                '{{WRAPPER}} .rs-addon-slider .swiper-pagination .swiper-pagination-bullet.swiper-pagination-bullet-active' => 'width: {{SIZE}}{{UNIT}};',
                            ],
                        ]
                    );
                    $this->add_responsive_control(
                        'bullet_active_height_custom',
                        [
                            'label' => esc_html__('Bullet Height', 'rsaddon'),
                            'type' => Controls_Manager::SLIDER,
                            'size_units' => ['px', '%', 'custom'],
                            'selectors' => [
                                '{{WRAPPER}} .rs-addon-slider .swiper-pagination .swiper-pagination-bullet.swiper-pagination-bullet-active' => 'height: {{SIZE}}{{UNIT}};',
                            ],
                        ]
                    );
                    $this->add_responsive_control(
                        'bullet_active_scale_custom',
                        [
                            'label' => esc_html__('Bullet Scale', 'rsaddon'),
                            'type' => Controls_Manager::SLIDER,
                            'range' => [
                                'px' => [
                                    'min' => 0,
                                    'max' => 1000,
                                    'step' => 0.1,
                                ],
                            ],
                            'selectors' => [
                                '{{WRAPPER}} .rs-addon-slider .swiper-pagination .swiper-pagination-bullet.swiper-pagination-bullet-active' => 'transform: scale({{SIZE}})',
                            ],
                        ]
                    );
                    $this->add_control(
                        'navigation_dot_active_border_color',
                        [
                            'label' => esc_html__('Border Color', 'rsaddon'),
                            'type' => Controls_Manager::COLOR,
                            'selectors' => [
                                '{{WRAPPER}} .rs-addon-slider .swiper-pagination .swiper-pagination-bullet:hover' => 'border-color: {{VALUE}};',
                                '{{WRAPPER}} .rs-addon-slider .swiper-pagination .swiper-pagination-bullet.swiper-pagination-bullet-active' => 'border-color: {{VALUE}};',

                            ],
                        ]
                    );
                $this->end_controls_tab();
            $this->end_controls_tabs();
            // Active Bullet End
            $this->add_responsive_control(
                'bullet_spacing_custom_position',
                [
                    'label' => esc_html__('Top Position', 'rsaddon'),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => ['px', '%', 'custom'],
                    'show_label' => true,
                    'range' => [
                        'px' => [
                            'min' => -1000,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => -1000,
                            'max' => 1000,
                        ],
                    ],
                    'separator' => 'before',
                    'selectors' => [
                        '{{WRAPPER}} .rs-addon-slider .swiper-pagination' => 'top: {{SIZE}}{{UNIT}} !important; bottom: unset !important;',
                    ],
                ]
            );
            $this->add_responsive_control(
                'bullet_spacing_custom_position_bottom',
                [
                    'label' => esc_html__('Bottom Position', 'rsaddon'),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => ['px', '%', 'custom'],
                    'show_label' => true,
                    'range' => [
                        'px' => [
                            'min' => -1000,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => -1000,
                            'max' => 1000,
                        ],
                    ],
                    'default' => [
                        'size' => 0,
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-addon-slider .swiper-pagination' => 'bottom: {{SIZE}}{{UNIT}} !important; top: unset !important;',
                    ],
                ]
            );
		$this->end_controls_section();

        // Progress Pagination
		$this->start_controls_section(
			'section_slider_style_dots_progress',
			[
				'label' => esc_html__('Bullet Progress Control', 'rsaddon'),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' => [
					'slider_dots' => 'true',
                    'testimonial_type_sl_grid' => 'slider',
                    'slider_bullet_type' => 'progressbar'
				]
			]
		);
            $this->add_control(
                'dots_progress_control_heading',
                [
                    'label' => esc_html__( 'Progress Options', 'rsaddon' ),
                    'type' => Controls_Manager::HEADING,
                    'classes' => 'rs-control-type-heading',
                ]
            );
            $this->add_responsive_control(
                'dots_progress_width',
                [
                    'label' => esc_html__( 'Width', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-addon-slider .swiper-pagination' => 'width: {{SIZE}}{{UNIT}} !important;',
                    ],
                ]
            );
            $this->add_responsive_control(
                'dots_progress_height',
                [
                    'label' => esc_html__( 'Height', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-addon-slider .swiper-pagination' => 'height: {{SIZE}}{{UNIT}} !important;',
                    ],
                ]
            );
            $this->add_control(
                'dots_progress_track_color',
                [
                    'label' => esc_html__( 'Track Background Color', 'rsaddon' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .rs-addon-slider .swiper-pagination' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'dots_progress_color',
                [
                    'label' => esc_html__( 'Progress Color', 'rsaddon' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .rs-addon-slider .swiper-pagination .swiper-pagination-progressbar-fill' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_responsive_control(
                'dots_progress_radius',
                [
                    'label' => esc_html__( 'Border Radius', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-addon-slider .swiper-pagination' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'dots_progress_border',
                    'selector' => '{{WRAPPER}} .rs-addon-slider .swiper-pagination',
                ]
            );
            $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                    'name' => 'dots_progress_box_shadow',
                    'selector' => '{{WRAPPER}} .rs-addon-slider .swiper-pagination',
                ]
            );

            // Position Control
            $this->add_control(
                'dots_progress_control_position_heading',
                [
                    'label' => esc_html__( 'Position Options', 'rsaddon' ),
                    'type' => Controls_Manager::HEADING,
                    'classes' => 'rs-control-type-heading',
                    'separator' => 'before',
                ]
            );
            $this->add_responsive_control(
                'dots_progress_position_top',
                [
                    'label' => esc_html__( 'Position Top', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-addon-slider .swiper-pagination' => 'top: {{SIZE}}{{UNIT}} !important; bottom: unset !important;',
                    ],
                ]
            );
            $this->add_responsive_control(
                'dots_progress_position_right',
                [
                    'label' => esc_html__( 'Position Right', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-addon-slider .swiper-pagination' => 'right: {{SIZE}}{{UNIT}} !important; left: unset !important;',
                    ],
                ]
            );
            $this->add_responsive_control(
                'dots_progress_position_bottom',
                [
                    'label' => esc_html__( 'Position Bottom', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-addon-slider .swiper-pagination' => 'bottom: {{SIZE}}{{UNIT}} !important; top: unset !important;',
                    ],
                ]
            );
            $this->add_responsive_control(
                'dots_progress_position_left',
                [
                    'label' => esc_html__( 'Position Left', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-addon-slider .swiper-pagination' => 'left: {{SIZE}}{{UNIT}} !important; right: unset !important;',
                    ],
                ]
            );
        $this->end_controls_section();

        // Fraction Pagination
		$this->start_controls_section(
			'section_slider_style_dots_fraction',
			[
				'label' => esc_html__('Bullet Fraction Control', 'rsaddon'),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' => [
					'slider_dots' => 'true',
                    'testimonial_type_sl_grid' => 'slider',
                    'slider_bullet_type' => 'fraction'
				]
			]
		);
            $this->add_responsive_control(
                'dots_fraction_wrapper_alignments',
                [
                    'label' => esc_html__('Alignment', 'rsaddon'),
                    'type' => Controls_Manager::CHOOSE,
                    'options' => [
                        'left' => [
                            'title' => esc_html__('Left', 'rsaddon'),
                            'icon' => 'eicon-text-align-left',
                        ],
                        'center' => [
                            'title' => esc_html__('Center', 'rsaddon'),
                            'icon' => 'eicon-text-align-center',
                        ],
                        'right' => [
                            'title' => esc_html__('Right', 'rsaddon'),
                            'icon' => 'eicon-text-align-right',
                        ],
                        'justify' => [
                            'title' => esc_html__('Justify', 'rsaddon'),
                            'icon' => 'eicon-text-align-justify',
                        ],
                    ],
                    'toggle' => true,
                    'selectors' => [
                        '{{WRAPPER}} .rs-addon-slider .swiper-pagination' => 'text-align: {{VALUE}}'
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'dots_fraction_typography',
                    'selector' => '{{WRAPPER}} .rs-addon-slider .swiper-pagination',
                ]
            );
            $this->add_control(
                'dots_fraction_text_color',
                [
                    'label' => esc_html__( 'Text Color', 'rsaddon' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .rs-addon-slider .swiper-pagination' => 'color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'dots_fraction_text_color_current',
                [
                    'label' => esc_html__( 'Text Color (Current)', 'rsaddon' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .rs-addon-slider .swiper-pagination .swiper-pagination-current' => 'color: {{VALUE}}',
                    ],
                ]
            );

            $this->add_responsive_control(
                'dots_fraction_wrapper_width',
                [
                    'label' => esc_html__('Width', 'rsaddon'),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => ['px', '%', 'custom'],
                    'show_label' => true,
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 1000,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-addon-slider .swiper-pagination' => 'width: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'dots_fraction_wrapper_height',
                [
                    'label' => esc_html__('Height', 'rsaddon'),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => ['px', '%', 'custom'],
                    'show_label' => true,
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 1000,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-addon-slider .swiper-pagination' => 'height: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'dots_fraction_wrapper_padding',
                [
                    'label' => esc_html__( 'Padding', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-addon-slider .swiper-pagination' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'dots_fraction_wrapper_radius',
                [
                    'label' => esc_html__( 'Border Radius', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-addon-slider .swiper-pagination' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name' => 'dots_fraction_wrapper_background',
                    'types' => [ 'classic', 'gradient' ],
                    'selector' => '{{WRAPPER}} .rs-addon-slider .swiper-pagination',
                ]
            );
            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'dots_fraction_wrapper_border',
                    'selector' => '{{WRAPPER}} .rs-addon-slider .swiper-pagination',
                ]
            );
            $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                    'name' => 'dots_fraction_wrapper_box_shadow',
                    'selector' => '{{WRAPPER}} .rs-addon-slider .swiper-pagination',
                ]
            );

            // Position Control
            $this->add_control(
                'dots_fraction_control_position_heading',
                [
                    'label' => esc_html__( 'Position Options', 'rsaddon' ),
                    'type' => Controls_Manager::HEADING,
                    'classes' => 'rs-control-type-heading',
                    'separator' => 'before',
                ]
            );
            $this->add_responsive_control(
                'dots_fraction_position_top',
                [
                    'label' => esc_html__('Top Position', 'rsaddon'),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => ['px', '%', 'custom'],
                    'show_label' => true,
                    'range' => [
                        'px' => [
                            'min' => -1000,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => -1000,
                            'max' => 1000,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-addon-slider .swiper-pagination' => 'top: {{SIZE}}{{UNIT}} !important; bottom: unset !important;',
                    ],
                ]
            );
            $this->add_responsive_control(
                'dots_fraction_position_right',
                [
                    'label' => esc_html__('Right Position', 'rsaddon'),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => ['px', '%', 'custom'],
                    'show_label' => true,
                    'range' => [
                        'px' => [
                            'min' => -1000,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => -1000,
                            'max' => 1000,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-addon-slider .swiper-pagination' => 'right: {{SIZE}}{{UNIT}} !important; left: unset !important;',
                    ],
                ]
            );
            $this->add_responsive_control(
                'dots_fraction_position_bottom',
                [
                    'label' => esc_html__('Bottom Position', 'rsaddon'),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => ['px', '%', 'custom'],
                    'show_label' => true,
                    'range' => [
                        'px' => [
                            'min' => -1000,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => -1000,
                            'max' => 1000,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-addon-slider .swiper-pagination' => 'bottom: {{SIZE}}{{UNIT}} !important; top: unset !important;',
                    ],
                ]
            );
            $this->add_responsive_control(
                'dots_fraction_position_left',
                [
                    'label' => esc_html__('Left Position', 'rsaddon'),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => ['px', '%', 'custom'],
                    'show_label' => true,
                    'range' => [
                        'px' => [
                            'min' => -1000,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => -1000,
                            'max' => 1000,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-addon-slider .swiper-pagination' => 'left: {{SIZE}}{{UNIT}} !important; right: unset !important;',
                    ],
                ]
            );
        $this->end_controls_section();
		// Bullet Style End

        // Autoplay Progress Start
		$this->start_controls_section(
			'section_slider_autoplay_progress',
			[
				'label' => esc_html__('Autoplay Progress Control', 'rsaddon'),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' => [
					'slider_autoplay' => 'true',
                    'testimonial_type_sl_grid' => 'slider',
                    'slide_item_circle_progress' => 'true'
				]
			]
		);
            $this->add_control(
                'autoplay_progress_circle_heading',
                [
                    'label' => esc_html__( 'Circle Options', 'rsaddon' ),
                    'type' => Controls_Manager::HEADING,
                    'classes' => 'rs-control-type-heading',
                ]
            );
            $this->add_responsive_control(
                'autoplay_progress_size',
                [
                    'label' => esc_html__( 'Size', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-addon-slider .autoplay-progress' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_responsive_control(
                'autoplay_progress_stroke_width',
                [
                    'label' => esc_html__( 'Stroke Width', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-addon-slider .autoplay-progress svg' => 'stroke-width: {{SIZE}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_control(
                'autoplay_progress_stroke_color',
                [
                    'label' => esc_html__( 'Stroke Color', 'rsaddon' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .rs-addon-slider .autoplay-progress svg' => 'stroke: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'autoplay_progress_stroke_color_solid',
                [
                    'label' => esc_html__( 'Stroke Color (Solid)', 'rsaddon' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .rs-addon-slider .autoplay-progress svg circle.normal' => 'stroke: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'autoplay_progress_bg_color',
                [
                    'label' => esc_html__( 'Background Color', 'rsaddon' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .rs-addon-slider .autoplay-progress svg' => 'fill: {{VALUE}}',
                    ],
                ]
            );

            // Number Control
            $this->add_control(
                'autoplay_progress_number_heading',
                [
                    'label' => esc_html__( 'Number Options', 'rsaddon' ),
                    'type' => Controls_Manager::HEADING,
                    'classes' => 'rs-control-type-heading',
                    'separator' => 'before',
                ]
            );
            $this->add_group_control(
                Group_Control_Typography::get_type(),
                [
                    'name' => 'autoplay_progress_number_typography',
                    'selector' => '{{WRAPPER}} .rs-addon-slider .autoplay-progress',
                ]
            );
            $this->add_control(
                'autoplay_progress_number_color',
                [
                    'label' => esc_html__( 'Text Color', 'rsaddon' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .rs-addon-slider .autoplay-progress' => 'color: {{VALUE}}',
                    ],
                ]
            );

            // Position Control
            $this->add_control(
                'autoplay_progress_position_heading',
                [
                    'label' => esc_html__( 'Position Options', 'rsaddon' ),
                    'type' => Controls_Manager::HEADING,
                    'classes' => 'rs-control-type-heading',
                    'separator' => 'before',
                ]
            );
            $this->add_responsive_control(
                'autoplay_progress_position_top',
                [
                    'label' => esc_html__('Top Position', 'rsaddon'),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => ['px', '%', 'custom'],
                    'show_label' => true,
                    'range' => [
                        'px' => [
                            'min' => -1000,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => -1000,
                            'max' => 1000,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-addon-slider .autoplay-progress' => 'top: {{SIZE}}{{UNIT}} !important; bottom: unset !important;',
                    ],
                ]
            );
            $this->add_responsive_control(
                'autoplay_progress_position_right',
                [
                    'label' => esc_html__('Right Position', 'rsaddon'),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => ['px', '%', 'custom'],
                    'show_label' => true,
                    'range' => [
                        'px' => [
                            'min' => -1000,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => -1000,
                            'max' => 1000,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-addon-slider .autoplay-progress' => 'right: {{SIZE}}{{UNIT}} !important; left: unset !important;',
                    ],
                ]
            );
            $this->add_responsive_control(
                'autoplay_progress_position_bottom',
                [
                    'label' => esc_html__('Bottom Position', 'rsaddon'),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => ['px', '%', 'custom'],
                    'show_label' => true,
                    'range' => [
                        'px' => [
                            'min' => -1000,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => -1000,
                            'max' => 1000,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-addon-slider .autoplay-progress' => 'bottom: {{SIZE}}{{UNIT}} !important; top: unset !important;',
                    ],
                ]
            );
            $this->add_responsive_control(
                'autoplay_progress_position_left',
                [
                    'label' => esc_html__('Left Position', 'rsaddon'),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => ['px', '%', 'custom'],
                    'show_label' => true,
                    'range' => [
                        'px' => [
                            'min' => -1000,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => -1000,
                            'max' => 1000,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-addon-slider .autoplay-progress' => 'left: {{SIZE}}{{UNIT}} !important; right: unset !important;',
                    ],
                ]
            );
        $this->end_controls_section();
        // Autoplay Progress End

        // Scrollbar Start
		$this->start_controls_section(
			'section_slider_scrollbar',
			[
				'label' => esc_html__('Scrollbar Control', 'rsaddon'),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' => [
					'slider_scrollbar' => 'true',
                    'testimonial_type_sl_grid' => 'slider'
				]
			]
		);
            $this->add_responsive_control(
                'scrollbar_width',
                [
                    'label' => esc_html__( 'Width', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-addon-slider .swiper-scrollbar' => 'width: {{SIZE}}{{UNIT}} !important;',
                    ],
                ]
            );
            $this->add_responsive_control(
                'scrollbar_height',
                [
                    'label' => esc_html__( 'Height', 'rsaddon' ),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'range' => [
                        'px' => [
                            'min' => 0,
                            'max' => 1000
                        ],
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-addon-slider .swiper-scrollbar' => 'height: {{SIZE}}{{UNIT}} !important;',
                    ],
                ]
            );
            $this->add_control(
                'scrollbar_track_color',
                [
                    'label' => esc_html__( 'Track Background Color', 'rsaddon' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .rs-addon-slider .swiper-scrollbar' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_control(
                'scrollbar_color',
                [
                    'label' => esc_html__( 'Scrollbar Color', 'rsaddon' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .rs-addon-slider .swiper-scrollbar .swiper-scrollbar-drag' => 'background-color: {{VALUE}}',
                    ],
                ]
            );
            $this->add_responsive_control(
                'scrollbar_margin',
                [
                    'label' => esc_html__( 'Margin', 'rsaddon' ),
                    'type' => Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%', 'custom' ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-addon-slider .swiper-scrollbar' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name' => 'scrollbar_border',
                    'selector' => '{{WRAPPER}} .rs-addon-slider .swiper-scrollbar',
                ]
            );
            $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                    'name' => 'scrollbar_box_shadow',
                    'selector' => '{{WRAPPER}} .rs-addon-slider .swiper-scrollbar',
                ]
            );
            // Position Control
            $this->add_control(
                'scrollbar_position_heading',
                [
                    'label' => esc_html__( 'Position Options', 'rsaddon' ),
                    'type' => Controls_Manager::HEADING,
                    'classes' => 'rs-control-type-heading',
                    'separator' => 'before',
                ]
            );
            $this->add_responsive_control(
                'scrollbar_position_top',
                [
                    'label' => esc_html__('Top Position', 'rsaddon'),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => ['px', '%', 'custom'],
                    'show_label' => true,
                    'range' => [
                        'px' => [
                            'min' => -1000,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => -1000,
                            'max' => 1000,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-addon-slider .swiper-scrollbar' => 'top: {{SIZE}}{{UNIT}} !important; bottom: unset !important;',
                    ],
                ]
            );
            $this->add_responsive_control(
                'scrollbar_position_right',
                [
                    'label' => esc_html__('Right Position', 'rsaddon'),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => ['px', '%', 'custom'],
                    'show_label' => true,
                    'range' => [
                        'px' => [
                            'min' => -1000,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => -1000,
                            'max' => 1000,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-addon-slider .swiper-scrollbar' => 'right: {{SIZE}}{{UNIT}} !important; left: unset !important;',
                    ],
                ]
            );
            $this->add_responsive_control(
                'scrollbar_position_bottom',
                [
                    'label' => esc_html__('Bottom Position', 'rsaddon'),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => ['px', '%', 'custom'],
                    'show_label' => true,
                    'range' => [
                        'px' => [
                            'min' => -1000,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => -1000,
                            'max' => 1000,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-addon-slider .swiper-scrollbar' => 'bottom: {{SIZE}}{{UNIT}} !important; top: unset !important;',
                    ],
                ]
            );
            $this->add_responsive_control(
                'scrollbar_position_left',
                [
                    'label' => esc_html__('Left Position', 'rsaddon'),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => ['px', '%', 'custom'],
                    'show_label' => true,
                    'range' => [
                        'px' => [
                            'min' => -1000,
                            'max' => 1000,
                        ],
                        '%' => [
                            'min' => -1000,
                            'max' => 1000,
                        ],
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .rs-addon-slider .swiper-scrollbar' => 'left: {{SIZE}}{{UNIT}} !important; right: unset !important;',
                    ],
                ]
            );
        $this->end_controls_section();
        // Scrollbar End

    }

    protected function render()
    {

        $settings = $this->get_settings_for_display();
        $id = $this->get_id();
        $unique = rand(2012, 35120);
        $clip_path_enable = ('yes' == $settings['right_clip_path_enable']) ? 'clip-path-css' : '';
        $borderEffect = ('yes' === $settings['show_border_effect']) ? 'border-effect' : '';
        
        if ('slider' === $settings['testimonial_type_sl_grid']) {
            $slidesToShow          = !empty($settings['col_lg']) ? $settings['col_lg'] : 3;
            $sliderSpeed           = !empty($settings['slider_speed']) ? $settings['slider_speed'] : 300;
            $interval              = $settings['slider_interval'];
            $slidesToScroll        = $settings['slides_ToScroll'];
            $slider_autoplay       = $settings['slider_autoplay'] === 'true' ? 'true' : 'false';
            $pauseOnHover          = $settings['slider_stop_on_hover'] === 'true' ? 'true' : 'false';
            $sliderDots            = $settings['slider_dots'] == 'true' ? 'true' : 'false';
            $sliderNav             = $settings['slider_nav'] == 'true' ? 'true' : 'false';
            $infinite              = $settings['slider_loop'] === 'true' ? 'true' : 'false';
            $centerMode            = $settings['slider_centerMode'] === 'true' ? 'true' : 'false';
            $freeMode              = $settings['slider_free_mode'] === 'true' ? 'true' : 'false';
            $grabCursor            = $settings['slider_grab_cursor'] === 'true' ? 'true' : 'false';
            $mousewheel            = $settings['slider_mousewheel'] === 'true' ? 'true' : 'false';
            $autoHeight            = $settings['slider_auto_height'] === 'true' ? 'true' : 'false';
            $keyboardControl       = $settings['slider_keyboard_control'] === 'true' ? 'true' : 'false';            
            $dynamicBullets        = $settings['slider_dynamic_bullets'] === 'true' ? 'true' : 'false';
            $slideEffect           = !empty($settings['slider_effect']) ? $settings['slider_effect'] : '';
            $bulletType            = !empty($settings['slider_bullet_type']) ? $settings['slider_bullet_type'] : '';
            $col_desktop           = $settings['col_desktop'];
            $col_lg                = $settings['col_lg'];
            $col_md                = $settings['col_md'];
            $col_sm                = $settings['col_sm'];
            $col_xs                = $settings['col_xs'];
            $spaceBetween          = !empty($settings['slide_space_between']['size']) ? $settings['slide_space_between']['size'] : 30;
            $spaceBetweenLg        = !empty($settings['slide_space_between_lg']['size']) ? $settings['slide_space_between_lg']['size'] : 30;
            $spaceBetweenMd        = !empty($settings['slide_space_between_md']['size']) ? $settings['slide_space_between_md']['size'] : 30;
            $spaceBetweenSm        = !empty($settings['slide_space_between_sm']['size']) ? $settings['slide_space_between_sm']['size'] : 20;
            $spaceBetweenXs        = !empty($settings['slide_space_between_xs']['size']) ? $settings['slide_space_between_xs']['size'] : 10;

            $slider_conf = compact('slidesToShow', 'spaceBetween', 'spaceBetweenLg', 'spaceBetweenMd', 'spaceBetweenSm', 'spaceBetweenXs', 'sliderSpeed','interval', 'slidesToScroll', 'slider_autoplay', 'pauseOnHover', 'sliderDots', 'sliderNav', 'infinite', 'centerMode', 'col_desktop', 'col_lg', 'col_md', 'col_sm', 'col_xs', 'freeMode', 'grabCursor', 'mousewheel', 'autoHeight', 'keyboardControl', 'dynamicBullets', 'bulletType', 'slideEffect');

            $slFor              = ('yes' == $settings['thumbnail_slider']) ? 'slider-for-' . $id : '';
            $slNav              = ('yes' == $settings['thumbnail_slider']) ? 'slider-nav-' . $id : '';
            $thumbSl            = ('yes' == $settings['thumbnail_slider']) ? 'rs-testi-thumb-slider' : '';
            $rtl = ('right' === $settings['slider_direction']) ? 'true' : 'false';
            $grid_cols = '';
        } else {
            $grid_cols = [
                'xl' => !empty($settings['grid_col_xl']) ? $settings['grid_col_xl'] : '3',
                'lg' => !empty($settings['grid_col_lg']) ? $settings['grid_col_lg'] : '3',
                'md' => !empty($settings['grid_col_md']) ? $settings['grid_col_md'] : '3',
                'sm' => !empty($settings['grid_col_sm']) ? $settings['grid_col_sm'] : '2',
                'xs' => !empty($settings['grid_col_xs']) ? $settings['grid_col_xs'] : '1'
            ];
            $grid_cols = 
                'col-xl-' . $grid_cols['xl'] . ' ' .
                'col-lg-' . $grid_cols['lg'] . ' ' .
                'col-md-' . $grid_cols['md'] . ' ' .
                'col-sm-' . $grid_cols['sm'] . ' ' .
                'col-'    . $grid_cols['xs']
            ;
        }

        if (empty($settings['testi_list'])) {
            return;
        }

?>
    <div id="rs-unique-slider-<?php echo esc_attr($unique); ?>" class="rsaddon-unique-slider <?php echo esc_attr($thumbSl); ?>">
        <?php if ('slider' === $settings['testimonial_type_sl_grid']) { ?>
            <div class="swiper addon-slider-<?php echo esc_attr($unique); ?> rs-addon-slider rs-testimonial-slider style<?php echo esc_attr($settings['testimonial_style']); ?> <?php echo esc_attr($slFor); ?> <?php echo esc_attr( $clip_path_enable ); ?> nav-icon-<?php echo esc_attr($settings['slider_nav_icon_style']); ?> slick-dots-<?php echo esc_attr($settings['slider_dots_style']); ?>" dir="<?php echo esc_attr(('true' === $rtl) ? 'rtl' : 'ltr'); ?>">
        <?php } else { ?>
            <div class="rs-testimonial-slider style<?php echo esc_attr($settings['testimonial_style']); ?> <?php echo esc_attr( $clip_path_enable ); ?>">
                <div class="row">
        <?php } ?>
            <div class="swiper-wrapper">
                <?php foreach ($settings['testi_list'] as $index => $item) :
                $vendor_image         =  wp_get_attachment_image_url( $item['vendor_image']['id'],'full' );
                $company_logo         =  wp_get_attachment_image_url( $item['company_logo']['id'],'full' );
                $name                 = !empty($item['name']) ? $item['name'] : '';
                $title                = !empty($item['title']) ? $item['title'] : '';
                $description          = !empty($item['description']) ? $item['description'] : '';
                $designation          = !empty($item['designation']) ? $item['designation'] : '';

                // Rating Start
                if ($settings['ratings_show'] == 'yes') {
                    $ratings = $item['ratings'];
                    $ratingstars = '';
                    $fullStars = floor($ratings);
                    $halfStar = ($ratings - $fullStars) == 0.5;
                    for ($i = 1; $i <= 5; $i++) {
                        $class = ($i <= $fullStars) ? 'ri-star-fill' : 'ri-star-line';
                        
                        if ($i == $fullStars + 1 && $halfStar) {
                            $class = 'ri-star-half-line';
                        }
                        $ratingstars .= '<i class="' . $class . '"></i>';
                    }
                }
                
                    if ('3' == $settings['testimonial_style']) {
                        include plugin_dir_path(__FILE__) . "/style3.php";
                    } elseif ('2' == $settings['testimonial_style']) {
                        include plugin_dir_path(__FILE__) . "/style2.php";
                    } else {
                        include plugin_dir_path(__FILE__) . "/style1.php";
                    }
                endforeach; ?>
            </div>

            <?php if ('true' === $settings['slider_nav']) { ?>
                <div class="swiper-button-next"></div>
                <div class="swiper-button-prev"></div>
            <?php }
            if ('true' === $settings['slider_dots']) { ?>
                <div class="swiper-pagination"></div>
            <?php }
            if ('true' === $settings['slider_scrollbar']) { ?>
                <div class="swiper-scrollbar"></div>
            <?php }
            if ('true' === $settings['slide_item_circle_progress']) { ?>
                <div class="autoplay-progress">
                    <svg viewBox="0 0 48 48">
                        <circle class="normal" cx="24" cy="24" r="20"></circle>
                        <circle cx="24" cy="24" r="20"></circle>
                    </svg>
                    <span></span>
                </div>
            <?php } ?>
        </div>
        <?php if ('yes' == $settings['thumbnail_slider']) {
            $thumb_cols = [
                'desktop' => !empty($settings['thumb_col_desktop']) ? $settings['thumb_col_desktop'] : '3',
                'lg' => !empty($settings['thumb_col_lg']) ? $settings['thumb_col_lg'] : '3',
                'md' => !empty($settings['thumb_col_md']) ? $settings['thumb_col_md'] : '3',
                'sm' => !empty($settings['thumb_col_sm']) ? $settings['thumb_col_sm'] : '3',
                'xs' => !empty($settings['thumb_col_xs']) ? $settings['thumb_col_xs'] : '3',
            ];

            $thumb_gap = [
                'desktop' => !empty($settings['thumb_col_gap_desktop']['size']) ? $settings['thumb_col_gap_desktop']['size'] : 30,
                'lg' => !empty($settings['thumb_col_gap_lg']['size']) ? $settings['thumb_col_gap_lg']['size'] : 30,
                'md' => !empty($settings['thumb_col_gap_md']['size']) ? $settings['thumb_col_gap_md']['size'] : 30,
                'sm' => !empty($settings['thumb_col_gap_sm']['size']) ? $settings['thumb_col_gap_sm']['size'] : 20,
                'xs' => !empty($settings['thumb_col_gap_xs']['size']) ? $settings['thumb_col_gap_xs']['size'] : 10,
            ];

            $thumb_vertical = [
                'desktop' => !empty($settings['thumb_col_desktop_vertical']) ? $settings['thumb_col_desktop_vertical'] : 'horizontal',
                'lg' => !empty($settings['thumb_col_lg_vertical']) ? $settings['thumb_col_lg_vertical'] : 'horizontal',
                'md' => !empty($settings['thumb_col_md_vertical']) ? $settings['thumb_col_md_vertical'] : 'horizontal',
                'sm' => !empty($settings['thumb_col_sm_vertical']) ? $settings['thumb_col_sm_vertical'] : 'horizontal',
                'xs' => !empty($settings['thumb_col_xs_vertical']) ? $settings['thumb_col_xs_vertical'] : 'horizontal',
            ];?>
            <div class="<?php echo esc_attr($slNav) ?> swiper thumb-sl-nav" thumbsSlider="" lenis-prevent-default>
                <div class="swiper-wrapper">
                    <?php foreach ($settings['testi_list'] as $index => $item) {
                        $vendor_image  =  wp_get_attachment_image_url( $item['vendor_image']['id'],'full' ); ?>
                        <div class="swiper-slide">
                            <div class="vendor-img">
                                <img src="<?php echo esc_url($vendor_image); ?>" alt="<?php echo esc_attr(Control_Media::get_image_alt($item['vendor_image'])); ?>">
                            </div>
                        </div>
                    <?php } ?>
                </div>
            </div>
        <?php } ?>
    <?php if ('slider' === $settings['testimonial_type_sl_grid']) { ?>
        <div class="rsaddon-slider-conf d-none" data-conf="<?php echo htmlspecialchars(json_encode($slider_conf)); ?>"></div>
        </div>
        <script>
            jQuery(document).ready(function($) {
                $('#rs-unique-slider-<?php echo esc_attr($unique); ?>').each(function() {
                    <?php if ('yes' == $settings['thumbnail_slider']) { ?>
                        var swiperThumb = new Swiper(".<?php echo esc_attr($slNav) ?>", {
                            spaceBetween: <?php echo esc_js($thumb_gap['desktop']); ?>,
                            slidesPerView: <?php echo esc_js($thumb_cols['desktop']); ?>,
                            direction: "<?php echo esc_attr($thumb_vertical['desktop']); ?>",
                            autoHeight: true,
                            breakpoints: {
                                100: {
                                    slidesPerView: <?php echo esc_js($thumb_cols['xs']); ?>,
                                    direction: "<?php echo esc_attr($thumb_vertical['xs']); ?>",
                                    spaceBetween: <?php echo esc_js($thumb_gap['xs']); ?>,
                                },
                                576: {
                                    slidesPerView: <?php echo esc_js($thumb_cols['sm']); ?>,
                                    direction: "<?php echo esc_attr($thumb_vertical['sm']); ?>",
                                    spaceBetween: <?php echo esc_js($thumb_gap['sm']); ?>,
                                },
                                768: {
                                    slidesPerView: <?php echo esc_js($thumb_cols['md']); ?>,
                                    direction: "<?php echo esc_attr($thumb_vertical['md']); ?>",
                                    spaceBetween: <?php echo esc_js($thumb_gap['md']); ?>,
                                },
                                992: {
                                    slidesPerView: <?php echo esc_js($thumb_cols['lg']); ?>,
                                    direction: "<?php echo esc_attr($thumb_vertical['lg']); ?>",
                                    spaceBetween: <?php echo esc_js($thumb_gap['lg']); ?>,
                                },
                                1200: {
                                    slidesPerView: <?php echo esc_js($thumb_cols['desktop']); ?>,
                                    direction: "<?php echo esc_attr($thumb_vertical['desktop']); ?>",
                                    spaceBetween: <?php echo esc_js($thumb_gap['desktop']); ?>,
                                },
                            },
                        });
                    <?php } ?>

                    var $slider = $(this);
                    var dataConf = $slider.find('.rsaddon-slider-conf').attr('data-conf');
                    var slider_conf = JSON.parse(dataConf);
                    if (slider_conf) {
                        const progressCircle = $slider.find(".autoplay-progress svg")[0];
                        const progressContent = $slider.find(".autoplay-progress span")[0];
                        var swiper = new Swiper(".addon-slider-<?php echo esc_attr($unique); ?>", {
                            slidesPerView: slider_conf.col_desktop,
                            speed: parseInt(slider_conf.sliderSpeed),
                            slidesPerGroup: parseInt(slider_conf.slidesToScroll),
                            spaceBetween: parseInt(slider_conf.spaceBetween),
                            loop: slider_conf.infinite === 'true' ? true : false,
                            freeMode: slider_conf.freeMode === 'true' ? true : false,
                            grabCursor: slider_conf.grabCursor === 'true' ? true : false,
                            mousewheel: slider_conf.mousewheel === 'true' ? true : false,
                            autoHeight: slider_conf.autoHeight === 'true' ? true : false,
                            centeredSlides: slider_conf.centerMode === 'true' ? true : false,
                            rtl: <?php echo esc_js($rtl); ?>,
                            effect: slider_conf.slideEffect, // 'fade', cube', 'coverflow', 'flip', 'cards', 'creative'
                            keyboard: {
                                enabled: slider_conf.keyboardControl === 'true' ? true : false,
                            },
                            navigation: {
                                nextEl: $slider.find(".swiper-button-next")[0],
                                prevEl: $slider.find(".swiper-button-prev")[0],
                            },
                            pagination: {
                                el: $slider.find(".swiper-pagination")[0],
                                clickable: true,
                                dynamicBullets: slider_conf.dynamicBullets === 'true' ? true : false,
                                <?php if (!empty($settings['slider_bullet_type'])) { ?>
                                    type: slider_conf.bulletType,
                                <?php } ?>
                            },
                            scrollbar: {
                                el: $slider.find(".swiper-scrollbar")[0],
                                hide: false,
                                draggable: true,
                            },
                            <?php if ('true' === $settings['slider_autoplay']) { ?>
                                autoplay: {
                                    delay: parseInt(slider_conf.interval),
                                    disableOnInteraction: false,
                                },
                                <?php if ('true' === $settings['slide_item_circle_progress']) { ?>
                                    on: {
                                        autoplayTimeLeft(s, time, progress) {
                                            progressCircle.style.setProperty("--progress", 1 - progress);
                                            progressContent.textContent = `${Math.ceil(time / 1000)}s`;
                                        }
                                    },
                                <?php }
                            } ?>

                            <?php if ('cards' === $settings['slider_effect']) { ?>
                                cardsEffect: {
                                    perSlideOffset: 12,
                                },
                            <?php } ?>
                            
                            <?php if ('creative' === $settings['slider_effect']) {
                                if ('two' === $settings['slider_creative_style']) { ?>
                                    creativeEffect: {
                                        prev: {
                                            shadow: true,
                                            translate: ["-120%", 0, -500],
                                        },
                                        next: {
                                            shadow: true,
                                            translate: ["120%", 0, -500],
                                        },
                                    },
                                <?php } elseif ('three' === $settings['slider_creative_style']) { ?>
                                    creativeEffect: {
                                        prev: {
                                            shadow: true,
                                            translate: ["-125%", 0, -800],
                                            rotate: [0, 0, -90],
                                        },
                                        next: {
                                            shadow: true,
                                            translate: ["125%", 0, -800],
                                            rotate: [0, 0, 90],
                                        },
                                    },
                                <?php } elseif ('four' === $settings['slider_creative_style']) { ?>
                                    creativeEffect: {
                                        prev: {
                                            shadow: true,
                                            origin: "left center",
                                            translate: ["-10%", 0, -200],
                                            rotate: [0, 100, 0],
                                        },
                                        next: {
                                            origin: "right center",
                                            translate: ["10%", 0, -200],
                                            rotate: [0, -100, 0],
                                        },
                                    },
                                <?php } else { ?>
                                    creativeEffect: {
                                        prev: {
                                            shadow: true,
                                            translate: ["-20%", 0, -1],
                                        },
                                        next: {
                                            translate: ["100%", 0, 0],
                                        },
                                    },
                                <?php }
                            }

                            if ('yes' == $settings['thumbnail_slider']) { ?>
                                thumbs: {
                                    swiper: swiperThumb,
                                },
                            <?php } ?>
                            
                            breakpoints: {
                                100: {
                                    slidesPerView: slider_conf.col_xs,
                                    spaceBetween: parseInt(slider_conf.spaceBetweenXs),
                                },
                                576: {
                                    slidesPerView: slider_conf.col_sm,
                                    spaceBetween: parseInt(slider_conf.spaceBetweenSm),
                                },
                                768: {
                                    slidesPerView: slider_conf.col_md,
                                    spaceBetween: parseInt(slider_conf.spaceBetweenMd),
                                },
                                992: {
                                    slidesPerView: slider_conf.col_lg,
                                    spaceBetween: parseInt(slider_conf.spaceBetweenLg),
                                },
                                1200: {
                                    slidesPerView: slider_conf.col_desktop,
                                    spaceBetween: parseInt(slider_conf.spaceBetween),
                                },
                            },
                        });
                        <?php if (('true' === $settings['slider_autoplay']) && ('true' === $settings['slider_stop_on_hover'])) { ?>
                            $slider.mouseenter(function(){
                                swiper.autoplay.pause();
                            });
                            $slider.mouseleave(function(){
                                swiper.autoplay.resume();
                            });
                        <?php } ?>
                    }
                });
            });
        </script>
    <?php } else { ?>
            </div>
        </div>
    <?php } ?>

<?php
    }
}