<?php
/**
 * Plugin Name: Logitic Header & Footer Builder
 * Plugin URI:  https://rstheme.com
 * Description: Logitic Header & Footer Builder
 * Author:      RSTheme
 * Author URI:  https://www.rstheme.com/
 * Text Domain: logitic-hfe
 * Domain Path: /languages
 * Version: 1.0.3
 */

define( 'RSHFE_VER', '1.0.3' );
define( 'RSHFE_FILE', __FILE__ );
define( 'RSHFE_DIR', plugin_dir_path( __FILE__ ) );
define( 'RSHFE_URL', plugins_url( '/', __FILE__ ) );
define( 'RSHFE_PATH', plugin_basename( __FILE__ ) );
define( 'RSHFE_DOMAIN', trailingslashit( 'https://rstheme.com' ) );
define( 'RSHFE_DIR_URL_ADMIN', plugin_dir_url( __FILE__ ) );
define( 'RSHFE_ASSETS_ADMIN', trailingslashit( RSHFE_DIR_URL_ADMIN ) );

/**
 * Load the class loader.
 */
require_once RSHFE_DIR . '/inc/class-header-footer-elementor.php';

/**
 * Load the Plugin Class.
 */
function rshfe_plugin_activation() {

	$footer_widget = rsrshfe_footer_widget_func();
	update_option( 'rshfe_plugin_is_activated', 'yes' );
	update_option( 'rshfe_addon_option', $footer_widget );
}
register_activation_hook( RSHFE_FILE, 'rshfe_plugin_activation' );

/**
 * Load the Plugin Class.
 */
function rshfe_init() {
	RSHeader_Footer_Elementor::instance();
}
add_action( 'plugins_loaded', 'rshfe_init' );

function rsrshfe_footer_widget_func() {
	$array = [
		'rshfe_copyright' => 'rshfe_copyright',
		'rsrshfe_header_button' => 'rsrshfe_header_button',
		'rshfe_navigation_menu' => 'rshfe_navigation_menu' ,
		'rshfe_site_logo' => 'rshfe_site_logo',
		'rshfe_page_title' => 'rshfe_page_title',
		'rshfe_search' => 'rshfe_search',
		'rshfe_meta' => 'rshfe_meta'
	];

	return $array;
}
