<?php
function logitic_404_panel($logitic_customizer, $priority)
{
    $logitic_customizer->add_section('logitic_404_setting',
        array(
            'title'       => esc_html__('404 Page Settings', 'logitic'),
            'panel'       => 'logitic_options_panel',
            'priority'    => $priority,
            'capability'  => 'edit_theme_options',
            'description' => esc_html__('Allows you to customize 404 page.', 'logitic'),
        )
    );

    //404
    $logitic_customizer->add_setting('logitic_404_title', array(
        'default'   => esc_html__('404', 'logitic'),
        'transport' => 'refresh',
    ));
    $logitic_customizer->add_control('logitic_404_title', array(
        'label'       => esc_html__('Title', 'logitic'),
        'description' => esc_html__('Enter title for 404 page', 'logitic'),
        'section'     => 'logitic_404_setting',
        'type'        => 'text',
        'setting'     => 'logitic_404_title',
    ));

    //Start separator
    $logitic_customizer->add_setting(
        '404_hr_0',
        array(
            'default' => '',
            'sanitize_callback' => 'esc_html',
        )
    );
    $logitic_customizer->add_control(
        new logitic_Separator_Control(
            $logitic_customizer,
            '404_hr_0',
            array(
                'settings' => '404_hr_0',
                'section'  => 'logitic_404_setting',
            )
        )
    );
    //End separator

    //404
    $logitic_customizer->add_setting('logitic_404_text', array(
        'default'   => esc_html__('Page Not Found', 'logitic'),
        'transport' => 'refresh',
    ));
    $logitic_customizer->add_control('logitic_404_text', array(
        'label'       => esc_html__('Text', 'logitic'),
        'description' => esc_html__('Enter text for 404 page', 'logitic'),
        'section'     => 'logitic_404_setting',
        'type'        => 'text',
        'setting'     => 'logitic_404_text',
    ));
    //End

    //Start separator
    $logitic_customizer->add_setting(
        '404_hr_1',
        array(
            'default' => '',
            'sanitize_callback' => 'esc_html',
        )
    );
    $logitic_customizer->add_control(
        new logitic_Separator_Control(
            $logitic_customizer,
            '404_hr_1',
            array(
                'settings' => '404_hr_1',
                'section'  => 'logitic_404_setting',
            )
        )
    );
    //End separator

    //404
    $logitic_customizer->add_setting('logitic_404_home_button_label', array(
        'default'   => esc_html__('Back to Homepage', 'logitic'),
        'transport' => 'refresh',
    ));
    $logitic_customizer->add_control('logitic_404_home_button_label', array(
        'label'       => esc_html__('Back to Home Button Label', 'logitic'),
        'description' => esc_html__('Enter label for "Back to Home" button', 'logitic'),
        'section'     => 'logitic_404_setting',
        'type'        => 'text',
        'setting'     => 'logitic_404_home_button_label',
    ));
    //End

    //Start separator
    $logitic_customizer->add_setting(
        '404_hr_2',
        array(
            'default' => '',
            'sanitize_callback' => 'esc_html',
        )
    );
    $logitic_customizer->add_control(
        new logitic_Separator_Control(
            $logitic_customizer,
            '404_hr_2',
            array(
                'settings' => '404_hr_2',
                'section'  => 'logitic_404_setting',
            )
        )
    );
    //End separator

    //Start default header logo
    $logitic_customizer->add_setting(
        'logitic_404_page_bg',
        array(
            'transport' => 'refresh',
        )
    );
    $logitic_customizer->add_control(
        new WP_Customize_Image_Control(
            $logitic_customizer,
            'logitic_404_page_bg',
            array(
                'label'    => esc_html__('Upload 404 Page Bg', 'logitic'),
                'section'  => 'logitic_404_setting',
                'settings' => 'logitic_404_page_bg',
            )
        )
    );
    //End default logo

    //Start separator
    $logitic_customizer->add_setting(
        'team_hr_3',
        array(
            'default' => '',
            'sanitize_callback' => 'esc_html',
        )
    );
    $logitic_customizer->add_control(
        new logitic_Separator_Control(
            $logitic_customizer,
            'team_hr_3',
            array(
                'settings' => 'team_hr_3',
                'section'  => 'logitic_404_setting',
            )
        )
    );
    //End separator

    //Start Body Background Color
    $logitic_customizer->add_setting(
        'logitic_404_text_color',
        array(
            'default' => '#FFFFFF',
        )
    );
    $logitic_customizer->add_control(
        new WP_Customize_Color_Control(
            $logitic_customizer,
            'logitic_404_text_color',
            array(
                'label'       => esc_html__('Text Color', 'logitic'),
                'description' => esc_html__('Text Color', 'logitic'),
                'section'     => 'logitic_404_setting',
                'settings'    => 'logitic_404_text_color',
            )
        )
    );
    //End Body Background Color

    //Start separator
    $logitic_customizer->add_setting(
        'team_hr_4',
        array(
            'default' => '',
            'sanitize_callback' => 'esc_html',
        )
    );
    $logitic_customizer->add_control(
        new logitic_Separator_Control(
            $logitic_customizer,
            'team_hr_4',
            array(
                'settings' => 'team_hr_4',
                'section'  => 'logitic_404_setting',
            )
        )
    );
    //End separator

    //Start Color
    $logitic_customizer->add_setting(
        'logitic_404_btn_bg_color',
    );
    $logitic_customizer->add_control(
        new WP_Customize_Color_Control(
            $logitic_customizer,
            'logitic_404_btn_bg_color',
            array(
                'label'       => esc_html__('Button Background Color', 'logitic'),
                'description' => esc_html__('choose button background color', 'logitic'),
                'section'     => 'logitic_404_setting',
                'settings'    => 'logitic_404_btn_bg_color',
            )
        )
    );
    //End Color

    //Start separator
    $logitic_customizer->add_setting(
        'team_hr_5',
        array(
            'default' => '',
            'sanitize_callback' => 'esc_html',
        )
    );
    $logitic_customizer->add_control(
        new logitic_Separator_Control(
            $logitic_customizer,
            'team_hr_5',
            array(
                'settings' => 'team_hr_5',
                'section'  => 'logitic_404_setting',
            )
        )
    );
    //End separator

    //Start Color
    $logitic_customizer->add_setting(
        'logitic_404_btn_text_color',
    );
    $logitic_customizer->add_control(
        new WP_Customize_Color_Control(
            $logitic_customizer,
            'logitic_404_btn_text_color',
            array(
                'label'       => esc_html__('Button Text Color', 'logitic'),
                'description' => esc_html__('Choose button text color', 'logitic'),
                'section'     => 'logitic_404_setting',
                'settings'    => 'logitic_404_btn_text_color',
            )
        )
    );
    //End Color

    //Start separator
    $logitic_customizer->add_setting(
        'team_hr_6',
        array(
            'default' => '',
            'sanitize_callback' => 'esc_html',
        )
    );
    $logitic_customizer->add_control(
        new logitic_Separator_Control(
            $logitic_customizer,
            'team_hr_6',
            array(
                'settings' => 'team_hr_6',
                'section'  => 'logitic_404_setting',
            )
        )
    );
    //End separator

}
