<?php
function logitic_blog_page_style_panel( $logitic_customizer, $priority ){
    $logitic_customizer->add_section( 'logitic_blog_page_style_setting' , array(
        'title'      => esc_html__( 'Blog Page', 'logitic' ),
        'priority'   => $priority,
        'panel'		 => 'logitic_blog_setting'
    ) );

	//Start default Page Banner
	$logitic_customizer->add_setting(
		'logitic_blog_page_bg', 
		array(
		'transport'		=> 'refresh'
		)
	);
	$logitic_customizer->add_control(
		new WP_Customize_Image_Control(
		$logitic_customizer,
		'logitic_blog_page_bg',
			array(
			'label'      => esc_html__( 'Blog Page Image', 'logitic' ),
			'section'    => 'logitic_blog_page_style_setting',
			'settings'   => 'logitic_blog_page_bg',
			)
		)   
	);
	//End default Page Banner

	//Start separator
	$logitic_customizer->add_setting(
		'blog_page_hr_0', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$logitic_customizer->add_control(
		new logitic_Separator_Control(
			$logitic_customizer, 
			'blog_page_hr_0', 
			array(
				'settings'		=> 'blog_page_hr_0',
				'section'  		=> 'logitic_blog_page_style_setting',
			)
		)
	);
	//End separator
	

	//Start Background Color
	$logitic_customizer->add_setting (
        'logitic_blog_page_bg_color'
    );
    $logitic_customizer->add_control(
        new WP_Customize_Color_Control(
            $logitic_customizer,
            'logitic_blog_page_bg_color',
            array(
                'label'      => esc_html__('Body Backgroud Color','logitic'),
                'description'      => esc_html__('Pick body background color','logitic'),
                'section'    => 'logitic_blog_page_style_setting',
                'settings'   => 'logitic_blog_page_bg_color',
            )
        )
    );
	//End Background Color

	//Start separator
	$logitic_customizer->add_setting(
		'blog_page_hr_1', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$logitic_customizer->add_control(
		new logitic_Separator_Control(
			$logitic_customizer, 
			'blog_page_hr_1', 
			array(
				'settings'		=> 'blog_page_hr_1',
				'section'  		=> 'logitic_blog_page_style_setting',
			)
		)
	);
	//End separator


	//Start
	$logitic_customizer->add_setting( 'logitic_blog_page_sidebar_setting', array(
		'default'           => 'blog_no_sidebar',
		'transport'	        => 'postMessage',
	) );
	$logitic_customizer->add_control( 'logitic_blog_page_sidebar_setting', array(
		'label'   => esc_html__( 'Sidebar Setting', 'logitic' ),
		'section' => 'logitic_blog_page_style_setting',
		'type'    => 'select',
		'choices' => array(
			'blog_no_sidebar' => esc_html__( 'Full Width', 'logitic' ),
			'blog_left_sidebar' => esc_html__( 'Left Sidebar', 'logitic' ),
			'blog_right_sidebar'  => esc_html__( 'Right Sidebar', 'logitic' ),
		),
	) );
	//End

	//Start separator
	$logitic_customizer->add_setting(
		'blog_page_hr_4', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$logitic_customizer->add_control(
		new logitic_Separator_Control(
			$logitic_customizer, 
			'blog_page_hr_4', 
			array(
				'settings'		=> 'blog_page_hr_4',
				'section'  		=> 'logitic_blog_page_style_setting',
			)
		)
	);
	//End separator

	//Start Hide Author
	$logitic_customizer->add_setting( 'logitic_blog_page_hide_author', 
	array(
		'default'           => 0,
	)
	);
	$logitic_customizer->add_control(
		new logitic_Customize_Switch_Control(
			$logitic_customizer,
			'logitic_blog_page_hide_author',
			array(
				'type' => 'switch',
				'label' => esc_html__('Hide Author','logitic'),
				'description' => esc_html__('If you want to hide author click ON button','logitic'),
				'section' => 'logitic_blog_page_style_setting'
			)
		)
	);
	//End Hide Author

	//Start separator
	$logitic_customizer->add_setting(
		'blog_page_hr_5', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$logitic_customizer->add_control(
		new logitic_Separator_Control(
			$logitic_customizer, 
			'blog_page_hr_5', 
			array(
				'settings'		=> 'blog_page_hr_5',
				'section'  		=> 'logitic_blog_page_style_setting',
			)
		)
	);
	//End separator

	//Start Hide Date
	$logitic_customizer->add_setting( 'logitic_blog_page_hide_date', 
	array(
		'default'    => 0,
		) 
	);
	$logitic_customizer->add_control(
		new logitic_Customize_Switch_Control(
			$logitic_customizer,
			'logitic_blog_page_hide_date',
			array(
				'type' => 'switch',
				'label' => esc_html__('Hide Date','logitic'),
				'description' => esc_html__('If you want to hide date click ON button','logitic'),
				'section' => 'logitic_blog_page_style_setting'
			)
		)
	);
	//End Hide Date

	//Start separator
	$logitic_customizer->add_setting(
		'blog_page_hr_6', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$logitic_customizer->add_control(
		new logitic_Separator_Control(
			$logitic_customizer, 
			'blog_page_hr_6', 
			array(
				'settings'		=> 'blog_page_hr_6',
				'section'  		=> 'logitic_blog_page_style_setting',
			)
		)
	);
	//End separator

	//Start Hide Date
	$logitic_customizer->add_setting( 'logitic_blog_page_hide_categiry', 
	array(
		'default'    => 0,
		) 
	);
	$logitic_customizer->add_control(
		new logitic_Customize_Switch_Control(
			$logitic_customizer,
			'logitic_blog_page_hide_categiry',
			array(
				'type' => 'switch',
				'label' => esc_html__('Hide Category','logitic'),
				'description' => esc_html__('If you want to hide categoy click ON button','logitic'),
				'section' => 'logitic_blog_page_style_setting'
			)
		)
	);
	//End Hide Date

	//Start separator
	$logitic_customizer->add_setting(
		'blog_page_hr_7', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$logitic_customizer->add_control(
		new logitic_Separator_Control(
			$logitic_customizer, 
			'blog_page_hr_7', 
			array(
				'settings'		=> 'blog_page_hr_7',
				'section'  		=> 'logitic_blog_page_style_setting',
			)
		)
	);
	//End separator

	//Start Blog Page Custom Title
	$logitic_customizer->add_setting(
		'logitic_blog_page_custom_read_more',
		array(
			'transport'		=> 'refresh',
		)
	 );

	 $logitic_customizer->add_control('logitic_blog_page_custom_read_more', array(
        'section'	=> 'logitic_blog_page_style_setting',
        'label'		=> esc_html__( 'Blog Read More Text', 'logitic' ),
        'description' => esc_html__( 'Enter Blog Read More Here', 'logitic' ),
        'type'		=> 'text',
        'setting'	=> 'logitic_blog_page_custom_read_more'
    ));
	//End Blog Page Custom Title

	//Start separator
	$logitic_customizer->add_setting(
		'blog_page_hr_8', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$logitic_customizer->add_control(
		new logitic_Separator_Control(
			$logitic_customizer, 
			'blog_page_hr_8', 
			array(
				'settings'		=> 'blog_page_hr_8',
				'section'  		=> 'logitic_blog_page_style_setting',
			)
		)
	);
	//End separator

	//Start
	$logitic_customizer->add_setting( 'logitic_blog_page_btn_setting', array(
	 	'default'           => 'rs-flat',
	 	'transport'	        => 'postMessage',
	));

	$logitic_customizer->add_control( 'logitic_blog_page_btn_setting', array(
	 	'label'   => esc_html__( 'Button Setting', 'logitic' ),
	 	'section' => 'logitic_blog_page_style_setting',
	 	'type'    => 'select',
	 	'choices' => array(
	 		'rs-default' => esc_html__( 'Default Style', 'logitic' ),
	 		'rs-border' => esc_html__( 'Border Style', 'logitic' ),
	 		'rs-flat' => esc_html__( 'Flat Style', 'logitic' )
	 	),
	));
	//End
}