<?php
function logitic_blog_single_style_panel( $logitic_customizer, $priority ){
    $logitic_customizer->add_section( 'logitic_blog_single_style_setting' , array(
        'title'      => esc_html__( 'Blog Single', 'logitic' ),
        'priority'   => $priority,
        'panel'		 => 'logitic_blog_setting'
    ) );


	//Start
	$logitic_customizer->add_setting( 'logitic_blog_single_sidebar_setting', array(
		'default'           => 'blog_single_no_sidebar',
		'transport'	        => 'postMessage',
	) );
	$logitic_customizer->add_control( 'logitic_blog_single_sidebar_setting', array(
		'label'   => esc_html__( 'Sidebar Setting', 'logitic' ),
		'section' => 'logitic_blog_single_style_setting',
		'type'    => 'select',
		'choices' => array(
			'blog_single_no_sidebar' => esc_html__( 'Full Width', 'logitic' ),
			'2left' => esc_html__( 'Left Sidebar', 'logitic' ),
			'2right'  => esc_html__( 'Right Sidebar', 'logitic' ),
		),
	) );
	//End

	//Start separator
	$logitic_customizer->add_setting(
		'blog_single_hr_00', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$logitic_customizer->add_control(
		new logitic_Separator_Control(
			$logitic_customizer, 
			'blog_single_hr_00', 
			array(
				'settings'		=> 'blog_single_hr_00',
				'section'  		=> 'logitic_blog_single_style_setting',
			)
		)
	);
	//End separator

	//Start Hide Author
	$logitic_customizer->add_setting( 'logitic_blog_single_hide_author', 
	array(
		'default'    => 0,
		) 
	);
	$logitic_customizer->add_control(
		new logitic_Customize_Switch_Control(
			$logitic_customizer,
			'logitic_blog_single_hide_author',
			array(
				'type' => 'switch',
				'label' => esc_html__('Hide Author','logitic'),
				'description' => esc_html__('You can show or hide Author','logitic'),
				'section' => 'logitic_blog_single_style_setting'
			)
		)
	);
	//End Hide Author

	//Start separator
	$logitic_customizer->add_setting(
		'blog_single_hr_1', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$logitic_customizer->add_control(
		new logitic_Separator_Control(
			$logitic_customizer, 
			'blog_single_hr_1', 
			array(
				'settings'		=> 'blog_single_hr_1',
				'section'  		=> 'logitic_blog_single_style_setting',
			)
		)
	);
	//End separator

	//Start Hide Date
	$logitic_customizer->add_setting( 'logitic_blog_single_hide_comment', 
	array(
		'default'    => 0,
		) 
	);
	$logitic_customizer->add_control(
		new logitic_Customize_Switch_Control(
			$logitic_customizer,
			'logitic_blog_single_hide_comment',
			array(
				'type' => 'switch',
				'label' => esc_html__('Hide Comment','logitic'),
				'description' => esc_html__('You can show or hide comment','logitic'),
				'section' => 'logitic_blog_single_style_setting'
			)
		)
	);
	//End Hide Date

	//Start separator
	$logitic_customizer->add_setting(
		'blog_single_hr_2', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$logitic_customizer->add_control(
		new logitic_Separator_Control(
			$logitic_customizer, 
			'blog_single_hr_2', 
			array(
				'settings'		=> 'blog_single_hr_2',
				'section'  		=> 'logitic_blog_single_style_setting',
			)
		)
	);
	//End separator

	//Start Hide Published
	$logitic_customizer->add_setting( 'logitic_blog_single_hide_published', 
	array(
		'default'    => 0,
		) 
	);
	$logitic_customizer->add_control(
		new logitic_Customize_Switch_Control(
			$logitic_customizer,
			'logitic_blog_single_hide_published',
			array(
				'type' => 'switch',
				'label' => esc_html__('Hide Published','logitic'),
				'description' => esc_html__('You can show or hide published','logitic'),
				'section' => 'logitic_blog_single_style_setting'
			)
		)
	);
	//End Hide Published

	//Start separator
	$logitic_customizer->add_setting(
		'blog_single_hr_3', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$logitic_customizer->add_control(
		new logitic_Separator_Control(
			$logitic_customizer, 
			'blog_single_hr_3', 
			array(
				'settings'		=> 'blog_single_hr_3',
				'section'  		=> 'logitic_blog_single_style_setting',
			)
		)
	);
	//End separator

	//Start Hide Category
	$logitic_customizer->add_setting( 'logitic_blog_single_hide_categiry', 
	array(
		'default'    => 0,
		) 
	);
	$logitic_customizer->add_control(
		new logitic_Customize_Switch_Control(
			$logitic_customizer,
			'logitic_blog_single_hide_categiry',
			array(
				'type' => 'switch',
				'label' => esc_html__('Hide Category','logitic'),
				'description' => esc_html__('You can show or hide categiry','logitic'),
				'section' => 'logitic_blog_single_style_setting'
			)
		)
	);
	//End Hide Category

	//Start separator
	$logitic_customizer->add_setting(
		'blog_single_hr_4', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$logitic_customizer->add_control(
		new logitic_Separator_Control(
			$logitic_customizer, 
			'blog_single_hr_4', 
			array(
				'settings'		=> 'blog_single_hr_4',
				'section'  		=> 'logitic_blog_single_style_setting',
			)
		)
	);
	//End separator

	$logitic_customizer->add_setting( 'logitic_blog_single_feature_img_in_col', 
	array(
		'default'    => 0,
		) 
	);
	$logitic_customizer->add_control(
		new logitic_Customize_Switch_Control(
			$logitic_customizer,
			'logitic_blog_single_feature_img_in_col',
			array(
				'type' => 'switch',
				'label' => esc_html__('Feature Image Inside','logitic'),
				'description' => esc_html__('Enable if you want feature image inside column.','logitic'),
				'section' => 'logitic_blog_single_style_setting'
			)
		)
	);
}