<?php
function logitic_custom_fonts_panel($logitic_customizer, $priority)
{
    $logitic_customizer->add_section('logitic_custom_fonts_panel', array(
        'title'    => esc_html__('Custom Fonts Settings', 'logitic'),
        'priority' => $priority,
        'panel'    => 'logitic_options_panel',
    ));

    $font_weight = [
        'normal' => esc_html__('Normal', 'logitic' ),
        '300' => esc_html__('300', 'logitic' ),
        '400' => esc_html__('400', 'logitic' ),
        '500' => esc_html__('500', 'logitic' ),
        '600' => esc_html__('600', 'logitic' ),
        '700' => esc_html__('700', 'logitic' ),
        '800' => esc_html__('800', 'logitic' ),
        '900' => esc_html__('900', 'logitic' ),
    ];

    //Start
    $logitic_customizer->add_setting(
        'logitic_custom_font_file', 
        array(
        'transport'     => 'refresh'
        )
    );
    $logitic_customizer->add_control(
        new WP_Customize_Upload_Control(
        $logitic_customizer,
        'logitic_custom_font_file',
            array(
            'label'      => esc_html__( 'Upload Body Font Here', 'logitic' ),
            'section'    => 'logitic_custom_fonts_panel',
            'settings'   => 'logitic_custom_font_file',
            )
        )   
    );
    //End

    //Start
    $logitic_customizer->add_setting( 'logitic_custom_body_font_weight', array(
        'default' => 'normal'
    ));

    $logitic_customizer->add_control( 'logitic_custom_body_font_weight', array(
        'type'        => 'select',
        'label'       => esc_html__( 'Font Weight', 'logitic' ),
        'description' => __( 'Select font Weight', 'logitic' ),
        'section'     => 'logitic_custom_fonts_panel',
        'choices'     => $font_weight
    ));
    //End

    //Start separator
    $logitic_customizer->add_setting(
        'separator_1', 
        array(
            'default'           => '',
            'sanitize_callback' => 'esc_html',
        )
    );
    $logitic_customizer->add_control(
        new logitic_Separator_Control(
            $logitic_customizer, 
            'separator_15', 
            array(
                'settings'      => 'separator_1',
                'section'       => 'logitic_custom_fonts_panel',
            )
        )
    );
    //End separator

    //Start
    $logitic_customizer->add_setting(
        'logitic_title_custom_font_file', 
        array(
        'transport'     => 'refresh'
        )
    );
    $logitic_customizer->add_control(
        new WP_Customize_Upload_Control(
        $logitic_customizer,
        'logitic_title_custom_font_file',
            array(
            'label'      => esc_html__( 'Upload Heading Font Here', 'logitic' ),
            'section'    => 'logitic_custom_fonts_panel',
            'settings'   => 'logitic_title_custom_font_file',
            )
        )   
    );
    //End

    //Start
    $logitic_customizer->add_setting( 'logitic_custom_title_font_weight', array(
        'default' => 'normal'
    ));
    
    $logitic_customizer->add_control( 'logitic_custom_title_font_weight', array(
        'type'        => 'select',
        'label'       => esc_html__( 'Font Weight', 'logitic' ),
        'description' => __( 'Select font Weight', 'logitic' ),
        'section'     => 'logitic_custom_fonts_panel',
        'choices'     => $font_weight
    ));
    //End
}
