<?php
function logitic_general_panel( $logitic_customizer, $priority ){
    $logitic_customizer->add_section(
		'logitic_general_section',
		array(
			'title'    => esc_html__( 'General Settings', 'logitic' ),
			'priority' => $priority,
			'panel'    => 'logitic_options_panel'
		)
	);


	//Start separator
	$logitic_customizer->add_setting(
		'separator_14', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$logitic_customizer->add_control(
		new logitic_Separator_Control(
			$logitic_customizer, 
			'separator_14', 
			array(
				'settings'		=> 'separator_14',
				'section'  		=> 'logitic_general_section',
			)
		)
	);
	//End separator

	//Start default header logo
	$logitic_customizer->add_setting(
		'rstheme_default_logo', 
		array(
		'transport'		=> 'refresh'
		)
	);
	$logitic_customizer->add_control(
		new WP_Customize_Image_Control(
		$logitic_customizer,
		'rstheme_default_logo',
			array(
			'label'      => esc_html__( 'Upload Default Logo', 'logitic' ),
			'section'    => 'logitic_general_section',
			'settings'   => 'rstheme_default_logo',
			)
		)   
	);
	//End default logo

	//Start separator
	$logitic_customizer->add_setting(
		'separator_15', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$logitic_customizer->add_control(
		new logitic_Separator_Control(
			$logitic_customizer, 
			'separator_15', 
			array(
				'settings'		=> 'separator_15',
				'section'  		=> 'logitic_general_section',
			)
		)
	);
	//End separator

	//Start separator
	$logitic_customizer->add_setting(
		'separator_3', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$logitic_customizer->add_control(
		new logitic_Separator_Control(
			$logitic_customizer, 
			'separator_3', 
			array(
				'settings'		=> 'separator_3',
				'section'  		=> 'logitic_general_section',
			)
		)
	);
	//End separator

	//Start Logo Height
	$logitic_customizer->add_setting(
		'rstheme_logo_height',
		array(
			'default' => esc_html__( '', 'logitic' ),
			'transport'		=> 'refresh',
		)
	 );

	 $logitic_customizer->add_control('rstheme_logo_height', array(
        'section'	=> 'logitic_general_section',
        'label'		=> esc_html__( 'Logo Height', 'logitic' ),
        'description' => esc_html__( 'Logo max height example(50px)', 'logitic' ),
        'type'		=> 'text',
        'setting'	=> 'rstheme_logo_height'
    ));
	//End Logo Height

	//Start separator
	$logitic_customizer->add_setting(
		'separator_4', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$logitic_customizer->add_control(
		new logitic_Separator_Control(
			$logitic_customizer, 
			'separator_4', 
			array(
				'settings'		=> 'separator_4',
				'section'  		=> 'logitic_general_section',
			)
		)
	);
	//End separator

	//Start Sticky Menu
	$logitic_customizer->add_setting( 'rstheme_enable_sticky_menu', 
	array(
			'default'    => '0',
		) 
	);
	$logitic_customizer->add_control(
		new logitic_Customize_Switch_Control(
			$logitic_customizer,
			'rstheme_enable_sticky_menu',
			array(
				'type' => 'switch',
				'label' => esc_html__('Sticky Menu','logitic'),
				'description' => esc_html__('You can show or hide sticky menu here','logitic'),
				'section' => 'logitic_general_section'
			)
		)
	);
	//End Sticky Menu

	//Start separator
	$logitic_customizer->add_setting(
		'separator_9', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$logitic_customizer->add_control(
		new logitic_Separator_Control(
			$logitic_customizer, 
			'separator_9', 
			array(
				'settings'		=> 'separator_9',
				'section'  		=> 'logitic_general_section',
			)
		)
	);
	//End separator

	//Start Sticky logo
	$logitic_customizer->add_setting(
		'rstheme_sticky_logo', 
		array(
		'transport'		=> 'refresh'
		)
	);
	$logitic_customizer->add_control(
		new WP_Customize_Image_Control(
		$logitic_customizer,
		'rstheme_sticky_logo',
			array(
			'label'      => esc_html__( 'Upload Your Sticky Logo', 'logitic' ),
			'section'    => 'logitic_general_section',
			'settings'   => 'rstheme_sticky_logo',
			)
		)   
	);
	//End Sticky logo

	//Start separator
	$logitic_customizer->add_setting(
		'separator_7', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$logitic_customizer->add_control(
		new logitic_Separator_Control(
			$logitic_customizer, 
			'separator_7', 
			array(
				'settings'		=> 'separator_7',
				'section'  		=> 'logitic_general_section',
			)
		)
	);
	//End separator

	//Start Sticky Logo Height
	$logitic_customizer->add_setting(
		'rstheme_sticky_logo_height',
		array(
			'default' => esc_html__( '25px', 'logitic' ),
			'transport'		=> 'refresh',
		)
	 );

	 $logitic_customizer->add_control('rstheme_sticky_logo_height', array(
        'section'	=> 'logitic_general_section',
        'label'		=> esc_html__( 'Sticky Logo Height', 'logitic' ),
        'description' => esc_html__( 'Sticky Logo max height example(20px)', 'logitic' ),
        'type'		=> 'text',
        'setting'	=> 'rstheme_sticky_logo_height'
    ));
	//End Sticky Logo Height

	//Start separator
	$logitic_customizer->add_setting(
		'separator_180', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$logitic_customizer->add_control(
		new logitic_Separator_Control(
			$logitic_customizer, 
			'separator_180', 
			array(
				'settings'		=> 'separator_180',
				'section'  		=> 'logitic_general_section',
			)
		)
	);
	//End separator

	//Start Footer logo
	$logitic_customizer->add_setting(
		'rstheme_footer_logo', 
		array(
		'transport'		=> 'refresh'
		)
	);
	$logitic_customizer->add_control(
		new WP_Customize_Image_Control(
		$logitic_customizer,
		'rstheme_footer_logo',
			array(
			'label'      => esc_html__( 'Upload Your Footer Logo', 'logitic' ),
			'section'    => 'logitic_general_section',
			'settings'   => 'rstheme_footer_logo',
			)
		)   
	);
	//End Footer logo

	//Start separator
	$logitic_customizer->add_setting(
		'separator_181', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$logitic_customizer->add_control(
		new logitic_Separator_Control(
			$logitic_customizer, 
			'separator_181', 
			array(
				'settings'		=> 'separator_181',
				'section'  		=> 'logitic_general_section',
			)
		)
	);
	//End separator

	//Start Footer Logo Height
	$logitic_customizer->add_setting(
		'rstheme_footer_logo_height',
		array(
			'default' => esc_html__( '36px', 'logitic' ),
			'transport'		=> 'refresh',
		)
	 );

	 $logitic_customizer->add_control('rstheme_footer_logo_height', array(
        'section'	=> 'logitic_general_section',
        'label'		=> esc_html__( 'Footer Logo Height', 'logitic' ),
        'description' => esc_html__( 'Footer Logo max height example(36px)', 'logitic' ),
        'type'		=> 'text',
        'setting'	=> 'rstheme_footer_logo_height'
    ));
	//End Footer Logo Height

	//Start separator
	$logitic_customizer->add_setting(
		'separator_80', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$logitic_customizer->add_control(
		new logitic_Separator_Control(
			$logitic_customizer, 
			'separator_80', 
			array(
				'settings'		=> 'separator_80',
				'section'  		=> 'logitic_general_section',
			)
		)
	);
	//End separator

	//Start favicon
	$logitic_customizer->add_setting(
		'logitic_favicon', 
		array(
		'transport'		=> 'refresh'
		)
	);
	$logitic_customizer->add_control(
		new WP_Customize_Image_Control(
		$logitic_customizer,
		'logitic_favicon',
			array(
			'label'      => esc_html__( 'Upload Favicon', 'logitic' ),
			'section'    => 'logitic_general_section',
			'settings'   => 'logitic_favicon',
			)
		)   
	);
	//End favicon
}