<?php
function logitic_gsap_animation_panel( $logitic_customizer, $priority ){
    $logitic_customizer->add_section( 'logitic_gsap_animation_setting' , array(
        'title'      => esc_html__( 'GSAP Animation Setting', 'logitic' ),
        'priority'   => $priority,
        'panel'		 => 'logitic_options_panel'
    ) );

	// GSAP Control Start
	$logitic_customizer->add_setting( 'gsap_animation_enable_disable', 
	array(
		'default'    => '0',
		) 
	);
	
	$logitic_customizer->add_control(
		new logitic_Customize_Switch_Control(
			$logitic_customizer,
			'gsap_animation_enable_disable',
			array(
				'type' => 'switch',
				'label' => esc_html__('GSAP Animation','logitic'),
				'description' => esc_html__('You can enable or disable GSAP Animation here','logitic'),
				'section' => 'logitic_gsap_animation_setting'
			)
		)
	);
	// GSAP Control End

	//Start separator
	$logitic_customizer->add_setting(
		'separator_0', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$logitic_customizer->add_control(
		new logitic_Separator_Control(
			$logitic_customizer, 
			'separator_0', 
			array(
				'settings'		=> 'separator_0',
				'section'  		=> 'logitic_gsap_animation_setting',
			)
		)
	);
	//End separator

	// GSAP Custom Cursor Control Start
	$logitic_customizer->add_setting( 'gsap_custom_cursor_enable_disable', 
	array(
		'default'    => '0',
		) 
	);
	
	$logitic_customizer->add_control(
		new logitic_Customize_Switch_Control(
			$logitic_customizer,
			'gsap_custom_cursor_enable_disable',
			array(
				'type' => 'switch',
				'label' => esc_html__('Custom Cursor','logitic'),
				'description' => esc_html__('You can enable or disable custom cursor. If GSAP Animation is on then it will work.','logitic'),
				'section' => 'logitic_gsap_animation_setting'
			)
		)
	);
	// GSAP Custom Cursor Control End
}