<?php
function logitic_header_panel( $logitic_customizer, $priority ){
    $logitic_customizer->add_section( 'logitic_header_setting' , array(
        'title'      => esc_html__( 'Header Settings', 'logitic' ),
        'priority'   => $priority,
        'panel'		 => 'logitic_options_panel'
    ) );

	//Start
    $logitic_customizer->add_setting(
        'logitic_header_sign_in_text',
        array(
            'transport' => 'refresh',
        )
    );
    $logitic_customizer->add_control('logitic_header_sign_in_text', array(
        'section' => 'logitic_header_setting',
        'label'   => esc_html__('Sign In', 'logitic'),
        'type'    => 'text',
        'setting' => 'logitic_header_sign_in_text',
    ));
    //End

	//Start separator
	$logitic_customizer->add_setting(
		'header_hr_0', 
		array(
			'default'           => '',
		)
	);
	$logitic_customizer->add_control(
		new logitic_Separator_Control(
			$logitic_customizer, 
			'header_hr_0', 
			array(
				'settings'		=> 'header_hr_0',
				'section'  		=> 'logitic_header_setting',
			)
		)
	);
	//End separator

	//Start Color
	$logitic_customizer->add_setting (
        'logitic_header_sign_in_text_color',
    );
    $logitic_customizer->add_control(
        new WP_Customize_Color_Control(
            $logitic_customizer,
            'logitic_header_sign_in_text_color',
            array(
                'label'       => esc_html__('Text Color','logitic'),
                'description' => esc_html__('Select Text Color','logitic'),
                'section'     => 'logitic_header_setting',
                'settings'    => 'logitic_header_sign_in_text_color',
            )
        )
    );
	//End Color

	//Start separator
	$logitic_customizer->add_setting(
		'header_hr_1', 
		array(
			'default'           => '',
		)
	);
	$logitic_customizer->add_control(
		new logitic_Separator_Control(
			$logitic_customizer, 
			'header_hr_1', 
			array(
				'settings'		=> 'header_hr_1',
				'section'  		=> 'logitic_header_setting',
			)
		)
	);
	//End separator

	//Start Color
	$logitic_customizer->add_setting (
        'logitic_header_sign_in_text_hover_color',
    );
    $logitic_customizer->add_control(
        new WP_Customize_Color_Control(
            $logitic_customizer,
            'logitic_header_sign_in_text_hover_color',
            array(
                'label'       => esc_html__('Hover Color','logitic'),
                'description' => esc_html__('Select Hover Color','logitic'),
                'section'     => 'logitic_header_setting',
                'settings'    => 'logitic_header_sign_in_text_hover_color',
            )
        )
    );
	//End Color

	//Start separator
	$logitic_customizer->add_setting(
		'header_hr_2', 
		array(
			'default'           => '',
		)
	);
	$logitic_customizer->add_control(
		new logitic_Separator_Control(
			$logitic_customizer, 
			'header_hr_2', 
			array(
				'settings'		=> 'header_hr_2',
				'section'  		=> 'logitic_header_setting',
			)
		)
	);
	//End separator

	//Start
    $logitic_customizer->add_setting(
        'logitic_header_sign_in_link',
        array(
			'default' => esc_html__( '#', 'logitic' ),
            'transport' => 'refresh',
        )
    );
    $logitic_customizer->add_control('logitic_header_sign_in_link', array(
        'section' => 'logitic_header_setting',
        'label'   => esc_html__('Sign In Link', 'logitic'),
        'type'    => 'text',
        'setting' => 'logitic_header_sign_in_link',
    ));
    //End

	//Start separator
	$logitic_customizer->add_setting(
		'header_hr_3', 
		array(
			'default'           => '',
		)
	);
	$logitic_customizer->add_control(
		new logitic_Separator_Control(
			$logitic_customizer, 
			'header_hr_3', 
			array(
				'settings'		=> 'header_hr_3',
				'section'  		=> 'logitic_header_setting',
			)
		)
	);
	//End separator

	//Start
	$logitic_customizer->add_setting( 'logitic_header_sign_in_link_new_tab', 
	array(
		'default'    => '1',
		) 
	);
	$logitic_customizer->add_control(
		new logitic_Customize_Switch_Control(
			$logitic_customizer,
			'logitic_header_sign_in_link_new_tab',
			array(
				'type'        => 'switch',
				'label'       => esc_html__('Open New Tab','logitic'),
				'description' => esc_html__('Open the link document in a new window or tab','logitic'),
				'section'     => 'logitic_header_setting'
			)
		)
	);
	//End

	//Start separator
	$logitic_customizer->add_setting(
		'header_hr_4', 
		array(
			'default'           => '',
		)
	);
	$logitic_customizer->add_control(
		new logitic_Separator_Control(
			$logitic_customizer, 
			'header_hr_4', 
			array(
				'settings'		=> 'header_hr_4',
				'section'  		=> 'logitic_header_setting',
			)
		)
	);
	//End separator

	//Start
    $logitic_customizer->add_setting(
        'logitic_header_download_text',
        array(
            'transport' => 'refresh',
        )
    );
    $logitic_customizer->add_control('logitic_header_download_text', array(
        'section' => 'logitic_header_setting',
        'label'   => esc_html__('Download', 'logitic'),
        'type'    => 'text',
        'setting' => 'logitic_header_download_text',
    ));
    //End

	//Start separator
	$logitic_customizer->add_setting(
		'header_hr_5', 
		array(
			'default'           => '',
		)
	);
	$logitic_customizer->add_control(
		new logitic_Separator_Control(
			$logitic_customizer, 
			'header_hr_5', 
			array(
				'settings'		=> 'header_hr_5',
				'section'  		=> 'logitic_header_setting',
			)
		)
	);
	//End separator

	//Start Color
	$logitic_customizer->add_setting (
        'logitic_header_download_border_color',
        array(
            'default'     => ''
        )
    );
    $logitic_customizer->add_control(
        new WP_Customize_Color_Control(
            $logitic_customizer,
            'logitic_header_download_border_color',
            array(
                'label'      => esc_html__('Border Color','logitic'),
                'description'      => esc_html__('Select Button Border Color','logitic'),
                'section'    => 'logitic_header_setting',
                'settings'   => 'logitic_header_download_border_color',
            )
        )
    );
	//End Color

	//Start separator
	$logitic_customizer->add_setting(
		'header_hr_6', 
		array(
			'default'           => '',
		)
	);
	$logitic_customizer->add_control(
		new logitic_Separator_Control(
			$logitic_customizer, 
			'header_hr_6', 
			array(
				'settings'		=> 'header_hr_6',
				'section'  		=> 'logitic_header_setting',
			)
		)
	);
	//End separator

	//Start Color
	$logitic_customizer->add_setting (
        'logitic_header_download_text_color',
        array(
            'default'     => ''
        )
    );
    $logitic_customizer->add_control(
        new WP_Customize_Color_Control(
            $logitic_customizer,
            'logitic_header_download_text_color',
            array(
                'label'      => esc_html__('Text Color','logitic'),
                'description'      => esc_html__('Select text Color','logitic'),
                'section'    => 'logitic_header_setting',
                'settings'   => 'logitic_header_download_text_color',
            )
        )
    );
	//End Color

	//Start separator
	$logitic_customizer->add_setting(
		'header_hr_7', 
		array(
			'default'           => '',
		)
	);
	$logitic_customizer->add_control(
		new logitic_Separator_Control(
			$logitic_customizer, 
			'header_hr_7', 
			array(
				'settings'		=> 'header_hr_7',
				'section'  		=> 'logitic_header_setting',
			)
		)
	);
	//End separator

	//Start Color
	$logitic_customizer->add_setting (
        'logitic_header_download_text_hover_color',
        array(
            'default'     => ''
        )
    );
    $logitic_customizer->add_control(
        new WP_Customize_Color_Control(
            $logitic_customizer,
            'logitic_header_download_text_hover_color',
            array(
                'label'      => esc_html__('Text Hover Color','logitic'),
                'description'      => esc_html__('Select Text Hover Color','logitic'),
                'section'    => 'logitic_header_setting',
                'settings'   => 'logitic_header_download_text_hover_color',
            )
        )
    );
	//End Color

	//Start separator
	$logitic_customizer->add_setting(
		'header_hr_8', 
		array(
			'default'           => '',
		)
	);
	$logitic_customizer->add_control(
		new logitic_Separator_Control(
			$logitic_customizer, 
			'header_hr_8', 
			array(
				'settings'		=> 'header_hr_8',
				'section'  		=> 'logitic_header_setting',
			)
		)
	);
	//End separator

	//Start Color
	$logitic_customizer->add_setting (
        'logitic_header_download_btn_hover_color',
        array(
            'default'     => ''
        )
    );
    $logitic_customizer->add_control(
        new WP_Customize_Color_Control(
            $logitic_customizer,
            'logitic_header_download_btn_hover_color',
            array(
                'label'      => esc_html__('Button Hover Color','logitic'),
                'description'      => esc_html__('Select Button Hover Color','logitic'),
                'section'    => 'logitic_header_setting',
                'settings'   => 'logitic_header_download_btn_hover_color',
            )
        )
    );
	//End Color

	//Start separator
	$logitic_customizer->add_setting(
		'header_hr_9', 
		array(
			'default'           => '',
		)
	);
	$logitic_customizer->add_control(
		new logitic_Separator_Control(
			$logitic_customizer, 
			'header_hr_9', 
			array(
				'settings'		=> 'header_hr_9',
				'section'  		=> 'logitic_header_setting',
			)
		)
	);
	//End separator

	//Start
    $logitic_customizer->add_setting(
        'logitic_header_download_link',
        array(
            'default' => esc_html__( '#', 'logitic' ),
            'transport' => 'refresh',
        )
    );
    $logitic_customizer->add_control('logitic_header_download_link', array(
        'section' => 'logitic_header_setting',
        'label' => esc_html__('Download Link', 'logitic'),
        'type' => 'text',
        'setting' => 'logitic_header_download_link',
    ));
    //End

	//Start separator
	$logitic_customizer->add_setting(
		'header_hr_10', 
		array(
			'default'           => '',
		)
	);
	$logitic_customizer->add_control(
		new logitic_Separator_Control(
			$logitic_customizer, 
			'header_hr_10', 
			array(
				'settings'		=> 'header_hr_10',
				'section'  		=> 'logitic_header_setting',
			)
		)
	);
	//End separator

	//Start Show Top Bar
	$logitic_customizer->add_setting( 'logitic_header_download_link_new_tab', 
	array(
		'default'    => '1',
		) 
	);
	$logitic_customizer->add_control(
		new logitic_Customize_Switch_Control(
			$logitic_customizer,
			'logitic_header_download_link_new_tab',
			array(
				'type' => 'switch',
				'label' => esc_html__('Open New Tab','logitic'),
				'description' => esc_html__('Open the link document in a new window or tab','logitic'),
				'section' => 'logitic_header_setting'
			)
		)
	);
	//End Show Top Bar

	//Start separator
	$logitic_customizer->add_setting(
		'header_hr_11', 
		array(
			'default'           => '',
		)
	);
	$logitic_customizer->add_control(
		new logitic_Separator_Control(
			$logitic_customizer, 
			'header_hr_11', 
			array(
				'settings'		=> 'header_hr_11',
				'section'  		=> 'logitic_header_setting',
			)
		)
	);
	//End separator

	//Start Meta Text Alignment
	$logitic_customizer->add_setting( 'logitic_header_width', array(
		'default'           => 'container',
		'transport'	        => 'postMessage',
	) );
	$logitic_customizer->add_control( 'logitic_header_width', array(
		'label'   => esc_html__( 'Header Area Width', 'logitic' ),
		'section' => 'logitic_header_setting',
		'type'    => 'select',
		'choices' => array(
			'container' => esc_html__( 'Container', 'logitic' ),
			'container-fluid' => esc_html__( 'Container Fluid', 'logitic' ),
			),
	));
	//End

	//Start separator
	$logitic_customizer->add_setting(
		'header_hr_12', 
		array(
			'default'           => '',
		)
	);
	$logitic_customizer->add_control(
		new logitic_Separator_Control(
			$logitic_customizer, 
			'header_hr_12', 
			array(
				'settings'		=> 'header_hr_12',
				'section'  		=> 'logitic_header_setting',
			)
		)
	);
	//End separator

	//Start Header Bg Color
	$logitic_customizer->add_setting (
        'logitic_style_header_bg_color',
        array(
            'default'     => ''
        )
    );
    $logitic_customizer->add_control(
        new WP_Customize_Color_Control(
            $logitic_customizer,
            'logitic_style_header_bg_color',
            array(
                'label'      => esc_html__('Header Bg Color','logitic'),
                'description'      => esc_html__('Select Header Bg Color','logitic'),
                'section'    => 'logitic_header_setting',
                'settings'   => 'logitic_style_header_bg_color',
            )
        )
    );
	//End Header Bg Color
}