<?php
if( !function_exists( 'logitic_customizer_register' ) ){
	function logitic_customizer_register( $logitic_customizer ){
	/*-----------------------------
	Theme Options
	-----------------------------*/
	$logitic_customizer->add_panel( 
		'logitic_options_panel',
		array(
			'title'      => esc_html__( 'Logitic Options', 'logitic' ),
			'description'=> esc_html__( 'General options of Logitic', 'logitic'),
			'priority'=> 20,
		)
	);

	/**
	 * General setting panel
	 * 
	 * @since 1.0.0
	 */
	
	logitic_general_panel( $logitic_customizer, 0 );
	//End General Setting


	 /**
	 * Start Mobile Menu Logo Style setting
	 * @since 1.0.0
	 */
	logitic_offcanvas_sidebar_panel( $logitic_customizer, 81 );
	//End Mobile Menu Logo Style setting

	 /**
	 * Start Preloader Style setting
	 * @since 1.0.0
	 */
	logitic_preloader_panel( $logitic_customizer, 82 );
	//End Preloader Style setting

	/**
	 * Start Scroll Up Style setting
	 * @since 1.0.0
	 */
	logitic_scroll_up_panel( $logitic_customizer, 83 );
	//End Scroll Up Style setting

	/**
	 * Start GSAP Animation setting
	 * @since 1.0.0
	 */
	logitic_gsap_animation_panel( $logitic_customizer, 84 );
	//End GSAP Animation setting
	
	/**
	 * Smooth Scrolling setting
	 * @since 1.0.0
	 */
	logitic_smooth_scrolling_panel( $logitic_customizer, 85 );
	//End Smooth Scrolling setting

	 /**
	 * Start Style setting
	 * @since 1.0.0
	 */
	logitic_style_panel( $logitic_customizer, 61 );
	

	/**
	 * Start Typography setting
	 * @since 1.0.0
	 */
	logitic_typography_panel( $logitic_customizer, 81 );
	//End Typography setting

	 /**
	 * Start Blog setting
	 * @since 1.0.0
	 */

	$logitic_blog_panel = new PE_WP_Customize_Panel( $logitic_customizer, 'logitic_blog_setting', array(
		'title' => esc_html__( 'Blog Settings', 'logitic' ),
		'panel' => 'logitic_options_panel',
		'priority' => 100,
		)
	);
	$logitic_customizer->add_panel( $logitic_blog_panel );

	logitic_blog_page_style_panel( $logitic_customizer, 101 );
	logitic_blog_single_style_panel( $logitic_customizer, 102 );
	
	//End Blog setting
	 
	/**
	 * Start Team setting
	 * @since 1.0.0
	 */
	logitic_team_panel( $logitic_customizer, 121 );
	//End Team setting
 
	/**
	 * Start woocommerce settings
	 * @since 1.0.0
	 */
	logitic_woocommerce_panel( $logitic_customizer, 210 );
	//End woocommerce settings

	logitic_custom_fonts_panel( $logitic_customizer, 200 );
	

	/**
	 * Start 404 Page Setting
	 * @since 1.0.0
	 */
	logitic_404_panel( $logitic_customizer, 241 );
	//End 404 Page Setting
		
 	}
}
add_action( 'customize_register', 'logitic_customizer_register' );