<?php
function logitic_offcanvas_sidebar_panel( $logitic_customizer, $priority ){
    $logitic_customizer->add_section( 'logitic_offcanvas_sidebar_setting' , array(
        'title'      => esc_html__( 'Offcanvas Sidebar Setting', 'logitic' ),
        'priority'   => $priority,
        'panel'		 => 'logitic_options_panel'
    ) );

	// Offcanvas Sidebar Logo Control Start
	$logitic_customizer->add_setting( 'offcanvas_sidebar_logo_enable_disable', 
	array(
		'default'    => '0',
		) 
	);
	
	$logitic_customizer->add_control(
		new logitic_Customize_Switch_Control(
			$logitic_customizer,
			'offcanvas_sidebar_logo_enable_disable',
			array(
				'type' => 'switch',
				'label' => esc_html__('Offcanvas Sidebar Logo','logitic'),
				'description' => esc_html__('You can enable or disable offcanvas sidebar logo here','logitic'),
				'section' => 'logitic_offcanvas_sidebar_setting'
			)
		)
	);
	// Offcanvas Sidebar Logo Control End

	//Start separator
	$logitic_customizer->add_setting(
		'separator_30', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$logitic_customizer->add_control(
		new logitic_Separator_Control(
			$logitic_customizer, 
			'separator_30', 
			array(
				'settings'		=> 'separator_30',
				'section'  		=> 'logitic_offcanvas_sidebar_setting',
			)
		)
	);
	//End separator

	//Start Offcanvas Sidebar Logo Image
	$logitic_customizer->add_setting(
		'rstheme_offcanvas_sidebar_logo_img', 
		array(
		'transport'		=> 'refresh'
		)
	);
	$logitic_customizer->add_control(
		new WP_Customize_Image_Control(
		$logitic_customizer,
		'rstheme_offcanvas_sidebar_logo_img',
			array(
			'label'      => esc_html__( 'Logo', 'logitic' ),
			'section'    => 'logitic_offcanvas_sidebar_setting',
			'settings'   => 'rstheme_offcanvas_sidebar_logo_img',
			)
		)   
	);
	//End Offcanvas Sidebar Logo Image

	//Start separator
	$logitic_customizer->add_setting(
		'separator_31', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$logitic_customizer->add_control(
		new logitic_Separator_Control(
			$logitic_customizer, 
			'separator_31', 
			array(
				'settings'		=> 'separator_31',
				'section'  		=> 'logitic_offcanvas_sidebar_setting',
			)
		)
	);
	//End separator

	//Start Offcanvas Sidebar Logo Height
	$logitic_customizer->add_setting(
		'rstheme_offcanvas_sidebar_logo_image_height',
		array(
			'default' => esc_html__( '30px', 'logitic' ),
			'transport'		=> 'refresh',
		)
	);

	$logitic_customizer->add_control('rstheme_offcanvas_sidebar_logo_image_height', array(
        'section'	=> 'logitic_offcanvas_sidebar_setting',
        'label'		=> esc_html__( 'Logo Height', 'logitic' ),
        'description' => esc_html__( 'Logo height example(30px)', 'logitic' ),
        'type'		=> 'text',
        'setting'	=> 'rstheme_offcanvas_sidebar_logo_image_height'
    ));
	//End Offcanvas Sidebar Logo Height

	//Start separator
	$logitic_customizer->add_setting(
		'separator_32', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$logitic_customizer->add_control(
		new logitic_Separator_Control(
			$logitic_customizer, 
			'separator_32', 
			array(
				'settings'		=> 'separator_32',
				'section'  		=> 'logitic_offcanvas_sidebar_setting',
			)
		)
	);
	//End separator

	//Start Offcanvas Sidebar Logo Margin Bottom
	$logitic_customizer->add_setting(
		'rstheme_offcanvas_sidebar_logo_bottom_margin',
		array(
			'default' => esc_html__( '20px', 'logitic' ),
			'transport'		=> 'refresh',
		)
	);

	$logitic_customizer->add_control('rstheme_offcanvas_sidebar_logo_bottom_margin', array(
        'section'	=> 'logitic_offcanvas_sidebar_setting',
        'label'		=> esc_html__( 'Logo Margin Bottom', 'logitic' ),
        'description' => esc_html__( 'Logo Margin Bottom example(20px)', 'logitic' ),
        'type'		=> 'text',
        'setting'	=> 'rstheme_offcanvas_sidebar_logo_bottom_margin'
    ));
	//End Offcanvas Sidebar Logo Margin Bottom

	//Start separator
	$logitic_customizer->add_setting(
		'separator_33', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$logitic_customizer->add_control(
		new logitic_Separator_Control(
			$logitic_customizer, 
			'separator_33', 
			array(
				'settings'		=> 'separator_33',
				'section'  		=> 'logitic_offcanvas_sidebar_setting',
			)
		)
	);
	//End separator

	//Start Mobile Sidebar Widget Title Color
	$logitic_customizer->add_setting (
        'logitic_mobile_sidebar_widget_title_color',
    );
    $logitic_customizer->add_control(
        new WP_Customize_Color_Control(
            $logitic_customizer,
            'logitic_mobile_sidebar_widget_title_color',
            array(
                'label'       => esc_html__('Widget Title Color','logitic'),
                'description' => esc_html__('Pic Color','logitic'),
                'section'     => 'logitic_offcanvas_sidebar_setting',
                'settings'    => 'logitic_mobile_sidebar_widget_title_color',
            )
        )
    );
	//End Mobile Sidebar Widget Title Color

	//Start separator
	$logitic_customizer->add_setting(
		'separator_333', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$logitic_customizer->add_control(
		new logitic_Separator_Control(
			$logitic_customizer, 
			'separator_333', 
			array(
				'settings'		=> 'separator_333',
				'section'  		=> 'logitic_offcanvas_sidebar_setting',
			)
		)
	);
	//End separator

	//Start Mobile Sidebar Menu Text Normal Color
	$logitic_customizer->add_setting (
        'logitic_mobile_sidebar_menu_normal_color',
    );
    $logitic_customizer->add_control(
        new WP_Customize_Color_Control(
            $logitic_customizer,
            'logitic_mobile_sidebar_menu_normal_color',
            array(
                'label'       => esc_html__('Mobile Menu Normal Color','logitic'),
                'description' => esc_html__('Pic Color','logitic'),
                'section'     => 'logitic_offcanvas_sidebar_setting',
                'settings'    => 'logitic_mobile_sidebar_menu_normal_color',
            )
        )
    );
	//End Mobile Sidebar Menu Text Normal Color

	//Start separator
	$logitic_customizer->add_setting(
		'separator_34', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$logitic_customizer->add_control(
		new logitic_Separator_Control(
			$logitic_customizer, 
			'separator_34', 
			array(
				'settings'		=> 'separator_34',
				'section'  		=> 'logitic_offcanvas_sidebar_setting',
			)
		)
	);
	//End separator

	//Start Mobile Sidebar Menu Text Hover Color
	$logitic_customizer->add_setting (
        'logitic_mobile_sidebar_menu_hover_color',
    );
    $logitic_customizer->add_control(
        new WP_Customize_Color_Control(
            $logitic_customizer,
            'logitic_mobile_sidebar_menu_hover_color',
            array(
                'label'       => esc_html__('Mobile Menu Hover Color','logitic'),
                'description' => esc_html__('Pic Color','logitic'),
                'section'     => 'logitic_offcanvas_sidebar_setting',
                'settings'    => 'logitic_mobile_sidebar_menu_hover_color',
            )
        )
    );
	//End Mobile Sidebar Menu Text Hover Color

	//Start separator
	$logitic_customizer->add_setting(
		'separator_35', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$logitic_customizer->add_control(
		new logitic_Separator_Control(
			$logitic_customizer, 
			'separator_35', 
			array(
				'settings'		=> 'separator_35',
				'section'  		=> 'logitic_offcanvas_sidebar_setting',
			)
		)
	);
	//End separator

	//Start Mobile Sidebar Menu Text Active Color
	$logitic_customizer->add_setting (
        'logitic_mobile_sidebar_menu_active_color',
    );
    $logitic_customizer->add_control(
        new WP_Customize_Color_Control(
            $logitic_customizer,
            'logitic_mobile_sidebar_menu_active_color',
            array(
                'label'       => esc_html__('Mobile Menu Active Color','logitic'),
                'description' => esc_html__('Pic Color','logitic'),
                'section'     => 'logitic_offcanvas_sidebar_setting',
                'settings'    => 'logitic_mobile_sidebar_menu_active_color',
            )
        )
    );
	//End Mobile Sidebar Menu Text Active Color
}