<?php
function logitic_mouse_pointer_panel($logitic_customizer, $priority)
{
    $logitic_customizer->add_section('logitic_mouse_pt_setting', array(
        'title' => esc_html__('Mouse Pointer Setting', 'logitic'),
        'priority' => $priority,
        'panel' => 'logitic_options_panel',
    ));

    //Start enabal global setting
    $logitic_customizer->add_setting('logitic_mouse_pt_enabel_pointer',
        array(
            'default' => '1',
            'sanitize_callback' => 'logitic_sanitize_integer',
        )
    );
    $logitic_customizer->add_control(
        new logitic_Customize_Switch_Control(
            $logitic_customizer,
            'logitic_mouse_pt_enabel_pointer',
            array(
                'type' => 'switch',
                'label' => esc_html__('Show Pointer', 'logitic'),
                'description' => esc_html__('You can show or hide Mouse Pointer', 'logitic'),
                'section' => 'logitic_mouse_pt_setting',
            )
        )
    );
    //End enabal global setting

    //Start separator
    $logitic_customizer->add_setting(
        'mouse_pt_hr_0',
        array(
            'default' => '',
            'sanitize_callback' => 'esc_html',
        )
    );
    $logitic_customizer->add_control(
        new logitic_Separator_Control(
            $logitic_customizer,
            'mouse_pt_hr_0',
            array(
                'settings' => 'mouse_pt_hr_0',
                'section' => 'logitic_mouse_pt_setting',
            )
        )
    );
    //End separator

    //Start Body Background Color
    $logitic_customizer->add_setting(
        'logitic_mouse_pt_pointer_border_color'
    );
    $logitic_customizer->add_control(
        new WP_Customize_Color_Control(
            $logitic_customizer,
            'logitic_mouse_pt_pointer_border_color',
            array(
                'label' => esc_html__('Pointer Border', 'logitic'),
                'description' => esc_html__('Pick color', 'logitic'),
                'section' => 'logitic_mouse_pt_setting',
                'settings' => 'logitic_mouse_pt_pointer_border_color',
            )
        )
    );
    //End Body Background Color

    //Start separator
    $logitic_customizer->add_setting(
        'mouse_pt_hr_1',
        array(
            'default' => '',
            'sanitize_callback' => 'esc_html',
        )
    );
    $logitic_customizer->add_control(
        new logitic_Separator_Control(
            $logitic_customizer,
            'mouse_pt_hr_1',
            array(
                'settings' => 'mouse_pt_hr_1',
                'section' => 'logitic_mouse_pt_setting',
            )
        )
    );
    //End separator

	//Start container size
    $logitic_customizer->add_setting(
        'logitic_mouse_pt_border_width',
        array(
            'default' => esc_html__('2', 'logitic'),
            'transport' => 'refresh',
        )
    );

    $logitic_customizer->add_control('logitic_mouse_pt_border_width', array(
        'section' => 'logitic_mouse_pt_setting',
        'label' => esc_html__('Border Width', 'logitic'),
        'description' => esc_html__('Enter Pointer Border Width', 'logitic'),
        'type' => 'text',
        'setting' => 'logitic_mouse_pt_border_width',
    ));
    //End container size

    //Start separator
    $logitic_customizer->add_setting(
        'mouse_pt_hr_2',
        array(
            'default' => '',
            'sanitize_callback' => 'esc_html',
        )
    );
    $logitic_customizer->add_control(
        new logitic_Separator_Control(
            $logitic_customizer,
            'mouse_pt_hr_2',
            array(
                'settings' => 'mouse_pt_hr_2',
                'section' => 'logitic_mouse_pt_setting',
            )
        )
    );
    //End separator

    //Start Body Background Color
    $logitic_customizer->add_setting(
        'logitic_mouse_pt_pointer_bg_color'
    );
    $logitic_customizer->add_control(
        new WP_Customize_Color_Control(
            $logitic_customizer,
            'logitic_mouse_pt_pointer_bg_color',
            array(
                'label' => esc_html__('Pointer Background', 'logitic'),
                'description' => esc_html__('Enter Pointer Background color', 'logitic'),
                'section' => 'logitic_mouse_pt_setting',
                'settings' => 'logitic_mouse_pt_pointer_bg_color',
            )
        )
    );
    //End Body Background Color

    //Start separator
    $logitic_customizer->add_setting(
        'mouse_pt_hr_4',
        array(
            'default' => '',
            'sanitize_callback' => 'esc_html',
        )
    );
    $logitic_customizer->add_control(
        new logitic_Separator_Control(
            $logitic_customizer,
            'mouse_pt_hr_4',
            array(
                'settings' => 'mouse_pt_hr_4',
                'section' => 'logitic_mouse_pt_setting',
            )
        )
    );
    //End separator	

	//Start container size
	$logitic_customizer->add_setting(
		'logitic_mouse_pt_diameter',
		array(
			'default' => esc_html__('40', 'logitic'),
			'transport' => 'refresh',
		)
	);

	$logitic_customizer->add_control('logitic_mouse_pt_diameter', array(
		'section' => 'logitic_mouse_pt_setting',
		'label' => esc_html__('Diameter', 'logitic'),
		'description' => esc_html__('Enter Pointer diameter Size', 'logitic'),
		'type' => 'text',
		'setting' => 'logitic_mouse_pt_diameter',
	));
	//End container size

    //Start separator
    $logitic_customizer->add_setting(
        'mouse_pt_hr_5',
        array(
            'default' => '',
            'sanitize_callback' => 'esc_html',
        )
    );
    $logitic_customizer->add_control(
        new logitic_Separator_Control(
            $logitic_customizer,
            'mouse_pt_hr_5',
            array(
                'settings' => 'mouse_pt_hr_5',
                'section' => 'logitic_mouse_pt_setting',
            )
        )
    );
    //End separator	

	//Start container size
    $logitic_customizer->add_setting(
        'logitic_mouse_pt_pointer_speed',
        array(
            'default' => esc_html__('4', 'logitic'),
            'transport' => 'refresh',
        )
    );

    $logitic_customizer->add_control('logitic_mouse_pt_pointer_speed', array(
        'section' => 'logitic_mouse_pt_setting',
        'label' => esc_html__('Pointer Speed', 'logitic'),
        'description' => esc_html__('Enter Pointer Scale Size', 'logitic'),
        'type' => 'text',
        'setting' => 'logitic_mouse_pt_pointer_speed',
    ));
    //End container size

    //Start separator
    $logitic_customizer->add_setting(
        'mouse_pt_hr_6',
        array(
            'default' => '',
            'sanitize_callback' => 'esc_html',
        )
    );
    $logitic_customizer->add_control(
        new logitic_Separator_Control(
            $logitic_customizer,
            'mouse_pt_hr_6',
            array(
                'settings' => 'mouse_pt_hr_6',
                'section' => 'logitic_mouse_pt_setting',
            )
        )
    );
    //End separator

	//Start container size
    $logitic_customizer->add_setting(
        'logitic_mouse_pt_hover_scale',
        array(
            'default' => esc_html__('1.3', 'logitic'),
            'transport' => 'refresh',
        )
    );

    $logitic_customizer->add_control('logitic_mouse_pt_hover_scale', array(
        'section' => 'logitic_mouse_pt_setting',
        'label' => esc_html__('Hover Scale', 'logitic'),
        'description' => esc_html__('Enter Pointer Scale Size', 'logitic'),
        'type' => 'text',
        'setting' => 'logitic_mouse_pt_hover_scale',
    ));
    //End container size

    //Start separator
    $logitic_customizer->add_setting(
        'mouse_pt_hr_7',
        array(
            'default' => '',
            'sanitize_callback' => 'esc_html',
        )
    );
    $logitic_customizer->add_control(
        new logitic_Separator_Control(
            $logitic_customizer,
            'mouse_pt_hr_7',
            array(
                'settings' => 'mouse_pt_hr_7',
                'section' => 'logitic_mouse_pt_setting',
            )
        )
    );
    //End separator

}
