<?php
function logitic_page_panel( $logitic_customizer, $priority ){
    $logitic_customizer->add_section( 'logitic_page_setting' , array(
        'title'      => esc_html__( 'Page Setting', 'logitic' ),
        'priority'   => $priority,
        'panel'		 => 'logitic_options_panel'
    ) );

	//Start
	$logitic_customizer->add_setting(
		'logitic_page_default_logo', 
		array(
		'transport'		=> 'refresh'
		)
	);
	$logitic_customizer->add_control(
		new WP_Customize_Image_Control(
		$logitic_customizer,
		'logitic_page_default_logo',
			array(
			'label'      => esc_html__( 'Upload Page Logo', 'logitic' ),
			'section'    => 'logitic_page_setting',
			'settings'   => 'logitic_page_default_logo',
			)
		)   
	);
	//End

	//Start Sticky Menu
	$logitic_customizer->add_setting( 'logitic_page_enable_sticky_menu', 
	array(
			'default'    => '0',
		) 
	);
	$logitic_customizer->add_control(
		new logitic_Customize_Switch_Control(
			$logitic_customizer,
			'logitic_page_enable_sticky_menu',
			array(
				'type' => 'switch',
				'label' => esc_html__('Sticky Menu','logitic'),
				'description' => esc_html__('You can show or hide sticky menu here','logitic'),
				'section' => 'logitic_page_setting'
			)
		)
	);
	//End Sticky Menu

	//Start
    $logitic_customizer->add_setting(
        'logitic_page_header_menu_bg_color'
    );
    $logitic_customizer->add_control(
        new WP_Customize_Color_Control(
            $logitic_customizer,
            'logitic_page_header_menu_bg_color',
            array(
                'label' => esc_html__('Header Background Color', 'logitic'),
                'description' => esc_html__('Pick color', 'logitic'),
                'section' => 'logitic_page_setting',
                'settings' => 'logitic_page_header_menu_bg_color',
            )
        )
    );
    //End

	//Start
    $logitic_customizer->add_setting(
        'logitic_page_header_menu_color'
    );
    $logitic_customizer->add_control(
        new WP_Customize_Color_Control(
            $logitic_customizer,
            'logitic_page_header_menu_color',
            array(
                'label' => esc_html__('Header Menu Color', 'logitic'),
                'description' => esc_html__('Pick color', 'logitic'),
                'section' => 'logitic_page_setting',
                'settings' => 'logitic_page_header_menu_color',
            )
        )
    );
    //End

	//Start separator
	$logitic_customizer->add_setting(
		'page_hr_0', 
		array(
			'default'           => '',
		)
	);
	$logitic_customizer->add_control(
		new logitic_Separator_Control(
			$logitic_customizer, 
			'page_hr_0', 
			array(
				'settings'		=> 'page_hr_0',
				'section'  		=> 'logitic_page_setting',
			)
		)
	);
	//End separator

	//Start
    $logitic_customizer->add_setting(
        'logitic_page_header_menu_hover_color'
    );
    $logitic_customizer->add_control(
        new WP_Customize_Color_Control(
            $logitic_customizer,
            'logitic_page_header_menu_hover_color',
            array(
                'label' => esc_html__('Header Menu Hover Color', 'logitic'),
                'description' => esc_html__('Pick color', 'logitic'),
                'section' => 'logitic_page_setting',
                'settings' => 'logitic_page_header_menu_hover_color',
            )
        )
    );
    //End

	//Start separator
	$logitic_customizer->add_setting(
		'page_hr_1', 
		array(
			'default'           => '',
		)
	);
	$logitic_customizer->add_control(
		new logitic_Separator_Control(
			$logitic_customizer, 
			'page_hr_1', 
			array(
				'settings'		=> 'page_hr_1',
				'section'  		=> 'logitic_page_setting',
			)
		)
	);
	//End separator

	//Start
    $logitic_customizer->add_setting(
        'logitic_page_header_menu_active_color'
    );
    $logitic_customizer->add_control(
        new WP_Customize_Color_Control(
            $logitic_customizer,
            'logitic_page_header_menu_active_color',
            array(
                'label' => esc_html__('Header Menu Active Color', 'logitic'),
                'description' => esc_html__('Pick color', 'logitic'),
                'section' => 'logitic_page_setting',
                'settings' => 'logitic_page_header_menu_active_color',
            )
        )
    );
    //End

	//Start separator
	$logitic_customizer->add_setting(
		'page_hr_2', 
		array(
			'default'           => '',
		)
	);
	$logitic_customizer->add_control(
		new logitic_Separator_Control(
			$logitic_customizer, 
			'page_hr_2', 
			array(
				'settings'		=> 'page_hr_2',
				'section'  		=> 'logitic_page_setting',
			)
		)
	);
	//End separator

	//Start Color
	$logitic_customizer->add_setting (
        'logitic_page_sign_in_text_color',
        array(
            'default'     => ''
        )
    );
    $logitic_customizer->add_control(
        new WP_Customize_Color_Control(
            $logitic_customizer,
            'logitic_page_sign_in_text_color',
            array(
                'label'      => esc_html__('Text Color','logitic'),
                'description'      => esc_html__('Select Text Color','logitic'),
                'section'    => 'logitic_page_setting',
                'settings'   => 'logitic_page_sign_in_text_color',
            )
        )
    );
	//End Color

    //Start Color
	$logitic_customizer->add_setting (
        'logitic_page_sign_in_text_hover_color',
        array(
            'default'     => ''
        )
    );
    $logitic_customizer->add_control(
        new WP_Customize_Color_Control(
            $logitic_customizer,
            'logitic_page_sign_in_text_hover_color',
            array(
                'label'      => esc_html__('Hover Color','logitic'),
                'description'      => esc_html__('Select Hover Color','logitic'),
                'section'    => 'logitic_page_setting',
                'settings'   => 'logitic_page_sign_in_text_hover_color',
            )
        )
    );
	//End Color

    //Start Color
	$logitic_customizer->add_setting (
        'logitic_page_download_border_color',
        array(
            'default'     => ''
        )
    );
    $logitic_customizer->add_control(
        new WP_Customize_Color_Control(
            $logitic_customizer,
            'logitic_page_download_border_color',
            array(
                'label'      => esc_html__('Button Border Color','logitic'),
                'description'      => esc_html__('Select Button Border Color','logitic'),
                'section'    => 'logitic_page_setting',
                'settings'   => 'logitic_page_download_border_color',
            )
        )
    );
	//End Color

    //Start Color
	$logitic_customizer->add_setting (
        'logitic_page_download_text_color',
        array(
            'default'     => ''
        )
    );
    $logitic_customizer->add_control(
        new WP_Customize_Color_Control(
            $logitic_customizer,
            'logitic_page_download_text_color',
            array(
                'label'      => esc_html__('Button Link Color','logitic'),
                'description'      => esc_html__('Select text Color','logitic'),
                'section'    => 'logitic_page_setting',
                'settings'   => 'logitic_page_download_text_color',
            )
        )
    );
	//End Color

    //Start Color
    $logitic_customizer->add_setting (
        'logitic_page_download_text_hover_color',
        array(
            'default'     => ''
        )
    );
    $logitic_customizer->add_control(
        new WP_Customize_Color_Control(
            $logitic_customizer,
            'logitic_page_download_text_hover_color',
            array(
                'label'      => esc_html__('Button Link Hover Color','logitic'),
                'description'      => esc_html__('Select Text Hover Color','logitic'),
                'section'    => 'logitic_page_setting',
                'settings'   => 'logitic_page_download_text_hover_color',
            )
        )
    );
    //End Color

    //Start Color
	$logitic_customizer->add_setting (
        'logitic_page_download_btn_hover_color',
        array(
            'default'     => ''
        )
    );
    $logitic_customizer->add_control(
        new WP_Customize_Color_Control(
            $logitic_customizer,
            'logitic_page_download_btn_hover_color',
            array(
                'label'      => esc_html__('Button Hover Color','logitic'),
                'description'      => esc_html__('Select Button Hover Color','logitic'),
                'section'    => 'logitic_page_setting',
                'settings'   => 'logitic_page_download_btn_hover_color',
            )
        )
    );
	//End Color
}