<?php
function logitic_portfolio_panel($logitic_customizer, $priority){
    $logitic_customizer->add_section('logitic_portfolio_setting', array(
        'title'    => esc_html__('Portfolio Settings', 'logitic'),
        'priority' => $priority,
        'panel'    => 'logitic_options_panel',
    ));

    //Start enabal
    $logitic_customizer->add_setting('logitic_enable_portfolio_page_banner',
    array(
        'default' => 0
    )
    );
    $logitic_customizer->add_control(
    new logitic_Customize_Switch_Control(
        $logitic_customizer,
        'logitic_enable_portfolio_page_banner',
        array(
            'type'        => 'switch',
            'label'       => esc_html__('Show Portfolio Page Banner', 'logitic'),
            'description' => esc_html__('You can select banner show or hide', 'logitic'),
            'section'     => 'logitic_portfolio_setting',
        )
    )
    );
    //End enabal

    //Start separator
    $logitic_customizer->add_setting(
    'portfolio_hr_00',
    array(
        'default' => '',
        'sanitize_callback' => 'esc_html',
    )
    );
    $logitic_customizer->add_control(
    new logitic_Separator_Control(
        $logitic_customizer,
        'portfolio_hr_00',
        array(
            'settings' => 'portfolio_hr_00',
            'section' => 'logitic_portfolio_setting',
        )
    )
    );
    //End separator

    //Start enabal
    $logitic_customizer->add_setting('logitic_enable_portfolio_breadcrumb',
    array(
        'default' => 0
    )
    );
    $logitic_customizer->add_control(
    new logitic_Customize_Switch_Control(
        $logitic_customizer,
        'logitic_enable_portfolio_breadcrumb',
        array(
            'type'        => 'switch',
            'label'       => esc_html__('Show Breadcrumb', 'logitic'),
            'description' => esc_html__('You want to show breadcrumb click ON', 'logitic'),
            'section'     => 'logitic_portfolio_setting',
        )
    )
    );
    //End enabal

    //Start separator
    $logitic_customizer->add_setting(
    'portfolio_hr_0',
    array(
        'default' => '',
        'sanitize_callback' => 'esc_html',
    )
    );
    $logitic_customizer->add_control(
    new logitic_Separator_Control(
        $logitic_customizer,
        'portfolio_hr_0',
        array(
            'settings' => 'portfolio_hr_0',
            'section' => 'logitic_portfolio_setting',
        )
    )
    );
    //End separator

    //Start default header logo
    $logitic_customizer->add_setting(
    'logitic_portfolio_banner_image',
    array(
        'transport' => 'refresh',
    )
    );
    $logitic_customizer->add_control(
    new WP_Customize_Image_Control(
        $logitic_customizer,
        'logitic_portfolio_banner_image',
        array(
            'label'    => esc_html__('Portfolio Single Page Banner Image', 'logitic'),
            'section'  => 'logitic_portfolio_setting',
            'settings' => 'logitic_portfolio_banner_image',
        )
    )
    );
    //End default logo

    //Start separator
    $logitic_customizer->add_setting(
    'portfolio_hr_1',
    array(
        'default' => '',
        'sanitize_callback' => 'esc_html',
    )
    );
    $logitic_customizer->add_control(
    new logitic_Separator_Control(
        $logitic_customizer,
        'portfolio_hr_1',
        array(
            'settings' => 'portfolio_hr_1',
            'section' => 'logitic_portfolio_setting',
        )
    )
    );
    //End separator

    //Start Body Background Color
    $logitic_customizer->add_setting(
    'logitic_portfolio_bg_color'
    );
    $logitic_customizer->add_control(
    new WP_Customize_Color_Control(
        $logitic_customizer,
        'logitic_portfolio_bg_color',
        array(
            'label'       => esc_html__('Sinlge Portfolio Body Backgroud Color', 'logitic'),
            'description' => esc_html__('Pick body background color', 'logitic'),
            'section'     => 'logitic_portfolio_setting',
            'settings'    => 'logitic_portfolio_bg_color',
        )
    )
    );
    //End Body Background Color

    //Start separator
    $logitic_customizer->add_setting(
    'portfolio_hr_2',
    array(
        'default' => '',
        'sanitize_callback' => 'esc_html',
    )
    );
    $logitic_customizer->add_control(
    new logitic_Separator_Control(
        $logitic_customizer,
        'portfolio_hr_2',
        array(
            'settings' => 'portfolio_hr_2',
            'section' => 'logitic_portfolio_setting',
        )
    )
    );
    //End separator

    //Start Logo Height
    $logitic_customizer->add_setting(
    'logitic_portfolio_banner_title',
    array(
        'transport' => 'refresh',
    )
    );
    $logitic_customizer->add_control('logitic_portfolio_banner_title', array(
    'section' => 'logitic_portfolio_setting',
    'label'   => esc_html__('Portfolio Single Banner Title', 'logitic'),
    'type'    => 'text',
    'setting' => 'logitic_portfolio_banner_title',
    ));
    //End Logo Height

    //Start separator
    $logitic_customizer->add_setting(
    'portfolio_hr_04',
    array(
        'default' => '',
        'sanitize_callback' => 'esc_html',
    )
    );
    $logitic_customizer->add_control(
    new logitic_Separator_Control(
        $logitic_customizer,
        'portfolio_hr_04',
        array(
            'settings' => 'portfolio_hr_04',
            'section' => 'logitic_portfolio_setting',
        )
    )
    );
    //End separator

    //Start
    $logitic_customizer->add_setting(
    'logitic_portfolio_banner_text',
    array(
        'transport' => 'refresh',
    )
    );
    $logitic_customizer->add_control('logitic_portfolio_banner_text', array(
    'section' => 'logitic_portfolio_setting',
    'label'   => esc_html__('Portfolio Single Banner Text', 'logitic'),
    'type'    => 'textarea',
    'setting' => 'logitic_portfolio_banner_text',
    ));
    //End
}
