<?php
function logitic_preloader_panel( $logitic_customizer, $priority ){
    $logitic_customizer->add_section( 'logitic_preloader_setting' , array(
        'title'      => esc_html__( 'Preloader Setting', 'logitic' ),
        'priority'   => $priority,
        'panel'		 => 'logitic_options_panel'
    ) );

    //Start Show Top Bar
	$logitic_customizer->add_setting( 'logitic_enable_preloader', 
	array(
		'default'    		=> '0', 
		) 
	);
	
	$logitic_customizer->add_control(
		new logitic_Customize_Switch_Control(
			$logitic_customizer,
			'logitic_enable_preloader',
			array(
				'type' 			=> 'switch',
				'label' 		=> esc_html__( 'Show Preloader','logitic' ),
				'description' 	=> esc_html__( 'You can show or hide preloader','logitic' ),
				'section' 		=> 'logitic_preloader_setting'
			)
		)
	);
	//End Show Top Bar

	//Start separator
	$logitic_customizer->add_setting(
		'separator_0', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$logitic_customizer->add_control(
		new logitic_Separator_Control(
			$logitic_customizer, 
			'separator_0', 
			array(
				'settings'		=> 'separator_0',
				'section'  		=> 'logitic_preloader_setting',
			)
		)
	);
	//End separator

	//Start Preloader Background Color
	$logitic_customizer->add_setting (
        'logitic_preloader_bg_color'
    );
    $logitic_customizer->add_control(
        new WP_Customize_Color_Control(
            $logitic_customizer,
            'logitic_preloader_bg_color',
            array(
                'label'      => esc_html__('Preloader Background Color','logitic'),
                'section'    => 'logitic_preloader_setting',
                'settings'   => 'logitic_preloader_bg_color',
            )
        )
    );
	//End Preloader Background Color

	//Start separator
	$logitic_customizer->add_setting(
		'separator_1', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$logitic_customizer->add_control(
		new logitic_Separator_Control(
			$logitic_customizer, 
			'separator_1', 
			array(
				'settings'		=> 'separator_1',
				'section'  		=> 'logitic_preloader_setting',
			)
		)
	);
	//End separator

	//Start Preloader Border Color
	$logitic_customizer->add_setting (
        'logitic_preloader_border_color'
    );
    $logitic_customizer->add_control(
        new WP_Customize_Color_Control(
            $logitic_customizer,
            'logitic_preloader_border_color',
            array(
                'label'      => esc_html__('Preloader Border Color','logitic'),
                'section'    => 'logitic_preloader_setting',
                'settings'   => 'logitic_preloader_border_color',
            )
        )
    );
	//End Preloader Border Color

	//Start separator
	$logitic_customizer->add_setting(
		'separator_2', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$logitic_customizer->add_control(
		new logitic_Separator_Control(
			$logitic_customizer, 
			'separator_2', 
			array(
				'settings'		=> 'separator_2',
				'section'  		=> 'logitic_preloader_setting',
			)
		)
	);
	//End separator

	//Start Preloader Animate Circle Color
	$logitic_customizer->add_setting (
        'logitic_preloader_animate_circle_color'
    );
    $logitic_customizer->add_control(
        new WP_Customize_Color_Control(
            $logitic_customizer,
            'logitic_preloader_animate_circle_color',
            array(
                'label'      => esc_html__('Preloader Animate Circle Color','logitic'),
                'section'    => 'logitic_preloader_setting',
                'settings'   => 'logitic_preloader_animate_circle_color',
            )
        )
    );
	//End Preloader Animate Circle Color

	//Start separator
	$logitic_customizer->add_setting(
		'separator_3', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$logitic_customizer->add_control(
		new logitic_Separator_Control(
			$logitic_customizer, 
			'separator_3', 
			array(
				'settings'		=> 'separator_3',
				'section'  		=> 'logitic_preloader_setting',
			)
		)
	);
	//End separator

	//Start Preloader Image
	$logitic_customizer->add_setting(
		'logitic_preloader_image', 
		array(
		'transport'		=> 'refresh'
		)
	);
	$logitic_customizer->add_control(
		new WP_Customize_Image_Control(
		$logitic_customizer,
		'logitic_preloader_image',
			array(
			'label'      => esc_html__( 'Preloader Image', 'logitic' ),
			'section'    => 'logitic_preloader_setting',
			'settings'   => 'logitic_preloader_image',
			)
		)   
	);
	//End Preloader Image

	//Start separator
	$logitic_customizer->add_setting(
		'separator_4', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$logitic_customizer->add_control(
		new logitic_Separator_Control(
			$logitic_customizer, 
			'separator_4', 
			array(
				'settings'		=> 'separator_4',
				'section'  		=> 'logitic_preloader_setting',
			)
		)
	);
	//End separator

	//Start Preloader Cancel Button BG Color
	$logitic_customizer->add_setting (
        'logitic_preloader_cancel_button_bg_color'
    );
    $logitic_customizer->add_control(
        new WP_Customize_Color_Control(
            $logitic_customizer,
            'logitic_preloader_cancel_button_bg_color',
            array(
                'label'      => esc_html__('Cancel Button Background','logitic'),
                'section'    => 'logitic_preloader_setting',
                'settings'   => 'logitic_preloader_cancel_button_bg_color',
            )
        )
    );
	//End Preloader Cancel Button BG Color

	//Start separator
	$logitic_customizer->add_setting(
		'separator_5', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$logitic_customizer->add_control(
		new logitic_Separator_Control(
			$logitic_customizer, 
			'separator_5', 
			array(
				'settings'		=> 'separator_5',
				'section'  		=> 'logitic_preloader_setting',
			)
		)
	);
	//End separator

	//Start Preloader Cancel Button Text Color
	$logitic_customizer->add_setting (
        'logitic_preloader_cancel_button_text_color'
    );
    $logitic_customizer->add_control(
        new WP_Customize_Color_Control(
            $logitic_customizer,
            'logitic_preloader_cancel_button_text_color',
            array(
                'label'      => esc_html__('Cancel Button Text Color','logitic'),
                'section'    => 'logitic_preloader_setting',
                'settings'   => 'logitic_preloader_cancel_button_text_color',
            )
        )
    );
	//End Preloader Cancel Button BG Color

	//Start separator
	$logitic_customizer->add_setting(
		'separator_6', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$logitic_customizer->add_control(
		new logitic_Separator_Control(
			$logitic_customizer, 
			'separator_6', 
			array(
				'settings'		=> 'separator_6',
				'section'  		=> 'logitic_preloader_setting',
			)
		)
	);
	//End separator

	$logitic_customizer->add_setting(
        'logitic_preloader_cancel_button_text',
        array(
            'transport' => 'refresh',
        )
    );
    $logitic_customizer->add_control('logitic_preloader_cancel_button_text', array(
        'section' => 'logitic_preloader_setting',
        'label'   => esc_html__('Cancle Button Text', 'logitic'),
        'description' => esc_html__('Default is: Cancle Loader','logitic'),
        'type'    => 'text',
        'setting' => 'logitic_preloader_cancel_button_text',
    ));
}