<?php
function logitic_team_panel($logitic_customizer, $priority){
    $logitic_customizer->add_section('logitic_slug_setting', array(
        'title'    => esc_html__('Post Type Configuration', 'logitic'),
        'priority' => $priority,
        'panel'    => 'logitic_options_panel',
    ));

    //Start Portfolio
    $logitic_customizer->add_setting(
        'rstheme_portfolio_slug',
        array(
            'transport' => 'refresh',
        )
    );
    $logitic_customizer->add_control('rstheme_portfolio_slug', array(
        'section' => 'logitic_slug_setting',
        'label'   => esc_html__('Portfolio Slug Change', 'logitic'),
        'type'    => 'text',
        'setting' => 'rstheme_portfolio_slug',
    ));
    // Cat Label
    $logitic_customizer->add_setting(
        'rstheme_portfolio_cat_taxonomy_title',
        array(
            'transport' => 'refresh',
        )
    );
    $logitic_customizer->add_control('rstheme_portfolio_cat_taxonomy_title', array(
        'section' => 'logitic_slug_setting',
        'label'   => esc_html__('Category Taxonomy Title', 'logitic'),
        'description' => esc_html__('Default title is: Portfolio Categories','logitic'),
        'type'    => 'text',
        'setting' => 'rstheme_portfolio_cat_taxonomy_title',
    ));
    // Cat Slug
    $logitic_customizer->add_setting(
        'rstheme_portfolio_cat_taxonomy_slug',
        array(
            'transport' => 'refresh',
        )
    );
    $logitic_customizer->add_control('rstheme_portfolio_cat_taxonomy_slug', array(
        'section' => 'logitic_slug_setting',
        'label'   => esc_html__('Category Taxonomy Slug', 'logitic'),
        'description' => esc_html__("Default slug is: portfolios-categorie (Note: Don't use same slug for portfolio & taxonomy).",'logitic'),
        'type'    => 'text',
        'setting' => 'rstheme_portfolio_cat_taxonomy_slug',
    ));
    //End Portfolio

    //Start separator
	$logitic_customizer->add_setting(
		'separator_1', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$logitic_customizer->add_control(
		new logitic_Separator_Control(
			$logitic_customizer, 
			'separator_1', 
			array(
				'settings'		=> 'separator_1',
				'section'  		=> 'logitic_slug_setting',
			)
		)
	);
	//End separator
    //Start separator
	$logitic_customizer->add_setting(
		'separator_11', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$logitic_customizer->add_control(
		new logitic_Separator_Control(
			$logitic_customizer, 
			'separator_11', 
			array(
				'settings'		=> 'separator_11',
				'section'  		=> 'logitic_slug_setting',
			)
		)
	);
	//End separator

    //Start Team
    $logitic_customizer->add_setting(
        'rstheme_team_slug',
        array(
            'transport' => 'refresh',
        )
    );
    $logitic_customizer->add_control('rstheme_team_slug', array(
        'section' => 'logitic_slug_setting',
        'label'   => esc_html__('Team Slug Change', 'logitic'),
        'type'    => 'text',
        'setting' => 'rstheme_team_slug',
    ));
    // Cat label
    $logitic_customizer->add_setting(
        'rstheme_team_cat_taxonomy_title',
        array(
            'transport' => 'refresh',
        )
    );
    $logitic_customizer->add_control('rstheme_team_cat_taxonomy_title', array(
        'section' => 'logitic_slug_setting',
        'label'   => esc_html__('Category Taxonomy Title', 'logitic'),
        'description' => esc_html__('Default title is: Team Categories','logitic'),
        'type'    => 'text',
        'setting' => 'rstheme_team_cat_taxonomy_title',
    ));
    // Cat Slug
    $logitic_customizer->add_setting(
        'rstheme_team_cat_taxonomy_slug',
        array(
            'transport' => 'refresh',
        )
    );
    $logitic_customizer->add_control('rstheme_team_cat_taxonomy_slug', array(
        'section' => 'logitic_slug_setting',
        'label'   => esc_html__('Category Taxonomy Slug', 'logitic'),
        'description' => esc_html__("Default slug is: teams-categorie (Note: Don't use same slug for team & taxonomy).",'logitic'),
        'type'    => 'text',
        'setting' => 'rstheme_team_cat_taxonomy_slug',
    ));
    //End Team

    //Start separator
	$logitic_customizer->add_setting(
		'separator_2', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$logitic_customizer->add_control(
		new logitic_Separator_Control(
			$logitic_customizer, 
			'separator_2', 
			array(
				'settings'		=> 'separator_2',
				'section'  		=> 'logitic_slug_setting',
			)
		)
	);
	//End separator
    //Start separator
	$logitic_customizer->add_setting(
		'separator_22', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$logitic_customizer->add_control(
		new logitic_Separator_Control(
			$logitic_customizer, 
			'separator_22', 
			array(
				'settings'		=> 'separator_22',
				'section'  		=> 'logitic_slug_setting',
			)
		)
	);
	//End separator

    //Start career
    $logitic_customizer->add_setting(
        'rstheme_career_slug',
        array(
            'transport' => 'refresh',
        )
    );
    $logitic_customizer->add_control('rstheme_career_slug', array(
        'section' => 'logitic_slug_setting',
        'label'   => esc_html__('Career Slug Change', 'logitic'),
        'type'    => 'text',
        'setting' => 'rstheme_career_slug',
    ));
    // Cat Label
    $logitic_customizer->add_setting(
        'rstheme_career_cat_taxonomy_title',
        array(
            'transport' => 'refresh',
        )
    );
    $logitic_customizer->add_control('rstheme_career_cat_taxonomy_title', array(
        'section' => 'logitic_slug_setting',
        'label'   => esc_html__('Category Taxonomy Title', 'logitic'),
        'description' => esc_html__('Default title is: Career Categories','logitic'),
        'type'    => 'text',
        'setting' => 'rstheme_career_cat_taxonomy_title',
    ));
    // Cat Slug
    $logitic_customizer->add_setting(
        'rstheme_career_cat_taxonomy_slug',
        array(
            'transport' => 'refresh',
        )
    );
    $logitic_customizer->add_control('rstheme_career_cat_taxonomy_slug', array(
        'section' => 'logitic_slug_setting',
        'label'   => esc_html__('Category Taxonomy Slug', 'logitic'),
        'description' => esc_html__("Default slug is: career-category (Note: Don't use same slug for career & taxonomy).",'logitic'),
        'type'    => 'text',
        'setting' => 'rstheme_career_cat_taxonomy_slug',
    ));
    //End career

    //Start separator
	$logitic_customizer->add_setting(
		'separator_3', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$logitic_customizer->add_control(
		new logitic_Separator_Control(
			$logitic_customizer, 
			'separator_3', 
			array(
				'settings'		=> 'separator_3',
				'section'  		=> 'logitic_slug_setting',
			)
		)
	);
	//End separator
    //Start separator
	$logitic_customizer->add_setting(
		'separator_33', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$logitic_customizer->add_control(
		new logitic_Separator_Control(
			$logitic_customizer, 
			'separator_33', 
			array(
				'settings'		=> 'separator_33',
				'section'  		=> 'logitic_slug_setting',
			)
		)
	);
	//End separator

    //Start event
    $logitic_customizer->add_setting(
        'rstheme_event_slug',
        array(
            'transport' => 'refresh',
        )
    );
    $logitic_customizer->add_control('rstheme_event_slug', array(
        'section' => 'logitic_slug_setting',
        'label'   => esc_html__('Event Slug Change', 'logitic'),
        'type'    => 'text',
        'setting' => 'rstheme_event_slug',
    ));
    // Cat Label
    $logitic_customizer->add_setting(
        'rstheme_event_cat_taxonomy_title',
        array(
            'transport' => 'refresh',
        )
    );
    $logitic_customizer->add_control('rstheme_event_cat_taxonomy_title', array(
        'section' => 'logitic_slug_setting',
        'label'   => esc_html__('Category Taxonomy Title', 'logitic'),
        'description' => esc_html__('Default title is: Event Categories','logitic'),
        'type'    => 'text',
        'setting' => 'rstheme_event_cat_taxonomy_title',
    ));
    // Cat Slug
    $logitic_customizer->add_setting(
        'rstheme_event_cat_taxonomy_slug',
        array(
            'transport' => 'refresh',
        )
    );
    $logitic_customizer->add_control('rstheme_event_cat_taxonomy_slug', array(
        'section' => 'logitic_slug_setting',
        'label'   => esc_html__('Category Taxonomy Slug', 'logitic'),
        'description' => esc_html__("Default slug is: event-category (Note: Don't use same slug for event & taxonomy).",'logitic'),
        'type'    => 'text',
        'setting' => 'rstheme_event_cat_taxonomy_slug',
    ));
    //End event








    //Start separator
	$logitic_customizer->add_setting(
		'separator_4', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$logitic_customizer->add_control(
		new logitic_Separator_Control(
			$logitic_customizer, 
			'separator_4', 
			array(
				'settings'		=> 'separator_4',
				'section'  		=> 'logitic_slug_setting',
			)
		)
	);
	//End separator
    //Start separator
	$logitic_customizer->add_setting(
		'separator_44', 
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_html',
		)
	);
	$logitic_customizer->add_control(
		new logitic_Separator_Control(
			$logitic_customizer, 
			'separator_44', 
			array(
				'settings'		=> 'separator_44',
				'section'  		=> 'logitic_slug_setting',
			)
		)
	);
	//End separator

    //Start Service
    $logitic_customizer->add_setting(
        'rstheme_service_slug',
        array(
            'transport' => 'refresh',
        )
    );
    $logitic_customizer->add_control('rstheme_service_slug', array(
        'section' => 'logitic_slug_setting',
        'label'   => esc_html__('Service Slug Change', 'logitic'),
        'type'    => 'text',
        'setting' => 'rstheme_service_slug',
    ));
    // Cat Label
    $logitic_customizer->add_setting(
        'rstheme_service_cat_taxonomy_title',
        array(
            'transport' => 'refresh',
        )
    );
    $logitic_customizer->add_control('rstheme_service_cat_taxonomy_title', array(
        'section' => 'logitic_slug_setting',
        'label'   => esc_html__('Category Taxonomy Title', 'logitic'),
        'description' => esc_html__('Default title is: Service Categories','logitic'),
        'type'    => 'text',
        'setting' => 'rstheme_service_cat_taxonomy_title',
    ));
    // Cat Slug
    $logitic_customizer->add_setting(
        'rstheme_service_cat_taxonomy_slug',
        array(
            'transport' => 'refresh',
        )
    );
    $logitic_customizer->add_control('rstheme_service_cat_taxonomy_slug', array(
        'section' => 'logitic_slug_setting',
        'label'   => esc_html__('Category Taxonomy Slug', 'logitic'),
        'description' => esc_html__("Default slug is: services-category (Note: Don't use same slug for services & taxonomy).",'logitic'),
        'type'    => 'text',
        'setting' => 'rstheme_service_cat_taxonomy_slug',
    ));
    //End Service

}
