<?php
function logitic_style_panel( $logitic_customizer, $priority ){
    $logitic_customizer->add_section( 'logitic_style_setting' , array(
        'title'      => esc_html__( 'Theme Style Settings', 'logitic' ),
        'priority'   => $priority,
        'panel'		 => 'logitic_options_panel'
    ) );

    $logitic_customizer->add_setting (
        'logitic_style_body_text_color',
    );
    $logitic_customizer->add_control(
        new WP_Customize_Color_Control(
            $logitic_customizer,
            'logitic_style_body_text_color',
            array(
                'label'       => esc_html__('Body Text Color','logitic'),
                'description' => esc_html__('Pic Color','logitic'),
                'section'     => 'logitic_style_setting',
                'settings'    => 'logitic_style_body_text_color',
            )
        )
    );

    //Start separator
    $logitic_customizer->add_setting(
        'style_hr_31', 
        array(
            'default'           => '',
            'sanitize_callback' => 'esc_html',
        )
    );
    $logitic_customizer->add_control(
        new logitic_Separator_Control(
            $logitic_customizer, 
            'style_hr_31', 
            array(
                'settings'      => 'style_hr_31',
                'section'       => 'logitic_style_setting',
            )
        )
    );
    //End separator


	$logitic_customizer->add_setting (
        'logitic_style_primary_color',
    );
    $logitic_customizer->add_control(
        new WP_Customize_Color_Control(
            $logitic_customizer,
            'logitic_style_primary_color',
            array(
                'label'       => esc_html__('Theme Primary Color','logitic'),
                'description' => esc_html__('Pic Color','logitic'),
                'section'     => 'logitic_style_setting',
                'settings'    => 'logitic_style_primary_color',
            )
        )
    );

    //Start separator
    $logitic_customizer->add_setting(
    	'style_hr_21', 
    	array(
    		'default'           => '',
    		'sanitize_callback' => 'esc_html',
    	)
    );
    $logitic_customizer->add_control(
    	new logitic_Separator_Control(
    		$logitic_customizer, 
    		'style_hr_21', 
    		array(
    			'settings'		=> 'style_hr_21',
    			'section'  		=> 'logitic_style_setting',
    		)
    	)
    );
    //End separator

	//Start Secondaer Color
	$logitic_customizer->add_setting (
        'logitic_theme_style_secondaer_color',
    );
    $logitic_customizer->add_control(
        new WP_Customize_Color_Control(
            $logitic_customizer,
            'logitic_theme_style_secondaer_color',
            array(
                'label'       => esc_html__('Theme Secondary Color','logitic'),
                'description' => esc_html__('Pic Color','logitic'),
                'section'     => 'logitic_style_setting',
                'settings'    => 'logitic_theme_style_secondaer_color',
            )
        )
    );
	//End Secondaer Color

    //Start separator
    $logitic_customizer->add_setting(
    	'style_hr_22', 
    	array(
    		'default'           => '',
    		'sanitize_callback' => 'esc_html',
    	)
    );
    $logitic_customizer->add_control(
    	new logitic_Separator_Control(
    		$logitic_customizer, 
    		'style_hr_22', 
    		array(
    			'settings'		=> 'style_hr_22',
    			'section'  		=> 'logitic_style_setting',
    		)
    	)
    );
    //End separator

    //Start Blog Page Title Color
	$logitic_customizer->add_setting (
        'logitic_blog_and_single_title_color',
    );
    $logitic_customizer->add_control(
        new WP_Customize_Color_Control(
            $logitic_customizer,
            'logitic_blog_and_single_title_color',
            array(
                'label'       => esc_html__('Blog/Single Page Title Color','logitic'),
                'description' => esc_html__('Pic Color','logitic'),
                'section'     => 'logitic_style_setting',
                'settings'    => 'logitic_blog_and_single_title_color',
            )
        )
    );
	//End  Blog Page Title Color
    
    //Start separator
    $logitic_customizer->add_setting(
    	'style_hr_23', 
    	array(
    		'default'           => '',
    		'sanitize_callback' => 'esc_html',
    	)
    );
    $logitic_customizer->add_control(
    	new logitic_Separator_Control(
    		$logitic_customizer, 
    		'style_hr_23', 
    		array(
    			'settings'		=> 'style_hr_23',
    			'section'  		=> 'logitic_style_setting',
    		)
    	)
    );
    //End separator

    
    //Start Blog Page Button Color
	$logitic_customizer->add_setting (
        'logitic_bloge_page_button_color',
    );
    $logitic_customizer->add_control(
        new WP_Customize_Color_Control(
            $logitic_customizer,
            'logitic_bloge_page_button_color',
            array(
                'label'       => esc_html__('Blog Page Button Color','logitic'),
                'description' => esc_html__('Pic Color','logitic'),
                'section'     => 'logitic_style_setting',
                'settings'    => 'logitic_bloge_page_button_color',
            )
        )
    );
	//End  Blog Page Button Color

    //Start separator
    $logitic_customizer->add_setting(
        'style_hr_24', 
        array(
            'default'           => '',
            'sanitize_callback' => 'esc_html',
        )
    );
    $logitic_customizer->add_control(
        new logitic_Separator_Control(
            $logitic_customizer, 
            'style_hr_24', 
            array(
                'settings'      => 'style_hr_24',
                'section'       => 'logitic_style_setting',
            )
        )
    );
    //End separator

    //Start Blog Page Sidebar Bg Color
    $logitic_customizer->add_setting (
        'logitic_bloge_page_sidebar_bg_color',
    );
    $logitic_customizer->add_control(
        new WP_Customize_Color_Control(
            $logitic_customizer,
            'logitic_bloge_page_sidebar_bg_color',
            array(
                'label'       => esc_html__('Sidebar Bg Color','logitic'),
                'description' => esc_html__('Pic Color','logitic'),
                'section'     => 'logitic_style_setting',
                'settings'    => 'logitic_bloge_page_sidebar_bg_color',
            )
        )
    );
    //End  Blog Page Sidebar Bg Color
}