<?php
function logitic_breadcrumb_style_panel($logitic_customizer, $priority)
{
    $logitic_customizer->add_section('logitic_breadcrumb_style_setting', array(
        'title' => esc_html__('Breadcrumb Settings', 'logitic'),
        'priority' => $priority,
        'panel' => 'logitic_options_panel',
    ));

    //Start Hide
	$logitic_customizer->add_setting( 'logitic_page_hide_banner', 
	array(
		'default'    => 0,
		) 
	);
	$logitic_customizer->add_control(
		new logitic_Customize_Switch_Control(
			$logitic_customizer,
			'logitic_page_hide_banner',
			array(
				'type' => 'switch',
				'label' => esc_html__('Hide Banner','logitic'),
				'description' => esc_html__('You can show or hide ','logitic'),
				'section' => 'logitic_breadcrumb_style_setting'
			)
		)
	);
	//End Hide

    //Start separator
    $logitic_customizer->add_setting(
        'breadcrumb_hr_0',
        array(
            'default' => '',
            'sanitize_callback' => 'esc_html',
        )
    );
    $logitic_customizer->add_control(
        new logitic_Separator_Control(
            $logitic_customizer,
            'breadcrumb_hr_0',
            array(
                'settings' => 'breadcrumb_hr_0',
                'section' => 'logitic_breadcrumb_style_setting',
            )
        )
    );
    //End separator

    //Start Hide
	$logitic_customizer->add_setting( 'logitic_page_hide_breadcrumb', 
	array(
		'default'    => 0,
		) 
	);
	$logitic_customizer->add_control(
		new logitic_Customize_Switch_Control(
			$logitic_customizer,
			'logitic_page_hide_breadcrumb',
			array(
				'type' => 'switch',
				'label' => esc_html__('Show Breadcrumb','logitic'),
				'description' => esc_html__('You want to show breadcrumb click ON','logitic'),
				'section' => 'logitic_breadcrumb_style_setting'
			)
		)
	);
	//End Hide

    //Start separator
    $logitic_customizer->add_setting(
        'breadcrumb_hr_110',
        array(
            'default' => '',
            'sanitize_callback' => 'esc_html',
        )
    );
    $logitic_customizer->add_control(
        new logitic_Separator_Control(
            $logitic_customizer,
            'breadcrumb_hr_110',
            array(
                'settings' => 'breadcrumb_hr_110',
                'section' => 'logitic_breadcrumb_style_setting',
            )
        )
    );
    //End separator

    //Start Body Background Color
    $logitic_customizer->add_setting(
        'logitic_breadcrumb_bg_color'
    );
    $logitic_customizer->add_control(
        new WP_Customize_Color_Control(
            $logitic_customizer,
            'logitic_breadcrumb_bg_color',
            array(
                'label' => esc_html__('Backgroud Color', 'logitic'),
                'description' => esc_html__('Pick color', 'logitic'),
                'section' => 'logitic_breadcrumb_style_setting',
                'settings' => 'logitic_breadcrumb_bg_color',
            )
        )
    );
    //End Body Background Color

    //Start separator
    $logitic_customizer->add_setting(
        'breadcrumb_hr_1',
        array(
            'default' => '',
            'sanitize_callback' => 'esc_html',
        )
    );
    $logitic_customizer->add_control(
        new logitic_Separator_Control(
            $logitic_customizer,
            'breadcrumb_hr_1',
            array(
                'settings' => 'breadcrumb_hr_1',
                'section' => 'logitic_breadcrumb_style_setting',
            )
        )
    );
    //End separator

    //Start default Page Banner
	$logitic_customizer->add_setting(
		'logitic_page_banner', 
		array(
		'transport'		=> 'refresh'
		)
	);
	$logitic_customizer->add_control(
		new WP_Customize_Image_Control(
		$logitic_customizer,
		'logitic_page_banner',
			array(
			'label'      => esc_html__( 'Page Banner', 'logitic' ),
			'section'    => 'logitic_breadcrumb_style_setting',
			'settings'   => 'logitic_page_banner',
			)
		)   
	);
	//End default Page Banner

    //Start separator
    $logitic_customizer->add_setting(
        'breadcrumb_hr_2',
        array(
            'default' => '',
            'sanitize_callback' => 'esc_html',
        )
    );
    $logitic_customizer->add_control(
        new logitic_Separator_Control(
            $logitic_customizer,
            'breadcrumb_hr_2',
            array(
                'settings' => 'breadcrumb_hr_2',
                'section' => 'logitic_breadcrumb_style_setting',
            )
        )
    );
    //End separator

    //Start Blog Page Custom Title
	$logitic_customizer->add_setting(
		'logitic_page_custom_title',
		array(
			'transport'		=> 'refresh',
		)
	 );

	 $logitic_customizer->add_control('logitic_page_custom_title', array(
        'section'	=> 'logitic_breadcrumb_style_setting',
        'label'		=> esc_html__( 'Page Custom Title', 'logitic' ),
        'description' => esc_html__( 'Enter Page Title Here', 'logitic' ),
        'type'		=> 'text',
        'setting'	=> 'logitic_page_custom_title'
    ));
	//End Blog Page Custom Title

    //Start separator
    $logitic_customizer->add_setting(
        'breadcrumb_hr_3',
        array(
            'default' => '',
            'sanitize_callback' => 'esc_html',
        )
    );
    $logitic_customizer->add_control(
        new logitic_Separator_Control(
            $logitic_customizer,
            'breadcrumb_hr_3',
            array(
                'settings' => 'breadcrumb_hr_3',
                'section' => 'logitic_breadcrumb_style_setting',
            )
        )
    );
    //End separator

    //Start Blog Page Custom Description
	$logitic_customizer->add_setting(
		'logitic_page_custom_description',
		array(
			'transport'		=> 'refresh',
		)
	 );
	 $logitic_customizer->add_control('logitic_page_custom_description', array(
        'section'	=> 'logitic_breadcrumb_style_setting',
        'label'		=> esc_html__( 'Page Banner Description', 'logitic' ),
        'description' => esc_html__( 'Enter Page Description Here', 'logitic' ),
        'type'		=> 'textarea',
        'setting'	=> 'logitic_page_custom_description'
    ));
	//End Blog Page Custom Description

}
